"use strict";
var _a, _b, _c, _d, _e, _f, _g;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DatabaseInstanceEngine = exports.SqlServerEngineVersion = exports.OracleEngineVersion = exports.OracleLegacyEngineVersion = exports.PostgresEngineVersion = exports.MysqlEngineVersion = exports.MariaDbEngineVersion = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const secretsmanager = require("../../aws-secretsmanager");
const option_group_1 = require("./option-group");
class InstanceEngineBase {
    constructor(props) {
        this.engineType = props.engineType;
        this.features = props.features;
        this.singleUserRotationApplication = props.singleUserRotationApplication;
        this.multiUserRotationApplication = props.multiUserRotationApplication;
        this.engineVersion = props.version;
        this.parameterGroupFamily = props.parameterGroupFamily ??
            (this.engineVersion ? `${this.engineType}${this.engineVersion.majorVersion}` : undefined);
        this.engineFamily = props.engineFamily;
    }
    bindToInstance(_scope, options) {
        if (options.timezone && !this.supportsTimezone) {
            throw new Error(`timezone property can not be configured for ${this.engineType}`);
        }
        return {
            features: this.features,
            optionGroup: options.optionGroup,
        };
    }
    /** Defines whether this Instance Engine can support timezone properties. */
    get supportsTimezone() { return false; }
}
/**
 * The versions for the MariaDB instance engines
 * (those returned by `DatabaseInstanceEngine.mariaDb`).
 */
class MariaDbEngineVersion {
    /**
     * Create a new MariaDbEngineVersion with an arbitrary version.
     *
     * @param mariaDbFullVersion the full version string,
     *   for example "10.5.28"
     * @param mariaDbMajorVersion the major version of the engine,
     *   for example "10.5"
     */
    static of(mariaDbFullVersion, mariaDbMajorVersion) {
        return new MariaDbEngineVersion(mariaDbFullVersion, mariaDbMajorVersion);
    }
    constructor(mariaDbFullVersion, mariaDbMajorVersion) {
        this.mariaDbFullVersion = mariaDbFullVersion;
        this.mariaDbMajorVersion = mariaDbMajorVersion;
    }
}
_a = JSII_RTTI_SYMBOL_1;
MariaDbEngineVersion[_a] = { fqn: "aws-cdk-lib.aws_rds.MariaDbEngineVersion", version: "2.74.0" };
/**
 * Version "10.0" (only a major version, without a specific minor version).
 * @deprecated MariaDB 10.0 is no longer supported by Amazon RDS.
*/
MariaDbEngineVersion.VER_10_0 = MariaDbEngineVersion.of('10.0', '10.0');
/**
 * Version "10.0.17".
 * @deprecated MariaDB 10.0 is no longer supported by Amazon RDS.
*/
MariaDbEngineVersion.VER_10_0_17 = MariaDbEngineVersion.of('10.0.17', '10.0');
/**
 * Version "10.0.24".
 * @deprecated MariaDB 10.0 is no longer supported by Amazon RDS.
*/
MariaDbEngineVersion.VER_10_0_24 = MariaDbEngineVersion.of('10.0.24', '10.0');
/**
 * Version "10.0.28".
 * @deprecated MariaDB 10.0 is no longer supported by Amazon RDS.
*/
MariaDbEngineVersion.VER_10_0_28 = MariaDbEngineVersion.of('10.0.28', '10.0');
/**
 * Version "10.0.31".
 * @deprecated MariaDB 10.0 is no longer supported by Amazon RDS.
*/
MariaDbEngineVersion.VER_10_0_31 = MariaDbEngineVersion.of('10.0.31', '10.0');
/**
 * Version "10.0.32".
 * @deprecated MariaDB 10.0 is no longer supported by Amazon RDS.
*/
MariaDbEngineVersion.VER_10_0_32 = MariaDbEngineVersion.of('10.0.32', '10.0');
/**
 * Version "10.0.34".
 * @deprecated MariaDB 10.0 is no longer supported by Amazon RDS.
*/
MariaDbEngineVersion.VER_10_0_34 = MariaDbEngineVersion.of('10.0.34', '10.0');
/**
 * Version "10.0.35".
 * @deprecated MariaDB 10.0 is no longer supported by Amazon RDS.
*/
MariaDbEngineVersion.VER_10_0_35 = MariaDbEngineVersion.of('10.0.35', '10.0');
/**
 * Version "10.1" (only a major version, without a specific minor version).
 * @deprecated MariaDB 10.1 is no longer supported by Amazon RDS.
*/
MariaDbEngineVersion.VER_10_1 = MariaDbEngineVersion.of('10.1', '10.1');
/**
 * Version "10.1.14".
 * @deprecated MariaDB 10.1 is no longer supported by Amazon RDS.
*/
MariaDbEngineVersion.VER_10_1_14 = MariaDbEngineVersion.of('10.1.14', '10.1');
/**
 * Version "10.1.19".
 * @deprecated MariaDB 10.1 is no longer supported by Amazon RDS.
*/
MariaDbEngineVersion.VER_10_1_19 = MariaDbEngineVersion.of('10.1.19', '10.1');
/**
 * Version "10.1.23".
 * @deprecated MariaDB 10.1 is no longer supported by Amazon RDS.
*/
MariaDbEngineVersion.VER_10_1_23 = MariaDbEngineVersion.of('10.1.23', '10.1');
/**
 * Version "10.1.26".
 * @deprecated MariaDB 10.1 is no longer supported by Amazon RDS.
*/
MariaDbEngineVersion.VER_10_1_26 = MariaDbEngineVersion.of('10.1.26', '10.1');
/**
 * Version "10.1.31".
 * @deprecated MariaDB 10.1 is no longer supported by Amazon RDS.
*/
MariaDbEngineVersion.VER_10_1_31 = MariaDbEngineVersion.of('10.1.31', '10.1');
/**
 * Version "10.1.34".
 * @deprecated MariaDB 10.1 is no longer supported by Amazon RDS.
*/
MariaDbEngineVersion.VER_10_1_34 = MariaDbEngineVersion.of('10.1.34', '10.1');
/**
 * Version "10.2" (only a major version, without a specific minor version)
 * @deprecated MariaDB 10.2 is no longer supported by Amazon RDS.
 */
MariaDbEngineVersion.VER_10_2 = MariaDbEngineVersion.of('10.2', '10.2');
/**
 * Version "10.2.11".
 * @deprecated MariaDB 10.2 is no longer supported by Amazon RDS.
*/
MariaDbEngineVersion.VER_10_2_11 = MariaDbEngineVersion.of('10.2.11', '10.2');
/**
 * Version "10.2.12".
 * @deprecated MariaDB 10.2 is no longer supported by Amazon RDS.
 */
MariaDbEngineVersion.VER_10_2_12 = MariaDbEngineVersion.of('10.2.12', '10.2');
/**
 * Version "10.2.15".
 * @deprecated MariaDB 10.2 is no longer supported by Amazon RDS.
 */
MariaDbEngineVersion.VER_10_2_15 = MariaDbEngineVersion.of('10.2.15', '10.2');
/**
 * Version "10.2.21".
 * @deprecated MariaDB 10.2 is no longer supported by Amazon RDS.
*/
MariaDbEngineVersion.VER_10_2_21 = MariaDbEngineVersion.of('10.2.21', '10.2');
/**
 * Version "10.2.32".
 * @deprecated MariaDB 10.2 is no longer supported by Amazon RDS.
*/
MariaDbEngineVersion.VER_10_2_32 = MariaDbEngineVersion.of('10.2.32', '10.2');
/**
 * Version "10.2.37".
 * @deprecated MariaDB 10.2 is no longer supported by Amazon RDS.
*/
MariaDbEngineVersion.VER_10_2_37 = MariaDbEngineVersion.of('10.2.37', '10.2');
/**
 * Version "10.2.39".
 * @deprecated MariaDB 10.2 is no longer supported by Amazon RDS.
 */
MariaDbEngineVersion.VER_10_2_39 = MariaDbEngineVersion.of('10.2.39', '10.2');
/**
 * Version "10.2.40".
 * @deprecated MariaDB 10.2 is no longer supported by Amazon RDS.
 */
MariaDbEngineVersion.VER_10_2_40 = MariaDbEngineVersion.of('10.2.40', '10.2');
/**
 * Version "10.2.41".
 * @deprecated MariaDB 10.2 is no longer supported by Amazon RDS.
 */
MariaDbEngineVersion.VER_10_2_41 = MariaDbEngineVersion.of('10.2.41', '10.2');
/** Version "10.3" (only a major version, without a specific minor version). */
MariaDbEngineVersion.VER_10_3 = MariaDbEngineVersion.of('10.3', '10.3');
/** Version "10.3.8". */
MariaDbEngineVersion.VER_10_3_8 = MariaDbEngineVersion.of('10.3.8', '10.3');
/** Version "10.3.13". */
MariaDbEngineVersion.VER_10_3_13 = MariaDbEngineVersion.of('10.3.13', '10.3');
/** Version "10.3.20". */
MariaDbEngineVersion.VER_10_3_20 = MariaDbEngineVersion.of('10.3.20', '10.3');
/** Version "10.3.23". */
MariaDbEngineVersion.VER_10_3_23 = MariaDbEngineVersion.of('10.3.23', '10.3');
/** Version "10.3.28". */
MariaDbEngineVersion.VER_10_3_28 = MariaDbEngineVersion.of('10.3.28', '10.3');
/** Version "10.3.31". */
MariaDbEngineVersion.VER_10_3_31 = MariaDbEngineVersion.of('10.3.31', '10.3');
/** Version "10.3.32". */
MariaDbEngineVersion.VER_10_3_32 = MariaDbEngineVersion.of('10.3.32', '10.3');
/** Version "10.3.34". */
MariaDbEngineVersion.VER_10_3_34 = MariaDbEngineVersion.of('10.3.34', '10.3');
/** Version "10.3.35". */
MariaDbEngineVersion.VER_10_3_35 = MariaDbEngineVersion.of('10.3.35', '10.3');
/** Version "10.3.36". */
MariaDbEngineVersion.VER_10_3_36 = MariaDbEngineVersion.of('10.3.36', '10.3');
/** Version "10.3.37". */
MariaDbEngineVersion.VER_10_3_37 = MariaDbEngineVersion.of('10.3.37', '10.3');
/** Version "10.3.38". */
MariaDbEngineVersion.VER_10_3_38 = MariaDbEngineVersion.of('10.3.38', '10.3');
/** Version "10.4" (only a major version, without a specific minor version). */
MariaDbEngineVersion.VER_10_4 = MariaDbEngineVersion.of('10.4', '10.4');
/** Version "10.4.8". */
MariaDbEngineVersion.VER_10_4_8 = MariaDbEngineVersion.of('10.4.8', '10.4');
/** Version "10.4.13". */
MariaDbEngineVersion.VER_10_4_13 = MariaDbEngineVersion.of('10.4.13', '10.4');
/** Version "10.4.18". */
MariaDbEngineVersion.VER_10_4_18 = MariaDbEngineVersion.of('10.4.18', '10.4');
/** Version "10.4.21". */
MariaDbEngineVersion.VER_10_4_21 = MariaDbEngineVersion.of('10.4.21', '10.4');
/** Version "10.4.22". */
MariaDbEngineVersion.VER_10_4_22 = MariaDbEngineVersion.of('10.4.22', '10.4');
/** Version "10.4.24". */
MariaDbEngineVersion.VER_10_4_24 = MariaDbEngineVersion.of('10.4.24', '10.4');
/** Version "10.4.25". */
MariaDbEngineVersion.VER_10_4_25 = MariaDbEngineVersion.of('10.4.25', '10.4');
/** Version "10.4.26". */
MariaDbEngineVersion.VER_10_4_26 = MariaDbEngineVersion.of('10.4.26', '10.4');
/** Version "10.4.27". */
MariaDbEngineVersion.VER_10_4_27 = MariaDbEngineVersion.of('10.4.27', '10.4');
/** Version "10.4.28". */
MariaDbEngineVersion.VER_10_4_28 = MariaDbEngineVersion.of('10.4.28', '10.4');
/** Version "10.5" (only a major version, without a specific minor version). */
MariaDbEngineVersion.VER_10_5 = MariaDbEngineVersion.of('10.5', '10.5');
/** Version "10.5.8". */
MariaDbEngineVersion.VER_10_5_8 = MariaDbEngineVersion.of('10.5.8', '10.5');
/** Version "10.5.9". */
MariaDbEngineVersion.VER_10_5_9 = MariaDbEngineVersion.of('10.5.9', '10.5');
/** Version "10.5.12". */
MariaDbEngineVersion.VER_10_5_12 = MariaDbEngineVersion.of('10.5.12', '10.5');
/** Version "10.5.13". */
MariaDbEngineVersion.VER_10_5_13 = MariaDbEngineVersion.of('10.5.13', '10.5');
/** Version "10.5.15". */
MariaDbEngineVersion.VER_10_5_15 = MariaDbEngineVersion.of('10.5.15', '10.5');
/** Version "10.5.16". */
MariaDbEngineVersion.VER_10_5_16 = MariaDbEngineVersion.of('10.5.16', '10.5');
/** Version "10.5.17". */
MariaDbEngineVersion.VER_10_5_17 = MariaDbEngineVersion.of('10.5.17', '10.5');
/** Version "10.5.18". */
MariaDbEngineVersion.VER_10_5_18 = MariaDbEngineVersion.of('10.5.18', '10.5');
/** Version "10.5.19". */
MariaDbEngineVersion.VER_10_5_19 = MariaDbEngineVersion.of('10.5.19', '10.5');
/** Version "10.6" (only a major version, without a specific minor version). */
MariaDbEngineVersion.VER_10_6 = MariaDbEngineVersion.of('10.6', '10.6');
/** Version "10.6.5". */
MariaDbEngineVersion.VER_10_6_5 = MariaDbEngineVersion.of('10.6.5', '10.6');
/** Version "10.6.7". */
MariaDbEngineVersion.VER_10_6_7 = MariaDbEngineVersion.of('10.6.7', '10.6');
/** Version "10.6.8". */
MariaDbEngineVersion.VER_10_6_8 = MariaDbEngineVersion.of('10.6.8', '10.6');
/** Version "10.6.10". */
MariaDbEngineVersion.VER_10_6_10 = MariaDbEngineVersion.of('10.6.10', '10.6');
/** Version "10.6.11". */
MariaDbEngineVersion.VER_10_6_11 = MariaDbEngineVersion.of('10.6.11', '10.6');
/** Version "10.6.12". */
MariaDbEngineVersion.VER_10_6_12 = MariaDbEngineVersion.of('10.6.12', '10.6');
exports.MariaDbEngineVersion = MariaDbEngineVersion;
class MariaDbInstanceEngine extends InstanceEngineBase {
    constructor(version) {
        super({
            engineType: 'mariadb',
            singleUserRotationApplication: secretsmanager.SecretRotationApplication.MARIADB_ROTATION_SINGLE_USER,
            multiUserRotationApplication: secretsmanager.SecretRotationApplication.MARIADB_ROTATION_MULTI_USER,
            version: version
                ? {
                    fullVersion: version.mariaDbFullVersion,
                    majorVersion: version.mariaDbMajorVersion,
                }
                : undefined,
        });
        this.supportsReadReplicaBackups = true;
    }
    bindToInstance(scope, options) {
        if (options.domain) {
            throw new Error(`domain property cannot be configured for ${this.engineType}`);
        }
        return super.bindToInstance(scope, options);
    }
}
/**
 * The versions for the MySQL instance engines
 * (those returned by `DatabaseInstanceEngine.mysql`).
 */
class MysqlEngineVersion {
    /**
     * Create a new MysqlEngineVersion with an arbitrary version.
     *
     * @param mysqlFullVersion the full version string,
     *   for example "8.1.43"
     * @param mysqlMajorVersion the major version of the engine,
     *   for example "8.1"
     */
    static of(mysqlFullVersion, mysqlMajorVersion) {
        return new MysqlEngineVersion(mysqlFullVersion, mysqlMajorVersion);
    }
    constructor(mysqlFullVersion, mysqlMajorVersion) {
        this.mysqlFullVersion = mysqlFullVersion;
        this.mysqlMajorVersion = mysqlMajorVersion;
    }
}
_b = JSII_RTTI_SYMBOL_1;
MysqlEngineVersion[_b] = { fqn: "aws-cdk-lib.aws_rds.MysqlEngineVersion", version: "2.74.0" };
/**
 * Version "5.5" (only a major version, without a specific minor version).
 * @deprecated MySQL 5.5 is no longer supported by Amazon RDS.
*/
MysqlEngineVersion.VER_5_5 = MysqlEngineVersion.of('5.5', '5.5');
/**
 * Version "5.5.46".
 * @deprecated MySQL 5.5 is no longer supported by Amazon RDS.
*/
MysqlEngineVersion.VER_5_5_46 = MysqlEngineVersion.of('5.5.46', '5.5');
/**
 * Version "5.5.53".
 * @deprecated MySQL 5.5 is no longer supported by Amazon RDS.
*/
MysqlEngineVersion.VER_5_5_53 = MysqlEngineVersion.of('5.5.53', '5.5');
/**
 * Version "5.5.57".
 * @deprecated MySQL 5.5 is no longer supported by Amazon RDS.
*/
MysqlEngineVersion.VER_5_5_57 = MysqlEngineVersion.of('5.5.57', '5.5');
/**
 * Version "5.5.59".
 * @deprecated MySQL 5.5 is no longer supported by Amazon RDS.
*/
MysqlEngineVersion.VER_5_5_59 = MysqlEngineVersion.of('5.5.59', '5.5');
/**
 * Version "5.5.61".
 * @deprecated MySQL 5.5 is no longer supported by Amazon RDS.
*/
MysqlEngineVersion.VER_5_5_61 = MysqlEngineVersion.of('5.5.61', '5.5');
/**
 * Version "5.6" (only a major version, without a specific minor version).
 * @deprecated MySQL 5.6 is no longer supported by Amazon RDS.
*/
MysqlEngineVersion.VER_5_6 = MysqlEngineVersion.of('5.6', '5.6');
/**
 * Version "5.6.34".
 * @deprecated MySQL 5.6 is no longer supported by Amazon RDS.
*/
MysqlEngineVersion.VER_5_6_34 = MysqlEngineVersion.of('5.6.34', '5.6');
/**
 * Version "5.6.35".
 * @deprecated MySQL 5.6 is no longer supported by Amazon RDS.
*/
MysqlEngineVersion.VER_5_6_35 = MysqlEngineVersion.of('5.6.35', '5.6');
/**
 * Version "5.6.37".
 * @deprecated MySQL 5.6 is no longer supported by Amazon RDS.
*/
MysqlEngineVersion.VER_5_6_37 = MysqlEngineVersion.of('5.6.37', '5.6');
/**
 * Version "5.6.39".
 * @deprecated MySQL 5.6 is no longer supported by Amazon RDS.
*/
MysqlEngineVersion.VER_5_6_39 = MysqlEngineVersion.of('5.6.39', '5.6');
/**
 * Version "5.6.40".
 * @deprecated MySQL 5.6 is no longer supported by Amazon RDS.
*/
MysqlEngineVersion.VER_5_6_40 = MysqlEngineVersion.of('5.6.40', '5.6');
/**
 * Version "5.6.41".
 * @deprecated MySQL 5.6 is no longer supported by Amazon RDS.
*/
MysqlEngineVersion.VER_5_6_41 = MysqlEngineVersion.of('5.6.41', '5.6');
/**
 * Version "5.6.43".
 * @deprecated MySQL 5.6 is no longer supported by Amazon RDS.
*/
MysqlEngineVersion.VER_5_6_43 = MysqlEngineVersion.of('5.6.43', '5.6');
/**
 * Version "5.6.44".
 * @deprecated MySQL 5.6 is no longer supported by Amazon RDS.
*/
MysqlEngineVersion.VER_5_6_44 = MysqlEngineVersion.of('5.6.44', '5.6');
/**
 * Version "5.6.46".
 * @deprecated MySQL 5.6 is no longer supported by Amazon RDS.
*/
MysqlEngineVersion.VER_5_6_46 = MysqlEngineVersion.of('5.6.46', '5.6');
/**
 * Version "5.6.48".
 * @deprecated MySQL 5.6 is no longer supported by Amazon RDS.
*/
MysqlEngineVersion.VER_5_6_48 = MysqlEngineVersion.of('5.6.48', '5.6');
/**
 * Version "5.6.49".
 * @deprecated MySQL 5.6 is no longer supported by Amazon RDS.
*/
MysqlEngineVersion.VER_5_6_49 = MysqlEngineVersion.of('5.6.49', '5.6');
/**
 * Version "5.6.51".
 * @deprecated MySQL 5.6 is no longer supported by Amazon RDS.
*/
MysqlEngineVersion.VER_5_6_51 = MysqlEngineVersion.of('5.6.51', '5.6');
/** Version "5.7" (only a major version, without a specific minor version). */
MysqlEngineVersion.VER_5_7 = MysqlEngineVersion.of('5.7', '5.7');
/** Version "5.7.16". */
MysqlEngineVersion.VER_5_7_16 = MysqlEngineVersion.of('5.7.16', '5.7');
/** Version "5.7.17". */
MysqlEngineVersion.VER_5_7_17 = MysqlEngineVersion.of('5.7.17', '5.7');
/** Version "5.7.19". */
MysqlEngineVersion.VER_5_7_19 = MysqlEngineVersion.of('5.7.19', '5.7');
/** Version "5.7.21". */
MysqlEngineVersion.VER_5_7_21 = MysqlEngineVersion.of('5.7.21', '5.7');
/** Version "5.7.22". */
MysqlEngineVersion.VER_5_7_22 = MysqlEngineVersion.of('5.7.22', '5.7');
/** Version "5.7.23". */
MysqlEngineVersion.VER_5_7_23 = MysqlEngineVersion.of('5.7.23', '5.7');
/** Version "5.7.24". */
MysqlEngineVersion.VER_5_7_24 = MysqlEngineVersion.of('5.7.24', '5.7');
/** Version "5.7.25". */
MysqlEngineVersion.VER_5_7_25 = MysqlEngineVersion.of('5.7.25', '5.7');
/** Version "5.7.26". */
MysqlEngineVersion.VER_5_7_26 = MysqlEngineVersion.of('5.7.26', '5.7');
/** Version "5.7.28". */
MysqlEngineVersion.VER_5_7_28 = MysqlEngineVersion.of('5.7.28', '5.7');
/** Version "5.7.30". */
MysqlEngineVersion.VER_5_7_30 = MysqlEngineVersion.of('5.7.30', '5.7');
/** Version "5.7.31". */
MysqlEngineVersion.VER_5_7_31 = MysqlEngineVersion.of('5.7.31', '5.7');
/** Version "5.7.33". */
MysqlEngineVersion.VER_5_7_33 = MysqlEngineVersion.of('5.7.33', '5.7');
/** Version "5.7.34". */
MysqlEngineVersion.VER_5_7_34 = MysqlEngineVersion.of('5.7.34', '5.7');
/** Version "5.7.35". */
MysqlEngineVersion.VER_5_7_35 = MysqlEngineVersion.of('5.7.35', '5.7');
/** Version "5.7.36". */
MysqlEngineVersion.VER_5_7_36 = MysqlEngineVersion.of('5.7.36', '5.7');
/** Version "5.7.37". */
MysqlEngineVersion.VER_5_7_37 = MysqlEngineVersion.of('5.7.37', '5.7');
/** Version "5.7.38". */
MysqlEngineVersion.VER_5_7_38 = MysqlEngineVersion.of('5.7.38', '5.7');
/** Version "5.7.39". */
MysqlEngineVersion.VER_5_7_39 = MysqlEngineVersion.of('5.7.39', '5.7');
/** Version "5.7.40". */
MysqlEngineVersion.VER_5_7_40 = MysqlEngineVersion.of('5.7.40', '5.7');
/** Version "5.7.41". */
MysqlEngineVersion.VER_5_7_41 = MysqlEngineVersion.of('5.7.41', '5.7');
/** Version "8.0" (only a major version, without a specific minor version). */
MysqlEngineVersion.VER_8_0 = MysqlEngineVersion.of('8.0', '8.0');
/** Version "8.0.11". */
MysqlEngineVersion.VER_8_0_11 = MysqlEngineVersion.of('8.0.11', '8.0');
/** Version "8.0.13". */
MysqlEngineVersion.VER_8_0_13 = MysqlEngineVersion.of('8.0.13', '8.0');
/** Version "8.0.15". */
MysqlEngineVersion.VER_8_0_15 = MysqlEngineVersion.of('8.0.15', '8.0');
/** Version "8.0.16". */
MysqlEngineVersion.VER_8_0_16 = MysqlEngineVersion.of('8.0.16', '8.0');
/** Version "8.0.17". */
MysqlEngineVersion.VER_8_0_17 = MysqlEngineVersion.of('8.0.17', '8.0');
/** Version "8.0.19". */
MysqlEngineVersion.VER_8_0_19 = MysqlEngineVersion.of('8.0.19', '8.0');
/** Version "8.0.20 ". */
MysqlEngineVersion.VER_8_0_20 = MysqlEngineVersion.of('8.0.20', '8.0');
/** Version "8.0.21 ". */
MysqlEngineVersion.VER_8_0_21 = MysqlEngineVersion.of('8.0.21', '8.0');
/** Version "8.0.23". */
MysqlEngineVersion.VER_8_0_23 = MysqlEngineVersion.of('8.0.23', '8.0');
/** Version "8.0.25". */
MysqlEngineVersion.VER_8_0_25 = MysqlEngineVersion.of('8.0.25', '8.0');
/** Version "8.0.26". */
MysqlEngineVersion.VER_8_0_26 = MysqlEngineVersion.of('8.0.26', '8.0');
/** Version "8.0.27". */
MysqlEngineVersion.VER_8_0_27 = MysqlEngineVersion.of('8.0.27', '8.0');
/** Version "8.0.28". */
MysqlEngineVersion.VER_8_0_28 = MysqlEngineVersion.of('8.0.28', '8.0');
/** Version "8.0.30". */
MysqlEngineVersion.VER_8_0_30 = MysqlEngineVersion.of('8.0.30', '8.0');
/** Version "8.0.31". */
MysqlEngineVersion.VER_8_0_31 = MysqlEngineVersion.of('8.0.31', '8.0');
/** Version "8.0.32". */
MysqlEngineVersion.VER_8_0_32 = MysqlEngineVersion.of('8.0.32', '8.0');
exports.MysqlEngineVersion = MysqlEngineVersion;
class MySqlInstanceEngine extends InstanceEngineBase {
    constructor(version) {
        super({
            engineType: 'mysql',
            singleUserRotationApplication: secretsmanager.SecretRotationApplication.MYSQL_ROTATION_SINGLE_USER,
            multiUserRotationApplication: secretsmanager.SecretRotationApplication.MYSQL_ROTATION_MULTI_USER,
            version: version
                ? {
                    fullVersion: version.mysqlFullVersion,
                    majorVersion: version.mysqlMajorVersion,
                }
                : undefined,
            engineFamily: 'MYSQL',
        });
        this.supportsReadReplicaBackups = true;
    }
}
/**
 * The versions for the PostgreSQL instance engines
 * (those returned by `DatabaseInstanceEngine.postgres`).
 */
class PostgresEngineVersion {
    /**
     * Create a new PostgresEngineVersion with an arbitrary version.
     *
     * @param postgresFullVersion the full version string,
     *   for example "13.11"
     * @param postgresMajorVersion the major version of the engine,
     *   for example "13"
     */
    static of(postgresFullVersion, postgresMajorVersion, postgresFeatures) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_PostgresEngineFeatures(postgresFeatures);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.of);
            }
            throw error;
        }
        return new PostgresEngineVersion(postgresFullVersion, postgresMajorVersion, postgresFeatures);
    }
    constructor(postgresFullVersion, postgresMajorVersion, postgresFeatures) {
        this.postgresFullVersion = postgresFullVersion;
        this.postgresMajorVersion = postgresMajorVersion;
        this._features = {
            s3Import: postgresFeatures?.s3Import ? 's3Import' : undefined,
            s3Export: postgresFeatures?.s3Export ? 's3Export' : undefined,
        };
    }
}
_c = JSII_RTTI_SYMBOL_1;
PostgresEngineVersion[_c] = { fqn: "aws-cdk-lib.aws_rds.PostgresEngineVersion", version: "2.74.0" };
/**
 * Version "9.5" (only a major version, without a specific minor version).
 * @deprecated PostgreSQL 9.5 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_5 = PostgresEngineVersion.of('9.5', '9.5');
/**
 * Version "9.5.2".
 * @deprecated PostgreSQL 9.5 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_5_2 = PostgresEngineVersion.of('9.5.2', '9.5');
/**
 * Version "9.5.4".
 * @deprecated PostgreSQL 9.5 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_5_4 = PostgresEngineVersion.of('9.5.4', '9.5');
/**
 * Version "9.5.6".
 * @deprecated PostgreSQL 9.5 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_5_6 = PostgresEngineVersion.of('9.5.6', '9.5');
/**
 * Version "9.5.7".
 * @deprecated PostgreSQL 9.5 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_5_7 = PostgresEngineVersion.of('9.5.7', '9.5');
/**
 * Version "9.5.9".
 * @deprecated PostgreSQL 9.5 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_5_9 = PostgresEngineVersion.of('9.5.9', '9.5');
/**
 * Version "9.5.10".
 * @deprecated PostgreSQL 9.5 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_5_10 = PostgresEngineVersion.of('9.5.10', '9.5');
/**
 * Version "9.5.12".
 * @deprecated PostgreSQL 9.5 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_5_12 = PostgresEngineVersion.of('9.5.12', '9.5');
/**
 * Version "9.5.13".
 * @deprecated PostgreSQL 9.5 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_5_13 = PostgresEngineVersion.of('9.5.13', '9.5');
/**
 * Version "9.5.14".
 * @deprecated PostgreSQL 9.5 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_5_14 = PostgresEngineVersion.of('9.5.14', '9.5');
/**
 * Version "9.5.15".
 * @deprecated PostgreSQL 9.5 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_5_15 = PostgresEngineVersion.of('9.5.15', '9.5');
/**
 * Version "9.5.16".
 * @deprecated PostgreSQL 9.5 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_5_16 = PostgresEngineVersion.of('9.5.16', '9.5');
/**
 * Version "9.5.18".
 * @deprecated PostgreSQL 9.5 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_5_18 = PostgresEngineVersion.of('9.5.18', '9.5');
/**
 * Version "9.5.19".
 * @deprecated PostgreSQL 9.5 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_5_19 = PostgresEngineVersion.of('9.5.19', '9.5');
/**
 * Version "9.5.20".
 * @deprecated PostgreSQL 9.5 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_5_20 = PostgresEngineVersion.of('9.5.20', '9.5');
/**
 * Version "9.5.21".
 * @deprecated PostgreSQL 9.5 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_5_21 = PostgresEngineVersion.of('9.5.21', '9.5');
/**
 * Version "9.5.22".
 * @deprecated PostgreSQL 9.5 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_5_22 = PostgresEngineVersion.of('9.5.22', '9.5');
/**
 * Version "9.5.23".
 * @deprecated PostgreSQL 9.5 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_5_23 = PostgresEngineVersion.of('9.5.23', '9.5');
/**
 * Version "9.5.24".
 * @deprecated PostgreSQL 9.5 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_5_24 = PostgresEngineVersion.of('9.5.24', '9.5');
/**
 * Version "9.5.25".
 * @deprecated PostgreSQL 9.5 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_5_25 = PostgresEngineVersion.of('9.5.25', '9.5');
/**
 * Version "9.6" (only a major version, without a specific minor version).
 * @deprecated PostgreSQL 9.6 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_6 = PostgresEngineVersion.of('9.6', '9.6');
/**
 * Version "9.6.1".
 * @deprecated PostgreSQL 9.6 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_6_1 = PostgresEngineVersion.of('9.6.1', '9.6');
/**
 * Version "9.6.2".
 * @deprecated PostgreSQL 9.6 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_6_2 = PostgresEngineVersion.of('9.6.2', '9.6');
/**
 * Version "9.6.3".
 * @deprecated PostgreSQL 9.6 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_6_3 = PostgresEngineVersion.of('9.6.3', '9.6');
/**
 * Version "9.6.5".
 * @deprecated PostgreSQL 9.6 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_6_5 = PostgresEngineVersion.of('9.6.5', '9.6');
/**
 * Version "9.6.6".
 * @deprecated PostgreSQL 9.6 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_6_6 = PostgresEngineVersion.of('9.6.6', '9.6');
/**
 * Version "9.6.8".
 * @deprecated PostgreSQL 9.6 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_6_8 = PostgresEngineVersion.of('9.6.8', '9.6');
/**
 * Version "9.6.9".
 * @deprecated PostgreSQL 9.6 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_6_9 = PostgresEngineVersion.of('9.6.9', '9.6');
/**
 * Version "9.6.10".
 * @deprecated PostgreSQL 9.6 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_6_10 = PostgresEngineVersion.of('9.6.10', '9.6');
/**
 * Version "9.6.11".
 * @deprecated PostgreSQL 9.6 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_6_11 = PostgresEngineVersion.of('9.6.11', '9.6');
/**
 * Version "9.6.12".
 * @deprecated PostgreSQL 9.6 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_6_12 = PostgresEngineVersion.of('9.6.12', '9.6');
/**
 * Version "9.6.14".
 * @deprecated PostgreSQL 9.6 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_6_14 = PostgresEngineVersion.of('9.6.14', '9.6');
/**
 * Version "9.6.15".
 * @deprecated PostgreSQL 9.6 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_6_15 = PostgresEngineVersion.of('9.6.15', '9.6');
/**
 * Version "9.6.16".
 * @deprecated PostgreSQL 9.6 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_6_16 = PostgresEngineVersion.of('9.6.16', '9.6');
/**
 * Version "9.6.17".
 * @deprecated PostgreSQL 9.6 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_6_17 = PostgresEngineVersion.of('9.6.17', '9.6');
/**
 * Version "9.6.18".
 * @deprecated PostgreSQL 9.6 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_6_18 = PostgresEngineVersion.of('9.6.18', '9.6');
/**
 * Version "9.6.19".
 * @deprecated PostgreSQL 9.6 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_6_19 = PostgresEngineVersion.of('9.6.19', '9.6');
/**
 * Version "9.6.20".
 * @deprecated PostgreSQL 9.6 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_6_20 = PostgresEngineVersion.of('9.6.20', '9.6');
/**
 * Version "9.6.21".
 * @deprecated PostgreSQL 9.6 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_6_21 = PostgresEngineVersion.of('9.6.21', '9.6');
/**
 * Version "9.6.22".
 * @deprecated PostgreSQL 9.6 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_6_22 = PostgresEngineVersion.of('9.6.22', '9.6');
/**
 * Version "9.6.23".
 * @deprecated PostgreSQL 9.6 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_6_23 = PostgresEngineVersion.of('9.6.23', '9.6');
/**
 * Version "9.6.24".
 * @deprecated PostgreSQL 9.6 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_9_6_24 = PostgresEngineVersion.of('9.6.24', '9.6');
/**
 * Version "10" (only a major version, without a specific minor version).
 * @deprecated PostgreSQL 10 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_10 = PostgresEngineVersion.of('10', '10');
/**
 * Version "10.1".
 * @deprecated PostgreSQL 10 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_10_1 = PostgresEngineVersion.of('10.1', '10');
/**
 * Version "10.3".
 * @deprecated PostgreSQL 10.3 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_10_3 = PostgresEngineVersion.of('10.3', '10');
/**
 * Version "10.4".
 * @deprecated PostgreSQL 10.4 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_10_4 = PostgresEngineVersion.of('10.4', '10');
/**
 * Version "10.5".
 * @deprecated PostgreSQL 10.5 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_10_5 = PostgresEngineVersion.of('10.5', '10');
/**
 * Version "10.6".
 * @deprecated PostgreSQL 10.6 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_10_6 = PostgresEngineVersion.of('10.6', '10');
/**
 * Version "10.7".
 * @deprecated PostgreSQL 10.7 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_10_7 = PostgresEngineVersion.of('10.7', '10', { s3Import: true });
/**
 * Version "10.9".
 * @deprecated PostgreSQL 10.9 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_10_9 = PostgresEngineVersion.of('10.9', '10', { s3Import: true });
/**
 * Version "10.10".
 * @deprecated PostgreSQL 10.10 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_10_10 = PostgresEngineVersion.of('10.10', '10', { s3Import: true });
/**
 * Version "10.11".
 * @deprecated PostgreSQL 10.11 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_10_11 = PostgresEngineVersion.of('10.11', '10', { s3Import: true });
/**
 * Version "10.12".
 * @deprecated PostgreSQL 10.12 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_10_12 = PostgresEngineVersion.of('10.12', '10', { s3Import: true });
/**
 * Version "10.13".
 * @deprecated PostgreSQL 10.13 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_10_13 = PostgresEngineVersion.of('10.13', '10', { s3Import: true });
/**
 * Version "10.14".
 * @deprecated PostgreSQL 10.14 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_10_14 = PostgresEngineVersion.of('10.14', '10', { s3Import: true, s3Export: true });
/**
 * Version "10.15".
 * @deprecated PostgreSQL 10.15 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_10_15 = PostgresEngineVersion.of('10.15', '10', { s3Import: true, s3Export: true });
/**
 * Version "10.16".
 * @deprecated PostgreSQL 10.16 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_10_16 = PostgresEngineVersion.of('10.16', '10', { s3Import: true, s3Export: true });
/**
 * Version "10.17".
 * @deprecated PostgreSQL 10.17 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_10_17 = PostgresEngineVersion.of('10.17', '10', { s3Import: true, s3Export: true });
/**
 * Version "10.18".
 * @deprecated PostgreSQL 10.18 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_10_18 = PostgresEngineVersion.of('10.18', '10', { s3Import: true, s3Export: true });
/**
 * Version "10.19".
 * @deprecated PostgreSQL 10.19 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_10_19 = PostgresEngineVersion.of('10.19', '10', { s3Import: true, s3Export: true });
/**
 * Version "10.20".
 * @deprecated PostgreSQL 10.20 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_10_20 = PostgresEngineVersion.of('10.20', '10', { s3Import: true, s3Export: true });
/**
 * Version "10.21".
 * @deprecated PostgreSQL 10.21 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_10_21 = PostgresEngineVersion.of('10.21', '10', { s3Import: true, s3Export: true });
/**
 * Version "10.22".
 * @deprecated PostgreSQL 10.22 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_10_22 = PostgresEngineVersion.of('10.22', '10', { s3Import: true, s3Export: true });
/**
 * Version "10.23".
 * @deprecated PostgreSQL 10.23 is no longer supported by Amazon RDS.
*/
PostgresEngineVersion.VER_10_23 = PostgresEngineVersion.of('10.23', '10', { s3Import: true, s3Export: true });
/** Version "11" (only a major version, without a specific minor version). */
PostgresEngineVersion.VER_11 = PostgresEngineVersion.of('11', '11', { s3Import: true });
/** Version "11.1". */
PostgresEngineVersion.VER_11_1 = PostgresEngineVersion.of('11.1', '11', { s3Import: true });
/** Version "11.2". */
PostgresEngineVersion.VER_11_2 = PostgresEngineVersion.of('11.2', '11', { s3Import: true });
/** Version "11.4". */
PostgresEngineVersion.VER_11_4 = PostgresEngineVersion.of('11.4', '11', { s3Import: true });
/** Version "11.5". */
PostgresEngineVersion.VER_11_5 = PostgresEngineVersion.of('11.5', '11', { s3Import: true });
/** Version "11.6". */
PostgresEngineVersion.VER_11_6 = PostgresEngineVersion.of('11.6', '11', { s3Import: true });
/** Version "11.7". */
PostgresEngineVersion.VER_11_7 = PostgresEngineVersion.of('11.7', '11', { s3Import: true });
/** Version "11.8". */
PostgresEngineVersion.VER_11_8 = PostgresEngineVersion.of('11.8', '11', { s3Import: true });
/** Version "11.9". */
PostgresEngineVersion.VER_11_9 = PostgresEngineVersion.of('11.9', '11', { s3Import: true, s3Export: true });
/** Version "11.10". */
PostgresEngineVersion.VER_11_10 = PostgresEngineVersion.of('11.10', '11', { s3Import: true, s3Export: true });
/** Version "11.11". */
PostgresEngineVersion.VER_11_11 = PostgresEngineVersion.of('11.11', '11', { s3Import: true, s3Export: true });
/** Version "11.12". */
PostgresEngineVersion.VER_11_12 = PostgresEngineVersion.of('11.12', '11', { s3Import: true, s3Export: true });
/** Version "11.13". */
PostgresEngineVersion.VER_11_13 = PostgresEngineVersion.of('11.13', '11', { s3Import: true, s3Export: true });
/** Version "11.14". */
PostgresEngineVersion.VER_11_14 = PostgresEngineVersion.of('11.14', '11', { s3Import: true, s3Export: true });
/** Version "11.15". */
PostgresEngineVersion.VER_11_15 = PostgresEngineVersion.of('11.15', '11', { s3Import: true, s3Export: true });
/** Version "11.16". */
PostgresEngineVersion.VER_11_16 = PostgresEngineVersion.of('11.16', '11', { s3Import: true, s3Export: true });
/** Version "11.17". */
PostgresEngineVersion.VER_11_17 = PostgresEngineVersion.of('11.17', '11', { s3Import: true, s3Export: true });
/** Version "11.18". */
PostgresEngineVersion.VER_11_18 = PostgresEngineVersion.of('11.18', '11', { s3Import: true, s3Export: true });
/** Version "11.19". */
PostgresEngineVersion.VER_11_19 = PostgresEngineVersion.of('11.19', '11', { s3Import: true, s3Export: true });
/** Version "12" (only a major version, without a specific minor version). */
PostgresEngineVersion.VER_12 = PostgresEngineVersion.of('12', '12', { s3Import: true });
/** Version "12.2". */
PostgresEngineVersion.VER_12_2 = PostgresEngineVersion.of('12.2', '12', { s3Import: true });
/** Version "12.3". */
PostgresEngineVersion.VER_12_3 = PostgresEngineVersion.of('12.3', '12', { s3Import: true });
/** Version "12.4". */
PostgresEngineVersion.VER_12_4 = PostgresEngineVersion.of('12.4', '12', { s3Import: true, s3Export: true });
/** Version "12.5". */
PostgresEngineVersion.VER_12_5 = PostgresEngineVersion.of('12.5', '12', { s3Import: true, s3Export: true });
/** Version "12.6". */
PostgresEngineVersion.VER_12_6 = PostgresEngineVersion.of('12.6', '12', { s3Import: true, s3Export: true });
/** Version "12.7". */
PostgresEngineVersion.VER_12_7 = PostgresEngineVersion.of('12.7', '12', { s3Import: true, s3Export: true });
/** Version "12.8". */
PostgresEngineVersion.VER_12_8 = PostgresEngineVersion.of('12.8', '12', { s3Import: true, s3Export: true });
/** Version "12.9". */
PostgresEngineVersion.VER_12_9 = PostgresEngineVersion.of('12.9', '12', { s3Import: true, s3Export: true });
/** Version "12.10". */
PostgresEngineVersion.VER_12_10 = PostgresEngineVersion.of('12.10', '12', { s3Import: true, s3Export: true });
/** Version "12.11". */
PostgresEngineVersion.VER_12_11 = PostgresEngineVersion.of('12.11', '12', { s3Import: true, s3Export: true });
/** Version "12.12". */
PostgresEngineVersion.VER_12_12 = PostgresEngineVersion.of('12.12', '12', { s3Import: true, s3Export: true });
/** Version "12.13". */
PostgresEngineVersion.VER_12_13 = PostgresEngineVersion.of('12.13', '12', { s3Import: true, s3Export: true });
/** Version "12.14". */
PostgresEngineVersion.VER_12_14 = PostgresEngineVersion.of('12.14', '12', { s3Import: true, s3Export: true });
/** Version "13" (only a major version, without a specific minor version). */
PostgresEngineVersion.VER_13 = PostgresEngineVersion.of('13', '13', { s3Import: true, s3Export: true });
/** Version "13.1". */
PostgresEngineVersion.VER_13_1 = PostgresEngineVersion.of('13.1', '13', { s3Import: true, s3Export: true });
/** Version "13.2". */
PostgresEngineVersion.VER_13_2 = PostgresEngineVersion.of('13.2', '13', { s3Import: true, s3Export: true });
/** Version "13.3". */
PostgresEngineVersion.VER_13_3 = PostgresEngineVersion.of('13.3', '13', { s3Import: true, s3Export: true });
/** Version "13.4". */
PostgresEngineVersion.VER_13_4 = PostgresEngineVersion.of('13.4', '13', { s3Import: true, s3Export: true });
/** Version "13.5". */
PostgresEngineVersion.VER_13_5 = PostgresEngineVersion.of('13.5', '13', { s3Import: true, s3Export: true });
/** Version "13.6". */
PostgresEngineVersion.VER_13_6 = PostgresEngineVersion.of('13.6', '13', { s3Import: true, s3Export: true });
/** Version "13.7". */
PostgresEngineVersion.VER_13_7 = PostgresEngineVersion.of('13.7', '13', { s3Import: true, s3Export: true });
/** Version "13.8". */
PostgresEngineVersion.VER_13_8 = PostgresEngineVersion.of('13.8', '13', { s3Import: true, s3Export: true });
/** Version "13.9". */
PostgresEngineVersion.VER_13_9 = PostgresEngineVersion.of('13.9', '13', { s3Import: true, s3Export: true });
/** Version "13.10". */
PostgresEngineVersion.VER_13_10 = PostgresEngineVersion.of('13.10', '13', { s3Import: true, s3Export: true });
/** Version "14" (only a major version, without a specific minor version). */
PostgresEngineVersion.VER_14 = PostgresEngineVersion.of('14', '14', { s3Import: true, s3Export: true });
/** Version "14.1". */
PostgresEngineVersion.VER_14_1 = PostgresEngineVersion.of('14.1', '14', { s3Import: true, s3Export: true });
/** Version "14.2". */
PostgresEngineVersion.VER_14_2 = PostgresEngineVersion.of('14.2', '14', { s3Import: true, s3Export: true });
/** Version "14.3". */
PostgresEngineVersion.VER_14_3 = PostgresEngineVersion.of('14.3', '14', { s3Import: true, s3Export: true });
/** Version "14.4". */
PostgresEngineVersion.VER_14_4 = PostgresEngineVersion.of('14.4', '14', { s3Import: true, s3Export: true });
/** Version "14.5". */
PostgresEngineVersion.VER_14_5 = PostgresEngineVersion.of('14.5', '14', { s3Import: true, s3Export: true });
/** Version "14.6". */
PostgresEngineVersion.VER_14_6 = PostgresEngineVersion.of('14.6', '14', { s3Import: true, s3Export: true });
/** Version "14.7". */
PostgresEngineVersion.VER_14_7 = PostgresEngineVersion.of('14.7', '14', { s3Import: true, s3Export: true });
/** Version "15" (only a major version, without a specific minor version). */
PostgresEngineVersion.VER_15 = PostgresEngineVersion.of('15', '15', { s3Import: true, s3Export: true });
/** Version "15.2". */
PostgresEngineVersion.VER_15_2 = PostgresEngineVersion.of('15.2', '15', { s3Import: true, s3Export: true });
exports.PostgresEngineVersion = PostgresEngineVersion;
/**
 * The instance engine for PostgreSQL.
 */
class PostgresInstanceEngine extends InstanceEngineBase {
    constructor(version) {
        super({
            engineType: 'postgres',
            singleUserRotationApplication: secretsmanager.SecretRotationApplication.POSTGRES_ROTATION_SINGLE_USER,
            multiUserRotationApplication: secretsmanager.SecretRotationApplication.POSTGRES_ROTATION_MULTI_USER,
            version: version
                ? {
                    fullVersion: version.postgresFullVersion,
                    majorVersion: version.postgresMajorVersion,
                }
                : undefined,
            features: version ? version?._features : { s3Import: 's3Import' },
            engineFamily: 'POSTGRESQL',
        });
        this.defaultUsername = 'postgres';
    }
}
/**
 * The versions for the legacy Oracle instance engines
 * (those returned by `DatabaseInstanceEngine.oracleSe`
 * and `DatabaseInstanceEngine.oracleSe1`).
 * Note: RDS will stop allowing creating new databases with this version in August 2020.
 *
 * @deprecated instances can no longer be created with these engine versions. See https://forums.aws.amazon.com/ann.jspa?annID=7341
 */
class OracleLegacyEngineVersion {
    static of(oracleLegacyFullVersion, oracleLegacyMajorVersion) {
        return new OracleLegacyEngineVersion(oracleLegacyFullVersion, oracleLegacyMajorVersion);
    }
    constructor(oracleLegacyFullVersion, oracleLegacyMajorVersion) {
        this.oracleLegacyFullVersion = oracleLegacyFullVersion;
        this.oracleLegacyMajorVersion = oracleLegacyMajorVersion;
    }
}
_d = JSII_RTTI_SYMBOL_1;
OracleLegacyEngineVersion[_d] = { fqn: "aws-cdk-lib.aws_rds.OracleLegacyEngineVersion", version: "2.74.0" };
/** Version "11.2" (only a major version, without a specific minor version). */
OracleLegacyEngineVersion.VER_11_2 = OracleLegacyEngineVersion.of('11.2', '11.2');
/** Version "11.2.0.2.v2". */
OracleLegacyEngineVersion.VER_11_2_0_2_V2 = OracleLegacyEngineVersion.of('11.2.0.2.v2', '11.2');
/** Version "11.2.0.4.v1". */
OracleLegacyEngineVersion.VER_11_2_0_4_V1 = OracleLegacyEngineVersion.of('11.2.0.4.v1', '11.2');
/** Version "11.2.0.4.v3". */
OracleLegacyEngineVersion.VER_11_2_0_4_V3 = OracleLegacyEngineVersion.of('11.2.0.4.v3', '11.2');
/** Version "11.2.0.4.v4". */
OracleLegacyEngineVersion.VER_11_2_0_4_V4 = OracleLegacyEngineVersion.of('11.2.0.4.v4', '11.2');
/** Version "11.2.0.4.v5". */
OracleLegacyEngineVersion.VER_11_2_0_4_V5 = OracleLegacyEngineVersion.of('11.2.0.4.v5', '11.2');
/** Version "11.2.0.4.v6". */
OracleLegacyEngineVersion.VER_11_2_0_4_V6 = OracleLegacyEngineVersion.of('11.2.0.4.v6', '11.2');
/** Version "11.2.0.4.v7". */
OracleLegacyEngineVersion.VER_11_2_0_4_V7 = OracleLegacyEngineVersion.of('11.2.0.4.v7', '11.2');
/** Version "11.2.0.4.v8". */
OracleLegacyEngineVersion.VER_11_2_0_4_V8 = OracleLegacyEngineVersion.of('11.2.0.4.v8', '11.2');
/** Version "11.2.0.4.v9". */
OracleLegacyEngineVersion.VER_11_2_0_4_V9 = OracleLegacyEngineVersion.of('11.2.0.4.v9', '11.2');
/** Version "11.2.0.4.v10". */
OracleLegacyEngineVersion.VER_11_2_0_4_V10 = OracleLegacyEngineVersion.of('11.2.0.4.v10', '11.2');
/** Version "11.2.0.4.v11". */
OracleLegacyEngineVersion.VER_11_2_0_4_V11 = OracleLegacyEngineVersion.of('11.2.0.4.v11', '11.2');
/** Version "11.2.0.4.v12". */
OracleLegacyEngineVersion.VER_11_2_0_4_V12 = OracleLegacyEngineVersion.of('11.2.0.4.v12', '11.2');
/** Version "11.2.0.4.v13". */
OracleLegacyEngineVersion.VER_11_2_0_4_V13 = OracleLegacyEngineVersion.of('11.2.0.4.v13', '11.2');
/** Version "11.2.0.4.v14". */
OracleLegacyEngineVersion.VER_11_2_0_4_V14 = OracleLegacyEngineVersion.of('11.2.0.4.v14', '11.2');
/** Version "11.2.0.4.v15". */
OracleLegacyEngineVersion.VER_11_2_0_4_V15 = OracleLegacyEngineVersion.of('11.2.0.4.v15', '11.2');
/** Version "11.2.0.4.v16". */
OracleLegacyEngineVersion.VER_11_2_0_4_V16 = OracleLegacyEngineVersion.of('11.2.0.4.v16', '11.2');
/** Version "11.2.0.4.v17". */
OracleLegacyEngineVersion.VER_11_2_0_4_V17 = OracleLegacyEngineVersion.of('11.2.0.4.v17', '11.2');
/** Version "11.2.0.4.v18". */
OracleLegacyEngineVersion.VER_11_2_0_4_V18 = OracleLegacyEngineVersion.of('11.2.0.4.v18', '11.2');
/** Version "11.2.0.4.v19". */
OracleLegacyEngineVersion.VER_11_2_0_4_V19 = OracleLegacyEngineVersion.of('11.2.0.4.v19', '11.2');
/** Version "11.2.0.4.v20". */
OracleLegacyEngineVersion.VER_11_2_0_4_V20 = OracleLegacyEngineVersion.of('11.2.0.4.v20', '11.2');
/** Version "11.2.0.4.v21". */
OracleLegacyEngineVersion.VER_11_2_0_4_V21 = OracleLegacyEngineVersion.of('11.2.0.4.v21', '11.2');
/** Version "11.2.0.4.v22". */
OracleLegacyEngineVersion.VER_11_2_0_4_V22 = OracleLegacyEngineVersion.of('11.2.0.4.v22', '11.2');
/** Version "11.2.0.4.v23". */
OracleLegacyEngineVersion.VER_11_2_0_4_V23 = OracleLegacyEngineVersion.of('11.2.0.4.v23', '11.2');
/** Version "11.2.0.4.v24". */
OracleLegacyEngineVersion.VER_11_2_0_4_V24 = OracleLegacyEngineVersion.of('11.2.0.4.v24', '11.2');
/** Version "11.2.0.4.v25". */
OracleLegacyEngineVersion.VER_11_2_0_4_V25 = OracleLegacyEngineVersion.of('11.2.0.4.v25', '11.2');
exports.OracleLegacyEngineVersion = OracleLegacyEngineVersion;
/**
 * The versions for the Oracle instance engines.
 * Those returned by the following list.
 * - `DatabaseInstanceEngine.oracleSe2`
 * - `DatabaseInstanceEngine.oracleSe2Cdb`
 * - `DatabaseInstanceEngine.oracleEe`
 * - `DatabaseInstanceEngine.oracleEeCdb`.
 */
class OracleEngineVersion {
    /**
     * Creates a new OracleEngineVersion with an arbitrary version.
     *
     * @param oracleFullVersion the full version string,
     *   for example "19.0.0.0.ru-2019-10.rur-2019-10.r1"
     * @param oracleMajorVersion the major version of the engine,
     *   for example "19"
     */
    static of(oracleFullVersion, oracleMajorVersion) {
        return new OracleEngineVersion(oracleFullVersion, oracleMajorVersion);
    }
    constructor(oracleFullVersion, oracleMajorVersion) {
        this.oracleFullVersion = oracleFullVersion;
        this.oracleMajorVersion = oracleMajorVersion;
    }
}
_e = JSII_RTTI_SYMBOL_1;
OracleEngineVersion[_e] = { fqn: "aws-cdk-lib.aws_rds.OracleEngineVersion", version: "2.74.0" };
/** Version "12.1" (only a major version, without a specific minor version). */
OracleEngineVersion.VER_12_1 = OracleEngineVersion.of('12.1', '12.1');
/** Version "12.1.0.2.v1". */
OracleEngineVersion.VER_12_1_0_2_V1 = OracleEngineVersion.of('12.1.0.2.v1', '12.1');
/** Version "12.1.0.2.v2". */
OracleEngineVersion.VER_12_1_0_2_V2 = OracleEngineVersion.of('12.1.0.2.v2', '12.1');
/** Version "12.1.0.2.v3". */
OracleEngineVersion.VER_12_1_0_2_V3 = OracleEngineVersion.of('12.1.0.2.v3', '12.1');
/** Version "12.1.0.2.v4". */
OracleEngineVersion.VER_12_1_0_2_V4 = OracleEngineVersion.of('12.1.0.2.v4', '12.1');
/** Version "12.1.0.2.v5". */
OracleEngineVersion.VER_12_1_0_2_V5 = OracleEngineVersion.of('12.1.0.2.v5', '12.1');
/** Version "12.1.0.2.v6". */
OracleEngineVersion.VER_12_1_0_2_V6 = OracleEngineVersion.of('12.1.0.2.v6', '12.1');
/** Version "12.1.0.2.v7". */
OracleEngineVersion.VER_12_1_0_2_V7 = OracleEngineVersion.of('12.1.0.2.v7', '12.1');
/** Version "12.1.0.2.v8". */
OracleEngineVersion.VER_12_1_0_2_V8 = OracleEngineVersion.of('12.1.0.2.v8', '12.1');
/** Version "12.1.0.2.v9". */
OracleEngineVersion.VER_12_1_0_2_V9 = OracleEngineVersion.of('12.1.0.2.v9', '12.1');
/** Version "12.1.0.2.v10". */
OracleEngineVersion.VER_12_1_0_2_V10 = OracleEngineVersion.of('12.1.0.2.v10', '12.1');
/** Version "12.1.0.2.v11". */
OracleEngineVersion.VER_12_1_0_2_V11 = OracleEngineVersion.of('12.1.0.2.v11', '12.1');
/** Version "12.1.0.2.v12". */
OracleEngineVersion.VER_12_1_0_2_V12 = OracleEngineVersion.of('12.1.0.2.v12', '12.1');
/** Version "12.1.0.2.v13". */
OracleEngineVersion.VER_12_1_0_2_V13 = OracleEngineVersion.of('12.1.0.2.v13', '12.1');
/** Version "12.1.0.2.v14". */
OracleEngineVersion.VER_12_1_0_2_V14 = OracleEngineVersion.of('12.1.0.2.v14', '12.1');
/** Version "12.1.0.2.v15". */
OracleEngineVersion.VER_12_1_0_2_V15 = OracleEngineVersion.of('12.1.0.2.v15', '12.1');
/** Version "12.1.0.2.v16". */
OracleEngineVersion.VER_12_1_0_2_V16 = OracleEngineVersion.of('12.1.0.2.v16', '12.1');
/** Version "12.1.0.2.v17". */
OracleEngineVersion.VER_12_1_0_2_V17 = OracleEngineVersion.of('12.1.0.2.v17', '12.1');
/** Version "12.1.0.2.v18". */
OracleEngineVersion.VER_12_1_0_2_V18 = OracleEngineVersion.of('12.1.0.2.v18', '12.1');
/** Version "12.1.0.2.v19". */
OracleEngineVersion.VER_12_1_0_2_V19 = OracleEngineVersion.of('12.1.0.2.v19', '12.1');
/** Version "12.1.0.2.v20". */
OracleEngineVersion.VER_12_1_0_2_V20 = OracleEngineVersion.of('12.1.0.2.v20', '12.1');
/** Version "12.1.0.2.v21". */
OracleEngineVersion.VER_12_1_0_2_V21 = OracleEngineVersion.of('12.1.0.2.v21', '12.1');
/** Version "12.1.0.2.v22". */
OracleEngineVersion.VER_12_1_0_2_V22 = OracleEngineVersion.of('12.1.0.2.v22', '12.1');
/** Version "12.1.0.2.v23". */
OracleEngineVersion.VER_12_1_0_2_V23 = OracleEngineVersion.of('12.1.0.2.v23', '12.1');
/** Version "12.1.0.2.v24". */
OracleEngineVersion.VER_12_1_0_2_V24 = OracleEngineVersion.of('12.1.0.2.v24', '12.1');
/** Version "12.1.0.2.v25". */
OracleEngineVersion.VER_12_1_0_2_V25 = OracleEngineVersion.of('12.1.0.2.v25', '12.1');
/** Version "12.1.0.2.v26". */
OracleEngineVersion.VER_12_1_0_2_V26 = OracleEngineVersion.of('12.1.0.2.v26', '12.1');
/** Version "12.1.0.2.v27". */
OracleEngineVersion.VER_12_1_0_2_V27 = OracleEngineVersion.of('12.1.0.2.v27', '12.1');
/** Version "12.1.0.2.v28". */
OracleEngineVersion.VER_12_1_0_2_V28 = OracleEngineVersion.of('12.1.0.2.v28', '12.1');
/** Version "12.1.0.2.v29". */
OracleEngineVersion.VER_12_1_0_2_V29 = OracleEngineVersion.of('12.1.0.2.v29', '12.1');
/** Version "12.2" (only a major version, without a specific minor version). */
OracleEngineVersion.VER_12_2 = OracleEngineVersion.of('12.2', '12.2');
/** Version "12.2.0.1.ru-2018-10.rur-2018-10.r1". */
OracleEngineVersion.VER_12_2_0_1_2018_10_R1 = OracleEngineVersion.of('12.2.0.1.ru-2018-10.rur-2018-10.r1', '12.2');
/** Version "12.2.0.1.ru-2019-01.rur-2019-01.r1". */
OracleEngineVersion.VER_12_2_0_1_2019_01_R1 = OracleEngineVersion.of('12.2.0.1.ru-2019-01.rur-2019-01.r1', '12.2');
/** Version "12.2.0.1.ru-2019-04.rur-2019-04.r1". */
OracleEngineVersion.VER_12_2_0_1_2019_04_R1 = OracleEngineVersion.of('12.2.0.1.ru-2019-04.rur-2019-04.r1', '12.2');
/** Version "12.2.0.1.ru-2019-07.rur-2019-07.r1". */
OracleEngineVersion.VER_12_2_0_1_2019_07_R1 = OracleEngineVersion.of('12.2.0.1.ru-2019-07.rur-2019-07.r1', '12.2');
/** Version "12.2.0.1.ru-2019-10.rur-2019-10.r1". */
OracleEngineVersion.VER_12_2_0_1_2019_10_R1 = OracleEngineVersion.of('12.2.0.1.ru-2019-10.rur-2019-10.r1', '12.2');
/** Version "12.2.0.1.ru-2020-01.rur-2020-01.r1". */
OracleEngineVersion.VER_12_2_0_1_2020_01_R1 = OracleEngineVersion.of('12.2.0.1.ru-2020-01.rur-2020-01.r1', '12.2');
/** Version "12.2.0.1.ru-2020-04.rur-2020-04.r1". */
OracleEngineVersion.VER_12_2_0_1_2020_04_R1 = OracleEngineVersion.of('12.2.0.1.ru-2020-04.rur-2020-04.r1', '12.2');
/** Version "12.2.0.1.ru-2020-07.rur-2020-07.r1". */
OracleEngineVersion.VER_12_2_0_1_2020_07_R1 = OracleEngineVersion.of('12.2.0.1.ru-2020-07.rur-2020-07.r1', '12.2');
/** Version "12.2.0.1.ru-2021-10.rur-2020-10.r1". */
OracleEngineVersion.VER_12_2_0_1_2020_10_R1 = OracleEngineVersion.of('12.2.0.1.ru-2020-10.rur-2020-10.r1', '12.2');
/** Version "12.2.0.1.ru-2021-01.rur-2021-01.r1". */
OracleEngineVersion.VER_12_2_0_1_2021_01_R1 = OracleEngineVersion.of('12.2.0.1.ru-2021-01.rur-2021-01.r1', '12.2');
/** Version "12.2.0.1.ru-2021-04.rur-2021-04.r1". */
OracleEngineVersion.VER_12_2_0_1_2021_04_R1 = OracleEngineVersion.of('12.2.0.1.ru-2021-04.rur-2021-04.r1', '12.2');
/** Version "12.2.0.1.ru-2021-07.rur-2021-07.r1". */
OracleEngineVersion.VER_12_2_0_1_2021_07_R1 = OracleEngineVersion.of('12.2.0.1.ru-2021-07.rur-2021-07.r1', '12.2');
/** Version "12.2.0.1.ru-2021-10.rur-2021-10.r1". */
OracleEngineVersion.VER_12_2_0_1_2021_10_R1 = OracleEngineVersion.of('12.2.0.1.ru-2021-10.rur-2021-10.r1', '12.2');
/** Version "12.2.0.1.ru-2022-01.rur-2022-01.r1". */
OracleEngineVersion.VER_12_2_0_1_2022_01_R1 = OracleEngineVersion.of('12.2.0.1.ru-2022-01.rur-2022-01.r1', '12.2');
/** Version "18" (only a major version, without a specific minor version). */
OracleEngineVersion.VER_18 = OracleEngineVersion.of('18', '18');
/** Version "18.0.0.0.ru-2019-07.rur-2019-07.r1". */
OracleEngineVersion.VER_18_0_0_0_2019_07_R1 = OracleEngineVersion.of('18.0.0.0.ru-2019-07.rur-2019-07.r1', '18');
/** Version "18.0.0.0.ru-2019-10.rur-2019-10.r1". */
OracleEngineVersion.VER_18_0_0_0_2019_10_R1 = OracleEngineVersion.of('18.0.0.0.ru-2019-10.rur-2019-10.r1', '18');
/** Version "18.0.0.0.ru-2020-01.rur-2020-01.r1". */
OracleEngineVersion.VER_18_0_0_0_2020_01_R1 = OracleEngineVersion.of('18.0.0.0.ru-2020-01.rur-2020-01.r1', '18');
/** Version "18.0.0.0.ru-2020-04.rur-2020-04.r1". */
OracleEngineVersion.VER_18_0_0_0_2020_04_R1 = OracleEngineVersion.of('18.0.0.0.ru-2020-04.rur-2020-04.r1', '18');
/** Version "18.0.0.0.ru-2020-07.rur-2020-07.r1". */
OracleEngineVersion.VER_18_0_0_0_2020_07_R1 = OracleEngineVersion.of('18.0.0.0.ru-2020-07.rur-2020-07.r1', '18');
/** Version "18.0.0.0.ru-2020-10.rur-2020-10.r1". */
OracleEngineVersion.VER_18_0_0_0_2020_10_R1 = OracleEngineVersion.of('18.0.0.0.ru-2020-10.rur-2020-10.r1', '18');
/** Version "18.0.0.0.ru-2021-01.rur-2021-01.r1". */
OracleEngineVersion.VER_18_0_0_0_2021_01_R1 = OracleEngineVersion.of('18.0.0.0.ru-2021-01.rur-2021-01.r1', '18');
/** Version "18.0.0.0.ru-2021-04.rur-2021-04.r1". */
OracleEngineVersion.VER_18_0_0_0_2021_04_R1 = OracleEngineVersion.of('18.0.0.0.ru-2021-04.rur-2021-04.r1', '18');
/** Version "19" (only a major version, without a specific minor version). */
OracleEngineVersion.VER_19 = OracleEngineVersion.of('19', '19');
/** Version "19.0.0.0.ru-2019-07.rur-2019-07.r1". */
OracleEngineVersion.VER_19_0_0_0_2019_07_R1 = OracleEngineVersion.of('19.0.0.0.ru-2019-07.rur-2019-07.r1', '19');
/** Version "19.0.0.0.ru-2019-10.rur-2019-10.r1". */
OracleEngineVersion.VER_19_0_0_0_2019_10_R1 = OracleEngineVersion.of('19.0.0.0.ru-2019-10.rur-2019-10.r1', '19');
/** Version "19.0.0.0.ru-2020-01.rur-2020-01.r1". */
OracleEngineVersion.VER_19_0_0_0_2020_01_R1 = OracleEngineVersion.of('19.0.0.0.ru-2020-01.rur-2020-01.r1', '19');
/** Version "19.0.0.0.ru-2020-04.rur-2020-04.r1". */
OracleEngineVersion.VER_19_0_0_0_2020_04_R1 = OracleEngineVersion.of('19.0.0.0.ru-2020-04.rur-2020-04.r1', '19');
/** Version "19.0.0.0.ru-2020-07.rur-2020-07.r1". */
OracleEngineVersion.VER_19_0_0_0_2020_07_R1 = OracleEngineVersion.of('19.0.0.0.ru-2020-07.rur-2020-07.r1', '19');
/** Version "19.0.0.0.ru-2020-07.rur-2020-10.r1". */
OracleEngineVersion.VER_19_0_0_0_2020_10_R1 = OracleEngineVersion.of('19.0.0.0.ru-2020-10.rur-2020-10.r1', '19');
/** Version "19.0.0.0.ru-2021-01.rur-2021-01.r1". */
OracleEngineVersion.VER_19_0_0_0_2021_01_R1 = OracleEngineVersion.of('19.0.0.0.ru-2021-01.rur-2021-01.r1', '19');
/** Version "19.0.0.0.ru-2021-01.rur-2021-01.r2". */
OracleEngineVersion.VER_19_0_0_0_2021_01_R2 = OracleEngineVersion.of('19.0.0.0.ru-2021-01.rur-2021-01.r2', '19');
/** Version "19.0.0.0.ru-2021-01.rur-2021-04.r1". */
OracleEngineVersion.VER_19_0_0_0_2021_04_R1 = OracleEngineVersion.of('19.0.0.0.ru-2021-04.rur-2021-04.r1', '19');
/** Version "19.0.0.0.ru-2021-07.rur-2021-07.r1". */
OracleEngineVersion.VER_19_0_0_0_2021_07_R1 = OracleEngineVersion.of('19.0.0.0.ru-2021-07.rur-2021-07.r1', '19');
/** Version "19.0.0.0.ru-2021-10.rur-2021-10.r1". */
OracleEngineVersion.VER_19_0_0_0_2021_10_R1 = OracleEngineVersion.of('19.0.0.0.ru-2021-10.rur-2021-10.r1', '19');
/** Version "19.0.0.0.ru-2022-01.rur-2022-01.r1". */
OracleEngineVersion.VER_19_0_0_0_2022_01_R1 = OracleEngineVersion.of('19.0.0.0.ru-2022-01.rur-2022-01.r1', '19');
/** Version "19.0.0.0.ru-2022-04.rur-2022-04.r1". */
OracleEngineVersion.VER_19_0_0_0_2022_04_R1 = OracleEngineVersion.of('19.0.0.0.ru-2022-04.rur-2022-04.r1', '19');
/** Version "19.0.0.0.ru-2022-07.rur-2022-07.r1". */
OracleEngineVersion.VER_19_0_0_0_2022_07_R1 = OracleEngineVersion.of('19.0.0.0.ru-2022-07.rur-2022-07.r1', '19');
/** Version "19.0.0.0.ru-2022-10.rur-2022-10.r1". */
OracleEngineVersion.VER_19_0_0_0_2022_10_R1 = OracleEngineVersion.of('19.0.0.0.ru-2022-10.rur-2022-10.r1', '19');
/** Version "19.0.0.0.ru-2023-01.rur-2023-01.r1". */
OracleEngineVersion.VER_19_0_0_0_2023_01_R1 = OracleEngineVersion.of('19.0.0.0.ru-2023-01.rur-2023-01.r1', '19');
/** Version "21" (only a major version, without a specific minor version). */
OracleEngineVersion.VER_21 = OracleEngineVersion.of('21', '21');
/** Version "21.0.0.0.ru-2022-01.rur-2022-01.r1". */
OracleEngineVersion.VER_21_0_0_0_2022_01_R1 = OracleEngineVersion.of('21.0.0.0.ru-2022-01.rur-2022-01.r1', '21');
/** Version "21.0.0.0.ru-2022-04.rur-2022-04.r1". */
OracleEngineVersion.VER_21_0_0_0_2022_04_R1 = OracleEngineVersion.of('21.0.0.0.ru-2022-04.rur-2022-04.r1', '21');
/** Version "21.0.0.0.ru-2022-07.rur-2022-07.r1". */
OracleEngineVersion.VER_21_0_0_0_2022_07_R1 = OracleEngineVersion.of('21.0.0.0.ru-2022-07.rur-2022-07.r1', '21');
/** Version "21.0.0.0.ru-2022-10.rur-2022-10.r1". */
OracleEngineVersion.VER_21_0_0_0_2022_10_R1 = OracleEngineVersion.of('21.0.0.0.ru-2022-10.rur-2022-10.r1', '21');
/** Version "21.0.0.0.ru-2023-01.rur-2023-01.r1". */
OracleEngineVersion.VER_21_0_0_0_2023_01_R1 = OracleEngineVersion.of('21.0.0.0.ru-2023-01.rur-2023-01.r1', '21');
exports.OracleEngineVersion = OracleEngineVersion;
class OracleInstanceEngineBase extends InstanceEngineBase {
    constructor(props) {
        super({
            ...props,
            singleUserRotationApplication: secretsmanager.SecretRotationApplication.ORACLE_ROTATION_SINGLE_USER,
            multiUserRotationApplication: secretsmanager.SecretRotationApplication.ORACLE_ROTATION_MULTI_USER,
            parameterGroupFamily: props.version ? `${props.engineType}-${props.version.majorVersion}` : undefined,
            features: {
                s3Import: 'S3_INTEGRATION',
                s3Export: 'S3_INTEGRATION',
            },
        });
    }
    bindToInstance(scope, options) {
        const config = super.bindToInstance(scope, options);
        let optionGroup = options.optionGroup;
        if (options.s3ImportRole || options.s3ExportRole) {
            if (!optionGroup) {
                optionGroup = new option_group_1.OptionGroup(scope, 'InstanceOptionGroup', {
                    engine: this,
                    configurations: [],
                });
            }
            // https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-s3-integration.html
            optionGroup.addConfiguration({
                name: 'S3_INTEGRATION',
                version: '1.0',
            });
        }
        return {
            ...config,
            optionGroup,
        };
    }
}
/** @deprecated instances can no longer be created with this engine. See https://forums.aws.amazon.com/ann.jspa?annID=7341 */
class OracleSeInstanceEngine extends OracleInstanceEngineBase {
    constructor(version) {
        super({
            engineType: 'oracle-se',
            version: version
                ? {
                    fullVersion: version.oracleLegacyFullVersion,
                    majorVersion: version.oracleLegacyMajorVersion,
                }
                : {
                    majorVersion: '11.2',
                },
        });
    }
}
/** @deprecated instances can no longer be created with this engine. See https://forums.aws.amazon.com/ann.jspa?annID=7341 */
class OracleSe1InstanceEngine extends OracleInstanceEngineBase {
    constructor(version) {
        super({
            engineType: 'oracle-se1',
            version: version
                ? {
                    fullVersion: version.oracleLegacyFullVersion,
                    majorVersion: version.oracleLegacyMajorVersion,
                }
                : {
                    majorVersion: '11.2',
                },
        });
    }
}
class OracleSe2InstanceEngine extends OracleInstanceEngineBase {
    constructor(version) {
        super({
            engineType: 'oracle-se2',
            version: version
                ? {
                    fullVersion: version.oracleFullVersion,
                    majorVersion: version.oracleMajorVersion,
                }
                : undefined,
        });
    }
}
class OracleSe2CdbInstanceEngine extends OracleInstanceEngineBase {
    constructor(version) {
        super({
            engineType: 'oracle-se2-cdb',
            version: version
                ? {
                    fullVersion: version.oracleFullVersion,
                    majorVersion: version.oracleMajorVersion,
                }
                : undefined,
        });
    }
}
class OracleEeInstanceEngine extends OracleInstanceEngineBase {
    constructor(version) {
        super({
            engineType: 'oracle-ee',
            version: version
                ? {
                    fullVersion: version.oracleFullVersion,
                    majorVersion: version.oracleMajorVersion,
                }
                : undefined,
        });
    }
}
class OracleEeCdbInstanceEngine extends OracleInstanceEngineBase {
    constructor(version) {
        super({
            engineType: 'oracle-ee-cdb',
            version: version
                ? {
                    fullVersion: version.oracleFullVersion,
                    majorVersion: version.oracleMajorVersion,
                }
                : undefined,
        });
    }
}
/**
 * The versions for the SQL Server instance engines
 * (those returned by `DatabaseInstanceEngine.sqlServerSe`,
 * `DatabaseInstanceEngine.sqlServerEx`, `DatabaseInstanceEngine.sqlServerWeb`
 * and `DatabaseInstanceEngine.sqlServerEe`).
 */
class SqlServerEngineVersion {
    /**
     * Create a new SqlServerEngineVersion with an arbitrary version.
     *
     * @param sqlServerFullVersion the full version string,
     *   for example "15.00.3049.1.v1"
     * @param sqlServerMajorVersion the major version of the engine,
     *   for example "15.00"
     */
    static of(sqlServerFullVersion, sqlServerMajorVersion) {
        return new SqlServerEngineVersion(sqlServerFullVersion, sqlServerMajorVersion);
    }
    constructor(sqlServerFullVersion, sqlServerMajorVersion) {
        this.sqlServerFullVersion = sqlServerFullVersion;
        this.sqlServerMajorVersion = sqlServerMajorVersion;
    }
}
_f = JSII_RTTI_SYMBOL_1;
SqlServerEngineVersion[_f] = { fqn: "aws-cdk-lib.aws_rds.SqlServerEngineVersion", version: "2.74.0" };
/** Version "11.00" (only a major version, without a specific minor version). */
SqlServerEngineVersion.VER_11 = SqlServerEngineVersion.of('11.00', '11.00');
/** Version "11.00.5058.0.v1". */
SqlServerEngineVersion.VER_11_00_5058_0_V1 = SqlServerEngineVersion.of('11.00.5058.0.v1', '11.00');
/** Version "11.00.6020.0.v1". */
SqlServerEngineVersion.VER_11_00_6020_0_V1 = SqlServerEngineVersion.of('11.00.6020.0.v1', '11.00');
/** Version "11.00.6594.0.v1". */
SqlServerEngineVersion.VER_11_00_6594_0_V1 = SqlServerEngineVersion.of('11.00.6594.0.v1', '11.00');
/** Version "11.00.7462.6.v1". */
SqlServerEngineVersion.VER_11_00_7462_6_V1 = SqlServerEngineVersion.of('11.00.7462.6.v1', '11.00');
/** Version "11.00.7493.4.v1". */
SqlServerEngineVersion.VER_11_00_7493_4_V1 = SqlServerEngineVersion.of('11.00.7493.4.v1', '11.00');
/** Version "12.00" (only a major version, without a specific minor version). */
SqlServerEngineVersion.VER_12 = SqlServerEngineVersion.of('12.00', '12.00');
/** Version "12.00.5000.0.v1". */
SqlServerEngineVersion.VER_12_00_5000_0_V1 = SqlServerEngineVersion.of('12.00.5000.0.v1', '12.00');
/** Version "12.00.5546.0.v1". */
SqlServerEngineVersion.VER_12_00_5546_0_V1 = SqlServerEngineVersion.of('12.00.5546.0.v1', '12.00');
/** Version "12.00.5571.0.v1". */
SqlServerEngineVersion.VER_12_00_5571_0_V1 = SqlServerEngineVersion.of('12.00.5571.0.v1', '12.00');
/** Version "12.00.6293.0.v1". */
SqlServerEngineVersion.VER_12_00_6293_0_V1 = SqlServerEngineVersion.of('12.00.6293.0.v1', '12.00');
/** Version "12.00.6329.1.v1". */
SqlServerEngineVersion.VER_12_00_6329_1_V1 = SqlServerEngineVersion.of('12.00.6329.1.v1', '12.00');
/** Version "12.00.6433.1.v1". */
SqlServerEngineVersion.VER_12_00_6433_1_V1 = SqlServerEngineVersion.of('12.00.6433.1.v1', '12.00');
/** Version "12.00.6439.10.v1". */
SqlServerEngineVersion.VER_12_00_6439_10_V1 = SqlServerEngineVersion.of('12.00.6439.10.v1', '12.00');
/** Version "13.00" (only a major version, without a specific minor version). */
SqlServerEngineVersion.VER_13 = SqlServerEngineVersion.of('13.00', '13.00');
/** Version "13.00.2164.0.v1". */
SqlServerEngineVersion.VER_13_00_2164_0_V1 = SqlServerEngineVersion.of('13.00.2164.0.v1', '13.00');
/** Version "13.00.4422.0.v1". */
SqlServerEngineVersion.VER_13_00_4422_0_V1 = SqlServerEngineVersion.of('13.00.4422.0.v1', '13.00');
/** Version "13.00.4451.0.v1". */
SqlServerEngineVersion.VER_13_00_4451_0_V1 = SqlServerEngineVersion.of('13.00.4451.0.v1', '13.00');
/** Version "13.00.4466.4.v1". */
SqlServerEngineVersion.VER_13_00_4466_4_V1 = SqlServerEngineVersion.of('13.00.4466.4.v1', '13.00');
/** Version "13.00.4522.0.v1". */
SqlServerEngineVersion.VER_13_00_4522_0_V1 = SqlServerEngineVersion.of('13.00.4522.0.v1', '13.00');
/** Version "13.00.5216.0.v1". */
SqlServerEngineVersion.VER_13_00_5216_0_V1 = SqlServerEngineVersion.of('13.00.5216.0.v1', '13.00');
/** Version "13.00.5292.0.v1". */
SqlServerEngineVersion.VER_13_00_5292_0_V1 = SqlServerEngineVersion.of('13.00.5292.0.v1', '13.00');
/** Version "13.00.5366.0.v1". */
SqlServerEngineVersion.VER_13_00_5366_0_V1 = SqlServerEngineVersion.of('13.00.5366.0.v1', '13.00');
/** Version "13.00.5426.0.v1". */
SqlServerEngineVersion.VER_13_00_5426_0_V1 = SqlServerEngineVersion.of('13.00.5426.0.v1', '13.00');
/** Version "13.00.5598.27.v1". */
SqlServerEngineVersion.VER_13_00_5598_27_V1 = SqlServerEngineVersion.of('13.00.5598.27.v1', '13.00');
/** Version "13.00.5820.21.v1". */
SqlServerEngineVersion.VER_13_00_5820_21_V1 = SqlServerEngineVersion.of('13.00.5820.21.v1', '13.00');
/** Version "13.00.5850.14.v1". */
SqlServerEngineVersion.VER_13_00_5850_14_V1 = SqlServerEngineVersion.of('13.00.5850.14.v1', '13.00');
/** Version "13.00.5882.1.v1". */
SqlServerEngineVersion.VER_13_00_5882_1_V1 = SqlServerEngineVersion.of('13.00.5882.1.v1', '13.00');
/** Version "13.00.6300.2.v1". */
SqlServerEngineVersion.VER_13_00_6300_2_V1 = SqlServerEngineVersion.of('13.00.6300.2.v1', '13.00');
/** Version "13.00.6419.1.v1". */
SqlServerEngineVersion.VER_13_00_6419_1_V1 = SqlServerEngineVersion.of('13.00.6419.1.v1', '13.00');
/** Version "14.00" (only a major version, without a specific minor version). */
SqlServerEngineVersion.VER_14 = SqlServerEngineVersion.of('14.00', '14.00');
/** Version "14.00.1000.169.v1". */
SqlServerEngineVersion.VER_14_00_1000_169_V1 = SqlServerEngineVersion.of('14.00.1000.169.v1', '14.00');
/** Version "14.00.3015.40.v1". */
SqlServerEngineVersion.VER_14_00_3015_40_V1 = SqlServerEngineVersion.of('14.00.3015.40.v1', '14.00');
/** Version "14.00.3035.2.v1". */
SqlServerEngineVersion.VER_14_00_3035_2_V1 = SqlServerEngineVersion.of('14.00.3035.2.v1', '14.00');
/** Version "14.00.3049.1.v1". */
SqlServerEngineVersion.VER_14_00_3049_1_V1 = SqlServerEngineVersion.of('14.00.3049.1.v1', '14.00');
/**
 * Version "14.00.3192.2.v1".
 * @deprecated SQL Server version 14.00.3192.2.v1 reached end of life
*/
SqlServerEngineVersion.VER_14_00_3192_2_V1 = SqlServerEngineVersion.of('14.00.3192.2.v1', '14.00');
/** Version "14.00.3223.3.v1". */
SqlServerEngineVersion.VER_14_00_3223_3_V1 = SqlServerEngineVersion.of('14.00.3223.3.v1', '14.00');
/** Version "14.00.3281.6.v1". */
SqlServerEngineVersion.VER_14_00_3281_6_V1 = SqlServerEngineVersion.of('14.00.3281.6.v1', '14.00');
/** Version "14.00.3294.2.v1". */
SqlServerEngineVersion.VER_14_00_3294_2_V1 = SqlServerEngineVersion.of('14.00.3294.2.v1', '14.00');
/** Version "14.00.3356.20.v1". */
SqlServerEngineVersion.VER_14_00_3356_20_V1 = SqlServerEngineVersion.of('14.00.3356.20.v1', '14.00');
/** Version "14.00.3381.3.v1". */
SqlServerEngineVersion.VER_14_00_3381_3_V1 = SqlServerEngineVersion.of('14.00.3381.3.v1', '14.00');
/** Version "14.00.3401.7.v1". */
SqlServerEngineVersion.VER_14_00_3401_7_V1 = SqlServerEngineVersion.of('14.00.3401.7.v1', '14.00');
/** Version "14.00.3421.10.v1". */
SqlServerEngineVersion.VER_14_00_3421_10_V1 = SqlServerEngineVersion.of('14.00.3421.10.v1', '14.00');
/** Version "14.00.3451.2.v1". */
SqlServerEngineVersion.VER_14_00_3451_2_V1 = SqlServerEngineVersion.of('14.00.3451.2.v1', '14.00');
/** Version "15.00" (only a major version, without a specific minor version). */
SqlServerEngineVersion.VER_15 = SqlServerEngineVersion.of('15.00', '15.00');
/** Version "15.00.4043.16.v1". */
SqlServerEngineVersion.VER_15_00_4043_16_V1 = SqlServerEngineVersion.of('15.00.4043.16.v1', '15.00');
/**
 * Version "15.00.4043.23.v1".
 * @deprecated This version is erroneous. You might be looking for `SqlServerEngineVersion.VER_15_00_4073_23_V1`, instead.
 */
SqlServerEngineVersion.VER_15_00_4043_23_V1 = SqlServerEngineVersion.of('15.00.4043.23.v1', '15.00');
/** Version "15.00.4073.23.v1". */
SqlServerEngineVersion.VER_15_00_4073_23_V1 = SqlServerEngineVersion.of('15.00.4073.23.v1', '15.00');
/** Version "15.00.4153.1.v1". */
SqlServerEngineVersion.VER_15_00_4153_1_V1 = SqlServerEngineVersion.of('15.00.4153.1.v1', '15.00');
/** Version "15.00.4198.2.v1". */
SqlServerEngineVersion.VER_15_00_4198_2_V1 = SqlServerEngineVersion.of('15.00.4198.2.v1', '15.00');
/** Version "15.00.4236.7.v1". */
SqlServerEngineVersion.VER_15_00_4236_7_V1 = SqlServerEngineVersion.of('15.00.4236.7.v1', '15.00');
exports.SqlServerEngineVersion = SqlServerEngineVersion;
class SqlServerInstanceEngineBase extends InstanceEngineBase {
    constructor(props) {
        super({
            ...props,
            singleUserRotationApplication: secretsmanager.SecretRotationApplication.SQLSERVER_ROTATION_SINGLE_USER,
            multiUserRotationApplication: secretsmanager.SecretRotationApplication.SQLSERVER_ROTATION_MULTI_USER,
            version: props.version
                ? {
                    fullVersion: props.version.sqlServerFullVersion,
                    majorVersion: props.version.sqlServerMajorVersion,
                }
                : undefined,
            parameterGroupFamily: props.version
                // for some reason, even though SQL Server major versions usually end in '.00',
                // the ParameterGroup family has to end in '.0'
                ? `${props.engineType}-${props.version.sqlServerMajorVersion.endsWith('.00')
                    ? props.version.sqlServerMajorVersion.slice(0, -1)
                    : props.version.sqlServerMajorVersion}`
                : undefined,
            features: {
                s3Import: 'S3_INTEGRATION',
                s3Export: 'S3_INTEGRATION',
            },
        });
    }
    bindToInstance(scope, options) {
        const config = super.bindToInstance(scope, options);
        let optionGroup = options.optionGroup;
        const s3Role = options.s3ImportRole ?? options.s3ExportRole;
        if (s3Role) {
            if (options.s3ImportRole && options.s3ExportRole && options.s3ImportRole !== options.s3ExportRole) {
                throw new Error('S3 import and export roles must be the same for SQL Server engines');
            }
            if (!optionGroup) {
                optionGroup = new option_group_1.OptionGroup(scope, 'InstanceOptionGroup', {
                    engine: this,
                    configurations: [],
                });
            }
            // https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.SQLServer.Options.BackupRestore.html
            optionGroup.addConfiguration({
                name: 'SQLSERVER_BACKUP_RESTORE',
                settings: { IAM_ROLE_ARN: s3Role.roleArn },
            });
        }
        return {
            ...config,
            optionGroup,
        };
    }
    get supportsTimezone() { return true; }
}
class SqlServerSeInstanceEngine extends SqlServerInstanceEngineBase {
    constructor(version) {
        super({
            engineType: 'sqlserver-se',
            version,
        });
    }
}
class SqlServerExInstanceEngine extends SqlServerInstanceEngineBase {
    constructor(version) {
        super({
            engineType: 'sqlserver-ex',
            version,
        });
    }
}
class SqlServerWebInstanceEngine extends SqlServerInstanceEngineBase {
    constructor(version) {
        super({
            engineType: 'sqlserver-web',
            version,
        });
    }
}
class SqlServerEeInstanceEngine extends SqlServerInstanceEngineBase {
    constructor(version) {
        super({
            engineType: 'sqlserver-ee',
            version,
        });
    }
}
/**
 * A database instance engine. Provides mapping to DatabaseEngine used for
 * secret rotation.
 */
class DatabaseInstanceEngine {
    /** Creates a new MariaDB instance engine. */
    static mariaDb(props) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_MariaDbInstanceEngineProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.mariaDb);
            }
            throw error;
        }
        return new MariaDbInstanceEngine(props.version);
    }
    /** Creates a new MySQL instance engine. */
    static mysql(props) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_MySqlInstanceEngineProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.mysql);
            }
            throw error;
        }
        return new MySqlInstanceEngine(props.version);
    }
    /** Creates a new PostgreSQL instance engine. */
    static postgres(props) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_PostgresInstanceEngineProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.postgres);
            }
            throw error;
        }
        return new PostgresInstanceEngine(props.version);
    }
    /**
     * Creates a new Oracle Standard Edition instance engine.
     * @deprecated instances can no longer be created with this engine. See https://forums.aws.amazon.com/ann.jspa?annID=7341
     */
    static oracleSe(props) {
        return new OracleSeInstanceEngine(props.version);
    }
    /**
     * Creates a new Oracle Standard Edition 1 instance engine.
     * @deprecated instances can no longer be created with this engine. See https://forums.aws.amazon.com/ann.jspa?annID=7341
     */
    static oracleSe1(props) {
        return new OracleSe1InstanceEngine(props.version);
    }
    /** Creates a new Oracle Standard Edition 2 instance engine. */
    static oracleSe2(props) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_OracleSe2InstanceEngineProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.oracleSe2);
            }
            throw error;
        }
        return new OracleSe2InstanceEngine(props.version);
    }
    /** Creates a new Oracle Standard Edition 2 (CDB) instance engine. */
    static oracleSe2Cdb(props) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_OracleSe2CdbInstanceEngineProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.oracleSe2Cdb);
            }
            throw error;
        }
        return new OracleSe2CdbInstanceEngine(props.version);
    }
    /** Creates a new Oracle Enterprise Edition instance engine. */
    static oracleEe(props) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_OracleEeInstanceEngineProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.oracleEe);
            }
            throw error;
        }
        return new OracleEeInstanceEngine(props.version);
    }
    /** Creates a new Oracle Enterprise Edition (CDB) instance engine. */
    static oracleEeCdb(props) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_OracleEeCdbInstanceEngineProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.oracleEeCdb);
            }
            throw error;
        }
        return new OracleEeCdbInstanceEngine(props.version);
    }
    /** Creates a new SQL Server Standard Edition instance engine. */
    static sqlServerSe(props) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_SqlServerSeInstanceEngineProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.sqlServerSe);
            }
            throw error;
        }
        return new SqlServerSeInstanceEngine(props.version);
    }
    /** Creates a new SQL Server Express Edition instance engine. */
    static sqlServerEx(props) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_SqlServerExInstanceEngineProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.sqlServerEx);
            }
            throw error;
        }
        return new SqlServerExInstanceEngine(props.version);
    }
    /** Creates a new SQL Server Web Edition instance engine. */
    static sqlServerWeb(props) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_SqlServerWebInstanceEngineProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.sqlServerWeb);
            }
            throw error;
        }
        return new SqlServerWebInstanceEngine(props.version);
    }
    /** Creates a new SQL Server Enterprise Edition instance engine. */
    static sqlServerEe(props) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_SqlServerEeInstanceEngineProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.sqlServerEe);
            }
            throw error;
        }
        return new SqlServerEeInstanceEngine(props.version);
    }
}
_g = JSII_RTTI_SYMBOL_1;
DatabaseInstanceEngine[_g] = { fqn: "aws-cdk-lib.aws_rds.DatabaseInstanceEngine", version: "2.74.0" };
/**
 * The unversioned 'mariadb' instance engine.
 *
 * NOTE: using unversioned engines is an availability risk.
 *   We recommend using versioned engines created using the `mariaDb()` method
 */
DatabaseInstanceEngine.MARIADB = new MariaDbInstanceEngine();
/**
 * The unversioned 'mysql' instance engine.
 *
 * NOTE: using unversioned engines is an availability risk.
 *   We recommend using versioned engines created using the `mysql()` method
 */
DatabaseInstanceEngine.MYSQL = new MySqlInstanceEngine();
/**
 * The unversioned 'oracle-ee' instance engine.
 *
 * NOTE: using unversioned engines is an availability risk.
 *   We recommend using versioned engines created using the `oracleEe()` method
 */
DatabaseInstanceEngine.ORACLE_EE = new OracleEeInstanceEngine();
/**
 * The unversioned 'oracle-ee-cdb' instance engine.
 *
 * NOTE: using unversioned engines is an availability risk.
 *   We recommend using versioned engines created using the `oracleEeCdb()` method
 */
DatabaseInstanceEngine.ORACLE_EE_CDB = new OracleEeCdbInstanceEngine();
/**
 * The unversioned 'oracle-se2' instance engine.
 *
 * NOTE: using unversioned engines is an availability risk.
 *   We recommend using versioned engines created using the `oracleSe2()` method
 */
DatabaseInstanceEngine.ORACLE_SE2 = new OracleSe2InstanceEngine();
/**
 * The unversioned 'oracle-se2-cdb' instance engine.
 *
 * NOTE: using unversioned engines is an availability risk.
 *   We recommend using versioned engines created using the `oracleSe2Cdb()` method
 */
DatabaseInstanceEngine.ORACLE_SE2_CDB = new OracleSe2CdbInstanceEngine();
/**
 * The unversioned 'oracle-se1' instance engine.
 *
 * @deprecated instances can no longer be created with this engine. See https://forums.aws.amazon.com/ann.jspa?annID=7341
 */
DatabaseInstanceEngine.ORACLE_SE1 = new OracleSe1InstanceEngine();
/**
 * The unversioned 'oracle-se' instance engine.
 *
 * @deprecated instances can no longer be created with this engine. See https://forums.aws.amazon.com/ann.jspa?annID=7341
 */
DatabaseInstanceEngine.ORACLE_SE = new OracleSeInstanceEngine();
/**
 * The unversioned 'postgres' instance engine.
 *
 * NOTE: using unversioned engines is an availability risk.
 *   We recommend using versioned engines created using the `postgres()` method
 */
DatabaseInstanceEngine.POSTGRES = new PostgresInstanceEngine();
/**
 * The unversioned 'sqlserver-ee' instance engine.
 *
 * NOTE: using unversioned engines is an availability risk.
 *   We recommend using versioned engines created using the `sqlServerEe()` method
 */
DatabaseInstanceEngine.SQL_SERVER_EE = new SqlServerEeInstanceEngine();
/**
 * The unversioned 'sqlserver-se' instance engine.
 *
 * NOTE: using unversioned engines is an availability risk.
 *   We recommend using versioned engines created using the `sqlServerSe()` method
 */
DatabaseInstanceEngine.SQL_SERVER_SE = new SqlServerSeInstanceEngine();
/**
 * The unversioned 'sqlserver-ex' instance engine.
 *
 * NOTE: using unversioned engines is an availability risk.
 *   We recommend using versioned engines created using the `sqlServerEx()` method
 */
DatabaseInstanceEngine.SQL_SERVER_EX = new SqlServerExInstanceEngine();
/**
 * The unversioned 'sqlserver-web' instance engine.
 *
 * NOTE: using unversioned engines is an availability risk.
 *   We recommend using versioned engines created using the `sqlServerWeb()` method
 */
DatabaseInstanceEngine.SQL_SERVER_WEB = new SqlServerWebInstanceEngine();
exports.DatabaseInstanceEngine = DatabaseInstanceEngine;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5zdGFuY2UtZW5naW5lLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW5zdGFuY2UtZW5naW5lLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUNBLDJEQUEyRDtBQUkzRCxpREFBMkQ7QUFxSDNELE1BQWUsa0JBQWtCO0lBVy9CLFlBQVksS0FBOEI7UUFDeEMsSUFBSSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUMsVUFBVSxDQUFDO1FBQ25DLElBQUksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQztRQUMvQixJQUFJLENBQUMsNkJBQTZCLEdBQUcsS0FBSyxDQUFDLDZCQUE2QixDQUFDO1FBQ3pFLElBQUksQ0FBQyw0QkFBNEIsR0FBRyxLQUFLLENBQUMsNEJBQTRCLENBQUM7UUFDdkUsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDO1FBQ25DLElBQUksQ0FBQyxvQkFBb0IsR0FBRyxLQUFLLENBQUMsb0JBQW9CO1lBQ3BELENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUMsR0FBRyxJQUFJLENBQUMsVUFBVSxHQUFHLElBQUksQ0FBQyxhQUFhLENBQUMsWUFBWSxFQUFFLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO1FBQzVGLElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDLFlBQVksQ0FBQztLQUN4QztJQUVNLGNBQWMsQ0FBQyxNQUFpQixFQUFFLE9BQWtDO1FBQ3pFLElBQUksT0FBTyxDQUFDLFFBQVEsSUFBSSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsRUFBRTtZQUM5QyxNQUFNLElBQUksS0FBSyxDQUFDLCtDQUErQyxJQUFJLENBQUMsVUFBVSxFQUFFLENBQUMsQ0FBQztTQUNuRjtRQUNELE9BQU87WUFDTCxRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVE7WUFDdkIsV0FBVyxFQUFFLE9BQU8sQ0FBQyxXQUFXO1NBQ2pDLENBQUM7S0FDSDtJQUVELDRFQUE0RTtJQUM1RSxJQUFjLGdCQUFnQixLQUFLLE9BQU8sS0FBSyxDQUFDLEVBQUU7Q0FDbkQ7QUFFRDs7O0dBR0c7QUFDSCxNQUFhLG9CQUFvQjtJQXdOL0I7Ozs7Ozs7T0FPRztJQUNJLE1BQU0sQ0FBQyxFQUFFLENBQUMsa0JBQTBCLEVBQUUsbUJBQTJCO1FBQ3RFLE9BQU8sSUFBSSxvQkFBb0IsQ0FBQyxrQkFBa0IsRUFBRSxtQkFBbUIsQ0FBQyxDQUFDO0tBQzFFO0lBT0QsWUFBb0Isa0JBQTBCLEVBQUUsbUJBQTJCO1FBQ3pFLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxrQkFBa0IsQ0FBQztRQUM3QyxJQUFJLENBQUMsbUJBQW1CLEdBQUcsbUJBQW1CLENBQUM7S0FDaEQ7Ozs7QUEzT0Q7OztFQUdFO0FBQ3FCLDZCQUFRLEdBQUcsb0JBQW9CLENBQUMsRUFBRSxDQUFDLE1BQU0sRUFBRSxNQUFNLENBQUMsQ0FBQztBQUMxRTs7O0VBR0U7QUFDcUIsZ0NBQVcsR0FBRyxvQkFBb0IsQ0FBQyxFQUFFLENBQUMsU0FBUyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQ2hGOzs7RUFHRTtBQUNxQixnQ0FBVyxHQUFHLG9CQUFvQixDQUFDLEVBQUUsQ0FBQyxTQUFTLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDaEY7OztFQUdFO0FBQ3FCLGdDQUFXLEdBQUcsb0JBQW9CLENBQUMsRUFBRSxDQUFDLFNBQVMsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUNoRjs7O0VBR0U7QUFDcUIsZ0NBQVcsR0FBRyxvQkFBb0IsQ0FBQyxFQUFFLENBQUMsU0FBUyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQ2hGOzs7RUFHRTtBQUNxQixnQ0FBVyxHQUFHLG9CQUFvQixDQUFDLEVBQUUsQ0FBQyxTQUFTLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDaEY7OztFQUdFO0FBQ3FCLGdDQUFXLEdBQUcsb0JBQW9CLENBQUMsRUFBRSxDQUFDLFNBQVMsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUNoRjs7O0VBR0U7QUFDcUIsZ0NBQVcsR0FBRyxvQkFBb0IsQ0FBQyxFQUFFLENBQUMsU0FBUyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBRWhGOzs7RUFHRTtBQUNxQiw2QkFBUSxHQUFHLG9CQUFvQixDQUFDLEVBQUUsQ0FBQyxNQUFNLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDMUU7OztFQUdFO0FBQ3FCLGdDQUFXLEdBQUcsb0JBQW9CLENBQUMsRUFBRSxDQUFDLFNBQVMsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUNoRjs7O0VBR0U7QUFDcUIsZ0NBQVcsR0FBRyxvQkFBb0IsQ0FBQyxFQUFFLENBQUMsU0FBUyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQ2hGOzs7RUFHRTtBQUNxQixnQ0FBVyxHQUFHLG9CQUFvQixDQUFDLEVBQUUsQ0FBQyxTQUFTLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDaEY7OztFQUdFO0FBQ3FCLGdDQUFXLEdBQUcsb0JBQW9CLENBQUMsRUFBRSxDQUFDLFNBQVMsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUNoRjs7O0VBR0U7QUFDcUIsZ0NBQVcsR0FBRyxvQkFBb0IsQ0FBQyxFQUFFLENBQUMsU0FBUyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQ2hGOzs7RUFHRTtBQUNxQixnQ0FBVyxHQUFHLG9CQUFvQixDQUFDLEVBQUUsQ0FBQyxTQUFTLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFFaEY7OztHQUdHO0FBQ29CLDZCQUFRLEdBQUcsb0JBQW9CLENBQUMsRUFBRSxDQUFDLE1BQU0sRUFBRSxNQUFNLENBQUMsQ0FBQztBQUMxRTs7O0VBR0U7QUFDcUIsZ0NBQVcsR0FBRyxvQkFBb0IsQ0FBQyxFQUFFLENBQUMsU0FBUyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQ2hGOzs7R0FHRztBQUNvQixnQ0FBVyxHQUFHLG9CQUFvQixDQUFDLEVBQUUsQ0FBQyxTQUFTLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDaEY7OztHQUdHO0FBQ29CLGdDQUFXLEdBQUcsb0JBQW9CLENBQUMsRUFBRSxDQUFDLFNBQVMsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUNoRjs7O0VBR0U7QUFDcUIsZ0NBQVcsR0FBRyxvQkFBb0IsQ0FBQyxFQUFFLENBQUMsU0FBUyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQ2hGOzs7RUFHRTtBQUNxQixnQ0FBVyxHQUFHLG9CQUFvQixDQUFDLEVBQUUsQ0FBQyxTQUFTLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDaEY7OztFQUdFO0FBQ3FCLGdDQUFXLEdBQUcsb0JBQW9CLENBQUMsRUFBRSxDQUFDLFNBQVMsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUNoRjs7O0dBR0c7QUFDb0IsZ0NBQVcsR0FBRyxvQkFBb0IsQ0FBQyxFQUFFLENBQUMsU0FBUyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQ2hGOzs7R0FHRztBQUNvQixnQ0FBVyxHQUFHLG9CQUFvQixDQUFDLEVBQUUsQ0FBQyxTQUFTLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDaEY7OztHQUdHO0FBQ29CLGdDQUFXLEdBQUcsb0JBQW9CLENBQUMsRUFBRSxDQUFDLFNBQVMsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUVoRiwrRUFBK0U7QUFDeEQsNkJBQVEsR0FBRyxvQkFBb0IsQ0FBQyxFQUFFLENBQUMsTUFBTSxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQzFFLHdCQUF3QjtBQUNELCtCQUFVLEdBQUcsb0JBQW9CLENBQUMsRUFBRSxDQUFDLFFBQVEsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUM5RSx5QkFBeUI7QUFDRixnQ0FBVyxHQUFHLG9CQUFvQixDQUFDLEVBQUUsQ0FBQyxTQUFTLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDaEYseUJBQXlCO0FBQ0YsZ0NBQVcsR0FBRyxvQkFBb0IsQ0FBQyxFQUFFLENBQUMsU0FBUyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQ2hGLHlCQUF5QjtBQUNGLGdDQUFXLEdBQUcsb0JBQW9CLENBQUMsRUFBRSxDQUFDLFNBQVMsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUNoRix5QkFBeUI7QUFDRixnQ0FBVyxHQUFHLG9CQUFvQixDQUFDLEVBQUUsQ0FBQyxTQUFTLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDaEYseUJBQXlCO0FBQ0YsZ0NBQVcsR0FBRyxvQkFBb0IsQ0FBQyxFQUFFLENBQUMsU0FBUyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQ2hGLHlCQUF5QjtBQUNGLGdDQUFXLEdBQUcsb0JBQW9CLENBQUMsRUFBRSxDQUFDLFNBQVMsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUNoRix5QkFBeUI7QUFDRixnQ0FBVyxHQUFHLG9CQUFvQixDQUFDLEVBQUUsQ0FBQyxTQUFTLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDaEYseUJBQXlCO0FBQ0YsZ0NBQVcsR0FBRyxvQkFBb0IsQ0FBQyxFQUFFLENBQUMsU0FBUyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQ2hGLHlCQUF5QjtBQUNGLGdDQUFXLEdBQUcsb0JBQW9CLENBQUMsRUFBRSxDQUFDLFNBQVMsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUNoRix5QkFBeUI7QUFDRixnQ0FBVyxHQUFHLG9CQUFvQixDQUFDLEVBQUUsQ0FBQyxTQUFTLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDaEYseUJBQXlCO0FBQ0YsZ0NBQVcsR0FBRyxvQkFBb0IsQ0FBQyxFQUFFLENBQUMsU0FBUyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBRWhGLCtFQUErRTtBQUN4RCw2QkFBUSxHQUFHLG9CQUFvQixDQUFDLEVBQUUsQ0FBQyxNQUFNLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDMUUsd0JBQXdCO0FBQ0QsK0JBQVUsR0FBRyxvQkFBb0IsQ0FBQyxFQUFFLENBQUMsUUFBUSxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQzlFLHlCQUF5QjtBQUNGLGdDQUFXLEdBQUcsb0JBQW9CLENBQUMsRUFBRSxDQUFDLFNBQVMsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUNoRix5QkFBeUI7QUFDRixnQ0FBVyxHQUFHLG9CQUFvQixDQUFDLEVBQUUsQ0FBQyxTQUFTLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDaEYseUJBQXlCO0FBQ0YsZ0NBQVcsR0FBRyxvQkFBb0IsQ0FBQyxFQUFFLENBQUMsU0FBUyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQ2hGLHlCQUF5QjtBQUNGLGdDQUFXLEdBQUcsb0JBQW9CLENBQUMsRUFBRSxDQUFDLFNBQVMsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUNoRix5QkFBeUI7QUFDRixnQ0FBVyxHQUFHLG9CQUFvQixDQUFDLEVBQUUsQ0FBQyxTQUFTLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDaEYseUJBQXlCO0FBQ0YsZ0NBQVcsR0FBRyxvQkFBb0IsQ0FBQyxFQUFFLENBQUMsU0FBUyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQ2hGLHlCQUF5QjtBQUNGLGdDQUFXLEdBQUcsb0JBQW9CLENBQUMsRUFBRSxDQUFDLFNBQVMsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUNoRix5QkFBeUI7QUFDRixnQ0FBVyxHQUFHLG9CQUFvQixDQUFDLEVBQUUsQ0FBQyxTQUFTLEVBQUUsTUFBTSxDQUFDLENBQUE7QUFDL0UseUJBQXlCO0FBQ0YsZ0NBQVcsR0FBRyxvQkFBb0IsQ0FBQyxFQUFFLENBQUMsU0FBUyxFQUFFLE1BQU0sQ0FBQyxDQUFBO0FBRS9FLCtFQUErRTtBQUN4RCw2QkFBUSxHQUFHLG9CQUFvQixDQUFDLEVBQUUsQ0FBQyxNQUFNLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDMUUsd0JBQXdCO0FBQ0QsK0JBQVUsR0FBRyxvQkFBb0IsQ0FBQyxFQUFFLENBQUMsUUFBUSxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQzlFLHdCQUF3QjtBQUNELCtCQUFVLEdBQUcsb0JBQW9CLENBQUMsRUFBRSxDQUFDLFFBQVEsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUM5RSx5QkFBeUI7QUFDRixnQ0FBVyxHQUFHLG9CQUFvQixDQUFDLEVBQUUsQ0FBQyxTQUFTLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDaEYseUJBQXlCO0FBQ0YsZ0NBQVcsR0FBRyxvQkFBb0IsQ0FBQyxFQUFFLENBQUMsU0FBUyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQ2hGLHlCQUF5QjtBQUNGLGdDQUFXLEdBQUcsb0JBQW9CLENBQUMsRUFBRSxDQUFDLFNBQVMsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUNoRix5QkFBeUI7QUFDRixnQ0FBVyxHQUFHLG9CQUFvQixDQUFDLEVBQUUsQ0FBQyxTQUFTLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDaEYseUJBQXlCO0FBQ0YsZ0NBQVcsR0FBRyxvQkFBb0IsQ0FBQyxFQUFFLENBQUMsU0FBUyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQ2hGLHlCQUF5QjtBQUNGLGdDQUFXLEdBQUcsb0JBQW9CLENBQUMsRUFBRSxDQUFDLFNBQVMsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUNoRix5QkFBeUI7QUFDRixnQ0FBVyxHQUFHLG9CQUFvQixDQUFDLEVBQUUsQ0FBQyxTQUFTLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFFaEYsK0VBQStFO0FBQ3hELDZCQUFRLEdBQUcsb0JBQW9CLENBQUMsRUFBRSxDQUFDLE1BQU0sRUFBRSxNQUFNLENBQUMsQ0FBQztBQUMxRSx3QkFBd0I7QUFDRCwrQkFBVSxHQUFHLG9CQUFvQixDQUFDLEVBQUUsQ0FBQyxRQUFRLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDOUUsd0JBQXdCO0FBQ0QsK0JBQVUsR0FBRyxvQkFBb0IsQ0FBQyxFQUFFLENBQUMsUUFBUSxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQzlFLHdCQUF3QjtBQUNELCtCQUFVLEdBQUcsb0JBQW9CLENBQUMsRUFBRSxDQUFDLFFBQVEsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUM5RSx5QkFBeUI7QUFDRixnQ0FBVyxHQUFHLG9CQUFvQixDQUFDLEVBQUUsQ0FBQyxTQUFTLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDaEYseUJBQXlCO0FBQ0YsZ0NBQVcsR0FBRyxvQkFBb0IsQ0FBQyxFQUFFLENBQUMsU0FBUyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQ2hGLHlCQUF5QjtBQUNGLGdDQUFXLEdBQUcsb0JBQW9CLENBQUMsRUFBRSxDQUFDLFNBQVMsRUFBRSxNQUFNLENBQUMsQ0FBQztBQXJOckUsb0RBQW9CO0FBd1BqQyxNQUFNLHFCQUFzQixTQUFRLGtCQUFrQjtJQUdwRCxZQUFZLE9BQThCO1FBQ3hDLEtBQUssQ0FBQztZQUNKLFVBQVUsRUFBRSxTQUFTO1lBQ3JCLDZCQUE2QixFQUFFLGNBQWMsQ0FBQyx5QkFBeUIsQ0FBQyw0QkFBNEI7WUFDcEcsNEJBQTRCLEVBQUUsY0FBYyxDQUFDLHlCQUF5QixDQUFDLDJCQUEyQjtZQUNsRyxPQUFPLEVBQUUsT0FBTztnQkFDZCxDQUFDLENBQUM7b0JBQ0EsV0FBVyxFQUFFLE9BQU8sQ0FBQyxrQkFBa0I7b0JBQ3ZDLFlBQVksRUFBRSxPQUFPLENBQUMsbUJBQW1CO2lCQUMxQztnQkFDRCxDQUFDLENBQUMsU0FBUztTQUNkLENBQUMsQ0FBQztRQWJXLCtCQUEwQixHQUFHLElBQUksQ0FBQztLQWNqRDtJQUVNLGNBQWMsQ0FBQyxLQUFnQixFQUFFLE9BQWtDO1FBQ3hFLElBQUksT0FBTyxDQUFDLE1BQU0sRUFBRTtZQUNsQixNQUFNLElBQUksS0FBSyxDQUFDLDRDQUE0QyxJQUFJLENBQUMsVUFBVSxFQUFFLENBQUMsQ0FBQztTQUNoRjtRQUNELE9BQU8sS0FBSyxDQUFDLGNBQWMsQ0FBQyxLQUFLLEVBQUUsT0FBTyxDQUFDLENBQUM7S0FDN0M7Q0FDRjtBQUVEOzs7R0FHRztBQUNILE1BQWEsa0JBQWtCO0lBa0w3Qjs7Ozs7OztPQU9HO0lBQ0ksTUFBTSxDQUFDLEVBQUUsQ0FBQyxnQkFBd0IsRUFBRSxpQkFBeUI7UUFDbEUsT0FBTyxJQUFJLGtCQUFrQixDQUFDLGdCQUFnQixFQUFFLGlCQUFpQixDQUFDLENBQUM7S0FDcEU7SUFPRCxZQUFvQixnQkFBd0IsRUFBRSxpQkFBeUI7UUFDckUsSUFBSSxDQUFDLGdCQUFnQixHQUFHLGdCQUFnQixDQUFDO1FBQ3pDLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxpQkFBaUIsQ0FBQztLQUM1Qzs7OztBQXJNRDs7O0VBR0U7QUFDcUIsMEJBQU8sR0FBRyxrQkFBa0IsQ0FBQyxFQUFFLENBQUMsS0FBSyxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQ3JFOzs7RUFHRTtBQUNxQiw2QkFBVSxHQUFHLGtCQUFrQixDQUFDLEVBQUUsQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDM0U7OztFQUdFO0FBQ3FCLDZCQUFVLEdBQUcsa0JBQWtCLENBQUMsRUFBRSxDQUFDLFFBQVEsRUFBRSxLQUFLLENBQUMsQ0FBQztBQUMzRTs7O0VBR0U7QUFDcUIsNkJBQVUsR0FBRyxrQkFBa0IsQ0FBQyxFQUFFLENBQUMsUUFBUSxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQzNFOzs7RUFHRTtBQUNxQiw2QkFBVSxHQUFHLGtCQUFrQixDQUFDLEVBQUUsQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDM0U7OztFQUdFO0FBQ3FCLDZCQUFVLEdBQUcsa0JBQWtCLENBQUMsRUFBRSxDQUFDLFFBQVEsRUFBRSxLQUFLLENBQUMsQ0FBQztBQUUzRTs7O0VBR0U7QUFDcUIsMEJBQU8sR0FBRyxrQkFBa0IsQ0FBQyxFQUFFLENBQUMsS0FBSyxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQ3JFOzs7RUFHRTtBQUNxQiw2QkFBVSxHQUFHLGtCQUFrQixDQUFDLEVBQUUsQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDM0U7OztFQUdFO0FBQ3FCLDZCQUFVLEdBQUcsa0JBQWtCLENBQUMsRUFBRSxDQUFDLFFBQVEsRUFBRSxLQUFLLENBQUMsQ0FBQztBQUMzRTs7O0VBR0U7QUFDcUIsNkJBQVUsR0FBRyxrQkFBa0IsQ0FBQyxFQUFFLENBQUMsUUFBUSxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQzNFOzs7RUFHRTtBQUNxQiw2QkFBVSxHQUFHLGtCQUFrQixDQUFDLEVBQUUsQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDM0U7OztFQUdFO0FBQ3FCLDZCQUFVLEdBQUcsa0JBQWtCLENBQUMsRUFBRSxDQUFDLFFBQVEsRUFBRSxLQUFLLENBQUMsQ0FBQztBQUMzRTs7O0VBR0U7QUFDcUIsNkJBQVUsR0FBRyxrQkFBa0IsQ0FBQyxFQUFFLENBQUMsUUFBUSxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQzNFOzs7RUFHRTtBQUNxQiw2QkFBVSxHQUFHLGtCQUFrQixDQUFDLEVBQUUsQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDM0U7OztFQUdFO0FBQ3FCLDZCQUFVLEdBQUcsa0JBQWtCLENBQUMsRUFBRSxDQUFDLFFBQVEsRUFBRSxLQUFLLENBQUMsQ0FBQztBQUMzRTs7O0VBR0U7QUFDcUIsNkJBQVUsR0FBRyxrQkFBa0IsQ0FBQyxFQUFFLENBQUMsUUFBUSxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQzNFOzs7RUFHRTtBQUNxQiw2QkFBVSxHQUFHLGtCQUFrQixDQUFDLEVBQUUsQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDM0U7OztFQUdFO0FBQ3FCLDZCQUFVLEdBQUcsa0JBQWtCLENBQUMsRUFBRSxDQUFDLFFBQVEsRUFBRSxLQUFLLENBQUMsQ0FBQztBQUMzRTs7O0VBR0U7QUFDcUIsNkJBQVUsR0FBRyxrQkFBa0IsQ0FBQyxFQUFFLENBQUMsUUFBUSxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBRTNFLDhFQUE4RTtBQUN2RCwwQkFBTyxHQUFHLGtCQUFrQixDQUFDLEVBQUUsQ0FBQyxLQUFLLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDckUsd0JBQXdCO0FBQ0QsNkJBQVUsR0FBRyxrQkFBa0IsQ0FBQyxFQUFFLENBQUMsUUFBUSxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQzNFLHdCQUF3QjtBQUNELDZCQUFVLEdBQUcsa0JBQWtCLENBQUMsRUFBRSxDQUFDLFFBQVEsRUFBRSxLQUFLLENBQUMsQ0FBQztBQUMzRSx3QkFBd0I7QUFDRCw2QkFBVSxHQUFHLGtCQUFrQixDQUFDLEVBQUUsQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDM0Usd0JBQXdCO0FBQ0QsNkJBQVUsR0FBRyxrQkFBa0IsQ0FBQyxFQUFFLENBQUMsUUFBUSxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQzNFLHdCQUF3QjtBQUNELDZCQUFVLEdBQUcsa0JBQWtCLENBQUMsRUFBRSxDQUFDLFFBQVEsRUFBRSxLQUFLLENBQUMsQ0FBQztBQUMzRSx3QkFBd0I7QUFDRCw2QkFBVSxHQUFHLGtCQUFrQixDQUFDLEVBQUUsQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDM0Usd0JBQXdCO0FBQ0QsNkJBQVUsR0FBRyxrQkFBa0IsQ0FBQyxFQUFFLENBQUMsUUFBUSxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQzNFLHdCQUF3QjtBQUNELDZCQUFVLEdBQUcsa0JBQWtCLENBQUMsRUFBRSxDQUFDLFFBQVEsRUFBRSxLQUFLLENBQUMsQ0FBQztBQUMzRSx3QkFBd0I7QUFDRCw2QkFBVSxHQUFHLGtCQUFrQixDQUFDLEVBQUUsQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDM0Usd0JBQXdCO0FBQ0QsNkJBQVUsR0FBRyxrQkFBa0IsQ0FBQyxFQUFFLENBQUMsUUFBUSxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQzNFLHdCQUF3QjtBQUNELDZCQUFVLEdBQUcsa0JBQWtCLENBQUMsRUFBRSxDQUFDLFFBQVEsRUFBRSxLQUFLLENBQUMsQ0FBQztBQUMzRSx3QkFBd0I7QUFDRCw2QkFBVSxHQUFHLGtCQUFrQixDQUFDLEVBQUUsQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDM0Usd0JBQXdCO0FBQ0QsNkJBQVUsR0FBRyxrQkFBa0IsQ0FBQyxFQUFFLENBQUMsUUFBUSxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQzNFLHdCQUF3QjtBQUNELDZCQUFVLEdBQUcsa0JBQWtCLENBQUMsRUFBRSxDQUFDLFFBQVEsRUFBRSxLQUFLLENBQUMsQ0FBQztBQUMzRSx3QkFBd0I7QUFDRCw2QkFBVSxHQUFHLGtCQUFrQixDQUFDLEVBQUUsQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDM0Usd0JBQXdCO0FBQ0QsNkJBQVUsR0FBRyxrQkFBa0IsQ0FBQyxFQUFFLENBQUMsUUFBUSxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQzNFLHdCQUF3QjtBQUNELDZCQUFVLEdBQUcsa0JBQWtCLENBQUMsRUFBRSxDQUFDLFFBQVEsRUFBRSxLQUFLLENBQUMsQ0FBQztBQUMzRSx3QkFBd0I7QUFDRCw2QkFBVSxHQUFHLGtCQUFrQixDQUFDLEVBQUUsQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDM0Usd0JBQXdCO0FBQ0QsNkJBQVUsR0FBRyxrQkFBa0IsQ0FBQyxFQUFFLENBQUMsUUFBUSxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQzNFLHdCQUF3QjtBQUNELDZCQUFVLEdBQUcsa0JBQWtCLENBQUMsRUFBRSxDQUFDLFFBQVEsRUFBRSxLQUFLLENBQUMsQ0FBQztBQUMzRSx3QkFBd0I7QUFDRCw2QkFBVSxHQUFHLGtCQUFrQixDQUFDLEVBQUUsQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFFM0UsOEVBQThFO0FBQ3ZELDBCQUFPLEdBQUcsa0JBQWtCLENBQUMsRUFBRSxDQUFDLEtBQUssRUFBRSxLQUFLLENBQUMsQ0FBQztBQUNyRSx3QkFBd0I7QUFDRCw2QkFBVSxHQUFHLGtCQUFrQixDQUFDLEVBQUUsQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDM0Usd0JBQXdCO0FBQ0QsNkJBQVUsR0FBRyxrQkFBa0IsQ0FBQyxFQUFFLENBQUMsUUFBUSxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQzNFLHdCQUF3QjtBQUNELDZCQUFVLEdBQUcsa0JBQWtCLENBQUMsRUFBRSxDQUFDLFFBQVEsRUFBRSxLQUFLLENBQUMsQ0FBQztBQUMzRSx3QkFBd0I7QUFDRCw2QkFBVSxHQUFHLGtCQUFrQixDQUFDLEVBQUUsQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDM0Usd0JBQXdCO0FBQ0QsNkJBQVUsR0FBRyxrQkFBa0IsQ0FBQyxFQUFFLENBQUMsUUFBUSxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQzNFLHdCQUF3QjtBQUNELDZCQUFVLEdBQUcsa0JBQWtCLENBQUMsRUFBRSxDQUFDLFFBQVEsRUFBRSxLQUFLLENBQUMsQ0FBQztBQUMzRSx5QkFBeUI7QUFDRiw2QkFBVSxHQUFHLGtCQUFrQixDQUFDLEVBQUUsQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDM0UseUJBQXlCO0FBQ0YsNkJBQVUsR0FBRyxrQkFBa0IsQ0FBQyxFQUFFLENBQUMsUUFBUSxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQzNFLHdCQUF3QjtBQUNELDZCQUFVLEdBQUcsa0JBQWtCLENBQUMsRUFBRSxDQUFDLFFBQVEsRUFBRSxLQUFLLENBQUMsQ0FBQztBQUMzRSx3QkFBd0I7QUFDRCw2QkFBVSxHQUFHLGtCQUFrQixDQUFDLEVBQUUsQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDM0Usd0JBQXdCO0FBQ0QsNkJBQVUsR0FBRyxrQkFBa0IsQ0FBQyxFQUFFLENBQUMsUUFBUSxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQzNFLHdCQUF3QjtBQUNELDZCQUFVLEdBQUcsa0JBQWtCLENBQUMsRUFBRSxDQUFDLFFBQVEsRUFBRSxLQUFLLENBQUMsQ0FBQztBQUMzRSx3QkFBd0I7QUFDRCw2QkFBVSxHQUFHLGtCQUFrQixDQUFDLEVBQUUsQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDM0Usd0JBQXdCO0FBQ0QsNkJBQVUsR0FBRyxrQkFBa0IsQ0FBQyxFQUFFLENBQUMsUUFBUSxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQzNFLHdCQUF3QjtBQUNELDZCQUFVLEdBQUcsa0JBQWtCLENBQUMsRUFBRSxDQUFDLFFBQVEsRUFBRSxLQUFLLENBQUMsQ0FBQztBQUMzRSx3QkFBd0I7QUFDRCw2QkFBVSxHQUFHLGtCQUFrQixDQUFDLEVBQUUsQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFoTGhFLGdEQUFrQjtBQWtOL0IsTUFBTSxtQkFBb0IsU0FBUSxrQkFBa0I7SUFHbEQsWUFBWSxPQUE0QjtRQUN0QyxLQUFLLENBQUM7WUFDSixVQUFVLEVBQUUsT0FBTztZQUNuQiw2QkFBNkIsRUFBRSxjQUFjLENBQUMseUJBQXlCLENBQUMsMEJBQTBCO1lBQ2xHLDRCQUE0QixFQUFFLGNBQWMsQ0FBQyx5QkFBeUIsQ0FBQyx5QkFBeUI7WUFDaEcsT0FBTyxFQUFFLE9BQU87Z0JBQ2QsQ0FBQyxDQUFDO29CQUNBLFdBQVcsRUFBRSxPQUFPLENBQUMsZ0JBQWdCO29CQUNyQyxZQUFZLEVBQUUsT0FBTyxDQUFDLGlCQUFpQjtpQkFDeEM7Z0JBQ0QsQ0FBQyxDQUFDLFNBQVM7WUFDYixZQUFZLEVBQUUsT0FBTztTQUN0QixDQUFDLENBQUM7UUFkVywrQkFBMEIsR0FBRyxJQUFJLENBQUM7S0FlakQ7Q0FDRjtBQXFCRDs7O0dBR0c7QUFDSCxNQUFhLHFCQUFxQjtJQXFiaEM7Ozs7Ozs7T0FPRztJQUNJLE1BQU0sQ0FBQyxFQUFFLENBQUMsbUJBQTJCLEVBQUUsb0JBQTRCLEVBQUUsZ0JBQXlDOzs7Ozs7Ozs7O1FBQ25ILE9BQU8sSUFBSSxxQkFBcUIsQ0FBQyxtQkFBbUIsRUFBRSxvQkFBb0IsRUFBRSxnQkFBZ0IsQ0FBQyxDQUFDO0tBQy9GO0lBYUQsWUFBb0IsbUJBQTJCLEVBQUUsb0JBQTRCLEVBQUUsZ0JBQXlDO1FBQ3RILElBQUksQ0FBQyxtQkFBbUIsR0FBRyxtQkFBbUIsQ0FBQztRQUMvQyxJQUFJLENBQUMsb0JBQW9CLEdBQUcsb0JBQW9CLENBQUM7UUFDakQsSUFBSSxDQUFDLFNBQVMsR0FBRztZQUNmLFFBQVEsRUFBRSxnQkFBZ0IsRUFBRSxRQUFRLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsU0FBUztZQUM3RCxRQUFRLEVBQUUsZ0JBQWdCLEVBQUUsUUFBUSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLFNBQVM7U0FDOUQsQ0FBQztLQUNIOzs7O0FBbGREOzs7RUFHRTtBQUNxQiw2QkFBTyxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxLQUFLLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDeEU7OztFQUdFO0FBQ3FCLCtCQUFTLEdBQUcscUJBQXFCLENBQUMsRUFBRSxDQUFDLE9BQU8sRUFBRSxLQUFLLENBQUMsQ0FBQztBQUM1RTs7O0VBR0U7QUFDcUIsK0JBQVMsR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsT0FBTyxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQzVFOzs7RUFHRTtBQUNxQiwrQkFBUyxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxPQUFPLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDNUU7OztFQUdFO0FBQ3FCLCtCQUFTLEdBQUcscUJBQXFCLENBQUMsRUFBRSxDQUFDLE9BQU8sRUFBRSxLQUFLLENBQUMsQ0FBQztBQUM1RTs7O0VBR0U7QUFDcUIsK0JBQVMsR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsT0FBTyxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQzVFOzs7RUFHRTtBQUNxQixnQ0FBVSxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDOUU7OztFQUdFO0FBQ3FCLGdDQUFVLEdBQUcscUJBQXFCLENBQUMsRUFBRSxDQUFDLFFBQVEsRUFBRSxLQUFLLENBQUMsQ0FBQztBQUM5RTs7O0VBR0U7QUFDcUIsZ0NBQVUsR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsUUFBUSxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQzlFOzs7RUFHRTtBQUNxQixnQ0FBVSxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDOUU7OztFQUdFO0FBQ3FCLGdDQUFVLEdBQUcscUJBQXFCLENBQUMsRUFBRSxDQUFDLFFBQVEsRUFBRSxLQUFLLENBQUMsQ0FBQztBQUM5RTs7O0VBR0U7QUFDcUIsZ0NBQVUsR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsUUFBUSxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQzlFOzs7RUFHRTtBQUNxQixnQ0FBVSxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDOUU7OztFQUdFO0FBQ3FCLGdDQUFVLEdBQUcscUJBQXFCLENBQUMsRUFBRSxDQUFDLFFBQVEsRUFBRSxLQUFLLENBQUMsQ0FBQztBQUM5RTs7O0VBR0U7QUFDcUIsZ0NBQVUsR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsUUFBUSxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQzlFOzs7RUFHRTtBQUNxQixnQ0FBVSxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDOUU7OztFQUdFO0FBQ3FCLGdDQUFVLEdBQUcscUJBQXFCLENBQUMsRUFBRSxDQUFDLFFBQVEsRUFBRSxLQUFLLENBQUMsQ0FBQztBQUM5RTs7O0VBR0U7QUFDcUIsZ0NBQVUsR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsUUFBUSxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQzlFOzs7RUFHRTtBQUNxQixnQ0FBVSxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDOUU7OztFQUdFO0FBQ3FCLGdDQUFVLEdBQUcscUJBQXFCLENBQUMsRUFBRSxDQUFDLFFBQVEsRUFBRSxLQUFLLENBQUMsQ0FBQztBQUU5RTs7O0VBR0U7QUFDcUIsNkJBQU8sR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsS0FBSyxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQ3hFOzs7RUFHRTtBQUNxQiwrQkFBUyxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxPQUFPLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDNUU7OztFQUdFO0FBQ3FCLCtCQUFTLEdBQUcscUJBQXFCLENBQUMsRUFBRSxDQUFDLE9BQU8sRUFBRSxLQUFLLENBQUMsQ0FBQztBQUM1RTs7O0VBR0U7QUFDcUIsK0JBQVMsR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsT0FBTyxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQzVFOzs7RUFHRTtBQUNxQiwrQkFBUyxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxPQUFPLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDNUU7OztFQUdFO0FBQ3FCLCtCQUFTLEdBQUcscUJBQXFCLENBQUMsRUFBRSxDQUFDLE9BQU8sRUFBRSxLQUFLLENBQUMsQ0FBQztBQUM1RTs7O0VBR0U7QUFDcUIsK0JBQVMsR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsT0FBTyxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQzVFOzs7RUFHRTtBQUNxQiwrQkFBUyxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxPQUFPLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDNUU7OztFQUdFO0FBQ3FCLGdDQUFVLEdBQUcscUJBQXFCLENBQUMsRUFBRSxDQUFDLFFBQVEsRUFBRSxLQUFLLENBQUMsQ0FBQztBQUM5RTs7O0VBR0U7QUFDcUIsZ0NBQVUsR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsUUFBUSxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQzlFOzs7RUFHRTtBQUNxQixnQ0FBVSxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDOUU7OztFQUdFO0FBQ3FCLGdDQUFVLEdBQUcscUJBQXFCLENBQUMsRUFBRSxDQUFDLFFBQVEsRUFBRSxLQUFLLENBQUMsQ0FBQztBQUM5RTs7O0VBR0U7QUFDcUIsZ0NBQVUsR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsUUFBUSxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQzlFOzs7RUFHRTtBQUNxQixnQ0FBVSxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDOUU7OztFQUdFO0FBQ3FCLGdDQUFVLEdBQUcscUJBQXFCLENBQUMsRUFBRSxDQUFDLFFBQVEsRUFBRSxLQUFLLENBQUMsQ0FBQztBQUM5RTs7O0VBR0U7QUFDcUIsZ0NBQVUsR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsUUFBUSxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQzlFOzs7RUFHRTtBQUNxQixnQ0FBVSxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDOUU7OztFQUdFO0FBQ3FCLGdDQUFVLEdBQUcscUJBQXFCLENBQUMsRUFBRSxDQUFDLFFBQVEsRUFBRSxLQUFLLENBQUMsQ0FBQztBQUM5RTs7O0VBR0U7QUFDcUIsZ0NBQVUsR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsUUFBUSxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQzlFOzs7RUFHRTtBQUNxQixnQ0FBVSxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDOUU7OztFQUdFO0FBQ3FCLGdDQUFVLEdBQUcscUJBQXFCLENBQUMsRUFBRSxDQUFDLFFBQVEsRUFBRSxLQUFLLENBQUMsQ0FBQztBQUM5RTs7O0VBR0U7QUFDcUIsZ0NBQVUsR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsUUFBUSxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBRTlFOzs7RUFHRTtBQUNxQiw0QkFBTSxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxJQUFJLEVBQUUsSUFBSSxDQUFDLENBQUM7QUFDckU7OztFQUdFO0FBQ3FCLDhCQUFRLEdBQUcscUJBQXFCLENBQUMsRUFBRSxDQUFDLE1BQU0sRUFBRSxJQUFJLENBQUMsQ0FBQztBQUN6RTs7O0VBR0U7QUFDcUIsOEJBQVEsR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsTUFBTSxFQUFFLElBQUksQ0FBQyxDQUFDO0FBQ3pFOzs7RUFHRTtBQUNxQiw4QkFBUSxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxNQUFNLEVBQUUsSUFBSSxDQUFDLENBQUM7QUFDekU7OztFQUdFO0FBQ3FCLDhCQUFRLEdBQUcscUJBQXFCLENBQUMsRUFBRSxDQUFDLE1BQU0sRUFBRSxJQUFJLENBQUMsQ0FBQztBQUN6RTs7O0VBR0U7QUFDcUIsOEJBQVEsR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsTUFBTSxFQUFFLElBQUksQ0FBQyxDQUFDO0FBQ3pFOzs7RUFHRTtBQUNxQiw4QkFBUSxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxNQUFNLEVBQUUsSUFBSSxFQUFFLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxDQUFDLENBQUM7QUFDN0Y7OztFQUdFO0FBQ3FCLDhCQUFRLEdBQUcscUJBQXFCLENBQUMsRUFBRSxDQUFDLE1BQU0sRUFBRSxJQUFJLEVBQUUsRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztBQUM3Rjs7O0VBR0U7QUFDcUIsK0JBQVMsR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsT0FBTyxFQUFFLElBQUksRUFBRSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsQ0FBQyxDQUFDO0FBQy9GOzs7RUFHRTtBQUNxQiwrQkFBUyxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxPQUFPLEVBQUUsSUFBSSxFQUFFLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxDQUFDLENBQUM7QUFDL0Y7OztFQUdFO0FBQ3FCLCtCQUFTLEdBQUcscUJBQXFCLENBQUMsRUFBRSxDQUFDLE9BQU8sRUFBRSxJQUFJLEVBQUUsRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztBQUMvRjs7O0VBR0U7QUFDcUIsK0JBQVMsR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsT0FBTyxFQUFFLElBQUksRUFBRSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsQ0FBQyxDQUFDO0FBQy9GOzs7RUFHRTtBQUNxQiwrQkFBUyxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxPQUFPLEVBQUUsSUFBSSxFQUFFLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztBQUMvRzs7O0VBR0U7QUFDcUIsK0JBQVMsR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsT0FBTyxFQUFFLElBQUksRUFBRSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxDQUFDLENBQUM7QUFDL0c7OztFQUdFO0FBQ3FCLCtCQUFTLEdBQUcscUJBQXFCLENBQUMsRUFBRSxDQUFDLE9BQU8sRUFBRSxJQUFJLEVBQUUsRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsQ0FBQyxDQUFDO0FBQy9HOzs7RUFHRTtBQUNxQiwrQkFBUyxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxPQUFPLEVBQUUsSUFBSSxFQUFFLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztBQUMvRzs7O0VBR0U7QUFDcUIsK0JBQVMsR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsT0FBTyxFQUFFLElBQUksRUFBRSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxDQUFDLENBQUM7QUFDL0c7OztFQUdFO0FBQ3FCLCtCQUFTLEdBQUcscUJBQXFCLENBQUMsRUFBRSxDQUFDLE9BQU8sRUFBRSxJQUFJLEVBQUUsRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsQ0FBQyxDQUFDO0FBQy9HOzs7RUFHRTtBQUNxQiwrQkFBUyxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxPQUFPLEVBQUUsSUFBSSxFQUFFLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztBQUMvRzs7O0VBR0U7QUFDcUIsK0JBQVMsR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsT0FBTyxFQUFFLElBQUksRUFBRSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxDQUFDLENBQUM7QUFDL0c7OztFQUdFO0FBQ3FCLCtCQUFTLEdBQUcscUJBQXFCLENBQUMsRUFBRSxDQUFDLE9BQU8sRUFBRSxJQUFJLEVBQUUsRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsQ0FBQyxDQUFDO0FBQy9HOzs7RUFHRTtBQUNxQiwrQkFBUyxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxPQUFPLEVBQUUsSUFBSSxFQUFFLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztBQUUvRyw2RUFBNkU7QUFDdEQsNEJBQU0sR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsSUFBSSxFQUFFLElBQUksRUFBRSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsQ0FBQyxDQUFDO0FBQ3pGLHNCQUFzQjtBQUNDLDhCQUFRLEdBQUcscUJBQXFCLENBQUMsRUFBRSxDQUFDLE1BQU0sRUFBRSxJQUFJLEVBQUUsRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztBQUM3RixzQkFBc0I7QUFDQyw4QkFBUSxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxNQUFNLEVBQUUsSUFBSSxFQUFFLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxDQUFDLENBQUM7QUFDN0Ysc0JBQXNCO0FBQ0MsOEJBQVEsR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsTUFBTSxFQUFFLElBQUksRUFBRSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsQ0FBQyxDQUFDO0FBQzdGLHNCQUFzQjtBQUNDLDhCQUFRLEdBQUcscUJBQXFCLENBQUMsRUFBRSxDQUFDLE1BQU0sRUFBRSxJQUFJLEVBQUUsRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztBQUM3RixzQkFBc0I7QUFDQyw4QkFBUSxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxNQUFNLEVBQUUsSUFBSSxFQUFFLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxDQUFDLENBQUM7QUFDN0Ysc0JBQXNCO0FBQ0MsOEJBQVEsR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsTUFBTSxFQUFFLElBQUksRUFBRSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsQ0FBQyxDQUFDO0FBQzdGLHNCQUFzQjtBQUNDLDhCQUFRLEdBQUcscUJBQXFCLENBQUMsRUFBRSxDQUFDLE1BQU0sRUFBRSxJQUFJLEVBQUUsRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztBQUM3RixzQkFBc0I7QUFDQyw4QkFBUSxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxNQUFNLEVBQUUsSUFBSSxFQUFFLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztBQUM3Ryx1QkFBdUI7QUFDQSwrQkFBUyxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxPQUFPLEVBQUUsSUFBSSxFQUFFLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztBQUMvRyx1QkFBdUI7QUFDQSwrQkFBUyxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxPQUFPLEVBQUUsSUFBSSxFQUFFLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztBQUMvRyx1QkFBdUI7QUFDQSwrQkFBUyxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxPQUFPLEVBQUUsSUFBSSxFQUFFLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztBQUMvRyx1QkFBdUI7QUFDQSwrQkFBUyxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxPQUFPLEVBQUUsSUFBSSxFQUFFLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztBQUMvRyx1QkFBdUI7QUFDQSwrQkFBUyxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxPQUFPLEVBQUUsSUFBSSxFQUFFLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztBQUMvRyx1QkFBdUI7QUFDQSwrQkFBUyxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxPQUFPLEVBQUUsSUFBSSxFQUFFLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztBQUMvRyx1QkFBdUI7QUFDQSwrQkFBUyxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxPQUFPLEVBQUUsSUFBSSxFQUFFLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztBQUMvRyx1QkFBdUI7QUFDQSwrQkFBUyxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxPQUFPLEVBQUUsSUFBSSxFQUFFLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztBQUMvRyx1QkFBdUI7QUFDQSwrQkFBUyxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxPQUFPLEVBQUUsSUFBSSxFQUFFLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztBQUMvRyx1QkFBdUI7QUFDQSwrQkFBUyxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxPQUFPLEVBQUUsSUFBSSxFQUFFLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztBQUUvRyw2RUFBNkU7QUFDdEQsNEJBQU0sR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsSUFBSSxFQUFFLElBQUksRUFBRSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsQ0FBQyxDQUFDO0FBQ3pGLHNCQUFzQjtBQUNDLDhCQUFRLEdBQUcscUJBQXFCLENBQUMsRUFBRSxDQUFDLE1BQU0sRUFBRSxJQUFJLEVBQUUsRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztBQUM3RixzQkFBc0I7QUFDQyw4QkFBUSxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxNQUFNLEVBQUUsSUFBSSxFQUFFLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxDQUFDLENBQUM7QUFDN0Ysc0JBQXNCO0FBQ0MsOEJBQVEsR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsTUFBTSxFQUFFLElBQUksRUFBRSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxDQUFDLENBQUM7QUFDN0csc0JBQXNCO0FBQ0MsOEJBQVEsR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsTUFBTSxFQUFFLElBQUksRUFBRSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxDQUFDLENBQUM7QUFDN0csc0JBQXNCO0FBQ0MsOEJBQVEsR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsTUFBTSxFQUFFLElBQUksRUFBRSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxDQUFDLENBQUM7QUFDN0csc0JBQXNCO0FBQ0MsOEJBQVEsR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsTUFBTSxFQUFFLElBQUksRUFBRSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxDQUFDLENBQUM7QUFDN0csc0JBQXNCO0FBQ0MsOEJBQVEsR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsTUFBTSxFQUFFLElBQUksRUFBRSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxDQUFDLENBQUM7QUFDN0csc0JBQXNCO0FBQ0MsOEJBQVEsR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsTUFBTSxFQUFFLElBQUksRUFBRSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxDQUFDLENBQUM7QUFDN0csdUJBQXVCO0FBQ0EsK0JBQVMsR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsT0FBTyxFQUFFLElBQUksRUFBRSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxDQUFDLENBQUM7QUFDL0csdUJBQXVCO0FBQ0EsK0JBQVMsR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsT0FBTyxFQUFFLElBQUksRUFBRSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxDQUFDLENBQUM7QUFDL0csdUJBQXVCO0FBQ0EsK0JBQVMsR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsT0FBTyxFQUFFLElBQUksRUFBRSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxDQUFDLENBQUM7QUFDL0csdUJBQXVCO0FBQ0EsK0JBQVMsR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsT0FBTyxFQUFFLElBQUksRUFBRSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxDQUFDLENBQUM7QUFDL0csdUJBQXVCO0FBQ0EsK0JBQVMsR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsT0FBTyxFQUFFLElBQUksRUFBRSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxDQUFDLENBQUM7QUFFL0csNkVBQTZFO0FBQ3RELDRCQUFNLEdBQUcscUJBQXFCLENBQUMsRUFBRSxDQUFDLElBQUksRUFBRSxJQUFJLEVBQUUsRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsQ0FBQyxDQUFDO0FBQ3pHLHNCQUFzQjtBQUNDLDhCQUFRLEdBQUcscUJBQXFCLENBQUMsRUFBRSxDQUFDLE1BQU0sRUFBRSxJQUFJLEVBQUUsRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsQ0FBQyxDQUFDO0FBQzdHLHNCQUFzQjtBQUNDLDhCQUFRLEdBQUcscUJBQXFCLENBQUMsRUFBRSxDQUFDLE1BQU0sRUFBRSxJQUFJLEVBQUUsRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsQ0FBQyxDQUFDO0FBQzdHLHNCQUFzQjtBQUNDLDhCQUFRLEdBQUcscUJBQXFCLENBQUMsRUFBRSxDQUFDLE1BQU0sRUFBRSxJQUFJLEVBQUUsRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsQ0FBQyxDQUFDO0FBQzdHLHNCQUFzQjtBQUNDLDhCQUFRLEdBQUcscUJBQXFCLENBQUMsRUFBRSxDQUFDLE1BQU0sRUFBRSxJQUFJLEVBQUUsRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsQ0FBQyxDQUFDO0FBQzdHLHNCQUFzQjtBQUNDLDhCQUFRLEdBQUcscUJBQXFCLENBQUMsRUFBRSxDQUFDLE1BQU0sRUFBRSxJQUFJLEVBQUUsRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsQ0FBQyxDQUFDO0FBQzdHLHNCQUFzQjtBQUNDLDhCQUFRLEdBQUcscUJBQXFCLENBQUMsRUFBRSxDQUFDLE1BQU0sRUFBRSxJQUFJLEVBQUUsRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsQ0FBQyxDQUFDO0FBQzdHLHNCQUFzQjtBQUNDLDhCQUFRLEdBQUcscUJBQXFCLENBQUMsRUFBRSxDQUFDLE1BQU0sRUFBRSxJQUFJLEVBQUUsRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsQ0FBQyxDQUFDO0FBQzdHLHNCQUFzQjtBQUNDLDhCQUFRLEdBQUcscUJBQXFCLENBQUMsRUFBRSxDQUFDLE1BQU0sRUFBRSxJQUFJLEVBQUUsRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsQ0FBQyxDQUFDO0FBQzdHLHNCQUFzQjtBQUNDLDhCQUFRLEdBQUcscUJBQXFCLENBQUMsRUFBRSxDQUFDLE1BQU0sRUFBRSxJQUFJLEVBQUUsRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsQ0FBQyxDQUFDO0FBQzdHLHVCQUF1QjtBQUNBLCtCQUFTLEdBQUcscUJBQXFCLENBQUMsRUFBRSxDQUFDLE9BQU8sRUFBRSxJQUFJLEVBQUUsRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsQ0FBQyxDQUFDO0FBRS9HLDZFQUE2RTtBQUN0RCw0QkFBTSxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxJQUFJLEVBQUUsSUFBSSxFQUFFLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztBQUN6RyxzQkFBc0I7QUFDQyw4QkFBUSxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxNQUFNLEVBQUUsSUFBSSxFQUFFLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztBQUM3RyxzQkFBc0I7QUFDQyw4QkFBUSxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxNQUFNLEVBQUUsSUFBSSxFQUFFLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztBQUM3RyxzQkFBc0I7QUFDQyw4QkFBUSxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxNQUFNLEVBQUUsSUFBSSxFQUFFLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztBQUM3RyxzQkFBc0I7QUFDQyw4QkFBUSxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxNQUFNLEVBQUUsSUFBSSxFQUFFLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztBQUM3RyxzQkFBc0I7QUFDQyw4QkFBUSxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxNQUFNLEVBQUUsSUFBSSxFQUFFLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztBQUM3RyxzQkFBc0I7QUFDQyw4QkFBUSxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxNQUFNLEVBQUUsSUFBSSxFQUFFLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztBQUM3RyxzQkFBc0I7QUFDQyw4QkFBUSxHQUFHLHFCQUFxQixDQUFDLEVBQUUsQ0FBQyxNQUFNLEVBQUUsSUFBSSxFQUFFLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztBQUU3Ryw2RUFBNkU7QUFDdEQsNEJBQU0sR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsSUFBSSxFQUFFLElBQUksRUFBRSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxDQUFDLENBQUM7QUFDekcsc0JBQXNCO0FBQ0MsOEJBQVEsR0FBRyxxQkFBcUIsQ0FBQyxFQUFFLENBQUMsTUFBTSxFQUFFLElBQUksRUFBRSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxDQUFDLENBQUM7QUFuYmxHLHNEQUFxQjtBQStkbEM7O0dBRUc7QUFDSCxNQUFNLHNCQUF1QixTQUFRLGtCQUFrQjtJQUdyRCxZQUFZLE9BQStCO1FBQ3pDLEtBQUssQ0FBQztZQUNKLFVBQVUsRUFBRSxVQUFVO1lBQ3RCLDZCQUE2QixFQUFFLGNBQWMsQ0FBQyx5QkFBeUIsQ0FBQyw2QkFBNkI7WUFDckcsNEJBQTRCLEVBQUUsY0FBYyxDQUFDLHlCQUF5QixDQUFDLDRCQUE0QjtZQUNuRyxPQUFPLEVBQUUsT0FBTztnQkFDZCxDQUFDLENBQUM7b0JBQ0EsV0FBVyxFQUFFLE9BQU8sQ0FBQyxtQkFBbUI7b0JBQ3hDLFlBQVksRUFBRSxPQUFPLENBQUMsb0JBQW9CO2lCQUMzQztnQkFDRCxDQUFDLENBQUMsU0FBUztZQUNiLFFBQVEsRUFBRSxPQUFPLENBQUMsQ0FBQyxDQUFDLE9BQU8sRUFBRSxTQUFTLENBQUMsQ0FBQyxDQUFDLEVBQUUsUUFBUSxFQUFFLFVBQVUsRUFBRTtZQUNqRSxZQUFZLEVBQUUsWUFBWTtTQUMzQixDQUFDLENBQUM7UUFmVyxvQkFBZSxHQUFHLFVBQVUsQ0FBQztLQWdCNUM7Q0FDRjtBQUVEOzs7Ozs7O0dBT0c7QUFDSCxNQUFhLHlCQUF5QjtJQXNENUIsTUFBTSxDQUFDLEVBQUUsQ0FBQyx1QkFBK0IsRUFBRSx3QkFBZ0M7UUFDakYsT0FBTyxJQUFJLHlCQUF5QixDQUFDLHVCQUF1QixFQUFFLHdCQUF3QixDQUFDLENBQUM7S0FDekY7SUFPRCxZQUFvQix1QkFBK0IsRUFBRSx3QkFBZ0M7UUFDbkYsSUFBSSxDQUFDLHVCQUF1QixHQUFHLHVCQUF1QixDQUFDO1FBQ3ZELElBQUksQ0FBQyx3QkFBd0IsR0FBRyx3QkFBd0IsQ0FBQztLQUMxRDs7OztBQWpFRCwrRUFBK0U7QUFDeEQsa0NBQVEsR0FBRyx5QkFBeUIsQ0FBQyxFQUFFLENBQUMsTUFBTSxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQy9FLDZCQUE2QjtBQUNOLHlDQUFlLEdBQUcseUJBQXlCLENBQUMsRUFBRSxDQUFDLGFBQWEsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUM3Riw2QkFBNkI7QUFDTix5Q0FBZSxHQUFHLHlCQUF5QixDQUFDLEVBQUUsQ0FBQyxhQUFhLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDN0YsNkJBQTZCO0FBQ04seUNBQWUsR0FBRyx5QkFBeUIsQ0FBQyxFQUFFLENBQUMsYUFBYSxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQzdGLDZCQUE2QjtBQUNOLHlDQUFlLEdBQUcseUJBQXlCLENBQUMsRUFBRSxDQUFDLGFBQWEsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUM3Riw2QkFBNkI7QUFDTix5Q0FBZSxHQUFHLHlCQUF5QixDQUFDLEVBQUUsQ0FBQyxhQUFhLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDN0YsNkJBQTZCO0FBQ04seUNBQWUsR0FBRyx5QkFBeUIsQ0FBQyxFQUFFLENBQUMsYUFBYSxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQzdGLDZCQUE2QjtBQUNOLHlDQUFlLEdBQUcseUJBQXlCLENBQUMsRUFBRSxDQUFDLGFBQWEsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUM3Riw2QkFBNkI7QUFDTix5Q0FBZSxHQUFHLHlCQUF5QixDQUFDLEVBQUUsQ0FBQyxhQUFhLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDN0YsNkJBQTZCO0FBQ04seUNBQWUsR0FBRyx5QkFBeUIsQ0FBQyxFQUFFLENBQUMsYUFBYSxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQzdGLDhCQUE4QjtBQUNQLDBDQUFnQixHQUFHLHlCQUF5QixDQUFDLEVBQUUsQ0FBQyxjQUFjLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDL0YsOEJBQThCO0FBQ1AsMENBQWdCLEdBQUcseUJBQXlCLENBQUMsRUFBRSxDQUFDLGNBQWMsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUMvRiw4QkFBOEI7QUFDUCwwQ0FBZ0IsR0FBRyx5QkFBeUIsQ0FBQyxFQUFFLENBQUMsY0FBYyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQy9GLDhCQUE4QjtBQUNQLDBDQUFnQixHQUFHLHlCQUF5QixDQUFDLEVBQUUsQ0FBQyxjQUFjLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDL0YsOEJBQThCO0FBQ1AsMENBQWdCLEdBQUcseUJBQXlCLENBQUMsRUFBRSxDQUFDLGNBQWMsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUMvRiw4QkFBOEI7QUFDUCwwQ0FBZ0IsR0FBRyx5QkFBeUIsQ0FBQyxFQUFFLENBQUMsY0FBYyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQy9GLDhCQUE4QjtBQUNQLDBDQUFnQixHQUFHLHlCQUF5QixDQUFDLEVBQUUsQ0FBQyxjQUFjLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDL0YsOEJBQThCO0FBQ1AsMENBQWdCLEdBQUcseUJBQXlCLENBQUMsRUFBRSxDQUFDLGNBQWMsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUMvRiw4QkFBOEI7QUFDUCwwQ0FBZ0IsR0FBRyx5QkFBeUIsQ0FBQyxFQUFFLENBQUMsY0FBYyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQy9GLDhCQUE4QjtBQUNQLDBDQUFnQixHQUFHLHlCQUF5QixDQUFDLEVBQUUsQ0FBQyxjQUFjLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDL0YsOEJBQThCO0FBQ1AsMENBQWdCLEdBQUcseUJBQXlCLENBQUMsRUFBRSxDQUFDLGNBQWMsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUMvRiw4QkFBOEI7QUFDUCwwQ0FBZ0IsR0FBRyx5QkFBeUIsQ0FBQyxFQUFFLENBQUMsY0FBYyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQy9GLDhCQUE4QjtBQUNQLDBDQUFnQixHQUFHLHlCQUF5QixDQUFDLEVBQUUsQ0FBQyxjQUFjLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDL0YsOEJBQThCO0FBQ1AsMENBQWdCLEdBQUcseUJBQXlCLENBQUMsRUFBRSxDQUFDLGNBQWMsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUMvRiw4QkFBOEI7QUFDUCwwQ0FBZ0IsR0FBRyx5QkFBeUIsQ0FBQyxFQUFFLENBQUMsY0FBYyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQy9GLDhCQUE4QjtBQUNQLDBDQUFnQixHQUFHLHlCQUF5QixDQUFDLEVBQUUsQ0FBQyxjQUFjLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFwRHBGLDhEQUF5QjtBQXFFdEM7Ozs7Ozs7R0FPRztBQUNILE1BQWEsbUJBQW1CO0lBZ0s5Qjs7Ozs7OztPQU9HO0lBQ0ksTUFBTSxDQUFDLEVBQUUsQ0FBQyxpQkFBeUIsRUFBRSxrQkFBMEI7UUFDcEUsT0FBTyxJQUFJLG1CQUFtQixDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixDQUFDLENBQUM7S0FDdkU7SUFPRCxZQUFvQixpQkFBeUIsRUFBRSxrQkFBMEI7UUFDdkUsSUFBSSxDQUFDLGlCQUFpQixHQUFHLGlCQUFpQixDQUFDO1FBQzNDLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxrQkFBa0IsQ0FBQztLQUM5Qzs7OztBQW5MRCwrRUFBK0U7QUFDeEQsNEJBQVEsR0FBRyxtQkFBbUIsQ0FBQyxFQUFFLENBQUMsTUFBTSxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQ3pFLDZCQUE2QjtBQUNOLG1DQUFlLEdBQUcsbUJBQW1CLENBQUMsRUFBRSxDQUFDLGFBQWEsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUN2Riw2QkFBNkI7QUFDTixtQ0FBZSxHQUFHLG1CQUFtQixDQUFDLEVBQUUsQ0FBQyxhQUFhLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDdkYsNkJBQTZCO0FBQ04sbUNBQWUsR0FBRyxtQkFBbUIsQ0FBQyxFQUFFLENBQUMsYUFBYSxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQ3ZGLDZCQUE2QjtBQUNOLG1DQUFlLEdBQUcsbUJBQW1CLENBQUMsRUFBRSxDQUFDLGFBQWEsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUN2Riw2QkFBNkI7QUFDTixtQ0FBZSxHQUFHLG1CQUFtQixDQUFDLEVBQUUsQ0FBQyxhQUFhLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDdkYsNkJBQTZCO0FBQ04sbUNBQWUsR0FBRyxtQkFBbUIsQ0FBQyxFQUFFLENBQUMsYUFBYSxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQ3ZGLDZCQUE2QjtBQUNOLG1DQUFlLEdBQUcsbUJBQW1CLENBQUMsRUFBRSxDQUFDLGFBQWEsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUN2Riw2QkFBNkI7QUFDTixtQ0FBZSxHQUFHLG1CQUFtQixDQUFDLEVBQUUsQ0FBQyxhQUFhLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDdkYsNkJBQTZCO0FBQ04sbUNBQWUsR0FBRyxtQkFBbUIsQ0FBQyxFQUFFLENBQUMsYUFBYSxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQ3ZGLDhCQUE4QjtBQUNQLG9DQUFnQixHQUFHLG1CQUFtQixDQUFDLEVBQUUsQ0FBQyxjQUFjLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDekYsOEJBQThCO0FBQ1Asb0NBQWdCLEdBQUcsbUJBQW1CLENBQUMsRUFBRSxDQUFDLGNBQWMsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUN6Riw4QkFBOEI7QUFDUCxvQ0FBZ0IsR0FBRyxtQkFBbUIsQ0FBQyxFQUFFLENBQUMsY0FBYyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQ3pGLDhCQUE4QjtBQUNQLG9DQUFnQixHQUFHLG1CQUFtQixDQUFDLEVBQUUsQ0FBQyxjQUFjLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDekYsOEJBQThCO0FBQ1Asb0NBQWdCLEdBQUcsbUJBQW1CLENBQUMsRUFBRSxDQUFDLGNBQWMsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUN6Riw4QkFBOEI7QUFDUCxvQ0FBZ0IsR0FBRyxtQkFBbUIsQ0FBQyxFQUFFLENBQUMsY0FBYyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQ3pGLDhCQUE4QjtBQUNQLG9DQUFnQixHQUFHLG1CQUFtQixDQUFDLEVBQUUsQ0FBQyxjQUFjLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDekYsOEJBQThCO0FBQ1Asb0NBQWdCLEdBQUcsbUJBQW1CLENBQUMsRUFBRSxDQUFDLGNBQWMsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUN6Riw4QkFBOEI7QUFDUCxvQ0FBZ0IsR0FBRyxtQkFBbUIsQ0FBQyxFQUFFLENBQUMsY0FBYyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQ3pGLDhCQUE4QjtBQUNQLG9DQUFnQixHQUFHLG1CQUFtQixDQUFDLEVBQUUsQ0FBQyxjQUFjLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDekYsOEJBQThCO0FBQ1Asb0NBQWdCLEdBQUcsbUJBQW1CLENBQUMsRUFBRSxDQUFDLGNBQWMsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUN6Riw4QkFBOEI7QUFDUCxvQ0FBZ0IsR0FBRyxtQkFBbUIsQ0FBQyxFQUFFLENBQUMsY0FBYyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQ3pGLDhCQUE4QjtBQUNQLG9DQUFnQixHQUFHLG1CQUFtQixDQUFDLEVBQUUsQ0FBQyxjQUFjLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDekYsOEJBQThCO0FBQ1Asb0NBQWdCLEdBQUcsbUJBQW1CLENBQUMsRUFBRSxDQUFDLGNBQWMsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUN6Riw4QkFBOEI7QUFDUCxvQ0FBZ0IsR0FBRyxtQkFBbUIsQ0FBQyxFQUFFLENBQUMsY0FBYyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQ3pGLDhCQUE4QjtBQUNQLG9DQUFnQixHQUFHLG1CQUFtQixDQUFDLEVBQUUsQ0FBQyxjQUFjLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDekYsOEJBQThCO0FBQ1Asb0NBQWdCLEdBQUcsbUJBQW1CLENBQUMsRUFBRSxDQUFDLGNBQWMsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUN6Riw4QkFBOEI7QUFDUCxvQ0FBZ0IsR0FBRyxtQkFBbUIsQ0FBQyxFQUFFLENBQUMsY0FBYyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQ3pGLDhCQUE4QjtBQUNQLG9DQUFnQixHQUFHLG1CQUFtQixDQUFDLEVBQUUsQ0FBQyxjQUFjLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDekYsOEJBQThCO0FBQ1Asb0NBQWdCLEdBQUcsbUJBQW1CLENBQUMsRUFBRSxDQUFDLGNBQWMsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUV6RiwrRUFBK0U7QUFDeEQsNEJBQVEsR0FBRyxtQkFBbUIsQ0FBQyxFQUFFLENBQUMsTUFBTSxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQ3pFLG9EQUFvRDtBQUM3QiwyQ0FBdUIsR0FBRyxtQkFBbUIsQ0FBQyxFQUFFLENBQUMsb0NBQW9DLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDdEgsb0RBQW9EO0FBQzdCLDJDQUF1QixHQUFHLG1CQUFtQixDQUFDLEVBQUUsQ0FBQyxvQ0FBb0MsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUN0SCxvREFBb0Q7QUFDN0IsMkNBQXVCLEdBQUcsbUJBQW1CLENBQUMsRUFBRSxDQUFDLG9DQUFvQyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQ3RILG9EQUFvRDtBQUM3QiwyQ0FBdUIsR0FBRyxtQkFBbUIsQ0FBQyxFQUFFLENBQUMsb0NBQW9DLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDdEgsb0RBQW9EO0FBQzdCLDJDQUF1QixHQUFHLG1CQUFtQixDQUFDLEVBQUUsQ0FBQyxvQ0FBb0MsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUN0SCxvREFBb0Q7QUFDN0IsMkNBQXVCLEdBQUcsbUJBQW1CLENBQUMsRUFBRSxDQUFDLG9DQUFvQyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQ3RILG9EQUFvRDtBQUM3QiwyQ0FBdUIsR0FBRyxtQkFBbUIsQ0FBQyxFQUFFLENBQUMsb0NBQW9DLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDdEgsb0RBQW9EO0FBQzdCLDJDQUF1QixHQUFHLG1CQUFtQixDQUFDLEVBQUUsQ0FBQyxvQ0FBb0MsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUN0SCxvREFBb0Q7QUFDN0IsMkNBQXVCLEdBQUcsbUJBQW1CLENBQUMsRUFBRSxDQUFDLG9DQUFvQyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQ3RILG9EQUFvRDtBQUM3QiwyQ0FBdUIsR0FBRyxtQkFBbUIsQ0FBQyxFQUFFLENBQUMsb0NBQW9DLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDdEgsb0RBQW9EO0FBQzdCLDJDQUF1QixHQUFHLG1CQUFtQixDQUFDLEVBQUUsQ0FBQyxvQ0FBb0MsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUN0SCxvREFBb0Q7QUFDN0IsMkNBQXVCLEdBQUcsbUJBQW1CLENBQUMsRUFBRSxDQUFDLG9DQUFvQyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQ3RILG9EQUFvRDtBQUM3QiwyQ0FBdUIsR0FBRyxtQkFBbUIsQ0FBQyxFQUFFLENBQUMsb0NBQW9DLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDdEgsb0RBQW9EO0FBQzdCLDJDQUF1QixHQUFHLG1CQUFtQixDQUFDLEVBQUUsQ0FBQyxvQ0FBb0MsRUFBRSxNQUFNLENBQUMsQ0FBQztBQUV0SCw2RUFBNkU7QUFDdEQsMEJBQU0sR0FBRyxtQkFBbUIsQ0FBQyxFQUFFLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxDQUFDO0FBQ25FLG9EQUFvRDtBQUM3QiwyQ0FBdUIsR0FBRyxtQkFBbUIsQ0FBQyxFQUFFLENBQUMsb0NBQW9DLEVBQUUsSUFBSSxDQUFDLENBQUM7QUFDcEgsb0RBQW9EO0FBQzdCLDJDQUF1QixHQUFHLG1CQUFtQixDQUFDLEVBQUUsQ0FBQyxvQ0FBb0MsRUFBRSxJQUFJLENBQUMsQ0FBQztBQUNwSCxvREFBb0Q7QUFDN0IsMkNBQXVCLEdBQUcsbUJBQW1CLENBQUMsRUFBRSxDQUFDLG9DQUFvQyxFQUFFLElBQUksQ0FBQyxDQUFDO0FBQ3BILG9EQUFvRDtBQUM3QiwyQ0FBdUIsR0FBRyxtQkFBbUIsQ0FBQyxFQUFFLENBQUMsb0NBQW9DLEVBQUUsSUFBSSxDQUFDLENBQUM7QUFDcEgsb0RBQW9EO0FBQzdCLDJDQUF1QixHQUFHLG1CQUFtQixDQUFDLEVBQUUsQ0FBQyxvQ0FBb0MsRUFBRSxJQUFJLENBQUMsQ0FBQztBQUNwSCxvREFBb0Q7QUFDN0IsMkNBQXVCLEdBQUcsbUJBQW1CLENBQUMsRUFBRSxDQUFDLG9DQUFvQyxFQUFFLElBQUksQ0FBQyxDQUFDO0FBQ3BILG9EQUFvRDtBQUM3QiwyQ0FBdUIsR0FBRyxtQkFBbUIsQ0FBQyxFQUFFLENBQUMsb0NBQW9DLEVBQUUsSUFBSSxDQUFDLENBQUM7QUFDcEgsb0RBQW9EO0FBQzdCLDJDQUF1QixHQUFHLG1CQUFtQixDQUFDLEVBQUUsQ0FBQyxvQ0FBb0MsRUFBRSxJQUFJLENBQUMsQ0FBQztBQUVwSCw2RUFBNkU7QUFDdEQsMEJBQU0sR0FBRyxtQkFBbUIsQ0FBQyxFQUFFLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxDQUFDO0FBQ25FLG9EQUFvRDtBQUM3QiwyQ0FBdUIsR0FBRyxtQkFBbUIsQ0FBQyxFQUFFLENBQUMsb0NBQW9DLEVBQUUsSUFBSSxDQUFDLENBQUM7QUFDcEgsb0RBQW9EO0FBQzdCLDJDQUF1QixHQUFHLG1CQUFtQixDQUFDLEVBQUUsQ0FBQyxvQ0FBb0MsRUFBRSxJQUFJLENBQUMsQ0FBQztBQUNwSCxvREFBb0Q7QUFDN0IsMkNBQXVCLEdBQUcsbUJBQW1CLENBQUMsRUFBRSxDQUFDLG9DQUFvQyxFQUFFLElBQUksQ0FBQyxDQUFDO0FBQ3BILG9EQUFvRDtBQUM3QiwyQ0FBdUIsR0FBRyxtQkFBbUIsQ0FBQyxFQUFFLENBQUMsb0NBQW9DLEVBQUUsSUFBSSxDQUFDLENBQUM7QUFDcEgsb0RBQW9EO0FBQzdCLDJDQUF1QixHQUFHLG1CQUFtQixDQUFDLEVBQUUsQ0FBQyxvQ0FBb0MsRUFBRSxJQUFJLENBQUMsQ0FBQztBQUNwSCxvREFBb0Q7QUFDN0IsMkNBQXVCLEdBQUcsbUJBQW1CLENBQUMsRUFBRSxDQUFDLG9DQUFvQyxFQUFFLElBQUksQ0FBQyxDQUFDO0FBQ3BILG9EQUFvRDtBQUM3QiwyQ0FBdUIsR0FBRyxtQkFBbUIsQ0FBQyxFQUFFLENBQUMsb0NBQW9DLEVBQUUsSUFBSSxDQUFDLENBQUM7QUFDcEgsb0RBQW9EO0FBQzdCLDJDQUF1QixHQUFHLG1CQUFtQixDQUFDLEVBQUUsQ0FBQyxvQ0FBb0MsRUFBRSxJQUFJLENBQUMsQ0FBQztBQUNwSCxvREFBb0Q7QUFDN0IsMkNBQXVCLEdBQUcsbUJBQW1CLENBQUMsRUFBRSxDQUFDLG9DQUFvQyxFQUFFLElBQUksQ0FBQyxDQUFDO0FBQ3BILG9EQUFvRDtBQUM3QiwyQ0FBdUIsR0FBRyxtQkFBbUIsQ0FBQyxFQUFFLENBQUMsb0NBQW9DLEVBQUUsSUFBSSxDQUFDLENBQUM7QUFDcEgsb0RBQW9EO0FBQzdCLDJDQUF1QixHQUFHLG1CQUFtQixDQUFDLEVBQUUsQ0FBQyxvQ0FBb0MsRUFBRSxJQUFJLENBQUMsQ0FBQztBQUNwSCxvREFBb0Q7QUFDN0IsMkNBQXVCLEdBQUcsbUJBQW1CLENBQUMsRUFBRSxDQUFDLG9DQUFvQyxFQUFFLElBQUksQ0FBQyxDQUFDO0FBQ3BILG9EQUFvRDtBQUM3QiwyQ0FBdUIsR0FBRyxtQkFBbUIsQ0FBQyxFQUFFLENBQUMsb0NBQW9DLEVBQUUsSUFBSSxDQUFDLENBQUM7QUFDcEgsb0RBQW9EO0FBQzdCLDJDQUF1QixHQUFHLG1CQUFtQixDQUFDLEVBQUUsQ0FBQyxvQ0FBb0MsRUFBRSxJQUFJLENBQUMsQ0FBQztBQUNwSCxvREFBb0Q7QUFDN0IsMkNBQXVCLEdBQUcsbUJBQW1CLENBQUMsRUFBRSxDQUFDLG9DQUFvQyxFQUFFLElBQUksQ0FBQyxDQUFDO0FBQ3BILG9EQUFvRDtBQUM3QiwyQ0FBdUIsR0FBRyxtQkFBbUIsQ0FBQyxFQUFFLENBQUMsb0NBQW9DLEVBQUUsSUFBSSxDQUFDLENBQUM7QUFFcEgsNkVBQTZFO0FBQ3RELDBCQUFNLEdBQUcsbUJBQW1CLENBQUMsRUFBRSxDQUFDLElBQUksRUFBRSxJQUFJLENBQUMsQ0FBQztBQUNuRSxvREFBb0Q7QUFDN0IsMkNBQXVCLEdBQUcsbUJBQW1CLENBQUMsRUFBRSxDQUFDLG9DQUFvQyxFQUFFLElBQUksQ0FBQyxDQUFDO0FBQ3BILG9EQUFvRDtBQUM3QiwyQ0FBdUIsR0FBRyxtQkFBbUIsQ0FBQyxFQUFFLENBQUMsb0NBQW9DLEVBQUUsSUFBSSxDQUFDLENBQUM7QUFDcEgsb0RBQW9EO0FBQzdCLDJDQUF1QixHQUFHLG1CQUFtQixDQUFDLEVBQUUsQ0FBQyxvQ0FBb0MsRUFBRSxJQUFJLENBQUMsQ0FBQztBQUNwSCxvREFBb0Q7QUFDN0IsMkNBQXVCLEdBQUcsbUJBQW1CLENBQUMsRUFBRSxDQUFDLG9DQUFvQyxFQUFFLElBQUksQ0FBQyxDQUFDO0FBQ3BILG9EQUFvRDtBQUM3QiwyQ0FBdUIsR0FBRyxtQkFBbUIsQ0FBQyxFQUFFLENBQUMsb0NBQW9DLEVBQUUsSUFBSSxDQUFDLENBQUM7QUE5SnpHLGtEQUFtQjtBQTRMaEMsTUFBZSx3QkFBeUIsU0FBUSxrQkFBa0I7SUFDaEUsWUFBWSxLQUFvQztRQUM5QyxLQUFLLENBQUM7WUFDSixHQUFHLEtBQUs7WUFDUiw2QkFBNkIsRUFBRSxjQUFjLENBQUMseUJBQXlCLENBQUMsMkJBQTJCO1lBQ25HLDRCQUE0QixFQUFFLGNBQWMsQ0FBQyx5QkFBeUIsQ0FBQywwQkFBMEI7WUFDakcsb0JBQW9CLEVBQUUsS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsR0FBRyxLQUFLLENBQUMsVUFBVSxJQUFJLEtBQUssQ0FBQyxPQUFPLENBQUMsWUFBWSxFQUFFLENBQUMsQ0FBQyxDQUFDLFNBQVM7WUFDckcsUUFBUSxFQUFFO2dCQUNSLFFBQVEsRUFBRSxnQkFBZ0I7Z0JBQzFCLFFBQVEsRUFBRSxnQkFBZ0I7YUFDM0I7U0FDRixDQUFDLENBQUM7S0FDSjtJQUVNLGNBQWMsQ0FBQyxLQUFnQixFQUFFLE9BQWtDO1FBQ3hFLE1BQU0sTUFBTSxHQUFHLEtBQUssQ0FBQyxjQUFjLENBQUMsS0FBSyxFQUFFLE9BQU8sQ0FBQyxDQUFDO1FBRXBELElBQUksV0FBVyxHQUFHLE9BQU8sQ0FBQyxXQUFXLENBQUM7UUFDdEMsSUFBSSxPQUFPLENBQUMsWUFBWSxJQUFJLE9BQU8sQ0FBQyxZQUFZLEVBQUU7WUFDaEQsSUFBSSxDQUFDLFdBQVcsRUFBRTtnQkFDaEIsV0FBVyxHQUFHLElBQUksMEJBQVcsQ0FBQyxLQUFLLEVBQUUscUJBQXFCLEVBQUU7b0JBQzFELE1BQU0sRUFBRSxJQUFJO29CQUNaLGNBQWMsRUFBRSxFQUFFO2lCQUNuQixDQUFDLENBQUM7YUFDSjtZQUNELG9GQUFvRjtZQUNwRixXQUFXLENBQUMsZ0JBQWdCLENBQUM7Z0JBQzNCLElBQUksRUFBRSxnQkFBZ0I7Z0JBQ3RCLE9BQU8sRUFBRSxLQUFLO2FBQ2YsQ0FBQyxDQUFDO1NBQ0o7UUFFRCxPQUFPO1lBQ0wsR0FBRyxNQUFNO1lBQ1QsV0FBVztTQUNaLENBQUM7S0FDSDtDQUNGO0FBa0JELDZIQUE2SDtBQUM3SCxNQUFNLHNCQUF1QixTQUFRLHdCQUF3QjtJQUMzRCxZQUFZLE9BQW1DO1FBQzdDLEtBQUssQ0FBQztZQUNKLFVBQVUsRUFBRSxXQUFXO1lBQ3ZCLE9BQU8sRUFBRSxPQUFPO2dCQUNkLENBQUMsQ0FBQztvQkFDQSxXQUFXLEVBQUUsT0FBTyxDQUFDLHVCQUF1QjtvQkFDNUMsWUFBWSxFQUFFLE9BQU8sQ0FBQyx3QkFBd0I7aUJBQy9DO2dCQUNELENBQUMsQ0FBQztvQkFDQSxZQUFZLEVBQUUsTUFBTTtpQkFDckI7U0FDSixDQUFDLENBQUM7S0FDSjtDQUNGO0FBYUQsNkhBQTZIO0FBQzdILE1BQU0sdUJBQXdCLFNBQVEsd0JBQXdCO0lBQzVELFlBQVksT0FBbUM7UUFDN0MsS0FBSyxDQUFDO1lBQ0osVUFBVSxFQUFFLFlBQVk7WUFDeEIsT0FBTyxFQUFFLE9BQU87Z0JBQ2QsQ0FBQyxDQUFDO29CQUNBLFdBQVcsRUFBRSxPQUFPLENBQUMsdUJBQXVCO29CQUM1QyxZQUFZLEVBQUUsT0FBTyxDQUFDLHdCQUF3QjtpQkFDL0M7Z0JBQ0QsQ0FBQyxDQUFDO29CQUNBLFlBQVksRUFBRSxNQUFNO2lCQUNyQjtTQUNKLENBQUMsQ0FBQztLQUNKO0NBQ0Y7QUFTRCxNQUFNLHVCQUF3QixTQUFRLHdCQUF3QjtJQUM1RCxZQUFZLE9BQTZCO1FBQ3ZDLEtBQUssQ0FBQztZQUNKLFVBQVUsRUFBRSxZQUFZO1lBQ3hCLE9BQU8sRUFBRSxPQUFPO2dCQUNkLENBQUMsQ0FBQztvQkFDQSxXQUFXLEVBQUUsT0FBTyxDQUFDLGlCQUFpQjtvQkFDdEMsWUFBWSxFQUFFLE9BQU8sQ0FBQyxrQkFBa0I7aUJBQ3pDO2dCQUNELENBQUMsQ0FBQyxTQUFTO1NBQ2QsQ0FBQyxDQUFDO0tBQ0o7Q0FDRjtBQVNELE1BQU0sMEJBQTJCLFNBQVEsd0JBQXdCO0lBQy9ELFlBQVksT0FBNkI7UUFDdkMsS0FBSyxDQUFDO1lBQ0osVUFBVSxFQUFFLGdCQUFnQjtZQUM1QixPQUFPLEVBQUUsT0FBTztnQkFDZCxDQUFDLENBQUM7b0JBQ0EsV0FBVyxFQUFFLE9BQU8sQ0FBQyxpQkFBaUI7b0JBQ3RDLFlBQVksRUFBRSxPQUFPLENBQUMsa0JBQWtCO2lCQUN6QztnQkFDRCxDQUFDLENBQUMsU0FBUztTQUNkLENBQUMsQ0FBQztLQUNKO0NBQ0Y7QUFTRCxNQUFNLHNCQUF1QixTQUFRLHdCQUF3QjtJQUMzRCxZQUFZLE9BQTZCO1FBQ3ZDLEtBQUssQ0FBQztZQUNKLFVBQVUsRUFBRSxXQUFXO1lBQ3ZCLE9BQU8sRUFBRSxPQUFPO2dCQUNkLENBQUMsQ0FBQztvQkFDQSxXQUFXLEVBQUUsT0FBTyxDQUFDLGlCQUFpQjtvQkFDdEMsWUFBWSxFQUFFLE9BQU8sQ0FBQyxrQkFBa0I7aUJBQ3pDO2dCQUNELENBQUMsQ0FBQyxTQUFTO1NBQ2QsQ0FBQyxDQUFDO0tBQ0o7Q0FDRjtBQVNELE1BQU0seUJBQTBCLFNBQVEsd0JBQXdCO0lBQzlELFlBQVksT0FBNkI7UUFDdkMsS0FBSyxDQUFDO1lBQ0osVUFBVSxFQUFFLGVBQWU7WUFDM0IsT0FBTyxFQUFFLE9BQU87Z0JBQ2QsQ0FBQyxDQUFDO29CQUNBLFdBQVcsRUFBRSxPQUFPLENBQUMsaUJBQWlCO29CQUN0QyxZQUFZLEVBQUUsT0FBTyxDQUFDLGtCQUFrQjtpQkFDekM7Z0JBQ0QsQ0FBQyxDQUFDLFNBQVM7U0FDZCxDQUFDLENBQUM7S0FDSjtDQUNGO0FBRUQ7Ozs7O0dBS0c7QUFDSCxNQUFhLHNCQUFzQjtJQW1IakM7Ozs7Ozs7T0FPRztJQUNJLE1BQU0sQ0FBQyxFQUFFLENBQUMsb0JBQTRCLEVBQUUscUJBQTZCO1FBQzFFLE9BQU8sSUFBSSxzQkFBc0IsQ0FBQyxvQkFBb0IsRUFBRSxxQkFBcUIsQ0FBQyxDQUFDO0tBQ2hGO0lBT0QsWUFBb0Isb0JBQTRCLEVBQUUscUJBQTZCO1FBQzdFLElBQUksQ0FBQyxvQkFBb0IsR0FBRyxvQkFBb0IsQ0FBQztRQUNqRCxJQUFJLENBQUMscUJBQXFCLEdBQUcscUJBQXFCLENBQUM7S0FDcEQ7Ozs7QUF0SUQsZ0ZBQWdGO0FBQ3pELDZCQUFNLEdBQUcsc0JBQXNCLENBQUMsRUFBRSxDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUMsQ0FBQztBQUM1RSxpQ0FBaUM7QUFDViwwQ0FBbUIsR0FBRyxzQkFBc0IsQ0FBQyxFQUFFLENBQUMsaUJBQWlCLEVBQUUsT0FBTyxDQUFDLENBQUM7QUFDbkcsaUNBQWlDO0FBQ1YsMENBQW1CLEdBQUcsc0JBQXNCLENBQUMsRUFBRSxDQUFDLGlCQUFpQixFQUFFLE9BQU8sQ0FBQyxDQUFDO0FBQ25HLGlDQUFpQztBQUNWLDBDQUFtQixHQUFHLHNCQUFzQixDQUFDLEVBQUUsQ0FBQyxpQkFBaUIsRUFBRSxPQUFPLENBQUMsQ0FBQztBQUNuRyxpQ0FBaUM7QUFDViwwQ0FBbUIsR0FBRyxzQkFBc0IsQ0FBQyxFQUFFLENBQUMsaUJBQWlCLEVBQUUsT0FBTyxDQUFDLENBQUM7QUFDbkcsaUNBQWlDO0FBQ1YsMENBQW1CLEdBQUcsc0JBQXNCLENBQUMsRUFBRSxDQUFDLGlCQUFpQixFQUFFLE9BQU8sQ0FBQyxDQUFDO0FBRW5HLGdGQUFnRjtBQUN6RCw2QkFBTSxHQUFHLHNCQUFzQixDQUFDLEVBQUUsQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLENBQUM7QUFDNUUsaUNBQWlDO0FBQ1YsMENBQW1CLEdBQUcsc0JBQXNCLENBQUMsRUFBRSxDQUFDLGlCQUFpQixFQUFFLE9BQU8sQ0FBQyxDQUFDO0FBQ25HLGlDQUFpQztBQUNWLDBDQUFtQixHQUFHLHNCQUFzQixDQUFDLEVBQUUsQ0FBQyxpQkFBaUIsRUFBRSxPQUFPLENBQUMsQ0FBQztBQUNuRyxpQ0FBaUM7QUFDViwwQ0FBbUIsR0FBRyxzQkFBc0IsQ0FBQyxFQUFFLENBQUMsaUJBQWlCLEVBQUUsT0FBTyxDQUFDLENBQUM7QUFDbkcsaUNBQWlDO0FBQ1YsMENBQW1CLEdBQUcsc0JBQXNCLENBQUMsRUFBRSxDQUFDLGlCQUFpQixFQUFFLE9BQU8sQ0FBQyxDQUFDO0FBQ25HLGlDQUFpQztBQUNWLDBDQUFtQixHQUFHLHNCQUFzQixDQUFDLEVBQUUsQ0FBQyxpQkFBaUIsRUFBRSxPQUFPLENBQUMsQ0FBQztBQUNuRyxpQ0FBaUM7QUFDViwwQ0FBbUIsR0FBRyxzQkFBc0IsQ0FBQyxFQUFFLENBQUMsaUJBQWlCLEVBQUUsT0FBTyxDQUFDLENBQUM7QUFDbkcsa0NBQWtDO0FBQ1gsMkNBQW9CLEdBQUcsc0JBQXNCLENBQUMsRUFBRSxDQUFDLGtCQUFrQixFQUFFLE9BQU8sQ0FBQyxDQUFDO0FBRXJHLGdGQUFnRjtBQUN6RCw2QkFBTSxHQUFHLHNCQUFzQixDQUFDLEVBQUUsQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLENBQUM7QUFDNUUsaUNBQWlDO0FBQ1YsMENBQW1CLEdBQUcsc0JBQXNCLENBQUMsRUFBRSxDQUFDLGlCQUFpQixFQUFFLE9BQU8sQ0FBQyxDQUFDO0FBQ25HLGlDQUFpQztBQUNWLDBDQUFtQixHQUFHLHNCQUFzQixDQUFDLEVBQUUsQ0FBQyxpQkFBaUIsRUFBRSxPQUFPLENBQUMsQ0FBQztBQUNuRyxpQ0FBaUM7QUFDViwwQ0FBbUIsR0FBRyxzQkFBc0IsQ0FBQyxFQUFFLENBQUMsaUJBQWlCLEVBQUUsT0FBTyxDQUFDLENBQUM7QUFDbkcsaUNBQWlDO0FBQ1YsMENBQW1CLEdBQUcsc0JBQXNCLENBQUMsRUFBRSxDQUFDLGlCQUFpQixFQUFFLE9BQU8sQ0FBQyxDQUFDO0FBQ25HLGlDQUFpQztBQUNWLDBDQUFtQixHQUFHLHNCQUFzQixDQUFDLEVBQUUsQ0FBQyxpQkFBaUIsRUFBRSxPQUFPLENBQUMsQ0FBQztBQUNuRyxpQ0FBaUM7QUFDViwwQ0FBbUIsR0FBRyxzQkFBc0IsQ0FBQyxFQUFFLENBQUMsaUJBQWlCLEVBQUUsT0FBTyxDQUFDLENBQUM7QUFDbkcsaUNBQWlDO0FBQ1YsMENBQW1CLEdBQUcsc0JBQXNCLENBQUMsRUFBRSxDQUFDLGlCQUFpQixFQUFFLE9BQU8sQ0FBQyxDQUFDO0FBQ25HLGlDQUFpQztBQUNWLDBDQUFtQixHQUFHLHNCQUFzQixDQUFDLEVBQUUsQ0FBQyxpQkFBaUIsRUFBRSxPQUFPLENBQUMsQ0FBQztBQUNuRyxpQ0FBaUM7QUFDViwwQ0FBbUIsR0FBRyxzQkFBc0IsQ0FBQyxFQUFFLENBQUMsaUJBQWlCLEVBQUUsT0FBTyxDQUFDLENBQUM7QUFDbkcsa0NBQWtDO0FBQ1gsMkNBQW9CLEdBQUcsc0JBQXNCLENBQUMsRUFBRSxDQUFDLGtCQUFrQixFQUFFLE9BQU8sQ0FBQyxDQUFDO0FBQ3JHLGtDQUFrQztBQUNYLDJDQUFvQixHQUFHLHNCQUFzQixDQUFDLEVBQUUsQ0FBQyxrQkFBa0IsRUFBRSxPQUFPLENBQUMsQ0FBQztBQUNyRyxrQ0FBa0M7QUFDWCwyQ0FBb0IsR0FBRyxzQkFBc0IsQ0FBQyxFQUFFLENBQUMsa0JBQWtCLEVBQUUsT0FBTyxDQUFDLENBQUM7QUFDckcsaUNBQWlDO0FBQ1YsMENBQW1CLEdBQUcsc0JBQXNCLENBQUMsRUFBRSxDQUFDLGlCQUFpQixFQUFFLE9BQU8sQ0FBQyxDQUFDO0FBQ25HLGlDQUFpQztBQUNWLDBDQUFtQixHQUFHLHNCQUFzQixDQUFDLEVBQUUsQ0FBQyxpQkFBaUIsRUFBRSxPQUFPLENBQUMsQ0FBQztBQUNuRyxpQ0FBaUM7QUFDViwwQ0FBbUIsR0FBRyxzQkFBc0IsQ0FBQyxFQUFFLENBQUMsaUJBQWlCLEVBQUUsT0FBTyxDQUFDLENBQUM7QUFFbkcsZ0ZBQWdGO0FBQ3pELDZCQUFNLEdBQUcsc0JBQXNCLENBQUMsRUFBRSxDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUMsQ0FBQztBQUM1RSxtQ0FBbUM7QUFDWiw0Q0FBcUIsR0FBRyxzQkFBc0IsQ0FBQyxFQUFFLENBQUMsbUJBQW1CLEVBQUUsT0FBTyxDQUFDLENBQUM7QUFDdkcsa0NBQWtDO0FBQ1gsMkNBQW9CLEdBQUcsc0JBQXNCLENBQUMsRUFBRSxDQUFDLGtCQUFrQixFQUFFLE9BQU8sQ0FBQyxDQUFDO0FBQ3JHLGlDQUFpQztBQUNWLDBDQUFtQixHQUFHLHNCQUFzQixDQUFDLEVBQUUsQ0FBQyxpQkFBaUIsRUFBRSxPQUFPLENBQUMsQ0FBQztBQUNuRyxpQ0FBaUM7QUFDViwwQ0FBbUIsR0FBRyxzQkFBc0IsQ0FBQyxFQUFFLENBQUMsaUJBQWlCLEVBQUUsT0FBTyxDQUFDLENBQUM7QUFDbkc7OztFQUdFO0FBQ3FCLDBDQUFtQixHQUFHLHNCQUFzQixDQUFDLEVBQUUsQ0FBQyxpQkFBaUIsRUFBRSxPQUFPLENBQUMsQ0FBQztBQUNuRyxpQ0FBaUM7QUFDViwwQ0FBbUIsR0FBRyxzQkFBc0IsQ0FBQyxFQUFFLENBQUMsaUJBQWlCLEVBQUUsT0FBTyxDQUFDLENBQUM7QUFDbkcsaUNBQWlDO0FBQ1YsMENBQW1CLEdBQUcsc0JBQXNCLENBQUMsRUFBRSxDQUFDLGlCQUFpQixFQUFFLE9BQU8sQ0FBQyxDQUFDO0FBQ25HLGlDQUFpQztBQUNWLDBDQUFtQixHQUFHLHNCQUFzQixDQUFDLEVBQUUsQ0FBQyxpQkFBaUIsRUFBRSxPQUFPLENBQUMsQ0FBQztBQUNuRyxrQ0FBa0M7QUFDWCwyQ0FBb0IsR0FBRyxzQkFBc0IsQ0FBQyxFQUFFLENBQUMsa0JBQWtCLEVBQUUsT0FBTyxDQUFDLENBQUM7QUFDckcsaUNBQWlDO0FBQ1YsMENBQW1CLEdBQUcsc0JBQXNCLENBQUMsRUFBRSxDQUFDLGlCQUFpQixFQUFFLE9BQU8sQ0FBQyxDQUFDO0FBQ25HLGlDQUFpQztBQUNWLDBDQUFtQixHQUFHLHNCQUFzQixDQUFDLEVBQUUsQ0FBQyxpQkFBaUIsRUFBRSxPQUFPLENBQUMsQ0FBQztBQUNuRyxrQ0FBa0M7QUFDWCwyQ0FBb0IsR0FBRyxzQkFBc0IsQ0FBQyxFQUFFLENBQUMsa0JBQWtCLEVBQUUsT0FBTyxDQUFDLENBQUM7QUFDckcsaUNBQWlDO0FBQ1YsMENBQW1CLEdBQUcsc0JBQXNCLENBQUMsRUFBRSxDQUFDLGlCQUFpQixFQUFFLE9BQU8sQ0FBQyxDQUFDO0FBRW5HLGdGQUFnRjtBQUN6RCw2QkFBTSxHQUFHLHNCQUFzQixDQUFDLEVBQUUsQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLENBQUM7QUFDNUUsa0NBQWtDO0FBQ1gsMkNBQW9CLEdBQUcsc0JBQXNCLENBQUMsRUFBRSxDQUFDLGtCQUFrQixFQUFFLE9BQU8sQ0FBQyxDQUFDO0FBQ3JHOzs7R0FHRztBQUNvQiwyQ0FBb0IsR0FBRyxzQkFBc0IsQ0FBQyxFQUFFLENBQUMsa0JBQWtCLEVBQUUsT0FBTyxDQUFDLENBQUM7QUFDckcsa0NBQWtDO0FBQ1gsMkNBQW9CLEdBQUcsc0JBQXNCLENBQUMsRUFBRSxDQUFDLGtCQUFrQixFQUFFLE9BQU8sQ0FBQyxDQUFDO0FBQ3JHLGlDQUFpQztBQUNWLDBDQUFtQixHQUFHLHNCQUFzQixDQUFDLEVBQUUsQ0FBQyxpQkFBaUIsRUFBRSxPQUFPLENBQUMsQ0FBQztBQUNuRyxpQ0FBaUM7QUFDViwwQ0FBbUIsR0FBRyxzQkFBc0IsQ0FBQyxFQUFFLENBQUMsaUJBQWlCLEVBQUUsT0FBTyxDQUFDLENBQUM7QUFDbkcsaUNBQWlDO0FBQ1YsMENBQW1CLEdBQUcsc0JBQXNCLENBQUMsRUFBRSxDQUFDLGlCQUFpQixFQUFFLE9BQU8sQ0FBQyxDQUFDO0FBaEh4Rix3REFBc0I7QUFvSm5DLE1BQWUsMkJBQTRCLFNBQVEsa0JBQWtCO0lBQ25FLFlBQVksS0FBdUM7UUFDakQsS0FBSyxDQUFDO1lBQ0osR0FBRyxLQUFLO1lBQ1IsNkJBQTZCLEVBQUUsY0FBYyxDQUFDLHlCQUF5QixDQUFDLDhCQUE4QjtZQUN0Ryw0QkFBNEIsRUFBRSxjQUFjLENBQUMseUJBQXlCLENBQUMsNkJBQTZCO1lBQ3BHLE9BQU8sRUFBRSxLQUFLLENBQUMsT0FBTztnQkFDcEIsQ0FBQyxDQUFDO29CQUNBLFdBQVcsRUFBRSxLQUFLLENBQUMsT0FBTyxDQUFDLG9CQUFvQjtvQkFDL0MsWUFBWSxFQUFFLEtBQUssQ0FBQyxPQUFPLENBQUMscUJBQXFCO2lCQUNsRDtnQkFDRCxDQUFDLENBQUMsU0FBUztZQUNiLG9CQUFvQixFQUFFLEtBQUssQ0FBQyxPQUFPO2dCQUNqQywrRUFBK0U7Z0JBQy9FLCtDQUErQztnQkFDL0MsQ0FBQyxDQUFDLEdBQUcsS0FBSyxDQUFDLFVBQVUsSUFBSSxLQUFLLENBQUMsT0FBTyxDQUFDLHFCQUFxQixDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUM7b0JBQzFFLENBQUMsQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLHFCQUFxQixDQUFDLEtBQUssQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7b0JBQ2xELENBQUMsQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLHFCQUFxQixFQUFFO2dCQUN6QyxDQUFDLENBQUMsU0FBUztZQUNiLFFBQVEsRUFBRTtnQkFDUixRQUFRLEVBQUUsZ0JBQWdCO2dCQUMxQixRQUFRLEVBQUUsZ0JBQWdCO2FBQzNCO1NBQ0YsQ0FBQyxDQUFDO0tBQ0o7SUFFTSxjQUFjLENBQUMsS0FBZ0IsRUFBRSxPQUFrQztRQUN4RSxNQUFNLE1BQU0sR0FBRyxLQUFLLENBQUMsY0FBYyxDQUFDLEtBQUssRUFBRSxPQUFPLENBQUMsQ0FBQztRQUVwRCxJQUFJLFdBQVcsR0FBRyxPQUFPLENBQUMsV0FBVyxDQUFDO1FBQ3RDLE1BQU0sTUFBTSxHQUFHLE9BQU8sQ0FBQyxZQUFZLElBQUksT0FBTyxDQUFDLFlBQVksQ0FBQztRQUM1RCxJQUFJLE1BQU0sRUFBRTtZQUNWLElBQUksT0FBTyxDQUFDLFlBQVksSUFBSSxPQUFPLENBQUMsWUFBWSxJQUFJLE9BQU8sQ0FBQyxZQUFZLEtBQUssT0FBTyxDQUFDLFlBQVksRUFBRTtnQkFDakcsTUFBTSxJQUFJLEtBQUssQ0FBQyxvRUFBb0UsQ0FBQyxDQUFDO2FBQ3ZGO1lBRUQsSUFBSSxDQUFDLFdBQVcsRUFBRTtnQkFDaEIsV0FBVyxHQUFHLElBQUksMEJBQVcsQ0FBQyxLQUFLLEVBQUUscUJBQXFCLEVBQUU7b0JBQzFELE1BQU0sRUFBRSxJQUFJO29CQUNaLGNBQWMsRUFBRSxFQUFFO2lCQUNuQixDQUFDLENBQUM7YUFDSjtZQUNELHVHQUF1RztZQUN2RyxXQUFXLENBQUMsZ0JBQWdCLENBQUM7Z0JBQzNCLElBQUksRUFBRSwwQkFBMEI7Z0JBQ2hDLFFBQVEsRUFBRSxFQUFFLFlBQVksRUFBRSxNQUFNLENBQUMsT0FBTyxFQUFFO2FBQzNDLENBQUMsQ0FBQztTQUNKO1FBRUQsT0FBTztZQUNMLEdBQUcsTUFBTTtZQUNULFdBQVc7U0FDWixDQUFDO0tBQ0g7SUFFRCxJQUFjLGdCQUFnQixLQUFLLE9BQU8sSUFBSSxDQUFDLEVBQUU7Q0FDbEQ7QUFTRCxNQUFNLHlCQUEwQixTQUFRLDJCQUEyQjtJQUNqRSxZQUFZLE9BQWdDO1FBQzFDLEtBQUssQ0FBQztZQUNKLFVBQVUsRUFBRSxjQUFjO1lBQzFCLE9BQU87U0FDUixDQUFDLENBQUM7S0FDSjtDQUNGO0FBU0QsTUFBTSx5QkFBMEIsU0FBUSwyQkFBMkI7SUFDakUsWUFBWSxPQUFnQztRQUMxQyxLQUFLLENBQUM7WUFDSixVQUFVLEVBQUUsY0FBYztZQUMxQixPQUFPO1NBQ1IsQ0FBQyxDQUFDO0tBQ0o7Q0FDRjtBQVNELE1BQU0sMEJBQTJCLFNBQVEsMkJBQTJCO0lBQ2xFLFlBQVksT0FBZ0M7UUFDMUMsS0FBSyxDQUFDO1lBQ0osVUFBVSxFQUFFLGVBQWU7WUFDM0IsT0FBTztTQUNSLENBQUMsQ0FBQztLQUNKO0NBQ0Y7QUFTRCxNQUFNLHlCQUEwQixTQUFRLDJCQUEyQjtJQUNqRSxZQUFZLE9BQWdDO1FBQzFDLEtBQUssQ0FBQztZQUNKLFVBQVUsRUFBRSxjQUFjO1lBQzFCLE9BQU87U0FDUixDQUFDLENBQUM7S0FDSjtDQUNGO0FBRUQ7OztHQUdHO0FBQ0gsTUFBYSxzQkFBc0I7SUF1R2pDLDZDQUE2QztJQUN0QyxNQUFNLENBQUMsT0FBTyxDQUFDLEtBQWlDOzs7Ozs7Ozs7O1FBQ3JELE9BQU8sSUFBSSxxQkFBcUIsQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUM7S0FDakQ7SUFFRCwyQ0FBMkM7SUFDcEMsTUFBTSxDQUFDLEtBQUssQ0FBQyxLQUErQjs7Ozs7Ozs7OztRQUNqRCxPQUFPLElBQUksbUJBQW1CLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDO0tBQy9DO0lBRUQsZ0RBQWdEO0lBQ3pDLE1BQU0sQ0FBQyxRQUFRLENBQUMsS0FBa0M7Ozs7Ozs7Ozs7UUFDdkQsT0FBTyxJQUFJLHNCQUFzQixDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQztLQUNsRDtJQUVEOzs7T0FHRztJQUNJLE1BQU0sQ0FBQyxRQUFRLENBQUMsS0FBa0M7UUFDdkQsT0FBTyxJQUFJLHNCQUFzQixDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQztLQUNsRDtJQUVEOzs7T0FHRztJQUNJLE1BQU0sQ0FBQyxTQUFTLENBQUMsS0FBbUM7UUFDekQsT0FBTyxJQUFJLHVCQUF1QixDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQztLQUNuRDtJQUVELCtEQUErRDtJQUN4RCxNQUFNLENBQUMsU0FBUyxDQUFDLEtBQW1DOzs7Ozs7Ozs7O1FBQ3pELE9BQU8sSUFBSSx1QkFBdUIsQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUM7S0FDbkQ7SUFFRCxxRUFBcUU7SUFDOUQsTUFBTSxDQUFDLFlBQVksQ0FBQyxLQUFzQzs7Ozs7Ozs7OztRQUMvRCxPQUFPLElBQUksMEJBQTBCLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDO0tBQ3REO0lBRUQsK0RBQStEO0lBQ3hELE1BQU0sQ0FBQyxRQUFRLENBQUMsS0FBa0M7Ozs7Ozs7Ozs7UUFDdkQsT0FBTyxJQUFJLHNCQUFzQixDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQztLQUNsRDtJQUVELHFFQUFxRTtJQUM5RCxNQUFNLENBQUMsV0FBVyxDQUFDLEtBQXFDOzs7Ozs7Ozs7O1FBQzdELE9BQU8sSUFBSSx5QkFBeUIsQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUM7S0FDckQ7SUFFRCxpRUFBaUU7SUFDMUQsTUFBTSxDQUFDLFdBQVcsQ0FBQyxLQUFxQzs7Ozs7Ozs7OztRQUM3RCxPQUFPLElBQUkseUJBQXlCLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDO0tBQ3JEO0lBRUQsZ0VBQWdFO0lBQ3pELE1BQU0sQ0FBQyxXQUFXLENBQUMsS0FBcUM7Ozs7Ozs7Ozs7UUFDN0QsT0FBTyxJQUFJLHlCQUF5QixDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQztLQUNyRDtJQUVELDREQUE0RDtJQUNyRCxNQUFNLENBQUMsWUFBWSxDQUFDLEtBQXNDOzs7Ozs7Ozs7O1FBQy9ELE9BQU8sSUFBSSwwQkFBMEIsQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUM7S0FDdEQ7SUFFRCxtRUFBbUU7SUFDNUQsTUFBTSxDQUFDLFdBQVcsQ0FBQyxLQUFxQzs7Ozs7Ozs7OztRQUM3RCxPQUFPLElBQUkseUJBQXlCLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDO0tBQ3JEOzs7O0FBM0tEOzs7OztHQUtHO0FBQ29CLDhCQUFPLEdBQW9CLElBQUkscUJBQXFCLEVBQUUsQ0FBQztBQUU5RTs7Ozs7R0FLRztBQUNvQiw0QkFBSyxHQUFvQixJQUFJLG1CQUFtQixFQUFFLENBQUM7QUFFMUU7Ozs7O0dBS0c7QUFDb0IsZ0NBQVMsR0FBb0IsSUFBSSxzQkFBc0IsRUFBRSxDQUFDO0FBRWpGOzs7OztHQUtHO0FBQ29CLG9DQUFhLEdBQW9CLElBQUkseUJBQXlCLEVBQUUsQ0FBQztBQUV4Rjs7Ozs7R0FLRztBQUNvQixpQ0FBVSxHQUFvQixJQUFJLHVCQUF1QixFQUFFLENBQUM7QUFFbkY7Ozs7O0dBS0c7QUFDb0IscUNBQWMsR0FBb0IsSUFBSSwwQkFBMEIsRUFBRSxDQUFDO0FBRTFGOzs7O0dBSUc7QUFDb0IsaUNBQVUsR0FBb0IsSUFBSSx1QkFBdUIsRUFBRSxDQUFDO0FBRW5GOzs7O0dBSUc7QUFDb0IsZ0NBQVMsR0FBb0IsSUFBSSxzQkFBc0IsRUFBRSxDQUFDO0FBRWpGOzs7OztHQUtHO0FBQ29CLCtCQUFRLEdBQW9CLElBQUksc0JBQXNCLEVBQUUsQ0FBQztBQUVoRjs7Ozs7R0FLRztBQUNvQixvQ0FBYSxHQUFvQixJQUFJLHlCQUF5QixFQUFFLENBQUM7QUFFeEY7Ozs7O0dBS0c7QUFDb0Isb0NBQWEsR0FBb0IsSUFBSSx5QkFBeUIsRUFBRSxDQUFDO0FBRXhGOzs7OztHQUtHO0FBQ29CLG9DQUFhLEdBQW9CLElBQUkseUJBQXlCLEVBQUUsQ0FBQztBQUV4Rjs7Ozs7R0FLRztBQUNvQixxQ0FBYyxHQUFvQixJQUFJLDBCQUEwQixFQUFFLENBQUM7QUFyRy9FLHdEQUFzQiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGlhbSBmcm9tICcuLi8uLi9hd3MtaWFtJztcbmltcG9ydCAqIGFzIHNlY3JldHNtYW5hZ2VyIGZyb20gJy4uLy4uL2F3cy1zZWNyZXRzbWFuYWdlcic7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IElFbmdpbmUgfSBmcm9tICcuL2VuZ2luZSc7XG5pbXBvcnQgeyBFbmdpbmVWZXJzaW9uIH0gZnJvbSAnLi9lbmdpbmUtdmVyc2lvbic7XG5pbXBvcnQgeyBJT3B0aW9uR3JvdXAsIE9wdGlvbkdyb3VwIH0gZnJvbSAnLi9vcHRpb24tZ3JvdXAnO1xuXG4vKipcbiAqIFRoZSBvcHRpb25zIHBhc3NlZCB0byBgSUluc3RhbmNlRW5naW5lLmJpbmRgLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIEluc3RhbmNlRW5naW5lQmluZE9wdGlvbnMge1xuICAvKipcbiAgICogVGhlIEFjdGl2ZSBEaXJlY3RvcnkgZGlyZWN0b3J5IElEIHRvIGNyZWF0ZSB0aGUgREIgaW5zdGFuY2UgaW4uXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gbm9uZSAoaXQncyBhbiBvcHRpb25hbCBmaWVsZClcbiAgICovXG4gIHJlYWRvbmx5IGRvbWFpbj86IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIHRpbWV6b25lIG9mIHRoZSBkYXRhYmFzZSwgc2V0IGJ5IHRoZSBjdXN0b21lci5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBub25lIChpdCdzIGFuIG9wdGlvbmFsIGZpZWxkKVxuICAgKi9cbiAgcmVhZG9ubHkgdGltZXpvbmU/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSByb2xlIHVzZWQgZm9yIFMzIGltcG9ydGluZy5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBub25lXG4gICAqL1xuICByZWFkb25seSBzM0ltcG9ydFJvbGU/OiBpYW0uSVJvbGU7XG5cbiAgLyoqXG4gICAqIFRoZSByb2xlIHVzZWQgZm9yIFMzIGV4cG9ydGluZy5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBub25lXG4gICAqL1xuICByZWFkb25seSBzM0V4cG9ydFJvbGU/OiBpYW0uSVJvbGU7XG5cbiAgLyoqXG4gICAqIFRoZSBvcHRpb24gZ3JvdXAgb2YgdGhlIGRhdGFiYXNlXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gbm9uZVxuICAgKi9cbiAgcmVhZG9ubHkgb3B0aW9uR3JvdXA/OiBJT3B0aW9uR3JvdXA7XG59XG5cbi8qKlxuICogVGhlIHR5cGUgcmV0dXJuZWQgZnJvbSB0aGUgYElJbnN0YW5jZUVuZ2luZS5iaW5kYCBtZXRob2QuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSW5zdGFuY2VFbmdpbmVDb25maWcge1xuICAvKipcbiAgICogRmVhdHVyZXMgc3VwcG9ydGVkIGJ5IHRoZSBkYXRhYmFzZSBlbmdpbmUuXG4gICAqXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FtYXpvblJEUy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9EQkVuZ2luZVZlcnNpb24uaHRtbFxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vIGZlYXR1cmVzXG4gICAqL1xuICByZWFkb25seSBmZWF0dXJlcz86IEluc3RhbmNlRW5naW5lRmVhdHVyZXM7XG5cbiAgLyoqXG4gICAqIE9wdGlvbiBncm91cCBvZiB0aGUgZGF0YWJhc2UuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gbm9uZVxuICAgKi9cbiAgcmVhZG9ubHkgb3B0aW9uR3JvdXA/OiBJT3B0aW9uR3JvdXA7XG59XG5cbi8qKlxuICogUmVwcmVzZW50cyBEYXRhYmFzZSBFbmdpbmUgZmVhdHVyZXNcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJbnN0YW5jZUVuZ2luZUZlYXR1cmVzIHtcbiAgLyoqXG4gICAqIEZlYXR1cmUgbmFtZSBmb3IgdGhlIERCIGluc3RhbmNlIHRoYXQgdGhlIElBTSByb2xlIHRvIGFjY2VzcyB0aGUgUzMgYnVja2V0IGZvciBpbXBvcnRcbiAgICogaXMgdG8gYmUgYXNzb2NpYXRlZCB3aXRoLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vIHMzSW1wb3J0IGZlYXR1cmUgbmFtZVxuICAgKi9cbiAgcmVhZG9ubHkgczNJbXBvcnQ/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEZlYXR1cmUgbmFtZSBmb3IgdGhlIERCIGluc3RhbmNlIHRoYXQgdGhlIElBTSByb2xlIHRvIGV4cG9ydCB0byBTMyBidWNrZXQgaXMgdG8gYmVcbiAgICogYXNzb2NpYXRlZCB3aXRoLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vIHMzRXhwb3J0IGZlYXR1cmUgbmFtZVxuICAgKi9cbiAgcmVhZG9ubHkgczNFeHBvcnQ/OiBzdHJpbmc7XG59XG5cbi8qKlxuICogSW50ZXJmYWNlIHJlcHJlc2VudGluZyBhIGRhdGFiYXNlIGluc3RhbmNlIChhcyBvcHBvc2VkIHRvIGNsdXN0ZXIpIGVuZ2luZS5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJSW5zdGFuY2VFbmdpbmUgZXh0ZW5kcyBJRW5naW5lIHtcbiAgLyoqIFRoZSBhcHBsaWNhdGlvbiB1c2VkIGJ5IHRoaXMgZW5naW5lIHRvIHBlcmZvcm0gcm90YXRpb24gZm9yIGEgc2luZ2xlLXVzZXIgc2NlbmFyaW8uICovXG4gIHJlYWRvbmx5IHNpbmdsZVVzZXJSb3RhdGlvbkFwcGxpY2F0aW9uOiBzZWNyZXRzbWFuYWdlci5TZWNyZXRSb3RhdGlvbkFwcGxpY2F0aW9uO1xuXG4gIC8qKiBUaGUgYXBwbGljYXRpb24gdXNlZCBieSB0aGlzIGVuZ2luZSB0byBwZXJmb3JtIHJvdGF0aW9uIGZvciBhIG11bHRpLXVzZXIgc2NlbmFyaW8uICovXG4gIHJlYWRvbmx5IG11bHRpVXNlclJvdGF0aW9uQXBwbGljYXRpb246IHNlY3JldHNtYW5hZ2VyLlNlY3JldFJvdGF0aW9uQXBwbGljYXRpb247XG5cbiAgLyoqXG4gICAqIFdoZXRoZXIgdGhpcyBlbmdpbmUgc3VwcG9ydHMgYXV0b21hdGljIGJhY2t1cHMgb2YgYSByZWFkIHJlcGxpY2EgaW5zdGFuY2UuXG4gICAqXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqL1xuICByZWFkb25seSBzdXBwb3J0c1JlYWRSZXBsaWNhQmFja3Vwcz86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIE1ldGhvZCBjYWxsZWQgd2hlbiB0aGUgZW5naW5lIGlzIHVzZWQgdG8gY3JlYXRlIGEgbmV3IGluc3RhbmNlLlxuICAgKi9cbiAgYmluZFRvSW5zdGFuY2Uoc2NvcGU6IENvbnN0cnVjdCwgb3B0aW9uczogSW5zdGFuY2VFbmdpbmVCaW5kT3B0aW9ucyk6IEluc3RhbmNlRW5naW5lQ29uZmlnO1xufVxuXG5pbnRlcmZhY2UgSW5zdGFuY2VFbmdpbmVCYXNlUHJvcHMge1xuICByZWFkb25seSBlbmdpbmVUeXBlOiBzdHJpbmc7XG4gIHJlYWRvbmx5IHNpbmdsZVVzZXJSb3RhdGlvbkFwcGxpY2F0aW9uOiBzZWNyZXRzbWFuYWdlci5TZWNyZXRSb3RhdGlvbkFwcGxpY2F0aW9uO1xuICByZWFkb25seSBtdWx0aVVzZXJSb3RhdGlvbkFwcGxpY2F0aW9uOiBzZWNyZXRzbWFuYWdlci5TZWNyZXRSb3RhdGlvbkFwcGxpY2F0aW9uO1xuICByZWFkb25seSB2ZXJzaW9uPzogRW5naW5lVmVyc2lvbjtcbiAgcmVhZG9ubHkgcGFyYW1ldGVyR3JvdXBGYW1pbHk/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGVuZ2luZUZhbWlseT86IHN0cmluZztcbiAgcmVhZG9ubHkgZmVhdHVyZXM/OiBJbnN0YW5jZUVuZ2luZUZlYXR1cmVzO1xufVxuXG5hYnN0cmFjdCBjbGFzcyBJbnN0YW5jZUVuZ2luZUJhc2UgaW1wbGVtZW50cyBJSW5zdGFuY2VFbmdpbmUge1xuICBwdWJsaWMgcmVhZG9ubHkgZW5naW5lVHlwZTogc3RyaW5nO1xuICBwdWJsaWMgcmVhZG9ubHkgZW5naW5lVmVyc2lvbj86IEVuZ2luZVZlcnNpb247XG4gIHB1YmxpYyByZWFkb25seSBwYXJhbWV0ZXJHcm91cEZhbWlseT86IHN0cmluZztcbiAgcHVibGljIHJlYWRvbmx5IHNpbmdsZVVzZXJSb3RhdGlvbkFwcGxpY2F0aW9uOiBzZWNyZXRzbWFuYWdlci5TZWNyZXRSb3RhdGlvbkFwcGxpY2F0aW9uO1xuICBwdWJsaWMgcmVhZG9ubHkgbXVsdGlVc2VyUm90YXRpb25BcHBsaWNhdGlvbjogc2VjcmV0c21hbmFnZXIuU2VjcmV0Um90YXRpb25BcHBsaWNhdGlvbjtcbiAgcHVibGljIHJlYWRvbmx5IGVuZ2luZUZhbWlseT86IHN0cmluZztcbiAgcHVibGljIHJlYWRvbmx5IHN1cHBvcnRzUmVhZFJlcGxpY2FCYWNrdXBzPzogYm9vbGVhbjtcblxuICBwcml2YXRlIHJlYWRvbmx5IGZlYXR1cmVzPzogSW5zdGFuY2VFbmdpbmVGZWF0dXJlcztcblxuICBjb25zdHJ1Y3Rvcihwcm9wczogSW5zdGFuY2VFbmdpbmVCYXNlUHJvcHMpIHtcbiAgICB0aGlzLmVuZ2luZVR5cGUgPSBwcm9wcy5lbmdpbmVUeXBlO1xuICAgIHRoaXMuZmVhdHVyZXMgPSBwcm9wcy5mZWF0dXJlcztcbiAgICB0aGlzLnNpbmdsZVVzZXJSb3RhdGlvbkFwcGxpY2F0aW9uID0gcHJvcHMuc2luZ2xlVXNlclJvdGF0aW9uQXBwbGljYXRpb247XG4gICAgdGhpcy5tdWx0aVVzZXJSb3RhdGlvbkFwcGxpY2F0aW9uID0gcHJvcHMubXVsdGlVc2VyUm90YXRpb25BcHBsaWNhdGlvbjtcbiAgICB0aGlzLmVuZ2luZVZlcnNpb24gPSBwcm9wcy52ZXJzaW9uO1xuICAgIHRoaXMucGFyYW1ldGVyR3JvdXBGYW1pbHkgPSBwcm9wcy5wYXJhbWV0ZXJHcm91cEZhbWlseSA/P1xuICAgICAgKHRoaXMuZW5naW5lVmVyc2lvbiA/IGAke3RoaXMuZW5naW5lVHlwZX0ke3RoaXMuZW5naW5lVmVyc2lvbi5tYWpvclZlcnNpb259YCA6IHVuZGVmaW5lZCk7XG4gICAgdGhpcy5lbmdpbmVGYW1pbHkgPSBwcm9wcy5lbmdpbmVGYW1pbHk7XG4gIH1cblxuICBwdWJsaWMgYmluZFRvSW5zdGFuY2UoX3Njb3BlOiBDb25zdHJ1Y3QsIG9wdGlvbnM6IEluc3RhbmNlRW5naW5lQmluZE9wdGlvbnMpOiBJbnN0YW5jZUVuZ2luZUNvbmZpZyB7XG4gICAgaWYgKG9wdGlvbnMudGltZXpvbmUgJiYgIXRoaXMuc3VwcG9ydHNUaW1lem9uZSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKGB0aW1lem9uZSBwcm9wZXJ0eSBjYW4gbm90IGJlIGNvbmZpZ3VyZWQgZm9yICR7dGhpcy5lbmdpbmVUeXBlfWApO1xuICAgIH1cbiAgICByZXR1cm4ge1xuICAgICAgZmVhdHVyZXM6IHRoaXMuZmVhdHVyZXMsXG4gICAgICBvcHRpb25Hcm91cDogb3B0aW9ucy5vcHRpb25Hcm91cCxcbiAgICB9O1xuICB9XG5cbiAgLyoqIERlZmluZXMgd2hldGhlciB0aGlzIEluc3RhbmNlIEVuZ2luZSBjYW4gc3VwcG9ydCB0aW1lem9uZSBwcm9wZXJ0aWVzLiAqL1xuICBwcm90ZWN0ZWQgZ2V0IHN1cHBvcnRzVGltZXpvbmUoKSB7IHJldHVybiBmYWxzZTsgfVxufVxuXG4vKipcbiAqIFRoZSB2ZXJzaW9ucyBmb3IgdGhlIE1hcmlhREIgaW5zdGFuY2UgZW5naW5lc1xuICogKHRob3NlIHJldHVybmVkIGJ5IGBEYXRhYmFzZUluc3RhbmNlRW5naW5lLm1hcmlhRGJgKS5cbiAqL1xuZXhwb3J0IGNsYXNzIE1hcmlhRGJFbmdpbmVWZXJzaW9uIHtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCIxMC4wXCIgKG9ubHkgYSBtYWpvciB2ZXJzaW9uLCB3aXRob3V0IGEgc3BlY2lmaWMgbWlub3IgdmVyc2lvbikuXG4gICAqIEBkZXByZWNhdGVkIE1hcmlhREIgMTAuMCBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzAgPSBNYXJpYURiRW5naW5lVmVyc2lvbi5vZignMTAuMCcsICcxMC4wJyk7XG4gIC8qKlxuICAgKiBWZXJzaW9uIFwiMTAuMC4xN1wiLlxuICAgKiBAZGVwcmVjYXRlZCBNYXJpYURCIDEwLjAgaXMgbm8gbG9uZ2VyIHN1cHBvcnRlZCBieSBBbWF6b24gUkRTLlxuICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMF8wXzE3ID0gTWFyaWFEYkVuZ2luZVZlcnNpb24ub2YoJzEwLjAuMTcnLCAnMTAuMCcpO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjEwLjAuMjRcIi5cbiAgICogQGRlcHJlY2F0ZWQgTWFyaWFEQiAxMC4wIGlzIG5vIGxvbmdlciBzdXBwb3J0ZWQgYnkgQW1hem9uIFJEUy5cbiAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTBfMF8yNCA9IE1hcmlhRGJFbmdpbmVWZXJzaW9uLm9mKCcxMC4wLjI0JywgJzEwLjAnKTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCIxMC4wLjI4XCIuXG4gICAqIEBkZXByZWNhdGVkIE1hcmlhREIgMTAuMCBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzBfMjggPSBNYXJpYURiRW5naW5lVmVyc2lvbi5vZignMTAuMC4yOCcsICcxMC4wJyk7XG4gIC8qKlxuICAgKiBWZXJzaW9uIFwiMTAuMC4zMVwiLlxuICAgKiBAZGVwcmVjYXRlZCBNYXJpYURCIDEwLjAgaXMgbm8gbG9uZ2VyIHN1cHBvcnRlZCBieSBBbWF6b24gUkRTLlxuICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMF8wXzMxID0gTWFyaWFEYkVuZ2luZVZlcnNpb24ub2YoJzEwLjAuMzEnLCAnMTAuMCcpO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjEwLjAuMzJcIi5cbiAgICogQGRlcHJlY2F0ZWQgTWFyaWFEQiAxMC4wIGlzIG5vIGxvbmdlciBzdXBwb3J0ZWQgYnkgQW1hem9uIFJEUy5cbiAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTBfMF8zMiA9IE1hcmlhRGJFbmdpbmVWZXJzaW9uLm9mKCcxMC4wLjMyJywgJzEwLjAnKTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCIxMC4wLjM0XCIuXG4gICAqIEBkZXByZWNhdGVkIE1hcmlhREIgMTAuMCBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzBfMzQgPSBNYXJpYURiRW5naW5lVmVyc2lvbi5vZignMTAuMC4zNCcsICcxMC4wJyk7XG4gIC8qKlxuICAgKiBWZXJzaW9uIFwiMTAuMC4zNVwiLlxuICAgKiBAZGVwcmVjYXRlZCBNYXJpYURCIDEwLjAgaXMgbm8gbG9uZ2VyIHN1cHBvcnRlZCBieSBBbWF6b24gUkRTLlxuICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMF8wXzM1ID0gTWFyaWFEYkVuZ2luZVZlcnNpb24ub2YoJzEwLjAuMzUnLCAnMTAuMCcpO1xuXG4gIC8qKlxuICAgKiBWZXJzaW9uIFwiMTAuMVwiIChvbmx5IGEgbWFqb3IgdmVyc2lvbiwgd2l0aG91dCBhIHNwZWNpZmljIG1pbm9yIHZlcnNpb24pLlxuICAgKiBAZGVwcmVjYXRlZCBNYXJpYURCIDEwLjEgaXMgbm8gbG9uZ2VyIHN1cHBvcnRlZCBieSBBbWF6b24gUkRTLlxuICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMF8xID0gTWFyaWFEYkVuZ2luZVZlcnNpb24ub2YoJzEwLjEnLCAnMTAuMScpO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjEwLjEuMTRcIi5cbiAgICogQGRlcHJlY2F0ZWQgTWFyaWFEQiAxMC4xIGlzIG5vIGxvbmdlciBzdXBwb3J0ZWQgYnkgQW1hem9uIFJEUy5cbiAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTBfMV8xNCA9IE1hcmlhRGJFbmdpbmVWZXJzaW9uLm9mKCcxMC4xLjE0JywgJzEwLjEnKTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCIxMC4xLjE5XCIuXG4gICAqIEBkZXByZWNhdGVkIE1hcmlhREIgMTAuMSBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzFfMTkgPSBNYXJpYURiRW5naW5lVmVyc2lvbi5vZignMTAuMS4xOScsICcxMC4xJyk7XG4gIC8qKlxuICAgKiBWZXJzaW9uIFwiMTAuMS4yM1wiLlxuICAgKiBAZGVwcmVjYXRlZCBNYXJpYURCIDEwLjEgaXMgbm8gbG9uZ2VyIHN1cHBvcnRlZCBieSBBbWF6b24gUkRTLlxuICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMF8xXzIzID0gTWFyaWFEYkVuZ2luZVZlcnNpb24ub2YoJzEwLjEuMjMnLCAnMTAuMScpO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjEwLjEuMjZcIi5cbiAgICogQGRlcHJlY2F0ZWQgTWFyaWFEQiAxMC4xIGlzIG5vIGxvbmdlciBzdXBwb3J0ZWQgYnkgQW1hem9uIFJEUy5cbiAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTBfMV8yNiA9IE1hcmlhRGJFbmdpbmVWZXJzaW9uLm9mKCcxMC4xLjI2JywgJzEwLjEnKTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCIxMC4xLjMxXCIuXG4gICAqIEBkZXByZWNhdGVkIE1hcmlhREIgMTAuMSBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzFfMzEgPSBNYXJpYURiRW5naW5lVmVyc2lvbi5vZignMTAuMS4zMScsICcxMC4xJyk7XG4gIC8qKlxuICAgKiBWZXJzaW9uIFwiMTAuMS4zNFwiLlxuICAgKiBAZGVwcmVjYXRlZCBNYXJpYURCIDEwLjEgaXMgbm8gbG9uZ2VyIHN1cHBvcnRlZCBieSBBbWF6b24gUkRTLlxuICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMF8xXzM0ID0gTWFyaWFEYkVuZ2luZVZlcnNpb24ub2YoJzEwLjEuMzQnLCAnMTAuMScpO1xuXG4gIC8qKlxuICAgKiBWZXJzaW9uIFwiMTAuMlwiIChvbmx5IGEgbWFqb3IgdmVyc2lvbiwgd2l0aG91dCBhIHNwZWNpZmljIG1pbm9yIHZlcnNpb24pXG4gICAqIEBkZXByZWNhdGVkIE1hcmlhREIgMTAuMiBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMF8yID0gTWFyaWFEYkVuZ2luZVZlcnNpb24ub2YoJzEwLjInLCAnMTAuMicpO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjEwLjIuMTFcIi5cbiAgICogQGRlcHJlY2F0ZWQgTWFyaWFEQiAxMC4yIGlzIG5vIGxvbmdlciBzdXBwb3J0ZWQgYnkgQW1hem9uIFJEUy5cbiAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTBfMl8xMSA9IE1hcmlhRGJFbmdpbmVWZXJzaW9uLm9mKCcxMC4yLjExJywgJzEwLjInKTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCIxMC4yLjEyXCIuXG4gICAqIEBkZXByZWNhdGVkIE1hcmlhREIgMTAuMiBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMF8yXzEyID0gTWFyaWFEYkVuZ2luZVZlcnNpb24ub2YoJzEwLjIuMTInLCAnMTAuMicpO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjEwLjIuMTVcIi5cbiAgICogQGRlcHJlY2F0ZWQgTWFyaWFEQiAxMC4yIGlzIG5vIGxvbmdlciBzdXBwb3J0ZWQgYnkgQW1hem9uIFJEUy5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzJfMTUgPSBNYXJpYURiRW5naW5lVmVyc2lvbi5vZignMTAuMi4xNScsICcxMC4yJyk7XG4gIC8qKlxuICAgKiBWZXJzaW9uIFwiMTAuMi4yMVwiLlxuICAgKiBAZGVwcmVjYXRlZCBNYXJpYURCIDEwLjIgaXMgbm8gbG9uZ2VyIHN1cHBvcnRlZCBieSBBbWF6b24gUkRTLlxuICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMF8yXzIxID0gTWFyaWFEYkVuZ2luZVZlcnNpb24ub2YoJzEwLjIuMjEnLCAnMTAuMicpO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjEwLjIuMzJcIi5cbiAgICogQGRlcHJlY2F0ZWQgTWFyaWFEQiAxMC4yIGlzIG5vIGxvbmdlciBzdXBwb3J0ZWQgYnkgQW1hem9uIFJEUy5cbiAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTBfMl8zMiA9IE1hcmlhRGJFbmdpbmVWZXJzaW9uLm9mKCcxMC4yLjMyJywgJzEwLjInKTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCIxMC4yLjM3XCIuXG4gICAqIEBkZXByZWNhdGVkIE1hcmlhREIgMTAuMiBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzJfMzcgPSBNYXJpYURiRW5naW5lVmVyc2lvbi5vZignMTAuMi4zNycsICcxMC4yJyk7XG4gIC8qKlxuICAgKiBWZXJzaW9uIFwiMTAuMi4zOVwiLlxuICAgKiBAZGVwcmVjYXRlZCBNYXJpYURCIDEwLjIgaXMgbm8gbG9uZ2VyIHN1cHBvcnRlZCBieSBBbWF6b24gUkRTLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTBfMl8zOSA9IE1hcmlhRGJFbmdpbmVWZXJzaW9uLm9mKCcxMC4yLjM5JywgJzEwLjInKTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCIxMC4yLjQwXCIuXG4gICAqIEBkZXByZWNhdGVkIE1hcmlhREIgMTAuMiBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMF8yXzQwID0gTWFyaWFEYkVuZ2luZVZlcnNpb24ub2YoJzEwLjIuNDAnLCAnMTAuMicpO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjEwLjIuNDFcIi5cbiAgICogQGRlcHJlY2F0ZWQgTWFyaWFEQiAxMC4yIGlzIG5vIGxvbmdlciBzdXBwb3J0ZWQgYnkgQW1hem9uIFJEUy5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzJfNDEgPSBNYXJpYURiRW5naW5lVmVyc2lvbi5vZignMTAuMi40MScsICcxMC4yJyk7XG5cbiAgLyoqIFZlcnNpb24gXCIxMC4zXCIgKG9ubHkgYSBtYWpvciB2ZXJzaW9uLCB3aXRob3V0IGEgc3BlY2lmaWMgbWlub3IgdmVyc2lvbikuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzMgPSBNYXJpYURiRW5naW5lVmVyc2lvbi5vZignMTAuMycsICcxMC4zJyk7XG4gIC8qKiBWZXJzaW9uIFwiMTAuMy44XCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzNfOCA9IE1hcmlhRGJFbmdpbmVWZXJzaW9uLm9mKCcxMC4zLjgnLCAnMTAuMycpO1xuICAvKiogVmVyc2lvbiBcIjEwLjMuMTNcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTBfM18xMyA9IE1hcmlhRGJFbmdpbmVWZXJzaW9uLm9mKCcxMC4zLjEzJywgJzEwLjMnKTtcbiAgLyoqIFZlcnNpb24gXCIxMC4zLjIwXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzNfMjAgPSBNYXJpYURiRW5naW5lVmVyc2lvbi5vZignMTAuMy4yMCcsICcxMC4zJyk7XG4gIC8qKiBWZXJzaW9uIFwiMTAuMy4yM1wiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMF8zXzIzID0gTWFyaWFEYkVuZ2luZVZlcnNpb24ub2YoJzEwLjMuMjMnLCAnMTAuMycpO1xuICAvKiogVmVyc2lvbiBcIjEwLjMuMjhcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTBfM18yOCA9IE1hcmlhRGJFbmdpbmVWZXJzaW9uLm9mKCcxMC4zLjI4JywgJzEwLjMnKTtcbiAgLyoqIFZlcnNpb24gXCIxMC4zLjMxXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzNfMzEgPSBNYXJpYURiRW5naW5lVmVyc2lvbi5vZignMTAuMy4zMScsICcxMC4zJyk7XG4gIC8qKiBWZXJzaW9uIFwiMTAuMy4zMlwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMF8zXzMyID0gTWFyaWFEYkVuZ2luZVZlcnNpb24ub2YoJzEwLjMuMzInLCAnMTAuMycpO1xuICAvKiogVmVyc2lvbiBcIjEwLjMuMzRcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTBfM18zNCA9IE1hcmlhRGJFbmdpbmVWZXJzaW9uLm9mKCcxMC4zLjM0JywgJzEwLjMnKTtcbiAgLyoqIFZlcnNpb24gXCIxMC4zLjM1XCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzNfMzUgPSBNYXJpYURiRW5naW5lVmVyc2lvbi5vZignMTAuMy4zNScsICcxMC4zJyk7XG4gIC8qKiBWZXJzaW9uIFwiMTAuMy4zNlwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMF8zXzM2ID0gTWFyaWFEYkVuZ2luZVZlcnNpb24ub2YoJzEwLjMuMzYnLCAnMTAuMycpO1xuICAvKiogVmVyc2lvbiBcIjEwLjMuMzdcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTBfM18zNyA9IE1hcmlhRGJFbmdpbmVWZXJzaW9uLm9mKCcxMC4zLjM3JywgJzEwLjMnKTtcbiAgLyoqIFZlcnNpb24gXCIxMC4zLjM4XCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzNfMzggPSBNYXJpYURiRW5naW5lVmVyc2lvbi5vZignMTAuMy4zOCcsICcxMC4zJyk7XG5cbiAgLyoqIFZlcnNpb24gXCIxMC40XCIgKG9ubHkgYSBtYWpvciB2ZXJzaW9uLCB3aXRob3V0IGEgc3BlY2lmaWMgbWlub3IgdmVyc2lvbikuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzQgPSBNYXJpYURiRW5naW5lVmVyc2lvbi5vZignMTAuNCcsICcxMC40Jyk7XG4gIC8qKiBWZXJzaW9uIFwiMTAuNC44XCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzRfOCA9IE1hcmlhRGJFbmdpbmVWZXJzaW9uLm9mKCcxMC40LjgnLCAnMTAuNCcpO1xuICAvKiogVmVyc2lvbiBcIjEwLjQuMTNcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTBfNF8xMyA9IE1hcmlhRGJFbmdpbmVWZXJzaW9uLm9mKCcxMC40LjEzJywgJzEwLjQnKTtcbiAgLyoqIFZlcnNpb24gXCIxMC40LjE4XCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzRfMTggPSBNYXJpYURiRW5naW5lVmVyc2lvbi5vZignMTAuNC4xOCcsICcxMC40Jyk7XG4gIC8qKiBWZXJzaW9uIFwiMTAuNC4yMVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMF80XzIxID0gTWFyaWFEYkVuZ2luZVZlcnNpb24ub2YoJzEwLjQuMjEnLCAnMTAuNCcpO1xuICAvKiogVmVyc2lvbiBcIjEwLjQuMjJcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTBfNF8yMiA9IE1hcmlhRGJFbmdpbmVWZXJzaW9uLm9mKCcxMC40LjIyJywgJzEwLjQnKTtcbiAgLyoqIFZlcnNpb24gXCIxMC40LjI0XCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzRfMjQgPSBNYXJpYURiRW5naW5lVmVyc2lvbi5vZignMTAuNC4yNCcsICcxMC40Jyk7XG4gIC8qKiBWZXJzaW9uIFwiMTAuNC4yNVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMF80XzI1ID0gTWFyaWFEYkVuZ2luZVZlcnNpb24ub2YoJzEwLjQuMjUnLCAnMTAuNCcpO1xuICAvKiogVmVyc2lvbiBcIjEwLjQuMjZcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTBfNF8yNiA9IE1hcmlhRGJFbmdpbmVWZXJzaW9uLm9mKCcxMC40LjI2JywgJzEwLjQnKTtcbiAgLyoqIFZlcnNpb24gXCIxMC40LjI3XCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzRfMjcgPSBNYXJpYURiRW5naW5lVmVyc2lvbi5vZignMTAuNC4yNycsICcxMC40JylcbiAgLyoqIFZlcnNpb24gXCIxMC40LjI4XCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzRfMjggPSBNYXJpYURiRW5naW5lVmVyc2lvbi5vZignMTAuNC4yOCcsICcxMC40JylcblxuICAvKiogVmVyc2lvbiBcIjEwLjVcIiAob25seSBhIG1ham9yIHZlcnNpb24sIHdpdGhvdXQgYSBzcGVjaWZpYyBtaW5vciB2ZXJzaW9uKS4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTBfNSA9IE1hcmlhRGJFbmdpbmVWZXJzaW9uLm9mKCcxMC41JywgJzEwLjUnKTtcbiAgLyoqIFZlcnNpb24gXCIxMC41LjhcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTBfNV84ID0gTWFyaWFEYkVuZ2luZVZlcnNpb24ub2YoJzEwLjUuOCcsICcxMC41Jyk7XG4gIC8qKiBWZXJzaW9uIFwiMTAuNS45XCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzVfOSA9IE1hcmlhRGJFbmdpbmVWZXJzaW9uLm9mKCcxMC41LjknLCAnMTAuNScpO1xuICAvKiogVmVyc2lvbiBcIjEwLjUuMTJcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTBfNV8xMiA9IE1hcmlhRGJFbmdpbmVWZXJzaW9uLm9mKCcxMC41LjEyJywgJzEwLjUnKTtcbiAgLyoqIFZlcnNpb24gXCIxMC41LjEzXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzVfMTMgPSBNYXJpYURiRW5naW5lVmVyc2lvbi5vZignMTAuNS4xMycsICcxMC41Jyk7XG4gIC8qKiBWZXJzaW9uIFwiMTAuNS4xNVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMF81XzE1ID0gTWFyaWFEYkVuZ2luZVZlcnNpb24ub2YoJzEwLjUuMTUnLCAnMTAuNScpO1xuICAvKiogVmVyc2lvbiBcIjEwLjUuMTZcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTBfNV8xNiA9IE1hcmlhRGJFbmdpbmVWZXJzaW9uLm9mKCcxMC41LjE2JywgJzEwLjUnKTtcbiAgLyoqIFZlcnNpb24gXCIxMC41LjE3XCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzVfMTcgPSBNYXJpYURiRW5naW5lVmVyc2lvbi5vZignMTAuNS4xNycsICcxMC41Jyk7XG4gIC8qKiBWZXJzaW9uIFwiMTAuNS4xOFwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMF81XzE4ID0gTWFyaWFEYkVuZ2luZVZlcnNpb24ub2YoJzEwLjUuMTgnLCAnMTAuNScpO1xuICAvKiogVmVyc2lvbiBcIjEwLjUuMTlcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTBfNV8xOSA9IE1hcmlhRGJFbmdpbmVWZXJzaW9uLm9mKCcxMC41LjE5JywgJzEwLjUnKTtcblxuICAvKiogVmVyc2lvbiBcIjEwLjZcIiAob25seSBhIG1ham9yIHZlcnNpb24sIHdpdGhvdXQgYSBzcGVjaWZpYyBtaW5vciB2ZXJzaW9uKS4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTBfNiA9IE1hcmlhRGJFbmdpbmVWZXJzaW9uLm9mKCcxMC42JywgJzEwLjYnKTtcbiAgLyoqIFZlcnNpb24gXCIxMC42LjVcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTBfNl81ID0gTWFyaWFEYkVuZ2luZVZlcnNpb24ub2YoJzEwLjYuNScsICcxMC42Jyk7XG4gIC8qKiBWZXJzaW9uIFwiMTAuNi43XCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzZfNyA9IE1hcmlhRGJFbmdpbmVWZXJzaW9uLm9mKCcxMC42LjcnLCAnMTAuNicpO1xuICAvKiogVmVyc2lvbiBcIjEwLjYuOFwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMF82XzggPSBNYXJpYURiRW5naW5lVmVyc2lvbi5vZignMTAuNi44JywgJzEwLjYnKTtcbiAgLyoqIFZlcnNpb24gXCIxMC42LjEwXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzZfMTAgPSBNYXJpYURiRW5naW5lVmVyc2lvbi5vZignMTAuNi4xMCcsICcxMC42Jyk7XG4gIC8qKiBWZXJzaW9uIFwiMTAuNi4xMVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMF82XzExID0gTWFyaWFEYkVuZ2luZVZlcnNpb24ub2YoJzEwLjYuMTEnLCAnMTAuNicpO1xuICAvKiogVmVyc2lvbiBcIjEwLjYuMTJcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTBfNl8xMiA9IE1hcmlhRGJFbmdpbmVWZXJzaW9uLm9mKCcxMC42LjEyJywgJzEwLjYnKTtcblxuXG4gIC8qKlxuICAgKiBDcmVhdGUgYSBuZXcgTWFyaWFEYkVuZ2luZVZlcnNpb24gd2l0aCBhbiBhcmJpdHJhcnkgdmVyc2lvbi5cbiAgICpcbiAgICogQHBhcmFtIG1hcmlhRGJGdWxsVmVyc2lvbiB0aGUgZnVsbCB2ZXJzaW9uIHN0cmluZyxcbiAgICogICBmb3IgZXhhbXBsZSBcIjEwLjUuMjhcIlxuICAgKiBAcGFyYW0gbWFyaWFEYk1ham9yVmVyc2lvbiB0aGUgbWFqb3IgdmVyc2lvbiBvZiB0aGUgZW5naW5lLFxuICAgKiAgIGZvciBleGFtcGxlIFwiMTAuNVwiXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIG9mKG1hcmlhRGJGdWxsVmVyc2lvbjogc3RyaW5nLCBtYXJpYURiTWFqb3JWZXJzaW9uOiBzdHJpbmcpOiBNYXJpYURiRW5naW5lVmVyc2lvbiB7XG4gICAgcmV0dXJuIG5ldyBNYXJpYURiRW5naW5lVmVyc2lvbihtYXJpYURiRnVsbFZlcnNpb24sIG1hcmlhRGJNYWpvclZlcnNpb24pO1xuICB9XG5cbiAgLyoqIFRoZSBmdWxsIHZlcnNpb24gc3RyaW5nLCBmb3IgZXhhbXBsZSwgXCIxMC41LjI4XCIuICovXG4gIHB1YmxpYyByZWFkb25seSBtYXJpYURiRnVsbFZlcnNpb246IHN0cmluZztcbiAgLyoqIFRoZSBtYWpvciB2ZXJzaW9uIG9mIHRoZSBlbmdpbmUsIGZvciBleGFtcGxlLCBcIjEwLjVcIi4gKi9cbiAgcHVibGljIHJlYWRvbmx5IG1hcmlhRGJNYWpvclZlcnNpb246IHN0cmluZztcblxuICBwcml2YXRlIGNvbnN0cnVjdG9yKG1hcmlhRGJGdWxsVmVyc2lvbjogc3RyaW5nLCBtYXJpYURiTWFqb3JWZXJzaW9uOiBzdHJpbmcpIHtcbiAgICB0aGlzLm1hcmlhRGJGdWxsVmVyc2lvbiA9IG1hcmlhRGJGdWxsVmVyc2lvbjtcbiAgICB0aGlzLm1hcmlhRGJNYWpvclZlcnNpb24gPSBtYXJpYURiTWFqb3JWZXJzaW9uO1xuICB9XG59XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgTWFyaWFEQiBpbnN0YW5jZSBlbmdpbmVzLlxuICogVXNlZCBpbiBgRGF0YWJhc2VJbnN0YW5jZUVuZ2luZS5tYXJpYURiYC5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBNYXJpYURiSW5zdGFuY2VFbmdpbmVQcm9wcyB7XG4gIC8qKiBUaGUgZXhhY3QgdmVyc2lvbiBvZiB0aGUgZW5naW5lIHRvIHVzZS4gKi9cbiAgcmVhZG9ubHkgdmVyc2lvbjogTWFyaWFEYkVuZ2luZVZlcnNpb247XG59XG5cbmNsYXNzIE1hcmlhRGJJbnN0YW5jZUVuZ2luZSBleHRlbmRzIEluc3RhbmNlRW5naW5lQmFzZSB7XG4gIHB1YmxpYyByZWFkb25seSBzdXBwb3J0c1JlYWRSZXBsaWNhQmFja3VwcyA9IHRydWU7XG5cbiAgY29uc3RydWN0b3IodmVyc2lvbj86IE1hcmlhRGJFbmdpbmVWZXJzaW9uKSB7XG4gICAgc3VwZXIoe1xuICAgICAgZW5naW5lVHlwZTogJ21hcmlhZGInLFxuICAgICAgc2luZ2xlVXNlclJvdGF0aW9uQXBwbGljYXRpb246IHNlY3JldHNtYW5hZ2VyLlNlY3JldFJvdGF0aW9uQXBwbGljYXRpb24uTUFSSUFEQl9ST1RBVElPTl9TSU5HTEVfVVNFUixcbiAgICAgIG11bHRpVXNlclJvdGF0aW9uQXBwbGljYXRpb246IHNlY3JldHNtYW5hZ2VyLlNlY3JldFJvdGF0aW9uQXBwbGljYXRpb24uTUFSSUFEQl9ST1RBVElPTl9NVUxUSV9VU0VSLFxuICAgICAgdmVyc2lvbjogdmVyc2lvblxuICAgICAgICA/IHtcbiAgICAgICAgICBmdWxsVmVyc2lvbjogdmVyc2lvbi5tYXJpYURiRnVsbFZlcnNpb24sXG4gICAgICAgICAgbWFqb3JWZXJzaW9uOiB2ZXJzaW9uLm1hcmlhRGJNYWpvclZlcnNpb24sXG4gICAgICAgIH1cbiAgICAgICAgOiB1bmRlZmluZWQsXG4gICAgfSk7XG4gIH1cblxuICBwdWJsaWMgYmluZFRvSW5zdGFuY2Uoc2NvcGU6IENvbnN0cnVjdCwgb3B0aW9uczogSW5zdGFuY2VFbmdpbmVCaW5kT3B0aW9ucyk6IEluc3RhbmNlRW5naW5lQ29uZmlnIHtcbiAgICBpZiAob3B0aW9ucy5kb21haW4pIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihgZG9tYWluIHByb3BlcnR5IGNhbm5vdCBiZSBjb25maWd1cmVkIGZvciAke3RoaXMuZW5naW5lVHlwZX1gKTtcbiAgICB9XG4gICAgcmV0dXJuIHN1cGVyLmJpbmRUb0luc3RhbmNlKHNjb3BlLCBvcHRpb25zKTtcbiAgfVxufVxuXG4vKipcbiAqIFRoZSB2ZXJzaW9ucyBmb3IgdGhlIE15U1FMIGluc3RhbmNlIGVuZ2luZXNcbiAqICh0aG9zZSByZXR1cm5lZCBieSBgRGF0YWJhc2VJbnN0YW5jZUVuZ2luZS5teXNxbGApLlxuICovXG5leHBvcnQgY2xhc3MgTXlzcWxFbmdpbmVWZXJzaW9uIHtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCI1LjVcIiAob25seSBhIG1ham9yIHZlcnNpb24sIHdpdGhvdXQgYSBzcGVjaWZpYyBtaW5vciB2ZXJzaW9uKS5cbiAgICogQGRlcHJlY2F0ZWQgTXlTUUwgNS41IGlzIG5vIGxvbmdlciBzdXBwb3J0ZWQgYnkgQW1hem9uIFJEUy5cbiAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfNV81ID0gTXlzcWxFbmdpbmVWZXJzaW9uLm9mKCc1LjUnLCAnNS41Jyk7XG4gIC8qKlxuICAgKiBWZXJzaW9uIFwiNS41LjQ2XCIuXG4gICAqIEBkZXByZWNhdGVkIE15U1FMIDUuNSBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzVfNV80NiA9IE15c3FsRW5naW5lVmVyc2lvbi5vZignNS41LjQ2JywgJzUuNScpO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjUuNS41M1wiLlxuICAgKiBAZGVwcmVjYXRlZCBNeVNRTCA1LjUgaXMgbm8gbG9uZ2VyIHN1cHBvcnRlZCBieSBBbWF6b24gUkRTLlxuICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl81XzVfNTMgPSBNeXNxbEVuZ2luZVZlcnNpb24ub2YoJzUuNS41MycsICc1LjUnKTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCI1LjUuNTdcIi5cbiAgICogQGRlcHJlY2F0ZWQgTXlTUUwgNS41IGlzIG5vIGxvbmdlciBzdXBwb3J0ZWQgYnkgQW1hem9uIFJEUy5cbiAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfNV81XzU3ID0gTXlzcWxFbmdpbmVWZXJzaW9uLm9mKCc1LjUuNTcnLCAnNS41Jyk7XG4gIC8qKlxuICAgKiBWZXJzaW9uIFwiNS41LjU5XCIuXG4gICAqIEBkZXByZWNhdGVkIE15U1FMIDUuNSBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzVfNV81OSA9IE15c3FsRW5naW5lVmVyc2lvbi5vZignNS41LjU5JywgJzUuNScpO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjUuNS42MVwiLlxuICAgKiBAZGVwcmVjYXRlZCBNeVNRTCA1LjUgaXMgbm8gbG9uZ2VyIHN1cHBvcnRlZCBieSBBbWF6b24gUkRTLlxuICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl81XzVfNjEgPSBNeXNxbEVuZ2luZVZlcnNpb24ub2YoJzUuNS42MScsICc1LjUnKTtcblxuICAvKipcbiAgICogVmVyc2lvbiBcIjUuNlwiIChvbmx5IGEgbWFqb3IgdmVyc2lvbiwgd2l0aG91dCBhIHNwZWNpZmljIG1pbm9yIHZlcnNpb24pLlxuICAgKiBAZGVwcmVjYXRlZCBNeVNRTCA1LjYgaXMgbm8gbG9uZ2VyIHN1cHBvcnRlZCBieSBBbWF6b24gUkRTLlxuICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl81XzYgPSBNeXNxbEVuZ2luZVZlcnNpb24ub2YoJzUuNicsICc1LjYnKTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCI1LjYuMzRcIi5cbiAgICogQGRlcHJlY2F0ZWQgTXlTUUwgNS42IGlzIG5vIGxvbmdlciBzdXBwb3J0ZWQgYnkgQW1hem9uIFJEUy5cbiAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfNV82XzM0ID0gTXlzcWxFbmdpbmVWZXJzaW9uLm9mKCc1LjYuMzQnLCAnNS42Jyk7XG4gIC8qKlxuICAgKiBWZXJzaW9uIFwiNS42LjM1XCIuXG4gICAqIEBkZXByZWNhdGVkIE15U1FMIDUuNiBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzVfNl8zNSA9IE15c3FsRW5naW5lVmVyc2lvbi5vZignNS42LjM1JywgJzUuNicpO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjUuNi4zN1wiLlxuICAgKiBAZGVwcmVjYXRlZCBNeVNRTCA1LjYgaXMgbm8gbG9uZ2VyIHN1cHBvcnRlZCBieSBBbWF6b24gUkRTLlxuICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl81XzZfMzcgPSBNeXNxbEVuZ2luZVZlcnNpb24ub2YoJzUuNi4zNycsICc1LjYnKTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCI1LjYuMzlcIi5cbiAgICogQGRlcHJlY2F0ZWQgTXlTUUwgNS42IGlzIG5vIGxvbmdlciBzdXBwb3J0ZWQgYnkgQW1hem9uIFJEUy5cbiAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfNV82XzM5ID0gTXlzcWxFbmdpbmVWZXJzaW9uLm9mKCc1LjYuMzknLCAnNS42Jyk7XG4gIC8qKlxuICAgKiBWZXJzaW9uIFwiNS42LjQwXCIuXG4gICAqIEBkZXByZWNhdGVkIE15U1FMIDUuNiBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzVfNl80MCA9IE15c3FsRW5naW5lVmVyc2lvbi5vZignNS42LjQwJywgJzUuNicpO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjUuNi40MVwiLlxuICAgKiBAZGVwcmVjYXRlZCBNeVNRTCA1LjYgaXMgbm8gbG9uZ2VyIHN1cHBvcnRlZCBieSBBbWF6b24gUkRTLlxuICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl81XzZfNDEgPSBNeXNxbEVuZ2luZVZlcnNpb24ub2YoJzUuNi40MScsICc1LjYnKTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCI1LjYuNDNcIi5cbiAgICogQGRlcHJlY2F0ZWQgTXlTUUwgNS42IGlzIG5vIGxvbmdlciBzdXBwb3J0ZWQgYnkgQW1hem9uIFJEUy5cbiAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfNV82XzQzID0gTXlzcWxFbmdpbmVWZXJzaW9uLm9mKCc1LjYuNDMnLCAnNS42Jyk7XG4gIC8qKlxuICAgKiBWZXJzaW9uIFwiNS42LjQ0XCIuXG4gICAqIEBkZXByZWNhdGVkIE15U1FMIDUuNiBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzVfNl80NCA9IE15c3FsRW5naW5lVmVyc2lvbi5vZignNS42LjQ0JywgJzUuNicpO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjUuNi40NlwiLlxuICAgKiBAZGVwcmVjYXRlZCBNeVNRTCA1LjYgaXMgbm8gbG9uZ2VyIHN1cHBvcnRlZCBieSBBbWF6b24gUkRTLlxuICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl81XzZfNDYgPSBNeXNxbEVuZ2luZVZlcnNpb24ub2YoJzUuNi40NicsICc1LjYnKTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCI1LjYuNDhcIi5cbiAgICogQGRlcHJlY2F0ZWQgTXlTUUwgNS42IGlzIG5vIGxvbmdlciBzdXBwb3J0ZWQgYnkgQW1hem9uIFJEUy5cbiAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfNV82XzQ4ID0gTXlzcWxFbmdpbmVWZXJzaW9uLm9mKCc1LjYuNDgnLCAnNS42Jyk7XG4gIC8qKlxuICAgKiBWZXJzaW9uIFwiNS42LjQ5XCIuXG4gICAqIEBkZXByZWNhdGVkIE15U1FMIDUuNiBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzVfNl80OSA9IE15c3FsRW5naW5lVmVyc2lvbi5vZignNS42LjQ5JywgJzUuNicpO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjUuNi41MVwiLlxuICAgKiBAZGVwcmVjYXRlZCBNeVNRTCA1LjYgaXMgbm8gbG9uZ2VyIHN1cHBvcnRlZCBieSBBbWF6b24gUkRTLlxuICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl81XzZfNTEgPSBNeXNxbEVuZ2luZVZlcnNpb24ub2YoJzUuNi41MScsICc1LjYnKTtcblxuICAvKiogVmVyc2lvbiBcIjUuN1wiIChvbmx5IGEgbWFqb3IgdmVyc2lvbiwgd2l0aG91dCBhIHNwZWNpZmljIG1pbm9yIHZlcnNpb24pLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl81XzcgPSBNeXNxbEVuZ2luZVZlcnNpb24ub2YoJzUuNycsICc1LjcnKTtcbiAgLyoqIFZlcnNpb24gXCI1LjcuMTZcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfNV83XzE2ID0gTXlzcWxFbmdpbmVWZXJzaW9uLm9mKCc1LjcuMTYnLCAnNS43Jyk7XG4gIC8qKiBWZXJzaW9uIFwiNS43LjE3XCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzVfN18xNyA9IE15c3FsRW5naW5lVmVyc2lvbi5vZignNS43LjE3JywgJzUuNycpO1xuICAvKiogVmVyc2lvbiBcIjUuNy4xOVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl81XzdfMTkgPSBNeXNxbEVuZ2luZVZlcnNpb24ub2YoJzUuNy4xOScsICc1LjcnKTtcbiAgLyoqIFZlcnNpb24gXCI1LjcuMjFcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfNV83XzIxID0gTXlzcWxFbmdpbmVWZXJzaW9uLm9mKCc1LjcuMjEnLCAnNS43Jyk7XG4gIC8qKiBWZXJzaW9uIFwiNS43LjIyXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzVfN18yMiA9IE15c3FsRW5naW5lVmVyc2lvbi5vZignNS43LjIyJywgJzUuNycpO1xuICAvKiogVmVyc2lvbiBcIjUuNy4yM1wiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl81XzdfMjMgPSBNeXNxbEVuZ2luZVZlcnNpb24ub2YoJzUuNy4yMycsICc1LjcnKTtcbiAgLyoqIFZlcnNpb24gXCI1LjcuMjRcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfNV83XzI0ID0gTXlzcWxFbmdpbmVWZXJzaW9uLm9mKCc1LjcuMjQnLCAnNS43Jyk7XG4gIC8qKiBWZXJzaW9uIFwiNS43LjI1XCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzVfN18yNSA9IE15c3FsRW5naW5lVmVyc2lvbi5vZignNS43LjI1JywgJzUuNycpO1xuICAvKiogVmVyc2lvbiBcIjUuNy4yNlwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl81XzdfMjYgPSBNeXNxbEVuZ2luZVZlcnNpb24ub2YoJzUuNy4yNicsICc1LjcnKTtcbiAgLyoqIFZlcnNpb24gXCI1LjcuMjhcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfNV83XzI4ID0gTXlzcWxFbmdpbmVWZXJzaW9uLm9mKCc1LjcuMjgnLCAnNS43Jyk7XG4gIC8qKiBWZXJzaW9uIFwiNS43LjMwXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzVfN18zMCA9IE15c3FsRW5naW5lVmVyc2lvbi5vZignNS43LjMwJywgJzUuNycpO1xuICAvKiogVmVyc2lvbiBcIjUuNy4zMVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl81XzdfMzEgPSBNeXNxbEVuZ2luZVZlcnNpb24ub2YoJzUuNy4zMScsICc1LjcnKTtcbiAgLyoqIFZlcnNpb24gXCI1LjcuMzNcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfNV83XzMzID0gTXlzcWxFbmdpbmVWZXJzaW9uLm9mKCc1LjcuMzMnLCAnNS43Jyk7XG4gIC8qKiBWZXJzaW9uIFwiNS43LjM0XCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzVfN18zNCA9IE15c3FsRW5naW5lVmVyc2lvbi5vZignNS43LjM0JywgJzUuNycpO1xuICAvKiogVmVyc2lvbiBcIjUuNy4zNVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl81XzdfMzUgPSBNeXNxbEVuZ2luZVZlcnNpb24ub2YoJzUuNy4zNScsICc1LjcnKTtcbiAgLyoqIFZlcnNpb24gXCI1LjcuMzZcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfNV83XzM2ID0gTXlzcWxFbmdpbmVWZXJzaW9uLm9mKCc1LjcuMzYnLCAnNS43Jyk7XG4gIC8qKiBWZXJzaW9uIFwiNS43LjM3XCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzVfN18zNyA9IE15c3FsRW5naW5lVmVyc2lvbi5vZignNS43LjM3JywgJzUuNycpO1xuICAvKiogVmVyc2lvbiBcIjUuNy4zOFwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl81XzdfMzggPSBNeXNxbEVuZ2luZVZlcnNpb24ub2YoJzUuNy4zOCcsICc1LjcnKTtcbiAgLyoqIFZlcnNpb24gXCI1LjcuMzlcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfNV83XzM5ID0gTXlzcWxFbmdpbmVWZXJzaW9uLm9mKCc1LjcuMzknLCAnNS43Jyk7XG4gIC8qKiBWZXJzaW9uIFwiNS43LjQwXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzVfN180MCA9IE15c3FsRW5naW5lVmVyc2lvbi5vZignNS43LjQwJywgJzUuNycpO1xuICAvKiogVmVyc2lvbiBcIjUuNy40MVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl81XzdfNDEgPSBNeXNxbEVuZ2luZVZlcnNpb24ub2YoJzUuNy40MScsICc1LjcnKTtcblxuICAvKiogVmVyc2lvbiBcIjguMFwiIChvbmx5IGEgbWFqb3IgdmVyc2lvbiwgd2l0aG91dCBhIHNwZWNpZmljIG1pbm9yIHZlcnNpb24pLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl84XzAgPSBNeXNxbEVuZ2luZVZlcnNpb24ub2YoJzguMCcsICc4LjAnKTtcbiAgLyoqIFZlcnNpb24gXCI4LjAuMTFcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfOF8wXzExID0gTXlzcWxFbmdpbmVWZXJzaW9uLm9mKCc4LjAuMTEnLCAnOC4wJyk7XG4gIC8qKiBWZXJzaW9uIFwiOC4wLjEzXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzhfMF8xMyA9IE15c3FsRW5naW5lVmVyc2lvbi5vZignOC4wLjEzJywgJzguMCcpO1xuICAvKiogVmVyc2lvbiBcIjguMC4xNVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl84XzBfMTUgPSBNeXNxbEVuZ2luZVZlcnNpb24ub2YoJzguMC4xNScsICc4LjAnKTtcbiAgLyoqIFZlcnNpb24gXCI4LjAuMTZcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfOF8wXzE2ID0gTXlzcWxFbmdpbmVWZXJzaW9uLm9mKCc4LjAuMTYnLCAnOC4wJyk7XG4gIC8qKiBWZXJzaW9uIFwiOC4wLjE3XCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzhfMF8xNyA9IE15c3FsRW5naW5lVmVyc2lvbi5vZignOC4wLjE3JywgJzguMCcpO1xuICAvKiogVmVyc2lvbiBcIjguMC4xOVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl84XzBfMTkgPSBNeXNxbEVuZ2luZVZlcnNpb24ub2YoJzguMC4xOScsICc4LjAnKTtcbiAgLyoqIFZlcnNpb24gXCI4LjAuMjAgXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzhfMF8yMCA9IE15c3FsRW5naW5lVmVyc2lvbi5vZignOC4wLjIwJywgJzguMCcpO1xuICAvKiogVmVyc2lvbiBcIjguMC4yMSBcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfOF8wXzIxID0gTXlzcWxFbmdpbmVWZXJzaW9uLm9mKCc4LjAuMjEnLCAnOC4wJyk7XG4gIC8qKiBWZXJzaW9uIFwiOC4wLjIzXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzhfMF8yMyA9IE15c3FsRW5naW5lVmVyc2lvbi5vZignOC4wLjIzJywgJzguMCcpO1xuICAvKiogVmVyc2lvbiBcIjguMC4yNVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl84XzBfMjUgPSBNeXNxbEVuZ2luZVZlcnNpb24ub2YoJzguMC4yNScsICc4LjAnKTtcbiAgLyoqIFZlcnNpb24gXCI4LjAuMjZcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfOF8wXzI2ID0gTXlzcWxFbmdpbmVWZXJzaW9uLm9mKCc4LjAuMjYnLCAnOC4wJyk7XG4gIC8qKiBWZXJzaW9uIFwiOC4wLjI3XCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzhfMF8yNyA9IE15c3FsRW5naW5lVmVyc2lvbi5vZignOC4wLjI3JywgJzguMCcpO1xuICAvKiogVmVyc2lvbiBcIjguMC4yOFwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl84XzBfMjggPSBNeXNxbEVuZ2luZVZlcnNpb24ub2YoJzguMC4yOCcsICc4LjAnKTtcbiAgLyoqIFZlcnNpb24gXCI4LjAuMzBcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfOF8wXzMwID0gTXlzcWxFbmdpbmVWZXJzaW9uLm9mKCc4LjAuMzAnLCAnOC4wJyk7XG4gIC8qKiBWZXJzaW9uIFwiOC4wLjMxXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzhfMF8zMSA9IE15c3FsRW5naW5lVmVyc2lvbi5vZignOC4wLjMxJywgJzguMCcpO1xuICAvKiogVmVyc2lvbiBcIjguMC4zMlwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl84XzBfMzIgPSBNeXNxbEVuZ2luZVZlcnNpb24ub2YoJzguMC4zMicsICc4LjAnKTtcblxuICAvKipcbiAgICogQ3JlYXRlIGEgbmV3IE15c3FsRW5naW5lVmVyc2lvbiB3aXRoIGFuIGFyYml0cmFyeSB2ZXJzaW9uLlxuICAgKlxuICAgKiBAcGFyYW0gbXlzcWxGdWxsVmVyc2lvbiB0aGUgZnVsbCB2ZXJzaW9uIHN0cmluZyxcbiAgICogICBmb3IgZXhhbXBsZSBcIjguMS40M1wiXG4gICAqIEBwYXJhbSBteXNxbE1ham9yVmVyc2lvbiB0aGUgbWFqb3IgdmVyc2lvbiBvZiB0aGUgZW5naW5lLFxuICAgKiAgIGZvciBleGFtcGxlIFwiOC4xXCJcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgb2YobXlzcWxGdWxsVmVyc2lvbjogc3RyaW5nLCBteXNxbE1ham9yVmVyc2lvbjogc3RyaW5nKTogTXlzcWxFbmdpbmVWZXJzaW9uIHtcbiAgICByZXR1cm4gbmV3IE15c3FsRW5naW5lVmVyc2lvbihteXNxbEZ1bGxWZXJzaW9uLCBteXNxbE1ham9yVmVyc2lvbik7XG4gIH1cblxuICAvKiogVGhlIGZ1bGwgdmVyc2lvbiBzdHJpbmcsIGZvciBleGFtcGxlLCBcIjEwLjUuMjhcIi4gKi9cbiAgcHVibGljIHJlYWRvbmx5IG15c3FsRnVsbFZlcnNpb246IHN0cmluZztcbiAgLyoqIFRoZSBtYWpvciB2ZXJzaW9uIG9mIHRoZSBlbmdpbmUsIGZvciBleGFtcGxlLCBcIjEwLjVcIi4gKi9cbiAgcHVibGljIHJlYWRvbmx5IG15c3FsTWFqb3JWZXJzaW9uOiBzdHJpbmc7XG5cbiAgcHJpdmF0ZSBjb25zdHJ1Y3RvcihteXNxbEZ1bGxWZXJzaW9uOiBzdHJpbmcsIG15c3FsTWFqb3JWZXJzaW9uOiBzdHJpbmcpIHtcbiAgICB0aGlzLm15c3FsRnVsbFZlcnNpb24gPSBteXNxbEZ1bGxWZXJzaW9uO1xuICAgIHRoaXMubXlzcWxNYWpvclZlcnNpb24gPSBteXNxbE1ham9yVmVyc2lvbjtcbiAgfVxufVxuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIE15U1FMIGluc3RhbmNlIGVuZ2luZXMuXG4gKiBVc2VkIGluIGBEYXRhYmFzZUluc3RhbmNlRW5naW5lLm15c3FsYC5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBNeVNxbEluc3RhbmNlRW5naW5lUHJvcHMge1xuICAvKiogVGhlIGV4YWN0IHZlcnNpb24gb2YgdGhlIGVuZ2luZSB0byB1c2UuICovXG4gIHJlYWRvbmx5IHZlcnNpb246IE15c3FsRW5naW5lVmVyc2lvbjtcbn1cblxuY2xhc3MgTXlTcWxJbnN0YW5jZUVuZ2luZSBleHRlbmRzIEluc3RhbmNlRW5naW5lQmFzZSB7XG4gIHB1YmxpYyByZWFkb25seSBzdXBwb3J0c1JlYWRSZXBsaWNhQmFja3VwcyA9IHRydWU7XG5cbiAgY29uc3RydWN0b3IodmVyc2lvbj86IE15c3FsRW5naW5lVmVyc2lvbikge1xuICAgIHN1cGVyKHtcbiAgICAgIGVuZ2luZVR5cGU6ICdteXNxbCcsXG4gICAgICBzaW5nbGVVc2VyUm90YXRpb25BcHBsaWNhdGlvbjogc2VjcmV0c21hbmFnZXIuU2VjcmV0Um90YXRpb25BcHBsaWNhdGlvbi5NWVNRTF9ST1RBVElPTl9TSU5HTEVfVVNFUixcbiAgICAgIG11bHRpVXNlclJvdGF0aW9uQXBwbGljYXRpb246IHNlY3JldHNtYW5hZ2VyLlNlY3JldFJvdGF0aW9uQXBwbGljYXRpb24uTVlTUUxfUk9UQVRJT05fTVVMVElfVVNFUixcbiAgICAgIHZlcnNpb246IHZlcnNpb25cbiAgICAgICAgPyB7XG4gICAgICAgICAgZnVsbFZlcnNpb246IHZlcnNpb24ubXlzcWxGdWxsVmVyc2lvbixcbiAgICAgICAgICBtYWpvclZlcnNpb246IHZlcnNpb24ubXlzcWxNYWpvclZlcnNpb24sXG4gICAgICAgIH1cbiAgICAgICAgOiB1bmRlZmluZWQsXG4gICAgICBlbmdpbmVGYW1pbHk6ICdNWVNRTCcsXG4gICAgfSk7XG4gIH1cbn1cblxuLyoqXG4gKiBGZWF0dXJlcyBzdXBwb3J0ZWQgYnkgdGhlIFBvc3RncmVzIGRhdGFiYXNlIGVuZ2luZVxuICovXG5leHBvcnQgaW50ZXJmYWNlIFBvc3RncmVzRW5naW5lRmVhdHVyZXMge1xuICAvKipcbiAgICogV2hldGhlciB0aGlzIHZlcnNpb24gb2YgdGhlIFBvc3RncmVzIGVuZ2luZSBzdXBwb3J0cyB0aGUgUzMgZGF0YSBpbXBvcnQgZmVhdHVyZS5cbiAgICpcbiAgICogQGRlZmF1bHQgZmFsc2VcbiAgICovXG4gIHJlYWRvbmx5IHMzSW1wb3J0PzogYm9vbGVhbjtcblxuICAvKipcbiAgICogV2hldGhlciB0aGlzIHZlcnNpb24gb2YgdGhlIFBvc3RncmVzIGVuZ2luZSBzdXBwb3J0cyB0aGUgUzMgZGF0YSBleHBvcnQgZmVhdHVyZS5cbiAgICpcbiAgICogQGRlZmF1bHQgZmFsc2VcbiAgICovXG4gIHJlYWRvbmx5IHMzRXhwb3J0PzogYm9vbGVhbjtcbn1cblxuLyoqXG4gKiBUaGUgdmVyc2lvbnMgZm9yIHRoZSBQb3N0Z3JlU1FMIGluc3RhbmNlIGVuZ2luZXNcbiAqICh0aG9zZSByZXR1cm5lZCBieSBgRGF0YWJhc2VJbnN0YW5jZUVuZ2luZS5wb3N0Z3Jlc2ApLlxuICovXG5leHBvcnQgY2xhc3MgUG9zdGdyZXNFbmdpbmVWZXJzaW9uIHtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCI5LjVcIiAob25seSBhIG1ham9yIHZlcnNpb24sIHdpdGhvdXQgYSBzcGVjaWZpYyBtaW5vciB2ZXJzaW9uKS5cbiAgICogQGRlcHJlY2F0ZWQgUG9zdGdyZVNRTCA5LjUgaXMgbm8gbG9uZ2VyIHN1cHBvcnRlZCBieSBBbWF6b24gUkRTLlxuICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl85XzUgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzkuNScsICc5LjUnKTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCI5LjUuMlwiLlxuICAgKiBAZGVwcmVjYXRlZCBQb3N0Z3JlU1FMIDkuNSBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzlfNV8yID0gUG9zdGdyZXNFbmdpbmVWZXJzaW9uLm9mKCc5LjUuMicsICc5LjUnKTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCI5LjUuNFwiLlxuICAgKiBAZGVwcmVjYXRlZCBQb3N0Z3JlU1FMIDkuNSBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzlfNV80ID0gUG9zdGdyZXNFbmdpbmVWZXJzaW9uLm9mKCc5LjUuNCcsICc5LjUnKTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCI5LjUuNlwiLlxuICAgKiBAZGVwcmVjYXRlZCBQb3N0Z3JlU1FMIDkuNSBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzlfNV82ID0gUG9zdGdyZXNFbmdpbmVWZXJzaW9uLm9mKCc5LjUuNicsICc5LjUnKTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCI5LjUuN1wiLlxuICAgKiBAZGVwcmVjYXRlZCBQb3N0Z3JlU1FMIDkuNSBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzlfNV83ID0gUG9zdGdyZXNFbmdpbmVWZXJzaW9uLm9mKCc5LjUuNycsICc5LjUnKTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCI5LjUuOVwiLlxuICAgKiBAZGVwcmVjYXRlZCBQb3N0Z3JlU1FMIDkuNSBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzlfNV85ID0gUG9zdGdyZXNFbmdpbmVWZXJzaW9uLm9mKCc5LjUuOScsICc5LjUnKTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCI5LjUuMTBcIi5cbiAgICogQGRlcHJlY2F0ZWQgUG9zdGdyZVNRTCA5LjUgaXMgbm8gbG9uZ2VyIHN1cHBvcnRlZCBieSBBbWF6b24gUkRTLlxuICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl85XzVfMTAgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzkuNS4xMCcsICc5LjUnKTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCI5LjUuMTJcIi5cbiAgICogQGRlcHJlY2F0ZWQgUG9zdGdyZVNRTCA5LjUgaXMgbm8gbG9uZ2VyIHN1cHBvcnRlZCBieSBBbWF6b24gUkRTLlxuICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl85XzVfMTIgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzkuNS4xMicsICc5LjUnKTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCI5LjUuMTNcIi5cbiAgICogQGRlcHJlY2F0ZWQgUG9zdGdyZVNRTCA5LjUgaXMgbm8gbG9uZ2VyIHN1cHBvcnRlZCBieSBBbWF6b24gUkRTLlxuICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl85XzVfMTMgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzkuNS4xMycsICc5LjUnKTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCI5LjUuMTRcIi5cbiAgICogQGRlcHJlY2F0ZWQgUG9zdGdyZVNRTCA5LjUgaXMgbm8gbG9uZ2VyIHN1cHBvcnRlZCBieSBBbWF6b24gUkRTLlxuICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl85XzVfMTQgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzkuNS4xNCcsICc5LjUnKTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCI5LjUuMTVcIi5cbiAgICogQGRlcHJlY2F0ZWQgUG9zdGdyZVNRTCA5LjUgaXMgbm8gbG9uZ2VyIHN1cHBvcnRlZCBieSBBbWF6b24gUkRTLlxuICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl85XzVfMTUgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzkuNS4xNScsICc5LjUnKTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCI5LjUuMTZcIi5cbiAgICogQGRlcHJlY2F0ZWQgUG9zdGdyZVNRTCA5LjUgaXMgbm8gbG9uZ2VyIHN1cHBvcnRlZCBieSBBbWF6b24gUkRTLlxuICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl85XzVfMTYgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzkuNS4xNicsICc5LjUnKTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCI5LjUuMThcIi5cbiAgICogQGRlcHJlY2F0ZWQgUG9zdGdyZVNRTCA5LjUgaXMgbm8gbG9uZ2VyIHN1cHBvcnRlZCBieSBBbWF6b24gUkRTLlxuICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl85XzVfMTggPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzkuNS4xOCcsICc5LjUnKTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCI5LjUuMTlcIi5cbiAgICogQGRlcHJlY2F0ZWQgUG9zdGdyZVNRTCA5LjUgaXMgbm8gbG9uZ2VyIHN1cHBvcnRlZCBieSBBbWF6b24gUkRTLlxuICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl85XzVfMTkgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzkuNS4xOScsICc5LjUnKTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCI5LjUuMjBcIi5cbiAgICogQGRlcHJlY2F0ZWQgUG9zdGdyZVNRTCA5LjUgaXMgbm8gbG9uZ2VyIHN1cHBvcnRlZCBieSBBbWF6b24gUkRTLlxuICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl85XzVfMjAgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzkuNS4yMCcsICc5LjUnKTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCI5LjUuMjFcIi5cbiAgICogQGRlcHJlY2F0ZWQgUG9zdGdyZVNRTCA5LjUgaXMgbm8gbG9uZ2VyIHN1cHBvcnRlZCBieSBBbWF6b24gUkRTLlxuICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl85XzVfMjEgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzkuNS4yMScsICc5LjUnKTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCI5LjUuMjJcIi5cbiAgICogQGRlcHJlY2F0ZWQgUG9zdGdyZVNRTCA5LjUgaXMgbm8gbG9uZ2VyIHN1cHBvcnRlZCBieSBBbWF6b24gUkRTLlxuICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl85XzVfMjIgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzkuNS4yMicsICc5LjUnKTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCI5LjUuMjNcIi5cbiAgICogQGRlcHJlY2F0ZWQgUG9zdGdyZVNRTCA5LjUgaXMgbm8gbG9uZ2VyIHN1cHBvcnRlZCBieSBBbWF6b24gUkRTLlxuICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl85XzVfMjMgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzkuNS4yMycsICc5LjUnKTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCI5LjUuMjRcIi5cbiAgICogQGRlcHJlY2F0ZWQgUG9zdGdyZVNRTCA5LjUgaXMgbm8gbG9uZ2VyIHN1cHBvcnRlZCBieSBBbWF6b24gUkRTLlxuICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl85XzVfMjQgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzkuNS4yNCcsICc5LjUnKTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCI5LjUuMjVcIi5cbiAgICogQGRlcHJlY2F0ZWQgUG9zdGdyZVNRTCA5LjUgaXMgbm8gbG9uZ2VyIHN1cHBvcnRlZCBieSBBbWF6b24gUkRTLlxuICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl85XzVfMjUgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzkuNS4yNScsICc5LjUnKTtcblxuICAvKipcbiAgICogVmVyc2lvbiBcIjkuNlwiIChvbmx5IGEgbWFqb3IgdmVyc2lvbiwgd2l0aG91dCBhIHNwZWNpZmljIG1pbm9yIHZlcnNpb24pLlxuICAgKiBAZGVwcmVjYXRlZCBQb3N0Z3JlU1FMIDkuNiBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzlfNiA9IFBvc3RncmVzRW5naW5lVmVyc2lvbi5vZignOS42JywgJzkuNicpO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjkuNi4xXCIuXG4gICAqIEBkZXByZWNhdGVkIFBvc3RncmVTUUwgOS42IGlzIG5vIGxvbmdlciBzdXBwb3J0ZWQgYnkgQW1hem9uIFJEUy5cbiAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfOV82XzEgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzkuNi4xJywgJzkuNicpO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjkuNi4yXCIuXG4gICAqIEBkZXByZWNhdGVkIFBvc3RncmVTUUwgOS42IGlzIG5vIGxvbmdlciBzdXBwb3J0ZWQgYnkgQW1hem9uIFJEUy5cbiAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfOV82XzIgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzkuNi4yJywgJzkuNicpO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjkuNi4zXCIuXG4gICAqIEBkZXByZWNhdGVkIFBvc3RncmVTUUwgOS42IGlzIG5vIGxvbmdlciBzdXBwb3J0ZWQgYnkgQW1hem9uIFJEUy5cbiAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfOV82XzMgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzkuNi4zJywgJzkuNicpO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjkuNi41XCIuXG4gICAqIEBkZXByZWNhdGVkIFBvc3RncmVTUUwgOS42IGlzIG5vIGxvbmdlciBzdXBwb3J0ZWQgYnkgQW1hem9uIFJEUy5cbiAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfOV82XzUgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzkuNi41JywgJzkuNicpO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjkuNi42XCIuXG4gICAqIEBkZXByZWNhdGVkIFBvc3RncmVTUUwgOS42IGlzIG5vIGxvbmdlciBzdXBwb3J0ZWQgYnkgQW1hem9uIFJEUy5cbiAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfOV82XzYgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzkuNi42JywgJzkuNicpO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjkuNi44XCIuXG4gICAqIEBkZXByZWNhdGVkIFBvc3RncmVTUUwgOS42IGlzIG5vIGxvbmdlciBzdXBwb3J0ZWQgYnkgQW1hem9uIFJEUy5cbiAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfOV82XzggPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzkuNi44JywgJzkuNicpO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjkuNi45XCIuXG4gICAqIEBkZXByZWNhdGVkIFBvc3RncmVTUUwgOS42IGlzIG5vIGxvbmdlciBzdXBwb3J0ZWQgYnkgQW1hem9uIFJEUy5cbiAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfOV82XzkgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzkuNi45JywgJzkuNicpO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjkuNi4xMFwiLlxuICAgKiBAZGVwcmVjYXRlZCBQb3N0Z3JlU1FMIDkuNiBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzlfNl8xMCA9IFBvc3RncmVzRW5naW5lVmVyc2lvbi5vZignOS42LjEwJywgJzkuNicpO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjkuNi4xMVwiLlxuICAgKiBAZGVwcmVjYXRlZCBQb3N0Z3JlU1FMIDkuNiBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzlfNl8xMSA9IFBvc3RncmVzRW5naW5lVmVyc2lvbi5vZignOS42LjExJywgJzkuNicpO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjkuNi4xMlwiLlxuICAgKiBAZGVwcmVjYXRlZCBQb3N0Z3JlU1FMIDkuNiBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzlfNl8xMiA9IFBvc3RncmVzRW5naW5lVmVyc2lvbi5vZignOS42LjEyJywgJzkuNicpO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjkuNi4xNFwiLlxuICAgKiBAZGVwcmVjYXRlZCBQb3N0Z3JlU1FMIDkuNiBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzlfNl8xNCA9IFBvc3RncmVzRW5naW5lVmVyc2lvbi5vZignOS42LjE0JywgJzkuNicpO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjkuNi4xNVwiLlxuICAgKiBAZGVwcmVjYXRlZCBQb3N0Z3JlU1FMIDkuNiBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzlfNl8xNSA9IFBvc3RncmVzRW5naW5lVmVyc2lvbi5vZignOS42LjE1JywgJzkuNicpO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjkuNi4xNlwiLlxuICAgKiBAZGVwcmVjYXRlZCBQb3N0Z3JlU1FMIDkuNiBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzlfNl8xNiA9IFBvc3RncmVzRW5naW5lVmVyc2lvbi5vZignOS42LjE2JywgJzkuNicpO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjkuNi4xN1wiLlxuICAgKiBAZGVwcmVjYXRlZCBQb3N0Z3JlU1FMIDkuNiBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzlfNl8xNyA9IFBvc3RncmVzRW5naW5lVmVyc2lvbi5vZignOS42LjE3JywgJzkuNicpO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjkuNi4xOFwiLlxuICAgKiBAZGVwcmVjYXRlZCBQb3N0Z3JlU1FMIDkuNiBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzlfNl8xOCA9IFBvc3RncmVzRW5naW5lVmVyc2lvbi5vZignOS42LjE4JywgJzkuNicpO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjkuNi4xOVwiLlxuICAgKiBAZGVwcmVjYXRlZCBQb3N0Z3JlU1FMIDkuNiBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzlfNl8xOSA9IFBvc3RncmVzRW5naW5lVmVyc2lvbi5vZignOS42LjE5JywgJzkuNicpO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjkuNi4yMFwiLlxuICAgKiBAZGVwcmVjYXRlZCBQb3N0Z3JlU1FMIDkuNiBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzlfNl8yMCA9IFBvc3RncmVzRW5naW5lVmVyc2lvbi5vZignOS42LjIwJywgJzkuNicpO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjkuNi4yMVwiLlxuICAgKiBAZGVwcmVjYXRlZCBQb3N0Z3JlU1FMIDkuNiBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzlfNl8yMSA9IFBvc3RncmVzRW5naW5lVmVyc2lvbi5vZignOS42LjIxJywgJzkuNicpO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjkuNi4yMlwiLlxuICAgKiBAZGVwcmVjYXRlZCBQb3N0Z3JlU1FMIDkuNiBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzlfNl8yMiA9IFBvc3RncmVzRW5naW5lVmVyc2lvbi5vZignOS42LjIyJywgJzkuNicpO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjkuNi4yM1wiLlxuICAgKiBAZGVwcmVjYXRlZCBQb3N0Z3JlU1FMIDkuNiBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzlfNl8yMyA9IFBvc3RncmVzRW5naW5lVmVyc2lvbi5vZignOS42LjIzJywgJzkuNicpO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjkuNi4yNFwiLlxuICAgKiBAZGVwcmVjYXRlZCBQb3N0Z3JlU1FMIDkuNiBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzlfNl8yNCA9IFBvc3RncmVzRW5naW5lVmVyc2lvbi5vZignOS42LjI0JywgJzkuNicpO1xuXG4gIC8qKlxuICAgKiBWZXJzaW9uIFwiMTBcIiAob25seSBhIG1ham9yIHZlcnNpb24sIHdpdGhvdXQgYSBzcGVjaWZpYyBtaW5vciB2ZXJzaW9uKS5cbiAgICogQGRlcHJlY2F0ZWQgUG9zdGdyZVNRTCAxMCBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwID0gUG9zdGdyZXNFbmdpbmVWZXJzaW9uLm9mKCcxMCcsICcxMCcpO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjEwLjFcIi5cbiAgICogQGRlcHJlY2F0ZWQgUG9zdGdyZVNRTCAxMCBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzEgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzEwLjEnLCAnMTAnKTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCIxMC4zXCIuXG4gICAqIEBkZXByZWNhdGVkIFBvc3RncmVTUUwgMTAuMyBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzMgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzEwLjMnLCAnMTAnKTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCIxMC40XCIuXG4gICAqIEBkZXByZWNhdGVkIFBvc3RncmVTUUwgMTAuNCBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzQgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzEwLjQnLCAnMTAnKTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCIxMC41XCIuXG4gICAqIEBkZXByZWNhdGVkIFBvc3RncmVTUUwgMTAuNSBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzUgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzEwLjUnLCAnMTAnKTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCIxMC42XCIuXG4gICAqIEBkZXByZWNhdGVkIFBvc3RncmVTUUwgMTAuNiBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzYgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzEwLjYnLCAnMTAnKTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCIxMC43XCIuXG4gICAqIEBkZXByZWNhdGVkIFBvc3RncmVTUUwgMTAuNyBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzcgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzEwLjcnLCAnMTAnLCB7IHMzSW1wb3J0OiB0cnVlIH0pO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjEwLjlcIi5cbiAgICogQGRlcHJlY2F0ZWQgUG9zdGdyZVNRTCAxMC45IGlzIG5vIGxvbmdlciBzdXBwb3J0ZWQgYnkgQW1hem9uIFJEUy5cbiAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTBfOSA9IFBvc3RncmVzRW5naW5lVmVyc2lvbi5vZignMTAuOScsICcxMCcsIHsgczNJbXBvcnQ6IHRydWUgfSk7XG4gIC8qKlxuICAgKiBWZXJzaW9uIFwiMTAuMTBcIi5cbiAgICogQGRlcHJlY2F0ZWQgUG9zdGdyZVNRTCAxMC4xMCBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzEwID0gUG9zdGdyZXNFbmdpbmVWZXJzaW9uLm9mKCcxMC4xMCcsICcxMCcsIHsgczNJbXBvcnQ6IHRydWUgfSk7XG4gIC8qKlxuICAgKiBWZXJzaW9uIFwiMTAuMTFcIi5cbiAgICogQGRlcHJlY2F0ZWQgUG9zdGdyZVNRTCAxMC4xMSBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzExID0gUG9zdGdyZXNFbmdpbmVWZXJzaW9uLm9mKCcxMC4xMScsICcxMCcsIHsgczNJbXBvcnQ6IHRydWUgfSk7XG4gIC8qKlxuICAgKiBWZXJzaW9uIFwiMTAuMTJcIi5cbiAgICogQGRlcHJlY2F0ZWQgUG9zdGdyZVNRTCAxMC4xMiBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzEyID0gUG9zdGdyZXNFbmdpbmVWZXJzaW9uLm9mKCcxMC4xMicsICcxMCcsIHsgczNJbXBvcnQ6IHRydWUgfSk7XG4gIC8qKlxuICAgKiBWZXJzaW9uIFwiMTAuMTNcIi5cbiAgICogQGRlcHJlY2F0ZWQgUG9zdGdyZVNRTCAxMC4xMyBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzEzID0gUG9zdGdyZXNFbmdpbmVWZXJzaW9uLm9mKCcxMC4xMycsICcxMCcsIHsgczNJbXBvcnQ6IHRydWUgfSk7XG4gIC8qKlxuICAgKiBWZXJzaW9uIFwiMTAuMTRcIi5cbiAgICogQGRlcHJlY2F0ZWQgUG9zdGdyZVNRTCAxMC4xNCBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzE0ID0gUG9zdGdyZXNFbmdpbmVWZXJzaW9uLm9mKCcxMC4xNCcsICcxMCcsIHsgczNJbXBvcnQ6IHRydWUsIHMzRXhwb3J0OiB0cnVlIH0pO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjEwLjE1XCIuXG4gICAqIEBkZXByZWNhdGVkIFBvc3RncmVTUUwgMTAuMTUgaXMgbm8gbG9uZ2VyIHN1cHBvcnRlZCBieSBBbWF6b24gUkRTLlxuICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMF8xNSA9IFBvc3RncmVzRW5naW5lVmVyc2lvbi5vZignMTAuMTUnLCAnMTAnLCB7IHMzSW1wb3J0OiB0cnVlLCBzM0V4cG9ydDogdHJ1ZSB9KTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCIxMC4xNlwiLlxuICAgKiBAZGVwcmVjYXRlZCBQb3N0Z3JlU1FMIDEwLjE2IGlzIG5vIGxvbmdlciBzdXBwb3J0ZWQgYnkgQW1hem9uIFJEUy5cbiAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTBfMTYgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzEwLjE2JywgJzEwJywgeyBzM0ltcG9ydDogdHJ1ZSwgczNFeHBvcnQ6IHRydWUgfSk7XG4gIC8qKlxuICAgKiBWZXJzaW9uIFwiMTAuMTdcIi5cbiAgICogQGRlcHJlY2F0ZWQgUG9zdGdyZVNRTCAxMC4xNyBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzE3ID0gUG9zdGdyZXNFbmdpbmVWZXJzaW9uLm9mKCcxMC4xNycsICcxMCcsIHsgczNJbXBvcnQ6IHRydWUsIHMzRXhwb3J0OiB0cnVlIH0pO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjEwLjE4XCIuXG4gICAqIEBkZXByZWNhdGVkIFBvc3RncmVTUUwgMTAuMTggaXMgbm8gbG9uZ2VyIHN1cHBvcnRlZCBieSBBbWF6b24gUkRTLlxuICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMF8xOCA9IFBvc3RncmVzRW5naW5lVmVyc2lvbi5vZignMTAuMTgnLCAnMTAnLCB7IHMzSW1wb3J0OiB0cnVlLCBzM0V4cG9ydDogdHJ1ZSB9KTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCIxMC4xOVwiLlxuICAgKiBAZGVwcmVjYXRlZCBQb3N0Z3JlU1FMIDEwLjE5IGlzIG5vIGxvbmdlciBzdXBwb3J0ZWQgYnkgQW1hem9uIFJEUy5cbiAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTBfMTkgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzEwLjE5JywgJzEwJywgeyBzM0ltcG9ydDogdHJ1ZSwgczNFeHBvcnQ6IHRydWUgfSk7XG4gIC8qKlxuICAgKiBWZXJzaW9uIFwiMTAuMjBcIi5cbiAgICogQGRlcHJlY2F0ZWQgUG9zdGdyZVNRTCAxMC4yMCBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzIwID0gUG9zdGdyZXNFbmdpbmVWZXJzaW9uLm9mKCcxMC4yMCcsICcxMCcsIHsgczNJbXBvcnQ6IHRydWUsIHMzRXhwb3J0OiB0cnVlIH0pO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjEwLjIxXCIuXG4gICAqIEBkZXByZWNhdGVkIFBvc3RncmVTUUwgMTAuMjEgaXMgbm8gbG9uZ2VyIHN1cHBvcnRlZCBieSBBbWF6b24gUkRTLlxuICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMF8yMSA9IFBvc3RncmVzRW5naW5lVmVyc2lvbi5vZignMTAuMjEnLCAnMTAnLCB7IHMzSW1wb3J0OiB0cnVlLCBzM0V4cG9ydDogdHJ1ZSB9KTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCIxMC4yMlwiLlxuICAgKiBAZGVwcmVjYXRlZCBQb3N0Z3JlU1FMIDEwLjIyIGlzIG5vIGxvbmdlciBzdXBwb3J0ZWQgYnkgQW1hem9uIFJEUy5cbiAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTBfMjIgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzEwLjIyJywgJzEwJywgeyBzM0ltcG9ydDogdHJ1ZSwgczNFeHBvcnQ6IHRydWUgfSk7XG4gIC8qKlxuICAgKiBWZXJzaW9uIFwiMTAuMjNcIi5cbiAgICogQGRlcHJlY2F0ZWQgUG9zdGdyZVNRTCAxMC4yMyBpcyBubyBsb25nZXIgc3VwcG9ydGVkIGJ5IEFtYXpvbiBSRFMuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEwXzIzID0gUG9zdGdyZXNFbmdpbmVWZXJzaW9uLm9mKCcxMC4yMycsICcxMCcsIHsgczNJbXBvcnQ6IHRydWUsIHMzRXhwb3J0OiB0cnVlIH0pO1xuXG4gIC8qKiBWZXJzaW9uIFwiMTFcIiAob25seSBhIG1ham9yIHZlcnNpb24sIHdpdGhvdXQgYSBzcGVjaWZpYyBtaW5vciB2ZXJzaW9uKS4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTEgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzExJywgJzExJywgeyBzM0ltcG9ydDogdHJ1ZSB9KTtcbiAgLyoqIFZlcnNpb24gXCIxMS4xXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzExXzEgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzExLjEnLCAnMTEnLCB7IHMzSW1wb3J0OiB0cnVlIH0pO1xuICAvKiogVmVyc2lvbiBcIjExLjJcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTFfMiA9IFBvc3RncmVzRW5naW5lVmVyc2lvbi5vZignMTEuMicsICcxMScsIHsgczNJbXBvcnQ6IHRydWUgfSk7XG4gIC8qKiBWZXJzaW9uIFwiMTEuNFwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMV80ID0gUG9zdGdyZXNFbmdpbmVWZXJzaW9uLm9mKCcxMS40JywgJzExJywgeyBzM0ltcG9ydDogdHJ1ZSB9KTtcbiAgLyoqIFZlcnNpb24gXCIxMS41XCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzExXzUgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzExLjUnLCAnMTEnLCB7IHMzSW1wb3J0OiB0cnVlIH0pO1xuICAvKiogVmVyc2lvbiBcIjExLjZcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTFfNiA9IFBvc3RncmVzRW5naW5lVmVyc2lvbi5vZignMTEuNicsICcxMScsIHsgczNJbXBvcnQ6IHRydWUgfSk7XG4gIC8qKiBWZXJzaW9uIFwiMTEuN1wiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMV83ID0gUG9zdGdyZXNFbmdpbmVWZXJzaW9uLm9mKCcxMS43JywgJzExJywgeyBzM0ltcG9ydDogdHJ1ZSB9KTtcbiAgLyoqIFZlcnNpb24gXCIxMS44XCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzExXzggPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzExLjgnLCAnMTEnLCB7IHMzSW1wb3J0OiB0cnVlIH0pO1xuICAvKiogVmVyc2lvbiBcIjExLjlcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTFfOSA9IFBvc3RncmVzRW5naW5lVmVyc2lvbi5vZignMTEuOScsICcxMScsIHsgczNJbXBvcnQ6IHRydWUsIHMzRXhwb3J0OiB0cnVlIH0pO1xuICAvKiogVmVyc2lvbiBcIjExLjEwXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzExXzEwID0gUG9zdGdyZXNFbmdpbmVWZXJzaW9uLm9mKCcxMS4xMCcsICcxMScsIHsgczNJbXBvcnQ6IHRydWUsIHMzRXhwb3J0OiB0cnVlIH0pO1xuICAvKiogVmVyc2lvbiBcIjExLjExXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzExXzExID0gUG9zdGdyZXNFbmdpbmVWZXJzaW9uLm9mKCcxMS4xMScsICcxMScsIHsgczNJbXBvcnQ6IHRydWUsIHMzRXhwb3J0OiB0cnVlIH0pO1xuICAvKiogVmVyc2lvbiBcIjExLjEyXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzExXzEyID0gUG9zdGdyZXNFbmdpbmVWZXJzaW9uLm9mKCcxMS4xMicsICcxMScsIHsgczNJbXBvcnQ6IHRydWUsIHMzRXhwb3J0OiB0cnVlIH0pO1xuICAvKiogVmVyc2lvbiBcIjExLjEzXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzExXzEzID0gUG9zdGdyZXNFbmdpbmVWZXJzaW9uLm9mKCcxMS4xMycsICcxMScsIHsgczNJbXBvcnQ6IHRydWUsIHMzRXhwb3J0OiB0cnVlIH0pO1xuICAvKiogVmVyc2lvbiBcIjExLjE0XCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzExXzE0ID0gUG9zdGdyZXNFbmdpbmVWZXJzaW9uLm9mKCcxMS4xNCcsICcxMScsIHsgczNJbXBvcnQ6IHRydWUsIHMzRXhwb3J0OiB0cnVlIH0pO1xuICAvKiogVmVyc2lvbiBcIjExLjE1XCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzExXzE1ID0gUG9zdGdyZXNFbmdpbmVWZXJzaW9uLm9mKCcxMS4xNScsICcxMScsIHsgczNJbXBvcnQ6IHRydWUsIHMzRXhwb3J0OiB0cnVlIH0pO1xuICAvKiogVmVyc2lvbiBcIjExLjE2XCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzExXzE2ID0gUG9zdGdyZXNFbmdpbmVWZXJzaW9uLm9mKCcxMS4xNicsICcxMScsIHsgczNJbXBvcnQ6IHRydWUsIHMzRXhwb3J0OiB0cnVlIH0pO1xuICAvKiogVmVyc2lvbiBcIjExLjE3XCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzExXzE3ID0gUG9zdGdyZXNFbmdpbmVWZXJzaW9uLm9mKCcxMS4xNycsICcxMScsIHsgczNJbXBvcnQ6IHRydWUsIHMzRXhwb3J0OiB0cnVlIH0pO1xuICAvKiogVmVyc2lvbiBcIjExLjE4XCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzExXzE4ID0gUG9zdGdyZXNFbmdpbmVWZXJzaW9uLm9mKCcxMS4xOCcsICcxMScsIHsgczNJbXBvcnQ6IHRydWUsIHMzRXhwb3J0OiB0cnVlIH0pO1xuICAvKiogVmVyc2lvbiBcIjExLjE5XCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzExXzE5ID0gUG9zdGdyZXNFbmdpbmVWZXJzaW9uLm9mKCcxMS4xOScsICcxMScsIHsgczNJbXBvcnQ6IHRydWUsIHMzRXhwb3J0OiB0cnVlIH0pO1xuXG4gIC8qKiBWZXJzaW9uIFwiMTJcIiAob25seSBhIG1ham9yIHZlcnNpb24sIHdpdGhvdXQgYSBzcGVjaWZpYyBtaW5vciB2ZXJzaW9uKS4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTIgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzEyJywgJzEyJywgeyBzM0ltcG9ydDogdHJ1ZSB9KTtcbiAgLyoqIFZlcnNpb24gXCIxMi4yXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEyXzIgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzEyLjInLCAnMTInLCB7IHMzSW1wb3J0OiB0cnVlIH0pO1xuICAvKiogVmVyc2lvbiBcIjEyLjNcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTJfMyA9IFBvc3RncmVzRW5naW5lVmVyc2lvbi5vZignMTIuMycsICcxMicsIHsgczNJbXBvcnQ6IHRydWUgfSk7XG4gIC8qKiBWZXJzaW9uIFwiMTIuNFwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl80ID0gUG9zdGdyZXNFbmdpbmVWZXJzaW9uLm9mKCcxMi40JywgJzEyJywgeyBzM0ltcG9ydDogdHJ1ZSwgczNFeHBvcnQ6IHRydWUgfSk7XG4gIC8qKiBWZXJzaW9uIFwiMTIuNVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl81ID0gUG9zdGdyZXNFbmdpbmVWZXJzaW9uLm9mKCcxMi41JywgJzEyJywgeyBzM0ltcG9ydDogdHJ1ZSwgczNFeHBvcnQ6IHRydWUgfSk7XG4gIC8qKiBWZXJzaW9uIFwiMTIuNlwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl82ID0gUG9zdGdyZXNFbmdpbmVWZXJzaW9uLm9mKCcxMi42JywgJzEyJywgeyBzM0ltcG9ydDogdHJ1ZSwgczNFeHBvcnQ6IHRydWUgfSk7XG4gIC8qKiBWZXJzaW9uIFwiMTIuN1wiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl83ID0gUG9zdGdyZXNFbmdpbmVWZXJzaW9uLm9mKCcxMi43JywgJzEyJywgeyBzM0ltcG9ydDogdHJ1ZSwgczNFeHBvcnQ6IHRydWUgfSk7XG4gIC8qKiBWZXJzaW9uIFwiMTIuOFwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl84ID0gUG9zdGdyZXNFbmdpbmVWZXJzaW9uLm9mKCcxMi44JywgJzEyJywgeyBzM0ltcG9ydDogdHJ1ZSwgczNFeHBvcnQ6IHRydWUgfSk7XG4gIC8qKiBWZXJzaW9uIFwiMTIuOVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl85ID0gUG9zdGdyZXNFbmdpbmVWZXJzaW9uLm9mKCcxMi45JywgJzEyJywgeyBzM0ltcG9ydDogdHJ1ZSwgczNFeHBvcnQ6IHRydWUgfSk7XG4gIC8qKiBWZXJzaW9uIFwiMTIuMTBcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTJfMTAgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzEyLjEwJywgJzEyJywgeyBzM0ltcG9ydDogdHJ1ZSwgczNFeHBvcnQ6IHRydWUgfSk7XG4gIC8qKiBWZXJzaW9uIFwiMTIuMTFcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTJfMTEgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzEyLjExJywgJzEyJywgeyBzM0ltcG9ydDogdHJ1ZSwgczNFeHBvcnQ6IHRydWUgfSk7XG4gIC8qKiBWZXJzaW9uIFwiMTIuMTJcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTJfMTIgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzEyLjEyJywgJzEyJywgeyBzM0ltcG9ydDogdHJ1ZSwgczNFeHBvcnQ6IHRydWUgfSk7XG4gIC8qKiBWZXJzaW9uIFwiMTIuMTNcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTJfMTMgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzEyLjEzJywgJzEyJywgeyBzM0ltcG9ydDogdHJ1ZSwgczNFeHBvcnQ6IHRydWUgfSk7XG4gIC8qKiBWZXJzaW9uIFwiMTIuMTRcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTJfMTQgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzEyLjE0JywgJzEyJywgeyBzM0ltcG9ydDogdHJ1ZSwgczNFeHBvcnQ6IHRydWUgfSk7XG5cbiAgLyoqIFZlcnNpb24gXCIxM1wiIChvbmx5IGEgbWFqb3IgdmVyc2lvbiwgd2l0aG91dCBhIHNwZWNpZmljIG1pbm9yIHZlcnNpb24pLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMyA9IFBvc3RncmVzRW5naW5lVmVyc2lvbi5vZignMTMnLCAnMTMnLCB7IHMzSW1wb3J0OiB0cnVlLCBzM0V4cG9ydDogdHJ1ZSB9KTtcbiAgLyoqIFZlcnNpb24gXCIxMy4xXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEzXzEgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzEzLjEnLCAnMTMnLCB7IHMzSW1wb3J0OiB0cnVlLCBzM0V4cG9ydDogdHJ1ZSB9KTtcbiAgLyoqIFZlcnNpb24gXCIxMy4yXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEzXzIgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzEzLjInLCAnMTMnLCB7IHMzSW1wb3J0OiB0cnVlLCBzM0V4cG9ydDogdHJ1ZSB9KTtcbiAgLyoqIFZlcnNpb24gXCIxMy4zXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEzXzMgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzEzLjMnLCAnMTMnLCB7IHMzSW1wb3J0OiB0cnVlLCBzM0V4cG9ydDogdHJ1ZSB9KTtcbiAgLyoqIFZlcnNpb24gXCIxMy40XCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEzXzQgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzEzLjQnLCAnMTMnLCB7IHMzSW1wb3J0OiB0cnVlLCBzM0V4cG9ydDogdHJ1ZSB9KTtcbiAgLyoqIFZlcnNpb24gXCIxMy41XCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEzXzUgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzEzLjUnLCAnMTMnLCB7IHMzSW1wb3J0OiB0cnVlLCBzM0V4cG9ydDogdHJ1ZSB9KTtcbiAgLyoqIFZlcnNpb24gXCIxMy42XCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEzXzYgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzEzLjYnLCAnMTMnLCB7IHMzSW1wb3J0OiB0cnVlLCBzM0V4cG9ydDogdHJ1ZSB9KTtcbiAgLyoqIFZlcnNpb24gXCIxMy43XCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEzXzcgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzEzLjcnLCAnMTMnLCB7IHMzSW1wb3J0OiB0cnVlLCBzM0V4cG9ydDogdHJ1ZSB9KTtcbiAgLyoqIFZlcnNpb24gXCIxMy44XCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEzXzggPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzEzLjgnLCAnMTMnLCB7IHMzSW1wb3J0OiB0cnVlLCBzM0V4cG9ydDogdHJ1ZSB9KTtcbiAgLyoqIFZlcnNpb24gXCIxMy45XCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEzXzkgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzEzLjknLCAnMTMnLCB7IHMzSW1wb3J0OiB0cnVlLCBzM0V4cG9ydDogdHJ1ZSB9KTtcbiAgLyoqIFZlcnNpb24gXCIxMy4xMFwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xM18xMCA9IFBvc3RncmVzRW5naW5lVmVyc2lvbi5vZignMTMuMTAnLCAnMTMnLCB7IHMzSW1wb3J0OiB0cnVlLCBzM0V4cG9ydDogdHJ1ZSB9KTtcblxuICAvKiogVmVyc2lvbiBcIjE0XCIgKG9ubHkgYSBtYWpvciB2ZXJzaW9uLCB3aXRob3V0IGEgc3BlY2lmaWMgbWlub3IgdmVyc2lvbikuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzE0ID0gUG9zdGdyZXNFbmdpbmVWZXJzaW9uLm9mKCcxNCcsICcxNCcsIHsgczNJbXBvcnQ6IHRydWUsIHMzRXhwb3J0OiB0cnVlIH0pO1xuICAvKiogVmVyc2lvbiBcIjE0LjFcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTRfMSA9IFBvc3RncmVzRW5naW5lVmVyc2lvbi5vZignMTQuMScsICcxNCcsIHsgczNJbXBvcnQ6IHRydWUsIHMzRXhwb3J0OiB0cnVlIH0pO1xuICAvKiogVmVyc2lvbiBcIjE0LjJcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTRfMiA9IFBvc3RncmVzRW5naW5lVmVyc2lvbi5vZignMTQuMicsICcxNCcsIHsgczNJbXBvcnQ6IHRydWUsIHMzRXhwb3J0OiB0cnVlIH0pO1xuICAvKiogVmVyc2lvbiBcIjE0LjNcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTRfMyA9IFBvc3RncmVzRW5naW5lVmVyc2lvbi5vZignMTQuMycsICcxNCcsIHsgczNJbXBvcnQ6IHRydWUsIHMzRXhwb3J0OiB0cnVlIH0pO1xuICAvKiogVmVyc2lvbiBcIjE0LjRcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTRfNCA9IFBvc3RncmVzRW5naW5lVmVyc2lvbi5vZignMTQuNCcsICcxNCcsIHsgczNJbXBvcnQ6IHRydWUsIHMzRXhwb3J0OiB0cnVlIH0pO1xuICAvKiogVmVyc2lvbiBcIjE0LjVcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTRfNSA9IFBvc3RncmVzRW5naW5lVmVyc2lvbi5vZignMTQuNScsICcxNCcsIHsgczNJbXBvcnQ6IHRydWUsIHMzRXhwb3J0OiB0cnVlIH0pO1xuICAvKiogVmVyc2lvbiBcIjE0LjZcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTRfNiA9IFBvc3RncmVzRW5naW5lVmVyc2lvbi5vZignMTQuNicsICcxNCcsIHsgczNJbXBvcnQ6IHRydWUsIHMzRXhwb3J0OiB0cnVlIH0pO1xuICAvKiogVmVyc2lvbiBcIjE0LjdcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTRfNyA9IFBvc3RncmVzRW5naW5lVmVyc2lvbi5vZignMTQuNycsICcxNCcsIHsgczNJbXBvcnQ6IHRydWUsIHMzRXhwb3J0OiB0cnVlIH0pO1xuXG4gIC8qKiBWZXJzaW9uIFwiMTVcIiAob25seSBhIG1ham9yIHZlcnNpb24sIHdpdGhvdXQgYSBzcGVjaWZpYyBtaW5vciB2ZXJzaW9uKS4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTUgPSBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24ub2YoJzE1JywgJzE1JywgeyBzM0ltcG9ydDogdHJ1ZSwgczNFeHBvcnQ6IHRydWUgfSk7XG4gIC8qKiBWZXJzaW9uIFwiMTUuMlwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xNV8yID0gUG9zdGdyZXNFbmdpbmVWZXJzaW9uLm9mKCcxNS4yJywgJzE1JywgeyBzM0ltcG9ydDogdHJ1ZSwgczNFeHBvcnQ6IHRydWUgfSk7XG5cbiAgLyoqXG4gICAqIENyZWF0ZSBhIG5ldyBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24gd2l0aCBhbiBhcmJpdHJhcnkgdmVyc2lvbi5cbiAgICpcbiAgICogQHBhcmFtIHBvc3RncmVzRnVsbFZlcnNpb24gdGhlIGZ1bGwgdmVyc2lvbiBzdHJpbmcsXG4gICAqICAgZm9yIGV4YW1wbGUgXCIxMy4xMVwiXG4gICAqIEBwYXJhbSBwb3N0Z3Jlc01ham9yVmVyc2lvbiB0aGUgbWFqb3IgdmVyc2lvbiBvZiB0aGUgZW5naW5lLFxuICAgKiAgIGZvciBleGFtcGxlIFwiMTNcIlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBvZihwb3N0Z3Jlc0Z1bGxWZXJzaW9uOiBzdHJpbmcsIHBvc3RncmVzTWFqb3JWZXJzaW9uOiBzdHJpbmcsIHBvc3RncmVzRmVhdHVyZXM/OiBQb3N0Z3Jlc0VuZ2luZUZlYXR1cmVzKTogUG9zdGdyZXNFbmdpbmVWZXJzaW9uIHtcbiAgICByZXR1cm4gbmV3IFBvc3RncmVzRW5naW5lVmVyc2lvbihwb3N0Z3Jlc0Z1bGxWZXJzaW9uLCBwb3N0Z3Jlc01ham9yVmVyc2lvbiwgcG9zdGdyZXNGZWF0dXJlcyk7XG4gIH1cblxuICAvKiogVGhlIGZ1bGwgdmVyc2lvbiBzdHJpbmcsIGZvciBleGFtcGxlLCBcIjEzLjExXCIuICovXG4gIHB1YmxpYyByZWFkb25seSBwb3N0Z3Jlc0Z1bGxWZXJzaW9uOiBzdHJpbmc7XG4gIC8qKiBUaGUgbWFqb3IgdmVyc2lvbiBvZiB0aGUgZW5naW5lLCBmb3IgZXhhbXBsZSwgXCIxM1wiLiAqL1xuICBwdWJsaWMgcmVhZG9ubHkgcG9zdGdyZXNNYWpvclZlcnNpb246IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIHN1cHBvcnRlZCBmZWF0dXJlcyBmb3IgdGhlIERCIGVuZ2luZVxuICAgKiBAaW50ZXJuYWxcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBfZmVhdHVyZXM6IEluc3RhbmNlRW5naW5lRmVhdHVyZXM7XG5cbiAgcHJpdmF0ZSBjb25zdHJ1Y3Rvcihwb3N0Z3Jlc0Z1bGxWZXJzaW9uOiBzdHJpbmcsIHBvc3RncmVzTWFqb3JWZXJzaW9uOiBzdHJpbmcsIHBvc3RncmVzRmVhdHVyZXM/OiBQb3N0Z3Jlc0VuZ2luZUZlYXR1cmVzKSB7XG4gICAgdGhpcy5wb3N0Z3Jlc0Z1bGxWZXJzaW9uID0gcG9zdGdyZXNGdWxsVmVyc2lvbjtcbiAgICB0aGlzLnBvc3RncmVzTWFqb3JWZXJzaW9uID0gcG9zdGdyZXNNYWpvclZlcnNpb247XG4gICAgdGhpcy5fZmVhdHVyZXMgPSB7XG4gICAgICBzM0ltcG9ydDogcG9zdGdyZXNGZWF0dXJlcz8uczNJbXBvcnQgPyAnczNJbXBvcnQnIDogdW5kZWZpbmVkLFxuICAgICAgczNFeHBvcnQ6IHBvc3RncmVzRmVhdHVyZXM/LnMzRXhwb3J0ID8gJ3MzRXhwb3J0JyA6IHVuZGVmaW5lZCxcbiAgICB9O1xuICB9XG59XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgUG9zdGdyZVNRTCBpbnN0YW5jZSBlbmdpbmVzLlxuICogVXNlZCBpbiBgRGF0YWJhc2VJbnN0YW5jZUVuZ2luZS5wb3N0Z3Jlc2AuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgUG9zdGdyZXNJbnN0YW5jZUVuZ2luZVByb3BzIHtcbiAgLyoqIFRoZSBleGFjdCB2ZXJzaW9uIG9mIHRoZSBlbmdpbmUgdG8gdXNlLiAqL1xuICByZWFkb25seSB2ZXJzaW9uOiBQb3N0Z3Jlc0VuZ2luZVZlcnNpb247XG59XG5cbi8qKlxuICogVGhlIGluc3RhbmNlIGVuZ2luZSBmb3IgUG9zdGdyZVNRTC5cbiAqL1xuY2xhc3MgUG9zdGdyZXNJbnN0YW5jZUVuZ2luZSBleHRlbmRzIEluc3RhbmNlRW5naW5lQmFzZSB7XG4gIHB1YmxpYyByZWFkb25seSBkZWZhdWx0VXNlcm5hbWUgPSAncG9zdGdyZXMnO1xuXG4gIGNvbnN0cnVjdG9yKHZlcnNpb24/OiBQb3N0Z3Jlc0VuZ2luZVZlcnNpb24pIHtcbiAgICBzdXBlcih7XG4gICAgICBlbmdpbmVUeXBlOiAncG9zdGdyZXMnLFxuICAgICAgc2luZ2xlVXNlclJvdGF0aW9uQXBwbGljYXRpb246IHNlY3JldHNtYW5hZ2VyLlNlY3JldFJvdGF0aW9uQXBwbGljYXRpb24uUE9TVEdSRVNfUk9UQVRJT05fU0lOR0xFX1VTRVIsXG4gICAgICBtdWx0aVVzZXJSb3RhdGlvbkFwcGxpY2F0aW9uOiBzZWNyZXRzbWFuYWdlci5TZWNyZXRSb3RhdGlvbkFwcGxpY2F0aW9uLlBPU1RHUkVTX1JPVEFUSU9OX01VTFRJX1VTRVIsXG4gICAgICB2ZXJzaW9uOiB2ZXJzaW9uXG4gICAgICAgID8ge1xuICAgICAgICAgIGZ1bGxWZXJzaW9uOiB2ZXJzaW9uLnBvc3RncmVzRnVsbFZlcnNpb24sXG4gICAgICAgICAgbWFqb3JWZXJzaW9uOiB2ZXJzaW9uLnBvc3RncmVzTWFqb3JWZXJzaW9uLFxuICAgICAgICB9XG4gICAgICAgIDogdW5kZWZpbmVkLFxuICAgICAgZmVhdHVyZXM6IHZlcnNpb24gPyB2ZXJzaW9uPy5fZmVhdHVyZXMgOiB7IHMzSW1wb3J0OiAnczNJbXBvcnQnIH0sXG4gICAgICBlbmdpbmVGYW1pbHk6ICdQT1NUR1JFU1FMJyxcbiAgICB9KTtcbiAgfVxufVxuXG4vKipcbiAqIFRoZSB2ZXJzaW9ucyBmb3IgdGhlIGxlZ2FjeSBPcmFjbGUgaW5zdGFuY2UgZW5naW5lc1xuICogKHRob3NlIHJldHVybmVkIGJ5IGBEYXRhYmFzZUluc3RhbmNlRW5naW5lLm9yYWNsZVNlYFxuICogYW5kIGBEYXRhYmFzZUluc3RhbmNlRW5naW5lLm9yYWNsZVNlMWApLlxuICogTm90ZTogUkRTIHdpbGwgc3RvcCBhbGxvd2luZyBjcmVhdGluZyBuZXcgZGF0YWJhc2VzIHdpdGggdGhpcyB2ZXJzaW9uIGluIEF1Z3VzdCAyMDIwLlxuICpcbiAqIEBkZXByZWNhdGVkIGluc3RhbmNlcyBjYW4gbm8gbG9uZ2VyIGJlIGNyZWF0ZWQgd2l0aCB0aGVzZSBlbmdpbmUgdmVyc2lvbnMuIFNlZSBodHRwczovL2ZvcnVtcy5hd3MuYW1hem9uLmNvbS9hbm4uanNwYT9hbm5JRD03MzQxXG4gKi9cbmV4cG9ydCBjbGFzcyBPcmFjbGVMZWdhY3lFbmdpbmVWZXJzaW9uIHtcbiAgLyoqIFZlcnNpb24gXCIxMS4yXCIgKG9ubHkgYSBtYWpvciB2ZXJzaW9uLCB3aXRob3V0IGEgc3BlY2lmaWMgbWlub3IgdmVyc2lvbikuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzExXzIgPSBPcmFjbGVMZWdhY3lFbmdpbmVWZXJzaW9uLm9mKCcxMS4yJywgJzExLjInKTtcbiAgLyoqIFZlcnNpb24gXCIxMS4yLjAuMi52MlwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMV8yXzBfMl9WMiA9IE9yYWNsZUxlZ2FjeUVuZ2luZVZlcnNpb24ub2YoJzExLjIuMC4yLnYyJywgJzExLjInKTtcbiAgLyoqIFZlcnNpb24gXCIxMS4yLjAuNC52MVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMV8yXzBfNF9WMSA9IE9yYWNsZUxlZ2FjeUVuZ2luZVZlcnNpb24ub2YoJzExLjIuMC40LnYxJywgJzExLjInKTtcbiAgLyoqIFZlcnNpb24gXCIxMS4yLjAuNC52M1wiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMV8yXzBfNF9WMyA9IE9yYWNsZUxlZ2FjeUVuZ2luZVZlcnNpb24ub2YoJzExLjIuMC40LnYzJywgJzExLjInKTtcbiAgLyoqIFZlcnNpb24gXCIxMS4yLjAuNC52NFwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMV8yXzBfNF9WNCA9IE9yYWNsZUxlZ2FjeUVuZ2luZVZlcnNpb24ub2YoJzExLjIuMC40LnY0JywgJzExLjInKTtcbiAgLyoqIFZlcnNpb24gXCIxMS4yLjAuNC52NVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMV8yXzBfNF9WNSA9IE9yYWNsZUxlZ2FjeUVuZ2luZVZlcnNpb24ub2YoJzExLjIuMC40LnY1JywgJzExLjInKTtcbiAgLyoqIFZlcnNpb24gXCIxMS4yLjAuNC52NlwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMV8yXzBfNF9WNiA9IE9yYWNsZUxlZ2FjeUVuZ2luZVZlcnNpb24ub2YoJzExLjIuMC40LnY2JywgJzExLjInKTtcbiAgLyoqIFZlcnNpb24gXCIxMS4yLjAuNC52N1wiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMV8yXzBfNF9WNyA9IE9yYWNsZUxlZ2FjeUVuZ2luZVZlcnNpb24ub2YoJzExLjIuMC40LnY3JywgJzExLjInKTtcbiAgLyoqIFZlcnNpb24gXCIxMS4yLjAuNC52OFwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMV8yXzBfNF9WOCA9IE9yYWNsZUxlZ2FjeUVuZ2luZVZlcnNpb24ub2YoJzExLjIuMC40LnY4JywgJzExLjInKTtcbiAgLyoqIFZlcnNpb24gXCIxMS4yLjAuNC52OVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMV8yXzBfNF9WOSA9IE9yYWNsZUxlZ2FjeUVuZ2luZVZlcnNpb24ub2YoJzExLjIuMC40LnY5JywgJzExLjInKTtcbiAgLyoqIFZlcnNpb24gXCIxMS4yLjAuNC52MTBcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTFfMl8wXzRfVjEwID0gT3JhY2xlTGVnYWN5RW5naW5lVmVyc2lvbi5vZignMTEuMi4wLjQudjEwJywgJzExLjInKTtcbiAgLyoqIFZlcnNpb24gXCIxMS4yLjAuNC52MTFcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTFfMl8wXzRfVjExID0gT3JhY2xlTGVnYWN5RW5naW5lVmVyc2lvbi5vZignMTEuMi4wLjQudjExJywgJzExLjInKTtcbiAgLyoqIFZlcnNpb24gXCIxMS4yLjAuNC52MTJcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTFfMl8wXzRfVjEyID0gT3JhY2xlTGVnYWN5RW5naW5lVmVyc2lvbi5vZignMTEuMi4wLjQudjEyJywgJzExLjInKTtcbiAgLyoqIFZlcnNpb24gXCIxMS4yLjAuNC52MTNcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTFfMl8wXzRfVjEzID0gT3JhY2xlTGVnYWN5RW5naW5lVmVyc2lvbi5vZignMTEuMi4wLjQudjEzJywgJzExLjInKTtcbiAgLyoqIFZlcnNpb24gXCIxMS4yLjAuNC52MTRcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTFfMl8wXzRfVjE0ID0gT3JhY2xlTGVnYWN5RW5naW5lVmVyc2lvbi5vZignMTEuMi4wLjQudjE0JywgJzExLjInKTtcbiAgLyoqIFZlcnNpb24gXCIxMS4yLjAuNC52MTVcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTFfMl8wXzRfVjE1ID0gT3JhY2xlTGVnYWN5RW5naW5lVmVyc2lvbi5vZignMTEuMi4wLjQudjE1JywgJzExLjInKTtcbiAgLyoqIFZlcnNpb24gXCIxMS4yLjAuNC52MTZcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTFfMl8wXzRfVjE2ID0gT3JhY2xlTGVnYWN5RW5naW5lVmVyc2lvbi5vZignMTEuMi4wLjQudjE2JywgJzExLjInKTtcbiAgLyoqIFZlcnNpb24gXCIxMS4yLjAuNC52MTdcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTFfMl8wXzRfVjE3ID0gT3JhY2xlTGVnYWN5RW5naW5lVmVyc2lvbi5vZignMTEuMi4wLjQudjE3JywgJzExLjInKTtcbiAgLyoqIFZlcnNpb24gXCIxMS4yLjAuNC52MThcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTFfMl8wXzRfVjE4ID0gT3JhY2xlTGVnYWN5RW5naW5lVmVyc2lvbi5vZignMTEuMi4wLjQudjE4JywgJzExLjInKTtcbiAgLyoqIFZlcnNpb24gXCIxMS4yLjAuNC52MTlcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTFfMl8wXzRfVjE5ID0gT3JhY2xlTGVnYWN5RW5naW5lVmVyc2lvbi5vZignMTEuMi4wLjQudjE5JywgJzExLjInKTtcbiAgLyoqIFZlcnNpb24gXCIxMS4yLjAuNC52MjBcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTFfMl8wXzRfVjIwID0gT3JhY2xlTGVnYWN5RW5naW5lVmVyc2lvbi5vZignMTEuMi4wLjQudjIwJywgJzExLjInKTtcbiAgLyoqIFZlcnNpb24gXCIxMS4yLjAuNC52MjFcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTFfMl8wXzRfVjIxID0gT3JhY2xlTGVnYWN5RW5naW5lVmVyc2lvbi5vZignMTEuMi4wLjQudjIxJywgJzExLjInKTtcbiAgLyoqIFZlcnNpb24gXCIxMS4yLjAuNC52MjJcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTFfMl8wXzRfVjIyID0gT3JhY2xlTGVnYWN5RW5naW5lVmVyc2lvbi5vZignMTEuMi4wLjQudjIyJywgJzExLjInKTtcbiAgLyoqIFZlcnNpb24gXCIxMS4yLjAuNC52MjNcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTFfMl8wXzRfVjIzID0gT3JhY2xlTGVnYWN5RW5naW5lVmVyc2lvbi5vZignMTEuMi4wLjQudjIzJywgJzExLjInKTtcbiAgLyoqIFZlcnNpb24gXCIxMS4yLjAuNC52MjRcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTFfMl8wXzRfVjI0ID0gT3JhY2xlTGVnYWN5RW5naW5lVmVyc2lvbi5vZignMTEuMi4wLjQudjI0JywgJzExLjInKTtcbiAgLyoqIFZlcnNpb24gXCIxMS4yLjAuNC52MjVcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTFfMl8wXzRfVjI1ID0gT3JhY2xlTGVnYWN5RW5naW5lVmVyc2lvbi5vZignMTEuMi4wLjQudjI1JywgJzExLjInKTtcblxuICBwcml2YXRlIHN0YXRpYyBvZihvcmFjbGVMZWdhY3lGdWxsVmVyc2lvbjogc3RyaW5nLCBvcmFjbGVMZWdhY3lNYWpvclZlcnNpb246IHN0cmluZyk6IE9yYWNsZUxlZ2FjeUVuZ2luZVZlcnNpb24ge1xuICAgIHJldHVybiBuZXcgT3JhY2xlTGVnYWN5RW5naW5lVmVyc2lvbihvcmFjbGVMZWdhY3lGdWxsVmVyc2lvbiwgb3JhY2xlTGVnYWN5TWFqb3JWZXJzaW9uKTtcbiAgfVxuXG4gIC8qKiBUaGUgZnVsbCB2ZXJzaW9uIHN0cmluZywgZm9yIGV4YW1wbGUsIFwiMTEuMi4wLjQudjI0XCIuICovXG4gIHB1YmxpYyByZWFkb25seSBvcmFjbGVMZWdhY3lGdWxsVmVyc2lvbjogc3RyaW5nO1xuICAvKiogVGhlIG1ham9yIHZlcnNpb24gb2YgdGhlIGVuZ2luZSwgZm9yIGV4YW1wbGUsIFwiMTEuMlwiLiAqL1xuICBwdWJsaWMgcmVhZG9ubHkgb3JhY2xlTGVnYWN5TWFqb3JWZXJzaW9uOiBzdHJpbmc7XG5cbiAgcHJpdmF0ZSBjb25zdHJ1Y3RvcihvcmFjbGVMZWdhY3lGdWxsVmVyc2lvbjogc3RyaW5nLCBvcmFjbGVMZWdhY3lNYWpvclZlcnNpb246IHN0cmluZykge1xuICAgIHRoaXMub3JhY2xlTGVnYWN5RnVsbFZlcnNpb24gPSBvcmFjbGVMZWdhY3lGdWxsVmVyc2lvbjtcbiAgICB0aGlzLm9yYWNsZUxlZ2FjeU1ham9yVmVyc2lvbiA9IG9yYWNsZUxlZ2FjeU1ham9yVmVyc2lvbjtcbiAgfVxufVxuXG4vKipcbiAqIFRoZSB2ZXJzaW9ucyBmb3IgdGhlIE9yYWNsZSBpbnN0YW5jZSBlbmdpbmVzLlxuICogVGhvc2UgcmV0dXJuZWQgYnkgdGhlIGZvbGxvd2luZyBsaXN0LlxuICogLSBgRGF0YWJhc2VJbnN0YW5jZUVuZ2luZS5vcmFjbGVTZTJgXG4gKiAtIGBEYXRhYmFzZUluc3RhbmNlRW5naW5lLm9yYWNsZVNlMkNkYmBcbiAqIC0gYERhdGFiYXNlSW5zdGFuY2VFbmdpbmUub3JhY2xlRWVgXG4gKiAtIGBEYXRhYmFzZUluc3RhbmNlRW5naW5lLm9yYWNsZUVlQ2RiYC5cbiAqL1xuZXhwb3J0IGNsYXNzIE9yYWNsZUVuZ2luZVZlcnNpb24ge1xuICAvKiogVmVyc2lvbiBcIjEyLjFcIiAob25seSBhIG1ham9yIHZlcnNpb24sIHdpdGhvdXQgYSBzcGVjaWZpYyBtaW5vciB2ZXJzaW9uKS4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTJfMSA9IE9yYWNsZUVuZ2luZVZlcnNpb24ub2YoJzEyLjEnLCAnMTIuMScpO1xuICAvKiogVmVyc2lvbiBcIjEyLjEuMC4yLnYxXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEyXzFfMF8yX1YxID0gT3JhY2xlRW5naW5lVmVyc2lvbi5vZignMTIuMS4wLjIudjEnLCAnMTIuMScpO1xuICAvKiogVmVyc2lvbiBcIjEyLjEuMC4yLnYyXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEyXzFfMF8yX1YyID0gT3JhY2xlRW5naW5lVmVyc2lvbi5vZignMTIuMS4wLjIudjInLCAnMTIuMScpO1xuICAvKiogVmVyc2lvbiBcIjEyLjEuMC4yLnYzXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEyXzFfMF8yX1YzID0gT3JhY2xlRW5naW5lVmVyc2lvbi5vZignMTIuMS4wLjIudjMnLCAnMTIuMScpO1xuICAvKiogVmVyc2lvbiBcIjEyLjEuMC4yLnY0XCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEyXzFfMF8yX1Y0ID0gT3JhY2xlRW5naW5lVmVyc2lvbi5vZignMTIuMS4wLjIudjQnLCAnMTIuMScpO1xuICAvKiogVmVyc2lvbiBcIjEyLjEuMC4yLnY1XCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEyXzFfMF8yX1Y1ID0gT3JhY2xlRW5naW5lVmVyc2lvbi5vZignMTIuMS4wLjIudjUnLCAnMTIuMScpO1xuICAvKiogVmVyc2lvbiBcIjEyLjEuMC4yLnY2XCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEyXzFfMF8yX1Y2ID0gT3JhY2xlRW5naW5lVmVyc2lvbi5vZignMTIuMS4wLjIudjYnLCAnMTIuMScpO1xuICAvKiogVmVyc2lvbiBcIjEyLjEuMC4yLnY3XCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEyXzFfMF8yX1Y3ID0gT3JhY2xlRW5naW5lVmVyc2lvbi5vZignMTIuMS4wLjIudjcnLCAnMTIuMScpO1xuICAvKiogVmVyc2lvbiBcIjEyLjEuMC4yLnY4XCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEyXzFfMF8yX1Y4ID0gT3JhY2xlRW5naW5lVmVyc2lvbi5vZignMTIuMS4wLjIudjgnLCAnMTIuMScpO1xuICAvKiogVmVyc2lvbiBcIjEyLjEuMC4yLnY5XCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEyXzFfMF8yX1Y5ID0gT3JhY2xlRW5naW5lVmVyc2lvbi5vZignMTIuMS4wLjIudjknLCAnMTIuMScpO1xuICAvKiogVmVyc2lvbiBcIjEyLjEuMC4yLnYxMFwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8xXzBfMl9WMTAgPSBPcmFjbGVFbmdpbmVWZXJzaW9uLm9mKCcxMi4xLjAuMi52MTAnLCAnMTIuMScpO1xuICAvKiogVmVyc2lvbiBcIjEyLjEuMC4yLnYxMVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8xXzBfMl9WMTEgPSBPcmFjbGVFbmdpbmVWZXJzaW9uLm9mKCcxMi4xLjAuMi52MTEnLCAnMTIuMScpO1xuICAvKiogVmVyc2lvbiBcIjEyLjEuMC4yLnYxMlwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8xXzBfMl9WMTIgPSBPcmFjbGVFbmdpbmVWZXJzaW9uLm9mKCcxMi4xLjAuMi52MTInLCAnMTIuMScpO1xuICAvKiogVmVyc2lvbiBcIjEyLjEuMC4yLnYxM1wiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8xXzBfMl9WMTMgPSBPcmFjbGVFbmdpbmVWZXJzaW9uLm9mKCcxMi4xLjAuMi52MTMnLCAnMTIuMScpO1xuICAvKiogVmVyc2lvbiBcIjEyLjEuMC4yLnYxNFwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8xXzBfMl9WMTQgPSBPcmFjbGVFbmdpbmVWZXJzaW9uLm9mKCcxMi4xLjAuMi52MTQnLCAnMTIuMScpO1xuICAvKiogVmVyc2lvbiBcIjEyLjEuMC4yLnYxNVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8xXzBfMl9WMTUgPSBPcmFjbGVFbmdpbmVWZXJzaW9uLm9mKCcxMi4xLjAuMi52MTUnLCAnMTIuMScpO1xuICAvKiogVmVyc2lvbiBcIjEyLjEuMC4yLnYxNlwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8xXzBfMl9WMTYgPSBPcmFjbGVFbmdpbmVWZXJzaW9uLm9mKCcxMi4xLjAuMi52MTYnLCAnMTIuMScpO1xuICAvKiogVmVyc2lvbiBcIjEyLjEuMC4yLnYxN1wiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8xXzBfMl9WMTcgPSBPcmFjbGVFbmdpbmVWZXJzaW9uLm9mKCcxMi4xLjAuMi52MTcnLCAnMTIuMScpO1xuICAvKiogVmVyc2lvbiBcIjEyLjEuMC4yLnYxOFwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8xXzBfMl9WMTggPSBPcmFjbGVFbmdpbmVWZXJzaW9uLm9mKCcxMi4xLjAuMi52MTgnLCAnMTIuMScpO1xuICAvKiogVmVyc2lvbiBcIjEyLjEuMC4yLnYxOVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8xXzBfMl9WMTkgPSBPcmFjbGVFbmdpbmVWZXJzaW9uLm9mKCcxMi4xLjAuMi52MTknLCAnMTIuMScpO1xuICAvKiogVmVyc2lvbiBcIjEyLjEuMC4yLnYyMFwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8xXzBfMl9WMjAgPSBPcmFjbGVFbmdpbmVWZXJzaW9uLm9mKCcxMi4xLjAuMi52MjAnLCAnMTIuMScpO1xuICAvKiogVmVyc2lvbiBcIjEyLjEuMC4yLnYyMVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8xXzBfMl9WMjEgPSBPcmFjbGVFbmdpbmVWZXJzaW9uLm9mKCcxMi4xLjAuMi52MjEnLCAnMTIuMScpO1xuICAvKiogVmVyc2lvbiBcIjEyLjEuMC4yLnYyMlwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8xXzBfMl9WMjIgPSBPcmFjbGVFbmdpbmVWZXJzaW9uLm9mKCcxMi4xLjAuMi52MjInLCAnMTIuMScpO1xuICAvKiogVmVyc2lvbiBcIjEyLjEuMC4yLnYyM1wiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8xXzBfMl9WMjMgPSBPcmFjbGVFbmdpbmVWZXJzaW9uLm9mKCcxMi4xLjAuMi52MjMnLCAnMTIuMScpO1xuICAvKiogVmVyc2lvbiBcIjEyLjEuMC4yLnYyNFwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8xXzBfMl9WMjQgPSBPcmFjbGVFbmdpbmVWZXJzaW9uLm9mKCcxMi4xLjAuMi52MjQnLCAnMTIuMScpO1xuICAvKiogVmVyc2lvbiBcIjEyLjEuMC4yLnYyNVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8xXzBfMl9WMjUgPSBPcmFjbGVFbmdpbmVWZXJzaW9uLm9mKCcxMi4xLjAuMi52MjUnLCAnMTIuMScpO1xuICAvKiogVmVyc2lvbiBcIjEyLjEuMC4yLnYyNlwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8xXzBfMl9WMjYgPSBPcmFjbGVFbmdpbmVWZXJzaW9uLm9mKCcxMi4xLjAuMi52MjYnLCAnMTIuMScpO1xuICAvKiogVmVyc2lvbiBcIjEyLjEuMC4yLnYyN1wiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8xXzBfMl9WMjcgPSBPcmFjbGVFbmdpbmVWZXJzaW9uLm9mKCcxMi4xLjAuMi52MjcnLCAnMTIuMScpO1xuICAvKiogVmVyc2lvbiBcIjEyLjEuMC4yLnYyOFwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8xXzBfMl9WMjggPSBPcmFjbGVFbmdpbmVWZXJzaW9uLm9mKCcxMi4xLjAuMi52MjgnLCAnMTIuMScpO1xuICAvKiogVmVyc2lvbiBcIjEyLjEuMC4yLnYyOVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8xXzBfMl9WMjkgPSBPcmFjbGVFbmdpbmVWZXJzaW9uLm9mKCcxMi4xLjAuMi52MjknLCAnMTIuMScpO1xuXG4gIC8qKiBWZXJzaW9uIFwiMTIuMlwiIChvbmx5IGEgbWFqb3IgdmVyc2lvbiwgd2l0aG91dCBhIHNwZWNpZmljIG1pbm9yIHZlcnNpb24pLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8yID0gT3JhY2xlRW5naW5lVmVyc2lvbi5vZignMTIuMicsICcxMi4yJyk7XG4gIC8qKiBWZXJzaW9uIFwiMTIuMi4wLjEucnUtMjAxOC0xMC5ydXItMjAxOC0xMC5yMVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8yXzBfMV8yMDE4XzEwX1IxID0gT3JhY2xlRW5naW5lVmVyc2lvbi5vZignMTIuMi4wLjEucnUtMjAxOC0xMC5ydXItMjAxOC0xMC5yMScsICcxMi4yJyk7XG4gIC8qKiBWZXJzaW9uIFwiMTIuMi4wLjEucnUtMjAxOS0wMS5ydXItMjAxOS0wMS5yMVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8yXzBfMV8yMDE5XzAxX1IxID0gT3JhY2xlRW5naW5lVmVyc2lvbi5vZignMTIuMi4wLjEucnUtMjAxOS0wMS5ydXItMjAxOS0wMS5yMScsICcxMi4yJyk7XG4gIC8qKiBWZXJzaW9uIFwiMTIuMi4wLjEucnUtMjAxOS0wNC5ydXItMjAxOS0wNC5yMVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8yXzBfMV8yMDE5XzA0X1IxID0gT3JhY2xlRW5naW5lVmVyc2lvbi5vZignMTIuMi4wLjEucnUtMjAxOS0wNC5ydXItMjAxOS0wNC5yMScsICcxMi4yJyk7XG4gIC8qKiBWZXJzaW9uIFwiMTIuMi4wLjEucnUtMjAxOS0wNy5ydXItMjAxOS0wNy5yMVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8yXzBfMV8yMDE5XzA3X1IxID0gT3JhY2xlRW5naW5lVmVyc2lvbi5vZignMTIuMi4wLjEucnUtMjAxOS0wNy5ydXItMjAxOS0wNy5yMScsICcxMi4yJyk7XG4gIC8qKiBWZXJzaW9uIFwiMTIuMi4wLjEucnUtMjAxOS0xMC5ydXItMjAxOS0xMC5yMVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8yXzBfMV8yMDE5XzEwX1IxID0gT3JhY2xlRW5naW5lVmVyc2lvbi5vZignMTIuMi4wLjEucnUtMjAxOS0xMC5ydXItMjAxOS0xMC5yMScsICcxMi4yJyk7XG4gIC8qKiBWZXJzaW9uIFwiMTIuMi4wLjEucnUtMjAyMC0wMS5ydXItMjAyMC0wMS5yMVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8yXzBfMV8yMDIwXzAxX1IxID0gT3JhY2xlRW5naW5lVmVyc2lvbi5vZignMTIuMi4wLjEucnUtMjAyMC0wMS5ydXItMjAyMC0wMS5yMScsICcxMi4yJyk7XG4gIC8qKiBWZXJzaW9uIFwiMTIuMi4wLjEucnUtMjAyMC0wNC5ydXItMjAyMC0wNC5yMVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8yXzBfMV8yMDIwXzA0X1IxID0gT3JhY2xlRW5naW5lVmVyc2lvbi5vZignMTIuMi4wLjEucnUtMjAyMC0wNC5ydXItMjAyMC0wNC5yMScsICcxMi4yJyk7XG4gIC8qKiBWZXJzaW9uIFwiMTIuMi4wLjEucnUtMjAyMC0wNy5ydXItMjAyMC0wNy5yMVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8yXzBfMV8yMDIwXzA3X1IxID0gT3JhY2xlRW5naW5lVmVyc2lvbi5vZignMTIuMi4wLjEucnUtMjAyMC0wNy5ydXItMjAyMC0wNy5yMScsICcxMi4yJyk7XG4gIC8qKiBWZXJzaW9uIFwiMTIuMi4wLjEucnUtMjAyMS0xMC5ydXItMjAyMC0xMC5yMVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8yXzBfMV8yMDIwXzEwX1IxID0gT3JhY2xlRW5naW5lVmVyc2lvbi5vZignMTIuMi4wLjEucnUtMjAyMC0xMC5ydXItMjAyMC0xMC5yMScsICcxMi4yJyk7XG4gIC8qKiBWZXJzaW9uIFwiMTIuMi4wLjEucnUtMjAyMS0wMS5ydXItMjAyMS0wMS5yMVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8yXzBfMV8yMDIxXzAxX1IxID0gT3JhY2xlRW5naW5lVmVyc2lvbi5vZignMTIuMi4wLjEucnUtMjAyMS0wMS5ydXItMjAyMS0wMS5yMScsICcxMi4yJyk7XG4gIC8qKiBWZXJzaW9uIFwiMTIuMi4wLjEucnUtMjAyMS0wNC5ydXItMjAyMS0wNC5yMVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8yXzBfMV8yMDIxXzA0X1IxID0gT3JhY2xlRW5naW5lVmVyc2lvbi5vZignMTIuMi4wLjEucnUtMjAyMS0wNC5ydXItMjAyMS0wNC5yMScsICcxMi4yJyk7XG4gIC8qKiBWZXJzaW9uIFwiMTIuMi4wLjEucnUtMjAyMS0wNy5ydXItMjAyMS0wNy5yMVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8yXzBfMV8yMDIxXzA3X1IxID0gT3JhY2xlRW5naW5lVmVyc2lvbi5vZignMTIuMi4wLjEucnUtMjAyMS0wNy5ydXItMjAyMS0wNy5yMScsICcxMi4yJyk7XG4gIC8qKiBWZXJzaW9uIFwiMTIuMi4wLjEucnUtMjAyMS0xMC5ydXItMjAyMS0xMC5yMVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8yXzBfMV8yMDIxXzEwX1IxID0gT3JhY2xlRW5naW5lVmVyc2lvbi5vZignMTIuMi4wLjEucnUtMjAyMS0xMC5ydXItMjAyMS0xMC5yMScsICcxMi4yJyk7XG4gIC8qKiBWZXJzaW9uIFwiMTIuMi4wLjEucnUtMjAyMi0wMS5ydXItMjAyMi0wMS5yMVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8yXzBfMV8yMDIyXzAxX1IxID0gT3JhY2xlRW5naW5lVmVyc2lvbi5vZignMTIuMi4wLjEucnUtMjAyMi0wMS5ydXItMjAyMi0wMS5yMScsICcxMi4yJyk7XG5cbiAgLyoqIFZlcnNpb24gXCIxOFwiIChvbmx5IGEgbWFqb3IgdmVyc2lvbiwgd2l0aG91dCBhIHNwZWNpZmljIG1pbm9yIHZlcnNpb24pLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xOCA9IE9yYWNsZUVuZ2luZVZlcnNpb24ub2YoJzE4JywgJzE4Jyk7XG4gIC8qKiBWZXJzaW9uIFwiMTguMC4wLjAucnUtMjAxOS0wNy5ydXItMjAxOS0wNy5yMVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xOF8wXzBfMF8yMDE5XzA3X1IxID0gT3JhY2xlRW5naW5lVmVyc2lvbi5vZignMTguMC4wLjAucnUtMjAxOS0wNy5ydXItMjAxOS0wNy5yMScsICcxOCcpO1xuICAvKiogVmVyc2lvbiBcIjE4LjAuMC4wLnJ1LTIwMTktMTAucnVyLTIwMTktMTAucjFcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMThfMF8wXzBfMjAxOV8xMF9SMSA9IE9yYWNsZUVuZ2luZVZlcnNpb24ub2YoJzE4LjAuMC4wLnJ1LTIwMTktMTAucnVyLTIwMTktMTAucjEnLCAnMTgnKTtcbiAgLyoqIFZlcnNpb24gXCIxOC4wLjAuMC5ydS0yMDIwLTAxLnJ1ci0yMDIwLTAxLnIxXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzE4XzBfMF8wXzIwMjBfMDFfUjEgPSBPcmFjbGVFbmdpbmVWZXJzaW9uLm9mKCcxOC4wLjAuMC5ydS0yMDIwLTAxLnJ1ci0yMDIwLTAxLnIxJywgJzE4Jyk7XG4gIC8qKiBWZXJzaW9uIFwiMTguMC4wLjAucnUtMjAyMC0wNC5ydXItMjAyMC0wNC5yMVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xOF8wXzBfMF8yMDIwXzA0X1IxID0gT3JhY2xlRW5naW5lVmVyc2lvbi5vZignMTguMC4wLjAucnUtMjAyMC0wNC5ydXItMjAyMC0wNC5yMScsICcxOCcpO1xuICAvKiogVmVyc2lvbiBcIjE4LjAuMC4wLnJ1LTIwMjAtMDcucnVyLTIwMjAtMDcucjFcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMThfMF8wXzBfMjAyMF8wN19SMSA9IE9yYWNsZUVuZ2luZVZlcnNpb24ub2YoJzE4LjAuMC4wLnJ1LTIwMjAtMDcucnVyLTIwMjAtMDcucjEnLCAnMTgnKTtcbiAgLyoqIFZlcnNpb24gXCIxOC4wLjAuMC5ydS0yMDIwLTEwLnJ1ci0yMDIwLTEwLnIxXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzE4XzBfMF8wXzIwMjBfMTBfUjEgPSBPcmFjbGVFbmdpbmVWZXJzaW9uLm9mKCcxOC4wLjAuMC5ydS0yMDIwLTEwLnJ1ci0yMDIwLTEwLnIxJywgJzE4Jyk7XG4gIC8qKiBWZXJzaW9uIFwiMTguMC4wLjAucnUtMjAyMS0wMS5ydXItMjAyMS0wMS5yMVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xOF8wXzBfMF8yMDIxXzAxX1IxID0gT3JhY2xlRW5naW5lVmVyc2lvbi5vZignMTguMC4wLjAucnUtMjAyMS0wMS5ydXItMjAyMS0wMS5yMScsICcxOCcpO1xuICAvKiogVmVyc2lvbiBcIjE4LjAuMC4wLnJ1LTIwMjEtMDQucnVyLTIwMjEtMDQucjFcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMThfMF8wXzBfMjAyMV8wNF9SMSA9IE9yYWNsZUVuZ2luZVZlcnNpb24ub2YoJzE4LjAuMC4wLnJ1LTIwMjEtMDQucnVyLTIwMjEtMDQucjEnLCAnMTgnKTtcblxuICAvKiogVmVyc2lvbiBcIjE5XCIgKG9ubHkgYSBtYWpvciB2ZXJzaW9uLCB3aXRob3V0IGEgc3BlY2lmaWMgbWlub3IgdmVyc2lvbikuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzE5ID0gT3JhY2xlRW5naW5lVmVyc2lvbi5vZignMTknLCAnMTknKTtcbiAgLyoqIFZlcnNpb24gXCIxOS4wLjAuMC5ydS0yMDE5LTA3LnJ1ci0yMDE5LTA3LnIxXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzE5XzBfMF8wXzIwMTlfMDdfUjEgPSBPcmFjbGVFbmdpbmVWZXJzaW9uLm9mKCcxOS4wLjAuMC5ydS0yMDE5LTA3LnJ1ci0yMDE5LTA3LnIxJywgJzE5Jyk7XG4gIC8qKiBWZXJzaW9uIFwiMTkuMC4wLjAucnUtMjAxOS0xMC5ydXItMjAxOS0xMC5yMVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xOV8wXzBfMF8yMDE5XzEwX1IxID0gT3JhY2xlRW5naW5lVmVyc2lvbi5vZignMTkuMC4wLjAucnUtMjAxOS0xMC5ydXItMjAxOS0xMC5yMScsICcxOScpO1xuICAvKiogVmVyc2lvbiBcIjE5LjAuMC4wLnJ1LTIwMjAtMDEucnVyLTIwMjAtMDEucjFcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTlfMF8wXzBfMjAyMF8wMV9SMSA9IE9yYWNsZUVuZ2luZVZlcnNpb24ub2YoJzE5LjAuMC4wLnJ1LTIwMjAtMDEucnVyLTIwMjAtMDEucjEnLCAnMTknKTtcbiAgLyoqIFZlcnNpb24gXCIxOS4wLjAuMC5ydS0yMDIwLTA0LnJ1ci0yMDIwLTA0LnIxXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzE5XzBfMF8wXzIwMjBfMDRfUjEgPSBPcmFjbGVFbmdpbmVWZXJzaW9uLm9mKCcxOS4wLjAuMC5ydS0yMDIwLTA0LnJ1ci0yMDIwLTA0LnIxJywgJzE5Jyk7XG4gIC8qKiBWZXJzaW9uIFwiMTkuMC4wLjAucnUtMjAyMC0wNy5ydXItMjAyMC0wNy5yMVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xOV8wXzBfMF8yMDIwXzA3X1IxID0gT3JhY2xlRW5naW5lVmVyc2lvbi5vZignMTkuMC4wLjAucnUtMjAyMC0wNy5ydXItMjAyMC0wNy5yMScsICcxOScpO1xuICAvKiogVmVyc2lvbiBcIjE5LjAuMC4wLnJ1LTIwMjAtMDcucnVyLTIwMjAtMTAucjFcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTlfMF8wXzBfMjAyMF8xMF9SMSA9IE9yYWNsZUVuZ2luZVZlcnNpb24ub2YoJzE5LjAuMC4wLnJ1LTIwMjAtMTAucnVyLTIwMjAtMTAucjEnLCAnMTknKTtcbiAgLyoqIFZlcnNpb24gXCIxOS4wLjAuMC5ydS0yMDIxLTAxLnJ1ci0yMDIxLTAxLnIxXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzE5XzBfMF8wXzIwMjFfMDFfUjEgPSBPcmFjbGVFbmdpbmVWZXJzaW9uLm9mKCcxOS4wLjAuMC5ydS0yMDIxLTAxLnJ1ci0yMDIxLTAxLnIxJywgJzE5Jyk7XG4gIC8qKiBWZXJzaW9uIFwiMTkuMC4wLjAucnUtMjAyMS0wMS5ydXItMjAyMS0wMS5yMlwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xOV8wXzBfMF8yMDIxXzAxX1IyID0gT3JhY2xlRW5naW5lVmVyc2lvbi5vZignMTkuMC4wLjAucnUtMjAyMS0wMS5ydXItMjAyMS0wMS5yMicsICcxOScpO1xuICAvKiogVmVyc2lvbiBcIjE5LjAuMC4wLnJ1LTIwMjEtMDEucnVyLTIwMjEtMDQucjFcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTlfMF8wXzBfMjAyMV8wNF9SMSA9IE9yYWNsZUVuZ2luZVZlcnNpb24ub2YoJzE5LjAuMC4wLnJ1LTIwMjEtMDQucnVyLTIwMjEtMDQucjEnLCAnMTknKTtcbiAgLyoqIFZlcnNpb24gXCIxOS4wLjAuMC5ydS0yMDIxLTA3LnJ1ci0yMDIxLTA3LnIxXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzE5XzBfMF8wXzIwMjFfMDdfUjEgPSBPcmFjbGVFbmdpbmVWZXJzaW9uLm9mKCcxOS4wLjAuMC5ydS0yMDIxLTA3LnJ1ci0yMDIxLTA3LnIxJywgJzE5Jyk7XG4gIC8qKiBWZXJzaW9uIFwiMTkuMC4wLjAucnUtMjAyMS0xMC5ydXItMjAyMS0xMC5yMVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xOV8wXzBfMF8yMDIxXzEwX1IxID0gT3JhY2xlRW5naW5lVmVyc2lvbi5vZignMTkuMC4wLjAucnUtMjAyMS0xMC5ydXItMjAyMS0xMC5yMScsICcxOScpO1xuICAvKiogVmVyc2lvbiBcIjE5LjAuMC4wLnJ1LTIwMjItMDEucnVyLTIwMjItMDEucjFcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTlfMF8wXzBfMjAyMl8wMV9SMSA9IE9yYWNsZUVuZ2luZVZlcnNpb24ub2YoJzE5LjAuMC4wLnJ1LTIwMjItMDEucnVyLTIwMjItMDEucjEnLCAnMTknKTtcbiAgLyoqIFZlcnNpb24gXCIxOS4wLjAuMC5ydS0yMDIyLTA0LnJ1ci0yMDIyLTA0LnIxXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzE5XzBfMF8wXzIwMjJfMDRfUjEgPSBPcmFjbGVFbmdpbmVWZXJzaW9uLm9mKCcxOS4wLjAuMC5ydS0yMDIyLTA0LnJ1ci0yMDIyLTA0LnIxJywgJzE5Jyk7XG4gIC8qKiBWZXJzaW9uIFwiMTkuMC4wLjAucnUtMjAyMi0wNy5ydXItMjAyMi0wNy5yMVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xOV8wXzBfMF8yMDIyXzA3X1IxID0gT3JhY2xlRW5naW5lVmVyc2lvbi5vZignMTkuMC4wLjAucnUtMjAyMi0wNy5ydXItMjAyMi0wNy5yMScsICcxOScpO1xuICAvKiogVmVyc2lvbiBcIjE5LjAuMC4wLnJ1LTIwMjItMTAucnVyLTIwMjItMTAucjFcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTlfMF8wXzBfMjAyMl8xMF9SMSA9IE9yYWNsZUVuZ2luZVZlcnNpb24ub2YoJzE5LjAuMC4wLnJ1LTIwMjItMTAucnVyLTIwMjItMTAucjEnLCAnMTknKTtcbiAgLyoqIFZlcnNpb24gXCIxOS4wLjAuMC5ydS0yMDIzLTAxLnJ1ci0yMDIzLTAxLnIxXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzE5XzBfMF8wXzIwMjNfMDFfUjEgPSBPcmFjbGVFbmdpbmVWZXJzaW9uLm9mKCcxOS4wLjAuMC5ydS0yMDIzLTAxLnJ1ci0yMDIzLTAxLnIxJywgJzE5Jyk7XG5cbiAgLyoqIFZlcnNpb24gXCIyMVwiIChvbmx5IGEgbWFqb3IgdmVyc2lvbiwgd2l0aG91dCBhIHNwZWNpZmljIG1pbm9yIHZlcnNpb24pLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8yMSA9IE9yYWNsZUVuZ2luZVZlcnNpb24ub2YoJzIxJywgJzIxJyk7XG4gIC8qKiBWZXJzaW9uIFwiMjEuMC4wLjAucnUtMjAyMi0wMS5ydXItMjAyMi0wMS5yMVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8yMV8wXzBfMF8yMDIyXzAxX1IxID0gT3JhY2xlRW5naW5lVmVyc2lvbi5vZignMjEuMC4wLjAucnUtMjAyMi0wMS5ydXItMjAyMi0wMS5yMScsICcyMScpO1xuICAvKiogVmVyc2lvbiBcIjIxLjAuMC4wLnJ1LTIwMjItMDQucnVyLTIwMjItMDQucjFcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMjFfMF8wXzBfMjAyMl8wNF9SMSA9IE9yYWNsZUVuZ2luZVZlcnNpb24ub2YoJzIxLjAuMC4wLnJ1LTIwMjItMDQucnVyLTIwMjItMDQucjEnLCAnMjEnKTtcbiAgLyoqIFZlcnNpb24gXCIyMS4wLjAuMC5ydS0yMDIyLTA3LnJ1ci0yMDIyLTA3LnIxXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzIxXzBfMF8wXzIwMjJfMDdfUjEgPSBPcmFjbGVFbmdpbmVWZXJzaW9uLm9mKCcyMS4wLjAuMC5ydS0yMDIyLTA3LnJ1ci0yMDIyLTA3LnIxJywgJzIxJyk7XG4gIC8qKiBWZXJzaW9uIFwiMjEuMC4wLjAucnUtMjAyMi0xMC5ydXItMjAyMi0xMC5yMVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8yMV8wXzBfMF8yMDIyXzEwX1IxID0gT3JhY2xlRW5naW5lVmVyc2lvbi5vZignMjEuMC4wLjAucnUtMjAyMi0xMC5ydXItMjAyMi0xMC5yMScsICcyMScpO1xuICAvKiogVmVyc2lvbiBcIjIxLjAuMC4wLnJ1LTIwMjMtMDEucnVyLTIwMjMtMDEucjFcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMjFfMF8wXzBfMjAyM18wMV9SMSA9IE9yYWNsZUVuZ2luZVZlcnNpb24ub2YoJzIxLjAuMC4wLnJ1LTIwMjMtMDEucnVyLTIwMjMtMDEucjEnLCAnMjEnKTtcblxuICAvKipcbiAgICogQ3JlYXRlcyBhIG5ldyBPcmFjbGVFbmdpbmVWZXJzaW9uIHdpdGggYW4gYXJiaXRyYXJ5IHZlcnNpb24uXG4gICAqXG4gICAqIEBwYXJhbSBvcmFjbGVGdWxsVmVyc2lvbiB0aGUgZnVsbCB2ZXJzaW9uIHN0cmluZyxcbiAgICogICBmb3IgZXhhbXBsZSBcIjE5LjAuMC4wLnJ1LTIwMTktMTAucnVyLTIwMTktMTAucjFcIlxuICAgKiBAcGFyYW0gb3JhY2xlTWFqb3JWZXJzaW9uIHRoZSBtYWpvciB2ZXJzaW9uIG9mIHRoZSBlbmdpbmUsXG4gICAqICAgZm9yIGV4YW1wbGUgXCIxOVwiXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIG9mKG9yYWNsZUZ1bGxWZXJzaW9uOiBzdHJpbmcsIG9yYWNsZU1ham9yVmVyc2lvbjogc3RyaW5nKTogT3JhY2xlRW5naW5lVmVyc2lvbiB7XG4gICAgcmV0dXJuIG5ldyBPcmFjbGVFbmdpbmVWZXJzaW9uKG9yYWNsZUZ1bGxWZXJzaW9uLCBvcmFjbGVNYWpvclZlcnNpb24pO1xuICB9XG5cbiAgLyoqIFRoZSBmdWxsIHZlcnNpb24gc3RyaW5nLCBmb3IgZXhhbXBsZSwgXCIxOS4wLjAuMC5ydS0yMDE5LTEwLnJ1ci0yMDE5LTEwLnIxXCIuICovXG4gIHB1YmxpYyByZWFkb25seSBvcmFjbGVGdWxsVmVyc2lvbjogc3RyaW5nO1xuICAvKiogVGhlIG1ham9yIHZlcnNpb24gb2YgdGhlIGVuZ2luZSwgZm9yIGV4YW1wbGUsIFwiMTlcIi4gKi9cbiAgcHVibGljIHJlYWRvbmx5IG9yYWNsZU1ham9yVmVyc2lvbjogc3RyaW5nO1xuXG4gIHByaXZhdGUgY29uc3RydWN0b3Iob3JhY2xlRnVsbFZlcnNpb246IHN0cmluZywgb3JhY2xlTWFqb3JWZXJzaW9uOiBzdHJpbmcpIHtcbiAgICB0aGlzLm9yYWNsZUZ1bGxWZXJzaW9uID0gb3JhY2xlRnVsbFZlcnNpb247XG4gICAgdGhpcy5vcmFjbGVNYWpvclZlcnNpb24gPSBvcmFjbGVNYWpvclZlcnNpb247XG4gIH1cbn1cblxuaW50ZXJmYWNlIE9yYWNsZUluc3RhbmNlRW5naW5lQmFzZVByb3BzIHtcbiAgcmVhZG9ubHkgZW5naW5lVHlwZTogc3RyaW5nO1xuICByZWFkb25seSB2ZXJzaW9uPzogRW5naW5lVmVyc2lvbjtcbn1cblxuYWJzdHJhY3QgY2xhc3MgT3JhY2xlSW5zdGFuY2VFbmdpbmVCYXNlIGV4dGVuZHMgSW5zdGFuY2VFbmdpbmVCYXNlIHtcbiAgY29uc3RydWN0b3IocHJvcHM6IE9yYWNsZUluc3RhbmNlRW5naW5lQmFzZVByb3BzKSB7XG4gICAgc3VwZXIoe1xuICAgICAgLi4ucHJvcHMsXG4gICAgICBzaW5nbGVVc2VyUm90YXRpb25BcHBsaWNhdGlvbjogc2VjcmV0c21hbmFnZXIuU2VjcmV0Um90YXRpb25BcHBsaWNhdGlvbi5PUkFDTEVfUk9UQVRJT05fU0lOR0xFX1VTRVIsXG4gICAgICBtdWx0aVVzZXJSb3RhdGlvbkFwcGxpY2F0aW9uOiBzZWNyZXRzbWFuYWdlci5TZWNyZXRSb3RhdGlvbkFwcGxpY2F0aW9uLk9SQUNMRV9ST1RBVElPTl9NVUxUSV9VU0VSLFxuICAgICAgcGFyYW1ldGVyR3JvdXBGYW1pbHk6IHByb3BzLnZlcnNpb24gPyBgJHtwcm9wcy5lbmdpbmVUeXBlfS0ke3Byb3BzLnZlcnNpb24ubWFqb3JWZXJzaW9ufWAgOiB1bmRlZmluZWQsXG4gICAgICBmZWF0dXJlczoge1xuICAgICAgICBzM0ltcG9ydDogJ1MzX0lOVEVHUkFUSU9OJyxcbiAgICAgICAgczNFeHBvcnQ6ICdTM19JTlRFR1JBVElPTicsXG4gICAgICB9LFxuICAgIH0pO1xuICB9XG5cbiAgcHVibGljIGJpbmRUb0luc3RhbmNlKHNjb3BlOiBDb25zdHJ1Y3QsIG9wdGlvbnM6IEluc3RhbmNlRW5naW5lQmluZE9wdGlvbnMpOiBJbnN0YW5jZUVuZ2luZUNvbmZpZyB7XG4gICAgY29uc3QgY29uZmlnID0gc3VwZXIuYmluZFRvSW5zdGFuY2Uoc2NvcGUsIG9wdGlvbnMpO1xuXG4gICAgbGV0IG9wdGlvbkdyb3VwID0gb3B0aW9ucy5vcHRpb25Hcm91cDtcbiAgICBpZiAob3B0aW9ucy5zM0ltcG9ydFJvbGUgfHwgb3B0aW9ucy5zM0V4cG9ydFJvbGUpIHtcbiAgICAgIGlmICghb3B0aW9uR3JvdXApIHtcbiAgICAgICAgb3B0aW9uR3JvdXAgPSBuZXcgT3B0aW9uR3JvdXAoc2NvcGUsICdJbnN0YW5jZU9wdGlvbkdyb3VwJywge1xuICAgICAgICAgIGVuZ2luZTogdGhpcyxcbiAgICAgICAgICBjb25maWd1cmF0aW9uczogW10sXG4gICAgICAgIH0pO1xuICAgICAgfVxuICAgICAgLy8gaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FtYXpvblJEUy9sYXRlc3QvVXNlckd1aWRlL29yYWNsZS1zMy1pbnRlZ3JhdGlvbi5odG1sXG4gICAgICBvcHRpb25Hcm91cC5hZGRDb25maWd1cmF0aW9uKHtcbiAgICAgICAgbmFtZTogJ1MzX0lOVEVHUkFUSU9OJyxcbiAgICAgICAgdmVyc2lvbjogJzEuMCcsXG4gICAgICB9KTtcbiAgICB9XG5cbiAgICByZXR1cm4ge1xuICAgICAgLi4uY29uZmlnLFxuICAgICAgb3B0aW9uR3JvdXAsXG4gICAgfTtcbiAgfVxufVxuXG5pbnRlcmZhY2UgT3JhY2xlSW5zdGFuY2VFbmdpbmVQcm9wcyB7XG4gIC8qKiBUaGUgZXhhY3QgdmVyc2lvbiBvZiB0aGUgZW5naW5lIHRvIHVzZS4gKi9cbiAgcmVhZG9ubHkgdmVyc2lvbjogT3JhY2xlRW5naW5lVmVyc2lvbjtcbn1cblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBPcmFjbGUgU3RhbmRhcmQgRWRpdGlvbiBpbnN0YW5jZSBlbmdpbmVzLlxuICogVXNlZCBpbiBgRGF0YWJhc2VJbnN0YW5jZUVuZ2luZS5vcmFjbGVTZWAuXG4gKlxuICogQGRlcHJlY2F0ZWQgaW5zdGFuY2VzIGNhbiBubyBsb25nZXIgYmUgY3JlYXRlZCB3aXRoIHRoaXMgZW5naW5lLiBTZWUgaHR0cHM6Ly9mb3J1bXMuYXdzLmFtYXpvbi5jb20vYW5uLmpzcGE/YW5uSUQ9NzM0MVxuICovXG5leHBvcnQgaW50ZXJmYWNlIE9yYWNsZVNlSW5zdGFuY2VFbmdpbmVQcm9wcyB7XG4gIC8qKiBUaGUgZXhhY3QgdmVyc2lvbiBvZiB0aGUgZW5naW5lIHRvIHVzZS4gKi9cbiAgcmVhZG9ubHkgdmVyc2lvbjogT3JhY2xlTGVnYWN5RW5naW5lVmVyc2lvbjtcbn1cblxuLyoqIEBkZXByZWNhdGVkIGluc3RhbmNlcyBjYW4gbm8gbG9uZ2VyIGJlIGNyZWF0ZWQgd2l0aCB0aGlzIGVuZ2luZS4gU2VlIGh0dHBzOi8vZm9ydW1zLmF3cy5hbWF6b24uY29tL2Fubi5qc3BhP2FubklEPTczNDEgKi9cbmNsYXNzIE9yYWNsZVNlSW5zdGFuY2VFbmdpbmUgZXh0ZW5kcyBPcmFjbGVJbnN0YW5jZUVuZ2luZUJhc2Uge1xuICBjb25zdHJ1Y3Rvcih2ZXJzaW9uPzogT3JhY2xlTGVnYWN5RW5naW5lVmVyc2lvbikge1xuICAgIHN1cGVyKHtcbiAgICAgIGVuZ2luZVR5cGU6ICdvcmFjbGUtc2UnLFxuICAgICAgdmVyc2lvbjogdmVyc2lvblxuICAgICAgICA/IHtcbiAgICAgICAgICBmdWxsVmVyc2lvbjogdmVyc2lvbi5vcmFjbGVMZWdhY3lGdWxsVmVyc2lvbixcbiAgICAgICAgICBtYWpvclZlcnNpb246IHZlcnNpb24ub3JhY2xlTGVnYWN5TWFqb3JWZXJzaW9uLFxuICAgICAgICB9XG4gICAgICAgIDoge1xuICAgICAgICAgIG1ham9yVmVyc2lvbjogJzExLjInLFxuICAgICAgICB9LFxuICAgIH0pO1xuICB9XG59XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgT3JhY2xlIFN0YW5kYXJkIEVkaXRpb24gMSBpbnN0YW5jZSBlbmdpbmVzLlxuICogVXNlZCBpbiBgRGF0YWJhc2VJbnN0YW5jZUVuZ2luZS5vcmFjbGVTZTFgLlxuICpcbiAqIEBkZXByZWNhdGVkIGluc3RhbmNlcyBjYW4gbm8gbG9uZ2VyIGJlIGNyZWF0ZWQgd2l0aCB0aGlzIGVuZ2luZS4gU2VlIGh0dHBzOi8vZm9ydW1zLmF3cy5hbWF6b24uY29tL2Fubi5qc3BhP2FubklEPTczNDFcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBPcmFjbGVTZTFJbnN0YW5jZUVuZ2luZVByb3BzIHtcbiAgLyoqIFRoZSBleGFjdCB2ZXJzaW9uIG9mIHRoZSBlbmdpbmUgdG8gdXNlLiAqL1xuICByZWFkb25seSB2ZXJzaW9uOiBPcmFjbGVMZWdhY3lFbmdpbmVWZXJzaW9uO1xufVxuXG4vKiogQGRlcHJlY2F0ZWQgaW5zdGFuY2VzIGNhbiBubyBsb25nZXIgYmUgY3JlYXRlZCB3aXRoIHRoaXMgZW5naW5lLiBTZWUgaHR0cHM6Ly9mb3J1bXMuYXdzLmFtYXpvbi5jb20vYW5uLmpzcGE/YW5uSUQ9NzM0MSAqL1xuY2xhc3MgT3JhY2xlU2UxSW5zdGFuY2VFbmdpbmUgZXh0ZW5kcyBPcmFjbGVJbnN0YW5jZUVuZ2luZUJhc2Uge1xuICBjb25zdHJ1Y3Rvcih2ZXJzaW9uPzogT3JhY2xlTGVnYWN5RW5naW5lVmVyc2lvbikge1xuICAgIHN1cGVyKHtcbiAgICAgIGVuZ2luZVR5cGU6ICdvcmFjbGUtc2UxJyxcbiAgICAgIHZlcnNpb246IHZlcnNpb25cbiAgICAgICAgPyB7XG4gICAgICAgICAgZnVsbFZlcnNpb246IHZlcnNpb24ub3JhY2xlTGVnYWN5RnVsbFZlcnNpb24sXG4gICAgICAgICAgbWFqb3JWZXJzaW9uOiB2ZXJzaW9uLm9yYWNsZUxlZ2FjeU1ham9yVmVyc2lvbixcbiAgICAgICAgfVxuICAgICAgICA6IHtcbiAgICAgICAgICBtYWpvclZlcnNpb246ICcxMS4yJyxcbiAgICAgICAgfSxcbiAgICB9KTtcbiAgfVxufVxuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIE9yYWNsZSBTdGFuZGFyZCBFZGl0aW9uIDIgaW5zdGFuY2UgZW5naW5lcy5cbiAqIFVzZWQgaW4gYERhdGFiYXNlSW5zdGFuY2VFbmdpbmUub3JhY2xlU2UyYC5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBPcmFjbGVTZTJJbnN0YW5jZUVuZ2luZVByb3BzIGV4dGVuZHMgT3JhY2xlSW5zdGFuY2VFbmdpbmVQcm9wcyB7XG59XG5cbmNsYXNzIE9yYWNsZVNlMkluc3RhbmNlRW5naW5lIGV4dGVuZHMgT3JhY2xlSW5zdGFuY2VFbmdpbmVCYXNlIHtcbiAgY29uc3RydWN0b3IodmVyc2lvbj86IE9yYWNsZUVuZ2luZVZlcnNpb24pIHtcbiAgICBzdXBlcih7XG4gICAgICBlbmdpbmVUeXBlOiAnb3JhY2xlLXNlMicsXG4gICAgICB2ZXJzaW9uOiB2ZXJzaW9uXG4gICAgICAgID8ge1xuICAgICAgICAgIGZ1bGxWZXJzaW9uOiB2ZXJzaW9uLm9yYWNsZUZ1bGxWZXJzaW9uLFxuICAgICAgICAgIG1ham9yVmVyc2lvbjogdmVyc2lvbi5vcmFjbGVNYWpvclZlcnNpb24sXG4gICAgICAgIH1cbiAgICAgICAgOiB1bmRlZmluZWQsXG4gICAgfSk7XG4gIH1cbn1cblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBPcmFjbGUgU3RhbmRhcmQgRWRpdGlvbiAyIChDREIpIGluc3RhbmNlIGVuZ2luZXMuXG4gKiBVc2VkIGluIGBEYXRhYmFzZUluc3RhbmNlRW5naW5lLm9yYWNsZVNlMkNkYmAuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgT3JhY2xlU2UyQ2RiSW5zdGFuY2VFbmdpbmVQcm9wcyBleHRlbmRzIE9yYWNsZUluc3RhbmNlRW5naW5lUHJvcHMge1xufVxuXG5jbGFzcyBPcmFjbGVTZTJDZGJJbnN0YW5jZUVuZ2luZSBleHRlbmRzIE9yYWNsZUluc3RhbmNlRW5naW5lQmFzZSB7XG4gIGNvbnN0cnVjdG9yKHZlcnNpb24/OiBPcmFjbGVFbmdpbmVWZXJzaW9uKSB7XG4gICAgc3VwZXIoe1xuICAgICAgZW5naW5lVHlwZTogJ29yYWNsZS1zZTItY2RiJyxcbiAgICAgIHZlcnNpb246IHZlcnNpb25cbiAgICAgICAgPyB7XG4gICAgICAgICAgZnVsbFZlcnNpb246IHZlcnNpb24ub3JhY2xlRnVsbFZlcnNpb24sXG4gICAgICAgICAgbWFqb3JWZXJzaW9uOiB2ZXJzaW9uLm9yYWNsZU1ham9yVmVyc2lvbixcbiAgICAgICAgfVxuICAgICAgICA6IHVuZGVmaW5lZCxcbiAgICB9KTtcbiAgfVxufVxuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIE9yYWNsZSBFbnRlcnByaXNlIEVkaXRpb24gaW5zdGFuY2UgZW5naW5lcy5cbiAqIFVzZWQgaW4gYERhdGFiYXNlSW5zdGFuY2VFbmdpbmUub3JhY2xlRWVgLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIE9yYWNsZUVlSW5zdGFuY2VFbmdpbmVQcm9wcyBleHRlbmRzIE9yYWNsZUluc3RhbmNlRW5naW5lUHJvcHMge1xufVxuXG5jbGFzcyBPcmFjbGVFZUluc3RhbmNlRW5naW5lIGV4dGVuZHMgT3JhY2xlSW5zdGFuY2VFbmdpbmVCYXNlIHtcbiAgY29uc3RydWN0b3IodmVyc2lvbj86IE9yYWNsZUVuZ2luZVZlcnNpb24pIHtcbiAgICBzdXBlcih7XG4gICAgICBlbmdpbmVUeXBlOiAnb3JhY2xlLWVlJyxcbiAgICAgIHZlcnNpb246IHZlcnNpb25cbiAgICAgICAgPyB7XG4gICAgICAgICAgZnVsbFZlcnNpb246IHZlcnNpb24ub3JhY2xlRnVsbFZlcnNpb24sXG4gICAgICAgICAgbWFqb3JWZXJzaW9uOiB2ZXJzaW9uLm9yYWNsZU1ham9yVmVyc2lvbixcbiAgICAgICAgfVxuICAgICAgICA6IHVuZGVmaW5lZCxcbiAgICB9KTtcbiAgfVxufVxuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIE9yYWNsZSBFbnRlcnByaXNlIEVkaXRpb24gKENEQikgaW5zdGFuY2UgZW5naW5lcy5cbiAqIFVzZWQgaW4gYERhdGFiYXNlSW5zdGFuY2VFbmdpbmUub3JhY2xlRWVDZGJgLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIE9yYWNsZUVlQ2RiSW5zdGFuY2VFbmdpbmVQcm9wcyBleHRlbmRzIE9yYWNsZUluc3RhbmNlRW5naW5lUHJvcHMge1xufVxuXG5jbGFzcyBPcmFjbGVFZUNkYkluc3RhbmNlRW5naW5lIGV4dGVuZHMgT3JhY2xlSW5zdGFuY2VFbmdpbmVCYXNlIHtcbiAgY29uc3RydWN0b3IodmVyc2lvbj86IE9yYWNsZUVuZ2luZVZlcnNpb24pIHtcbiAgICBzdXBlcih7XG4gICAgICBlbmdpbmVUeXBlOiAnb3JhY2xlLWVlLWNkYicsXG4gICAgICB2ZXJzaW9uOiB2ZXJzaW9uXG4gICAgICAgID8ge1xuICAgICAgICAgIGZ1bGxWZXJzaW9uOiB2ZXJzaW9uLm9yYWNsZUZ1bGxWZXJzaW9uLFxuICAgICAgICAgIG1ham9yVmVyc2lvbjogdmVyc2lvbi5vcmFjbGVNYWpvclZlcnNpb24sXG4gICAgICAgIH1cbiAgICAgICAgOiB1bmRlZmluZWQsXG4gICAgfSk7XG4gIH1cbn1cblxuLyoqXG4gKiBUaGUgdmVyc2lvbnMgZm9yIHRoZSBTUUwgU2VydmVyIGluc3RhbmNlIGVuZ2luZXNcbiAqICh0aG9zZSByZXR1cm5lZCBieSBgRGF0YWJhc2VJbnN0YW5jZUVuZ2luZS5zcWxTZXJ2ZXJTZWAsXG4gKiBgRGF0YWJhc2VJbnN0YW5jZUVuZ2luZS5zcWxTZXJ2ZXJFeGAsIGBEYXRhYmFzZUluc3RhbmNlRW5naW5lLnNxbFNlcnZlcldlYmBcbiAqIGFuZCBgRGF0YWJhc2VJbnN0YW5jZUVuZ2luZS5zcWxTZXJ2ZXJFZWApLlxuICovXG5leHBvcnQgY2xhc3MgU3FsU2VydmVyRW5naW5lVmVyc2lvbiB7XG4gIC8qKiBWZXJzaW9uIFwiMTEuMDBcIiAob25seSBhIG1ham9yIHZlcnNpb24sIHdpdGhvdXQgYSBzcGVjaWZpYyBtaW5vciB2ZXJzaW9uKS4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTEgPSBTcWxTZXJ2ZXJFbmdpbmVWZXJzaW9uLm9mKCcxMS4wMCcsICcxMS4wMCcpO1xuICAvKiogVmVyc2lvbiBcIjExLjAwLjUwNTguMC52MVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMV8wMF81MDU4XzBfVjEgPSBTcWxTZXJ2ZXJFbmdpbmVWZXJzaW9uLm9mKCcxMS4wMC41MDU4LjAudjEnLCAnMTEuMDAnKTtcbiAgLyoqIFZlcnNpb24gXCIxMS4wMC42MDIwLjAudjFcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTFfMDBfNjAyMF8wX1YxID0gU3FsU2VydmVyRW5naW5lVmVyc2lvbi5vZignMTEuMDAuNjAyMC4wLnYxJywgJzExLjAwJyk7XG4gIC8qKiBWZXJzaW9uIFwiMTEuMDAuNjU5NC4wLnYxXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzExXzAwXzY1OTRfMF9WMSA9IFNxbFNlcnZlckVuZ2luZVZlcnNpb24ub2YoJzExLjAwLjY1OTQuMC52MScsICcxMS4wMCcpO1xuICAvKiogVmVyc2lvbiBcIjExLjAwLjc0NjIuNi52MVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMV8wMF83NDYyXzZfVjEgPSBTcWxTZXJ2ZXJFbmdpbmVWZXJzaW9uLm9mKCcxMS4wMC43NDYyLjYudjEnLCAnMTEuMDAnKTtcbiAgLyoqIFZlcnNpb24gXCIxMS4wMC43NDkzLjQudjFcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTFfMDBfNzQ5M180X1YxID0gU3FsU2VydmVyRW5naW5lVmVyc2lvbi5vZignMTEuMDAuNzQ5My40LnYxJywgJzExLjAwJyk7XG5cbiAgLyoqIFZlcnNpb24gXCIxMi4wMFwiIChvbmx5IGEgbWFqb3IgdmVyc2lvbiwgd2l0aG91dCBhIHNwZWNpZmljIG1pbm9yIHZlcnNpb24pLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMiA9IFNxbFNlcnZlckVuZ2luZVZlcnNpb24ub2YoJzEyLjAwJywgJzEyLjAwJyk7XG4gIC8qKiBWZXJzaW9uIFwiMTIuMDAuNTAwMC4wLnYxXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEyXzAwXzUwMDBfMF9WMSA9IFNxbFNlcnZlckVuZ2luZVZlcnNpb24ub2YoJzEyLjAwLjUwMDAuMC52MScsICcxMi4wMCcpO1xuICAvKiogVmVyc2lvbiBcIjEyLjAwLjU1NDYuMC52MVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8wMF81NTQ2XzBfVjEgPSBTcWxTZXJ2ZXJFbmdpbmVWZXJzaW9uLm9mKCcxMi4wMC41NTQ2LjAudjEnLCAnMTIuMDAnKTtcbiAgLyoqIFZlcnNpb24gXCIxMi4wMC41NTcxLjAudjFcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTJfMDBfNTU3MV8wX1YxID0gU3FsU2VydmVyRW5naW5lVmVyc2lvbi5vZignMTIuMDAuNTU3MS4wLnYxJywgJzEyLjAwJyk7XG4gIC8qKiBWZXJzaW9uIFwiMTIuMDAuNjI5My4wLnYxXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEyXzAwXzYyOTNfMF9WMSA9IFNxbFNlcnZlckVuZ2luZVZlcnNpb24ub2YoJzEyLjAwLjYyOTMuMC52MScsICcxMi4wMCcpO1xuICAvKiogVmVyc2lvbiBcIjEyLjAwLjYzMjkuMS52MVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8wMF82MzI5XzFfVjEgPSBTcWxTZXJ2ZXJFbmdpbmVWZXJzaW9uLm9mKCcxMi4wMC42MzI5LjEudjEnLCAnMTIuMDAnKTtcbiAgLyoqIFZlcnNpb24gXCIxMi4wMC42NDMzLjEudjFcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTJfMDBfNjQzM18xX1YxID0gU3FsU2VydmVyRW5naW5lVmVyc2lvbi5vZignMTIuMDAuNjQzMy4xLnYxJywgJzEyLjAwJyk7XG4gIC8qKiBWZXJzaW9uIFwiMTIuMDAuNjQzOS4xMC52MVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xMl8wMF82NDM5XzEwX1YxID0gU3FsU2VydmVyRW5naW5lVmVyc2lvbi5vZignMTIuMDAuNjQzOS4xMC52MScsICcxMi4wMCcpO1xuXG4gIC8qKiBWZXJzaW9uIFwiMTMuMDBcIiAob25seSBhIG1ham9yIHZlcnNpb24sIHdpdGhvdXQgYSBzcGVjaWZpYyBtaW5vciB2ZXJzaW9uKS4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTMgPSBTcWxTZXJ2ZXJFbmdpbmVWZXJzaW9uLm9mKCcxMy4wMCcsICcxMy4wMCcpO1xuICAvKiogVmVyc2lvbiBcIjEzLjAwLjIxNjQuMC52MVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xM18wMF8yMTY0XzBfVjEgPSBTcWxTZXJ2ZXJFbmdpbmVWZXJzaW9uLm9mKCcxMy4wMC4yMTY0LjAudjEnLCAnMTMuMDAnKTtcbiAgLyoqIFZlcnNpb24gXCIxMy4wMC40NDIyLjAudjFcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTNfMDBfNDQyMl8wX1YxID0gU3FsU2VydmVyRW5naW5lVmVyc2lvbi5vZignMTMuMDAuNDQyMi4wLnYxJywgJzEzLjAwJyk7XG4gIC8qKiBWZXJzaW9uIFwiMTMuMDAuNDQ1MS4wLnYxXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEzXzAwXzQ0NTFfMF9WMSA9IFNxbFNlcnZlckVuZ2luZVZlcnNpb24ub2YoJzEzLjAwLjQ0NTEuMC52MScsICcxMy4wMCcpO1xuICAvKiogVmVyc2lvbiBcIjEzLjAwLjQ0NjYuNC52MVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xM18wMF80NDY2XzRfVjEgPSBTcWxTZXJ2ZXJFbmdpbmVWZXJzaW9uLm9mKCcxMy4wMC40NDY2LjQudjEnLCAnMTMuMDAnKTtcbiAgLyoqIFZlcnNpb24gXCIxMy4wMC40NTIyLjAudjFcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTNfMDBfNDUyMl8wX1YxID0gU3FsU2VydmVyRW5naW5lVmVyc2lvbi5vZignMTMuMDAuNDUyMi4wLnYxJywgJzEzLjAwJyk7XG4gIC8qKiBWZXJzaW9uIFwiMTMuMDAuNTIxNi4wLnYxXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEzXzAwXzUyMTZfMF9WMSA9IFNxbFNlcnZlckVuZ2luZVZlcnNpb24ub2YoJzEzLjAwLjUyMTYuMC52MScsICcxMy4wMCcpO1xuICAvKiogVmVyc2lvbiBcIjEzLjAwLjUyOTIuMC52MVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xM18wMF81MjkyXzBfVjEgPSBTcWxTZXJ2ZXJFbmdpbmVWZXJzaW9uLm9mKCcxMy4wMC41MjkyLjAudjEnLCAnMTMuMDAnKTtcbiAgLyoqIFZlcnNpb24gXCIxMy4wMC41MzY2LjAudjFcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTNfMDBfNTM2Nl8wX1YxID0gU3FsU2VydmVyRW5naW5lVmVyc2lvbi5vZignMTMuMDAuNTM2Ni4wLnYxJywgJzEzLjAwJyk7XG4gIC8qKiBWZXJzaW9uIFwiMTMuMDAuNTQyNi4wLnYxXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEzXzAwXzU0MjZfMF9WMSA9IFNxbFNlcnZlckVuZ2luZVZlcnNpb24ub2YoJzEzLjAwLjU0MjYuMC52MScsICcxMy4wMCcpO1xuICAvKiogVmVyc2lvbiBcIjEzLjAwLjU1OTguMjcudjFcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTNfMDBfNTU5OF8yN19WMSA9IFNxbFNlcnZlckVuZ2luZVZlcnNpb24ub2YoJzEzLjAwLjU1OTguMjcudjEnLCAnMTMuMDAnKTtcbiAgLyoqIFZlcnNpb24gXCIxMy4wMC41ODIwLjIxLnYxXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEzXzAwXzU4MjBfMjFfVjEgPSBTcWxTZXJ2ZXJFbmdpbmVWZXJzaW9uLm9mKCcxMy4wMC41ODIwLjIxLnYxJywgJzEzLjAwJyk7XG4gIC8qKiBWZXJzaW9uIFwiMTMuMDAuNTg1MC4xNC52MVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xM18wMF81ODUwXzE0X1YxID0gU3FsU2VydmVyRW5naW5lVmVyc2lvbi5vZignMTMuMDAuNTg1MC4xNC52MScsICcxMy4wMCcpO1xuICAvKiogVmVyc2lvbiBcIjEzLjAwLjU4ODIuMS52MVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xM18wMF81ODgyXzFfVjEgPSBTcWxTZXJ2ZXJFbmdpbmVWZXJzaW9uLm9mKCcxMy4wMC41ODgyLjEudjEnLCAnMTMuMDAnKTtcbiAgLyoqIFZlcnNpb24gXCIxMy4wMC42MzAwLjIudjFcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTNfMDBfNjMwMF8yX1YxID0gU3FsU2VydmVyRW5naW5lVmVyc2lvbi5vZignMTMuMDAuNjMwMC4yLnYxJywgJzEzLjAwJyk7XG4gIC8qKiBWZXJzaW9uIFwiMTMuMDAuNjQxOS4xLnYxXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzEzXzAwXzY0MTlfMV9WMSA9IFNxbFNlcnZlckVuZ2luZVZlcnNpb24ub2YoJzEzLjAwLjY0MTkuMS52MScsICcxMy4wMCcpO1xuXG4gIC8qKiBWZXJzaW9uIFwiMTQuMDBcIiAob25seSBhIG1ham9yIHZlcnNpb24sIHdpdGhvdXQgYSBzcGVjaWZpYyBtaW5vciB2ZXJzaW9uKS4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTQgPSBTcWxTZXJ2ZXJFbmdpbmVWZXJzaW9uLm9mKCcxNC4wMCcsICcxNC4wMCcpO1xuICAvKiogVmVyc2lvbiBcIjE0LjAwLjEwMDAuMTY5LnYxXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzE0XzAwXzEwMDBfMTY5X1YxID0gU3FsU2VydmVyRW5naW5lVmVyc2lvbi5vZignMTQuMDAuMTAwMC4xNjkudjEnLCAnMTQuMDAnKTtcbiAgLyoqIFZlcnNpb24gXCIxNC4wMC4zMDE1LjQwLnYxXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzE0XzAwXzMwMTVfNDBfVjEgPSBTcWxTZXJ2ZXJFbmdpbmVWZXJzaW9uLm9mKCcxNC4wMC4zMDE1LjQwLnYxJywgJzE0LjAwJyk7XG4gIC8qKiBWZXJzaW9uIFwiMTQuMDAuMzAzNS4yLnYxXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzE0XzAwXzMwMzVfMl9WMSA9IFNxbFNlcnZlckVuZ2luZVZlcnNpb24ub2YoJzE0LjAwLjMwMzUuMi52MScsICcxNC4wMCcpO1xuICAvKiogVmVyc2lvbiBcIjE0LjAwLjMwNDkuMS52MVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xNF8wMF8zMDQ5XzFfVjEgPSBTcWxTZXJ2ZXJFbmdpbmVWZXJzaW9uLm9mKCcxNC4wMC4zMDQ5LjEudjEnLCAnMTQuMDAnKTtcbiAgLyoqXG4gICAqIFZlcnNpb24gXCIxNC4wMC4zMTkyLjIudjFcIi5cbiAgICogQGRlcHJlY2F0ZWQgU1FMIFNlcnZlciB2ZXJzaW9uIDE0LjAwLjMxOTIuMi52MSByZWFjaGVkIGVuZCBvZiBsaWZlXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzE0XzAwXzMxOTJfMl9WMSA9IFNxbFNlcnZlckVuZ2luZVZlcnNpb24ub2YoJzE0LjAwLjMxOTIuMi52MScsICcxNC4wMCcpO1xuICAvKiogVmVyc2lvbiBcIjE0LjAwLjMyMjMuMy52MVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xNF8wMF8zMjIzXzNfVjEgPSBTcWxTZXJ2ZXJFbmdpbmVWZXJzaW9uLm9mKCcxNC4wMC4zMjIzLjMudjEnLCAnMTQuMDAnKTtcbiAgLyoqIFZlcnNpb24gXCIxNC4wMC4zMjgxLjYudjFcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTRfMDBfMzI4MV82X1YxID0gU3FsU2VydmVyRW5naW5lVmVyc2lvbi5vZignMTQuMDAuMzI4MS42LnYxJywgJzE0LjAwJyk7XG4gIC8qKiBWZXJzaW9uIFwiMTQuMDAuMzI5NC4yLnYxXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzE0XzAwXzMyOTRfMl9WMSA9IFNxbFNlcnZlckVuZ2luZVZlcnNpb24ub2YoJzE0LjAwLjMyOTQuMi52MScsICcxNC4wMCcpO1xuICAvKiogVmVyc2lvbiBcIjE0LjAwLjMzNTYuMjAudjFcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTRfMDBfMzM1Nl8yMF9WMSA9IFNxbFNlcnZlckVuZ2luZVZlcnNpb24ub2YoJzE0LjAwLjMzNTYuMjAudjEnLCAnMTQuMDAnKTtcbiAgLyoqIFZlcnNpb24gXCIxNC4wMC4zMzgxLjMudjFcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTRfMDBfMzM4MV8zX1YxID0gU3FsU2VydmVyRW5naW5lVmVyc2lvbi5vZignMTQuMDAuMzM4MS4zLnYxJywgJzE0LjAwJyk7XG4gIC8qKiBWZXJzaW9uIFwiMTQuMDAuMzQwMS43LnYxXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzE0XzAwXzM0MDFfN19WMSA9IFNxbFNlcnZlckVuZ2luZVZlcnNpb24ub2YoJzE0LjAwLjM0MDEuNy52MScsICcxNC4wMCcpO1xuICAvKiogVmVyc2lvbiBcIjE0LjAwLjM0MjEuMTAudjFcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTRfMDBfMzQyMV8xMF9WMSA9IFNxbFNlcnZlckVuZ2luZVZlcnNpb24ub2YoJzE0LjAwLjM0MjEuMTAudjEnLCAnMTQuMDAnKTtcbiAgLyoqIFZlcnNpb24gXCIxNC4wMC4zNDUxLjIudjFcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTRfMDBfMzQ1MV8yX1YxID0gU3FsU2VydmVyRW5naW5lVmVyc2lvbi5vZignMTQuMDAuMzQ1MS4yLnYxJywgJzE0LjAwJyk7XG5cbiAgLyoqIFZlcnNpb24gXCIxNS4wMFwiIChvbmx5IGEgbWFqb3IgdmVyc2lvbiwgd2l0aG91dCBhIHNwZWNpZmljIG1pbm9yIHZlcnNpb24pLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xNSA9IFNxbFNlcnZlckVuZ2luZVZlcnNpb24ub2YoJzE1LjAwJywgJzE1LjAwJyk7XG4gIC8qKiBWZXJzaW9uIFwiMTUuMDAuNDA0My4xNi52MVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xNV8wMF80MDQzXzE2X1YxID0gU3FsU2VydmVyRW5naW5lVmVyc2lvbi5vZignMTUuMDAuNDA0My4xNi52MScsICcxNS4wMCcpO1xuICAvKipcbiAgICogVmVyc2lvbiBcIjE1LjAwLjQwNDMuMjMudjFcIi5cbiAgICogQGRlcHJlY2F0ZWQgVGhpcyB2ZXJzaW9uIGlzIGVycm9uZW91cy4gWW91IG1pZ2h0IGJlIGxvb2tpbmcgZm9yIGBTcWxTZXJ2ZXJFbmdpbmVWZXJzaW9uLlZFUl8xNV8wMF80MDczXzIzX1YxYCwgaW5zdGVhZC5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzE1XzAwXzQwNDNfMjNfVjEgPSBTcWxTZXJ2ZXJFbmdpbmVWZXJzaW9uLm9mKCcxNS4wMC40MDQzLjIzLnYxJywgJzE1LjAwJyk7XG4gIC8qKiBWZXJzaW9uIFwiMTUuMDAuNDA3My4yMy52MVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xNV8wMF80MDczXzIzX1YxID0gU3FsU2VydmVyRW5naW5lVmVyc2lvbi5vZignMTUuMDAuNDA3My4yMy52MScsICcxNS4wMCcpO1xuICAvKiogVmVyc2lvbiBcIjE1LjAwLjQxNTMuMS52MVwiLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZFUl8xNV8wMF80MTUzXzFfVjEgPSBTcWxTZXJ2ZXJFbmdpbmVWZXJzaW9uLm9mKCcxNS4wMC40MTUzLjEudjEnLCAnMTUuMDAnKTtcbiAgLyoqIFZlcnNpb24gXCIxNS4wMC40MTk4LjIudjFcIi4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJfMTVfMDBfNDE5OF8yX1YxID0gU3FsU2VydmVyRW5naW5lVmVyc2lvbi5vZignMTUuMDAuNDE5OC4yLnYxJywgJzE1LjAwJyk7XG4gIC8qKiBWZXJzaW9uIFwiMTUuMDAuNDIzNi43LnYxXCIuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSXzE1XzAwXzQyMzZfN19WMSA9IFNxbFNlcnZlckVuZ2luZVZlcnNpb24ub2YoJzE1LjAwLjQyMzYuNy52MScsICcxNS4wMCcpO1xuXG5cbiAgLyoqXG4gICAqIENyZWF0ZSBhIG5ldyBTcWxTZXJ2ZXJFbmdpbmVWZXJzaW9uIHdpdGggYW4gYXJiaXRyYXJ5IHZlcnNpb24uXG4gICAqXG4gICAqIEBwYXJhbSBzcWxTZXJ2ZXJGdWxsVmVyc2lvbiB0aGUgZnVsbCB2ZXJzaW9uIHN0cmluZyxcbiAgICogICBmb3IgZXhhbXBsZSBcIjE1LjAwLjMwNDkuMS52MVwiXG4gICAqIEBwYXJhbSBzcWxTZXJ2ZXJNYWpvclZlcnNpb24gdGhlIG1ham9yIHZlcnNpb24gb2YgdGhlIGVuZ2luZSxcbiAgICogICBmb3IgZXhhbXBsZSBcIjE1LjAwXCJcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgb2Yoc3FsU2VydmVyRnVsbFZlcnNpb246IHN0cmluZywgc3FsU2VydmVyTWFqb3JWZXJzaW9uOiBzdHJpbmcpOiBTcWxTZXJ2ZXJFbmdpbmVWZXJzaW9uIHtcbiAgICByZXR1cm4gbmV3IFNxbFNlcnZlckVuZ2luZVZlcnNpb24oc3FsU2VydmVyRnVsbFZlcnNpb24sIHNxbFNlcnZlck1ham9yVmVyc2lvbik7XG4gIH1cblxuICAvKiogVGhlIGZ1bGwgdmVyc2lvbiBzdHJpbmcsIGZvciBleGFtcGxlLCBcIjE1LjAwLjMwNDkuMS52MVwiLiAqL1xuICBwdWJsaWMgcmVhZG9ubHkgc3FsU2VydmVyRnVsbFZlcnNpb246IHN0cmluZztcbiAgLyoqIFRoZSBtYWpvciB2ZXJzaW9uIG9mIHRoZSBlbmdpbmUsIGZvciBleGFtcGxlLCBcIjE1LjAwXCIuICovXG4gIHB1YmxpYyByZWFkb25seSBzcWxTZXJ2ZXJNYWpvclZlcnNpb246IHN0cmluZztcblxuICBwcml2YXRlIGNvbnN0cnVjdG9yKHNxbFNlcnZlckZ1bGxWZXJzaW9uOiBzdHJpbmcsIHNxbFNlcnZlck1ham9yVmVyc2lvbjogc3RyaW5nKSB7XG4gICAgdGhpcy5zcWxTZXJ2ZXJGdWxsVmVyc2lvbiA9IHNxbFNlcnZlckZ1bGxWZXJzaW9uO1xuICAgIHRoaXMuc3FsU2VydmVyTWFqb3JWZXJzaW9uID0gc3FsU2VydmVyTWFqb3JWZXJzaW9uO1xuICB9XG59XG5cbmludGVyZmFjZSBTcWxTZXJ2ZXJJbnN0YW5jZUVuZ2luZVByb3BzIHtcbiAgLyoqIFRoZSBleGFjdCB2ZXJzaW9uIG9mIHRoZSBlbmdpbmUgdG8gdXNlLiAqL1xuICByZWFkb25seSB2ZXJzaW9uOiBTcWxTZXJ2ZXJFbmdpbmVWZXJzaW9uO1xufVxuXG5pbnRlcmZhY2UgU3FsU2VydmVySW5zdGFuY2VFbmdpbmVCYXNlUHJvcHMge1xuICByZWFkb25seSBlbmdpbmVUeXBlOiBzdHJpbmc7XG4gIHJlYWRvbmx5IHZlcnNpb24/OiBTcWxTZXJ2ZXJFbmdpbmVWZXJzaW9uO1xufVxuXG5hYnN0cmFjdCBjbGFzcyBTcWxTZXJ2ZXJJbnN0YW5jZUVuZ2luZUJhc2UgZXh0ZW5kcyBJbnN0YW5jZUVuZ2luZUJhc2Uge1xuICBjb25zdHJ1Y3Rvcihwcm9wczogU3FsU2VydmVySW5zdGFuY2VFbmdpbmVCYXNlUHJvcHMpIHtcbiAgICBzdXBlcih7XG4gICAgICAuLi5wcm9wcyxcbiAgICAgIHNpbmdsZVVzZXJSb3RhdGlvbkFwcGxpY2F0aW9uOiBzZWNyZXRzbWFuYWdlci5TZWNyZXRSb3RhdGlvbkFwcGxpY2F0aW9uLlNRTFNFUlZFUl9ST1RBVElPTl9TSU5HTEVfVVNFUixcbiAgICAgIG11bHRpVXNlclJvdGF0aW9uQXBwbGljYXRpb246IHNlY3JldHNtYW5hZ2VyLlNlY3JldFJvdGF0aW9uQXBwbGljYXRpb24uU1FMU0VSVkVSX1JPVEFUSU9OX01VTFRJX1VTRVIsXG4gICAgICB2ZXJzaW9uOiBwcm9wcy52ZXJzaW9uXG4gICAgICAgID8ge1xuICAgICAgICAgIGZ1bGxWZXJzaW9uOiBwcm9wcy52ZXJzaW9uLnNxbFNlcnZlckZ1bGxWZXJzaW9uLFxuICAgICAgICAgIG1ham9yVmVyc2lvbjogcHJvcHMudmVyc2lvbi5zcWxTZXJ2ZXJNYWpvclZlcnNpb24sXG4gICAgICAgIH1cbiAgICAgICAgOiB1bmRlZmluZWQsXG4gICAgICBwYXJhbWV0ZXJHcm91cEZhbWlseTogcHJvcHMudmVyc2lvblxuICAgICAgICAvLyBmb3Igc29tZSByZWFzb24sIGV2ZW4gdGhvdWdoIFNRTCBTZXJ2ZXIgbWFqb3IgdmVyc2lvbnMgdXN1YWxseSBlbmQgaW4gJy4wMCcsXG4gICAgICAgIC8vIHRoZSBQYXJhbWV0ZXJHcm91cCBmYW1pbHkgaGFzIHRvIGVuZCBpbiAnLjAnXG4gICAgICAgID8gYCR7cHJvcHMuZW5naW5lVHlwZX0tJHtwcm9wcy52ZXJzaW9uLnNxbFNlcnZlck1ham9yVmVyc2lvbi5lbmRzV2l0aCgnLjAwJylcbiAgICAgICAgICA/IHByb3BzLnZlcnNpb24uc3FsU2VydmVyTWFqb3JWZXJzaW9uLnNsaWNlKDAsIC0xKVxuICAgICAgICAgIDogcHJvcHMudmVyc2lvbi5zcWxTZXJ2ZXJNYWpvclZlcnNpb259YFxuICAgICAgICA6IHVuZGVmaW5lZCxcbiAgICAgIGZlYXR1cmVzOiB7XG4gICAgICAgIHMzSW1wb3J0OiAnUzNfSU5URUdSQVRJT04nLFxuICAgICAgICBzM0V4cG9ydDogJ1MzX0lOVEVHUkFUSU9OJyxcbiAgICAgIH0sXG4gICAgfSk7XG4gIH1cblxuICBwdWJsaWMgYmluZFRvSW5zdGFuY2Uoc2NvcGU6IENvbnN0cnVjdCwgb3B0aW9uczogSW5zdGFuY2VFbmdpbmVCaW5kT3B0aW9ucyk6IEluc3RhbmNlRW5naW5lQ29uZmlnIHtcbiAgICBjb25zdCBjb25maWcgPSBzdXBlci5iaW5kVG9JbnN0YW5jZShzY29wZSwgb3B0aW9ucyk7XG5cbiAgICBsZXQgb3B0aW9uR3JvdXAgPSBvcHRpb25zLm9wdGlvbkdyb3VwO1xuICAgIGNvbnN0IHMzUm9sZSA9IG9wdGlvbnMuczNJbXBvcnRSb2xlID8/IG9wdGlvbnMuczNFeHBvcnRSb2xlO1xuICAgIGlmIChzM1JvbGUpIHtcbiAgICAgIGlmIChvcHRpb25zLnMzSW1wb3J0Um9sZSAmJiBvcHRpb25zLnMzRXhwb3J0Um9sZSAmJiBvcHRpb25zLnMzSW1wb3J0Um9sZSAhPT0gb3B0aW9ucy5zM0V4cG9ydFJvbGUpIHtcbiAgICAgICAgdGhyb3cgbmV3IEVycm9yKCdTMyBpbXBvcnQgYW5kIGV4cG9ydCByb2xlcyBtdXN0IGJlIHRoZSBzYW1lIGZvciBTUUwgU2VydmVyIGVuZ2luZXMnKTtcbiAgICAgIH1cblxuICAgICAgaWYgKCFvcHRpb25Hcm91cCkge1xuICAgICAgICBvcHRpb25Hcm91cCA9IG5ldyBPcHRpb25Hcm91cChzY29wZSwgJ0luc3RhbmNlT3B0aW9uR3JvdXAnLCB7XG4gICAgICAgICAgZW5naW5lOiB0aGlzLFxuICAgICAgICAgIGNvbmZpZ3VyYXRpb25zOiBbXSxcbiAgICAgICAgfSk7XG4gICAgICB9XG4gICAgICAvLyBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQW1hem9uUkRTL2xhdGVzdC9Vc2VyR3VpZGUvQXBwZW5kaXguU1FMU2VydmVyLk9wdGlvbnMuQmFja3VwUmVzdG9yZS5odG1sXG4gICAgICBvcHRpb25Hcm91cC5hZGRDb25maWd1cmF0aW9uKHtcbiAgICAgICAgbmFtZTogJ1NRTFNFUlZFUl9CQUNLVVBfUkVTVE9SRScsXG4gICAgICAgIHNldHRpbmdzOiB7IElBTV9ST0xFX0FSTjogczNSb2xlLnJvbGVBcm4gfSxcbiAgICAgIH0pO1xuICAgIH1cblxuICAgIHJldHVybiB7XG4gICAgICAuLi5jb25maWcsXG4gICAgICBvcHRpb25Hcm91cCxcbiAgICB9O1xuICB9XG5cbiAgcHJvdGVjdGVkIGdldCBzdXBwb3J0c1RpbWV6b25lKCkgeyByZXR1cm4gdHJ1ZTsgfVxufVxuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIFNRTCBTZXJ2ZXIgU3RhbmRhcmQgRWRpdGlvbiBpbnN0YW5jZSBlbmdpbmVzLlxuICogVXNlZCBpbiBgRGF0YWJhc2VJbnN0YW5jZUVuZ2luZS5zcWxTZXJ2ZXJTZWAuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgU3FsU2VydmVyU2VJbnN0YW5jZUVuZ2luZVByb3BzIGV4dGVuZHMgU3FsU2VydmVySW5zdGFuY2VFbmdpbmVQcm9wcyB7XG59XG5cbmNsYXNzIFNxbFNlcnZlclNlSW5zdGFuY2VFbmdpbmUgZXh0ZW5kcyBTcWxTZXJ2ZXJJbnN0YW5jZUVuZ2luZUJhc2Uge1xuICBjb25zdHJ1Y3Rvcih2ZXJzaW9uPzogU3FsU2VydmVyRW5naW5lVmVyc2lvbikge1xuICAgIHN1cGVyKHtcbiAgICAgIGVuZ2luZVR5cGU6ICdzcWxzZXJ2ZXItc2UnLFxuICAgICAgdmVyc2lvbixcbiAgICB9KTtcbiAgfVxufVxuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIFNRTCBTZXJ2ZXIgRXhwcmVzcyBFZGl0aW9uIGluc3RhbmNlIGVuZ2luZXMuXG4gKiBVc2VkIGluIGBEYXRhYmFzZUluc3RhbmNlRW5naW5lLnNxbFNlcnZlckV4YC5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBTcWxTZXJ2ZXJFeEluc3RhbmNlRW5naW5lUHJvcHMgZXh0ZW5kcyBTcWxTZXJ2ZXJJbnN0YW5jZUVuZ2luZVByb3BzIHtcbn1cblxuY2xhc3MgU3FsU2VydmVyRXhJbnN0YW5jZUVuZ2luZSBleHRlbmRzIFNxbFNlcnZlckluc3RhbmNlRW5naW5lQmFzZSB7XG4gIGNvbnN0cnVjdG9yKHZlcnNpb24/OiBTcWxTZXJ2ZXJFbmdpbmVWZXJzaW9uKSB7XG4gICAgc3VwZXIoe1xuICAgICAgZW5naW5lVHlwZTogJ3NxbHNlcnZlci1leCcsXG4gICAgICB2ZXJzaW9uLFxuICAgIH0pO1xuICB9XG59XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgU1FMIFNlcnZlciBXZWIgRWRpdGlvbiBpbnN0YW5jZSBlbmdpbmVzLlxuICogVXNlZCBpbiBgRGF0YWJhc2VJbnN0YW5jZUVuZ2luZS5zcWxTZXJ2ZXJXZWJgLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIFNxbFNlcnZlcldlYkluc3RhbmNlRW5naW5lUHJvcHMgZXh0ZW5kcyBTcWxTZXJ2ZXJJbnN0YW5jZUVuZ2luZVByb3BzIHtcbn1cblxuY2xhc3MgU3FsU2VydmVyV2ViSW5zdGFuY2VFbmdpbmUgZXh0ZW5kcyBTcWxTZXJ2ZXJJbnN0YW5jZUVuZ2luZUJhc2Uge1xuICBjb25zdHJ1Y3Rvcih2ZXJzaW9uPzogU3FsU2VydmVyRW5naW5lVmVyc2lvbikge1xuICAgIHN1cGVyKHtcbiAgICAgIGVuZ2luZVR5cGU6ICdzcWxzZXJ2ZXItd2ViJyxcbiAgICAgIHZlcnNpb24sXG4gICAgfSk7XG4gIH1cbn1cblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBTUUwgU2VydmVyIEVudGVycHJpc2UgRWRpdGlvbiBpbnN0YW5jZSBlbmdpbmVzLlxuICogVXNlZCBpbiBgRGF0YWJhc2VJbnN0YW5jZUVuZ2luZS5zcWxTZXJ2ZXJFZWAuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgU3FsU2VydmVyRWVJbnN0YW5jZUVuZ2luZVByb3BzIGV4dGVuZHMgU3FsU2VydmVySW5zdGFuY2VFbmdpbmVQcm9wcyB7XG59XG5cbmNsYXNzIFNxbFNlcnZlckVlSW5zdGFuY2VFbmdpbmUgZXh0ZW5kcyBTcWxTZXJ2ZXJJbnN0YW5jZUVuZ2luZUJhc2Uge1xuICBjb25zdHJ1Y3Rvcih2ZXJzaW9uPzogU3FsU2VydmVyRW5naW5lVmVyc2lvbikge1xuICAgIHN1cGVyKHtcbiAgICAgIGVuZ2luZVR5cGU6ICdzcWxzZXJ2ZXItZWUnLFxuICAgICAgdmVyc2lvbixcbiAgICB9KTtcbiAgfVxufVxuXG4vKipcbiAqIEEgZGF0YWJhc2UgaW5zdGFuY2UgZW5naW5lLiBQcm92aWRlcyBtYXBwaW5nIHRvIERhdGFiYXNlRW5naW5lIHVzZWQgZm9yXG4gKiBzZWNyZXQgcm90YXRpb24uXG4gKi9cbmV4cG9ydCBjbGFzcyBEYXRhYmFzZUluc3RhbmNlRW5naW5lIHtcbiAgLyoqXG4gICAqIFRoZSB1bnZlcnNpb25lZCAnbWFyaWFkYicgaW5zdGFuY2UgZW5naW5lLlxuICAgKlxuICAgKiBOT1RFOiB1c2luZyB1bnZlcnNpb25lZCBlbmdpbmVzIGlzIGFuIGF2YWlsYWJpbGl0eSByaXNrLlxuICAgKiAgIFdlIHJlY29tbWVuZCB1c2luZyB2ZXJzaW9uZWQgZW5naW5lcyBjcmVhdGVkIHVzaW5nIHRoZSBgbWFyaWFEYigpYCBtZXRob2RcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgTUFSSUFEQjogSUluc3RhbmNlRW5naW5lID0gbmV3IE1hcmlhRGJJbnN0YW5jZUVuZ2luZSgpO1xuXG4gIC8qKlxuICAgKiBUaGUgdW52ZXJzaW9uZWQgJ215c3FsJyBpbnN0YW5jZSBlbmdpbmUuXG4gICAqXG4gICAqIE5PVEU6IHVzaW5nIHVudmVyc2lvbmVkIGVuZ2luZXMgaXMgYW4gYXZhaWxhYmlsaXR5IHJpc2suXG4gICAqICAgV2UgcmVjb21tZW5kIHVzaW5nIHZlcnNpb25lZCBlbmdpbmVzIGNyZWF0ZWQgdXNpbmcgdGhlIGBteXNxbCgpYCBtZXRob2RcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgTVlTUUw6IElJbnN0YW5jZUVuZ2luZSA9IG5ldyBNeVNxbEluc3RhbmNlRW5naW5lKCk7XG5cbiAgLyoqXG4gICAqIFRoZSB1bnZlcnNpb25lZCAnb3JhY2xlLWVlJyBpbnN0YW5jZSBlbmdpbmUuXG4gICAqXG4gICAqIE5PVEU6IHVzaW5nIHVudmVyc2lvbmVkIGVuZ2luZXMgaXMgYW4gYXZhaWxhYmlsaXR5IHJpc2suXG4gICAqICAgV2UgcmVjb21tZW5kIHVzaW5nIHZlcnNpb25lZCBlbmdpbmVzIGNyZWF0ZWQgdXNpbmcgdGhlIGBvcmFjbGVFZSgpYCBtZXRob2RcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgT1JBQ0xFX0VFOiBJSW5zdGFuY2VFbmdpbmUgPSBuZXcgT3JhY2xlRWVJbnN0YW5jZUVuZ2luZSgpO1xuXG4gIC8qKlxuICAgKiBUaGUgdW52ZXJzaW9uZWQgJ29yYWNsZS1lZS1jZGInIGluc3RhbmNlIGVuZ2luZS5cbiAgICpcbiAgICogTk9URTogdXNpbmcgdW52ZXJzaW9uZWQgZW5naW5lcyBpcyBhbiBhdmFpbGFiaWxpdHkgcmlzay5cbiAgICogICBXZSByZWNvbW1lbmQgdXNpbmcgdmVyc2lvbmVkIGVuZ2luZXMgY3JlYXRlZCB1c2luZyB0aGUgYG9yYWNsZUVlQ2RiKClgIG1ldGhvZFxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBPUkFDTEVfRUVfQ0RCOiBJSW5zdGFuY2VFbmdpbmUgPSBuZXcgT3JhY2xlRWVDZGJJbnN0YW5jZUVuZ2luZSgpO1xuXG4gIC8qKlxuICAgKiBUaGUgdW52ZXJzaW9uZWQgJ29yYWNsZS1zZTInIGluc3RhbmNlIGVuZ2luZS5cbiAgICpcbiAgICogTk9URTogdXNpbmcgdW52ZXJzaW9uZWQgZW5naW5lcyBpcyBhbiBhdmFpbGFiaWxpdHkgcmlzay5cbiAgICogICBXZSByZWNvbW1lbmQgdXNpbmcgdmVyc2lvbmVkIGVuZ2luZXMgY3JlYXRlZCB1c2luZyB0aGUgYG9yYWNsZVNlMigpYCBtZXRob2RcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgT1JBQ0xFX1NFMjogSUluc3RhbmNlRW5naW5lID0gbmV3IE9yYWNsZVNlMkluc3RhbmNlRW5naW5lKCk7XG5cbiAgLyoqXG4gICAqIFRoZSB1bnZlcnNpb25lZCAnb3JhY2xlLXNlMi1jZGInIGluc3RhbmNlIGVuZ2luZS5cbiAgICpcbiAgICogTk9URTogdXNpbmcgdW52ZXJzaW9uZWQgZW5naW5lcyBpcyBhbiBhdmFpbGFiaWxpdHkgcmlzay5cbiAgICogICBXZSByZWNvbW1lbmQgdXNpbmcgdmVyc2lvbmVkIGVuZ2luZXMgY3JlYXRlZCB1c2luZyB0aGUgYG9yYWNsZVNlMkNkYigpYCBtZXRob2RcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgT1JBQ0xFX1NFMl9DREI6IElJbnN0YW5jZUVuZ2luZSA9IG5ldyBPcmFjbGVTZTJDZGJJbnN0YW5jZUVuZ2luZSgpO1xuXG4gIC8qKlxuICAgKiBUaGUgdW52ZXJzaW9uZWQgJ29yYWNsZS1zZTEnIGluc3RhbmNlIGVuZ2luZS5cbiAgICpcbiAgICogQGRlcHJlY2F0ZWQgaW5zdGFuY2VzIGNhbiBubyBsb25nZXIgYmUgY3JlYXRlZCB3aXRoIHRoaXMgZW5naW5lLiBTZWUgaHR0cHM6Ly9mb3J1bXMuYXdzLmFtYXpvbi5jb20vYW5uLmpzcGE/YW5uSUQ9NzM0MVxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBPUkFDTEVfU0UxOiBJSW5zdGFuY2VFbmdpbmUgPSBuZXcgT3JhY2xlU2UxSW5zdGFuY2VFbmdpbmUoKTtcblxuICAvKipcbiAgICogVGhlIHVudmVyc2lvbmVkICdvcmFjbGUtc2UnIGluc3RhbmNlIGVuZ2luZS5cbiAgICpcbiAgICogQGRlcHJlY2F0ZWQgaW5zdGFuY2VzIGNhbiBubyBsb25nZXIgYmUgY3JlYXRlZCB3aXRoIHRoaXMgZW5naW5lLiBTZWUgaHR0cHM6Ly9mb3J1bXMuYXdzLmFtYXpvbi5jb20vYW5uLmpzcGE/YW5uSUQ9NzM0MVxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBPUkFDTEVfU0U6IElJbnN0YW5jZUVuZ2luZSA9IG5ldyBPcmFjbGVTZUluc3RhbmNlRW5naW5lKCk7XG5cbiAgLyoqXG4gICAqIFRoZSB1bnZlcnNpb25lZCAncG9zdGdyZXMnIGluc3RhbmNlIGVuZ2luZS5cbiAgICpcbiAgICogTk9URTogdXNpbmcgdW52ZXJzaW9uZWQgZW5naW5lcyBpcyBhbiBhdmFpbGFiaWxpdHkgcmlzay5cbiAgICogICBXZSByZWNvbW1lbmQgdXNpbmcgdmVyc2lvbmVkIGVuZ2luZXMgY3JlYXRlZCB1c2luZyB0aGUgYHBvc3RncmVzKClgIG1ldGhvZFxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBQT1NUR1JFUzogSUluc3RhbmNlRW5naW5lID0gbmV3IFBvc3RncmVzSW5zdGFuY2VFbmdpbmUoKTtcblxuICAvKipcbiAgICogVGhlIHVudmVyc2lvbmVkICdzcWxzZXJ2ZXItZWUnIGluc3RhbmNlIGVuZ2luZS5cbiAgICpcbiAgICogTk9URTogdXNpbmcgdW52ZXJzaW9uZWQgZW5naW5lcyBpcyBhbiBhdmFpbGFiaWxpdHkgcmlzay5cbiAgICogICBXZSByZWNvbW1lbmQgdXNpbmcgdmVyc2lvbmVkIGVuZ2luZXMgY3JlYXRlZCB1c2luZyB0aGUgYHNxbFNlcnZlckVlKClgIG1ldGhvZFxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBTUUxfU0VSVkVSX0VFOiBJSW5zdGFuY2VFbmdpbmUgPSBuZXcgU3FsU2VydmVyRWVJbnN0YW5jZUVuZ2luZSgpO1xuXG4gIC8qKlxuICAgKiBUaGUgdW52ZXJzaW9uZWQgJ3NxbHNlcnZlci1zZScgaW5zdGFuY2UgZW5naW5lLlxuICAgKlxuICAgKiBOT1RFOiB1c2luZyB1bnZlcnNpb25lZCBlbmdpbmVzIGlzIGFuIGF2YWlsYWJpbGl0eSByaXNrLlxuICAgKiAgIFdlIHJlY29tbWVuZCB1c2luZyB2ZXJzaW9uZWQgZW5naW5lcyBjcmVhdGVkIHVzaW5nIHRoZSBgc3FsU2VydmVyU2UoKWAgbWV0aG9kXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFNRTF9TRVJWRVJfU0U6IElJbnN0YW5jZUVuZ2luZSA9IG5ldyBTcWxTZXJ2ZXJTZUluc3RhbmNlRW5naW5lKCk7XG5cbiAgLyoqXG4gICAqIFRoZSB1bnZlcnNpb25lZCAnc3Fsc2VydmVyLWV4JyBpbnN0YW5jZSBlbmdpbmUuXG4gICAqXG4gICAqIE5PVEU6IHVzaW5nIHVudmVyc2lvbmVkIGVuZ2luZXMgaXMgYW4gYXZhaWxhYmlsaXR5IHJpc2suXG4gICAqICAgV2UgcmVjb21tZW5kIHVzaW5nIHZlcnNpb25lZCBlbmdpbmVzIGNyZWF0ZWQgdXNpbmcgdGhlIGBzcWxTZXJ2ZXJFeCgpYCBtZXRob2RcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgU1FMX1NFUlZFUl9FWDogSUluc3RhbmNlRW5naW5lID0gbmV3IFNxbFNlcnZlckV4SW5zdGFuY2VFbmdpbmUoKTtcblxuICAvKipcbiAgICogVGhlIHVudmVyc2lvbmVkICdzcWxzZXJ2ZXItd2ViJyBpbnN0YW5jZSBlbmdpbmUuXG4gICAqXG4gICAqIE5PVEU6IHVzaW5nIHVudmVyc2lvbmVkIGVuZ2luZXMgaXMgYW4gYXZhaWxhYmlsaXR5IHJpc2suXG4gICAqICAgV2UgcmVjb21tZW5kIHVzaW5nIHZlcnNpb25lZCBlbmdpbmVzIGNyZWF0ZWQgdXNpbmcgdGhlIGBzcWxTZXJ2ZXJXZWIoKWAgbWV0aG9kXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFNRTF9TRVJWRVJfV0VCOiBJSW5zdGFuY2VFbmdpbmUgPSBuZXcgU3FsU2VydmVyV2ViSW5zdGFuY2VFbmdpbmUoKTtcblxuICAvKiogQ3JlYXRlcyBhIG5ldyBNYXJpYURCIGluc3RhbmNlIGVuZ2luZS4gKi9cbiAgcHVibGljIHN0YXRpYyBtYXJpYURiKHByb3BzOiBNYXJpYURiSW5zdGFuY2VFbmdpbmVQcm9wcyk6IElJbnN0YW5jZUVuZ2luZSB7XG4gICAgcmV0dXJuIG5ldyBNYXJpYURiSW5zdGFuY2VFbmdpbmUocHJvcHMudmVyc2lvbik7XG4gIH1cblxuICAvKiogQ3JlYXRlcyBhIG5ldyBNeVNRTCBpbnN0YW5jZSBlbmdpbmUuICovXG4gIHB1YmxpYyBzdGF0aWMgbXlzcWwocHJvcHM6IE15U3FsSW5zdGFuY2VFbmdpbmVQcm9wcyk6IElJbnN0YW5jZUVuZ2luZSB7XG4gICAgcmV0dXJuIG5ldyBNeVNxbEluc3RhbmNlRW5naW5lKHByb3BzLnZlcnNpb24pO1xuICB9XG5cbiAgLyoqIENyZWF0ZXMgYSBuZXcgUG9zdGdyZVNRTCBpbnN0YW5jZSBlbmdpbmUuICovXG4gIHB1YmxpYyBzdGF0aWMgcG9zdGdyZXMocHJvcHM6IFBvc3RncmVzSW5zdGFuY2VFbmdpbmVQcm9wcyk6IElJbnN0YW5jZUVuZ2luZSB7XG4gICAgcmV0dXJuIG5ldyBQb3N0Z3Jlc0luc3RhbmNlRW5naW5lKHByb3BzLnZlcnNpb24pO1xuICB9XG5cbiAgLyoqXG4gICAqIENyZWF0ZXMgYSBuZXcgT3JhY2xlIFN0YW5kYXJkIEVkaXRpb24gaW5zdGFuY2UgZW5naW5lLlxuICAgKiBAZGVwcmVjYXRlZCBpbnN0YW5jZXMgY2FuIG5vIGxvbmdlciBiZSBjcmVhdGVkIHdpdGggdGhpcyBlbmdpbmUuIFNlZSBodHRwczovL2ZvcnVtcy5hd3MuYW1hem9uLmNvbS9hbm4uanNwYT9hbm5JRD03MzQxXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIG9yYWNsZVNlKHByb3BzOiBPcmFjbGVTZUluc3RhbmNlRW5naW5lUHJvcHMpOiBJSW5zdGFuY2VFbmdpbmUge1xuICAgIHJldHVybiBuZXcgT3JhY2xlU2VJbnN0YW5jZUVuZ2luZShwcm9wcy52ZXJzaW9uKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBDcmVhdGVzIGEgbmV3IE9yYWNsZSBTdGFuZGFyZCBFZGl0aW9uIDEgaW5zdGFuY2UgZW5naW5lLlxuICAgKiBAZGVwcmVjYXRlZCBpbnN0YW5jZXMgY2FuIG5vIGxvbmdlciBiZSBjcmVhdGVkIHdpdGggdGhpcyBlbmdpbmUuIFNlZSBodHRwczovL2ZvcnVtcy5hd3MuYW1hem9uLmNvbS9hbm4uanNwYT9hbm5JRD03MzQxXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIG9yYWNsZVNlMShwcm9wczogT3JhY2xlU2UxSW5zdGFuY2VFbmdpbmVQcm9wcyk6IElJbnN0YW5jZUVuZ2luZSB7XG4gICAgcmV0dXJuIG5ldyBPcmFjbGVTZTFJbnN0YW5jZUVuZ2luZShwcm9wcy52ZXJzaW9uKTtcbiAgfVxuXG4gIC8qKiBDcmVhdGVzIGEgbmV3IE9yYWNsZSBTdGFuZGFyZCBFZGl0aW9uIDIgaW5zdGFuY2UgZW5naW5lLiAqL1xuICBwdWJsaWMgc3RhdGljIG9yYWNsZVNlMihwcm9wczogT3JhY2xlU2UySW5zdGFuY2VFbmdpbmVQcm9wcyk6IElJbnN0YW5jZUVuZ2luZSB7XG4gICAgcmV0dXJuIG5ldyBPcmFjbGVTZTJJbnN0YW5jZUVuZ2luZShwcm9wcy52ZXJzaW9uKTtcbiAgfVxuXG4gIC8qKiBDcmVhdGVzIGEgbmV3IE9yYWNsZSBTdGFuZGFyZCBFZGl0aW9uIDIgKENEQikgaW5zdGFuY2UgZW5naW5lLiAqL1xuICBwdWJsaWMgc3RhdGljIG9yYWNsZVNlMkNkYihwcm9wczogT3JhY2xlU2UyQ2RiSW5zdGFuY2VFbmdpbmVQcm9wcyk6IElJbnN0YW5jZUVuZ2luZSB7XG4gICAgcmV0dXJuIG5ldyBPcmFjbGVTZTJDZGJJbnN0YW5jZUVuZ2luZShwcm9wcy52ZXJzaW9uKTtcbiAgfVxuXG4gIC8qKiBDcmVhdGVzIGEgbmV3IE9yYWNsZSBFbnRlcnByaXNlIEVkaXRpb24gaW5zdGFuY2UgZW5naW5lLiAqL1xuICBwdWJsaWMgc3RhdGljIG9yYWNsZUVlKHByb3BzOiBPcmFjbGVFZUluc3RhbmNlRW5naW5lUHJvcHMpOiBJSW5zdGFuY2VFbmdpbmUge1xuICAgIHJldHVybiBuZXcgT3JhY2xlRWVJbnN0YW5jZUVuZ2luZShwcm9wcy52ZXJzaW9uKTtcbiAgfVxuXG4gIC8qKiBDcmVhdGVzIGEgbmV3IE9yYWNsZSBFbnRlcnByaXNlIEVkaXRpb24gKENEQikgaW5zdGFuY2UgZW5naW5lLiAqL1xuICBwdWJsaWMgc3RhdGljIG9yYWNsZUVlQ2RiKHByb3BzOiBPcmFjbGVFZUNkYkluc3RhbmNlRW5naW5lUHJvcHMpOiBJSW5zdGFuY2VFbmdpbmUge1xuICAgIHJldHVybiBuZXcgT3JhY2xlRWVDZGJJbnN0YW5jZUVuZ2luZShwcm9wcy52ZXJzaW9uKTtcbiAgfVxuXG4gIC8qKiBDcmVhdGVzIGEgbmV3IFNRTCBTZXJ2ZXIgU3RhbmRhcmQgRWRpdGlvbiBpbnN0YW5jZSBlbmdpbmUuICovXG4gIHB1YmxpYyBzdGF0aWMgc3FsU2VydmVyU2UocHJvcHM6IFNxbFNlcnZlclNlSW5zdGFuY2VFbmdpbmVQcm9wcyk6IElJbnN0YW5jZUVuZ2luZSB7XG4gICAgcmV0dXJuIG5ldyBTcWxTZXJ2ZXJTZUluc3RhbmNlRW5naW5lKHByb3BzLnZlcnNpb24pO1xuICB9XG5cbiAgLyoqIENyZWF0ZXMgYSBuZXcgU1FMIFNlcnZlciBFeHByZXNzIEVkaXRpb24gaW5zdGFuY2UgZW5naW5lLiAqL1xuICBwdWJsaWMgc3RhdGljIHNxbFNlcnZlckV4KHByb3BzOiBTcWxTZXJ2ZXJFeEluc3RhbmNlRW5naW5lUHJvcHMpOiBJSW5zdGFuY2VFbmdpbmUge1xuICAgIHJldHVybiBuZXcgU3FsU2VydmVyRXhJbnN0YW5jZUVuZ2luZShwcm9wcy52ZXJzaW9uKTtcbiAgfVxuXG4gIC8qKiBDcmVhdGVzIGEgbmV3IFNRTCBTZXJ2ZXIgV2ViIEVkaXRpb24gaW5zdGFuY2UgZW5naW5lLiAqL1xuICBwdWJsaWMgc3RhdGljIHNxbFNlcnZlcldlYihwcm9wczogU3FsU2VydmVyV2ViSW5zdGFuY2VFbmdpbmVQcm9wcyk6IElJbnN0YW5jZUVuZ2luZSB7XG4gICAgcmV0dXJuIG5ldyBTcWxTZXJ2ZXJXZWJJbnN0YW5jZUVuZ2luZShwcm9wcy52ZXJzaW9uKTtcbiAgfVxuXG4gIC8qKiBDcmVhdGVzIGEgbmV3IFNRTCBTZXJ2ZXIgRW50ZXJwcmlzZSBFZGl0aW9uIGluc3RhbmNlIGVuZ2luZS4gKi9cbiAgcHVibGljIHN0YXRpYyBzcWxTZXJ2ZXJFZShwcm9wczogU3FsU2VydmVyRWVJbnN0YW5jZUVuZ2luZVByb3BzKTogSUluc3RhbmNlRW5naW5lIHtcbiAgICByZXR1cm4gbmV3IFNxbFNlcnZlckVlSW5zdGFuY2VFbmdpbmUocHJvcHMudmVyc2lvbik7XG4gIH1cbn1cbiJdfQ==