"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OptionGroup = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("../../aws-ec2");
const core_1 = require("../../core");
const rds_generated_1 = require("./rds.generated");
/**
 * An option group
 */
class OptionGroup extends core_1.Resource {
    /**
     * Import an existing option group.
     */
    static fromOptionGroupName(scope, id, optionGroupName) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.optionGroupName = optionGroupName;
            }
            addConfiguration(_) { return false; }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * The connections object for the options.
         */
        this.optionConnections = {};
        this.configurations = [];
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_OptionGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, OptionGroup);
            }
            throw error;
        }
        const majorEngineVersion = props.engine.engineVersion?.majorVersion;
        if (!majorEngineVersion) {
            throw new Error("OptionGroup cannot be used with an engine that doesn't specify a version");
        }
        props.configurations.forEach(config => this.addConfiguration(config));
        const optionGroup = new rds_generated_1.CfnOptionGroup(this, 'Resource', {
            engineName: props.engine.engineType,
            majorEngineVersion,
            optionGroupDescription: props.description || `Option group for ${props.engine.engineType} ${majorEngineVersion}`,
            optionConfigurations: core_1.Lazy.any({ produce: () => this.renderConfigurations(this.configurations) }),
        });
        this.optionGroupName = optionGroup.ref;
    }
    addConfiguration(configuration) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_OptionConfiguration(configuration);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addConfiguration);
            }
            throw error;
        }
        this.configurations.push(configuration);
        if (configuration.port) {
            if (!configuration.vpc) {
                throw new Error('`port` and `vpc` must be specified together.');
            }
            const securityGroups = configuration.securityGroups && configuration.securityGroups.length > 0
                ? configuration.securityGroups
                : [new ec2.SecurityGroup(this, `SecurityGroup${configuration.name}`, {
                        description: `Security group for ${configuration.name} option`,
                        vpc: configuration.vpc,
                    })];
            this.optionConnections[configuration.name] = new ec2.Connections({
                securityGroups: securityGroups,
                defaultPort: ec2.Port.tcp(configuration.port),
            });
        }
        return true;
    }
    /**
     * Renders the option configurations specifications.
     */
    renderConfigurations(configurations) {
        const configs = [];
        for (const config of configurations) {
            const securityGroups = config.vpc
                ? this.optionConnections[config.name].securityGroups.map(sg => sg.securityGroupId)
                : undefined;
            configs.push({
                optionName: config.name,
                optionSettings: config.settings && Object.entries(config.settings).map(([name, value]) => ({ name, value })),
                optionVersion: config.version,
                port: config.port,
                vpcSecurityGroupMemberships: securityGroups,
            });
        }
        return configs;
    }
}
_a = JSII_RTTI_SYMBOL_1;
OptionGroup[_a] = { fqn: "aws-cdk-lib.aws_rds.OptionGroup", version: "2.74.0" };
exports.OptionGroup = OptionGroup;
//# sourceMappingURL=data:application/json;base64,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