"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ParameterGroup = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const rds_generated_1 = require("./rds.generated");
/**
 * A parameter group.
 * Represents both a cluster parameter group,
 * and an instance parameter group.
 *
 * @resource AWS::RDS::DBParameterGroup
 */
class ParameterGroup extends core_1.Resource {
    /**
     * Imports a parameter group
     */
    static fromParameterGroupName(scope, id, parameterGroupName) {
        class Import extends core_1.Resource {
            bindToCluster(_options) {
                return { parameterGroupName };
            }
            bindToInstance(_options) {
                return { parameterGroupName };
            }
            addParameter(_key, _value) {
                return false;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_ParameterGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ParameterGroup);
            }
            throw error;
        }
        const family = props.engine.parameterGroupFamily;
        if (!family) {
            throw new Error("ParameterGroup cannot be used with an engine that doesn't specify a version");
        }
        this.family = family;
        this.description = props.description;
        this.parameters = props.parameters ?? {};
    }
    bindToCluster(_options) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_ParameterGroupClusterBindOptions(_options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bindToCluster);
            }
            throw error;
        }
        if (!this.clusterCfnGroup) {
            const id = this.instanceCfnGroup ? 'ClusterParameterGroup' : 'Resource';
            this.clusterCfnGroup = new rds_generated_1.CfnDBClusterParameterGroup(this, id, {
                description: this.description || `Cluster parameter group for ${this.family}`,
                family: this.family,
                parameters: core_1.Lazy.any({ produce: () => this.parameters }),
            });
        }
        return {
            parameterGroupName: this.clusterCfnGroup.ref,
        };
    }
    bindToInstance(_options) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_ParameterGroupInstanceBindOptions(_options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bindToInstance);
            }
            throw error;
        }
        if (!this.instanceCfnGroup) {
            const id = this.clusterCfnGroup ? 'InstanceParameterGroup' : 'Resource';
            this.instanceCfnGroup = new rds_generated_1.CfnDBParameterGroup(this, id, {
                description: this.description || `Parameter group for ${this.family}`,
                family: this.family,
                parameters: core_1.Lazy.any({ produce: () => this.parameters }),
            });
        }
        return {
            parameterGroupName: this.instanceCfnGroup.ref,
        };
    }
    /**
     * Add a parameter to this parameter group
     *
     * @param key The key of the parameter to be added
     * @param value The value of the parameter to be added
     */
    addParameter(key, value) {
        this.parameters[key] = value;
        return true;
    }
}
_a = JSII_RTTI_SYMBOL_1;
ParameterGroup[_a] = { fqn: "aws-cdk-lib.aws_rds.ParameterGroup", version: "2.74.0" };
exports.ParameterGroup = ParameterGroup;
//# sourceMappingURL=data:application/json;base64,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