"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PerformanceInsightRetention = exports.SnapshotCredentials = exports.Credentials = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Username and password combination
 */
class Credentials {
    /**
     * Creates Credentials with a password generated and stored in Secrets Manager.
     */
    static fromGeneratedSecret(username, options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_CredentialsBaseOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromGeneratedSecret);
            }
            throw error;
        }
        return {
            ...options,
            username,
            usernameAsString: true,
        };
    }
    /**
     * Creates Credentials from a password
     *
     * Do not put passwords in your CDK code directly.
     */
    static fromPassword(username, password) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_SecretValue(password);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromPassword);
            }
            throw error;
        }
        return {
            username,
            password,
            usernameAsString: true,
        };
    }
    /**
     * Creates Credentials for the given username, and optional password and key.
     * If no password is provided, one will be generated and stored in Secrets Manager.
     */
    static fromUsername(username, options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_CredentialsFromUsernameOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromUsername);
            }
            throw error;
        }
        return {
            ...options,
            username,
        };
    }
    /**
     * Creates Credentials from an existing Secrets Manager ``Secret`` (or ``DatabaseSecret``)
     *
     * The Secret must be a JSON string with a ``username`` and ``password`` field:
     * ```
     * {
     *   ...
     *   "username": <required: username>,
     *   "password": <required: password>,
     * }
     * ```
     *
     * @param secret The secret where the credentials are stored
     * @param username The username defined in the secret. If specified the username
     *   will be referenced as a string and not a dynamic reference to the username
     *   field in the secret. This allows to replace the secret without replacing the
     *   instance or cluster.
     */
    static fromSecret(secret, username) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_secretsmanager_ISecret(secret);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromSecret);
            }
            throw error;
        }
        return {
            username: username ?? secret.secretValueFromJson('username').unsafeUnwrap(),
            password: secret.secretValueFromJson('password'),
            encryptionKey: secret.encryptionKey,
            secret,
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
Credentials[_a] = { fqn: "aws-cdk-lib.aws_rds.Credentials", version: "2.74.0" };
exports.Credentials = Credentials;
/**
 * Credentials to update the password for a ``DatabaseInstanceFromSnapshot``.
 */
class SnapshotCredentials {
    /**
     * Generate a new password for the snapshot, using the existing username and an optional encryption key.
     * The new credentials are stored in Secrets Manager.
     *
     * Note - The username must match the existing master username of the snapshot.
     */
    static fromGeneratedSecret(username, options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_SnapshotCredentialsFromGeneratedPasswordOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromGeneratedSecret);
            }
            throw error;
        }
        return {
            ...options,
            generatePassword: true,
            replaceOnPasswordCriteriaChanges: true,
            username,
        };
    }
    /**
     * Generate a new password for the snapshot, using the existing username and an optional encryption key.
     *
     * Note - The username must match the existing master username of the snapshot.
     *
     * NOTE: use `fromGeneratedSecret()` for new Clusters and Instances. Switching from
     * `fromGeneratedPassword()` to `fromGeneratedSecret()` for already deployed Clusters
     * or Instances will update their master password.
     */
    static fromGeneratedPassword(username, options = {}) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_SnapshotCredentialsFromGeneratedPasswordOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromGeneratedPassword);
            }
            throw error;
        }
        return {
            ...options,
            generatePassword: true,
            username,
        };
    }
    /**
     * Update the snapshot login with an existing password.
     */
    static fromPassword(password) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_SecretValue(password);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromPassword);
            }
            throw error;
        }
        return { generatePassword: false, password };
    }
    /**
     * Update the snapshot login with an existing password from a Secret.
     *
     * The Secret must be a JSON string with a ``password`` field:
     * ```
     * {
     *   ...
     *   "password": <required: password>,
     * }
     * ```
     */
    static fromSecret(secret) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_secretsmanager_ISecret(secret);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromSecret);
            }
            throw error;
        }
        return {
            generatePassword: false,
            password: secret.secretValueFromJson('password'),
            secret,
        };
    }
}
_b = JSII_RTTI_SYMBOL_1;
SnapshotCredentials[_b] = { fqn: "aws-cdk-lib.aws_rds.SnapshotCredentials", version: "2.74.0" };
exports.SnapshotCredentials = SnapshotCredentials;
/**
 * The retention period for Performance Insight.
 */
var PerformanceInsightRetention;
(function (PerformanceInsightRetention) {
    /**
     * Default retention period of 7 days.
     */
    PerformanceInsightRetention[PerformanceInsightRetention["DEFAULT"] = 7] = "DEFAULT";
    /**
     * Long term retention period of 2 years.
     */
    PerformanceInsightRetention[PerformanceInsightRetention["LONG_TERM"] = 731] = "LONG_TERM";
})(PerformanceInsightRetention = exports.PerformanceInsightRetention || (exports.PerformanceInsightRetention = {}));
//# sourceMappingURL=data:application/json;base64,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