"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnOptionGroup = exports.CfnGlobalCluster = exports.CfnEventSubscription = exports.CfnDBSubnetGroup = exports.CfnDBSecurityGroupIngress = exports.CfnDBSecurityGroup = exports.CfnDBProxyTargetGroup = exports.CfnDBProxyEndpoint = exports.CfnDBProxy = exports.CfnDBParameterGroup = exports.CfnDBInstance = exports.CfnDBClusterParameterGroup = exports.CfnDBCluster = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core");
const cfn_parse = require("../../core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnDBClusterProps`
 *
 * @param properties - the TypeScript properties of a `CfnDBClusterProps`
 *
 * @returns the result of the validation.
 */
function CfnDBClusterPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('allocatedStorage', cdk.validateNumber)(properties.allocatedStorage));
    errors.collect(cdk.propertyValidator('associatedRoles', cdk.listValidator(CfnDBCluster_DBClusterRolePropertyValidator))(properties.associatedRoles));
    errors.collect(cdk.propertyValidator('autoMinorVersionUpgrade', cdk.validateBoolean)(properties.autoMinorVersionUpgrade));
    errors.collect(cdk.propertyValidator('availabilityZones', cdk.listValidator(cdk.validateString))(properties.availabilityZones));
    errors.collect(cdk.propertyValidator('backtrackWindow', cdk.validateNumber)(properties.backtrackWindow));
    errors.collect(cdk.propertyValidator('backupRetentionPeriod', cdk.validateNumber)(properties.backupRetentionPeriod));
    errors.collect(cdk.propertyValidator('copyTagsToSnapshot', cdk.validateBoolean)(properties.copyTagsToSnapshot));
    errors.collect(cdk.propertyValidator('dbClusterIdentifier', cdk.validateString)(properties.dbClusterIdentifier));
    errors.collect(cdk.propertyValidator('dbClusterInstanceClass', cdk.validateString)(properties.dbClusterInstanceClass));
    errors.collect(cdk.propertyValidator('dbClusterParameterGroupName', cdk.validateString)(properties.dbClusterParameterGroupName));
    errors.collect(cdk.propertyValidator('dbInstanceParameterGroupName', cdk.validateString)(properties.dbInstanceParameterGroupName));
    errors.collect(cdk.propertyValidator('dbSubnetGroupName', cdk.validateString)(properties.dbSubnetGroupName));
    errors.collect(cdk.propertyValidator('dbSystemId', cdk.validateString)(properties.dbSystemId));
    errors.collect(cdk.propertyValidator('databaseName', cdk.validateString)(properties.databaseName));
    errors.collect(cdk.propertyValidator('deletionProtection', cdk.validateBoolean)(properties.deletionProtection));
    errors.collect(cdk.propertyValidator('domain', cdk.validateString)(properties.domain));
    errors.collect(cdk.propertyValidator('domainIamRoleName', cdk.validateString)(properties.domainIamRoleName));
    errors.collect(cdk.propertyValidator('enableCloudwatchLogsExports', cdk.listValidator(cdk.validateString))(properties.enableCloudwatchLogsExports));
    errors.collect(cdk.propertyValidator('enableHttpEndpoint', cdk.validateBoolean)(properties.enableHttpEndpoint));
    errors.collect(cdk.propertyValidator('enableIamDatabaseAuthentication', cdk.validateBoolean)(properties.enableIamDatabaseAuthentication));
    errors.collect(cdk.propertyValidator('engine', cdk.validateString)(properties.engine));
    errors.collect(cdk.propertyValidator('engineMode', cdk.validateString)(properties.engineMode));
    errors.collect(cdk.propertyValidator('engineVersion', cdk.validateString)(properties.engineVersion));
    errors.collect(cdk.propertyValidator('globalClusterIdentifier', cdk.validateString)(properties.globalClusterIdentifier));
    errors.collect(cdk.propertyValidator('iops', cdk.validateNumber)(properties.iops));
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    errors.collect(cdk.propertyValidator('manageMasterUserPassword', cdk.validateBoolean)(properties.manageMasterUserPassword));
    errors.collect(cdk.propertyValidator('masterUserPassword', cdk.validateString)(properties.masterUserPassword));
    errors.collect(cdk.propertyValidator('masterUserSecret', CfnDBCluster_MasterUserSecretPropertyValidator)(properties.masterUserSecret));
    errors.collect(cdk.propertyValidator('masterUsername', cdk.validateString)(properties.masterUsername));
    errors.collect(cdk.propertyValidator('monitoringInterval', cdk.validateNumber)(properties.monitoringInterval));
    errors.collect(cdk.propertyValidator('monitoringRoleArn', cdk.validateString)(properties.monitoringRoleArn));
    errors.collect(cdk.propertyValidator('networkType', cdk.validateString)(properties.networkType));
    errors.collect(cdk.propertyValidator('performanceInsightsEnabled', cdk.validateBoolean)(properties.performanceInsightsEnabled));
    errors.collect(cdk.propertyValidator('performanceInsightsKmsKeyId', cdk.validateString)(properties.performanceInsightsKmsKeyId));
    errors.collect(cdk.propertyValidator('performanceInsightsRetentionPeriod', cdk.validateNumber)(properties.performanceInsightsRetentionPeriod));
    errors.collect(cdk.propertyValidator('port', cdk.validateNumber)(properties.port));
    errors.collect(cdk.propertyValidator('preferredBackupWindow', cdk.validateString)(properties.preferredBackupWindow));
    errors.collect(cdk.propertyValidator('preferredMaintenanceWindow', cdk.validateString)(properties.preferredMaintenanceWindow));
    errors.collect(cdk.propertyValidator('publiclyAccessible', cdk.validateBoolean)(properties.publiclyAccessible));
    errors.collect(cdk.propertyValidator('replicationSourceIdentifier', cdk.validateString)(properties.replicationSourceIdentifier));
    errors.collect(cdk.propertyValidator('restoreType', cdk.validateString)(properties.restoreType));
    errors.collect(cdk.propertyValidator('scalingConfiguration', CfnDBCluster_ScalingConfigurationPropertyValidator)(properties.scalingConfiguration));
    errors.collect(cdk.propertyValidator('serverlessV2ScalingConfiguration', CfnDBCluster_ServerlessV2ScalingConfigurationPropertyValidator)(properties.serverlessV2ScalingConfiguration));
    errors.collect(cdk.propertyValidator('snapshotIdentifier', cdk.validateString)(properties.snapshotIdentifier));
    errors.collect(cdk.propertyValidator('sourceDbClusterIdentifier', cdk.validateString)(properties.sourceDbClusterIdentifier));
    errors.collect(cdk.propertyValidator('sourceRegion', cdk.validateString)(properties.sourceRegion));
    errors.collect(cdk.propertyValidator('storageEncrypted', cdk.validateBoolean)(properties.storageEncrypted));
    errors.collect(cdk.propertyValidator('storageType', cdk.validateString)(properties.storageType));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('useLatestRestorableTime', cdk.validateBoolean)(properties.useLatestRestorableTime));
    errors.collect(cdk.propertyValidator('vpcSecurityGroupIds', cdk.listValidator(cdk.validateString))(properties.vpcSecurityGroupIds));
    return errors.wrap('supplied properties not correct for "CfnDBClusterProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBCluster` resource
 *
 * @param properties - the TypeScript properties of a `CfnDBClusterProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBCluster` resource.
 */
// @ts-ignore TS6133
function cfnDBClusterPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBClusterPropsValidator(properties).assertSuccess();
    return {
        AllocatedStorage: cdk.numberToCloudFormation(properties.allocatedStorage),
        AssociatedRoles: cdk.listMapper(cfnDBClusterDBClusterRolePropertyToCloudFormation)(properties.associatedRoles),
        AutoMinorVersionUpgrade: cdk.booleanToCloudFormation(properties.autoMinorVersionUpgrade),
        AvailabilityZones: cdk.listMapper(cdk.stringToCloudFormation)(properties.availabilityZones),
        BacktrackWindow: cdk.numberToCloudFormation(properties.backtrackWindow),
        BackupRetentionPeriod: cdk.numberToCloudFormation(properties.backupRetentionPeriod),
        CopyTagsToSnapshot: cdk.booleanToCloudFormation(properties.copyTagsToSnapshot),
        DatabaseName: cdk.stringToCloudFormation(properties.databaseName),
        DBClusterIdentifier: cdk.stringToCloudFormation(properties.dbClusterIdentifier),
        DBClusterInstanceClass: cdk.stringToCloudFormation(properties.dbClusterInstanceClass),
        DBClusterParameterGroupName: cdk.stringToCloudFormation(properties.dbClusterParameterGroupName),
        DBInstanceParameterGroupName: cdk.stringToCloudFormation(properties.dbInstanceParameterGroupName),
        DBSubnetGroupName: cdk.stringToCloudFormation(properties.dbSubnetGroupName),
        DBSystemId: cdk.stringToCloudFormation(properties.dbSystemId),
        DeletionProtection: cdk.booleanToCloudFormation(properties.deletionProtection),
        Domain: cdk.stringToCloudFormation(properties.domain),
        DomainIAMRoleName: cdk.stringToCloudFormation(properties.domainIamRoleName),
        EnableCloudwatchLogsExports: cdk.listMapper(cdk.stringToCloudFormation)(properties.enableCloudwatchLogsExports),
        EnableHttpEndpoint: cdk.booleanToCloudFormation(properties.enableHttpEndpoint),
        EnableIAMDatabaseAuthentication: cdk.booleanToCloudFormation(properties.enableIamDatabaseAuthentication),
        Engine: cdk.stringToCloudFormation(properties.engine),
        EngineMode: cdk.stringToCloudFormation(properties.engineMode),
        EngineVersion: cdk.stringToCloudFormation(properties.engineVersion),
        GlobalClusterIdentifier: cdk.stringToCloudFormation(properties.globalClusterIdentifier),
        Iops: cdk.numberToCloudFormation(properties.iops),
        KmsKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
        ManageMasterUserPassword: cdk.booleanToCloudFormation(properties.manageMasterUserPassword),
        MasterUsername: cdk.stringToCloudFormation(properties.masterUsername),
        MasterUserPassword: cdk.stringToCloudFormation(properties.masterUserPassword),
        MasterUserSecret: cfnDBClusterMasterUserSecretPropertyToCloudFormation(properties.masterUserSecret),
        MonitoringInterval: cdk.numberToCloudFormation(properties.monitoringInterval),
        MonitoringRoleArn: cdk.stringToCloudFormation(properties.monitoringRoleArn),
        NetworkType: cdk.stringToCloudFormation(properties.networkType),
        PerformanceInsightsEnabled: cdk.booleanToCloudFormation(properties.performanceInsightsEnabled),
        PerformanceInsightsKmsKeyId: cdk.stringToCloudFormation(properties.performanceInsightsKmsKeyId),
        PerformanceInsightsRetentionPeriod: cdk.numberToCloudFormation(properties.performanceInsightsRetentionPeriod),
        Port: cdk.numberToCloudFormation(properties.port),
        PreferredBackupWindow: cdk.stringToCloudFormation(properties.preferredBackupWindow),
        PreferredMaintenanceWindow: cdk.stringToCloudFormation(properties.preferredMaintenanceWindow),
        PubliclyAccessible: cdk.booleanToCloudFormation(properties.publiclyAccessible),
        ReplicationSourceIdentifier: cdk.stringToCloudFormation(properties.replicationSourceIdentifier),
        RestoreType: cdk.stringToCloudFormation(properties.restoreType),
        ScalingConfiguration: cfnDBClusterScalingConfigurationPropertyToCloudFormation(properties.scalingConfiguration),
        ServerlessV2ScalingConfiguration: cfnDBClusterServerlessV2ScalingConfigurationPropertyToCloudFormation(properties.serverlessV2ScalingConfiguration),
        SnapshotIdentifier: cdk.stringToCloudFormation(properties.snapshotIdentifier),
        SourceDBClusterIdentifier: cdk.stringToCloudFormation(properties.sourceDbClusterIdentifier),
        SourceRegion: cdk.stringToCloudFormation(properties.sourceRegion),
        StorageEncrypted: cdk.booleanToCloudFormation(properties.storageEncrypted),
        StorageType: cdk.stringToCloudFormation(properties.storageType),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        UseLatestRestorableTime: cdk.booleanToCloudFormation(properties.useLatestRestorableTime),
        VpcSecurityGroupIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.vpcSecurityGroupIds),
    };
}
// @ts-ignore TS6133
function CfnDBClusterPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('allocatedStorage', 'AllocatedStorage', properties.AllocatedStorage != null ? cfn_parse.FromCloudFormation.getNumber(properties.AllocatedStorage) : undefined);
    ret.addPropertyResult('associatedRoles', 'AssociatedRoles', properties.AssociatedRoles != null ? cfn_parse.FromCloudFormation.getArray(CfnDBClusterDBClusterRolePropertyFromCloudFormation)(properties.AssociatedRoles) : undefined);
    ret.addPropertyResult('autoMinorVersionUpgrade', 'AutoMinorVersionUpgrade', properties.AutoMinorVersionUpgrade != null ? cfn_parse.FromCloudFormation.getBoolean(properties.AutoMinorVersionUpgrade) : undefined);
    ret.addPropertyResult('availabilityZones', 'AvailabilityZones', properties.AvailabilityZones != null ? cfn_parse.FromCloudFormation.getStringArray(properties.AvailabilityZones) : undefined);
    ret.addPropertyResult('backtrackWindow', 'BacktrackWindow', properties.BacktrackWindow != null ? cfn_parse.FromCloudFormation.getNumber(properties.BacktrackWindow) : undefined);
    ret.addPropertyResult('backupRetentionPeriod', 'BackupRetentionPeriod', properties.BackupRetentionPeriod != null ? cfn_parse.FromCloudFormation.getNumber(properties.BackupRetentionPeriod) : undefined);
    ret.addPropertyResult('copyTagsToSnapshot', 'CopyTagsToSnapshot', properties.CopyTagsToSnapshot != null ? cfn_parse.FromCloudFormation.getBoolean(properties.CopyTagsToSnapshot) : undefined);
    ret.addPropertyResult('databaseName', 'DatabaseName', properties.DatabaseName != null ? cfn_parse.FromCloudFormation.getString(properties.DatabaseName) : undefined);
    ret.addPropertyResult('dbClusterIdentifier', 'DBClusterIdentifier', properties.DBClusterIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.DBClusterIdentifier) : undefined);
    ret.addPropertyResult('dbClusterInstanceClass', 'DBClusterInstanceClass', properties.DBClusterInstanceClass != null ? cfn_parse.FromCloudFormation.getString(properties.DBClusterInstanceClass) : undefined);
    ret.addPropertyResult('dbClusterParameterGroupName', 'DBClusterParameterGroupName', properties.DBClusterParameterGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.DBClusterParameterGroupName) : undefined);
    ret.addPropertyResult('dbInstanceParameterGroupName', 'DBInstanceParameterGroupName', properties.DBInstanceParameterGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.DBInstanceParameterGroupName) : undefined);
    ret.addPropertyResult('dbSubnetGroupName', 'DBSubnetGroupName', properties.DBSubnetGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.DBSubnetGroupName) : undefined);
    ret.addPropertyResult('dbSystemId', 'DBSystemId', properties.DBSystemId != null ? cfn_parse.FromCloudFormation.getString(properties.DBSystemId) : undefined);
    ret.addPropertyResult('deletionProtection', 'DeletionProtection', properties.DeletionProtection != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DeletionProtection) : undefined);
    ret.addPropertyResult('domain', 'Domain', properties.Domain != null ? cfn_parse.FromCloudFormation.getString(properties.Domain) : undefined);
    ret.addPropertyResult('domainIamRoleName', 'DomainIAMRoleName', properties.DomainIAMRoleName != null ? cfn_parse.FromCloudFormation.getString(properties.DomainIAMRoleName) : undefined);
    ret.addPropertyResult('enableCloudwatchLogsExports', 'EnableCloudwatchLogsExports', properties.EnableCloudwatchLogsExports != null ? cfn_parse.FromCloudFormation.getStringArray(properties.EnableCloudwatchLogsExports) : undefined);
    ret.addPropertyResult('enableHttpEndpoint', 'EnableHttpEndpoint', properties.EnableHttpEndpoint != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableHttpEndpoint) : undefined);
    ret.addPropertyResult('enableIamDatabaseAuthentication', 'EnableIAMDatabaseAuthentication', properties.EnableIAMDatabaseAuthentication != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableIAMDatabaseAuthentication) : undefined);
    ret.addPropertyResult('engine', 'Engine', properties.Engine != null ? cfn_parse.FromCloudFormation.getString(properties.Engine) : undefined);
    ret.addPropertyResult('engineMode', 'EngineMode', properties.EngineMode != null ? cfn_parse.FromCloudFormation.getString(properties.EngineMode) : undefined);
    ret.addPropertyResult('engineVersion', 'EngineVersion', properties.EngineVersion != null ? cfn_parse.FromCloudFormation.getString(properties.EngineVersion) : undefined);
    ret.addPropertyResult('globalClusterIdentifier', 'GlobalClusterIdentifier', properties.GlobalClusterIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.GlobalClusterIdentifier) : undefined);
    ret.addPropertyResult('iops', 'Iops', properties.Iops != null ? cfn_parse.FromCloudFormation.getNumber(properties.Iops) : undefined);
    ret.addPropertyResult('kmsKeyId', 'KmsKeyId', properties.KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyId) : undefined);
    ret.addPropertyResult('manageMasterUserPassword', 'ManageMasterUserPassword', properties.ManageMasterUserPassword != null ? cfn_parse.FromCloudFormation.getBoolean(properties.ManageMasterUserPassword) : undefined);
    ret.addPropertyResult('masterUsername', 'MasterUsername', properties.MasterUsername != null ? cfn_parse.FromCloudFormation.getString(properties.MasterUsername) : undefined);
    ret.addPropertyResult('masterUserPassword', 'MasterUserPassword', properties.MasterUserPassword != null ? cfn_parse.FromCloudFormation.getString(properties.MasterUserPassword) : undefined);
    ret.addPropertyResult('masterUserSecret', 'MasterUserSecret', properties.MasterUserSecret != null ? CfnDBClusterMasterUserSecretPropertyFromCloudFormation(properties.MasterUserSecret) : undefined);
    ret.addPropertyResult('monitoringInterval', 'MonitoringInterval', properties.MonitoringInterval != null ? cfn_parse.FromCloudFormation.getNumber(properties.MonitoringInterval) : undefined);
    ret.addPropertyResult('monitoringRoleArn', 'MonitoringRoleArn', properties.MonitoringRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.MonitoringRoleArn) : undefined);
    ret.addPropertyResult('networkType', 'NetworkType', properties.NetworkType != null ? cfn_parse.FromCloudFormation.getString(properties.NetworkType) : undefined);
    ret.addPropertyResult('performanceInsightsEnabled', 'PerformanceInsightsEnabled', properties.PerformanceInsightsEnabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.PerformanceInsightsEnabled) : undefined);
    ret.addPropertyResult('performanceInsightsKmsKeyId', 'PerformanceInsightsKmsKeyId', properties.PerformanceInsightsKmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.PerformanceInsightsKmsKeyId) : undefined);
    ret.addPropertyResult('performanceInsightsRetentionPeriod', 'PerformanceInsightsRetentionPeriod', properties.PerformanceInsightsRetentionPeriod != null ? cfn_parse.FromCloudFormation.getNumber(properties.PerformanceInsightsRetentionPeriod) : undefined);
    ret.addPropertyResult('port', 'Port', properties.Port != null ? cfn_parse.FromCloudFormation.getNumber(properties.Port) : undefined);
    ret.addPropertyResult('preferredBackupWindow', 'PreferredBackupWindow', properties.PreferredBackupWindow != null ? cfn_parse.FromCloudFormation.getString(properties.PreferredBackupWindow) : undefined);
    ret.addPropertyResult('preferredMaintenanceWindow', 'PreferredMaintenanceWindow', properties.PreferredMaintenanceWindow != null ? cfn_parse.FromCloudFormation.getString(properties.PreferredMaintenanceWindow) : undefined);
    ret.addPropertyResult('publiclyAccessible', 'PubliclyAccessible', properties.PubliclyAccessible != null ? cfn_parse.FromCloudFormation.getBoolean(properties.PubliclyAccessible) : undefined);
    ret.addPropertyResult('replicationSourceIdentifier', 'ReplicationSourceIdentifier', properties.ReplicationSourceIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.ReplicationSourceIdentifier) : undefined);
    ret.addPropertyResult('restoreType', 'RestoreType', properties.RestoreType != null ? cfn_parse.FromCloudFormation.getString(properties.RestoreType) : undefined);
    ret.addPropertyResult('scalingConfiguration', 'ScalingConfiguration', properties.ScalingConfiguration != null ? CfnDBClusterScalingConfigurationPropertyFromCloudFormation(properties.ScalingConfiguration) : undefined);
    ret.addPropertyResult('serverlessV2ScalingConfiguration', 'ServerlessV2ScalingConfiguration', properties.ServerlessV2ScalingConfiguration != null ? CfnDBClusterServerlessV2ScalingConfigurationPropertyFromCloudFormation(properties.ServerlessV2ScalingConfiguration) : undefined);
    ret.addPropertyResult('snapshotIdentifier', 'SnapshotIdentifier', properties.SnapshotIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.SnapshotIdentifier) : undefined);
    ret.addPropertyResult('sourceDbClusterIdentifier', 'SourceDBClusterIdentifier', properties.SourceDBClusterIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.SourceDBClusterIdentifier) : undefined);
    ret.addPropertyResult('sourceRegion', 'SourceRegion', properties.SourceRegion != null ? cfn_parse.FromCloudFormation.getString(properties.SourceRegion) : undefined);
    ret.addPropertyResult('storageEncrypted', 'StorageEncrypted', properties.StorageEncrypted != null ? cfn_parse.FromCloudFormation.getBoolean(properties.StorageEncrypted) : undefined);
    ret.addPropertyResult('storageType', 'StorageType', properties.StorageType != null ? cfn_parse.FromCloudFormation.getString(properties.StorageType) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('useLatestRestorableTime', 'UseLatestRestorableTime', properties.UseLatestRestorableTime != null ? cfn_parse.FromCloudFormation.getBoolean(properties.UseLatestRestorableTime) : undefined);
    ret.addPropertyResult('vpcSecurityGroupIds', 'VpcSecurityGroupIds', properties.VpcSecurityGroupIds != null ? cfn_parse.FromCloudFormation.getStringArray(properties.VpcSecurityGroupIds) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::DBCluster`
 *
 * The `AWS::RDS::DBCluster` resource creates an Amazon Aurora DB cluster or Multi-AZ DB cluster.
 *
 * For more information about creating an Aurora DB cluster, see [Creating an Amazon Aurora DB cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.CreateInstance.html) in the *Amazon Aurora User Guide* .
 *
 * For more information about creating a Multi-AZ DB cluster, see [Creating a Multi-AZ DB cluster](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/create-multi-az-db-cluster.html) in the *Amazon RDS User Guide* .
 *
 * > You can only create this resource in AWS Regions where Amazon Aurora or Multi-AZ DB clusters are supported.
 *
 * *Updating DB clusters*
 *
 * When properties labeled " *Update requires:* [Replacement](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement) " are updated, AWS CloudFormation first creates a replacement DB cluster, then changes references from other dependent resources to point to the replacement DB cluster, and finally deletes the old DB cluster.
 *
 * > We highly recommend that you take a snapshot of the database before updating the stack. If you don't, you lose the data when AWS CloudFormation replaces your DB cluster. To preserve your data, perform the following procedure:
 * >
 * > - Deactivate any applications that are using the DB cluster so that there's no activity on the DB instance.
 * > - Create a snapshot of the DB cluster. For more information, see [Creating a DB Cluster Snapshot](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CreateSnapshotCluster.html) .
 * > - If you want to restore your DB cluster using a DB cluster snapshot, modify the updated template with your DB cluster changes and add the `SnapshotIdentifier` property with the ID of the DB cluster snapshot that you want to use.
 * >
 * > After you restore a DB cluster with a `SnapshotIdentifier` property, you must specify the same `SnapshotIdentifier` property for any future updates to the DB cluster. When you specify this property for an update, the DB cluster is not restored from the DB cluster snapshot again, and the data in the database is not changed. However, if you don't specify the `SnapshotIdentifier` property, an empty DB cluster is created, and the original DB cluster is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB cluster is restored from the specified `SnapshotIdentifier` property, and the original DB cluster is deleted.
 * > - Update the stack.
 *
 * Currently, when you are updating the stack for an Aurora Serverless DB cluster, you can't include changes to any other properties when you specify one of the following properties: `PreferredBackupWindow` , `PreferredMaintenanceWindow` , and `Port` . This limitation doesn't apply to provisioned DB clusters.
 *
 * For more information about updating other properties of this resource, see `[ModifyDBCluster](https://docs.aws.amazon.com//AmazonRDS/latest/APIReference/API_ModifyDBCluster.html)` . For more information about updating stacks, see [AWS CloudFormation Stacks Updates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html) .
 *
 * *Deleting DB clusters*
 *
 * The default `DeletionPolicy` for `AWS::RDS::DBCluster` resources is `Snapshot` . For more information about how AWS CloudFormation deletes resources, see [DeletionPolicy Attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html) .
 *
 * @cloudformationResource AWS::RDS::DBCluster
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html
 */
class CfnDBCluster extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDBClusterPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDBCluster(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::RDS::DBCluster`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnDBCluster.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_CfnDBClusterProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnDBCluster);
            }
            throw error;
        }
        this.attrDbClusterArn = cdk.Token.asString(this.getAtt('DBClusterArn', cdk.ResolutionTypeHint.STRING));
        this.attrDbClusterResourceId = cdk.Token.asString(this.getAtt('DBClusterResourceId', cdk.ResolutionTypeHint.STRING));
        this.attrEndpointAddress = cdk.Token.asString(this.getAtt('Endpoint.Address', cdk.ResolutionTypeHint.STRING));
        this.attrEndpointPort = cdk.Token.asString(this.getAtt('Endpoint.Port', cdk.ResolutionTypeHint.STRING));
        this.attrMasterUserSecretSecretArn = cdk.Token.asString(this.getAtt('MasterUserSecret.SecretArn', cdk.ResolutionTypeHint.STRING));
        this.attrReadEndpointAddress = cdk.Token.asString(this.getAtt('ReadEndpoint.Address', cdk.ResolutionTypeHint.STRING));
        this.allocatedStorage = props.allocatedStorage;
        this.associatedRoles = props.associatedRoles;
        this.autoMinorVersionUpgrade = props.autoMinorVersionUpgrade;
        this.availabilityZones = props.availabilityZones;
        this.backtrackWindow = props.backtrackWindow;
        this.backupRetentionPeriod = props.backupRetentionPeriod;
        this.copyTagsToSnapshot = props.copyTagsToSnapshot;
        this.databaseName = props.databaseName;
        this.dbClusterIdentifier = props.dbClusterIdentifier;
        this.dbClusterInstanceClass = props.dbClusterInstanceClass;
        this.dbClusterParameterGroupName = props.dbClusterParameterGroupName;
        this.dbInstanceParameterGroupName = props.dbInstanceParameterGroupName;
        this.dbSubnetGroupName = props.dbSubnetGroupName;
        this.dbSystemId = props.dbSystemId;
        this.deletionProtection = props.deletionProtection;
        this.domain = props.domain;
        this.domainIamRoleName = props.domainIamRoleName;
        this.enableCloudwatchLogsExports = props.enableCloudwatchLogsExports;
        this.enableHttpEndpoint = props.enableHttpEndpoint;
        this.enableIamDatabaseAuthentication = props.enableIamDatabaseAuthentication;
        this.engine = props.engine;
        this.engineMode = props.engineMode;
        this.engineVersion = props.engineVersion;
        this.globalClusterIdentifier = props.globalClusterIdentifier;
        this.iops = props.iops;
        this.kmsKeyId = props.kmsKeyId;
        this.manageMasterUserPassword = props.manageMasterUserPassword;
        this.masterUsername = props.masterUsername;
        this.masterUserPassword = props.masterUserPassword;
        this.masterUserSecret = props.masterUserSecret;
        this.monitoringInterval = props.monitoringInterval;
        this.monitoringRoleArn = props.monitoringRoleArn;
        this.networkType = props.networkType;
        this.performanceInsightsEnabled = props.performanceInsightsEnabled;
        this.performanceInsightsKmsKeyId = props.performanceInsightsKmsKeyId;
        this.performanceInsightsRetentionPeriod = props.performanceInsightsRetentionPeriod;
        this.port = props.port;
        this.preferredBackupWindow = props.preferredBackupWindow;
        this.preferredMaintenanceWindow = props.preferredMaintenanceWindow;
        this.publiclyAccessible = props.publiclyAccessible;
        this.replicationSourceIdentifier = props.replicationSourceIdentifier;
        this.restoreType = props.restoreType;
        this.scalingConfiguration = props.scalingConfiguration;
        this.serverlessV2ScalingConfiguration = props.serverlessV2ScalingConfiguration;
        this.snapshotIdentifier = props.snapshotIdentifier;
        this.sourceDbClusterIdentifier = props.sourceDbClusterIdentifier;
        this.sourceRegion = props.sourceRegion;
        this.storageEncrypted = props.storageEncrypted;
        this.storageType = props.storageType;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::RDS::DBCluster", props.tags, { tagPropertyName: 'tags' });
        this.useLatestRestorableTime = props.useLatestRestorableTime;
        this.vpcSecurityGroupIds = props.vpcSecurityGroupIds;
        if (this.node.scope && cdk.Resource.isResource(this.node.scope)) {
            this.node.addValidation({ validate: () => this.cfnOptions.deletionPolicy === undefined
                    ? ['\'AWS::RDS::DBCluster\' is a stateful resource type, and you must specify a Removal Policy for it. Call \'resource.applyRemovalPolicy()\'.']
                    : [] });
        }
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDBCluster.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            allocatedStorage: this.allocatedStorage,
            associatedRoles: this.associatedRoles,
            autoMinorVersionUpgrade: this.autoMinorVersionUpgrade,
            availabilityZones: this.availabilityZones,
            backtrackWindow: this.backtrackWindow,
            backupRetentionPeriod: this.backupRetentionPeriod,
            copyTagsToSnapshot: this.copyTagsToSnapshot,
            databaseName: this.databaseName,
            dbClusterIdentifier: this.dbClusterIdentifier,
            dbClusterInstanceClass: this.dbClusterInstanceClass,
            dbClusterParameterGroupName: this.dbClusterParameterGroupName,
            dbInstanceParameterGroupName: this.dbInstanceParameterGroupName,
            dbSubnetGroupName: this.dbSubnetGroupName,
            dbSystemId: this.dbSystemId,
            deletionProtection: this.deletionProtection,
            domain: this.domain,
            domainIamRoleName: this.domainIamRoleName,
            enableCloudwatchLogsExports: this.enableCloudwatchLogsExports,
            enableHttpEndpoint: this.enableHttpEndpoint,
            enableIamDatabaseAuthentication: this.enableIamDatabaseAuthentication,
            engine: this.engine,
            engineMode: this.engineMode,
            engineVersion: this.engineVersion,
            globalClusterIdentifier: this.globalClusterIdentifier,
            iops: this.iops,
            kmsKeyId: this.kmsKeyId,
            manageMasterUserPassword: this.manageMasterUserPassword,
            masterUsername: this.masterUsername,
            masterUserPassword: this.masterUserPassword,
            masterUserSecret: this.masterUserSecret,
            monitoringInterval: this.monitoringInterval,
            monitoringRoleArn: this.monitoringRoleArn,
            networkType: this.networkType,
            performanceInsightsEnabled: this.performanceInsightsEnabled,
            performanceInsightsKmsKeyId: this.performanceInsightsKmsKeyId,
            performanceInsightsRetentionPeriod: this.performanceInsightsRetentionPeriod,
            port: this.port,
            preferredBackupWindow: this.preferredBackupWindow,
            preferredMaintenanceWindow: this.preferredMaintenanceWindow,
            publiclyAccessible: this.publiclyAccessible,
            replicationSourceIdentifier: this.replicationSourceIdentifier,
            restoreType: this.restoreType,
            scalingConfiguration: this.scalingConfiguration,
            serverlessV2ScalingConfiguration: this.serverlessV2ScalingConfiguration,
            snapshotIdentifier: this.snapshotIdentifier,
            sourceDbClusterIdentifier: this.sourceDbClusterIdentifier,
            sourceRegion: this.sourceRegion,
            storageEncrypted: this.storageEncrypted,
            storageType: this.storageType,
            tags: this.tags.renderTags(),
            useLatestRestorableTime: this.useLatestRestorableTime,
            vpcSecurityGroupIds: this.vpcSecurityGroupIds,
        };
    }
    renderProperties(props) {
        return cfnDBClusterPropsToCloudFormation(props);
    }
}
_a = JSII_RTTI_SYMBOL_1;
CfnDBCluster[_a] = { fqn: "aws-cdk-lib.aws_rds.CfnDBCluster", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDBCluster.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBCluster";
exports.CfnDBCluster = CfnDBCluster;
/**
 * Determine whether the given properties match those of a `DBClusterRoleProperty`
 *
 * @param properties - the TypeScript properties of a `DBClusterRoleProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBCluster_DBClusterRolePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('featureName', cdk.validateString)(properties.featureName));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    return errors.wrap('supplied properties not correct for "DBClusterRoleProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBCluster.DBClusterRole` resource
 *
 * @param properties - the TypeScript properties of a `DBClusterRoleProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBCluster.DBClusterRole` resource.
 */
// @ts-ignore TS6133
function cfnDBClusterDBClusterRolePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBCluster_DBClusterRolePropertyValidator(properties).assertSuccess();
    return {
        FeatureName: cdk.stringToCloudFormation(properties.featureName),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
    };
}
// @ts-ignore TS6133
function CfnDBClusterDBClusterRolePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('featureName', 'FeatureName', properties.FeatureName != null ? cfn_parse.FromCloudFormation.getString(properties.FeatureName) : undefined);
    ret.addPropertyResult('roleArn', 'RoleArn', cfn_parse.FromCloudFormation.getString(properties.RoleArn));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `EndpointProperty`
 *
 * @param properties - the TypeScript properties of a `EndpointProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBCluster_EndpointPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('address', cdk.validateString)(properties.address));
    errors.collect(cdk.propertyValidator('port', cdk.validateString)(properties.port));
    return errors.wrap('supplied properties not correct for "EndpointProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBCluster.Endpoint` resource
 *
 * @param properties - the TypeScript properties of a `EndpointProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBCluster.Endpoint` resource.
 */
// @ts-ignore TS6133
function cfnDBClusterEndpointPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBCluster_EndpointPropertyValidator(properties).assertSuccess();
    return {
        Address: cdk.stringToCloudFormation(properties.address),
        Port: cdk.stringToCloudFormation(properties.port),
    };
}
// @ts-ignore TS6133
function CfnDBClusterEndpointPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('address', 'Address', properties.Address != null ? cfn_parse.FromCloudFormation.getString(properties.Address) : undefined);
    ret.addPropertyResult('port', 'Port', properties.Port != null ? cfn_parse.FromCloudFormation.getString(properties.Port) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MasterUserSecretProperty`
 *
 * @param properties - the TypeScript properties of a `MasterUserSecretProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBCluster_MasterUserSecretPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    errors.collect(cdk.propertyValidator('secretArn', cdk.validateString)(properties.secretArn));
    return errors.wrap('supplied properties not correct for "MasterUserSecretProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBCluster.MasterUserSecret` resource
 *
 * @param properties - the TypeScript properties of a `MasterUserSecretProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBCluster.MasterUserSecret` resource.
 */
// @ts-ignore TS6133
function cfnDBClusterMasterUserSecretPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBCluster_MasterUserSecretPropertyValidator(properties).assertSuccess();
    return {
        KmsKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
        SecretArn: cdk.stringToCloudFormation(properties.secretArn),
    };
}
// @ts-ignore TS6133
function CfnDBClusterMasterUserSecretPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('kmsKeyId', 'KmsKeyId', properties.KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyId) : undefined);
    ret.addPropertyResult('secretArn', 'SecretArn', properties.SecretArn != null ? cfn_parse.FromCloudFormation.getString(properties.SecretArn) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ReadEndpointProperty`
 *
 * @param properties - the TypeScript properties of a `ReadEndpointProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBCluster_ReadEndpointPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('address', cdk.validateString)(properties.address));
    return errors.wrap('supplied properties not correct for "ReadEndpointProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBCluster.ReadEndpoint` resource
 *
 * @param properties - the TypeScript properties of a `ReadEndpointProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBCluster.ReadEndpoint` resource.
 */
// @ts-ignore TS6133
function cfnDBClusterReadEndpointPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBCluster_ReadEndpointPropertyValidator(properties).assertSuccess();
    return {
        Address: cdk.stringToCloudFormation(properties.address),
    };
}
// @ts-ignore TS6133
function CfnDBClusterReadEndpointPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('address', 'Address', properties.Address != null ? cfn_parse.FromCloudFormation.getString(properties.Address) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ScalingConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `ScalingConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBCluster_ScalingConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('autoPause', cdk.validateBoolean)(properties.autoPause));
    errors.collect(cdk.propertyValidator('maxCapacity', cdk.validateNumber)(properties.maxCapacity));
    errors.collect(cdk.propertyValidator('minCapacity', cdk.validateNumber)(properties.minCapacity));
    errors.collect(cdk.propertyValidator('secondsBeforeTimeout', cdk.validateNumber)(properties.secondsBeforeTimeout));
    errors.collect(cdk.propertyValidator('secondsUntilAutoPause', cdk.validateNumber)(properties.secondsUntilAutoPause));
    errors.collect(cdk.propertyValidator('timeoutAction', cdk.validateString)(properties.timeoutAction));
    return errors.wrap('supplied properties not correct for "ScalingConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBCluster.ScalingConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `ScalingConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBCluster.ScalingConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnDBClusterScalingConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBCluster_ScalingConfigurationPropertyValidator(properties).assertSuccess();
    return {
        AutoPause: cdk.booleanToCloudFormation(properties.autoPause),
        MaxCapacity: cdk.numberToCloudFormation(properties.maxCapacity),
        MinCapacity: cdk.numberToCloudFormation(properties.minCapacity),
        SecondsBeforeTimeout: cdk.numberToCloudFormation(properties.secondsBeforeTimeout),
        SecondsUntilAutoPause: cdk.numberToCloudFormation(properties.secondsUntilAutoPause),
        TimeoutAction: cdk.stringToCloudFormation(properties.timeoutAction),
    };
}
// @ts-ignore TS6133
function CfnDBClusterScalingConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('autoPause', 'AutoPause', properties.AutoPause != null ? cfn_parse.FromCloudFormation.getBoolean(properties.AutoPause) : undefined);
    ret.addPropertyResult('maxCapacity', 'MaxCapacity', properties.MaxCapacity != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxCapacity) : undefined);
    ret.addPropertyResult('minCapacity', 'MinCapacity', properties.MinCapacity != null ? cfn_parse.FromCloudFormation.getNumber(properties.MinCapacity) : undefined);
    ret.addPropertyResult('secondsBeforeTimeout', 'SecondsBeforeTimeout', properties.SecondsBeforeTimeout != null ? cfn_parse.FromCloudFormation.getNumber(properties.SecondsBeforeTimeout) : undefined);
    ret.addPropertyResult('secondsUntilAutoPause', 'SecondsUntilAutoPause', properties.SecondsUntilAutoPause != null ? cfn_parse.FromCloudFormation.getNumber(properties.SecondsUntilAutoPause) : undefined);
    ret.addPropertyResult('timeoutAction', 'TimeoutAction', properties.TimeoutAction != null ? cfn_parse.FromCloudFormation.getString(properties.TimeoutAction) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ServerlessV2ScalingConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `ServerlessV2ScalingConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBCluster_ServerlessV2ScalingConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('maxCapacity', cdk.validateNumber)(properties.maxCapacity));
    errors.collect(cdk.propertyValidator('minCapacity', cdk.validateNumber)(properties.minCapacity));
    return errors.wrap('supplied properties not correct for "ServerlessV2ScalingConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBCluster.ServerlessV2ScalingConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `ServerlessV2ScalingConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBCluster.ServerlessV2ScalingConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnDBClusterServerlessV2ScalingConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBCluster_ServerlessV2ScalingConfigurationPropertyValidator(properties).assertSuccess();
    return {
        MaxCapacity: cdk.numberToCloudFormation(properties.maxCapacity),
        MinCapacity: cdk.numberToCloudFormation(properties.minCapacity),
    };
}
// @ts-ignore TS6133
function CfnDBClusterServerlessV2ScalingConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('maxCapacity', 'MaxCapacity', properties.MaxCapacity != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxCapacity) : undefined);
    ret.addPropertyResult('minCapacity', 'MinCapacity', properties.MinCapacity != null ? cfn_parse.FromCloudFormation.getNumber(properties.MinCapacity) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnDBClusterParameterGroupProps`
 *
 * @param properties - the TypeScript properties of a `CfnDBClusterParameterGroupProps`
 *
 * @returns the result of the validation.
 */
function CfnDBClusterParameterGroupPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dbClusterParameterGroupName', cdk.validateString)(properties.dbClusterParameterGroupName));
    errors.collect(cdk.propertyValidator('description', cdk.requiredValidator)(properties.description));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('family', cdk.requiredValidator)(properties.family));
    errors.collect(cdk.propertyValidator('family', cdk.validateString)(properties.family));
    errors.collect(cdk.propertyValidator('parameters', cdk.requiredValidator)(properties.parameters));
    errors.collect(cdk.propertyValidator('parameters', cdk.validateObject)(properties.parameters));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnDBClusterParameterGroupProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBClusterParameterGroup` resource
 *
 * @param properties - the TypeScript properties of a `CfnDBClusterParameterGroupProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBClusterParameterGroup` resource.
 */
// @ts-ignore TS6133
function cfnDBClusterParameterGroupPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBClusterParameterGroupPropsValidator(properties).assertSuccess();
    return {
        Description: cdk.stringToCloudFormation(properties.description),
        Family: cdk.stringToCloudFormation(properties.family),
        Parameters: cdk.objectToCloudFormation(properties.parameters),
        DBClusterParameterGroupName: cdk.stringToCloudFormation(properties.dbClusterParameterGroupName),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnDBClusterParameterGroupPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('description', 'Description', cfn_parse.FromCloudFormation.getString(properties.Description));
    ret.addPropertyResult('family', 'Family', cfn_parse.FromCloudFormation.getString(properties.Family));
    ret.addPropertyResult('parameters', 'Parameters', cfn_parse.FromCloudFormation.getAny(properties.Parameters));
    ret.addPropertyResult('dbClusterParameterGroupName', 'DBClusterParameterGroupName', properties.DBClusterParameterGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.DBClusterParameterGroupName) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::DBClusterParameterGroup`
 *
 * The `AWS::RDS::DBClusterParameterGroup` resource creates a new Amazon RDS DB cluster parameter group.
 *
 * For information about configuring parameters for Amazon Aurora DB clusters, see [Working with parameter groups](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_WorkingWithParamGroups.html) in the *Amazon Aurora User Guide* .
 *
 * > If you apply a parameter group to a DB cluster, then its DB instances might need to reboot. This can result in an outage while the DB instances are rebooting.
 * >
 * > If you apply a change to parameter group associated with a stopped DB cluster, then the update stack waits until the DB cluster is started.
 *
 * @cloudformationResource AWS::RDS::DBClusterParameterGroup
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbclusterparametergroup.html
 */
class CfnDBClusterParameterGroup extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDBClusterParameterGroupPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDBClusterParameterGroup(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::RDS::DBClusterParameterGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDBClusterParameterGroup.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_CfnDBClusterParameterGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnDBClusterParameterGroup);
            }
            throw error;
        }
        cdk.requireProperty(props, 'description', this);
        cdk.requireProperty(props, 'family', this);
        cdk.requireProperty(props, 'parameters', this);
        this.description = props.description;
        this.family = props.family;
        this.parameters = props.parameters;
        this.dbClusterParameterGroupName = props.dbClusterParameterGroupName;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::RDS::DBClusterParameterGroup", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDBClusterParameterGroup.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            description: this.description,
            family: this.family,
            parameters: this.parameters,
            dbClusterParameterGroupName: this.dbClusterParameterGroupName,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnDBClusterParameterGroupPropsToCloudFormation(props);
    }
}
_b = JSII_RTTI_SYMBOL_1;
CfnDBClusterParameterGroup[_b] = { fqn: "aws-cdk-lib.aws_rds.CfnDBClusterParameterGroup", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDBClusterParameterGroup.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBClusterParameterGroup";
exports.CfnDBClusterParameterGroup = CfnDBClusterParameterGroup;
/**
 * Determine whether the given properties match those of a `CfnDBInstanceProps`
 *
 * @param properties - the TypeScript properties of a `CfnDBInstanceProps`
 *
 * @returns the result of the validation.
 */
function CfnDBInstancePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('allocatedStorage', cdk.validateString)(properties.allocatedStorage));
    errors.collect(cdk.propertyValidator('allowMajorVersionUpgrade', cdk.validateBoolean)(properties.allowMajorVersionUpgrade));
    errors.collect(cdk.propertyValidator('associatedRoles', cdk.listValidator(CfnDBInstance_DBInstanceRolePropertyValidator))(properties.associatedRoles));
    errors.collect(cdk.propertyValidator('autoMinorVersionUpgrade', cdk.validateBoolean)(properties.autoMinorVersionUpgrade));
    errors.collect(cdk.propertyValidator('availabilityZone', cdk.validateString)(properties.availabilityZone));
    errors.collect(cdk.propertyValidator('backupRetentionPeriod', cdk.validateNumber)(properties.backupRetentionPeriod));
    errors.collect(cdk.propertyValidator('caCertificateIdentifier', cdk.validateString)(properties.caCertificateIdentifier));
    errors.collect(cdk.propertyValidator('certificateDetails', CfnDBInstance_CertificateDetailsPropertyValidator)(properties.certificateDetails));
    errors.collect(cdk.propertyValidator('certificateRotationRestart', cdk.validateBoolean)(properties.certificateRotationRestart));
    errors.collect(cdk.propertyValidator('characterSetName', cdk.validateString)(properties.characterSetName));
    errors.collect(cdk.propertyValidator('copyTagsToSnapshot', cdk.validateBoolean)(properties.copyTagsToSnapshot));
    errors.collect(cdk.propertyValidator('customIamInstanceProfile', cdk.validateString)(properties.customIamInstanceProfile));
    errors.collect(cdk.propertyValidator('dbClusterIdentifier', cdk.validateString)(properties.dbClusterIdentifier));
    errors.collect(cdk.propertyValidator('dbClusterSnapshotIdentifier', cdk.validateString)(properties.dbClusterSnapshotIdentifier));
    errors.collect(cdk.propertyValidator('dbInstanceClass', cdk.validateString)(properties.dbInstanceClass));
    errors.collect(cdk.propertyValidator('dbInstanceIdentifier', cdk.validateString)(properties.dbInstanceIdentifier));
    errors.collect(cdk.propertyValidator('dbName', cdk.validateString)(properties.dbName));
    errors.collect(cdk.propertyValidator('dbParameterGroupName', cdk.validateString)(properties.dbParameterGroupName));
    errors.collect(cdk.propertyValidator('dbSecurityGroups', cdk.listValidator(cdk.validateString))(properties.dbSecurityGroups));
    errors.collect(cdk.propertyValidator('dbSnapshotIdentifier', cdk.validateString)(properties.dbSnapshotIdentifier));
    errors.collect(cdk.propertyValidator('dbSubnetGroupName', cdk.validateString)(properties.dbSubnetGroupName));
    errors.collect(cdk.propertyValidator('deleteAutomatedBackups', cdk.validateBoolean)(properties.deleteAutomatedBackups));
    errors.collect(cdk.propertyValidator('deletionProtection', cdk.validateBoolean)(properties.deletionProtection));
    errors.collect(cdk.propertyValidator('domain', cdk.validateString)(properties.domain));
    errors.collect(cdk.propertyValidator('domainIamRoleName', cdk.validateString)(properties.domainIamRoleName));
    errors.collect(cdk.propertyValidator('enableCloudwatchLogsExports', cdk.listValidator(cdk.validateString))(properties.enableCloudwatchLogsExports));
    errors.collect(cdk.propertyValidator('enableIamDatabaseAuthentication', cdk.validateBoolean)(properties.enableIamDatabaseAuthentication));
    errors.collect(cdk.propertyValidator('enablePerformanceInsights', cdk.validateBoolean)(properties.enablePerformanceInsights));
    errors.collect(cdk.propertyValidator('endpoint', CfnDBInstance_EndpointPropertyValidator)(properties.endpoint));
    errors.collect(cdk.propertyValidator('engine', cdk.validateString)(properties.engine));
    errors.collect(cdk.propertyValidator('engineVersion', cdk.validateString)(properties.engineVersion));
    errors.collect(cdk.propertyValidator('iops', cdk.validateNumber)(properties.iops));
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    errors.collect(cdk.propertyValidator('licenseModel', cdk.validateString)(properties.licenseModel));
    errors.collect(cdk.propertyValidator('manageMasterUserPassword', cdk.validateBoolean)(properties.manageMasterUserPassword));
    errors.collect(cdk.propertyValidator('masterUserPassword', cdk.validateString)(properties.masterUserPassword));
    errors.collect(cdk.propertyValidator('masterUserSecret', CfnDBInstance_MasterUserSecretPropertyValidator)(properties.masterUserSecret));
    errors.collect(cdk.propertyValidator('masterUsername', cdk.validateString)(properties.masterUsername));
    errors.collect(cdk.propertyValidator('maxAllocatedStorage', cdk.validateNumber)(properties.maxAllocatedStorage));
    errors.collect(cdk.propertyValidator('monitoringInterval', cdk.validateNumber)(properties.monitoringInterval));
    errors.collect(cdk.propertyValidator('monitoringRoleArn', cdk.validateString)(properties.monitoringRoleArn));
    errors.collect(cdk.propertyValidator('multiAz', cdk.validateBoolean)(properties.multiAz));
    errors.collect(cdk.propertyValidator('ncharCharacterSetName', cdk.validateString)(properties.ncharCharacterSetName));
    errors.collect(cdk.propertyValidator('networkType', cdk.validateString)(properties.networkType));
    errors.collect(cdk.propertyValidator('optionGroupName', cdk.validateString)(properties.optionGroupName));
    errors.collect(cdk.propertyValidator('performanceInsightsKmsKeyId', cdk.validateString)(properties.performanceInsightsKmsKeyId));
    errors.collect(cdk.propertyValidator('performanceInsightsRetentionPeriod', cdk.validateNumber)(properties.performanceInsightsRetentionPeriod));
    errors.collect(cdk.propertyValidator('port', cdk.validateString)(properties.port));
    errors.collect(cdk.propertyValidator('preferredBackupWindow', cdk.validateString)(properties.preferredBackupWindow));
    errors.collect(cdk.propertyValidator('preferredMaintenanceWindow', cdk.validateString)(properties.preferredMaintenanceWindow));
    errors.collect(cdk.propertyValidator('processorFeatures', cdk.listValidator(CfnDBInstance_ProcessorFeaturePropertyValidator))(properties.processorFeatures));
    errors.collect(cdk.propertyValidator('promotionTier', cdk.validateNumber)(properties.promotionTier));
    errors.collect(cdk.propertyValidator('publiclyAccessible', cdk.validateBoolean)(properties.publiclyAccessible));
    errors.collect(cdk.propertyValidator('replicaMode', cdk.validateString)(properties.replicaMode));
    errors.collect(cdk.propertyValidator('restoreTime', cdk.validateString)(properties.restoreTime));
    errors.collect(cdk.propertyValidator('sourceDbInstanceAutomatedBackupsArn', cdk.validateString)(properties.sourceDbInstanceAutomatedBackupsArn));
    errors.collect(cdk.propertyValidator('sourceDbInstanceIdentifier', cdk.validateString)(properties.sourceDbInstanceIdentifier));
    errors.collect(cdk.propertyValidator('sourceDbiResourceId', cdk.validateString)(properties.sourceDbiResourceId));
    errors.collect(cdk.propertyValidator('sourceRegion', cdk.validateString)(properties.sourceRegion));
    errors.collect(cdk.propertyValidator('storageEncrypted', cdk.validateBoolean)(properties.storageEncrypted));
    errors.collect(cdk.propertyValidator('storageThroughput', cdk.validateNumber)(properties.storageThroughput));
    errors.collect(cdk.propertyValidator('storageType', cdk.validateString)(properties.storageType));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('timezone', cdk.validateString)(properties.timezone));
    errors.collect(cdk.propertyValidator('useDefaultProcessorFeatures', cdk.validateBoolean)(properties.useDefaultProcessorFeatures));
    errors.collect(cdk.propertyValidator('useLatestRestorableTime', cdk.validateBoolean)(properties.useLatestRestorableTime));
    errors.collect(cdk.propertyValidator('vpcSecurityGroups', cdk.listValidator(cdk.validateString))(properties.vpcSecurityGroups));
    return errors.wrap('supplied properties not correct for "CfnDBInstanceProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBInstance` resource
 *
 * @param properties - the TypeScript properties of a `CfnDBInstanceProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBInstance` resource.
 */
// @ts-ignore TS6133
function cfnDBInstancePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBInstancePropsValidator(properties).assertSuccess();
    return {
        AllocatedStorage: cdk.stringToCloudFormation(properties.allocatedStorage),
        AllowMajorVersionUpgrade: cdk.booleanToCloudFormation(properties.allowMajorVersionUpgrade),
        AssociatedRoles: cdk.listMapper(cfnDBInstanceDBInstanceRolePropertyToCloudFormation)(properties.associatedRoles),
        AutoMinorVersionUpgrade: cdk.booleanToCloudFormation(properties.autoMinorVersionUpgrade),
        AvailabilityZone: cdk.stringToCloudFormation(properties.availabilityZone),
        BackupRetentionPeriod: cdk.numberToCloudFormation(properties.backupRetentionPeriod),
        CACertificateIdentifier: cdk.stringToCloudFormation(properties.caCertificateIdentifier),
        CertificateDetails: cfnDBInstanceCertificateDetailsPropertyToCloudFormation(properties.certificateDetails),
        CertificateRotationRestart: cdk.booleanToCloudFormation(properties.certificateRotationRestart),
        CharacterSetName: cdk.stringToCloudFormation(properties.characterSetName),
        CopyTagsToSnapshot: cdk.booleanToCloudFormation(properties.copyTagsToSnapshot),
        CustomIAMInstanceProfile: cdk.stringToCloudFormation(properties.customIamInstanceProfile),
        DBClusterIdentifier: cdk.stringToCloudFormation(properties.dbClusterIdentifier),
        DBClusterSnapshotIdentifier: cdk.stringToCloudFormation(properties.dbClusterSnapshotIdentifier),
        DBInstanceClass: cdk.stringToCloudFormation(properties.dbInstanceClass),
        DBInstanceIdentifier: cdk.stringToCloudFormation(properties.dbInstanceIdentifier),
        DBName: cdk.stringToCloudFormation(properties.dbName),
        DBParameterGroupName: cdk.stringToCloudFormation(properties.dbParameterGroupName),
        DBSecurityGroups: cdk.listMapper(cdk.stringToCloudFormation)(properties.dbSecurityGroups),
        DBSnapshotIdentifier: cdk.stringToCloudFormation(properties.dbSnapshotIdentifier),
        DBSubnetGroupName: cdk.stringToCloudFormation(properties.dbSubnetGroupName),
        DeleteAutomatedBackups: cdk.booleanToCloudFormation(properties.deleteAutomatedBackups),
        DeletionProtection: cdk.booleanToCloudFormation(properties.deletionProtection),
        Domain: cdk.stringToCloudFormation(properties.domain),
        DomainIAMRoleName: cdk.stringToCloudFormation(properties.domainIamRoleName),
        EnableCloudwatchLogsExports: cdk.listMapper(cdk.stringToCloudFormation)(properties.enableCloudwatchLogsExports),
        EnableIAMDatabaseAuthentication: cdk.booleanToCloudFormation(properties.enableIamDatabaseAuthentication),
        EnablePerformanceInsights: cdk.booleanToCloudFormation(properties.enablePerformanceInsights),
        Endpoint: cfnDBInstanceEndpointPropertyToCloudFormation(properties.endpoint),
        Engine: cdk.stringToCloudFormation(properties.engine),
        EngineVersion: cdk.stringToCloudFormation(properties.engineVersion),
        Iops: cdk.numberToCloudFormation(properties.iops),
        KmsKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
        LicenseModel: cdk.stringToCloudFormation(properties.licenseModel),
        ManageMasterUserPassword: cdk.booleanToCloudFormation(properties.manageMasterUserPassword),
        MasterUsername: cdk.stringToCloudFormation(properties.masterUsername),
        MasterUserPassword: cdk.stringToCloudFormation(properties.masterUserPassword),
        MasterUserSecret: cfnDBInstanceMasterUserSecretPropertyToCloudFormation(properties.masterUserSecret),
        MaxAllocatedStorage: cdk.numberToCloudFormation(properties.maxAllocatedStorage),
        MonitoringInterval: cdk.numberToCloudFormation(properties.monitoringInterval),
        MonitoringRoleArn: cdk.stringToCloudFormation(properties.monitoringRoleArn),
        MultiAZ: cdk.booleanToCloudFormation(properties.multiAz),
        NcharCharacterSetName: cdk.stringToCloudFormation(properties.ncharCharacterSetName),
        NetworkType: cdk.stringToCloudFormation(properties.networkType),
        OptionGroupName: cdk.stringToCloudFormation(properties.optionGroupName),
        PerformanceInsightsKMSKeyId: cdk.stringToCloudFormation(properties.performanceInsightsKmsKeyId),
        PerformanceInsightsRetentionPeriod: cdk.numberToCloudFormation(properties.performanceInsightsRetentionPeriod),
        Port: cdk.stringToCloudFormation(properties.port),
        PreferredBackupWindow: cdk.stringToCloudFormation(properties.preferredBackupWindow),
        PreferredMaintenanceWindow: cdk.stringToCloudFormation(properties.preferredMaintenanceWindow),
        ProcessorFeatures: cdk.listMapper(cfnDBInstanceProcessorFeaturePropertyToCloudFormation)(properties.processorFeatures),
        PromotionTier: cdk.numberToCloudFormation(properties.promotionTier),
        PubliclyAccessible: cdk.booleanToCloudFormation(properties.publiclyAccessible),
        ReplicaMode: cdk.stringToCloudFormation(properties.replicaMode),
        RestoreTime: cdk.stringToCloudFormation(properties.restoreTime),
        SourceDBInstanceAutomatedBackupsArn: cdk.stringToCloudFormation(properties.sourceDbInstanceAutomatedBackupsArn),
        SourceDBInstanceIdentifier: cdk.stringToCloudFormation(properties.sourceDbInstanceIdentifier),
        SourceDbiResourceId: cdk.stringToCloudFormation(properties.sourceDbiResourceId),
        SourceRegion: cdk.stringToCloudFormation(properties.sourceRegion),
        StorageEncrypted: cdk.booleanToCloudFormation(properties.storageEncrypted),
        StorageThroughput: cdk.numberToCloudFormation(properties.storageThroughput),
        StorageType: cdk.stringToCloudFormation(properties.storageType),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        Timezone: cdk.stringToCloudFormation(properties.timezone),
        UseDefaultProcessorFeatures: cdk.booleanToCloudFormation(properties.useDefaultProcessorFeatures),
        UseLatestRestorableTime: cdk.booleanToCloudFormation(properties.useLatestRestorableTime),
        VPCSecurityGroups: cdk.listMapper(cdk.stringToCloudFormation)(properties.vpcSecurityGroups),
    };
}
// @ts-ignore TS6133
function CfnDBInstancePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('allocatedStorage', 'AllocatedStorage', properties.AllocatedStorage != null ? cfn_parse.FromCloudFormation.getString(properties.AllocatedStorage) : undefined);
    ret.addPropertyResult('allowMajorVersionUpgrade', 'AllowMajorVersionUpgrade', properties.AllowMajorVersionUpgrade != null ? cfn_parse.FromCloudFormation.getBoolean(properties.AllowMajorVersionUpgrade) : undefined);
    ret.addPropertyResult('associatedRoles', 'AssociatedRoles', properties.AssociatedRoles != null ? cfn_parse.FromCloudFormation.getArray(CfnDBInstanceDBInstanceRolePropertyFromCloudFormation)(properties.AssociatedRoles) : undefined);
    ret.addPropertyResult('autoMinorVersionUpgrade', 'AutoMinorVersionUpgrade', properties.AutoMinorVersionUpgrade != null ? cfn_parse.FromCloudFormation.getBoolean(properties.AutoMinorVersionUpgrade) : undefined);
    ret.addPropertyResult('availabilityZone', 'AvailabilityZone', properties.AvailabilityZone != null ? cfn_parse.FromCloudFormation.getString(properties.AvailabilityZone) : undefined);
    ret.addPropertyResult('backupRetentionPeriod', 'BackupRetentionPeriod', properties.BackupRetentionPeriod != null ? cfn_parse.FromCloudFormation.getNumber(properties.BackupRetentionPeriod) : undefined);
    ret.addPropertyResult('caCertificateIdentifier', 'CACertificateIdentifier', properties.CACertificateIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.CACertificateIdentifier) : undefined);
    ret.addPropertyResult('certificateDetails', 'CertificateDetails', properties.CertificateDetails != null ? CfnDBInstanceCertificateDetailsPropertyFromCloudFormation(properties.CertificateDetails) : undefined);
    ret.addPropertyResult('certificateRotationRestart', 'CertificateRotationRestart', properties.CertificateRotationRestart != null ? cfn_parse.FromCloudFormation.getBoolean(properties.CertificateRotationRestart) : undefined);
    ret.addPropertyResult('characterSetName', 'CharacterSetName', properties.CharacterSetName != null ? cfn_parse.FromCloudFormation.getString(properties.CharacterSetName) : undefined);
    ret.addPropertyResult('copyTagsToSnapshot', 'CopyTagsToSnapshot', properties.CopyTagsToSnapshot != null ? cfn_parse.FromCloudFormation.getBoolean(properties.CopyTagsToSnapshot) : undefined);
    ret.addPropertyResult('customIamInstanceProfile', 'CustomIAMInstanceProfile', properties.CustomIAMInstanceProfile != null ? cfn_parse.FromCloudFormation.getString(properties.CustomIAMInstanceProfile) : undefined);
    ret.addPropertyResult('dbClusterIdentifier', 'DBClusterIdentifier', properties.DBClusterIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.DBClusterIdentifier) : undefined);
    ret.addPropertyResult('dbClusterSnapshotIdentifier', 'DBClusterSnapshotIdentifier', properties.DBClusterSnapshotIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.DBClusterSnapshotIdentifier) : undefined);
    ret.addPropertyResult('dbInstanceClass', 'DBInstanceClass', properties.DBInstanceClass != null ? cfn_parse.FromCloudFormation.getString(properties.DBInstanceClass) : undefined);
    ret.addPropertyResult('dbInstanceIdentifier', 'DBInstanceIdentifier', properties.DBInstanceIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.DBInstanceIdentifier) : undefined);
    ret.addPropertyResult('dbName', 'DBName', properties.DBName != null ? cfn_parse.FromCloudFormation.getString(properties.DBName) : undefined);
    ret.addPropertyResult('dbParameterGroupName', 'DBParameterGroupName', properties.DBParameterGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.DBParameterGroupName) : undefined);
    ret.addPropertyResult('dbSecurityGroups', 'DBSecurityGroups', properties.DBSecurityGroups != null ? cfn_parse.FromCloudFormation.getStringArray(properties.DBSecurityGroups) : undefined);
    ret.addPropertyResult('dbSnapshotIdentifier', 'DBSnapshotIdentifier', properties.DBSnapshotIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.DBSnapshotIdentifier) : undefined);
    ret.addPropertyResult('dbSubnetGroupName', 'DBSubnetGroupName', properties.DBSubnetGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.DBSubnetGroupName) : undefined);
    ret.addPropertyResult('deleteAutomatedBackups', 'DeleteAutomatedBackups', properties.DeleteAutomatedBackups != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DeleteAutomatedBackups) : undefined);
    ret.addPropertyResult('deletionProtection', 'DeletionProtection', properties.DeletionProtection != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DeletionProtection) : undefined);
    ret.addPropertyResult('domain', 'Domain', properties.Domain != null ? cfn_parse.FromCloudFormation.getString(properties.Domain) : undefined);
    ret.addPropertyResult('domainIamRoleName', 'DomainIAMRoleName', properties.DomainIAMRoleName != null ? cfn_parse.FromCloudFormation.getString(properties.DomainIAMRoleName) : undefined);
    ret.addPropertyResult('enableCloudwatchLogsExports', 'EnableCloudwatchLogsExports', properties.EnableCloudwatchLogsExports != null ? cfn_parse.FromCloudFormation.getStringArray(properties.EnableCloudwatchLogsExports) : undefined);
    ret.addPropertyResult('enableIamDatabaseAuthentication', 'EnableIAMDatabaseAuthentication', properties.EnableIAMDatabaseAuthentication != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableIAMDatabaseAuthentication) : undefined);
    ret.addPropertyResult('enablePerformanceInsights', 'EnablePerformanceInsights', properties.EnablePerformanceInsights != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnablePerformanceInsights) : undefined);
    ret.addPropertyResult('endpoint', 'Endpoint', properties.Endpoint != null ? CfnDBInstanceEndpointPropertyFromCloudFormation(properties.Endpoint) : undefined);
    ret.addPropertyResult('engine', 'Engine', properties.Engine != null ? cfn_parse.FromCloudFormation.getString(properties.Engine) : undefined);
    ret.addPropertyResult('engineVersion', 'EngineVersion', properties.EngineVersion != null ? cfn_parse.FromCloudFormation.getString(properties.EngineVersion) : undefined);
    ret.addPropertyResult('iops', 'Iops', properties.Iops != null ? cfn_parse.FromCloudFormation.getNumber(properties.Iops) : undefined);
    ret.addPropertyResult('kmsKeyId', 'KmsKeyId', properties.KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyId) : undefined);
    ret.addPropertyResult('licenseModel', 'LicenseModel', properties.LicenseModel != null ? cfn_parse.FromCloudFormation.getString(properties.LicenseModel) : undefined);
    ret.addPropertyResult('manageMasterUserPassword', 'ManageMasterUserPassword', properties.ManageMasterUserPassword != null ? cfn_parse.FromCloudFormation.getBoolean(properties.ManageMasterUserPassword) : undefined);
    ret.addPropertyResult('masterUsername', 'MasterUsername', properties.MasterUsername != null ? cfn_parse.FromCloudFormation.getString(properties.MasterUsername) : undefined);
    ret.addPropertyResult('masterUserPassword', 'MasterUserPassword', properties.MasterUserPassword != null ? cfn_parse.FromCloudFormation.getString(properties.MasterUserPassword) : undefined);
    ret.addPropertyResult('masterUserSecret', 'MasterUserSecret', properties.MasterUserSecret != null ? CfnDBInstanceMasterUserSecretPropertyFromCloudFormation(properties.MasterUserSecret) : undefined);
    ret.addPropertyResult('maxAllocatedStorage', 'MaxAllocatedStorage', properties.MaxAllocatedStorage != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxAllocatedStorage) : undefined);
    ret.addPropertyResult('monitoringInterval', 'MonitoringInterval', properties.MonitoringInterval != null ? cfn_parse.FromCloudFormation.getNumber(properties.MonitoringInterval) : undefined);
    ret.addPropertyResult('monitoringRoleArn', 'MonitoringRoleArn', properties.MonitoringRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.MonitoringRoleArn) : undefined);
    ret.addPropertyResult('multiAz', 'MultiAZ', properties.MultiAZ != null ? cfn_parse.FromCloudFormation.getBoolean(properties.MultiAZ) : undefined);
    ret.addPropertyResult('ncharCharacterSetName', 'NcharCharacterSetName', properties.NcharCharacterSetName != null ? cfn_parse.FromCloudFormation.getString(properties.NcharCharacterSetName) : undefined);
    ret.addPropertyResult('networkType', 'NetworkType', properties.NetworkType != null ? cfn_parse.FromCloudFormation.getString(properties.NetworkType) : undefined);
    ret.addPropertyResult('optionGroupName', 'OptionGroupName', properties.OptionGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.OptionGroupName) : undefined);
    ret.addPropertyResult('performanceInsightsKmsKeyId', 'PerformanceInsightsKMSKeyId', properties.PerformanceInsightsKMSKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.PerformanceInsightsKMSKeyId) : undefined);
    ret.addPropertyResult('performanceInsightsRetentionPeriod', 'PerformanceInsightsRetentionPeriod', properties.PerformanceInsightsRetentionPeriod != null ? cfn_parse.FromCloudFormation.getNumber(properties.PerformanceInsightsRetentionPeriod) : undefined);
    ret.addPropertyResult('port', 'Port', properties.Port != null ? cfn_parse.FromCloudFormation.getString(properties.Port) : undefined);
    ret.addPropertyResult('preferredBackupWindow', 'PreferredBackupWindow', properties.PreferredBackupWindow != null ? cfn_parse.FromCloudFormation.getString(properties.PreferredBackupWindow) : undefined);
    ret.addPropertyResult('preferredMaintenanceWindow', 'PreferredMaintenanceWindow', properties.PreferredMaintenanceWindow != null ? cfn_parse.FromCloudFormation.getString(properties.PreferredMaintenanceWindow) : undefined);
    ret.addPropertyResult('processorFeatures', 'ProcessorFeatures', properties.ProcessorFeatures != null ? cfn_parse.FromCloudFormation.getArray(CfnDBInstanceProcessorFeaturePropertyFromCloudFormation)(properties.ProcessorFeatures) : undefined);
    ret.addPropertyResult('promotionTier', 'PromotionTier', properties.PromotionTier != null ? cfn_parse.FromCloudFormation.getNumber(properties.PromotionTier) : undefined);
    ret.addPropertyResult('publiclyAccessible', 'PubliclyAccessible', properties.PubliclyAccessible != null ? cfn_parse.FromCloudFormation.getBoolean(properties.PubliclyAccessible) : undefined);
    ret.addPropertyResult('replicaMode', 'ReplicaMode', properties.ReplicaMode != null ? cfn_parse.FromCloudFormation.getString(properties.ReplicaMode) : undefined);
    ret.addPropertyResult('restoreTime', 'RestoreTime', properties.RestoreTime != null ? cfn_parse.FromCloudFormation.getString(properties.RestoreTime) : undefined);
    ret.addPropertyResult('sourceDbInstanceAutomatedBackupsArn', 'SourceDBInstanceAutomatedBackupsArn', properties.SourceDBInstanceAutomatedBackupsArn != null ? cfn_parse.FromCloudFormation.getString(properties.SourceDBInstanceAutomatedBackupsArn) : undefined);
    ret.addPropertyResult('sourceDbInstanceIdentifier', 'SourceDBInstanceIdentifier', properties.SourceDBInstanceIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.SourceDBInstanceIdentifier) : undefined);
    ret.addPropertyResult('sourceDbiResourceId', 'SourceDbiResourceId', properties.SourceDbiResourceId != null ? cfn_parse.FromCloudFormation.getString(properties.SourceDbiResourceId) : undefined);
    ret.addPropertyResult('sourceRegion', 'SourceRegion', properties.SourceRegion != null ? cfn_parse.FromCloudFormation.getString(properties.SourceRegion) : undefined);
    ret.addPropertyResult('storageEncrypted', 'StorageEncrypted', properties.StorageEncrypted != null ? cfn_parse.FromCloudFormation.getBoolean(properties.StorageEncrypted) : undefined);
    ret.addPropertyResult('storageThroughput', 'StorageThroughput', properties.StorageThroughput != null ? cfn_parse.FromCloudFormation.getNumber(properties.StorageThroughput) : undefined);
    ret.addPropertyResult('storageType', 'StorageType', properties.StorageType != null ? cfn_parse.FromCloudFormation.getString(properties.StorageType) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('timezone', 'Timezone', properties.Timezone != null ? cfn_parse.FromCloudFormation.getString(properties.Timezone) : undefined);
    ret.addPropertyResult('useDefaultProcessorFeatures', 'UseDefaultProcessorFeatures', properties.UseDefaultProcessorFeatures != null ? cfn_parse.FromCloudFormation.getBoolean(properties.UseDefaultProcessorFeatures) : undefined);
    ret.addPropertyResult('useLatestRestorableTime', 'UseLatestRestorableTime', properties.UseLatestRestorableTime != null ? cfn_parse.FromCloudFormation.getBoolean(properties.UseLatestRestorableTime) : undefined);
    ret.addPropertyResult('vpcSecurityGroups', 'VPCSecurityGroups', properties.VPCSecurityGroups != null ? cfn_parse.FromCloudFormation.getStringArray(properties.VPCSecurityGroups) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::DBInstance`
 *
 * The `AWS::RDS::DBInstance` resource creates an Amazon DB instance. The new DB instance can be an RDS DB instance, or it can be a DB instance in an Aurora DB cluster.
 *
 * For more information about creating an RDS DB instance, see [Creating an Amazon RDS DB instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CreateDBInstance.html) in the *Amazon RDS User Guide* .
 *
 * For more information about creating a DB instance in an Aurora DB cluster, see [Creating an Amazon Aurora DB cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.CreateInstance.html) in the *Amazon Aurora User Guide* .
 *
 * If you import an existing DB instance, and the template configuration doesn't match the actual configuration of the DB instance, AWS CloudFormation applies the changes in the template during the import operation.
 *
 * > If a DB instance is deleted or replaced during an update, AWS CloudFormation deletes all automated snapshots. However, it retains manual DB snapshots. During an update that requires replacement, you can apply a stack policy to prevent DB instances from being replaced. For more information, see [Prevent Updates to Stack Resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html) .
 *
 * *Updating DB instances*
 *
 * When properties labeled " *Update requires:* [Replacement](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement) " are updated, AWS CloudFormation first creates a replacement DB instance, then changes references from other dependent resources to point to the replacement DB instance, and finally deletes the old DB instance.
 *
 * > We highly recommend that you take a snapshot of the database before updating the stack. If you don't, you lose the data when AWS CloudFormation replaces your DB instance. To preserve your data, perform the following procedure:
 * >
 * > - Deactivate any applications that are using the DB instance so that there's no activity on the DB instance.
 * > - Create a snapshot of the DB instance. For more information, see [Creating a DB Snapshot](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CreateSnapshot.html) .
 * > - If you want to restore your instance using a DB snapshot, modify the updated template with your DB instance changes and add the `DBSnapshotIdentifier` property with the ID of the DB snapshot that you want to use.
 * >
 * > After you restore a DB instance with a `DBSnapshotIdentifier` property, you must specify the same `DBSnapshotIdentifier` property for any future updates to the DB instance. When you specify this property for an update, the DB instance is not restored from the DB snapshot again, and the data in the database is not changed. However, if you don't specify the `DBSnapshotIdentifier` property, an empty DB instance is created, and the original DB instance is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB instance is restored from the specified `DBSnapshotIdentifier` property, and the original DB instance is deleted.
 * > - Update the stack.
 *
 * For more information about updating other properties of this resource, see `[ModifyDBInstance](https://docs.aws.amazon.com//AmazonRDS/latest/APIReference/API_ModifyDBInstance.html)` . For more information about updating stacks, see [AWS CloudFormation Stacks Updates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html) .
 *
 * *Deleting DB instances*
 *
 * For DB instances that are part of an Aurora DB cluster, you can set a deletion policy for your DB instance to control how AWS CloudFormation handles the DB instance when the stack is deleted. For Amazon RDS DB instances, you can choose to *retain* the DB instance, to *delete* the DB instance, or to *create a snapshot* of the DB instance. The default AWS CloudFormation behavior depends on the `DBClusterIdentifier` property:
 *
 * - For `AWS::RDS::DBInstance` resources that don't specify the `DBClusterIdentifier` property, AWS CloudFormation saves a snapshot of the DB instance.
 * - For `AWS::RDS::DBInstance` resources that do specify the `DBClusterIdentifier` property, AWS CloudFormation deletes the DB instance.
 *
 * For more information, see [DeletionPolicy Attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html) .
 *
 * @cloudformationResource AWS::RDS::DBInstance
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html
 */
class CfnDBInstance extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDBInstancePropsFromCloudFormation(resourceProperties);
        const ret = new CfnDBInstance(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::RDS::DBInstance`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnDBInstance.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_CfnDBInstanceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnDBInstance);
            }
            throw error;
        }
        this.attrCertificateDetailsCaIdentifier = cdk.Token.asString(this.getAtt('CertificateDetails.CAIdentifier', cdk.ResolutionTypeHint.STRING));
        this.attrCertificateDetailsValidTill = cdk.Token.asString(this.getAtt('CertificateDetails.ValidTill', cdk.ResolutionTypeHint.STRING));
        this.attrDbInstanceArn = cdk.Token.asString(this.getAtt('DBInstanceArn', cdk.ResolutionTypeHint.STRING));
        this.attrDbSystemId = cdk.Token.asString(this.getAtt('DBSystemId', cdk.ResolutionTypeHint.STRING));
        this.attrDbiResourceId = cdk.Token.asString(this.getAtt('DbiResourceId', cdk.ResolutionTypeHint.STRING));
        this.attrEndpointAddress = cdk.Token.asString(this.getAtt('Endpoint.Address', cdk.ResolutionTypeHint.STRING));
        this.attrEndpointHostedZoneId = cdk.Token.asString(this.getAtt('Endpoint.HostedZoneId', cdk.ResolutionTypeHint.STRING));
        this.attrEndpointPort = cdk.Token.asString(this.getAtt('Endpoint.Port', cdk.ResolutionTypeHint.STRING));
        this.attrMasterUserSecretSecretArn = cdk.Token.asString(this.getAtt('MasterUserSecret.SecretArn', cdk.ResolutionTypeHint.STRING));
        this.allocatedStorage = props.allocatedStorage;
        this.allowMajorVersionUpgrade = props.allowMajorVersionUpgrade;
        this.associatedRoles = props.associatedRoles;
        this.autoMinorVersionUpgrade = props.autoMinorVersionUpgrade;
        this.availabilityZone = props.availabilityZone;
        this.backupRetentionPeriod = props.backupRetentionPeriod;
        this.caCertificateIdentifier = props.caCertificateIdentifier;
        this.certificateDetails = props.certificateDetails;
        this.certificateRotationRestart = props.certificateRotationRestart;
        this.characterSetName = props.characterSetName;
        this.copyTagsToSnapshot = props.copyTagsToSnapshot;
        this.customIamInstanceProfile = props.customIamInstanceProfile;
        this.dbClusterIdentifier = props.dbClusterIdentifier;
        this.dbClusterSnapshotIdentifier = props.dbClusterSnapshotIdentifier;
        this.dbInstanceClass = props.dbInstanceClass;
        this.dbInstanceIdentifier = props.dbInstanceIdentifier;
        this.dbName = props.dbName;
        this.dbParameterGroupName = props.dbParameterGroupName;
        this.dbSecurityGroups = props.dbSecurityGroups;
        this.dbSnapshotIdentifier = props.dbSnapshotIdentifier;
        this.dbSubnetGroupName = props.dbSubnetGroupName;
        this.deleteAutomatedBackups = props.deleteAutomatedBackups;
        this.deletionProtection = props.deletionProtection;
        this.domain = props.domain;
        this.domainIamRoleName = props.domainIamRoleName;
        this.enableCloudwatchLogsExports = props.enableCloudwatchLogsExports;
        this.enableIamDatabaseAuthentication = props.enableIamDatabaseAuthentication;
        this.enablePerformanceInsights = props.enablePerformanceInsights;
        this.endpoint = props.endpoint;
        this.engine = props.engine;
        this.engineVersion = props.engineVersion;
        this.iops = props.iops;
        this.kmsKeyId = props.kmsKeyId;
        this.licenseModel = props.licenseModel;
        this.manageMasterUserPassword = props.manageMasterUserPassword;
        this.masterUsername = props.masterUsername;
        this.masterUserPassword = props.masterUserPassword;
        this.masterUserSecret = props.masterUserSecret;
        this.maxAllocatedStorage = props.maxAllocatedStorage;
        this.monitoringInterval = props.monitoringInterval;
        this.monitoringRoleArn = props.monitoringRoleArn;
        this.multiAz = props.multiAz;
        this.ncharCharacterSetName = props.ncharCharacterSetName;
        this.networkType = props.networkType;
        this.optionGroupName = props.optionGroupName;
        this.performanceInsightsKmsKeyId = props.performanceInsightsKmsKeyId;
        this.performanceInsightsRetentionPeriod = props.performanceInsightsRetentionPeriod;
        this.port = props.port;
        this.preferredBackupWindow = props.preferredBackupWindow;
        this.preferredMaintenanceWindow = props.preferredMaintenanceWindow;
        this.processorFeatures = props.processorFeatures;
        this.promotionTier = props.promotionTier;
        this.publiclyAccessible = props.publiclyAccessible;
        this.replicaMode = props.replicaMode;
        this.restoreTime = props.restoreTime;
        this.sourceDbInstanceAutomatedBackupsArn = props.sourceDbInstanceAutomatedBackupsArn;
        this.sourceDbInstanceIdentifier = props.sourceDbInstanceIdentifier;
        this.sourceDbiResourceId = props.sourceDbiResourceId;
        this.sourceRegion = props.sourceRegion;
        this.storageEncrypted = props.storageEncrypted;
        this.storageThroughput = props.storageThroughput;
        this.storageType = props.storageType;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::RDS::DBInstance", props.tags, { tagPropertyName: 'tags' });
        this.timezone = props.timezone;
        this.useDefaultProcessorFeatures = props.useDefaultProcessorFeatures;
        this.useLatestRestorableTime = props.useLatestRestorableTime;
        this.vpcSecurityGroups = props.vpcSecurityGroups;
        if (this.node.scope && cdk.Resource.isResource(this.node.scope)) {
            this.node.addValidation({ validate: () => this.cfnOptions.deletionPolicy === undefined
                    ? ['\'AWS::RDS::DBInstance\' is a stateful resource type, and you must specify a Removal Policy for it. Call \'resource.applyRemovalPolicy()\'.']
                    : [] });
        }
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDBInstance.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            allocatedStorage: this.allocatedStorage,
            allowMajorVersionUpgrade: this.allowMajorVersionUpgrade,
            associatedRoles: this.associatedRoles,
            autoMinorVersionUpgrade: this.autoMinorVersionUpgrade,
            availabilityZone: this.availabilityZone,
            backupRetentionPeriod: this.backupRetentionPeriod,
            caCertificateIdentifier: this.caCertificateIdentifier,
            certificateDetails: this.certificateDetails,
            certificateRotationRestart: this.certificateRotationRestart,
            characterSetName: this.characterSetName,
            copyTagsToSnapshot: this.copyTagsToSnapshot,
            customIamInstanceProfile: this.customIamInstanceProfile,
            dbClusterIdentifier: this.dbClusterIdentifier,
            dbClusterSnapshotIdentifier: this.dbClusterSnapshotIdentifier,
            dbInstanceClass: this.dbInstanceClass,
            dbInstanceIdentifier: this.dbInstanceIdentifier,
            dbName: this.dbName,
            dbParameterGroupName: this.dbParameterGroupName,
            dbSecurityGroups: this.dbSecurityGroups,
            dbSnapshotIdentifier: this.dbSnapshotIdentifier,
            dbSubnetGroupName: this.dbSubnetGroupName,
            deleteAutomatedBackups: this.deleteAutomatedBackups,
            deletionProtection: this.deletionProtection,
            domain: this.domain,
            domainIamRoleName: this.domainIamRoleName,
            enableCloudwatchLogsExports: this.enableCloudwatchLogsExports,
            enableIamDatabaseAuthentication: this.enableIamDatabaseAuthentication,
            enablePerformanceInsights: this.enablePerformanceInsights,
            endpoint: this.endpoint,
            engine: this.engine,
            engineVersion: this.engineVersion,
            iops: this.iops,
            kmsKeyId: this.kmsKeyId,
            licenseModel: this.licenseModel,
            manageMasterUserPassword: this.manageMasterUserPassword,
            masterUsername: this.masterUsername,
            masterUserPassword: this.masterUserPassword,
            masterUserSecret: this.masterUserSecret,
            maxAllocatedStorage: this.maxAllocatedStorage,
            monitoringInterval: this.monitoringInterval,
            monitoringRoleArn: this.monitoringRoleArn,
            multiAz: this.multiAz,
            ncharCharacterSetName: this.ncharCharacterSetName,
            networkType: this.networkType,
            optionGroupName: this.optionGroupName,
            performanceInsightsKmsKeyId: this.performanceInsightsKmsKeyId,
            performanceInsightsRetentionPeriod: this.performanceInsightsRetentionPeriod,
            port: this.port,
            preferredBackupWindow: this.preferredBackupWindow,
            preferredMaintenanceWindow: this.preferredMaintenanceWindow,
            processorFeatures: this.processorFeatures,
            promotionTier: this.promotionTier,
            publiclyAccessible: this.publiclyAccessible,
            replicaMode: this.replicaMode,
            restoreTime: this.restoreTime,
            sourceDbInstanceAutomatedBackupsArn: this.sourceDbInstanceAutomatedBackupsArn,
            sourceDbInstanceIdentifier: this.sourceDbInstanceIdentifier,
            sourceDbiResourceId: this.sourceDbiResourceId,
            sourceRegion: this.sourceRegion,
            storageEncrypted: this.storageEncrypted,
            storageThroughput: this.storageThroughput,
            storageType: this.storageType,
            tags: this.tags.renderTags(),
            timezone: this.timezone,
            useDefaultProcessorFeatures: this.useDefaultProcessorFeatures,
            useLatestRestorableTime: this.useLatestRestorableTime,
            vpcSecurityGroups: this.vpcSecurityGroups,
        };
    }
    renderProperties(props) {
        return cfnDBInstancePropsToCloudFormation(props);
    }
}
_c = JSII_RTTI_SYMBOL_1;
CfnDBInstance[_c] = { fqn: "aws-cdk-lib.aws_rds.CfnDBInstance", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDBInstance.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBInstance";
exports.CfnDBInstance = CfnDBInstance;
/**
 * Determine whether the given properties match those of a `CertificateDetailsProperty`
 *
 * @param properties - the TypeScript properties of a `CertificateDetailsProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBInstance_CertificateDetailsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('caIdentifier', cdk.validateString)(properties.caIdentifier));
    errors.collect(cdk.propertyValidator('validTill', cdk.validateString)(properties.validTill));
    return errors.wrap('supplied properties not correct for "CertificateDetailsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBInstance.CertificateDetails` resource
 *
 * @param properties - the TypeScript properties of a `CertificateDetailsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBInstance.CertificateDetails` resource.
 */
// @ts-ignore TS6133
function cfnDBInstanceCertificateDetailsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBInstance_CertificateDetailsPropertyValidator(properties).assertSuccess();
    return {
        CAIdentifier: cdk.stringToCloudFormation(properties.caIdentifier),
        ValidTill: cdk.stringToCloudFormation(properties.validTill),
    };
}
// @ts-ignore TS6133
function CfnDBInstanceCertificateDetailsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('caIdentifier', 'CAIdentifier', properties.CAIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.CAIdentifier) : undefined);
    ret.addPropertyResult('validTill', 'ValidTill', properties.ValidTill != null ? cfn_parse.FromCloudFormation.getString(properties.ValidTill) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DBInstanceRoleProperty`
 *
 * @param properties - the TypeScript properties of a `DBInstanceRoleProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBInstance_DBInstanceRolePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('featureName', cdk.requiredValidator)(properties.featureName));
    errors.collect(cdk.propertyValidator('featureName', cdk.validateString)(properties.featureName));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    return errors.wrap('supplied properties not correct for "DBInstanceRoleProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBInstance.DBInstanceRole` resource
 *
 * @param properties - the TypeScript properties of a `DBInstanceRoleProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBInstance.DBInstanceRole` resource.
 */
// @ts-ignore TS6133
function cfnDBInstanceDBInstanceRolePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBInstance_DBInstanceRolePropertyValidator(properties).assertSuccess();
    return {
        FeatureName: cdk.stringToCloudFormation(properties.featureName),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
    };
}
// @ts-ignore TS6133
function CfnDBInstanceDBInstanceRolePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('featureName', 'FeatureName', cfn_parse.FromCloudFormation.getString(properties.FeatureName));
    ret.addPropertyResult('roleArn', 'RoleArn', cfn_parse.FromCloudFormation.getString(properties.RoleArn));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `EndpointProperty`
 *
 * @param properties - the TypeScript properties of a `EndpointProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBInstance_EndpointPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('address', cdk.validateString)(properties.address));
    errors.collect(cdk.propertyValidator('hostedZoneId', cdk.validateString)(properties.hostedZoneId));
    errors.collect(cdk.propertyValidator('port', cdk.validateString)(properties.port));
    return errors.wrap('supplied properties not correct for "EndpointProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBInstance.Endpoint` resource
 *
 * @param properties - the TypeScript properties of a `EndpointProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBInstance.Endpoint` resource.
 */
// @ts-ignore TS6133
function cfnDBInstanceEndpointPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBInstance_EndpointPropertyValidator(properties).assertSuccess();
    return {
        Address: cdk.stringToCloudFormation(properties.address),
        HostedZoneId: cdk.stringToCloudFormation(properties.hostedZoneId),
        Port: cdk.stringToCloudFormation(properties.port),
    };
}
// @ts-ignore TS6133
function CfnDBInstanceEndpointPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('address', 'Address', properties.Address != null ? cfn_parse.FromCloudFormation.getString(properties.Address) : undefined);
    ret.addPropertyResult('hostedZoneId', 'HostedZoneId', properties.HostedZoneId != null ? cfn_parse.FromCloudFormation.getString(properties.HostedZoneId) : undefined);
    ret.addPropertyResult('port', 'Port', properties.Port != null ? cfn_parse.FromCloudFormation.getString(properties.Port) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MasterUserSecretProperty`
 *
 * @param properties - the TypeScript properties of a `MasterUserSecretProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBInstance_MasterUserSecretPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    errors.collect(cdk.propertyValidator('secretArn', cdk.validateString)(properties.secretArn));
    return errors.wrap('supplied properties not correct for "MasterUserSecretProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBInstance.MasterUserSecret` resource
 *
 * @param properties - the TypeScript properties of a `MasterUserSecretProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBInstance.MasterUserSecret` resource.
 */
// @ts-ignore TS6133
function cfnDBInstanceMasterUserSecretPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBInstance_MasterUserSecretPropertyValidator(properties).assertSuccess();
    return {
        KmsKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
        SecretArn: cdk.stringToCloudFormation(properties.secretArn),
    };
}
// @ts-ignore TS6133
function CfnDBInstanceMasterUserSecretPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('kmsKeyId', 'KmsKeyId', properties.KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyId) : undefined);
    ret.addPropertyResult('secretArn', 'SecretArn', properties.SecretArn != null ? cfn_parse.FromCloudFormation.getString(properties.SecretArn) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ProcessorFeatureProperty`
 *
 * @param properties - the TypeScript properties of a `ProcessorFeatureProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBInstance_ProcessorFeaturePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "ProcessorFeatureProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBInstance.ProcessorFeature` resource
 *
 * @param properties - the TypeScript properties of a `ProcessorFeatureProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBInstance.ProcessorFeature` resource.
 */
// @ts-ignore TS6133
function cfnDBInstanceProcessorFeaturePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBInstance_ProcessorFeaturePropertyValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnDBInstanceProcessorFeaturePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('value', 'Value', properties.Value != null ? cfn_parse.FromCloudFormation.getString(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnDBParameterGroupProps`
 *
 * @param properties - the TypeScript properties of a `CfnDBParameterGroupProps`
 *
 * @returns the result of the validation.
 */
function CfnDBParameterGroupPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dbParameterGroupName', cdk.validateString)(properties.dbParameterGroupName));
    errors.collect(cdk.propertyValidator('description', cdk.requiredValidator)(properties.description));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('family', cdk.requiredValidator)(properties.family));
    errors.collect(cdk.propertyValidator('family', cdk.validateString)(properties.family));
    errors.collect(cdk.propertyValidator('parameters', cdk.validateObject)(properties.parameters));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnDBParameterGroupProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBParameterGroup` resource
 *
 * @param properties - the TypeScript properties of a `CfnDBParameterGroupProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBParameterGroup` resource.
 */
// @ts-ignore TS6133
function cfnDBParameterGroupPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBParameterGroupPropsValidator(properties).assertSuccess();
    return {
        Description: cdk.stringToCloudFormation(properties.description),
        Family: cdk.stringToCloudFormation(properties.family),
        DBParameterGroupName: cdk.stringToCloudFormation(properties.dbParameterGroupName),
        Parameters: cdk.objectToCloudFormation(properties.parameters),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnDBParameterGroupPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('description', 'Description', cfn_parse.FromCloudFormation.getString(properties.Description));
    ret.addPropertyResult('family', 'Family', cfn_parse.FromCloudFormation.getString(properties.Family));
    ret.addPropertyResult('dbParameterGroupName', 'DBParameterGroupName', properties.DBParameterGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.DBParameterGroupName) : undefined);
    ret.addPropertyResult('parameters', 'Parameters', properties.Parameters != null ? cfn_parse.FromCloudFormation.getAny(properties.Parameters) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::DBParameterGroup`
 *
 * The `AWS::RDS::DBParameterGroup` resource creates a custom parameter group for an RDS database family.
 *
 * This type can be declared in a template and referenced in the `DBParameterGroupName` property of an `[AWS::RDS::DBInstance](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html)` resource.
 *
 * For information about configuring parameters for Amazon RDS DB instances, see [Working with parameter groups](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithParamGroups.html) in the *Amazon RDS User Guide* .
 *
 * For information about configuring parameters for Amazon Aurora DB instances, see [Working with parameter groups](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_WorkingWithParamGroups.html) in the *Amazon Aurora User Guide* .
 *
 * > Applying a parameter group to a DB instance may require the DB instance to reboot, resulting in a database outage for the duration of the reboot.
 *
 * @cloudformationResource AWS::RDS::DBParameterGroup
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbparametergroup.html
 */
class CfnDBParameterGroup extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDBParameterGroupPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDBParameterGroup(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::RDS::DBParameterGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDBParameterGroup.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_CfnDBParameterGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnDBParameterGroup);
            }
            throw error;
        }
        cdk.requireProperty(props, 'description', this);
        cdk.requireProperty(props, 'family', this);
        this.attrDbParameterGroupName = cdk.Token.asString(this.getAtt('DBParameterGroupName', cdk.ResolutionTypeHint.STRING));
        this.description = props.description;
        this.family = props.family;
        this.dbParameterGroupName = props.dbParameterGroupName;
        this.parameters = props.parameters;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::RDS::DBParameterGroup", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDBParameterGroup.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            description: this.description,
            family: this.family,
            dbParameterGroupName: this.dbParameterGroupName,
            parameters: this.parameters,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnDBParameterGroupPropsToCloudFormation(props);
    }
}
_d = JSII_RTTI_SYMBOL_1;
CfnDBParameterGroup[_d] = { fqn: "aws-cdk-lib.aws_rds.CfnDBParameterGroup", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDBParameterGroup.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBParameterGroup";
exports.CfnDBParameterGroup = CfnDBParameterGroup;
/**
 * Determine whether the given properties match those of a `CfnDBProxyProps`
 *
 * @param properties - the TypeScript properties of a `CfnDBProxyProps`
 *
 * @returns the result of the validation.
 */
function CfnDBProxyPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('auth', cdk.requiredValidator)(properties.auth));
    errors.collect(cdk.propertyValidator('auth', cdk.listValidator(CfnDBProxy_AuthFormatPropertyValidator))(properties.auth));
    errors.collect(cdk.propertyValidator('dbProxyName', cdk.requiredValidator)(properties.dbProxyName));
    errors.collect(cdk.propertyValidator('dbProxyName', cdk.validateString)(properties.dbProxyName));
    errors.collect(cdk.propertyValidator('debugLogging', cdk.validateBoolean)(properties.debugLogging));
    errors.collect(cdk.propertyValidator('engineFamily', cdk.requiredValidator)(properties.engineFamily));
    errors.collect(cdk.propertyValidator('engineFamily', cdk.validateString)(properties.engineFamily));
    errors.collect(cdk.propertyValidator('idleClientTimeout', cdk.validateNumber)(properties.idleClientTimeout));
    errors.collect(cdk.propertyValidator('requireTls', cdk.validateBoolean)(properties.requireTls));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(CfnDBProxy_TagFormatPropertyValidator))(properties.tags));
    errors.collect(cdk.propertyValidator('vpcSecurityGroupIds', cdk.listValidator(cdk.validateString))(properties.vpcSecurityGroupIds));
    errors.collect(cdk.propertyValidator('vpcSubnetIds', cdk.requiredValidator)(properties.vpcSubnetIds));
    errors.collect(cdk.propertyValidator('vpcSubnetIds', cdk.listValidator(cdk.validateString))(properties.vpcSubnetIds));
    return errors.wrap('supplied properties not correct for "CfnDBProxyProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBProxy` resource
 *
 * @param properties - the TypeScript properties of a `CfnDBProxyProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBProxy` resource.
 */
// @ts-ignore TS6133
function cfnDBProxyPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBProxyPropsValidator(properties).assertSuccess();
    return {
        Auth: cdk.listMapper(cfnDBProxyAuthFormatPropertyToCloudFormation)(properties.auth),
        DBProxyName: cdk.stringToCloudFormation(properties.dbProxyName),
        EngineFamily: cdk.stringToCloudFormation(properties.engineFamily),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
        VpcSubnetIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.vpcSubnetIds),
        DebugLogging: cdk.booleanToCloudFormation(properties.debugLogging),
        IdleClientTimeout: cdk.numberToCloudFormation(properties.idleClientTimeout),
        RequireTLS: cdk.booleanToCloudFormation(properties.requireTls),
        Tags: cdk.listMapper(cfnDBProxyTagFormatPropertyToCloudFormation)(properties.tags),
        VpcSecurityGroupIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.vpcSecurityGroupIds),
    };
}
// @ts-ignore TS6133
function CfnDBProxyPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('auth', 'Auth', cfn_parse.FromCloudFormation.getArray(CfnDBProxyAuthFormatPropertyFromCloudFormation)(properties.Auth));
    ret.addPropertyResult('dbProxyName', 'DBProxyName', cfn_parse.FromCloudFormation.getString(properties.DBProxyName));
    ret.addPropertyResult('engineFamily', 'EngineFamily', cfn_parse.FromCloudFormation.getString(properties.EngineFamily));
    ret.addPropertyResult('roleArn', 'RoleArn', cfn_parse.FromCloudFormation.getString(properties.RoleArn));
    ret.addPropertyResult('vpcSubnetIds', 'VpcSubnetIds', cfn_parse.FromCloudFormation.getStringArray(properties.VpcSubnetIds));
    ret.addPropertyResult('debugLogging', 'DebugLogging', properties.DebugLogging != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DebugLogging) : undefined);
    ret.addPropertyResult('idleClientTimeout', 'IdleClientTimeout', properties.IdleClientTimeout != null ? cfn_parse.FromCloudFormation.getNumber(properties.IdleClientTimeout) : undefined);
    ret.addPropertyResult('requireTls', 'RequireTLS', properties.RequireTLS != null ? cfn_parse.FromCloudFormation.getBoolean(properties.RequireTLS) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(CfnDBProxyTagFormatPropertyFromCloudFormation)(properties.Tags) : undefined);
    ret.addPropertyResult('vpcSecurityGroupIds', 'VpcSecurityGroupIds', properties.VpcSecurityGroupIds != null ? cfn_parse.FromCloudFormation.getStringArray(properties.VpcSecurityGroupIds) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::DBProxy`
 *
 * The `AWS::RDS::DBProxy` resource creates or updates a DB proxy.
 *
 * For information about RDS Proxy for Amazon RDS, see [Managing Connections with Amazon RDS Proxy](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-proxy.html) in the *Amazon RDS User Guide* .
 *
 * For information about RDS Proxy for Amazon Aurora, see [Managing Connections with Amazon RDS Proxy](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-proxy.html) in the *Amazon Aurora User Guide* .
 *
 * > Limitations apply to RDS Proxy, including DB engine version limitations and AWS Region limitations.
 * >
 * > For information about limitations that apply to RDS Proxy for Amazon RDS, see [Limitations for RDS Proxy](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-proxy.html#rds-proxy.limitations) in the *Amazon RDS User Guide* .
 * >
 * > For information about that apply to RDS Proxy for Amazon Aurora, see [Limitations for RDS Proxy](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-proxy.html#rds-proxy.limitations) in the *Amazon Aurora User Guide* .
 *
 * @cloudformationResource AWS::RDS::DBProxy
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html
 */
class CfnDBProxy extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDBProxyPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDBProxy(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::RDS::DBProxy`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDBProxy.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_CfnDBProxyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnDBProxy);
            }
            throw error;
        }
        cdk.requireProperty(props, 'auth', this);
        cdk.requireProperty(props, 'dbProxyName', this);
        cdk.requireProperty(props, 'engineFamily', this);
        cdk.requireProperty(props, 'roleArn', this);
        cdk.requireProperty(props, 'vpcSubnetIds', this);
        this.attrDbProxyArn = cdk.Token.asString(this.getAtt('DBProxyArn', cdk.ResolutionTypeHint.STRING));
        this.attrEndpoint = cdk.Token.asString(this.getAtt('Endpoint', cdk.ResolutionTypeHint.STRING));
        this.attrVpcId = cdk.Token.asString(this.getAtt('VpcId', cdk.ResolutionTypeHint.STRING));
        this.auth = props.auth;
        this.dbProxyName = props.dbProxyName;
        this.engineFamily = props.engineFamily;
        this.roleArn = props.roleArn;
        this.vpcSubnetIds = props.vpcSubnetIds;
        this.debugLogging = props.debugLogging;
        this.idleClientTimeout = props.idleClientTimeout;
        this.requireTls = props.requireTls;
        this.tags = props.tags;
        this.vpcSecurityGroupIds = props.vpcSecurityGroupIds;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDBProxy.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            auth: this.auth,
            dbProxyName: this.dbProxyName,
            engineFamily: this.engineFamily,
            roleArn: this.roleArn,
            vpcSubnetIds: this.vpcSubnetIds,
            debugLogging: this.debugLogging,
            idleClientTimeout: this.idleClientTimeout,
            requireTls: this.requireTls,
            tags: this.tags,
            vpcSecurityGroupIds: this.vpcSecurityGroupIds,
        };
    }
    renderProperties(props) {
        return cfnDBProxyPropsToCloudFormation(props);
    }
}
_e = JSII_RTTI_SYMBOL_1;
CfnDBProxy[_e] = { fqn: "aws-cdk-lib.aws_rds.CfnDBProxy", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDBProxy.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBProxy";
exports.CfnDBProxy = CfnDBProxy;
/**
 * Determine whether the given properties match those of a `AuthFormatProperty`
 *
 * @param properties - the TypeScript properties of a `AuthFormatProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBProxy_AuthFormatPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('authScheme', cdk.validateString)(properties.authScheme));
    errors.collect(cdk.propertyValidator('clientPasswordAuthType', cdk.validateString)(properties.clientPasswordAuthType));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('iamAuth', cdk.validateString)(properties.iamAuth));
    errors.collect(cdk.propertyValidator('secretArn', cdk.validateString)(properties.secretArn));
    return errors.wrap('supplied properties not correct for "AuthFormatProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBProxy.AuthFormat` resource
 *
 * @param properties - the TypeScript properties of a `AuthFormatProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBProxy.AuthFormat` resource.
 */
// @ts-ignore TS6133
function cfnDBProxyAuthFormatPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBProxy_AuthFormatPropertyValidator(properties).assertSuccess();
    return {
        AuthScheme: cdk.stringToCloudFormation(properties.authScheme),
        ClientPasswordAuthType: cdk.stringToCloudFormation(properties.clientPasswordAuthType),
        Description: cdk.stringToCloudFormation(properties.description),
        IAMAuth: cdk.stringToCloudFormation(properties.iamAuth),
        SecretArn: cdk.stringToCloudFormation(properties.secretArn),
    };
}
// @ts-ignore TS6133
function CfnDBProxyAuthFormatPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('authScheme', 'AuthScheme', properties.AuthScheme != null ? cfn_parse.FromCloudFormation.getString(properties.AuthScheme) : undefined);
    ret.addPropertyResult('clientPasswordAuthType', 'ClientPasswordAuthType', properties.ClientPasswordAuthType != null ? cfn_parse.FromCloudFormation.getString(properties.ClientPasswordAuthType) : undefined);
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('iamAuth', 'IAMAuth', properties.IAMAuth != null ? cfn_parse.FromCloudFormation.getString(properties.IAMAuth) : undefined);
    ret.addPropertyResult('secretArn', 'SecretArn', properties.SecretArn != null ? cfn_parse.FromCloudFormation.getString(properties.SecretArn) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `TagFormatProperty`
 *
 * @param properties - the TypeScript properties of a `TagFormatProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBProxy_TagFormatPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "TagFormatProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBProxy.TagFormat` resource
 *
 * @param properties - the TypeScript properties of a `TagFormatProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBProxy.TagFormat` resource.
 */
// @ts-ignore TS6133
function cfnDBProxyTagFormatPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBProxy_TagFormatPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnDBProxyTagFormatPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('key', 'Key', properties.Key != null ? cfn_parse.FromCloudFormation.getString(properties.Key) : undefined);
    ret.addPropertyResult('value', 'Value', properties.Value != null ? cfn_parse.FromCloudFormation.getString(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnDBProxyEndpointProps`
 *
 * @param properties - the TypeScript properties of a `CfnDBProxyEndpointProps`
 *
 * @returns the result of the validation.
 */
function CfnDBProxyEndpointPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dbProxyEndpointName', cdk.requiredValidator)(properties.dbProxyEndpointName));
    errors.collect(cdk.propertyValidator('dbProxyEndpointName', cdk.validateString)(properties.dbProxyEndpointName));
    errors.collect(cdk.propertyValidator('dbProxyName', cdk.requiredValidator)(properties.dbProxyName));
    errors.collect(cdk.propertyValidator('dbProxyName', cdk.validateString)(properties.dbProxyName));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(CfnDBProxyEndpoint_TagFormatPropertyValidator))(properties.tags));
    errors.collect(cdk.propertyValidator('targetRole', cdk.validateString)(properties.targetRole));
    errors.collect(cdk.propertyValidator('vpcSecurityGroupIds', cdk.listValidator(cdk.validateString))(properties.vpcSecurityGroupIds));
    errors.collect(cdk.propertyValidator('vpcSubnetIds', cdk.requiredValidator)(properties.vpcSubnetIds));
    errors.collect(cdk.propertyValidator('vpcSubnetIds', cdk.listValidator(cdk.validateString))(properties.vpcSubnetIds));
    return errors.wrap('supplied properties not correct for "CfnDBProxyEndpointProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBProxyEndpoint` resource
 *
 * @param properties - the TypeScript properties of a `CfnDBProxyEndpointProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBProxyEndpoint` resource.
 */
// @ts-ignore TS6133
function cfnDBProxyEndpointPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBProxyEndpointPropsValidator(properties).assertSuccess();
    return {
        DBProxyEndpointName: cdk.stringToCloudFormation(properties.dbProxyEndpointName),
        DBProxyName: cdk.stringToCloudFormation(properties.dbProxyName),
        VpcSubnetIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.vpcSubnetIds),
        Tags: cdk.listMapper(cfnDBProxyEndpointTagFormatPropertyToCloudFormation)(properties.tags),
        TargetRole: cdk.stringToCloudFormation(properties.targetRole),
        VpcSecurityGroupIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.vpcSecurityGroupIds),
    };
}
// @ts-ignore TS6133
function CfnDBProxyEndpointPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dbProxyEndpointName', 'DBProxyEndpointName', cfn_parse.FromCloudFormation.getString(properties.DBProxyEndpointName));
    ret.addPropertyResult('dbProxyName', 'DBProxyName', cfn_parse.FromCloudFormation.getString(properties.DBProxyName));
    ret.addPropertyResult('vpcSubnetIds', 'VpcSubnetIds', cfn_parse.FromCloudFormation.getStringArray(properties.VpcSubnetIds));
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(CfnDBProxyEndpointTagFormatPropertyFromCloudFormation)(properties.Tags) : undefined);
    ret.addPropertyResult('targetRole', 'TargetRole', properties.TargetRole != null ? cfn_parse.FromCloudFormation.getString(properties.TargetRole) : undefined);
    ret.addPropertyResult('vpcSecurityGroupIds', 'VpcSecurityGroupIds', properties.VpcSecurityGroupIds != null ? cfn_parse.FromCloudFormation.getStringArray(properties.VpcSecurityGroupIds) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::DBProxyEndpoint`
 *
 * The `AWS::RDS::DBProxyEndpoint` resource creates or updates a DB proxy endpoint. You can use custom proxy endpoints to access a proxy through a different VPC than the proxy's default VPC.
 *
 * For more information about RDS Proxy, see [AWS::RDS::DBProxy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html) .
 *
 * @cloudformationResource AWS::RDS::DBProxyEndpoint
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxyendpoint.html
 */
class CfnDBProxyEndpoint extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDBProxyEndpointPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDBProxyEndpoint(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::RDS::DBProxyEndpoint`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDBProxyEndpoint.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_CfnDBProxyEndpointProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnDBProxyEndpoint);
            }
            throw error;
        }
        cdk.requireProperty(props, 'dbProxyEndpointName', this);
        cdk.requireProperty(props, 'dbProxyName', this);
        cdk.requireProperty(props, 'vpcSubnetIds', this);
        this.attrDbProxyEndpointArn = cdk.Token.asString(this.getAtt('DBProxyEndpointArn', cdk.ResolutionTypeHint.STRING));
        this.attrEndpoint = cdk.Token.asString(this.getAtt('Endpoint', cdk.ResolutionTypeHint.STRING));
        this.attrIsDefault = this.getAtt('IsDefault', cdk.ResolutionTypeHint.STRING);
        this.attrVpcId = cdk.Token.asString(this.getAtt('VpcId', cdk.ResolutionTypeHint.STRING));
        this.dbProxyEndpointName = props.dbProxyEndpointName;
        this.dbProxyName = props.dbProxyName;
        this.vpcSubnetIds = props.vpcSubnetIds;
        this.tags = props.tags;
        this.targetRole = props.targetRole;
        this.vpcSecurityGroupIds = props.vpcSecurityGroupIds;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDBProxyEndpoint.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            dbProxyEndpointName: this.dbProxyEndpointName,
            dbProxyName: this.dbProxyName,
            vpcSubnetIds: this.vpcSubnetIds,
            tags: this.tags,
            targetRole: this.targetRole,
            vpcSecurityGroupIds: this.vpcSecurityGroupIds,
        };
    }
    renderProperties(props) {
        return cfnDBProxyEndpointPropsToCloudFormation(props);
    }
}
_f = JSII_RTTI_SYMBOL_1;
CfnDBProxyEndpoint[_f] = { fqn: "aws-cdk-lib.aws_rds.CfnDBProxyEndpoint", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDBProxyEndpoint.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBProxyEndpoint";
exports.CfnDBProxyEndpoint = CfnDBProxyEndpoint;
/**
 * Determine whether the given properties match those of a `TagFormatProperty`
 *
 * @param properties - the TypeScript properties of a `TagFormatProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBProxyEndpoint_TagFormatPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "TagFormatProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBProxyEndpoint.TagFormat` resource
 *
 * @param properties - the TypeScript properties of a `TagFormatProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBProxyEndpoint.TagFormat` resource.
 */
// @ts-ignore TS6133
function cfnDBProxyEndpointTagFormatPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBProxyEndpoint_TagFormatPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnDBProxyEndpointTagFormatPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('key', 'Key', properties.Key != null ? cfn_parse.FromCloudFormation.getString(properties.Key) : undefined);
    ret.addPropertyResult('value', 'Value', properties.Value != null ? cfn_parse.FromCloudFormation.getString(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnDBProxyTargetGroupProps`
 *
 * @param properties - the TypeScript properties of a `CfnDBProxyTargetGroupProps`
 *
 * @returns the result of the validation.
 */
function CfnDBProxyTargetGroupPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('connectionPoolConfigurationInfo', CfnDBProxyTargetGroup_ConnectionPoolConfigurationInfoFormatPropertyValidator)(properties.connectionPoolConfigurationInfo));
    errors.collect(cdk.propertyValidator('dbClusterIdentifiers', cdk.listValidator(cdk.validateString))(properties.dbClusterIdentifiers));
    errors.collect(cdk.propertyValidator('dbInstanceIdentifiers', cdk.listValidator(cdk.validateString))(properties.dbInstanceIdentifiers));
    errors.collect(cdk.propertyValidator('dbProxyName', cdk.requiredValidator)(properties.dbProxyName));
    errors.collect(cdk.propertyValidator('dbProxyName', cdk.validateString)(properties.dbProxyName));
    errors.collect(cdk.propertyValidator('targetGroupName', cdk.requiredValidator)(properties.targetGroupName));
    errors.collect(cdk.propertyValidator('targetGroupName', cdk.validateString)(properties.targetGroupName));
    return errors.wrap('supplied properties not correct for "CfnDBProxyTargetGroupProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBProxyTargetGroup` resource
 *
 * @param properties - the TypeScript properties of a `CfnDBProxyTargetGroupProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBProxyTargetGroup` resource.
 */
// @ts-ignore TS6133
function cfnDBProxyTargetGroupPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBProxyTargetGroupPropsValidator(properties).assertSuccess();
    return {
        DBProxyName: cdk.stringToCloudFormation(properties.dbProxyName),
        TargetGroupName: cdk.stringToCloudFormation(properties.targetGroupName),
        ConnectionPoolConfigurationInfo: cfnDBProxyTargetGroupConnectionPoolConfigurationInfoFormatPropertyToCloudFormation(properties.connectionPoolConfigurationInfo),
        DBClusterIdentifiers: cdk.listMapper(cdk.stringToCloudFormation)(properties.dbClusterIdentifiers),
        DBInstanceIdentifiers: cdk.listMapper(cdk.stringToCloudFormation)(properties.dbInstanceIdentifiers),
    };
}
// @ts-ignore TS6133
function CfnDBProxyTargetGroupPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dbProxyName', 'DBProxyName', cfn_parse.FromCloudFormation.getString(properties.DBProxyName));
    ret.addPropertyResult('targetGroupName', 'TargetGroupName', cfn_parse.FromCloudFormation.getString(properties.TargetGroupName));
    ret.addPropertyResult('connectionPoolConfigurationInfo', 'ConnectionPoolConfigurationInfo', properties.ConnectionPoolConfigurationInfo != null ? CfnDBProxyTargetGroupConnectionPoolConfigurationInfoFormatPropertyFromCloudFormation(properties.ConnectionPoolConfigurationInfo) : undefined);
    ret.addPropertyResult('dbClusterIdentifiers', 'DBClusterIdentifiers', properties.DBClusterIdentifiers != null ? cfn_parse.FromCloudFormation.getStringArray(properties.DBClusterIdentifiers) : undefined);
    ret.addPropertyResult('dbInstanceIdentifiers', 'DBInstanceIdentifiers', properties.DBInstanceIdentifiers != null ? cfn_parse.FromCloudFormation.getStringArray(properties.DBInstanceIdentifiers) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::DBProxyTargetGroup`
 *
 * The `AWS::RDS::DBProxyTargetGroup` resource represents a set of RDS DB instances, Aurora DB clusters, or both that a proxy can connect to. Currently, each target group is associated with exactly one RDS DB instance or Aurora DB cluster.
 *
 * This data type is used as a response element in the `DescribeDBProxyTargetGroups` action.
 *
 * For information about RDS Proxy for Amazon RDS, see [Managing Connections with Amazon RDS Proxy](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-proxy.html) in the *Amazon RDS User Guide* .
 *
 * For information about RDS Proxy for Amazon Aurora, see [Managing Connections with Amazon RDS Proxy](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-proxy.html) in the *Amazon Aurora User Guide* .
 *
 * For a sample template that creates a DB proxy and registers a DB instance, see [Examples](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#aws-resource-rds-dbproxy--examples) in AWS::RDS::DBProxy.
 *
 * > Limitations apply to RDS Proxy, including DB engine version limitations and AWS Region limitations.
 * >
 * > For information about limitations that apply to RDS Proxy for Amazon RDS, see [Limitations for RDS Proxy](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-proxy.html#rds-proxy.limitations) in the *Amazon RDS User Guide* .
 * >
 * > For information about that apply to RDS Proxy for Amazon Aurora, see [Limitations for RDS Proxy](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-proxy.html#rds-proxy.limitations) in the *Amazon Aurora User Guide* .
 *
 * @cloudformationResource AWS::RDS::DBProxyTargetGroup
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html
 */
class CfnDBProxyTargetGroup extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDBProxyTargetGroupPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDBProxyTargetGroup(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::RDS::DBProxyTargetGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDBProxyTargetGroup.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_CfnDBProxyTargetGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnDBProxyTargetGroup);
            }
            throw error;
        }
        cdk.requireProperty(props, 'dbProxyName', this);
        cdk.requireProperty(props, 'targetGroupName', this);
        this.attrTargetGroupArn = cdk.Token.asString(this.getAtt('TargetGroupArn', cdk.ResolutionTypeHint.STRING));
        this.dbProxyName = props.dbProxyName;
        this.targetGroupName = props.targetGroupName;
        this.connectionPoolConfigurationInfo = props.connectionPoolConfigurationInfo;
        this.dbClusterIdentifiers = props.dbClusterIdentifiers;
        this.dbInstanceIdentifiers = props.dbInstanceIdentifiers;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDBProxyTargetGroup.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            dbProxyName: this.dbProxyName,
            targetGroupName: this.targetGroupName,
            connectionPoolConfigurationInfo: this.connectionPoolConfigurationInfo,
            dbClusterIdentifiers: this.dbClusterIdentifiers,
            dbInstanceIdentifiers: this.dbInstanceIdentifiers,
        };
    }
    renderProperties(props) {
        return cfnDBProxyTargetGroupPropsToCloudFormation(props);
    }
}
_g = JSII_RTTI_SYMBOL_1;
CfnDBProxyTargetGroup[_g] = { fqn: "aws-cdk-lib.aws_rds.CfnDBProxyTargetGroup", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDBProxyTargetGroup.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBProxyTargetGroup";
exports.CfnDBProxyTargetGroup = CfnDBProxyTargetGroup;
/**
 * Determine whether the given properties match those of a `ConnectionPoolConfigurationInfoFormatProperty`
 *
 * @param properties - the TypeScript properties of a `ConnectionPoolConfigurationInfoFormatProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBProxyTargetGroup_ConnectionPoolConfigurationInfoFormatPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('connectionBorrowTimeout', cdk.validateNumber)(properties.connectionBorrowTimeout));
    errors.collect(cdk.propertyValidator('initQuery', cdk.validateString)(properties.initQuery));
    errors.collect(cdk.propertyValidator('maxConnectionsPercent', cdk.validateNumber)(properties.maxConnectionsPercent));
    errors.collect(cdk.propertyValidator('maxIdleConnectionsPercent', cdk.validateNumber)(properties.maxIdleConnectionsPercent));
    errors.collect(cdk.propertyValidator('sessionPinningFilters', cdk.listValidator(cdk.validateString))(properties.sessionPinningFilters));
    return errors.wrap('supplied properties not correct for "ConnectionPoolConfigurationInfoFormatProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBProxyTargetGroup.ConnectionPoolConfigurationInfoFormat` resource
 *
 * @param properties - the TypeScript properties of a `ConnectionPoolConfigurationInfoFormatProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBProxyTargetGroup.ConnectionPoolConfigurationInfoFormat` resource.
 */
// @ts-ignore TS6133
function cfnDBProxyTargetGroupConnectionPoolConfigurationInfoFormatPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBProxyTargetGroup_ConnectionPoolConfigurationInfoFormatPropertyValidator(properties).assertSuccess();
    return {
        ConnectionBorrowTimeout: cdk.numberToCloudFormation(properties.connectionBorrowTimeout),
        InitQuery: cdk.stringToCloudFormation(properties.initQuery),
        MaxConnectionsPercent: cdk.numberToCloudFormation(properties.maxConnectionsPercent),
        MaxIdleConnectionsPercent: cdk.numberToCloudFormation(properties.maxIdleConnectionsPercent),
        SessionPinningFilters: cdk.listMapper(cdk.stringToCloudFormation)(properties.sessionPinningFilters),
    };
}
// @ts-ignore TS6133
function CfnDBProxyTargetGroupConnectionPoolConfigurationInfoFormatPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('connectionBorrowTimeout', 'ConnectionBorrowTimeout', properties.ConnectionBorrowTimeout != null ? cfn_parse.FromCloudFormation.getNumber(properties.ConnectionBorrowTimeout) : undefined);
    ret.addPropertyResult('initQuery', 'InitQuery', properties.InitQuery != null ? cfn_parse.FromCloudFormation.getString(properties.InitQuery) : undefined);
    ret.addPropertyResult('maxConnectionsPercent', 'MaxConnectionsPercent', properties.MaxConnectionsPercent != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxConnectionsPercent) : undefined);
    ret.addPropertyResult('maxIdleConnectionsPercent', 'MaxIdleConnectionsPercent', properties.MaxIdleConnectionsPercent != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxIdleConnectionsPercent) : undefined);
    ret.addPropertyResult('sessionPinningFilters', 'SessionPinningFilters', properties.SessionPinningFilters != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SessionPinningFilters) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnDBSecurityGroupProps`
 *
 * @param properties - the TypeScript properties of a `CfnDBSecurityGroupProps`
 *
 * @returns the result of the validation.
 */
function CfnDBSecurityGroupPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dbSecurityGroupIngress', cdk.requiredValidator)(properties.dbSecurityGroupIngress));
    errors.collect(cdk.propertyValidator('dbSecurityGroupIngress', cdk.listValidator(CfnDBSecurityGroup_IngressPropertyValidator))(properties.dbSecurityGroupIngress));
    errors.collect(cdk.propertyValidator('ec2VpcId', cdk.validateString)(properties.ec2VpcId));
    errors.collect(cdk.propertyValidator('groupDescription', cdk.requiredValidator)(properties.groupDescription));
    errors.collect(cdk.propertyValidator('groupDescription', cdk.validateString)(properties.groupDescription));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnDBSecurityGroupProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBSecurityGroup` resource
 *
 * @param properties - the TypeScript properties of a `CfnDBSecurityGroupProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBSecurityGroup` resource.
 */
// @ts-ignore TS6133
function cfnDBSecurityGroupPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBSecurityGroupPropsValidator(properties).assertSuccess();
    return {
        DBSecurityGroupIngress: cdk.listMapper(cfnDBSecurityGroupIngressPropertyToCloudFormation)(properties.dbSecurityGroupIngress),
        GroupDescription: cdk.stringToCloudFormation(properties.groupDescription),
        EC2VpcId: cdk.stringToCloudFormation(properties.ec2VpcId),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnDBSecurityGroupPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dbSecurityGroupIngress', 'DBSecurityGroupIngress', cfn_parse.FromCloudFormation.getArray(CfnDBSecurityGroupIngressPropertyFromCloudFormation)(properties.DBSecurityGroupIngress));
    ret.addPropertyResult('groupDescription', 'GroupDescription', cfn_parse.FromCloudFormation.getString(properties.GroupDescription));
    ret.addPropertyResult('ec2VpcId', 'EC2VpcId', properties.EC2VpcId != null ? cfn_parse.FromCloudFormation.getString(properties.EC2VpcId) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::DBSecurityGroup`
 *
 * The `AWS::RDS::DBSecurityGroup` resource creates or updates an Amazon RDS DB security group.
 *
 * > EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that you migrate as soon as possible. For more information, see [Migrate from EC2-Classic to a VPC](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html) in the *Amazon EC2 User Guide* , the blog [EC2-Classic Networking is Retiring – Here’s How to Prepare](https://docs.aws.amazon.com/aws/ec2-classic-is-retiring-heres-how-to-prepare/) , and [Moving a DB instance not in a VPC into a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html) in the *Amazon RDS User Guide* .
 *
 * @cloudformationResource AWS::RDS::DBSecurityGroup
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group.html
 */
class CfnDBSecurityGroup extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDBSecurityGroupPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDBSecurityGroup(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::RDS::DBSecurityGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDBSecurityGroup.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_CfnDBSecurityGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnDBSecurityGroup);
            }
            throw error;
        }
        cdk.requireProperty(props, 'dbSecurityGroupIngress', this);
        cdk.requireProperty(props, 'groupDescription', this);
        this.dbSecurityGroupIngress = props.dbSecurityGroupIngress;
        this.groupDescription = props.groupDescription;
        this.ec2VpcId = props.ec2VpcId;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::RDS::DBSecurityGroup", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDBSecurityGroup.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            dbSecurityGroupIngress: this.dbSecurityGroupIngress,
            groupDescription: this.groupDescription,
            ec2VpcId: this.ec2VpcId,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnDBSecurityGroupPropsToCloudFormation(props);
    }
}
_h = JSII_RTTI_SYMBOL_1;
CfnDBSecurityGroup[_h] = { fqn: "aws-cdk-lib.aws_rds.CfnDBSecurityGroup", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDBSecurityGroup.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBSecurityGroup";
exports.CfnDBSecurityGroup = CfnDBSecurityGroup;
/**
 * Determine whether the given properties match those of a `IngressProperty`
 *
 * @param properties - the TypeScript properties of a `IngressProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBSecurityGroup_IngressPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cidrip', cdk.validateString)(properties.cidrip));
    errors.collect(cdk.propertyValidator('ec2SecurityGroupId', cdk.validateString)(properties.ec2SecurityGroupId));
    errors.collect(cdk.propertyValidator('ec2SecurityGroupName', cdk.validateString)(properties.ec2SecurityGroupName));
    errors.collect(cdk.propertyValidator('ec2SecurityGroupOwnerId', cdk.validateString)(properties.ec2SecurityGroupOwnerId));
    return errors.wrap('supplied properties not correct for "IngressProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBSecurityGroup.Ingress` resource
 *
 * @param properties - the TypeScript properties of a `IngressProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBSecurityGroup.Ingress` resource.
 */
// @ts-ignore TS6133
function cfnDBSecurityGroupIngressPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBSecurityGroup_IngressPropertyValidator(properties).assertSuccess();
    return {
        CIDRIP: cdk.stringToCloudFormation(properties.cidrip),
        EC2SecurityGroupId: cdk.stringToCloudFormation(properties.ec2SecurityGroupId),
        EC2SecurityGroupName: cdk.stringToCloudFormation(properties.ec2SecurityGroupName),
        EC2SecurityGroupOwnerId: cdk.stringToCloudFormation(properties.ec2SecurityGroupOwnerId),
    };
}
// @ts-ignore TS6133
function CfnDBSecurityGroupIngressPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('cidrip', 'CIDRIP', properties.CIDRIP != null ? cfn_parse.FromCloudFormation.getString(properties.CIDRIP) : undefined);
    ret.addPropertyResult('ec2SecurityGroupId', 'EC2SecurityGroupId', properties.EC2SecurityGroupId != null ? cfn_parse.FromCloudFormation.getString(properties.EC2SecurityGroupId) : undefined);
    ret.addPropertyResult('ec2SecurityGroupName', 'EC2SecurityGroupName', properties.EC2SecurityGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.EC2SecurityGroupName) : undefined);
    ret.addPropertyResult('ec2SecurityGroupOwnerId', 'EC2SecurityGroupOwnerId', properties.EC2SecurityGroupOwnerId != null ? cfn_parse.FromCloudFormation.getString(properties.EC2SecurityGroupOwnerId) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnDBSecurityGroupIngressProps`
 *
 * @param properties - the TypeScript properties of a `CfnDBSecurityGroupIngressProps`
 *
 * @returns the result of the validation.
 */
function CfnDBSecurityGroupIngressPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cidrip', cdk.validateString)(properties.cidrip));
    errors.collect(cdk.propertyValidator('dbSecurityGroupName', cdk.requiredValidator)(properties.dbSecurityGroupName));
    errors.collect(cdk.propertyValidator('dbSecurityGroupName', cdk.validateString)(properties.dbSecurityGroupName));
    errors.collect(cdk.propertyValidator('ec2SecurityGroupId', cdk.validateString)(properties.ec2SecurityGroupId));
    errors.collect(cdk.propertyValidator('ec2SecurityGroupName', cdk.validateString)(properties.ec2SecurityGroupName));
    errors.collect(cdk.propertyValidator('ec2SecurityGroupOwnerId', cdk.validateString)(properties.ec2SecurityGroupOwnerId));
    return errors.wrap('supplied properties not correct for "CfnDBSecurityGroupIngressProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBSecurityGroupIngress` resource
 *
 * @param properties - the TypeScript properties of a `CfnDBSecurityGroupIngressProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBSecurityGroupIngress` resource.
 */
// @ts-ignore TS6133
function cfnDBSecurityGroupIngressPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBSecurityGroupIngressPropsValidator(properties).assertSuccess();
    return {
        DBSecurityGroupName: cdk.stringToCloudFormation(properties.dbSecurityGroupName),
        CIDRIP: cdk.stringToCloudFormation(properties.cidrip),
        EC2SecurityGroupId: cdk.stringToCloudFormation(properties.ec2SecurityGroupId),
        EC2SecurityGroupName: cdk.stringToCloudFormation(properties.ec2SecurityGroupName),
        EC2SecurityGroupOwnerId: cdk.stringToCloudFormation(properties.ec2SecurityGroupOwnerId),
    };
}
// @ts-ignore TS6133
function CfnDBSecurityGroupIngressPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dbSecurityGroupName', 'DBSecurityGroupName', cfn_parse.FromCloudFormation.getString(properties.DBSecurityGroupName));
    ret.addPropertyResult('cidrip', 'CIDRIP', properties.CIDRIP != null ? cfn_parse.FromCloudFormation.getString(properties.CIDRIP) : undefined);
    ret.addPropertyResult('ec2SecurityGroupId', 'EC2SecurityGroupId', properties.EC2SecurityGroupId != null ? cfn_parse.FromCloudFormation.getString(properties.EC2SecurityGroupId) : undefined);
    ret.addPropertyResult('ec2SecurityGroupName', 'EC2SecurityGroupName', properties.EC2SecurityGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.EC2SecurityGroupName) : undefined);
    ret.addPropertyResult('ec2SecurityGroupOwnerId', 'EC2SecurityGroupOwnerId', properties.EC2SecurityGroupOwnerId != null ? cfn_parse.FromCloudFormation.getString(properties.EC2SecurityGroupOwnerId) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::DBSecurityGroupIngress`
 *
 * The `AWS::RDS::DBSecurityGroupIngress` resource enables ingress to a DB security group using one of two forms of authorization. First, you can add EC2 or VPC security groups to the DB security group if the application using the database is running on EC2 or VPC instances. Second, IP ranges are available if the application accessing your database is running on the Internet.
 *
 * This type supports updates. For more information about updating stacks, see [AWS CloudFormation Stacks Updates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html) .
 *
 * For details about the settings for DB security group ingress, see [AuthorizeDBSecurityGroupIngress](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_AuthorizeDBSecurityGroupIngress.html) .
 *
 * > EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that you migrate as soon as possible. For more information, see [Migrate from EC2-Classic to a VPC](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html) in the *Amazon EC2 User Guide* , the blog [EC2-Classic Networking is Retiring – Here’s How to Prepare](https://docs.aws.amazon.com/aws/ec2-classic-is-retiring-heres-how-to-prepare/) , and [Moving a DB instance not in a VPC into a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html) in the *Amazon RDS User Guide* .
 *
 * @cloudformationResource AWS::RDS::DBSecurityGroupIngress
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html
 */
class CfnDBSecurityGroupIngress extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDBSecurityGroupIngressPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDBSecurityGroupIngress(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::RDS::DBSecurityGroupIngress`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDBSecurityGroupIngress.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_CfnDBSecurityGroupIngressProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnDBSecurityGroupIngress);
            }
            throw error;
        }
        cdk.requireProperty(props, 'dbSecurityGroupName', this);
        this.dbSecurityGroupName = props.dbSecurityGroupName;
        this.cidrip = props.cidrip;
        this.ec2SecurityGroupId = props.ec2SecurityGroupId;
        this.ec2SecurityGroupName = props.ec2SecurityGroupName;
        this.ec2SecurityGroupOwnerId = props.ec2SecurityGroupOwnerId;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDBSecurityGroupIngress.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            dbSecurityGroupName: this.dbSecurityGroupName,
            cidrip: this.cidrip,
            ec2SecurityGroupId: this.ec2SecurityGroupId,
            ec2SecurityGroupName: this.ec2SecurityGroupName,
            ec2SecurityGroupOwnerId: this.ec2SecurityGroupOwnerId,
        };
    }
    renderProperties(props) {
        return cfnDBSecurityGroupIngressPropsToCloudFormation(props);
    }
}
_j = JSII_RTTI_SYMBOL_1;
CfnDBSecurityGroupIngress[_j] = { fqn: "aws-cdk-lib.aws_rds.CfnDBSecurityGroupIngress", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDBSecurityGroupIngress.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBSecurityGroupIngress";
exports.CfnDBSecurityGroupIngress = CfnDBSecurityGroupIngress;
/**
 * Determine whether the given properties match those of a `CfnDBSubnetGroupProps`
 *
 * @param properties - the TypeScript properties of a `CfnDBSubnetGroupProps`
 *
 * @returns the result of the validation.
 */
function CfnDBSubnetGroupPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dbSubnetGroupDescription', cdk.requiredValidator)(properties.dbSubnetGroupDescription));
    errors.collect(cdk.propertyValidator('dbSubnetGroupDescription', cdk.validateString)(properties.dbSubnetGroupDescription));
    errors.collect(cdk.propertyValidator('dbSubnetGroupName', cdk.validateString)(properties.dbSubnetGroupName));
    errors.collect(cdk.propertyValidator('subnetIds', cdk.requiredValidator)(properties.subnetIds));
    errors.collect(cdk.propertyValidator('subnetIds', cdk.listValidator(cdk.validateString))(properties.subnetIds));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnDBSubnetGroupProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBSubnetGroup` resource
 *
 * @param properties - the TypeScript properties of a `CfnDBSubnetGroupProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBSubnetGroup` resource.
 */
// @ts-ignore TS6133
function cfnDBSubnetGroupPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBSubnetGroupPropsValidator(properties).assertSuccess();
    return {
        DBSubnetGroupDescription: cdk.stringToCloudFormation(properties.dbSubnetGroupDescription),
        SubnetIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.subnetIds),
        DBSubnetGroupName: cdk.stringToCloudFormation(properties.dbSubnetGroupName),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnDBSubnetGroupPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dbSubnetGroupDescription', 'DBSubnetGroupDescription', cfn_parse.FromCloudFormation.getString(properties.DBSubnetGroupDescription));
    ret.addPropertyResult('subnetIds', 'SubnetIds', cfn_parse.FromCloudFormation.getStringArray(properties.SubnetIds));
    ret.addPropertyResult('dbSubnetGroupName', 'DBSubnetGroupName', properties.DBSubnetGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.DBSubnetGroupName) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::DBSubnetGroup`
 *
 * The `AWS::RDS::DBSubnetGroup` resource creates a database subnet group. Subnet groups must contain at least two subnets in two different Availability Zones in the same region.
 *
 * For more information, see [Working with DB subnet groups](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html#USER_VPC.Subnets) in the *Amazon RDS User Guide* .
 *
 * @cloudformationResource AWS::RDS::DBSubnetGroup
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbsubnetgroup.html
 */
class CfnDBSubnetGroup extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDBSubnetGroupPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDBSubnetGroup(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::RDS::DBSubnetGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDBSubnetGroup.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_CfnDBSubnetGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnDBSubnetGroup);
            }
            throw error;
        }
        cdk.requireProperty(props, 'dbSubnetGroupDescription', this);
        cdk.requireProperty(props, 'subnetIds', this);
        this.dbSubnetGroupDescription = props.dbSubnetGroupDescription;
        this.subnetIds = props.subnetIds;
        this.dbSubnetGroupName = props.dbSubnetGroupName;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::RDS::DBSubnetGroup", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDBSubnetGroup.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            dbSubnetGroupDescription: this.dbSubnetGroupDescription,
            subnetIds: this.subnetIds,
            dbSubnetGroupName: this.dbSubnetGroupName,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnDBSubnetGroupPropsToCloudFormation(props);
    }
}
_k = JSII_RTTI_SYMBOL_1;
CfnDBSubnetGroup[_k] = { fqn: "aws-cdk-lib.aws_rds.CfnDBSubnetGroup", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDBSubnetGroup.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBSubnetGroup";
exports.CfnDBSubnetGroup = CfnDBSubnetGroup;
/**
 * Determine whether the given properties match those of a `CfnEventSubscriptionProps`
 *
 * @param properties - the TypeScript properties of a `CfnEventSubscriptionProps`
 *
 * @returns the result of the validation.
 */
function CfnEventSubscriptionPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('enabled', cdk.validateBoolean)(properties.enabled));
    errors.collect(cdk.propertyValidator('eventCategories', cdk.listValidator(cdk.validateString))(properties.eventCategories));
    errors.collect(cdk.propertyValidator('snsTopicArn', cdk.requiredValidator)(properties.snsTopicArn));
    errors.collect(cdk.propertyValidator('snsTopicArn', cdk.validateString)(properties.snsTopicArn));
    errors.collect(cdk.propertyValidator('sourceIds', cdk.listValidator(cdk.validateString))(properties.sourceIds));
    errors.collect(cdk.propertyValidator('sourceType', cdk.validateString)(properties.sourceType));
    errors.collect(cdk.propertyValidator('subscriptionName', cdk.validateString)(properties.subscriptionName));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnEventSubscriptionProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::EventSubscription` resource
 *
 * @param properties - the TypeScript properties of a `CfnEventSubscriptionProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::EventSubscription` resource.
 */
// @ts-ignore TS6133
function cfnEventSubscriptionPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEventSubscriptionPropsValidator(properties).assertSuccess();
    return {
        SnsTopicArn: cdk.stringToCloudFormation(properties.snsTopicArn),
        Enabled: cdk.booleanToCloudFormation(properties.enabled),
        EventCategories: cdk.listMapper(cdk.stringToCloudFormation)(properties.eventCategories),
        SourceIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.sourceIds),
        SourceType: cdk.stringToCloudFormation(properties.sourceType),
        SubscriptionName: cdk.stringToCloudFormation(properties.subscriptionName),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnEventSubscriptionPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('snsTopicArn', 'SnsTopicArn', cfn_parse.FromCloudFormation.getString(properties.SnsTopicArn));
    ret.addPropertyResult('enabled', 'Enabled', properties.Enabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Enabled) : undefined);
    ret.addPropertyResult('eventCategories', 'EventCategories', properties.EventCategories != null ? cfn_parse.FromCloudFormation.getStringArray(properties.EventCategories) : undefined);
    ret.addPropertyResult('sourceIds', 'SourceIds', properties.SourceIds != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SourceIds) : undefined);
    ret.addPropertyResult('sourceType', 'SourceType', properties.SourceType != null ? cfn_parse.FromCloudFormation.getString(properties.SourceType) : undefined);
    ret.addPropertyResult('subscriptionName', 'SubscriptionName', properties.SubscriptionName != null ? cfn_parse.FromCloudFormation.getString(properties.SubscriptionName) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::EventSubscription`
 *
 * The `AWS::RDS::EventSubscription` resource allows you to receive notifications for Amazon Relational Database Service events through the Amazon Simple Notification Service (Amazon SNS). For more information, see [Using Amazon RDS Event Notification](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html) in the *Amazon RDS User Guide* .
 *
 * @cloudformationResource AWS::RDS::EventSubscription
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html
 */
class CfnEventSubscription extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnEventSubscriptionPropsFromCloudFormation(resourceProperties);
        const ret = new CfnEventSubscription(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::RDS::EventSubscription`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnEventSubscription.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_CfnEventSubscriptionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnEventSubscription);
            }
            throw error;
        }
        cdk.requireProperty(props, 'snsTopicArn', this);
        this.snsTopicArn = props.snsTopicArn;
        this.enabled = props.enabled;
        this.eventCategories = props.eventCategories;
        this.sourceIds = props.sourceIds;
        this.sourceType = props.sourceType;
        this.subscriptionName = props.subscriptionName;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::RDS::EventSubscription", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnEventSubscription.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            snsTopicArn: this.snsTopicArn,
            enabled: this.enabled,
            eventCategories: this.eventCategories,
            sourceIds: this.sourceIds,
            sourceType: this.sourceType,
            subscriptionName: this.subscriptionName,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnEventSubscriptionPropsToCloudFormation(props);
    }
}
_l = JSII_RTTI_SYMBOL_1;
CfnEventSubscription[_l] = { fqn: "aws-cdk-lib.aws_rds.CfnEventSubscription", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnEventSubscription.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::EventSubscription";
exports.CfnEventSubscription = CfnEventSubscription;
/**
 * Determine whether the given properties match those of a `CfnGlobalClusterProps`
 *
 * @param properties - the TypeScript properties of a `CfnGlobalClusterProps`
 *
 * @returns the result of the validation.
 */
function CfnGlobalClusterPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('deletionProtection', cdk.validateBoolean)(properties.deletionProtection));
    errors.collect(cdk.propertyValidator('engine', cdk.validateString)(properties.engine));
    errors.collect(cdk.propertyValidator('engineVersion', cdk.validateString)(properties.engineVersion));
    errors.collect(cdk.propertyValidator('globalClusterIdentifier', cdk.validateString)(properties.globalClusterIdentifier));
    errors.collect(cdk.propertyValidator('sourceDbClusterIdentifier', cdk.validateString)(properties.sourceDbClusterIdentifier));
    errors.collect(cdk.propertyValidator('storageEncrypted', cdk.validateBoolean)(properties.storageEncrypted));
    return errors.wrap('supplied properties not correct for "CfnGlobalClusterProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::GlobalCluster` resource
 *
 * @param properties - the TypeScript properties of a `CfnGlobalClusterProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::GlobalCluster` resource.
 */
// @ts-ignore TS6133
function cfnGlobalClusterPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGlobalClusterPropsValidator(properties).assertSuccess();
    return {
        DeletionProtection: cdk.booleanToCloudFormation(properties.deletionProtection),
        Engine: cdk.stringToCloudFormation(properties.engine),
        EngineVersion: cdk.stringToCloudFormation(properties.engineVersion),
        GlobalClusterIdentifier: cdk.stringToCloudFormation(properties.globalClusterIdentifier),
        SourceDBClusterIdentifier: cdk.stringToCloudFormation(properties.sourceDbClusterIdentifier),
        StorageEncrypted: cdk.booleanToCloudFormation(properties.storageEncrypted),
    };
}
// @ts-ignore TS6133
function CfnGlobalClusterPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('deletionProtection', 'DeletionProtection', properties.DeletionProtection != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DeletionProtection) : undefined);
    ret.addPropertyResult('engine', 'Engine', properties.Engine != null ? cfn_parse.FromCloudFormation.getString(properties.Engine) : undefined);
    ret.addPropertyResult('engineVersion', 'EngineVersion', properties.EngineVersion != null ? cfn_parse.FromCloudFormation.getString(properties.EngineVersion) : undefined);
    ret.addPropertyResult('globalClusterIdentifier', 'GlobalClusterIdentifier', properties.GlobalClusterIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.GlobalClusterIdentifier) : undefined);
    ret.addPropertyResult('sourceDbClusterIdentifier', 'SourceDBClusterIdentifier', properties.SourceDBClusterIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.SourceDBClusterIdentifier) : undefined);
    ret.addPropertyResult('storageEncrypted', 'StorageEncrypted', properties.StorageEncrypted != null ? cfn_parse.FromCloudFormation.getBoolean(properties.StorageEncrypted) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::GlobalCluster`
 *
 * The `AWS::RDS::GlobalCluster` resource creates or updates an Amazon Aurora global database spread across multiple AWS Regions.
 *
 * The global database contains a single primary cluster with read-write capability, and a read-only secondary cluster that receives data from the primary cluster through high-speed replication performed by the Aurora storage subsystem.
 *
 * You can create a global database that is initially empty, and then add a primary cluster and a secondary cluster to it.
 *
 * For information about Aurora global databases, see [Working with Amazon Aurora Global Databases](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html) in the *Amazon Aurora User Guide* .
 *
 * @cloudformationResource AWS::RDS::GlobalCluster
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html
 */
class CfnGlobalCluster extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnGlobalClusterPropsFromCloudFormation(resourceProperties);
        const ret = new CfnGlobalCluster(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::RDS::GlobalCluster`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnGlobalCluster.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_CfnGlobalClusterProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnGlobalCluster);
            }
            throw error;
        }
        this.deletionProtection = props.deletionProtection;
        this.engine = props.engine;
        this.engineVersion = props.engineVersion;
        this.globalClusterIdentifier = props.globalClusterIdentifier;
        this.sourceDbClusterIdentifier = props.sourceDbClusterIdentifier;
        this.storageEncrypted = props.storageEncrypted;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnGlobalCluster.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            deletionProtection: this.deletionProtection,
            engine: this.engine,
            engineVersion: this.engineVersion,
            globalClusterIdentifier: this.globalClusterIdentifier,
            sourceDbClusterIdentifier: this.sourceDbClusterIdentifier,
            storageEncrypted: this.storageEncrypted,
        };
    }
    renderProperties(props) {
        return cfnGlobalClusterPropsToCloudFormation(props);
    }
}
_m = JSII_RTTI_SYMBOL_1;
CfnGlobalCluster[_m] = { fqn: "aws-cdk-lib.aws_rds.CfnGlobalCluster", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnGlobalCluster.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::GlobalCluster";
exports.CfnGlobalCluster = CfnGlobalCluster;
/**
 * Determine whether the given properties match those of a `CfnOptionGroupProps`
 *
 * @param properties - the TypeScript properties of a `CfnOptionGroupProps`
 *
 * @returns the result of the validation.
 */
function CfnOptionGroupPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('engineName', cdk.requiredValidator)(properties.engineName));
    errors.collect(cdk.propertyValidator('engineName', cdk.validateString)(properties.engineName));
    errors.collect(cdk.propertyValidator('majorEngineVersion', cdk.requiredValidator)(properties.majorEngineVersion));
    errors.collect(cdk.propertyValidator('majorEngineVersion', cdk.validateString)(properties.majorEngineVersion));
    errors.collect(cdk.propertyValidator('optionConfigurations', cdk.listValidator(CfnOptionGroup_OptionConfigurationPropertyValidator))(properties.optionConfigurations));
    errors.collect(cdk.propertyValidator('optionGroupDescription', cdk.requiredValidator)(properties.optionGroupDescription));
    errors.collect(cdk.propertyValidator('optionGroupDescription', cdk.validateString)(properties.optionGroupDescription));
    errors.collect(cdk.propertyValidator('optionGroupName', cdk.validateString)(properties.optionGroupName));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnOptionGroupProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::OptionGroup` resource
 *
 * @param properties - the TypeScript properties of a `CfnOptionGroupProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::OptionGroup` resource.
 */
// @ts-ignore TS6133
function cfnOptionGroupPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnOptionGroupPropsValidator(properties).assertSuccess();
    return {
        EngineName: cdk.stringToCloudFormation(properties.engineName),
        MajorEngineVersion: cdk.stringToCloudFormation(properties.majorEngineVersion),
        OptionGroupDescription: cdk.stringToCloudFormation(properties.optionGroupDescription),
        OptionConfigurations: cdk.listMapper(cfnOptionGroupOptionConfigurationPropertyToCloudFormation)(properties.optionConfigurations),
        OptionGroupName: cdk.stringToCloudFormation(properties.optionGroupName),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnOptionGroupPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('engineName', 'EngineName', cfn_parse.FromCloudFormation.getString(properties.EngineName));
    ret.addPropertyResult('majorEngineVersion', 'MajorEngineVersion', cfn_parse.FromCloudFormation.getString(properties.MajorEngineVersion));
    ret.addPropertyResult('optionGroupDescription', 'OptionGroupDescription', cfn_parse.FromCloudFormation.getString(properties.OptionGroupDescription));
    ret.addPropertyResult('optionConfigurations', 'OptionConfigurations', properties.OptionConfigurations != null ? cfn_parse.FromCloudFormation.getArray(CfnOptionGroupOptionConfigurationPropertyFromCloudFormation)(properties.OptionConfigurations) : undefined);
    ret.addPropertyResult('optionGroupName', 'OptionGroupName', properties.OptionGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.OptionGroupName) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::OptionGroup`
 *
 * The `AWS::RDS::OptionGroup` resource creates or updates an option group, to enable and configure features that are specific to a particular DB engine.
 *
 * @cloudformationResource AWS::RDS::OptionGroup
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html
 */
class CfnOptionGroup extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnOptionGroupPropsFromCloudFormation(resourceProperties);
        const ret = new CfnOptionGroup(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::RDS::OptionGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnOptionGroup.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_CfnOptionGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnOptionGroup);
            }
            throw error;
        }
        cdk.requireProperty(props, 'engineName', this);
        cdk.requireProperty(props, 'majorEngineVersion', this);
        cdk.requireProperty(props, 'optionGroupDescription', this);
        this.engineName = props.engineName;
        this.majorEngineVersion = props.majorEngineVersion;
        this.optionGroupDescription = props.optionGroupDescription;
        this.optionConfigurations = props.optionConfigurations;
        this.optionGroupName = props.optionGroupName;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::RDS::OptionGroup", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnOptionGroup.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            engineName: this.engineName,
            majorEngineVersion: this.majorEngineVersion,
            optionGroupDescription: this.optionGroupDescription,
            optionConfigurations: this.optionConfigurations,
            optionGroupName: this.optionGroupName,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnOptionGroupPropsToCloudFormation(props);
    }
}
_o = JSII_RTTI_SYMBOL_1;
CfnOptionGroup[_o] = { fqn: "aws-cdk-lib.aws_rds.CfnOptionGroup", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnOptionGroup.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::OptionGroup";
exports.CfnOptionGroup = CfnOptionGroup;
/**
 * Determine whether the given properties match those of a `OptionConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `OptionConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnOptionGroup_OptionConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dbSecurityGroupMemberships', cdk.listValidator(cdk.validateString))(properties.dbSecurityGroupMemberships));
    errors.collect(cdk.propertyValidator('optionName', cdk.requiredValidator)(properties.optionName));
    errors.collect(cdk.propertyValidator('optionName', cdk.validateString)(properties.optionName));
    errors.collect(cdk.propertyValidator('optionSettings', cdk.listValidator(CfnOptionGroup_OptionSettingPropertyValidator))(properties.optionSettings));
    errors.collect(cdk.propertyValidator('optionVersion', cdk.validateString)(properties.optionVersion));
    errors.collect(cdk.propertyValidator('port', cdk.validateNumber)(properties.port));
    errors.collect(cdk.propertyValidator('vpcSecurityGroupMemberships', cdk.listValidator(cdk.validateString))(properties.vpcSecurityGroupMemberships));
    return errors.wrap('supplied properties not correct for "OptionConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::OptionGroup.OptionConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `OptionConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::OptionGroup.OptionConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnOptionGroupOptionConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnOptionGroup_OptionConfigurationPropertyValidator(properties).assertSuccess();
    return {
        DBSecurityGroupMemberships: cdk.listMapper(cdk.stringToCloudFormation)(properties.dbSecurityGroupMemberships),
        OptionName: cdk.stringToCloudFormation(properties.optionName),
        OptionSettings: cdk.listMapper(cfnOptionGroupOptionSettingPropertyToCloudFormation)(properties.optionSettings),
        OptionVersion: cdk.stringToCloudFormation(properties.optionVersion),
        Port: cdk.numberToCloudFormation(properties.port),
        VpcSecurityGroupMemberships: cdk.listMapper(cdk.stringToCloudFormation)(properties.vpcSecurityGroupMemberships),
    };
}
// @ts-ignore TS6133
function CfnOptionGroupOptionConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dbSecurityGroupMemberships', 'DBSecurityGroupMemberships', properties.DBSecurityGroupMemberships != null ? cfn_parse.FromCloudFormation.getStringArray(properties.DBSecurityGroupMemberships) : undefined);
    ret.addPropertyResult('optionName', 'OptionName', cfn_parse.FromCloudFormation.getString(properties.OptionName));
    ret.addPropertyResult('optionSettings', 'OptionSettings', properties.OptionSettings != null ? cfn_parse.FromCloudFormation.getArray(CfnOptionGroupOptionSettingPropertyFromCloudFormation)(properties.OptionSettings) : undefined);
    ret.addPropertyResult('optionVersion', 'OptionVersion', properties.OptionVersion != null ? cfn_parse.FromCloudFormation.getString(properties.OptionVersion) : undefined);
    ret.addPropertyResult('port', 'Port', properties.Port != null ? cfn_parse.FromCloudFormation.getNumber(properties.Port) : undefined);
    ret.addPropertyResult('vpcSecurityGroupMemberships', 'VpcSecurityGroupMemberships', properties.VpcSecurityGroupMemberships != null ? cfn_parse.FromCloudFormation.getStringArray(properties.VpcSecurityGroupMemberships) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `OptionSettingProperty`
 *
 * @param properties - the TypeScript properties of a `OptionSettingProperty`
 *
 * @returns the result of the validation.
 */
function CfnOptionGroup_OptionSettingPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "OptionSettingProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::OptionGroup.OptionSetting` resource
 *
 * @param properties - the TypeScript properties of a `OptionSettingProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::OptionGroup.OptionSetting` resource.
 */
// @ts-ignore TS6133
function cfnOptionGroupOptionSettingPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnOptionGroup_OptionSettingPropertyValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnOptionGroupOptionSettingPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('value', 'Value', properties.Value != null ? cfn_parse.FromCloudFormation.getString(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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