"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubnetGroup = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("../../aws-ec2");
const core_1 = require("../../core");
const rds_generated_1 = require("./rds.generated");
/**
 * Class for creating a RDS DB subnet group
 *
 * @resource AWS::RDS::DBSubnetGroup
 */
class SubnetGroup extends core_1.Resource {
    /**
     * Imports an existing subnet group by name.
     */
    static fromSubnetGroupName(scope, id, subnetGroupName) {
        return new class extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.subnetGroupName = subnetGroupName;
            }
        }(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_SubnetGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SubnetGroup);
            }
            throw error;
        }
        const { subnetIds } = props.vpc.selectSubnets(props.vpcSubnets ?? { subnetType: ec2.SubnetType.PRIVATE_WITH_EGRESS });
        // Using 'Default' as the resource id for historical reasons (usage from `Instance` and `Cluster`).
        const subnetGroup = new rds_generated_1.CfnDBSubnetGroup(this, 'Default', {
            dbSubnetGroupDescription: props.description,
            // names are actually stored by RDS changed to lowercase on the server side,
            // and not lowercasing them in CloudFormation means things like { Ref }
            // do not work correctly
            dbSubnetGroupName: core_1.Token.isUnresolved(props.subnetGroupName)
                ? props.subnetGroupName
                : props.subnetGroupName?.toLowerCase(),
            subnetIds,
        });
        if (props.removalPolicy) {
            subnetGroup.applyRemovalPolicy(props.removalPolicy);
        }
        this.subnetGroupName = subnetGroup.ref;
    }
}
_a = JSII_RTTI_SYMBOL_1;
SubnetGroup[_a] = { fqn: "aws-cdk-lib.aws_rds.SubnetGroup", version: "2.74.0" };
exports.SubnetGroup = SubnetGroup;
//# sourceMappingURL=data:application/json;base64,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