"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnResiliencyPolicy = exports.CfnApp = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core");
const cfn_parse = require("../../core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnAppProps`
 *
 * @param properties - the TypeScript properties of a `CfnAppProps`
 *
 * @returns the result of the validation.
 */
function CfnAppPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('appAssessmentSchedule', cdk.validateString)(properties.appAssessmentSchedule));
    errors.collect(cdk.propertyValidator('appTemplateBody', cdk.requiredValidator)(properties.appTemplateBody));
    errors.collect(cdk.propertyValidator('appTemplateBody', cdk.validateString)(properties.appTemplateBody));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('resiliencyPolicyArn', cdk.validateString)(properties.resiliencyPolicyArn));
    errors.collect(cdk.propertyValidator('resourceMappings', cdk.requiredValidator)(properties.resourceMappings));
    errors.collect(cdk.propertyValidator('resourceMappings', cdk.listValidator(CfnApp_ResourceMappingPropertyValidator))(properties.resourceMappings));
    errors.collect(cdk.propertyValidator('tags', cdk.hashValidator(cdk.validateString))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnAppProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ResilienceHub::App` resource
 *
 * @param properties - the TypeScript properties of a `CfnAppProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ResilienceHub::App` resource.
 */
// @ts-ignore TS6133
function cfnAppPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAppPropsValidator(properties).assertSuccess();
    return {
        AppTemplateBody: cdk.stringToCloudFormation(properties.appTemplateBody),
        Name: cdk.stringToCloudFormation(properties.name),
        ResourceMappings: cdk.listMapper(cfnAppResourceMappingPropertyToCloudFormation)(properties.resourceMappings),
        AppAssessmentSchedule: cdk.stringToCloudFormation(properties.appAssessmentSchedule),
        Description: cdk.stringToCloudFormation(properties.description),
        ResiliencyPolicyArn: cdk.stringToCloudFormation(properties.resiliencyPolicyArn),
        Tags: cdk.hashMapper(cdk.stringToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnAppPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('appTemplateBody', 'AppTemplateBody', cfn_parse.FromCloudFormation.getString(properties.AppTemplateBody));
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('resourceMappings', 'ResourceMappings', cfn_parse.FromCloudFormation.getArray(CfnAppResourceMappingPropertyFromCloudFormation)(properties.ResourceMappings));
    ret.addPropertyResult('appAssessmentSchedule', 'AppAssessmentSchedule', properties.AppAssessmentSchedule != null ? cfn_parse.FromCloudFormation.getString(properties.AppAssessmentSchedule) : undefined);
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('resiliencyPolicyArn', 'ResiliencyPolicyArn', properties.ResiliencyPolicyArn != null ? cfn_parse.FromCloudFormation.getString(properties.ResiliencyPolicyArn) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getMap(cfn_parse.FromCloudFormation.getString)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::ResilienceHub::App`
 *
 * Creates an AWS Resilience Hub application. An AWS Resilience Hub application is a collection of AWS resources structured to prevent and recover AWS application disruptions. To describe a AWS Resilience Hub application, you provide an application name, resources from one or more–up to 20– AWS CloudFormation stacks, and an appropriate resiliency policy.
 *
 * After you create an AWS Resilience Hub application, you publish it so that you can run a resiliency assessment on it. You can then use recommendations from the assessment to improve resiliency by running another assessment, comparing results, and then iterating the process until you achieve your goals for recovery time objective (RTO) and recovery point objective (RPO).
 *
 * @cloudformationResource AWS::ResilienceHub::App
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html
 */
class CfnApp extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnAppPropsFromCloudFormation(resourceProperties);
        const ret = new CfnApp(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::ResilienceHub::App`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnApp.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_resiliencehub_CfnAppProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnApp);
            }
            throw error;
        }
        cdk.requireProperty(props, 'appTemplateBody', this);
        cdk.requireProperty(props, 'name', this);
        cdk.requireProperty(props, 'resourceMappings', this);
        this.attrAppArn = cdk.Token.asString(this.getAtt('AppArn', cdk.ResolutionTypeHint.STRING));
        this.appTemplateBody = props.appTemplateBody;
        this.name = props.name;
        this.resourceMappings = props.resourceMappings;
        this.appAssessmentSchedule = props.appAssessmentSchedule;
        this.description = props.description;
        this.resiliencyPolicyArn = props.resiliencyPolicyArn;
        this.tags = new cdk.TagManager(cdk.TagType.MAP, "AWS::ResilienceHub::App", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnApp.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            appTemplateBody: this.appTemplateBody,
            name: this.name,
            resourceMappings: this.resourceMappings,
            appAssessmentSchedule: this.appAssessmentSchedule,
            description: this.description,
            resiliencyPolicyArn: this.resiliencyPolicyArn,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnAppPropsToCloudFormation(props);
    }
}
_a = JSII_RTTI_SYMBOL_1;
CfnApp[_a] = { fqn: "aws-cdk-lib.aws_resiliencehub.CfnApp", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnApp.CFN_RESOURCE_TYPE_NAME = "AWS::ResilienceHub::App";
exports.CfnApp = CfnApp;
/**
 * Determine whether the given properties match those of a `PhysicalResourceIdProperty`
 *
 * @param properties - the TypeScript properties of a `PhysicalResourceIdProperty`
 *
 * @returns the result of the validation.
 */
function CfnApp_PhysicalResourceIdPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('awsAccountId', cdk.validateString)(properties.awsAccountId));
    errors.collect(cdk.propertyValidator('awsRegion', cdk.validateString)(properties.awsRegion));
    errors.collect(cdk.propertyValidator('identifier', cdk.requiredValidator)(properties.identifier));
    errors.collect(cdk.propertyValidator('identifier', cdk.validateString)(properties.identifier));
    errors.collect(cdk.propertyValidator('type', cdk.requiredValidator)(properties.type));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    return errors.wrap('supplied properties not correct for "PhysicalResourceIdProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ResilienceHub::App.PhysicalResourceId` resource
 *
 * @param properties - the TypeScript properties of a `PhysicalResourceIdProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ResilienceHub::App.PhysicalResourceId` resource.
 */
// @ts-ignore TS6133
function cfnAppPhysicalResourceIdPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnApp_PhysicalResourceIdPropertyValidator(properties).assertSuccess();
    return {
        AwsAccountId: cdk.stringToCloudFormation(properties.awsAccountId),
        AwsRegion: cdk.stringToCloudFormation(properties.awsRegion),
        Identifier: cdk.stringToCloudFormation(properties.identifier),
        Type: cdk.stringToCloudFormation(properties.type),
    };
}
// @ts-ignore TS6133
function CfnAppPhysicalResourceIdPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('awsAccountId', 'AwsAccountId', properties.AwsAccountId != null ? cfn_parse.FromCloudFormation.getString(properties.AwsAccountId) : undefined);
    ret.addPropertyResult('awsRegion', 'AwsRegion', properties.AwsRegion != null ? cfn_parse.FromCloudFormation.getString(properties.AwsRegion) : undefined);
    ret.addPropertyResult('identifier', 'Identifier', cfn_parse.FromCloudFormation.getString(properties.Identifier));
    ret.addPropertyResult('type', 'Type', cfn_parse.FromCloudFormation.getString(properties.Type));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ResourceMappingProperty`
 *
 * @param properties - the TypeScript properties of a `ResourceMappingProperty`
 *
 * @returns the result of the validation.
 */
function CfnApp_ResourceMappingPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('logicalStackName', cdk.validateString)(properties.logicalStackName));
    errors.collect(cdk.propertyValidator('mappingType', cdk.requiredValidator)(properties.mappingType));
    errors.collect(cdk.propertyValidator('mappingType', cdk.validateString)(properties.mappingType));
    errors.collect(cdk.propertyValidator('physicalResourceId', cdk.requiredValidator)(properties.physicalResourceId));
    errors.collect(cdk.propertyValidator('physicalResourceId', CfnApp_PhysicalResourceIdPropertyValidator)(properties.physicalResourceId));
    errors.collect(cdk.propertyValidator('resourceName', cdk.validateString)(properties.resourceName));
    errors.collect(cdk.propertyValidator('terraformSourceName', cdk.validateString)(properties.terraformSourceName));
    return errors.wrap('supplied properties not correct for "ResourceMappingProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ResilienceHub::App.ResourceMapping` resource
 *
 * @param properties - the TypeScript properties of a `ResourceMappingProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ResilienceHub::App.ResourceMapping` resource.
 */
// @ts-ignore TS6133
function cfnAppResourceMappingPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnApp_ResourceMappingPropertyValidator(properties).assertSuccess();
    return {
        LogicalStackName: cdk.stringToCloudFormation(properties.logicalStackName),
        MappingType: cdk.stringToCloudFormation(properties.mappingType),
        PhysicalResourceId: cfnAppPhysicalResourceIdPropertyToCloudFormation(properties.physicalResourceId),
        ResourceName: cdk.stringToCloudFormation(properties.resourceName),
        TerraformSourceName: cdk.stringToCloudFormation(properties.terraformSourceName),
    };
}
// @ts-ignore TS6133
function CfnAppResourceMappingPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('logicalStackName', 'LogicalStackName', properties.LogicalStackName != null ? cfn_parse.FromCloudFormation.getString(properties.LogicalStackName) : undefined);
    ret.addPropertyResult('mappingType', 'MappingType', cfn_parse.FromCloudFormation.getString(properties.MappingType));
    ret.addPropertyResult('physicalResourceId', 'PhysicalResourceId', CfnAppPhysicalResourceIdPropertyFromCloudFormation(properties.PhysicalResourceId));
    ret.addPropertyResult('resourceName', 'ResourceName', properties.ResourceName != null ? cfn_parse.FromCloudFormation.getString(properties.ResourceName) : undefined);
    ret.addPropertyResult('terraformSourceName', 'TerraformSourceName', properties.TerraformSourceName != null ? cfn_parse.FromCloudFormation.getString(properties.TerraformSourceName) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnResiliencyPolicyProps`
 *
 * @param properties - the TypeScript properties of a `CfnResiliencyPolicyProps`
 *
 * @returns the result of the validation.
 */
function CfnResiliencyPolicyPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dataLocationConstraint', cdk.validateString)(properties.dataLocationConstraint));
    errors.collect(cdk.propertyValidator('policy', cdk.requiredValidator)(properties.policy));
    errors.collect(cdk.propertyValidator('policy', cdk.hashValidator(CfnResiliencyPolicy_FailurePolicyPropertyValidator))(properties.policy));
    errors.collect(cdk.propertyValidator('policyDescription', cdk.validateString)(properties.policyDescription));
    errors.collect(cdk.propertyValidator('policyName', cdk.requiredValidator)(properties.policyName));
    errors.collect(cdk.propertyValidator('policyName', cdk.validateString)(properties.policyName));
    errors.collect(cdk.propertyValidator('tags', cdk.hashValidator(cdk.validateString))(properties.tags));
    errors.collect(cdk.propertyValidator('tier', cdk.requiredValidator)(properties.tier));
    errors.collect(cdk.propertyValidator('tier', cdk.validateString)(properties.tier));
    return errors.wrap('supplied properties not correct for "CfnResiliencyPolicyProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ResilienceHub::ResiliencyPolicy` resource
 *
 * @param properties - the TypeScript properties of a `CfnResiliencyPolicyProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ResilienceHub::ResiliencyPolicy` resource.
 */
// @ts-ignore TS6133
function cfnResiliencyPolicyPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnResiliencyPolicyPropsValidator(properties).assertSuccess();
    return {
        Policy: cdk.hashMapper(cfnResiliencyPolicyFailurePolicyPropertyToCloudFormation)(properties.policy),
        PolicyName: cdk.stringToCloudFormation(properties.policyName),
        Tier: cdk.stringToCloudFormation(properties.tier),
        DataLocationConstraint: cdk.stringToCloudFormation(properties.dataLocationConstraint),
        PolicyDescription: cdk.stringToCloudFormation(properties.policyDescription),
        Tags: cdk.hashMapper(cdk.stringToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnResiliencyPolicyPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('policy', 'Policy', cfn_parse.FromCloudFormation.getMap(CfnResiliencyPolicyFailurePolicyPropertyFromCloudFormation)(properties.Policy));
    ret.addPropertyResult('policyName', 'PolicyName', cfn_parse.FromCloudFormation.getString(properties.PolicyName));
    ret.addPropertyResult('tier', 'Tier', cfn_parse.FromCloudFormation.getString(properties.Tier));
    ret.addPropertyResult('dataLocationConstraint', 'DataLocationConstraint', properties.DataLocationConstraint != null ? cfn_parse.FromCloudFormation.getString(properties.DataLocationConstraint) : undefined);
    ret.addPropertyResult('policyDescription', 'PolicyDescription', properties.PolicyDescription != null ? cfn_parse.FromCloudFormation.getString(properties.PolicyDescription) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getMap(cfn_parse.FromCloudFormation.getString)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::ResilienceHub::ResiliencyPolicy`
 *
 * Defines a resiliency policy.
 *
 * @cloudformationResource AWS::ResilienceHub::ResiliencyPolicy
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html
 */
class CfnResiliencyPolicy extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnResiliencyPolicyPropsFromCloudFormation(resourceProperties);
        const ret = new CfnResiliencyPolicy(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::ResilienceHub::ResiliencyPolicy`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnResiliencyPolicy.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_resiliencehub_CfnResiliencyPolicyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnResiliencyPolicy);
            }
            throw error;
        }
        cdk.requireProperty(props, 'policy', this);
        cdk.requireProperty(props, 'policyName', this);
        cdk.requireProperty(props, 'tier', this);
        this.attrPolicyArn = cdk.Token.asString(this.getAtt('PolicyArn', cdk.ResolutionTypeHint.STRING));
        this.policy = props.policy;
        this.policyName = props.policyName;
        this.tier = props.tier;
        this.dataLocationConstraint = props.dataLocationConstraint;
        this.policyDescription = props.policyDescription;
        this.tags = new cdk.TagManager(cdk.TagType.MAP, "AWS::ResilienceHub::ResiliencyPolicy", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnResiliencyPolicy.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            policy: this.policy,
            policyName: this.policyName,
            tier: this.tier,
            dataLocationConstraint: this.dataLocationConstraint,
            policyDescription: this.policyDescription,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnResiliencyPolicyPropsToCloudFormation(props);
    }
}
_b = JSII_RTTI_SYMBOL_1;
CfnResiliencyPolicy[_b] = { fqn: "aws-cdk-lib.aws_resiliencehub.CfnResiliencyPolicy", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnResiliencyPolicy.CFN_RESOURCE_TYPE_NAME = "AWS::ResilienceHub::ResiliencyPolicy";
exports.CfnResiliencyPolicy = CfnResiliencyPolicy;
/**
 * Determine whether the given properties match those of a `FailurePolicyProperty`
 *
 * @param properties - the TypeScript properties of a `FailurePolicyProperty`
 *
 * @returns the result of the validation.
 */
function CfnResiliencyPolicy_FailurePolicyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('rpoInSecs', cdk.requiredValidator)(properties.rpoInSecs));
    errors.collect(cdk.propertyValidator('rpoInSecs', cdk.validateNumber)(properties.rpoInSecs));
    errors.collect(cdk.propertyValidator('rtoInSecs', cdk.requiredValidator)(properties.rtoInSecs));
    errors.collect(cdk.propertyValidator('rtoInSecs', cdk.validateNumber)(properties.rtoInSecs));
    return errors.wrap('supplied properties not correct for "FailurePolicyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ResilienceHub::ResiliencyPolicy.FailurePolicy` resource
 *
 * @param properties - the TypeScript properties of a `FailurePolicyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ResilienceHub::ResiliencyPolicy.FailurePolicy` resource.
 */
// @ts-ignore TS6133
function cfnResiliencyPolicyFailurePolicyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnResiliencyPolicy_FailurePolicyPropertyValidator(properties).assertSuccess();
    return {
        RpoInSecs: cdk.numberToCloudFormation(properties.rpoInSecs),
        RtoInSecs: cdk.numberToCloudFormation(properties.rtoInSecs),
    };
}
// @ts-ignore TS6133
function CfnResiliencyPolicyFailurePolicyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('rpoInSecs', 'RpoInSecs', cfn_parse.FromCloudFormation.getNumber(properties.RpoInSecs));
    ret.addPropertyResult('rtoInSecs', 'RtoInSecs', cfn_parse.FromCloudFormation.getNumber(properties.RtoInSecs));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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