"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiGateway = exports.ApiGatewayDomain = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Defines an API Gateway domain name as the alias target.
 *
 * Use the `ApiGateway` class if you wish to map the alias to an REST API with a
 * domain name defined through the `RestApiProps.domainName` prop.
 */
class ApiGatewayDomain {
    constructor(domainName) {
        this.domainName = domainName;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_IDomainName(domainName);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ApiGatewayDomain);
            }
            throw error;
        }
    }
    bind(_record, _zone) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_route53_IRecordSet(_record);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_route53_IHostedZone(_zone);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            dnsName: this.domainName.domainNameAliasDomainName,
            hostedZoneId: this.domainName.domainNameAliasHostedZoneId,
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
ApiGatewayDomain[_a] = { fqn: "aws-cdk-lib.aws_route53_targets.ApiGatewayDomain", version: "2.74.0" };
exports.ApiGatewayDomain = ApiGatewayDomain;
/**
 * Defines an API Gateway REST API as the alias target. Requires that the domain
 * name will be defined through `RestApiProps.domainName`.
 *
 * You can direct the alias to any `apigateway.DomainName` resource through the
 * `ApiGatewayDomain` class.
 */
class ApiGateway extends ApiGatewayDomain {
    constructor(api) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_apigateway_RestApiBase(api);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ApiGateway);
            }
            throw error;
        }
        if (!api.domainName) {
            throw new Error('API does not define a default domain name');
        }
        super(api.domainName);
    }
}
_b = JSII_RTTI_SYMBOL_1;
ApiGateway[_b] = { fqn: "aws-cdk-lib.aws_route53_targets.ApiGateway", version: "2.74.0" };
exports.ApiGateway = ApiGateway;
//# sourceMappingURL=data:application/json;base64,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