"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BucketWebsiteTarget = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const region_info_1 = require("../../region-info");
/**
 * Use a S3 as an alias record target
 */
class BucketWebsiteTarget {
    constructor(bucket) {
        this.bucket = bucket;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_s3_IBucket(bucket);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, BucketWebsiteTarget);
            }
            throw error;
        }
    }
    bind(_record, _zone) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_route53_IRecordSet(_record);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_route53_IHostedZone(_zone);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        const { region } = core_1.Stack.of(this.bucket.stack);
        if (core_1.Token.isUnresolved(region)) {
            throw new Error([
                'Cannot use an S3 record alias in region-agnostic stacks.',
                'You must specify a specific region when you define the stack',
                '(see https://docs.aws.amazon.com/cdk/latest/guide/environments.html)',
            ].join(' '));
        }
        const { s3StaticWebsiteHostedZoneId: hostedZoneId, s3StaticWebsiteEndpoint: dnsName } = region_info_1.RegionInfo.get(region);
        if (!hostedZoneId || !dnsName) {
            throw new Error(`Bucket website target is not supported for the "${region}" region`);
        }
        return { hostedZoneId, dnsName };
    }
}
_a = JSII_RTTI_SYMBOL_1;
BucketWebsiteTarget[_a] = { fqn: "aws-cdk-lib.aws_route53_targets.BucketWebsiteTarget", version: "2.74.0" };
exports.BucketWebsiteTarget = BucketWebsiteTarget;
//# sourceMappingURL=data:application/json;base64,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