"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFrontTarget = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
/**
 * Use a CloudFront Distribution as an alias record target
 */
class CloudFrontTarget {
    /**
     * Get the hosted zone id for the current scope.
     *
     * @param scope - scope in which this resource is defined
     */
    static getHostedZoneId(scope) {
        const mappingName = 'AWSCloudFrontPartitionHostedZoneIdMap';
        const scopeStack = core_1.Stack.of(scope);
        let mapping = scopeStack.node.tryFindChild(mappingName) ??
            new core_1.CfnMapping(scopeStack, mappingName, {
                mapping: {
                    ['aws']: {
                        zoneId: 'Z2FDTNDATAQYW2', // https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-aliastarget.html
                    },
                    ['aws-cn']: {
                        zoneId: 'Z3RFFRIM2A3IF5', // https://docs.amazonaws.cn/en_us/aws/latest/userguide/route53.html
                    },
                },
            });
        return mapping.findInMap(core_1.Aws.PARTITION, 'zoneId');
    }
    constructor(distribution) {
        this.distribution = distribution;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudfront_IDistribution(distribution);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CloudFrontTarget);
            }
            throw error;
        }
    }
    bind(_record, _zone) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_route53_IRecordSet(_record);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_route53_IHostedZone(_zone);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            hostedZoneId: CloudFrontTarget.getHostedZoneId(this.distribution),
            dnsName: this.distribution.distributionDomainName,
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
CloudFrontTarget[_a] = { fqn: "aws-cdk-lib.aws_route53_targets.CloudFrontTarget", version: "2.74.0" };
/**
 * The hosted zone Id if using an alias record in Route53.
 * This value never changes.
 */
CloudFrontTarget.CLOUDFRONT_ZONE_ID = 'Z2FDTNDATAQYW2';
exports.CloudFrontTarget = CloudFrontTarget;
//# sourceMappingURL=data:application/json;base64,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