"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElasticBeanstalkEnvironmentEndpointTarget = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core");
const region_info_1 = require("../../region-info");
/**
 * Use an Elastic Beanstalk environment URL as an alias record target.
 * E.g. mysampleenvironment.xyz.us-east-1.elasticbeanstalk.com
 * or mycustomcnameprefix.us-east-1.elasticbeanstalk.com
 *
 * Only supports Elastic Beanstalk environments created after 2016 that have a regional endpoint.
 */
class ElasticBeanstalkEnvironmentEndpointTarget {
    constructor(environmentEndpoint) {
        this.environmentEndpoint = environmentEndpoint;
    }
    bind(_record, _zone) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_route53_IRecordSet(_record);
            jsiiDeprecationWarnings.aws_cdk_lib_aws_route53_IHostedZone(_zone);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        if (cdk.Token.isUnresolved(this.environmentEndpoint)) {
            throw new Error('Cannot use an EBS alias as `environmentEndpoint`. You must find your EBS environment endpoint via the AWS console. See the Elastic Beanstalk developer guide: https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/customdomains.html');
        }
        const dnsName = this.environmentEndpoint;
        const subDomains = cdk.Fn.split('.', dnsName);
        const regionSubdomainIndex = subDomains.length - 3;
        const region = cdk.Fn.select(regionSubdomainIndex, subDomains);
        const { ebsEnvEndpointHostedZoneId: hostedZoneId } = region_info_1.RegionInfo.get(region);
        if (!hostedZoneId || !dnsName) {
            throw new Error(`Elastic Beanstalk environment target is not supported for the "${region}" region.`);
        }
        return {
            hostedZoneId,
            dnsName,
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
ElasticBeanstalkEnvironmentEndpointTarget[_a] = { fqn: "aws-cdk-lib.aws_route53_targets.ElasticBeanstalkEnvironmentEndpointTarget", version: "2.74.0" };
exports.ElasticBeanstalkEnvironmentEndpointTarget = ElasticBeanstalkEnvironmentEndpointTarget;
//# sourceMappingURL=data:application/json;base64,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