"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CrossAccountZoneDelegationRecord = exports.ZoneDelegationRecord = exports.DsRecord = exports.NsRecord = exports.MxRecord = exports.CaaAmazonRecord = exports.CaaRecord = exports.CaaTag = exports.SrvRecord = exports.TxtRecord = exports.CnameRecord = exports.AaaaRecord = exports.ARecord = exports.AddressRecordTarget = exports.RecordSet = exports.RecordTarget = exports.RecordType = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const iam = require("../../aws-iam");
const core_1 = require("../../core");
const constructs_1 = require("constructs");
const route53_generated_1 = require("./route53.generated");
const util_1 = require("./util");
const CROSS_ACCOUNT_ZONE_DELEGATION_RESOURCE_TYPE = 'Custom::CrossAccountZoneDelegation';
const DELETE_EXISTING_RECORD_SET_RESOURCE_TYPE = 'Custom::DeleteExistingRecordSet';
/**
 * Context key to control whether to use the regional STS endpoint, instead of the global one
 *
 * There is only exactly one use case where you want to turn this on. If:
 *
 * - you are building an AWS service; AND
 * - would like to your own Global Service Principal in the trust policy of the delegation role; AND
 * - the target account is opted in in the same region as well
 *
 * Then you can turn this on. For all other use cases, the global endpoint is preferable:
 *
 * - if you are a regular customer, your trust policy would be in terms of account ids or
 *   organization ids, or ARNs, not Service Principals, so you don't care about this behavior.
 * - if the target account is not opted in as well, the AssumeRole call would fail
 *
 * Because this configuration option is so rare, turn it into a context setting instead
 * of a publicly available prop.
 */
const USE_REGIONAL_STS_ENDPOINT_CONTEXT_KEY = '@aws-cdk/aws-route53:useRegionalStsEndpoint';
/**
 * The record type.
 */
var RecordType;
(function (RecordType) {
    /**
     * route traffic to a resource, such as a web server, using an IPv4 address in dotted decimal
     * notation
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#AFormat
     */
    RecordType["A"] = "A";
    /**
     * route traffic to a resource, such as a web server, using an IPv6 address in colon-separated
     * hexadecimal format
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#AAAAFormat
     */
    RecordType["AAAA"] = "AAAA";
    /**
     * A CAA record specifies which certificate authorities (CAs) are allowed to issue certificates
     * for a domain or subdomain
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#CAAFormat
     */
    RecordType["CAA"] = "CAA";
    /**
     * A CNAME record maps DNS queries for the name of the current record, such as acme.example.com,
     * to another domain (example.com or example.net) or subdomain (acme.example.com or zenith.example.org).
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#CNAMEFormat
     */
    RecordType["CNAME"] = "CNAME";
    /**
     * A delegation signer (DS) record refers a zone key for a delegated subdomain zone.
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#DSFormat
     */
    RecordType["DS"] = "DS";
    /**
     * An MX record specifies the names of your mail servers and, if you have two or more mail servers,
     * the priority order.
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#MXFormat
     */
    RecordType["MX"] = "MX";
    /**
     * A Name Authority Pointer (NAPTR) is a type of record that is used by Dynamic Delegation Discovery
     * System (DDDS) applications to convert one value to another or to replace one value with another.
     * For example, one common use is to convert phone numbers into SIP URIs.
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#NAPTRFormat
     */
    RecordType["NAPTR"] = "NAPTR";
    /**
     * An NS record identifies the name servers for the hosted zone
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#NSFormat
     */
    RecordType["NS"] = "NS";
    /**
     * A PTR record maps an IP address to the corresponding domain name.
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#PTRFormat
     */
    RecordType["PTR"] = "PTR";
    /**
     * A start of authority (SOA) record provides information about a domain and the corresponding Amazon
     * Route 53 hosted zone
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#SOAFormat
     */
    RecordType["SOA"] = "SOA";
    /**
     * SPF records were formerly used to verify the identity of the sender of email messages.
     * Instead of an SPF record, we recommend that you create a TXT record that contains the applicable value.
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#SPFFormat
     */
    RecordType["SPF"] = "SPF";
    /**
     * An SRV record Value element consists of four space-separated values. The first three values are
     * decimal numbers representing priority, weight, and port. The fourth value is a domain name.
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#SRVFormat
     */
    RecordType["SRV"] = "SRV";
    /**
     * A TXT record contains one or more strings that are enclosed in double quotation marks (").
     *
     * @see https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html#TXTFormat
     */
    RecordType["TXT"] = "TXT";
})(RecordType = exports.RecordType || (exports.RecordType = {}));
/**
 * Type union for a record that accepts multiple types of target.
 */
class RecordTarget {
    /**
     * Use string values as target.
     */
    static fromValues(...values) {
        return new RecordTarget(values);
    }
    /**
     * Use an alias as target.
     */
    static fromAlias(aliasTarget) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_route53_IAliasRecordTarget(aliasTarget);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromAlias);
            }
            throw error;
        }
        return new RecordTarget(undefined, aliasTarget);
    }
    /**
     * Use ip addresses as target.
     */
    static fromIpAddresses(...ipAddresses) {
        return RecordTarget.fromValues(...ipAddresses);
    }
    /**
     *
     * @param values correspond with the chosen record type (e.g. for 'A' Type, specify one or more IP addresses)
     * @param aliasTarget alias for targets such as CloudFront distribution to route traffic to
     */
    constructor(values, aliasTarget) {
        this.values = values;
        this.aliasTarget = aliasTarget;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_route53_IAliasRecordTarget(aliasTarget);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, RecordTarget);
            }
            throw error;
        }
    }
}
_a = JSII_RTTI_SYMBOL_1;
RecordTarget[_a] = { fqn: "aws-cdk-lib.aws_route53.RecordTarget", version: "2.74.0" };
exports.RecordTarget = RecordTarget;
/**
 * A record set.
 */
class RecordSet extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_route53_RecordSetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, RecordSet);
            }
            throw error;
        }
        const ttl = props.target.aliasTarget ? undefined : ((props.ttl && props.ttl.toSeconds()) ?? 1800).toString();
        const recordName = (0, util_1.determineFullyQualifiedDomainName)(props.recordName || props.zone.zoneName, props.zone);
        const recordSet = new route53_generated_1.CfnRecordSet(this, 'Resource', {
            hostedZoneId: props.zone.hostedZoneId,
            name: recordName,
            type: props.recordType,
            resourceRecords: props.target.values,
            aliasTarget: props.target.aliasTarget && props.target.aliasTarget.bind(this, props.zone),
            ttl,
            comment: props.comment,
        });
        this.domainName = recordSet.ref;
        if (props.deleteExisting) {
            // Delete existing record before creating the new one
            const provider = core_1.CustomResourceProvider.getOrCreateProvider(this, DELETE_EXISTING_RECORD_SET_RESOURCE_TYPE, {
                codeDirectory: path.join(__dirname, 'delete-existing-record-set-handler'),
                runtime: core_1.CustomResourceProviderRuntime.NODEJS_14_X,
                policyStatements: [{
                        Effect: 'Allow',
                        Action: 'route53:GetChange',
                        Resource: '*',
                    }],
            });
            // Add to the singleton policy for this specific provider
            provider.addToRolePolicy({
                Effect: 'Allow',
                Action: 'route53:ListResourceRecordSets',
                Resource: props.zone.hostedZoneArn,
            });
            provider.addToRolePolicy({
                Effect: 'Allow',
                Action: 'route53:ChangeResourceRecordSets',
                Resource: props.zone.hostedZoneArn,
                Condition: {
                    'ForAllValues:StringEquals': {
                        'route53:ChangeResourceRecordSetsRecordTypes': [props.recordType],
                        'route53:ChangeResourceRecordSetsActions': ['DELETE'],
                    },
                },
            });
            const customResource = new core_1.CustomResource(this, 'DeleteExistingRecordSetCustomResource', {
                resourceType: DELETE_EXISTING_RECORD_SET_RESOURCE_TYPE,
                serviceToken: provider.serviceToken,
                properties: {
                    HostedZoneId: props.zone.hostedZoneId,
                    RecordName: recordName,
                    RecordType: props.recordType,
                },
            });
            recordSet.node.addDependency(customResource);
        }
    }
}
_b = JSII_RTTI_SYMBOL_1;
RecordSet[_b] = { fqn: "aws-cdk-lib.aws_route53.RecordSet", version: "2.74.0" };
exports.RecordSet = RecordSet;
/**
 * Target for a DNS A Record
 *
 * @deprecated Use RecordTarget
 */
class AddressRecordTarget extends RecordTarget {
}
_c = JSII_RTTI_SYMBOL_1;
AddressRecordTarget[_c] = { fqn: "aws-cdk-lib.aws_route53.AddressRecordTarget", version: "2.74.0" };
exports.AddressRecordTarget = AddressRecordTarget;
/**
 * A DNS A record
 *
 * @resource AWS::Route53::RecordSet
 */
class ARecord extends RecordSet {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            recordType: RecordType.A,
            target: props.target,
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_route53_ARecordProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ARecord);
            }
            throw error;
        }
    }
}
_d = JSII_RTTI_SYMBOL_1;
ARecord[_d] = { fqn: "aws-cdk-lib.aws_route53.ARecord", version: "2.74.0" };
exports.ARecord = ARecord;
/**
 * A DNS AAAA record
 *
 * @resource AWS::Route53::RecordSet
 */
class AaaaRecord extends RecordSet {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            recordType: RecordType.AAAA,
            target: props.target,
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_route53_AaaaRecordProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AaaaRecord);
            }
            throw error;
        }
    }
}
_e = JSII_RTTI_SYMBOL_1;
AaaaRecord[_e] = { fqn: "aws-cdk-lib.aws_route53.AaaaRecord", version: "2.74.0" };
exports.AaaaRecord = AaaaRecord;
/**
 * A DNS CNAME record
 *
 * @resource AWS::Route53::RecordSet
 */
class CnameRecord extends RecordSet {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            recordType: RecordType.CNAME,
            target: RecordTarget.fromValues(props.domainName),
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_route53_CnameRecordProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CnameRecord);
            }
            throw error;
        }
    }
}
_f = JSII_RTTI_SYMBOL_1;
CnameRecord[_f] = { fqn: "aws-cdk-lib.aws_route53.CnameRecord", version: "2.74.0" };
exports.CnameRecord = CnameRecord;
/**
 * A DNS TXT record
 *
 * @resource AWS::Route53::RecordSet
 */
class TxtRecord extends RecordSet {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            recordType: RecordType.TXT,
            target: RecordTarget.fromValues(...props.values.map(v => formatTxt(v))),
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_route53_TxtRecordProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, TxtRecord);
            }
            throw error;
        }
    }
}
_g = JSII_RTTI_SYMBOL_1;
TxtRecord[_g] = { fqn: "aws-cdk-lib.aws_route53.TxtRecord", version: "2.74.0" };
exports.TxtRecord = TxtRecord;
/**
 * Formats a text value for use in a TXT record
 *
 * Use `JSON.stringify` to correctly escape and enclose in double quotes ("").
 *
 * DNS TXT records can contain up to 255 characters in a single string. TXT
 * record strings over 255 characters must be split into multiple text strings
 * within the same record.
 *
 * @see https://aws.amazon.com/premiumsupport/knowledge-center/route53-resolve-dkim-text-record-error/
 */
function formatTxt(string) {
    const result = [];
    let idx = 0;
    while (idx < string.length) {
        result.push(string.slice(idx, idx += 255)); // chunks of 255 characters long
    }
    return result.map(r => JSON.stringify(r)).join('');
}
/**
 * A DNS SRV record
 *
 * @resource AWS::Route53::RecordSet
 */
class SrvRecord extends RecordSet {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            recordType: RecordType.SRV,
            target: RecordTarget.fromValues(...props.values.map(v => `${v.priority} ${v.weight} ${v.port} ${v.hostName}`)),
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_route53_SrvRecordProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SrvRecord);
            }
            throw error;
        }
    }
}
_h = JSII_RTTI_SYMBOL_1;
SrvRecord[_h] = { fqn: "aws-cdk-lib.aws_route53.SrvRecord", version: "2.74.0" };
exports.SrvRecord = SrvRecord;
/**
 * The CAA tag.
 */
var CaaTag;
(function (CaaTag) {
    /**
     * Explicity authorizes a single certificate authority to issue a
     * certificate (any type) for the hostname.
     */
    CaaTag["ISSUE"] = "issue";
    /**
     * Explicity authorizes a single certificate authority to issue a
     * wildcard certificate (and only wildcard) for the hostname.
     */
    CaaTag["ISSUEWILD"] = "issuewild";
    /**
     * Specifies a URL to which a certificate authority may report policy
     * violations.
     */
    CaaTag["IODEF"] = "iodef";
})(CaaTag = exports.CaaTag || (exports.CaaTag = {}));
/**
 * A DNS CAA record
 *
 * @resource AWS::Route53::RecordSet
 */
class CaaRecord extends RecordSet {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            recordType: RecordType.CAA,
            target: RecordTarget.fromValues(...props.values.map(v => `${v.flag} ${v.tag} "${v.value}"`)),
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_route53_CaaRecordProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CaaRecord);
            }
            throw error;
        }
    }
}
_j = JSII_RTTI_SYMBOL_1;
CaaRecord[_j] = { fqn: "aws-cdk-lib.aws_route53.CaaRecord", version: "2.74.0" };
exports.CaaRecord = CaaRecord;
/**
 * A DNS Amazon CAA record.
 *
 * A CAA record to restrict certificate authorities allowed
 * to issue certificates for a domain to Amazon only.
 *
 * @resource AWS::Route53::RecordSet
 */
class CaaAmazonRecord extends CaaRecord {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            values: [
                {
                    flag: 0,
                    tag: CaaTag.ISSUE,
                    value: 'amazon.com',
                },
            ],
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_route53_CaaAmazonRecordProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CaaAmazonRecord);
            }
            throw error;
        }
    }
}
_k = JSII_RTTI_SYMBOL_1;
CaaAmazonRecord[_k] = { fqn: "aws-cdk-lib.aws_route53.CaaAmazonRecord", version: "2.74.0" };
exports.CaaAmazonRecord = CaaAmazonRecord;
/**
 * A DNS MX record
 *
 * @resource AWS::Route53::RecordSet
 */
class MxRecord extends RecordSet {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            recordType: RecordType.MX,
            target: RecordTarget.fromValues(...props.values.map(v => `${v.priority} ${v.hostName}`)),
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_route53_MxRecordProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, MxRecord);
            }
            throw error;
        }
    }
}
_l = JSII_RTTI_SYMBOL_1;
MxRecord[_l] = { fqn: "aws-cdk-lib.aws_route53.MxRecord", version: "2.74.0" };
exports.MxRecord = MxRecord;
/**
 * A DNS NS record
 *
 * @resource AWS::Route53::RecordSet
 */
class NsRecord extends RecordSet {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            recordType: RecordType.NS,
            target: RecordTarget.fromValues(...props.values),
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_route53_NsRecordProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, NsRecord);
            }
            throw error;
        }
    }
}
_m = JSII_RTTI_SYMBOL_1;
NsRecord[_m] = { fqn: "aws-cdk-lib.aws_route53.NsRecord", version: "2.74.0" };
exports.NsRecord = NsRecord;
/**
 * A DNS DS record
 *
 * @resource AWS::Route53::RecordSet
 */
class DsRecord extends RecordSet {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            recordType: RecordType.DS,
            target: RecordTarget.fromValues(...props.values),
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_route53_DsRecordProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, DsRecord);
            }
            throw error;
        }
    }
}
_o = JSII_RTTI_SYMBOL_1;
DsRecord[_o] = { fqn: "aws-cdk-lib.aws_route53.DsRecord", version: "2.74.0" };
exports.DsRecord = DsRecord;
/**
 * A record to delegate further lookups to a different set of name servers.
 */
class ZoneDelegationRecord extends RecordSet {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            recordType: RecordType.NS,
            target: RecordTarget.fromValues(...core_1.Token.isUnresolved(props.nameServers)
                ? props.nameServers // Can't map a string-array token!
                : props.nameServers.map(ns => (core_1.Token.isUnresolved(ns) || ns.endsWith('.')) ? ns : `${ns}.`)),
            ttl: props.ttl || core_1.Duration.days(2),
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_route53_ZoneDelegationRecordProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ZoneDelegationRecord);
            }
            throw error;
        }
    }
}
_p = JSII_RTTI_SYMBOL_1;
ZoneDelegationRecord[_p] = { fqn: "aws-cdk-lib.aws_route53.ZoneDelegationRecord", version: "2.74.0" };
exports.ZoneDelegationRecord = ZoneDelegationRecord;
/**
 * A Cross Account Zone Delegation record
 */
class CrossAccountZoneDelegationRecord extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_route53_CrossAccountZoneDelegationRecordProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CrossAccountZoneDelegationRecord);
            }
            throw error;
        }
        if (!props.parentHostedZoneName && !props.parentHostedZoneId) {
            throw Error('At least one of parentHostedZoneName or parentHostedZoneId is required');
        }
        if (props.parentHostedZoneName && props.parentHostedZoneId) {
            throw Error('Only one of parentHostedZoneName and parentHostedZoneId is supported');
        }
        const provider = core_1.CustomResourceProvider.getOrCreateProvider(this, CROSS_ACCOUNT_ZONE_DELEGATION_RESOURCE_TYPE, {
            codeDirectory: path.join(__dirname, 'cross-account-zone-delegation-handler'),
            runtime: core_1.CustomResourceProviderRuntime.NODEJS_14_X,
        });
        const role = iam.Role.fromRoleArn(this, 'cross-account-zone-delegation-handler-role', provider.roleArn);
        const addToPrinciplePolicyResult = role.addToPrincipalPolicy(new iam.PolicyStatement({
            effect: iam.Effect.ALLOW,
            actions: ['sts:AssumeRole'],
            resources: [props.delegationRole.roleArn],
        }));
        const useRegionalStsEndpoint = this.node.tryGetContext(USE_REGIONAL_STS_ENDPOINT_CONTEXT_KEY);
        const customResource = new core_1.CustomResource(this, 'CrossAccountZoneDelegationCustomResource', {
            resourceType: CROSS_ACCOUNT_ZONE_DELEGATION_RESOURCE_TYPE,
            serviceToken: provider.serviceToken,
            removalPolicy: props.removalPolicy,
            properties: {
                AssumeRoleArn: props.delegationRole.roleArn,
                ParentZoneName: props.parentHostedZoneName,
                ParentZoneId: props.parentHostedZoneId,
                DelegatedZoneName: props.delegatedZone.zoneName,
                DelegatedZoneNameServers: props.delegatedZone.hostedZoneNameServers,
                TTL: (props.ttl || core_1.Duration.days(2)).toSeconds(),
                UseRegionalStsEndpoint: useRegionalStsEndpoint ? 'true' : undefined,
            },
        });
        if (addToPrinciplePolicyResult.policyDependable) {
            customResource.node.addDependency(addToPrinciplePolicyResult.policyDependable);
        }
    }
}
_q = JSII_RTTI_SYMBOL_1;
CrossAccountZoneDelegationRecord[_q] = { fqn: "aws-cdk-lib.aws_route53.CrossAccountZoneDelegationRecord", version: "2.74.0" };
exports.CrossAccountZoneDelegationRecord = CrossAccountZoneDelegationRecord;
//# sourceMappingURL=data:application/json;base64,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