"use strict";
var _a, _b, _c, _d, _e, _f, _g;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnRecordSetGroup = exports.CfnRecordSet = exports.CfnKeySigningKey = exports.CfnHostedZone = exports.CfnHealthCheck = exports.CfnDNSSEC = exports.CfnCidrCollection = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core");
const cfn_parse = require("../../core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnCidrCollectionProps`
 *
 * @param properties - the TypeScript properties of a `CfnCidrCollectionProps`
 *
 * @returns the result of the validation.
 */
function CfnCidrCollectionPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('locations', cdk.listValidator(CfnCidrCollection_LocationPropertyValidator))(properties.locations));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    return errors.wrap('supplied properties not correct for "CfnCidrCollectionProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::CidrCollection` resource
 *
 * @param properties - the TypeScript properties of a `CfnCidrCollectionProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::CidrCollection` resource.
 */
// @ts-ignore TS6133
function cfnCidrCollectionPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnCidrCollectionPropsValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        Locations: cdk.listMapper(cfnCidrCollectionLocationPropertyToCloudFormation)(properties.locations),
    };
}
// @ts-ignore TS6133
function CfnCidrCollectionPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('locations', 'Locations', properties.Locations != null ? cfn_parse.FromCloudFormation.getArray(CfnCidrCollectionLocationPropertyFromCloudFormation)(properties.Locations) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Route53::CidrCollection`
 *
 * Creates a CIDR collection in the current AWS account.
 *
 * @cloudformationResource AWS::Route53::CidrCollection
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-cidrcollection.html
 */
class CfnCidrCollection extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnCidrCollectionPropsFromCloudFormation(resourceProperties);
        const ret = new CfnCidrCollection(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::Route53::CidrCollection`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnCidrCollection.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_route53_CfnCidrCollectionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnCidrCollection);
            }
            throw error;
        }
        cdk.requireProperty(props, 'name', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn', cdk.ResolutionTypeHint.STRING));
        this.attrId = cdk.Token.asString(this.getAtt('Id', cdk.ResolutionTypeHint.STRING));
        this.name = props.name;
        this.locations = props.locations;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnCidrCollection.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            name: this.name,
            locations: this.locations,
        };
    }
    renderProperties(props) {
        return cfnCidrCollectionPropsToCloudFormation(props);
    }
}
_a = JSII_RTTI_SYMBOL_1;
CfnCidrCollection[_a] = { fqn: "aws-cdk-lib.aws_route53.CfnCidrCollection", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnCidrCollection.CFN_RESOURCE_TYPE_NAME = "AWS::Route53::CidrCollection";
exports.CfnCidrCollection = CfnCidrCollection;
/**
 * Determine whether the given properties match those of a `LocationProperty`
 *
 * @param properties - the TypeScript properties of a `LocationProperty`
 *
 * @returns the result of the validation.
 */
function CfnCidrCollection_LocationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cidrList', cdk.requiredValidator)(properties.cidrList));
    errors.collect(cdk.propertyValidator('cidrList', cdk.listValidator(cdk.validateString))(properties.cidrList));
    errors.collect(cdk.propertyValidator('locationName', cdk.requiredValidator)(properties.locationName));
    errors.collect(cdk.propertyValidator('locationName', cdk.validateString)(properties.locationName));
    return errors.wrap('supplied properties not correct for "LocationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::CidrCollection.Location` resource
 *
 * @param properties - the TypeScript properties of a `LocationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::CidrCollection.Location` resource.
 */
// @ts-ignore TS6133
function cfnCidrCollectionLocationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnCidrCollection_LocationPropertyValidator(properties).assertSuccess();
    return {
        CidrList: cdk.listMapper(cdk.stringToCloudFormation)(properties.cidrList),
        LocationName: cdk.stringToCloudFormation(properties.locationName),
    };
}
// @ts-ignore TS6133
function CfnCidrCollectionLocationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('cidrList', 'CidrList', cfn_parse.FromCloudFormation.getStringArray(properties.CidrList));
    ret.addPropertyResult('locationName', 'LocationName', cfn_parse.FromCloudFormation.getString(properties.LocationName));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnDNSSECProps`
 *
 * @param properties - the TypeScript properties of a `CfnDNSSECProps`
 *
 * @returns the result of the validation.
 */
function CfnDNSSECPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('hostedZoneId', cdk.requiredValidator)(properties.hostedZoneId));
    errors.collect(cdk.propertyValidator('hostedZoneId', cdk.validateString)(properties.hostedZoneId));
    return errors.wrap('supplied properties not correct for "CfnDNSSECProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::DNSSEC` resource
 *
 * @param properties - the TypeScript properties of a `CfnDNSSECProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::DNSSEC` resource.
 */
// @ts-ignore TS6133
function cfnDNSSECPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDNSSECPropsValidator(properties).assertSuccess();
    return {
        HostedZoneId: cdk.stringToCloudFormation(properties.hostedZoneId),
    };
}
// @ts-ignore TS6133
function CfnDNSSECPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('hostedZoneId', 'HostedZoneId', cfn_parse.FromCloudFormation.getString(properties.HostedZoneId));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Route53::DNSSEC`
 *
 * The `AWS::Route53::DNSSEC` resource is used to enable DNSSEC signing in a hosted zone.
 *
 * @cloudformationResource AWS::Route53::DNSSEC
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-dnssec.html
 */
class CfnDNSSEC extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDNSSECPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDNSSEC(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::Route53::DNSSEC`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDNSSEC.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_route53_CfnDNSSECProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnDNSSEC);
            }
            throw error;
        }
        cdk.requireProperty(props, 'hostedZoneId', this);
        this.hostedZoneId = props.hostedZoneId;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDNSSEC.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            hostedZoneId: this.hostedZoneId,
        };
    }
    renderProperties(props) {
        return cfnDNSSECPropsToCloudFormation(props);
    }
}
_b = JSII_RTTI_SYMBOL_1;
CfnDNSSEC[_b] = { fqn: "aws-cdk-lib.aws_route53.CfnDNSSEC", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDNSSEC.CFN_RESOURCE_TYPE_NAME = "AWS::Route53::DNSSEC";
exports.CfnDNSSEC = CfnDNSSEC;
/**
 * Determine whether the given properties match those of a `CfnHealthCheckProps`
 *
 * @param properties - the TypeScript properties of a `CfnHealthCheckProps`
 *
 * @returns the result of the validation.
 */
function CfnHealthCheckPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('healthCheckConfig', cdk.requiredValidator)(properties.healthCheckConfig));
    errors.collect(cdk.propertyValidator('healthCheckConfig', CfnHealthCheck_HealthCheckConfigPropertyValidator)(properties.healthCheckConfig));
    errors.collect(cdk.propertyValidator('healthCheckTags', cdk.listValidator(CfnHealthCheck_HealthCheckTagPropertyValidator))(properties.healthCheckTags));
    return errors.wrap('supplied properties not correct for "CfnHealthCheckProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::HealthCheck` resource
 *
 * @param properties - the TypeScript properties of a `CfnHealthCheckProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::HealthCheck` resource.
 */
// @ts-ignore TS6133
function cfnHealthCheckPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnHealthCheckPropsValidator(properties).assertSuccess();
    return {
        HealthCheckConfig: cfnHealthCheckHealthCheckConfigPropertyToCloudFormation(properties.healthCheckConfig),
        HealthCheckTags: cdk.listMapper(cfnHealthCheckHealthCheckTagPropertyToCloudFormation)(properties.healthCheckTags),
    };
}
// @ts-ignore TS6133
function CfnHealthCheckPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('healthCheckConfig', 'HealthCheckConfig', CfnHealthCheckHealthCheckConfigPropertyFromCloudFormation(properties.HealthCheckConfig));
    ret.addPropertyResult('healthCheckTags', 'HealthCheckTags', properties.HealthCheckTags != null ? cfn_parse.FromCloudFormation.getArray(CfnHealthCheckHealthCheckTagPropertyFromCloudFormation)(properties.HealthCheckTags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Route53::HealthCheck`
 *
 * The `AWS::Route53::HealthCheck` resource is a Route 53 resource type that contains settings for a Route 53 health check.
 *
 * For information about associating health checks with records, see [HealthCheckId](https://docs.aws.amazon.com/Route53/latest/APIReference/API_ResourceRecordSet.html#Route53-Type-ResourceRecordSet-HealthCheckId) in [ChangeResourceRecordSets](https://docs.aws.amazon.com/Route53/latest/APIReference/API_ChangeResourceRecordSets.html) .
 *
 * > You can't create a health check with simple routing.
 *
 * *ELB Load Balancers*
 *
 * If you're registering EC2 instances with an Elastic Load Balancing (ELB) load balancer, do not create Amazon Route 53 health checks for the EC2 instances. When you register an EC2 instance with a load balancer, you configure settings for an ELB health check, which performs a similar function to a Route 53 health check.
 *
 * *Private Hosted Zones*
 *
 * You can associate health checks with failover records in a private hosted zone. Note the following:
 *
 * - Route 53 health checkers are outside the VPC. To check the health of an endpoint within a VPC by IP address, you must assign a public IP address to the instance in the VPC.
 * - You can configure a health checker to check the health of an external resource that the instance relies on, such as a database server.
 * - You can create a CloudWatch metric, associate an alarm with the metric, and then create a health check that is based on the state of the alarm. For example, you might create a CloudWatch metric that checks the status of the Amazon EC2 `StatusCheckFailed` metric, add an alarm to the metric, and then create a health check that is based on the state of the alarm. For information about creating CloudWatch metrics and alarms by using the CloudWatch console, see the [Amazon CloudWatch User Guide](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/WhatIsCloudWatch.html) .
 *
 * @cloudformationResource AWS::Route53::HealthCheck
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html
 */
class CfnHealthCheck extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnHealthCheckPropsFromCloudFormation(resourceProperties);
        const ret = new CfnHealthCheck(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::Route53::HealthCheck`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnHealthCheck.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_route53_CfnHealthCheckProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnHealthCheck);
            }
            throw error;
        }
        cdk.requireProperty(props, 'healthCheckConfig', this);
        this.attrHealthCheckId = cdk.Token.asString(this.getAtt('HealthCheckId', cdk.ResolutionTypeHint.STRING));
        this.healthCheckConfig = props.healthCheckConfig;
        this.healthCheckTags = props.healthCheckTags;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnHealthCheck.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            healthCheckConfig: this.healthCheckConfig,
            healthCheckTags: this.healthCheckTags,
        };
    }
    renderProperties(props) {
        return cfnHealthCheckPropsToCloudFormation(props);
    }
}
_c = JSII_RTTI_SYMBOL_1;
CfnHealthCheck[_c] = { fqn: "aws-cdk-lib.aws_route53.CfnHealthCheck", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnHealthCheck.CFN_RESOURCE_TYPE_NAME = "AWS::Route53::HealthCheck";
exports.CfnHealthCheck = CfnHealthCheck;
/**
 * Determine whether the given properties match those of a `AlarmIdentifierProperty`
 *
 * @param properties - the TypeScript properties of a `AlarmIdentifierProperty`
 *
 * @returns the result of the validation.
 */
function CfnHealthCheck_AlarmIdentifierPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('region', cdk.requiredValidator)(properties.region));
    errors.collect(cdk.propertyValidator('region', cdk.validateString)(properties.region));
    return errors.wrap('supplied properties not correct for "AlarmIdentifierProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::HealthCheck.AlarmIdentifier` resource
 *
 * @param properties - the TypeScript properties of a `AlarmIdentifierProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::HealthCheck.AlarmIdentifier` resource.
 */
// @ts-ignore TS6133
function cfnHealthCheckAlarmIdentifierPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnHealthCheck_AlarmIdentifierPropertyValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        Region: cdk.stringToCloudFormation(properties.region),
    };
}
// @ts-ignore TS6133
function CfnHealthCheckAlarmIdentifierPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('region', 'Region', cfn_parse.FromCloudFormation.getString(properties.Region));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `HealthCheckConfigProperty`
 *
 * @param properties - the TypeScript properties of a `HealthCheckConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnHealthCheck_HealthCheckConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('alarmIdentifier', CfnHealthCheck_AlarmIdentifierPropertyValidator)(properties.alarmIdentifier));
    errors.collect(cdk.propertyValidator('childHealthChecks', cdk.listValidator(cdk.validateString))(properties.childHealthChecks));
    errors.collect(cdk.propertyValidator('enableSni', cdk.validateBoolean)(properties.enableSni));
    errors.collect(cdk.propertyValidator('failureThreshold', cdk.validateNumber)(properties.failureThreshold));
    errors.collect(cdk.propertyValidator('fullyQualifiedDomainName', cdk.validateString)(properties.fullyQualifiedDomainName));
    errors.collect(cdk.propertyValidator('healthThreshold', cdk.validateNumber)(properties.healthThreshold));
    errors.collect(cdk.propertyValidator('ipAddress', cdk.validateString)(properties.ipAddress));
    errors.collect(cdk.propertyValidator('insufficientDataHealthStatus', cdk.validateString)(properties.insufficientDataHealthStatus));
    errors.collect(cdk.propertyValidator('inverted', cdk.validateBoolean)(properties.inverted));
    errors.collect(cdk.propertyValidator('measureLatency', cdk.validateBoolean)(properties.measureLatency));
    errors.collect(cdk.propertyValidator('port', cdk.validateNumber)(properties.port));
    errors.collect(cdk.propertyValidator('regions', cdk.listValidator(cdk.validateString))(properties.regions));
    errors.collect(cdk.propertyValidator('requestInterval', cdk.validateNumber)(properties.requestInterval));
    errors.collect(cdk.propertyValidator('resourcePath', cdk.validateString)(properties.resourcePath));
    errors.collect(cdk.propertyValidator('routingControlArn', cdk.validateString)(properties.routingControlArn));
    errors.collect(cdk.propertyValidator('searchString', cdk.validateString)(properties.searchString));
    errors.collect(cdk.propertyValidator('type', cdk.requiredValidator)(properties.type));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    return errors.wrap('supplied properties not correct for "HealthCheckConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::HealthCheck.HealthCheckConfig` resource
 *
 * @param properties - the TypeScript properties of a `HealthCheckConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::HealthCheck.HealthCheckConfig` resource.
 */
// @ts-ignore TS6133
function cfnHealthCheckHealthCheckConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnHealthCheck_HealthCheckConfigPropertyValidator(properties).assertSuccess();
    return {
        AlarmIdentifier: cfnHealthCheckAlarmIdentifierPropertyToCloudFormation(properties.alarmIdentifier),
        ChildHealthChecks: cdk.listMapper(cdk.stringToCloudFormation)(properties.childHealthChecks),
        EnableSNI: cdk.booleanToCloudFormation(properties.enableSni),
        FailureThreshold: cdk.numberToCloudFormation(properties.failureThreshold),
        FullyQualifiedDomainName: cdk.stringToCloudFormation(properties.fullyQualifiedDomainName),
        HealthThreshold: cdk.numberToCloudFormation(properties.healthThreshold),
        IPAddress: cdk.stringToCloudFormation(properties.ipAddress),
        InsufficientDataHealthStatus: cdk.stringToCloudFormation(properties.insufficientDataHealthStatus),
        Inverted: cdk.booleanToCloudFormation(properties.inverted),
        MeasureLatency: cdk.booleanToCloudFormation(properties.measureLatency),
        Port: cdk.numberToCloudFormation(properties.port),
        Regions: cdk.listMapper(cdk.stringToCloudFormation)(properties.regions),
        RequestInterval: cdk.numberToCloudFormation(properties.requestInterval),
        ResourcePath: cdk.stringToCloudFormation(properties.resourcePath),
        RoutingControlArn: cdk.stringToCloudFormation(properties.routingControlArn),
        SearchString: cdk.stringToCloudFormation(properties.searchString),
        Type: cdk.stringToCloudFormation(properties.type),
    };
}
// @ts-ignore TS6133
function CfnHealthCheckHealthCheckConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('alarmIdentifier', 'AlarmIdentifier', properties.AlarmIdentifier != null ? CfnHealthCheckAlarmIdentifierPropertyFromCloudFormation(properties.AlarmIdentifier) : undefined);
    ret.addPropertyResult('childHealthChecks', 'ChildHealthChecks', properties.ChildHealthChecks != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ChildHealthChecks) : undefined);
    ret.addPropertyResult('enableSni', 'EnableSNI', properties.EnableSNI != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableSNI) : undefined);
    ret.addPropertyResult('failureThreshold', 'FailureThreshold', properties.FailureThreshold != null ? cfn_parse.FromCloudFormation.getNumber(properties.FailureThreshold) : undefined);
    ret.addPropertyResult('fullyQualifiedDomainName', 'FullyQualifiedDomainName', properties.FullyQualifiedDomainName != null ? cfn_parse.FromCloudFormation.getString(properties.FullyQualifiedDomainName) : undefined);
    ret.addPropertyResult('healthThreshold', 'HealthThreshold', properties.HealthThreshold != null ? cfn_parse.FromCloudFormation.getNumber(properties.HealthThreshold) : undefined);
    ret.addPropertyResult('ipAddress', 'IPAddress', properties.IPAddress != null ? cfn_parse.FromCloudFormation.getString(properties.IPAddress) : undefined);
    ret.addPropertyResult('insufficientDataHealthStatus', 'InsufficientDataHealthStatus', properties.InsufficientDataHealthStatus != null ? cfn_parse.FromCloudFormation.getString(properties.InsufficientDataHealthStatus) : undefined);
    ret.addPropertyResult('inverted', 'Inverted', properties.Inverted != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Inverted) : undefined);
    ret.addPropertyResult('measureLatency', 'MeasureLatency', properties.MeasureLatency != null ? cfn_parse.FromCloudFormation.getBoolean(properties.MeasureLatency) : undefined);
    ret.addPropertyResult('port', 'Port', properties.Port != null ? cfn_parse.FromCloudFormation.getNumber(properties.Port) : undefined);
    ret.addPropertyResult('regions', 'Regions', properties.Regions != null ? cfn_parse.FromCloudFormation.getStringArray(properties.Regions) : undefined);
    ret.addPropertyResult('requestInterval', 'RequestInterval', properties.RequestInterval != null ? cfn_parse.FromCloudFormation.getNumber(properties.RequestInterval) : undefined);
    ret.addPropertyResult('resourcePath', 'ResourcePath', properties.ResourcePath != null ? cfn_parse.FromCloudFormation.getString(properties.ResourcePath) : undefined);
    ret.addPropertyResult('routingControlArn', 'RoutingControlArn', properties.RoutingControlArn != null ? cfn_parse.FromCloudFormation.getString(properties.RoutingControlArn) : undefined);
    ret.addPropertyResult('searchString', 'SearchString', properties.SearchString != null ? cfn_parse.FromCloudFormation.getString(properties.SearchString) : undefined);
    ret.addPropertyResult('type', 'Type', cfn_parse.FromCloudFormation.getString(properties.Type));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `HealthCheckTagProperty`
 *
 * @param properties - the TypeScript properties of a `HealthCheckTagProperty`
 *
 * @returns the result of the validation.
 */
function CfnHealthCheck_HealthCheckTagPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('key', cdk.requiredValidator)(properties.key));
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('value', cdk.requiredValidator)(properties.value));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "HealthCheckTagProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::HealthCheck.HealthCheckTag` resource
 *
 * @param properties - the TypeScript properties of a `HealthCheckTagProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::HealthCheck.HealthCheckTag` resource.
 */
// @ts-ignore TS6133
function cfnHealthCheckHealthCheckTagPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnHealthCheck_HealthCheckTagPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnHealthCheckHealthCheckTagPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('key', 'Key', cfn_parse.FromCloudFormation.getString(properties.Key));
    ret.addPropertyResult('value', 'Value', cfn_parse.FromCloudFormation.getString(properties.Value));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnHostedZoneProps`
 *
 * @param properties - the TypeScript properties of a `CfnHostedZoneProps`
 *
 * @returns the result of the validation.
 */
function CfnHostedZonePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('hostedZoneConfig', CfnHostedZone_HostedZoneConfigPropertyValidator)(properties.hostedZoneConfig));
    errors.collect(cdk.propertyValidator('hostedZoneTags', cdk.listValidator(CfnHostedZone_HostedZoneTagPropertyValidator))(properties.hostedZoneTags));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('queryLoggingConfig', CfnHostedZone_QueryLoggingConfigPropertyValidator)(properties.queryLoggingConfig));
    errors.collect(cdk.propertyValidator('vpcs', cdk.listValidator(CfnHostedZone_VPCPropertyValidator))(properties.vpcs));
    return errors.wrap('supplied properties not correct for "CfnHostedZoneProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::HostedZone` resource
 *
 * @param properties - the TypeScript properties of a `CfnHostedZoneProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::HostedZone` resource.
 */
// @ts-ignore TS6133
function cfnHostedZonePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnHostedZonePropsValidator(properties).assertSuccess();
    return {
        HostedZoneConfig: cfnHostedZoneHostedZoneConfigPropertyToCloudFormation(properties.hostedZoneConfig),
        HostedZoneTags: cdk.listMapper(cfnHostedZoneHostedZoneTagPropertyToCloudFormation)(properties.hostedZoneTags),
        Name: cdk.stringToCloudFormation(properties.name),
        QueryLoggingConfig: cfnHostedZoneQueryLoggingConfigPropertyToCloudFormation(properties.queryLoggingConfig),
        VPCs: cdk.listMapper(cfnHostedZoneVPCPropertyToCloudFormation)(properties.vpcs),
    };
}
// @ts-ignore TS6133
function CfnHostedZonePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('hostedZoneConfig', 'HostedZoneConfig', properties.HostedZoneConfig != null ? CfnHostedZoneHostedZoneConfigPropertyFromCloudFormation(properties.HostedZoneConfig) : undefined);
    ret.addPropertyResult('hostedZoneTags', 'HostedZoneTags', properties.HostedZoneTags != null ? cfn_parse.FromCloudFormation.getArray(CfnHostedZoneHostedZoneTagPropertyFromCloudFormation)(properties.HostedZoneTags) : undefined);
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('queryLoggingConfig', 'QueryLoggingConfig', properties.QueryLoggingConfig != null ? CfnHostedZoneQueryLoggingConfigPropertyFromCloudFormation(properties.QueryLoggingConfig) : undefined);
    ret.addPropertyResult('vpcs', 'VPCs', properties.VPCs != null ? cfn_parse.FromCloudFormation.getArray(CfnHostedZoneVPCPropertyFromCloudFormation)(properties.VPCs) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Route53::HostedZone`
 *
 * Creates a new public or private hosted zone. You create records in a public hosted zone to define how you want to route traffic on the internet for a domain, such as example.com, and its subdomains (apex.example.com, acme.example.com). You create records in a private hosted zone to define how you want to route traffic for a domain and its subdomains within one or more Amazon Virtual Private Clouds (Amazon VPCs).
 *
 * > You can't convert a public hosted zone to a private hosted zone or vice versa. Instead, you must create a new hosted zone with the same name and create new resource record sets.
 *
 * For more information about charges for hosted zones, see [Amazon Route 53 Pricing](https://docs.aws.amazon.com/route53/pricing/) .
 *
 * Note the following:
 *
 * - You can't create a hosted zone for a top-level domain (TLD) such as .com.
 * - If your domain is registered with a registrar other than Route 53, you must update the name servers with your registrar to make Route 53 the DNS service for the domain. For more information, see [Migrating DNS Service for an Existing Domain to Amazon Route 53](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/MigratingDNS.html) in the *Amazon Route 53 Developer Guide* .
 *
 * When you submit a `CreateHostedZone` request, the initial status of the hosted zone is `PENDING` . For public hosted zones, this means that the NS and SOA records are not yet available on all Route 53 DNS servers. When the NS and SOA records are available, the status of the zone changes to `INSYNC` .
 *
 * The `CreateHostedZone` request requires the caller to have an `ec2:DescribeVpcs` permission.
 *
 * > When creating private hosted zones, the Amazon VPC must belong to the same partition where the hosted zone is created. A partition is a group of AWS Regions . Each AWS account is scoped to one partition.
 * >
 * > The following are the supported partitions:
 * >
 * > - `aws` - AWS Regions
 * > - `aws-cn` - China Regions
 * > - `aws-us-gov` - AWS GovCloud (US) Region
 * >
 * > For more information, see [Access Management](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference* .
 *
 * @cloudformationResource AWS::Route53::HostedZone
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html
 */
class CfnHostedZone extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnHostedZonePropsFromCloudFormation(resourceProperties);
        const ret = new CfnHostedZone(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::Route53::HostedZone`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnHostedZone.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_route53_CfnHostedZoneProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnHostedZone);
            }
            throw error;
        }
        this.attrId = cdk.Token.asString(this.getAtt('Id', cdk.ResolutionTypeHint.STRING));
        this.attrNameServers = cdk.Token.asList(this.getAtt('NameServers', cdk.ResolutionTypeHint.STRING_LIST));
        this.hostedZoneConfig = props.hostedZoneConfig;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::Route53::HostedZone", props.hostedZoneTags, { tagPropertyName: 'hostedZoneTags' });
        this.name = props.name;
        this.queryLoggingConfig = props.queryLoggingConfig;
        this.vpcs = props.vpcs;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnHostedZone.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            hostedZoneConfig: this.hostedZoneConfig,
            hostedZoneTags: this.tags.renderTags(),
            name: this.name,
            queryLoggingConfig: this.queryLoggingConfig,
            vpcs: this.vpcs,
        };
    }
    renderProperties(props) {
        return cfnHostedZonePropsToCloudFormation(props);
    }
}
_d = JSII_RTTI_SYMBOL_1;
CfnHostedZone[_d] = { fqn: "aws-cdk-lib.aws_route53.CfnHostedZone", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnHostedZone.CFN_RESOURCE_TYPE_NAME = "AWS::Route53::HostedZone";
exports.CfnHostedZone = CfnHostedZone;
/**
 * Determine whether the given properties match those of a `HostedZoneConfigProperty`
 *
 * @param properties - the TypeScript properties of a `HostedZoneConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnHostedZone_HostedZoneConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('comment', cdk.validateString)(properties.comment));
    return errors.wrap('supplied properties not correct for "HostedZoneConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::HostedZone.HostedZoneConfig` resource
 *
 * @param properties - the TypeScript properties of a `HostedZoneConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::HostedZone.HostedZoneConfig` resource.
 */
// @ts-ignore TS6133
function cfnHostedZoneHostedZoneConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnHostedZone_HostedZoneConfigPropertyValidator(properties).assertSuccess();
    return {
        Comment: cdk.stringToCloudFormation(properties.comment),
    };
}
// @ts-ignore TS6133
function CfnHostedZoneHostedZoneConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('comment', 'Comment', properties.Comment != null ? cfn_parse.FromCloudFormation.getString(properties.Comment) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `HostedZoneTagProperty`
 *
 * @param properties - the TypeScript properties of a `HostedZoneTagProperty`
 *
 * @returns the result of the validation.
 */
function CfnHostedZone_HostedZoneTagPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('key', cdk.requiredValidator)(properties.key));
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('value', cdk.requiredValidator)(properties.value));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "HostedZoneTagProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::HostedZone.HostedZoneTag` resource
 *
 * @param properties - the TypeScript properties of a `HostedZoneTagProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::HostedZone.HostedZoneTag` resource.
 */
// @ts-ignore TS6133
function cfnHostedZoneHostedZoneTagPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnHostedZone_HostedZoneTagPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnHostedZoneHostedZoneTagPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('key', 'Key', cfn_parse.FromCloudFormation.getString(properties.Key));
    ret.addPropertyResult('value', 'Value', cfn_parse.FromCloudFormation.getString(properties.Value));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `QueryLoggingConfigProperty`
 *
 * @param properties - the TypeScript properties of a `QueryLoggingConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnHostedZone_QueryLoggingConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cloudWatchLogsLogGroupArn', cdk.requiredValidator)(properties.cloudWatchLogsLogGroupArn));
    errors.collect(cdk.propertyValidator('cloudWatchLogsLogGroupArn', cdk.validateString)(properties.cloudWatchLogsLogGroupArn));
    return errors.wrap('supplied properties not correct for "QueryLoggingConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::HostedZone.QueryLoggingConfig` resource
 *
 * @param properties - the TypeScript properties of a `QueryLoggingConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::HostedZone.QueryLoggingConfig` resource.
 */
// @ts-ignore TS6133
function cfnHostedZoneQueryLoggingConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnHostedZone_QueryLoggingConfigPropertyValidator(properties).assertSuccess();
    return {
        CloudWatchLogsLogGroupArn: cdk.stringToCloudFormation(properties.cloudWatchLogsLogGroupArn),
    };
}
// @ts-ignore TS6133
function CfnHostedZoneQueryLoggingConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('cloudWatchLogsLogGroupArn', 'CloudWatchLogsLogGroupArn', cfn_parse.FromCloudFormation.getString(properties.CloudWatchLogsLogGroupArn));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `VPCProperty`
 *
 * @param properties - the TypeScript properties of a `VPCProperty`
 *
 * @returns the result of the validation.
 */
function CfnHostedZone_VPCPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('vpcId', cdk.requiredValidator)(properties.vpcId));
    errors.collect(cdk.propertyValidator('vpcId', cdk.validateString)(properties.vpcId));
    errors.collect(cdk.propertyValidator('vpcRegion', cdk.requiredValidator)(properties.vpcRegion));
    errors.collect(cdk.propertyValidator('vpcRegion', cdk.validateString)(properties.vpcRegion));
    return errors.wrap('supplied properties not correct for "VPCProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::HostedZone.VPC` resource
 *
 * @param properties - the TypeScript properties of a `VPCProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::HostedZone.VPC` resource.
 */
// @ts-ignore TS6133
function cfnHostedZoneVPCPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnHostedZone_VPCPropertyValidator(properties).assertSuccess();
    return {
        VPCId: cdk.stringToCloudFormation(properties.vpcId),
        VPCRegion: cdk.stringToCloudFormation(properties.vpcRegion),
    };
}
// @ts-ignore TS6133
function CfnHostedZoneVPCPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('vpcId', 'VPCId', cfn_parse.FromCloudFormation.getString(properties.VPCId));
    ret.addPropertyResult('vpcRegion', 'VPCRegion', cfn_parse.FromCloudFormation.getString(properties.VPCRegion));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnKeySigningKeyProps`
 *
 * @param properties - the TypeScript properties of a `CfnKeySigningKeyProps`
 *
 * @returns the result of the validation.
 */
function CfnKeySigningKeyPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('hostedZoneId', cdk.requiredValidator)(properties.hostedZoneId));
    errors.collect(cdk.propertyValidator('hostedZoneId', cdk.validateString)(properties.hostedZoneId));
    errors.collect(cdk.propertyValidator('keyManagementServiceArn', cdk.requiredValidator)(properties.keyManagementServiceArn));
    errors.collect(cdk.propertyValidator('keyManagementServiceArn', cdk.validateString)(properties.keyManagementServiceArn));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('status', cdk.requiredValidator)(properties.status));
    errors.collect(cdk.propertyValidator('status', cdk.validateString)(properties.status));
    return errors.wrap('supplied properties not correct for "CfnKeySigningKeyProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::KeySigningKey` resource
 *
 * @param properties - the TypeScript properties of a `CfnKeySigningKeyProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::KeySigningKey` resource.
 */
// @ts-ignore TS6133
function cfnKeySigningKeyPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnKeySigningKeyPropsValidator(properties).assertSuccess();
    return {
        HostedZoneId: cdk.stringToCloudFormation(properties.hostedZoneId),
        KeyManagementServiceArn: cdk.stringToCloudFormation(properties.keyManagementServiceArn),
        Name: cdk.stringToCloudFormation(properties.name),
        Status: cdk.stringToCloudFormation(properties.status),
    };
}
// @ts-ignore TS6133
function CfnKeySigningKeyPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('hostedZoneId', 'HostedZoneId', cfn_parse.FromCloudFormation.getString(properties.HostedZoneId));
    ret.addPropertyResult('keyManagementServiceArn', 'KeyManagementServiceArn', cfn_parse.FromCloudFormation.getString(properties.KeyManagementServiceArn));
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('status', 'Status', cfn_parse.FromCloudFormation.getString(properties.Status));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Route53::KeySigningKey`
 *
 * The `AWS::Route53::KeySigningKey` resource creates a new key-signing key (KSK) in a hosted zone. The hosted zone ID is passed as a parameter in the KSK properties. You can specify the properties of this KSK using the `Name` , `Status` , and `KeyManagementServiceArn` properties of the resource.
 *
 * @cloudformationResource AWS::Route53::KeySigningKey
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-keysigningkey.html
 */
class CfnKeySigningKey extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnKeySigningKeyPropsFromCloudFormation(resourceProperties);
        const ret = new CfnKeySigningKey(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::Route53::KeySigningKey`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnKeySigningKey.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_route53_CfnKeySigningKeyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnKeySigningKey);
            }
            throw error;
        }
        cdk.requireProperty(props, 'hostedZoneId', this);
        cdk.requireProperty(props, 'keyManagementServiceArn', this);
        cdk.requireProperty(props, 'name', this);
        cdk.requireProperty(props, 'status', this);
        this.hostedZoneId = props.hostedZoneId;
        this.keyManagementServiceArn = props.keyManagementServiceArn;
        this.name = props.name;
        this.status = props.status;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnKeySigningKey.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            hostedZoneId: this.hostedZoneId,
            keyManagementServiceArn: this.keyManagementServiceArn,
            name: this.name,
            status: this.status,
        };
    }
    renderProperties(props) {
        return cfnKeySigningKeyPropsToCloudFormation(props);
    }
}
_e = JSII_RTTI_SYMBOL_1;
CfnKeySigningKey[_e] = { fqn: "aws-cdk-lib.aws_route53.CfnKeySigningKey", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnKeySigningKey.CFN_RESOURCE_TYPE_NAME = "AWS::Route53::KeySigningKey";
exports.CfnKeySigningKey = CfnKeySigningKey;
/**
 * Determine whether the given properties match those of a `CfnRecordSetProps`
 *
 * @param properties - the TypeScript properties of a `CfnRecordSetProps`
 *
 * @returns the result of the validation.
 */
function CfnRecordSetPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('aliasTarget', CfnRecordSet_AliasTargetPropertyValidator)(properties.aliasTarget));
    errors.collect(cdk.propertyValidator('cidrRoutingConfig', CfnRecordSet_CidrRoutingConfigPropertyValidator)(properties.cidrRoutingConfig));
    errors.collect(cdk.propertyValidator('comment', cdk.validateString)(properties.comment));
    errors.collect(cdk.propertyValidator('failover', cdk.validateString)(properties.failover));
    errors.collect(cdk.propertyValidator('geoLocation', CfnRecordSet_GeoLocationPropertyValidator)(properties.geoLocation));
    errors.collect(cdk.propertyValidator('healthCheckId', cdk.validateString)(properties.healthCheckId));
    errors.collect(cdk.propertyValidator('hostedZoneId', cdk.validateString)(properties.hostedZoneId));
    errors.collect(cdk.propertyValidator('hostedZoneName', cdk.validateString)(properties.hostedZoneName));
    errors.collect(cdk.propertyValidator('multiValueAnswer', cdk.validateBoolean)(properties.multiValueAnswer));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('region', cdk.validateString)(properties.region));
    errors.collect(cdk.propertyValidator('resourceRecords', cdk.listValidator(cdk.validateString))(properties.resourceRecords));
    errors.collect(cdk.propertyValidator('setIdentifier', cdk.validateString)(properties.setIdentifier));
    errors.collect(cdk.propertyValidator('ttl', cdk.validateString)(properties.ttl));
    errors.collect(cdk.propertyValidator('type', cdk.requiredValidator)(properties.type));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    errors.collect(cdk.propertyValidator('weight', cdk.validateNumber)(properties.weight));
    return errors.wrap('supplied properties not correct for "CfnRecordSetProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::RecordSet` resource
 *
 * @param properties - the TypeScript properties of a `CfnRecordSetProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::RecordSet` resource.
 */
// @ts-ignore TS6133
function cfnRecordSetPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRecordSetPropsValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        Type: cdk.stringToCloudFormation(properties.type),
        AliasTarget: cfnRecordSetAliasTargetPropertyToCloudFormation(properties.aliasTarget),
        CidrRoutingConfig: cfnRecordSetCidrRoutingConfigPropertyToCloudFormation(properties.cidrRoutingConfig),
        Comment: cdk.stringToCloudFormation(properties.comment),
        Failover: cdk.stringToCloudFormation(properties.failover),
        GeoLocation: cfnRecordSetGeoLocationPropertyToCloudFormation(properties.geoLocation),
        HealthCheckId: cdk.stringToCloudFormation(properties.healthCheckId),
        HostedZoneId: cdk.stringToCloudFormation(properties.hostedZoneId),
        HostedZoneName: cdk.stringToCloudFormation(properties.hostedZoneName),
        MultiValueAnswer: cdk.booleanToCloudFormation(properties.multiValueAnswer),
        Region: cdk.stringToCloudFormation(properties.region),
        ResourceRecords: cdk.listMapper(cdk.stringToCloudFormation)(properties.resourceRecords),
        SetIdentifier: cdk.stringToCloudFormation(properties.setIdentifier),
        TTL: cdk.stringToCloudFormation(properties.ttl),
        Weight: cdk.numberToCloudFormation(properties.weight),
    };
}
// @ts-ignore TS6133
function CfnRecordSetPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('type', 'Type', cfn_parse.FromCloudFormation.getString(properties.Type));
    ret.addPropertyResult('aliasTarget', 'AliasTarget', properties.AliasTarget != null ? CfnRecordSetAliasTargetPropertyFromCloudFormation(properties.AliasTarget) : undefined);
    ret.addPropertyResult('cidrRoutingConfig', 'CidrRoutingConfig', properties.CidrRoutingConfig != null ? CfnRecordSetCidrRoutingConfigPropertyFromCloudFormation(properties.CidrRoutingConfig) : undefined);
    ret.addPropertyResult('comment', 'Comment', properties.Comment != null ? cfn_parse.FromCloudFormation.getString(properties.Comment) : undefined);
    ret.addPropertyResult('failover', 'Failover', properties.Failover != null ? cfn_parse.FromCloudFormation.getString(properties.Failover) : undefined);
    ret.addPropertyResult('geoLocation', 'GeoLocation', properties.GeoLocation != null ? CfnRecordSetGeoLocationPropertyFromCloudFormation(properties.GeoLocation) : undefined);
    ret.addPropertyResult('healthCheckId', 'HealthCheckId', properties.HealthCheckId != null ? cfn_parse.FromCloudFormation.getString(properties.HealthCheckId) : undefined);
    ret.addPropertyResult('hostedZoneId', 'HostedZoneId', properties.HostedZoneId != null ? cfn_parse.FromCloudFormation.getString(properties.HostedZoneId) : undefined);
    ret.addPropertyResult('hostedZoneName', 'HostedZoneName', properties.HostedZoneName != null ? cfn_parse.FromCloudFormation.getString(properties.HostedZoneName) : undefined);
    ret.addPropertyResult('multiValueAnswer', 'MultiValueAnswer', properties.MultiValueAnswer != null ? cfn_parse.FromCloudFormation.getBoolean(properties.MultiValueAnswer) : undefined);
    ret.addPropertyResult('region', 'Region', properties.Region != null ? cfn_parse.FromCloudFormation.getString(properties.Region) : undefined);
    ret.addPropertyResult('resourceRecords', 'ResourceRecords', properties.ResourceRecords != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ResourceRecords) : undefined);
    ret.addPropertyResult('setIdentifier', 'SetIdentifier', properties.SetIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.SetIdentifier) : undefined);
    ret.addPropertyResult('ttl', 'TTL', properties.TTL != null ? cfn_parse.FromCloudFormation.getString(properties.TTL) : undefined);
    ret.addPropertyResult('weight', 'Weight', properties.Weight != null ? cfn_parse.FromCloudFormation.getNumber(properties.Weight) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Route53::RecordSet`
 *
 * Information about the record that you want to create.
 *
 * The `AWS::Route53::RecordSet` type can be used as a standalone resource or as an embedded property in the `AWS::Route53::RecordSetGroup` type. Note that some `AWS::Route53::RecordSet` properties are valid only when used within `AWS::Route53::RecordSetGroup` .
 *
 * For more information, see [ChangeResourceRecordSets](https://docs.aws.amazon.com/Route53/latest/APIReference/API_ChangeResourceRecordSets.html) in the *Amazon Route 53 API Reference* .
 *
 * @cloudformationResource AWS::Route53::RecordSet
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html
 */
class CfnRecordSet extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnRecordSetPropsFromCloudFormation(resourceProperties);
        const ret = new CfnRecordSet(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::Route53::RecordSet`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnRecordSet.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_route53_CfnRecordSetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnRecordSet);
            }
            throw error;
        }
        cdk.requireProperty(props, 'name', this);
        cdk.requireProperty(props, 'type', this);
        this.name = props.name;
        this.type = props.type;
        this.aliasTarget = props.aliasTarget;
        this.cidrRoutingConfig = props.cidrRoutingConfig;
        this.comment = props.comment;
        this.failover = props.failover;
        this.geoLocation = props.geoLocation;
        this.healthCheckId = props.healthCheckId;
        this.hostedZoneId = props.hostedZoneId;
        this.hostedZoneName = props.hostedZoneName;
        this.multiValueAnswer = props.multiValueAnswer;
        this.region = props.region;
        this.resourceRecords = props.resourceRecords;
        this.setIdentifier = props.setIdentifier;
        this.ttl = props.ttl;
        this.weight = props.weight;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnRecordSet.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            name: this.name,
            type: this.type,
            aliasTarget: this.aliasTarget,
            cidrRoutingConfig: this.cidrRoutingConfig,
            comment: this.comment,
            failover: this.failover,
            geoLocation: this.geoLocation,
            healthCheckId: this.healthCheckId,
            hostedZoneId: this.hostedZoneId,
            hostedZoneName: this.hostedZoneName,
            multiValueAnswer: this.multiValueAnswer,
            region: this.region,
            resourceRecords: this.resourceRecords,
            setIdentifier: this.setIdentifier,
            ttl: this.ttl,
            weight: this.weight,
        };
    }
    renderProperties(props) {
        return cfnRecordSetPropsToCloudFormation(props);
    }
}
_f = JSII_RTTI_SYMBOL_1;
CfnRecordSet[_f] = { fqn: "aws-cdk-lib.aws_route53.CfnRecordSet", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnRecordSet.CFN_RESOURCE_TYPE_NAME = "AWS::Route53::RecordSet";
exports.CfnRecordSet = CfnRecordSet;
/**
 * Determine whether the given properties match those of a `AliasTargetProperty`
 *
 * @param properties - the TypeScript properties of a `AliasTargetProperty`
 *
 * @returns the result of the validation.
 */
function CfnRecordSet_AliasTargetPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dnsName', cdk.requiredValidator)(properties.dnsName));
    errors.collect(cdk.propertyValidator('dnsName', cdk.validateString)(properties.dnsName));
    errors.collect(cdk.propertyValidator('evaluateTargetHealth', cdk.validateBoolean)(properties.evaluateTargetHealth));
    errors.collect(cdk.propertyValidator('hostedZoneId', cdk.requiredValidator)(properties.hostedZoneId));
    errors.collect(cdk.propertyValidator('hostedZoneId', cdk.validateString)(properties.hostedZoneId));
    return errors.wrap('supplied properties not correct for "AliasTargetProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::RecordSet.AliasTarget` resource
 *
 * @param properties - the TypeScript properties of a `AliasTargetProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::RecordSet.AliasTarget` resource.
 */
// @ts-ignore TS6133
function cfnRecordSetAliasTargetPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRecordSet_AliasTargetPropertyValidator(properties).assertSuccess();
    return {
        DNSName: cdk.stringToCloudFormation(properties.dnsName),
        EvaluateTargetHealth: cdk.booleanToCloudFormation(properties.evaluateTargetHealth),
        HostedZoneId: cdk.stringToCloudFormation(properties.hostedZoneId),
    };
}
// @ts-ignore TS6133
function CfnRecordSetAliasTargetPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dnsName', 'DNSName', cfn_parse.FromCloudFormation.getString(properties.DNSName));
    ret.addPropertyResult('evaluateTargetHealth', 'EvaluateTargetHealth', properties.EvaluateTargetHealth != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EvaluateTargetHealth) : undefined);
    ret.addPropertyResult('hostedZoneId', 'HostedZoneId', cfn_parse.FromCloudFormation.getString(properties.HostedZoneId));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CidrRoutingConfigProperty`
 *
 * @param properties - the TypeScript properties of a `CidrRoutingConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnRecordSet_CidrRoutingConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('collectionId', cdk.requiredValidator)(properties.collectionId));
    errors.collect(cdk.propertyValidator('collectionId', cdk.validateString)(properties.collectionId));
    errors.collect(cdk.propertyValidator('locationName', cdk.requiredValidator)(properties.locationName));
    errors.collect(cdk.propertyValidator('locationName', cdk.validateString)(properties.locationName));
    return errors.wrap('supplied properties not correct for "CidrRoutingConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::RecordSet.CidrRoutingConfig` resource
 *
 * @param properties - the TypeScript properties of a `CidrRoutingConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::RecordSet.CidrRoutingConfig` resource.
 */
// @ts-ignore TS6133
function cfnRecordSetCidrRoutingConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRecordSet_CidrRoutingConfigPropertyValidator(properties).assertSuccess();
    return {
        CollectionId: cdk.stringToCloudFormation(properties.collectionId),
        LocationName: cdk.stringToCloudFormation(properties.locationName),
    };
}
// @ts-ignore TS6133
function CfnRecordSetCidrRoutingConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('collectionId', 'CollectionId', cfn_parse.FromCloudFormation.getString(properties.CollectionId));
    ret.addPropertyResult('locationName', 'LocationName', cfn_parse.FromCloudFormation.getString(properties.LocationName));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `GeoLocationProperty`
 *
 * @param properties - the TypeScript properties of a `GeoLocationProperty`
 *
 * @returns the result of the validation.
 */
function CfnRecordSet_GeoLocationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('continentCode', cdk.validateString)(properties.continentCode));
    errors.collect(cdk.propertyValidator('countryCode', cdk.validateString)(properties.countryCode));
    errors.collect(cdk.propertyValidator('subdivisionCode', cdk.validateString)(properties.subdivisionCode));
    return errors.wrap('supplied properties not correct for "GeoLocationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::RecordSet.GeoLocation` resource
 *
 * @param properties - the TypeScript properties of a `GeoLocationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::RecordSet.GeoLocation` resource.
 */
// @ts-ignore TS6133
function cfnRecordSetGeoLocationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRecordSet_GeoLocationPropertyValidator(properties).assertSuccess();
    return {
        ContinentCode: cdk.stringToCloudFormation(properties.continentCode),
        CountryCode: cdk.stringToCloudFormation(properties.countryCode),
        SubdivisionCode: cdk.stringToCloudFormation(properties.subdivisionCode),
    };
}
// @ts-ignore TS6133
function CfnRecordSetGeoLocationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('continentCode', 'ContinentCode', properties.ContinentCode != null ? cfn_parse.FromCloudFormation.getString(properties.ContinentCode) : undefined);
    ret.addPropertyResult('countryCode', 'CountryCode', properties.CountryCode != null ? cfn_parse.FromCloudFormation.getString(properties.CountryCode) : undefined);
    ret.addPropertyResult('subdivisionCode', 'SubdivisionCode', properties.SubdivisionCode != null ? cfn_parse.FromCloudFormation.getString(properties.SubdivisionCode) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnRecordSetGroupProps`
 *
 * @param properties - the TypeScript properties of a `CfnRecordSetGroupProps`
 *
 * @returns the result of the validation.
 */
function CfnRecordSetGroupPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('comment', cdk.validateString)(properties.comment));
    errors.collect(cdk.propertyValidator('hostedZoneId', cdk.validateString)(properties.hostedZoneId));
    errors.collect(cdk.propertyValidator('hostedZoneName', cdk.validateString)(properties.hostedZoneName));
    errors.collect(cdk.propertyValidator('recordSets', cdk.listValidator(CfnRecordSetGroup_RecordSetPropertyValidator))(properties.recordSets));
    return errors.wrap('supplied properties not correct for "CfnRecordSetGroupProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::RecordSetGroup` resource
 *
 * @param properties - the TypeScript properties of a `CfnRecordSetGroupProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::RecordSetGroup` resource.
 */
// @ts-ignore TS6133
function cfnRecordSetGroupPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRecordSetGroupPropsValidator(properties).assertSuccess();
    return {
        Comment: cdk.stringToCloudFormation(properties.comment),
        HostedZoneId: cdk.stringToCloudFormation(properties.hostedZoneId),
        HostedZoneName: cdk.stringToCloudFormation(properties.hostedZoneName),
        RecordSets: cdk.listMapper(cfnRecordSetGroupRecordSetPropertyToCloudFormation)(properties.recordSets),
    };
}
// @ts-ignore TS6133
function CfnRecordSetGroupPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('comment', 'Comment', properties.Comment != null ? cfn_parse.FromCloudFormation.getString(properties.Comment) : undefined);
    ret.addPropertyResult('hostedZoneId', 'HostedZoneId', properties.HostedZoneId != null ? cfn_parse.FromCloudFormation.getString(properties.HostedZoneId) : undefined);
    ret.addPropertyResult('hostedZoneName', 'HostedZoneName', properties.HostedZoneName != null ? cfn_parse.FromCloudFormation.getString(properties.HostedZoneName) : undefined);
    ret.addPropertyResult('recordSets', 'RecordSets', properties.RecordSets != null ? cfn_parse.FromCloudFormation.getArray(CfnRecordSetGroupRecordSetPropertyFromCloudFormation)(properties.RecordSets) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Route53::RecordSetGroup`
 *
 * A complex type that contains an optional comment, the name and ID of the hosted zone that you want to make changes in, and values for the records that you want to create.
 *
 * @cloudformationResource AWS::Route53::RecordSetGroup
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html
 */
class CfnRecordSetGroup extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnRecordSetGroupPropsFromCloudFormation(resourceProperties);
        const ret = new CfnRecordSetGroup(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::Route53::RecordSetGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnRecordSetGroup.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_route53_CfnRecordSetGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnRecordSetGroup);
            }
            throw error;
        }
        this.comment = props.comment;
        this.hostedZoneId = props.hostedZoneId;
        this.hostedZoneName = props.hostedZoneName;
        this.recordSets = props.recordSets;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnRecordSetGroup.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            comment: this.comment,
            hostedZoneId: this.hostedZoneId,
            hostedZoneName: this.hostedZoneName,
            recordSets: this.recordSets,
        };
    }
    renderProperties(props) {
        return cfnRecordSetGroupPropsToCloudFormation(props);
    }
}
_g = JSII_RTTI_SYMBOL_1;
CfnRecordSetGroup[_g] = { fqn: "aws-cdk-lib.aws_route53.CfnRecordSetGroup", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnRecordSetGroup.CFN_RESOURCE_TYPE_NAME = "AWS::Route53::RecordSetGroup";
exports.CfnRecordSetGroup = CfnRecordSetGroup;
/**
 * Determine whether the given properties match those of a `AliasTargetProperty`
 *
 * @param properties - the TypeScript properties of a `AliasTargetProperty`
 *
 * @returns the result of the validation.
 */
function CfnRecordSetGroup_AliasTargetPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dnsName', cdk.requiredValidator)(properties.dnsName));
    errors.collect(cdk.propertyValidator('dnsName', cdk.validateString)(properties.dnsName));
    errors.collect(cdk.propertyValidator('evaluateTargetHealth', cdk.validateBoolean)(properties.evaluateTargetHealth));
    errors.collect(cdk.propertyValidator('hostedZoneId', cdk.requiredValidator)(properties.hostedZoneId));
    errors.collect(cdk.propertyValidator('hostedZoneId', cdk.validateString)(properties.hostedZoneId));
    return errors.wrap('supplied properties not correct for "AliasTargetProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::RecordSetGroup.AliasTarget` resource
 *
 * @param properties - the TypeScript properties of a `AliasTargetProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::RecordSetGroup.AliasTarget` resource.
 */
// @ts-ignore TS6133
function cfnRecordSetGroupAliasTargetPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRecordSetGroup_AliasTargetPropertyValidator(properties).assertSuccess();
    return {
        DNSName: cdk.stringToCloudFormation(properties.dnsName),
        EvaluateTargetHealth: cdk.booleanToCloudFormation(properties.evaluateTargetHealth),
        HostedZoneId: cdk.stringToCloudFormation(properties.hostedZoneId),
    };
}
// @ts-ignore TS6133
function CfnRecordSetGroupAliasTargetPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dnsName', 'DNSName', cfn_parse.FromCloudFormation.getString(properties.DNSName));
    ret.addPropertyResult('evaluateTargetHealth', 'EvaluateTargetHealth', properties.EvaluateTargetHealth != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EvaluateTargetHealth) : undefined);
    ret.addPropertyResult('hostedZoneId', 'HostedZoneId', cfn_parse.FromCloudFormation.getString(properties.HostedZoneId));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CidrRoutingConfigProperty`
 *
 * @param properties - the TypeScript properties of a `CidrRoutingConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnRecordSetGroup_CidrRoutingConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('collectionId', cdk.requiredValidator)(properties.collectionId));
    errors.collect(cdk.propertyValidator('collectionId', cdk.validateString)(properties.collectionId));
    errors.collect(cdk.propertyValidator('locationName', cdk.requiredValidator)(properties.locationName));
    errors.collect(cdk.propertyValidator('locationName', cdk.validateString)(properties.locationName));
    return errors.wrap('supplied properties not correct for "CidrRoutingConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::RecordSetGroup.CidrRoutingConfig` resource
 *
 * @param properties - the TypeScript properties of a `CidrRoutingConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::RecordSetGroup.CidrRoutingConfig` resource.
 */
// @ts-ignore TS6133
function cfnRecordSetGroupCidrRoutingConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRecordSetGroup_CidrRoutingConfigPropertyValidator(properties).assertSuccess();
    return {
        CollectionId: cdk.stringToCloudFormation(properties.collectionId),
        LocationName: cdk.stringToCloudFormation(properties.locationName),
    };
}
// @ts-ignore TS6133
function CfnRecordSetGroupCidrRoutingConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('collectionId', 'CollectionId', cfn_parse.FromCloudFormation.getString(properties.CollectionId));
    ret.addPropertyResult('locationName', 'LocationName', cfn_parse.FromCloudFormation.getString(properties.LocationName));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `GeoLocationProperty`
 *
 * @param properties - the TypeScript properties of a `GeoLocationProperty`
 *
 * @returns the result of the validation.
 */
function CfnRecordSetGroup_GeoLocationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('continentCode', cdk.validateString)(properties.continentCode));
    errors.collect(cdk.propertyValidator('countryCode', cdk.validateString)(properties.countryCode));
    errors.collect(cdk.propertyValidator('subdivisionCode', cdk.validateString)(properties.subdivisionCode));
    return errors.wrap('supplied properties not correct for "GeoLocationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::RecordSetGroup.GeoLocation` resource
 *
 * @param properties - the TypeScript properties of a `GeoLocationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::RecordSetGroup.GeoLocation` resource.
 */
// @ts-ignore TS6133
function cfnRecordSetGroupGeoLocationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRecordSetGroup_GeoLocationPropertyValidator(properties).assertSuccess();
    return {
        ContinentCode: cdk.stringToCloudFormation(properties.continentCode),
        CountryCode: cdk.stringToCloudFormation(properties.countryCode),
        SubdivisionCode: cdk.stringToCloudFormation(properties.subdivisionCode),
    };
}
// @ts-ignore TS6133
function CfnRecordSetGroupGeoLocationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('continentCode', 'ContinentCode', properties.ContinentCode != null ? cfn_parse.FromCloudFormation.getString(properties.ContinentCode) : undefined);
    ret.addPropertyResult('countryCode', 'CountryCode', properties.CountryCode != null ? cfn_parse.FromCloudFormation.getString(properties.CountryCode) : undefined);
    ret.addPropertyResult('subdivisionCode', 'SubdivisionCode', properties.SubdivisionCode != null ? cfn_parse.FromCloudFormation.getString(properties.SubdivisionCode) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `RecordSetProperty`
 *
 * @param properties - the TypeScript properties of a `RecordSetProperty`
 *
 * @returns the result of the validation.
 */
function CfnRecordSetGroup_RecordSetPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('aliasTarget', CfnRecordSetGroup_AliasTargetPropertyValidator)(properties.aliasTarget));
    errors.collect(cdk.propertyValidator('cidrRoutingConfig', CfnRecordSetGroup_CidrRoutingConfigPropertyValidator)(properties.cidrRoutingConfig));
    errors.collect(cdk.propertyValidator('failover', cdk.validateString)(properties.failover));
    errors.collect(cdk.propertyValidator('geoLocation', CfnRecordSetGroup_GeoLocationPropertyValidator)(properties.geoLocation));
    errors.collect(cdk.propertyValidator('healthCheckId', cdk.validateString)(properties.healthCheckId));
    errors.collect(cdk.propertyValidator('hostedZoneId', cdk.validateString)(properties.hostedZoneId));
    errors.collect(cdk.propertyValidator('hostedZoneName', cdk.validateString)(properties.hostedZoneName));
    errors.collect(cdk.propertyValidator('multiValueAnswer', cdk.validateBoolean)(properties.multiValueAnswer));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('region', cdk.validateString)(properties.region));
    errors.collect(cdk.propertyValidator('resourceRecords', cdk.listValidator(cdk.validateString))(properties.resourceRecords));
    errors.collect(cdk.propertyValidator('setIdentifier', cdk.validateString)(properties.setIdentifier));
    errors.collect(cdk.propertyValidator('ttl', cdk.validateString)(properties.ttl));
    errors.collect(cdk.propertyValidator('type', cdk.requiredValidator)(properties.type));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    errors.collect(cdk.propertyValidator('weight', cdk.validateNumber)(properties.weight));
    return errors.wrap('supplied properties not correct for "RecordSetProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::RecordSetGroup.RecordSet` resource
 *
 * @param properties - the TypeScript properties of a `RecordSetProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::RecordSetGroup.RecordSet` resource.
 */
// @ts-ignore TS6133
function cfnRecordSetGroupRecordSetPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRecordSetGroup_RecordSetPropertyValidator(properties).assertSuccess();
    return {
        AliasTarget: cfnRecordSetGroupAliasTargetPropertyToCloudFormation(properties.aliasTarget),
        CidrRoutingConfig: cfnRecordSetGroupCidrRoutingConfigPropertyToCloudFormation(properties.cidrRoutingConfig),
        Failover: cdk.stringToCloudFormation(properties.failover),
        GeoLocation: cfnRecordSetGroupGeoLocationPropertyToCloudFormation(properties.geoLocation),
        HealthCheckId: cdk.stringToCloudFormation(properties.healthCheckId),
        HostedZoneId: cdk.stringToCloudFormation(properties.hostedZoneId),
        HostedZoneName: cdk.stringToCloudFormation(properties.hostedZoneName),
        MultiValueAnswer: cdk.booleanToCloudFormation(properties.multiValueAnswer),
        Name: cdk.stringToCloudFormation(properties.name),
        Region: cdk.stringToCloudFormation(properties.region),
        ResourceRecords: cdk.listMapper(cdk.stringToCloudFormation)(properties.resourceRecords),
        SetIdentifier: cdk.stringToCloudFormation(properties.setIdentifier),
        TTL: cdk.stringToCloudFormation(properties.ttl),
        Type: cdk.stringToCloudFormation(properties.type),
        Weight: cdk.numberToCloudFormation(properties.weight),
    };
}
// @ts-ignore TS6133
function CfnRecordSetGroupRecordSetPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('aliasTarget', 'AliasTarget', properties.AliasTarget != null ? CfnRecordSetGroupAliasTargetPropertyFromCloudFormation(properties.AliasTarget) : undefined);
    ret.addPropertyResult('cidrRoutingConfig', 'CidrRoutingConfig', properties.CidrRoutingConfig != null ? CfnRecordSetGroupCidrRoutingConfigPropertyFromCloudFormation(properties.CidrRoutingConfig) : undefined);
    ret.addPropertyResult('failover', 'Failover', properties.Failover != null ? cfn_parse.FromCloudFormation.getString(properties.Failover) : undefined);
    ret.addPropertyResult('geoLocation', 'GeoLocation', properties.GeoLocation != null ? CfnRecordSetGroupGeoLocationPropertyFromCloudFormation(properties.GeoLocation) : undefined);
    ret.addPropertyResult('healthCheckId', 'HealthCheckId', properties.HealthCheckId != null ? cfn_parse.FromCloudFormation.getString(properties.HealthCheckId) : undefined);
    ret.addPropertyResult('hostedZoneId', 'HostedZoneId', properties.HostedZoneId != null ? cfn_parse.FromCloudFormation.getString(properties.HostedZoneId) : undefined);
    ret.addPropertyResult('hostedZoneName', 'HostedZoneName', properties.HostedZoneName != null ? cfn_parse.FromCloudFormation.getString(properties.HostedZoneName) : undefined);
    ret.addPropertyResult('multiValueAnswer', 'MultiValueAnswer', properties.MultiValueAnswer != null ? cfn_parse.FromCloudFormation.getBoolean(properties.MultiValueAnswer) : undefined);
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('region', 'Region', properties.Region != null ? cfn_parse.FromCloudFormation.getString(properties.Region) : undefined);
    ret.addPropertyResult('resourceRecords', 'ResourceRecords', properties.ResourceRecords != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ResourceRecords) : undefined);
    ret.addPropertyResult('setIdentifier', 'SetIdentifier', properties.SetIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.SetIdentifier) : undefined);
    ret.addPropertyResult('ttl', 'TTL', properties.TTL != null ? cfn_parse.FromCloudFormation.getString(properties.TTL) : undefined);
    ret.addPropertyResult('type', 'Type', cfn_parse.FromCloudFormation.getString(properties.Type));
    ret.addPropertyResult('weight', 'Weight', properties.Weight != null ? cfn_parse.FromCloudFormation.getNumber(properties.Weight) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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