"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaDestination = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
const s3 = require("../../aws-s3");
const core_1 = require("../../core");
const constructs_1 = require("constructs");
/**
 * Use a Lambda function as a bucket notification destination
 */
class LambdaDestination {
    constructor(fn) {
        this.fn = fn;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_IFunction(fn);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, LambdaDestination);
            }
            throw error;
        }
    }
    bind(_scope, bucket) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_s3_IBucket(bucket);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        const permissionId = `AllowBucketNotificationsTo${core_1.Names.nodeUniqueId(this.fn.permissionsNode)}`;
        if (!(bucket instanceof constructs_1.Construct)) {
            throw new Error(`LambdaDestination for function ${core_1.Names.nodeUniqueId(this.fn.permissionsNode)} can only be configured on a
        bucket construct (Bucket ${bucket.bucketName})`);
        }
        if (bucket.node.tryFindChild(permissionId) === undefined) {
            this.fn.addPermission(permissionId, {
                sourceAccount: core_1.Stack.of(bucket).account,
                principal: new iam.ServicePrincipal('s3.amazonaws.com'),
                sourceArn: bucket.bucketArn,
                // Placing the permissions node in the same scope as the s3 bucket.
                // Otherwise, there is a circular dependency when the s3 bucket
                // and lambda functions declared in different stacks.
                scope: bucket,
            });
        }
        // if we have a permission resource for this relationship, add it as a dependency
        // to the bucket notifications resource, so it will be created first.
        const permission = bucket.node.tryFindChild(permissionId);
        return {
            type: s3.BucketNotificationDestinationType.LAMBDA,
            arn: this.fn.functionArn,
            dependencies: permission ? [permission] : undefined,
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
LambdaDestination[_a] = { fqn: "aws-cdk-lib.aws_s3_notifications.LambdaDestination", version: "2.74.0" };
exports.LambdaDestination = LambdaDestination;
//# sourceMappingURL=data:application/json;base64,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