"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KEY_WRITE_ACTIONS = exports.KEY_READ_ACTIONS = exports.BUCKET_DELETE_ACTIONS = exports.BUCKET_PUT_ACL_ACTIONS = exports.BUCKET_PUT_ACTIONS = exports.LEGACY_BUCKET_PUT_ACTIONS = exports.BUCKET_READ_METADATA_ACTIONS = exports.BUCKET_READ_ACTIONS = void 0;
exports.BUCKET_READ_ACTIONS = [
    's3:GetObject*',
    's3:GetBucket*',
    's3:List*',
];
exports.BUCKET_READ_METADATA_ACTIONS = [
    's3:GetBucket*',
    's3:List*',
];
exports.LEGACY_BUCKET_PUT_ACTIONS = [
    's3:PutObject*',
    's3:Abort*',
];
exports.BUCKET_PUT_ACTIONS = [
    's3:PutObject',
    's3:PutObjectLegalHold',
    's3:PutObjectRetention',
    's3:PutObjectTagging',
    's3:PutObjectVersionTagging',
    's3:Abort*',
];
exports.BUCKET_PUT_ACL_ACTIONS = [
    's3:PutObjectAcl',
    's3:PutObjectVersionAcl',
];
exports.BUCKET_DELETE_ACTIONS = [
    's3:DeleteObject*',
];
exports.KEY_READ_ACTIONS = [
    'kms:Decrypt',
    'kms:DescribeKey',
];
exports.KEY_WRITE_ACTIONS = [
    'kms:Encrypt',
    'kms:ReEncrypt*',
    'kms:GenerateDataKey*',
    'kms:Decrypt', // required for multipart uploads. Refer https://aws.amazon.com/premiumsupport/knowledge-center/s3-multipart-kms-decrypt/
];
//# sourceMappingURL=data:application/json;base64,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