"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductStackHistory = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const core_1 = require("../../core");
const constructs_1 = require("constructs");
const cloudformation_template_1 = require("./cloudformation-template");
const common_1 = require("./common");
/**
 * A Construct that contains a Service Catalog product stack with its previous deployments maintained.
 */
class ProductStackHistory extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_servicecatalog_ProductStackHistoryProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ProductStackHistory);
            }
            throw error;
        }
        props.productStack._setParentProductStackHistory(this);
        this.props = props;
    }
    /**
     * Retains product stack template as a snapshot when deployed and
     * retrieves a CloudFormationProductVersion for the current product version.
     */
    currentVersion() {
        return {
            cloudFormationTemplate: cloudformation_template_1.CloudFormationTemplate.fromProductStack(this.props.productStack),
            productVersionName: this.props.currentVersionName,
            description: this.props.description,
        };
    }
    /**
     * Retrieves a CloudFormationProductVersion from a previously deployed productVersionName.
     */
    versionFromSnapshot(productVersionName) {
        const productStackSnapshotDirectory = this.props.directory || common_1.DEFAULT_PRODUCT_STACK_SNAPSHOT_DIRECTORY;
        const templateFileKey = `${core_1.Names.uniqueId(this)}.${this.props.productStack.artifactId}.${productVersionName}.product.template.json`;
        const templateFilePath = path.join(productStackSnapshotDirectory, templateFileKey);
        if (!fs.existsSync(templateFilePath)) {
            throw new Error(`Template ${templateFileKey} cannot be found in ${productStackSnapshotDirectory}`);
        }
        return {
            cloudFormationTemplate: cloudformation_template_1.CloudFormationTemplate.fromAsset(templateFilePath),
            productVersionName: productVersionName,
            description: this.props.description,
        };
    }
    /**
     * Writes current template generated from Product Stack to a snapshot directory.
     *
     * @internal
     */
    _writeTemplateToSnapshot(cfn) {
        const productStackSnapshotDirectory = this.props.directory || common_1.DEFAULT_PRODUCT_STACK_SNAPSHOT_DIRECTORY;
        if (!fs.existsSync(productStackSnapshotDirectory)) {
            fs.mkdirSync(productStackSnapshotDirectory, { recursive: true });
        }
        const templateFileKey = `${core_1.Names.uniqueId(this)}.${this.props.productStack.artifactId}.${this.props.currentVersionName}.product.template.json`;
        const templateFilePath = path.join(productStackSnapshotDirectory, templateFileKey);
        if (fs.existsSync(templateFilePath)) {
            const previousCfn = fs.readFileSync(templateFilePath).toString();
            if (previousCfn !== cfn && this.props.currentVersionLocked) {
                throw new Error(`Template has changed for ProductStack Version ${this.props.currentVersionName}.
        ${this.props.currentVersionName} already exist in ${productStackSnapshotDirectory}.
        Since locked has been set to ${this.props.currentVersionLocked},
        Either update the currentVersionName to deploy a new version or deploy the existing ProductStack snapshot.
        If ${this.props.currentVersionName} was unintentionally synthesized and not deployed, 
        delete the corresponding version from ${productStackSnapshotDirectory} and redeploy.`);
            }
        }
        fs.writeFileSync(templateFilePath, cfn);
    }
}
_a = JSII_RTTI_SYMBOL_1;
ProductStackHistory[_a] = { fqn: "aws-cdk-lib.aws_servicecatalog.ProductStackHistory", version: "2.74.0" };
exports.ProductStackHistory = ProductStackHistory;
//# sourceMappingURL=data:application/json;base64,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