"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CnameInstance = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const instance_1 = require("./instance");
const namespace_1 = require("./namespace");
const service_1 = require("./service");
const servicediscovery_generated_1 = require("./servicediscovery.generated");
/**
 * Instance that is accessible using a domain name (CNAME).
 * @resource AWS::ServiceDiscovery::Instance
 */
class CnameInstance extends instance_1.InstanceBase {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_servicediscovery_CnameInstanceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CnameInstance);
            }
            throw error;
        }
        if (props.service.namespace.type === namespace_1.NamespaceType.HTTP) {
            throw new Error('Namespace associated with Service must be a DNS Namespace.');
        }
        if (props.service.dnsRecordType !== service_1.DnsRecordType.CNAME) {
            throw new Error('A `CnameIntance` can only be used with a service using a `CNAME` record.');
        }
        const resource = new servicediscovery_generated_1.CfnInstance(this, 'Resource', {
            instanceId: props.instanceId || this.uniqueInstanceId(),
            serviceId: props.service.serviceId,
            instanceAttributes: {
                AWS_INSTANCE_CNAME: props.instanceCname,
                ...props.customAttributes,
            },
        });
        this.service = props.service;
        this.instanceId = resource.ref;
        this.cname = props.instanceCname;
    }
}
_a = JSII_RTTI_SYMBOL_1;
CnameInstance[_a] = { fqn: "aws-cdk-lib.aws_servicediscovery.CnameInstance", version: "2.74.0" };
exports.CnameInstance = CnameInstance;
//# sourceMappingURL=data:application/json;base64,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