"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
class InstanceBase extends core_1.Resource {
    /**
     * Generate a unique instance Id that is safe to pass to CloudMap
     */
    uniqueInstanceId() {
        // Max length of 64 chars, get the last 64 chars
        const id = core_1.Names.uniqueId(this);
        return id.substring(Math.max(id.length - 64, 0), id.length);
    }
}
_a = JSII_RTTI_SYMBOL_1;
InstanceBase[_a] = { fqn: "aws-cdk-lib.aws_servicediscovery.InstanceBase", version: "2.74.0" };
exports.InstanceBase = InstanceBase;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5zdGFuY2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbnN0YW5jZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLHFDQUF3RDtBQW9DeEQsTUFBc0IsWUFBYSxTQUFRLGVBQVE7SUFXakQ7O09BRUc7SUFDTyxnQkFBZ0I7UUFDeEIsZ0RBQWdEO1FBQ2hELE1BQU0sRUFBRSxHQUFHLFlBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDaEMsT0FBTyxFQUFFLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLE1BQU0sR0FBRyxFQUFFLEVBQUUsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLE1BQU0sQ0FBQyxDQUFDO0tBQzdEOzs7O0FBbEJtQixvQ0FBWSIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IElSZXNvdXJjZSwgTmFtZXMsIFJlc291cmNlIH0gZnJvbSAnLi4vLi4vY29yZSc7XG5pbXBvcnQgeyBJU2VydmljZSB9IGZyb20gJy4vc2VydmljZSc7XG5cbmV4cG9ydCBpbnRlcmZhY2UgSUluc3RhbmNlIGV4dGVuZHMgSVJlc291cmNlIHtcbiAgLyoqXG4gICAqIFRoZSBpZCBvZiB0aGUgaW5zdGFuY2UgcmVzb3VyY2VcbiAgICogQGF0dHJpYnV0ZVxuICAgKi9cbiAgcmVhZG9ubHkgaW5zdGFuY2VJZDogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgQ2xvdWRtYXAgc2VydmljZSB0aGlzIHJlc291cmNlIGlzIHJlZ2lzdGVyZWQgdG8uXG4gICAqL1xuICByZWFkb25seSBzZXJ2aWNlOiBJU2VydmljZTtcbn1cblxuLyoqXG4gKiBVc2VkIHdoZW4gdGhlIHJlc291cmNlIHRoYXQncyBhc3NvY2lhdGVkIHdpdGggdGhlIHNlcnZpY2UgaW5zdGFuY2UgaXMgYWNjZXNzaWJsZSB1c2luZyB2YWx1ZXMgb3RoZXIgdGhhbiBhbiBJUFxuICogYWRkcmVzcyBvciBhIGRvbWFpbiBuYW1lIChDTkFNRSksIGkuZS4gZm9yIG5vbi1pcC1pbnN0YW5jZXNcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBCYXNlSW5zdGFuY2VQcm9wcyB7XG4gIC8qKlxuICAgKiBUaGUgaWQgb2YgdGhlIGluc3RhbmNlIHJlc291cmNlXG4gICAqXG4gICAqIEBkZWZhdWx0IEF1dG9tYXRpY2FsbHkgZ2VuZXJhdGVkIG5hbWVcbiAgICovXG4gIHJlYWRvbmx5IGluc3RhbmNlSWQ/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEN1c3RvbSBhdHRyaWJ1dGVzIG9mIHRoZSBpbnN0YW5jZS5cbiAgICpcbiAgICogQGRlZmF1bHQgbm9uZVxuICAgKi9cbiAgcmVhZG9ubHkgY3VzdG9tQXR0cmlidXRlcz86IHsgW2tleTogc3RyaW5nXTogc3RyaW5nIH07XG59XG5cbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBJbnN0YW5jZUJhc2UgZXh0ZW5kcyBSZXNvdXJjZSBpbXBsZW1lbnRzIElJbnN0YW5jZSB7XG4gIC8qKlxuICAgKiBUaGUgSWQgb2YgdGhlIGluc3RhbmNlXG4gICAqL1xuICBwdWJsaWMgYWJzdHJhY3QgcmVhZG9ubHkgaW5zdGFuY2VJZDogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgQ2xvdWRtYXAgc2VydmljZSB0byB3aGljaCB0aGUgaW5zdGFuY2UgaXMgcmVnaXN0ZXJlZC5cbiAgICovXG4gIHB1YmxpYyBhYnN0cmFjdCByZWFkb25seSBzZXJ2aWNlOiBJU2VydmljZTtcblxuICAvKipcbiAgICogR2VuZXJhdGUgYSB1bmlxdWUgaW5zdGFuY2UgSWQgdGhhdCBpcyBzYWZlIHRvIHBhc3MgdG8gQ2xvdWRNYXBcbiAgICovXG4gIHByb3RlY3RlZCB1bmlxdWVJbnN0YW5jZUlkKCkge1xuICAgIC8vIE1heCBsZW5ndGggb2YgNjQgY2hhcnMsIGdldCB0aGUgbGFzdCA2NCBjaGFyc1xuICAgIGNvbnN0IGlkID0gTmFtZXMudW5pcXVlSWQodGhpcyk7XG4gICAgcmV0dXJuIGlkLnN1YnN0cmluZyhNYXRoLm1heChpZC5sZW5ndGggLSA2NCwgMCksIGlkLmxlbmd0aCk7XG4gIH1cbn1cbiJdfQ==