"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IpInstance = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const instance_1 = require("./instance");
const service_1 = require("./service");
const servicediscovery_generated_1 = require("./servicediscovery.generated");
/**
 * Instance that is accessible using an IP address.
 *
 * @resource AWS::ServiceDiscovery::Instance
 */
class IpInstance extends instance_1.InstanceBase {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_servicediscovery_IpInstanceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, IpInstance);
            }
            throw error;
        }
        const dnsRecordType = props.service.dnsRecordType;
        if (dnsRecordType === service_1.DnsRecordType.CNAME) {
            throw new Error('Service must support `A`, `AAAA` or `SRV` records to register this instance type.');
        }
        if (dnsRecordType === service_1.DnsRecordType.SRV) {
            if (!props.port) {
                throw new Error('A `port` must be specified for a service using a `SRV` record.');
            }
            if (!props.ipv4 && !props.ipv6) {
                throw new Error('At least `ipv4` or `ipv6` must be specified for a service using a `SRV` record.');
            }
        }
        if (!props.ipv4 && (dnsRecordType === service_1.DnsRecordType.A || dnsRecordType === service_1.DnsRecordType.A_AAAA)) {
            throw new Error('An `ipv4` must be specified for a service using a `A` record.');
        }
        if (!props.ipv6 &&
            (dnsRecordType === service_1.DnsRecordType.AAAA || dnsRecordType === service_1.DnsRecordType.A_AAAA)) {
            throw new Error('An `ipv6` must be specified for a service using a `AAAA` record.');
        }
        const port = props.port || 80;
        const resource = new servicediscovery_generated_1.CfnInstance(this, 'Resource', {
            instanceAttributes: {
                AWS_INSTANCE_IPV4: props.ipv4,
                AWS_INSTANCE_IPV6: props.ipv6,
                AWS_INSTANCE_PORT: port.toString(),
                ...props.customAttributes,
            },
            instanceId: props.instanceId || this.uniqueInstanceId(),
            serviceId: props.service.serviceId,
        });
        this.service = props.service;
        this.instanceId = resource.ref;
        this.ipv4 = props.ipv4 || '';
        this.ipv6 = props.ipv6 || '';
        this.port = port;
    }
}
_a = JSII_RTTI_SYMBOL_1;
IpInstance[_a] = { fqn: "aws-cdk-lib.aws_servicediscovery.IpInstance", version: "2.74.0" };
exports.IpInstance = IpInstance;
//# sourceMappingURL=data:application/json;base64,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