"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PrivateDnsNamespace = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const namespace_1 = require("./namespace");
const service_1 = require("./service");
const servicediscovery_generated_1 = require("./servicediscovery.generated");
/**
 * Define a Service Discovery HTTP Namespace
 */
class PrivateDnsNamespace extends core_1.Resource {
    static fromPrivateDnsNamespaceAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_servicediscovery_PrivateDnsNamespaceAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromPrivateDnsNamespaceAttributes);
            }
            throw error;
        }
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.namespaceName = attrs.namespaceName;
                this.namespaceId = attrs.namespaceId;
                this.namespaceArn = attrs.namespaceArn;
                this.type = namespace_1.NamespaceType.DNS_PRIVATE;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_servicediscovery_PrivateDnsNamespaceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, PrivateDnsNamespace);
            }
            throw error;
        }
        if (props.vpc === undefined) {
            throw new Error('VPC must be specified for PrivateDNSNamespaces');
        }
        const ns = new servicediscovery_generated_1.CfnPrivateDnsNamespace(this, 'Resource', {
            name: props.name,
            description: props.description,
            vpc: props.vpc.vpcId,
        });
        this.namespaceName = props.name;
        this.namespaceId = ns.attrId;
        this.namespaceArn = ns.attrArn;
        this.namespaceHostedZoneId = ns.attrHostedZoneId;
        this.type = namespace_1.NamespaceType.DNS_PRIVATE;
    }
    /** @attribute */
    get privateDnsNamespaceArn() { return this.namespaceArn; }
    /** @attribute */
    get privateDnsNamespaceName() { return this.namespaceName; }
    /** @attribute */
    get privateDnsNamespaceId() { return this.namespaceId; }
    /**
     * Creates a service within the namespace
     */
    createService(id, props) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_servicediscovery_DnsServiceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.createService);
            }
            throw error;
        }
        return new service_1.Service(this, id, {
            namespace: this,
            ...props,
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
PrivateDnsNamespace[_a] = { fqn: "aws-cdk-lib.aws_servicediscovery.PrivateDnsNamespace", version: "2.74.0" };
exports.PrivateDnsNamespace = PrivateDnsNamespace;
//# sourceMappingURL=data:application/json;base64,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