"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3 = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
const cdk = require("../../core");
/**
 * Saves the received message to an Amazon S3 bucket and, optionally, publishes
 * a notification to Amazon SNS.
 */
class S3 {
    constructor(props) {
        this.props = props;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ses_actions_S3Props(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, S3);
            }
            throw error;
        }
    }
    bind(rule) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ses_IReceiptRule(rule);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        // Allow SES to write to S3 bucket
        // See https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html#receiving-email-permissions-s3
        const keyPattern = this.props.objectKeyPrefix || '';
        const s3Statement = new iam.PolicyStatement({
            actions: ['s3:PutObject'],
            principals: [new iam.ServicePrincipal('ses.amazonaws.com')],
            resources: [this.props.bucket.arnForObjects(`${keyPattern}*`)],
            conditions: {
                StringEquals: {
                    'aws:Referer': cdk.Aws.ACCOUNT_ID,
                },
            },
        });
        this.props.bucket.addToResourcePolicy(s3Statement);
        const policy = this.props.bucket.node.tryFindChild('Policy');
        if (policy) { // The bucket could be imported
            rule.node.addDependency(policy);
        }
        else {
            cdk.Annotations.of(rule).addWarning('This rule is using a S3 action with an imported bucket. Ensure permission is given to SES to write to that bucket.');
        }
        // Allow SES to use KMS master key
        // See https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html#receiving-email-permissions-kms
        if (this.props.kmsKey && !/alias\/aws\/ses$/.test(this.props.kmsKey.keyArn)) {
            const kmsStatement = new iam.PolicyStatement({
                actions: ['kms:Encrypt', 'kms:GenerateDataKey'],
                principals: [new iam.ServicePrincipal('ses.amazonaws.com')],
                resources: ['*'],
                conditions: {
                    Null: {
                        'kms:EncryptionContext:aws:ses:rule-name': 'false',
                        'kms:EncryptionContext:aws:ses:message-id': 'false',
                    },
                    StringEquals: {
                        'kms:EncryptionContext:aws:ses:source-account': cdk.Aws.ACCOUNT_ID,
                    },
                },
            });
            this.props.kmsKey.addToResourcePolicy(kmsStatement);
        }
        return {
            s3Action: {
                bucketName: this.props.bucket.bucketName,
                kmsKeyArn: this.props.kmsKey?.keyArn,
                objectKeyPrefix: this.props.objectKeyPrefix,
                topicArn: this.props.topic?.topicArn,
            },
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
S3[_a] = { fqn: "aws-cdk-lib.aws_ses_actions.S3", version: "2.74.0" };
exports.S3 = S3;
//# sourceMappingURL=data:application/json;base64,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