"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Stop = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Terminates the evaluation of the receipt rule set and optionally publishes a
 * notification to Amazon SNS.
 */
class Stop {
    constructor(props = {}) {
        this.props = props;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ses_actions_StopProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Stop);
            }
            throw error;
        }
    }
    bind(_rule) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ses_IReceiptRule(_rule);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            stopAction: {
                scope: 'RuleSet',
                topicArn: this.props.topic?.topicArn,
            },
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
Stop[_a] = { fqn: "aws-cdk-lib.aws_ses_actions.Stop", version: "2.74.0" };
exports.Stop = Stop;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RvcC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInN0b3AudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBYUE7OztHQUdHO0FBQ0gsTUFBYSxJQUFJO0lBQ2YsWUFBNkIsUUFBbUIsRUFBRTtRQUFyQixVQUFLLEdBQUwsS0FBSyxDQUFnQjs7Ozs7OytDQUR2QyxJQUFJOzs7O0tBRWQ7SUFFTSxJQUFJLENBQUMsS0FBdUI7Ozs7Ozs7Ozs7UUFDakMsT0FBTztZQUNMLFVBQVUsRUFBRTtnQkFDVixLQUFLLEVBQUUsU0FBUztnQkFDaEIsUUFBUSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSyxFQUFFLFFBQVE7YUFDckM7U0FDRixDQUFDO0tBQ0g7Ozs7QUFYVSxvQkFBSSIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHNlcyBmcm9tICcuLi8uLi9hd3Mtc2VzJztcbmltcG9ydCAqIGFzIHNucyBmcm9tICcuLi8uLi9hd3Mtc25zJztcblxuLyoqXG4gKiBDb25zdHJ1Y3Rpb24gcHJvcGVydGllcyBmb3IgYSBzdG9wIGFjdGlvbi5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBTdG9wUHJvcHMge1xuICAvKipcbiAgICogVGhlIFNOUyB0b3BpYyB0byBub3RpZnkgd2hlbiB0aGUgc3RvcCBhY3Rpb24gaXMgdGFrZW4uXG4gICAqL1xuICByZWFkb25seSB0b3BpYz86IHNucy5JVG9waWM7XG59XG5cbi8qKlxuICogVGVybWluYXRlcyB0aGUgZXZhbHVhdGlvbiBvZiB0aGUgcmVjZWlwdCBydWxlIHNldCBhbmQgb3B0aW9uYWxseSBwdWJsaXNoZXMgYVxuICogbm90aWZpY2F0aW9uIHRvIEFtYXpvbiBTTlMuXG4gKi9cbmV4cG9ydCBjbGFzcyBTdG9wIGltcGxlbWVudHMgc2VzLklSZWNlaXB0UnVsZUFjdGlvbiB7XG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgcHJvcHM6IFN0b3BQcm9wcyA9IHt9KSB7XG4gIH1cblxuICBwdWJsaWMgYmluZChfcnVsZTogc2VzLklSZWNlaXB0UnVsZSk6IHNlcy5SZWNlaXB0UnVsZUFjdGlvbkNvbmZpZyB7XG4gICAgcmV0dXJuIHtcbiAgICAgIHN0b3BBY3Rpb246IHtcbiAgICAgICAgc2NvcGU6ICdSdWxlU2V0JyxcbiAgICAgICAgdG9waWNBcm46IHRoaXMucHJvcHMudG9waWM/LnRvcGljQXJuLFxuICAgICAgfSxcbiAgICB9O1xuICB9XG59XG4iXX0=