"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConfigurationSet = exports.SuppressionReasons = exports.ConfigurationSetTlsPolicy = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const configuration_set_event_destination_1 = require("./configuration-set-event-destination");
const utils_1 = require("./private/utils");
const ses_generated_1 = require("./ses.generated");
/**
 * TLS policy for a configuration set
 */
var ConfigurationSetTlsPolicy;
(function (ConfigurationSetTlsPolicy) {
    /**
     * Messages are only delivered if a TLS connection can be established
     */
    ConfigurationSetTlsPolicy["REQUIRE"] = "REQUIRE";
    /**
     * Messages can be delivered in plain text if a TLS connection can't be established
     */
    ConfigurationSetTlsPolicy["OPTIONAL"] = "OPTIONAL";
})(ConfigurationSetTlsPolicy = exports.ConfigurationSetTlsPolicy || (exports.ConfigurationSetTlsPolicy = {}));
/**
 * Reasons for which recipient email addresses should be automatically added
 * to your account's suppression list
 */
var SuppressionReasons;
(function (SuppressionReasons) {
    /**
     * Bounces and complaints
     */
    SuppressionReasons["BOUNCES_AND_COMPLAINTS"] = "BOUNCES_AND_COMPLAINTS";
    /**
     * Bounces only
     */
    SuppressionReasons["BOUNCES_ONLY"] = "BOUNCES_ONLY";
    /**
     * Complaints only
     */
    SuppressionReasons["COMPLAINTS_ONLY"] = "COMPLAINTS_ONLY";
})(SuppressionReasons = exports.SuppressionReasons || (exports.SuppressionReasons = {}));
/**
 * A configuration set
 */
class ConfigurationSet extends core_1.Resource {
    /**
     * Use an existing configuration set
     */
    static fromConfigurationSetName(scope, id, configurationSetName) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.configurationSetName = configurationSetName;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.configurationSetName,
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ses_ConfigurationSetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ConfigurationSet);
            }
            throw error;
        }
        const configurationSet = new ses_generated_1.CfnConfigurationSet(this, 'Resource', {
            deliveryOptions: (0, utils_1.undefinedIfNoKeys)({
                sendingPoolName: props.dedicatedIpPool?.dedicatedIpPoolName,
                tlsPolicy: props.tlsPolicy,
            }),
            name: this.physicalName,
            reputationOptions: (0, utils_1.undefinedIfNoKeys)({
                reputationMetricsEnabled: props.reputationMetrics,
            }),
            sendingOptions: (0, utils_1.undefinedIfNoKeys)({
                sendingEnabled: props.sendingEnabled,
            }),
            suppressionOptions: (0, utils_1.undefinedIfNoKeys)({
                suppressedReasons: renderSuppressedReasons(props.suppressionReasons),
            }),
            trackingOptions: (0, utils_1.undefinedIfNoKeys)({
                customRedirectDomain: props.customTrackingRedirectDomain,
            }),
        });
        this.configurationSetName = configurationSet.ref;
    }
    /**
     * Adds an event destination to this configuration set
     */
    addEventDestination(id, options) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ses_ConfigurationSetEventDestinationOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addEventDestination);
            }
            throw error;
        }
        return new configuration_set_event_destination_1.ConfigurationSetEventDestination(this, id, {
            ...options,
            configurationSet: this,
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
ConfigurationSet[_a] = { fqn: "aws-cdk-lib.aws_ses.ConfigurationSet", version: "2.74.0" };
exports.ConfigurationSet = ConfigurationSet;
function renderSuppressedReasons(suppressionReasons) {
    if (!suppressionReasons) {
        return undefined;
    }
    switch (suppressionReasons) {
        case SuppressionReasons.BOUNCES_AND_COMPLAINTS:
            return ['BOUNCE', 'COMPLAINT'];
        case SuppressionReasons.BOUNCES_ONLY:
            return ['BOUNCE'];
        case SuppressionReasons.COMPLAINTS_ONLY:
            return ['COMPLAINT'];
    }
}
//# sourceMappingURL=data:application/json;base64,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