"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DedicatedIpPool = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const ses_generated_1 = require("./ses.generated");
/**
 * A dedicated IP pool
 */
class DedicatedIpPool extends core_1.Resource {
    /**
     * Use an existing dedicated IP pool
     */
    static fromDedicatedIpPoolName(scope, id, dedicatedIpPoolName) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.dedicatedIpPoolName = dedicatedIpPoolName;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.dedicatedIpPoolName,
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ses_DedicatedIpPoolProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, DedicatedIpPool);
            }
            throw error;
        }
        const pool = new ses_generated_1.CfnDedicatedIpPool(this, 'Resource', {
            poolName: this.physicalName,
        });
        this.dedicatedIpPoolName = pool.ref;
    }
}
_a = JSII_RTTI_SYMBOL_1;
DedicatedIpPool[_a] = { fqn: "aws-cdk-lib.aws_ses.DedicatedIpPool", version: "2.74.0" };
exports.DedicatedIpPool = DedicatedIpPool;
//# sourceMappingURL=data:application/json;base64,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