"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WhiteListReceiptFilter = exports.AllowListReceiptFilter = exports.ReceiptFilter = exports.ReceiptFilterPolicy = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const constructs_1 = require("constructs");
const ses_generated_1 = require("./ses.generated");
/**
 * The policy for the receipt filter.
 */
var ReceiptFilterPolicy;
(function (ReceiptFilterPolicy) {
    /**
     * Allow the ip address or range.
     */
    ReceiptFilterPolicy["ALLOW"] = "Allow";
    /**
     * Block the ip address or range.
     */
    ReceiptFilterPolicy["BLOCK"] = "Block";
})(ReceiptFilterPolicy = exports.ReceiptFilterPolicy || (exports.ReceiptFilterPolicy = {}));
/**
 * A receipt filter. When instantiated without props, it creates a
 * block all receipt filter.
 */
class ReceiptFilter extends core_1.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.receiptFilterName,
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ses_ReceiptFilterProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ReceiptFilter);
            }
            throw error;
        }
        new ses_generated_1.CfnReceiptFilter(this, 'Resource', {
            filter: {
                ipFilter: {
                    cidr: props.ip || '0.0.0.0/0',
                    policy: props.policy || ReceiptFilterPolicy.BLOCK,
                },
                name: this.physicalName,
            },
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
ReceiptFilter[_a] = { fqn: "aws-cdk-lib.aws_ses.ReceiptFilter", version: "2.74.0" };
exports.ReceiptFilter = ReceiptFilter;
/**
 * An allow list receipt filter.
 */
class AllowListReceiptFilter extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ses_AllowListReceiptFilterProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AllowListReceiptFilter);
            }
            throw error;
        }
        new ReceiptFilter(this, 'BlockAll');
        props.ips.forEach(ip => {
            new ReceiptFilter(this, `Allow${ip.replace(/[^\d]/g, '')}`, {
                ip,
                policy: ReceiptFilterPolicy.ALLOW,
            });
        });
    }
}
_b = JSII_RTTI_SYMBOL_1;
AllowListReceiptFilter[_b] = { fqn: "aws-cdk-lib.aws_ses.AllowListReceiptFilter", version: "2.74.0" };
exports.AllowListReceiptFilter = AllowListReceiptFilter;
/**
 * An allow list receipt filter.
 * @deprecated use `AllowListReceiptFilter`
 */
class WhiteListReceiptFilter extends AllowListReceiptFilter {
    constructor(scope, id, props) {
        super(scope, id, props);
    }
}
_c = JSII_RTTI_SYMBOL_1;
WhiteListReceiptFilter[_c] = { fqn: "aws-cdk-lib.aws_ses.WhiteListReceiptFilter", version: "2.74.0" };
exports.WhiteListReceiptFilter = WhiteListReceiptFilter;
//# sourceMappingURL=data:application/json;base64,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