"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VdmAttributes = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const ses_generated_1 = require("./ses.generated");
/**
 * Virtual Deliverablity Manager (VDM) attributes
 */
class VdmAttributes extends core_1.Resource {
    /**
     * Use an existing Virtual Deliverablity Manager attributes resource
     */
    static fromVdmAttributesName(scope, id, vdmAttributesName) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.vdmAttributesName = vdmAttributesName;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props = {}) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ses_VdmAttributesProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, VdmAttributes);
            }
            throw error;
        }
        const resource = new ses_generated_1.CfnVdmAttributes(this, 'Resource', {
            dashboardAttributes: {
                engagementMetrics: booleanToEnabledDisabled(props.engagementMetrics ?? true),
            },
            guardianAttributes: {
                optimizedSharedDelivery: booleanToEnabledDisabled(props.optimizedSharedDelivery ?? true),
            },
        });
        this.vdmAttributesName = resource.ref;
        this.vdmAttributesResourceId = resource.attrVdmAttributesResourceId;
    }
}
_a = JSII_RTTI_SYMBOL_1;
VdmAttributes[_a] = { fqn: "aws-cdk-lib.aws_ses.VdmAttributes", version: "2.74.0" };
exports.VdmAttributes = VdmAttributes;
function booleanToEnabledDisabled(value) {
    return value === true
        ? 'ENABLED'
        : 'DISABLED';
}
//# sourceMappingURL=data:application/json;base64,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