"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SigningProfile = exports.Platform = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const signer_generated_1 = require("./signer.generated");
/**
 * Platforms that are allowed with signing config.
 * @see https://docs.aws.amazon.com/signer/latest/developerguide/gs-platform.html
 */
class Platform {
    constructor(platformId) {
        this.platformId = platformId;
    }
}
_a = JSII_RTTI_SYMBOL_1;
Platform[_a] = { fqn: "aws-cdk-lib.aws_signer.Platform", version: "2.74.0" };
/**
 * Specification of signature format and signing algorithms for AWS IoT Device.
 */
Platform.AWS_IOT_DEVICE_MANAGEMENT_SHA256_ECDSA = new Platform('AWSIoTDeviceManagement-SHA256-ECDSA');
/**
 * Specification of signature format and signing algorithms for AWS Lambda.
 */
Platform.AWS_LAMBDA_SHA384_ECDSA = new Platform('AWSLambda-SHA384-ECDSA');
/**
 * Specification of signature format and signing algorithms with
 * SHA1 hash and RSA encryption for Amazon FreeRTOS.
 */
Platform.AMAZON_FREE_RTOS_TI_CC3220SF = new Platform('AmazonFreeRTOS-TI-CC3220SF');
/**
 * Specification of signature format and signing algorithms with
 * SHA256 hash and ECDSA encryption for Amazon FreeRTOS.
 */
Platform.AMAZON_FREE_RTOS_DEFAULT = new Platform('AmazonFreeRTOS-Default');
exports.Platform = Platform;
/**
 * Defines a Signing Profile.
 *
 * @resource AWS::Signer::SigningProfile
 */
class SigningProfile extends core_1.Resource {
    /**
     * Creates a Signing Profile construct that represents an external Signing Profile.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param attrs A `SigningProfileAttributes` object.
     */
    static fromSigningProfileAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_signer_SigningProfileAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromSigningProfileAttributes);
            }
            throw error;
        }
        class Import extends core_1.Resource {
            constructor(signingProfileArn, signingProfileProfileVersionArn) {
                super(scope, id);
                this.signingProfileName = attrs.signingProfileName;
                this.signingProfileVersion = attrs.signingProfileVersion;
                this.signingProfileArn = signingProfileArn;
                this.signingProfileVersionArn = signingProfileProfileVersionArn;
            }
        }
        const signingProfileArn = core_1.Stack.of(scope).formatArn({
            service: 'signer',
            resource: '',
            resourceName: `/signing-profiles/${attrs.signingProfileName}`,
        });
        const SigningProfileVersionArn = core_1.Stack.of(scope).formatArn({
            service: 'signer',
            resource: '',
            resourceName: `/signing-profiles/${attrs.signingProfileName}/${attrs.signingProfileVersion}`,
        });
        return new Import(signingProfileArn, SigningProfileVersionArn);
    }
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.signingProfileName,
        });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_signer_SigningProfileProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SigningProfile);
            }
            throw error;
        }
        const resource = new signer_generated_1.CfnSigningProfile(this, 'Resource', {
            platformId: props.platform.platformId,
            signatureValidityPeriod: props.signatureValidity ? {
                type: 'DAYS',
                value: props.signatureValidity?.toDays(),
            } : {
                type: 'MONTHS',
                value: 135,
            },
        });
        this.signingProfileArn = resource.attrArn;
        this.signingProfileName = resource.attrProfileName;
        this.signingProfileVersion = resource.attrProfileVersion;
        this.signingProfileVersionArn = resource.attrProfileVersionArn;
    }
}
_b = JSII_RTTI_SYMBOL_1;
SigningProfile[_b] = { fqn: "aws-cdk-lib.aws_signer.SigningProfile", version: "2.74.0" };
exports.SigningProfile = SigningProfile;
//# sourceMappingURL=data:application/json;base64,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