"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmsSubscription = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const sns = require("../../aws-sns");
/**
 * Use an sms address as a subscription target
 */
class SmsSubscription {
    constructor(phoneNumber, props = {}) {
        this.phoneNumber = phoneNumber;
        this.props = props;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_sns_subscriptions_SmsSubscriptionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SmsSubscription);
            }
            throw error;
        }
    }
    bind(_topic) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_sns_ITopic(_topic);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            subscriberId: this.phoneNumber,
            endpoint: this.phoneNumber,
            protocol: sns.SubscriptionProtocol.SMS,
            filterPolicy: this.props.filterPolicy,
            filterPolicyWithMessageBody: this.props.filterPolicyWithMessageBody,
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
SmsSubscription[_a] = { fqn: "aws-cdk-lib.aws_sns_subscriptions.SmsSubscription", version: "2.74.0" };
exports.SmsSubscription = SmsSubscription;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic21zLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic21zLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBLHFDQUFxQztBQVNyQzs7R0FFRztBQUNILE1BQWEsZUFBZTtJQUMxQixZQUE2QixXQUFtQixFQUFtQixRQUE4QixFQUFFO1FBQXRFLGdCQUFXLEdBQVgsV0FBVyxDQUFRO1FBQW1CLFVBQUssR0FBTCxLQUFLLENBQTJCOzs7Ozs7K0NBRHhGLGVBQWU7Ozs7S0FFekI7SUFFTSxJQUFJLENBQUMsTUFBa0I7Ozs7Ozs7Ozs7UUFDNUIsT0FBTztZQUNMLFlBQVksRUFBRSxJQUFJLENBQUMsV0FBVztZQUM5QixRQUFRLEVBQUUsSUFBSSxDQUFDLFdBQVc7WUFDMUIsUUFBUSxFQUFFLEdBQUcsQ0FBQyxvQkFBb0IsQ0FBQyxHQUFHO1lBQ3RDLFlBQVksRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFlBQVk7WUFDckMsMkJBQTJCLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQywyQkFBMkI7U0FDcEUsQ0FBQztLQUNIOzs7O0FBWlUsMENBQWUiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBzbnMgZnJvbSAnLi4vLi4vYXdzLXNucyc7XG5pbXBvcnQgeyBTdWJzY3JpcHRpb25Qcm9wcyB9IGZyb20gJy4vc3Vic2NyaXB0aW9uJztcblxuLyoqXG4gKiBPcHRpb25zIGZvciBTTVMgc3Vic2NyaXB0aW9ucy5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBTbXNTdWJzY3JpcHRpb25Qcm9wcyBleHRlbmRzIFN1YnNjcmlwdGlvblByb3BzIHtcbn1cblxuLyoqXG4gKiBVc2UgYW4gc21zIGFkZHJlc3MgYXMgYSBzdWJzY3JpcHRpb24gdGFyZ2V0XG4gKi9cbmV4cG9ydCBjbGFzcyBTbXNTdWJzY3JpcHRpb24gaW1wbGVtZW50cyBzbnMuSVRvcGljU3Vic2NyaXB0aW9uIHtcbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBwaG9uZU51bWJlcjogc3RyaW5nLCBwcml2YXRlIHJlYWRvbmx5IHByb3BzOiBTbXNTdWJzY3JpcHRpb25Qcm9wcyA9IHt9KSB7XG4gIH1cblxuICBwdWJsaWMgYmluZChfdG9waWM6IHNucy5JVG9waWMpOiBzbnMuVG9waWNTdWJzY3JpcHRpb25Db25maWcge1xuICAgIHJldHVybiB7XG4gICAgICBzdWJzY3JpYmVySWQ6IHRoaXMucGhvbmVOdW1iZXIsXG4gICAgICBlbmRwb2ludDogdGhpcy5waG9uZU51bWJlcixcbiAgICAgIHByb3RvY29sOiBzbnMuU3Vic2NyaXB0aW9uUHJvdG9jb2wuU01TLFxuICAgICAgZmlsdGVyUG9saWN5OiB0aGlzLnByb3BzLmZpbHRlclBvbGljeSxcbiAgICAgIGZpbHRlclBvbGljeVdpdGhNZXNzYWdlQm9keTogdGhpcy5wcm9wcy5maWx0ZXJQb2xpY3lXaXRoTWVzc2FnZUJvZHksXG4gICAgfTtcbiAgfVxufVxuIl19