"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Topic = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const sns_generated_1 = require("./sns.generated");
const topic_base_1 = require("./topic-base");
/**
 * A new SNS topic
 */
class Topic extends topic_base_1.TopicBase {
    /**
     * Import an existing SNS topic provided an ARN
     *
     * @param scope The parent creating construct
     * @param id The construct's name
     * @param topicArn topic ARN (i.e. arn:aws:sns:us-east-2:444455556666:MyTopic)
     */
    static fromTopicArn(scope, id, topicArn) {
        class Import extends topic_base_1.TopicBase {
            constructor() {
                super(...arguments);
                this.topicArn = topicArn;
                this.topicName = core_1.Stack.of(scope).splitArn(topicArn, core_1.ArnFormat.NO_RESOURCE_NAME).resource;
                this.fifo = this.topicName.endsWith('.fifo');
                this.autoCreatePolicy = false;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.topicName,
        });
        this.autoCreatePolicy = true;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_sns_TopicProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Topic);
            }
            throw error;
        }
        if (props.contentBasedDeduplication && !props.fifo) {
            throw new Error('Content based deduplication can only be enabled for FIFO SNS topics.');
        }
        let cfnTopicName;
        if (props.fifo && props.topicName && !props.topicName.endsWith('.fifo')) {
            cfnTopicName = this.physicalName + '.fifo';
        }
        else if (props.fifo && !props.topicName) {
            // Max lenght allowed by CloudFormation is 256, we subtract 5 to allow for ".fifo" suffix
            const prefixName = core_1.Names.uniqueResourceName(this, {
                maxLength: 256 - 5,
                separator: '-',
            });
            cfnTopicName = `${prefixName}.fifo`;
        }
        else {
            cfnTopicName = this.physicalName;
        }
        const resource = new sns_generated_1.CfnTopic(this, 'Resource', {
            displayName: props.displayName,
            topicName: cfnTopicName,
            kmsMasterKeyId: props.masterKey && props.masterKey.keyArn,
            contentBasedDeduplication: props.contentBasedDeduplication,
            fifoTopic: props.fifo,
        });
        this.topicArn = this.getResourceArnAttribute(resource.ref, {
            service: 'sns',
            resource: this.physicalName,
        });
        this.topicName = this.getResourceNameAttribute(resource.attrTopicName);
        this.fifo = props.fifo || false;
    }
}
_a = JSII_RTTI_SYMBOL_1;
Topic[_a] = { fqn: "aws-cdk-lib.aws_sns.Topic", version: "2.74.0" };
exports.Topic = Topic;
//# sourceMappingURL=data:application/json;base64,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