"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.QueuePolicy = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("../../aws-iam");
const core_1 = require("../../core");
const sqs_generated_1 = require("./sqs.generated");
/**
 * The policy for an SQS Queue
 *
 * Policies define the operations that are allowed on this resource.
 *
 * You almost never need to define this construct directly.
 *
 * All AWS resources that support resource policies have a method called
 * `addToResourcePolicy()`, which will automatically create a new resource
 * policy if one doesn't exist yet, otherwise it will add to the existing
 * policy.
 *
 * Prefer to use `addToResourcePolicy()` instead.
 */
class QueuePolicy extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * The IAM policy document for this policy.
         */
        this.document = new aws_iam_1.PolicyDocument();
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_sqs_QueuePolicyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, QueuePolicy);
            }
            throw error;
        }
        new sqs_generated_1.CfnQueuePolicy(this, 'Resource', {
            policyDocument: this.document,
            queues: props.queues.map(q => q.queueUrl),
        });
    }
    /**
     * Not currently supported by AWS CloudFormation.
     *
     * This attribute temporarily existed in CloudFormation, and then was removed again.
     *
     * @attribute
     */
    get queuePolicyId() {
        throw new Error('QueuePolicy.queuePolicyId has been removed from CloudFormation');
    }
}
_a = JSII_RTTI_SYMBOL_1;
QueuePolicy[_a] = { fqn: "aws-cdk-lib.aws_sqs.QueuePolicy", version: "2.74.0" };
exports.QueuePolicy = QueuePolicy;
//# sourceMappingURL=data:application/json;base64,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