"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnQueuePolicy = exports.CfnQueue = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core");
const cfn_parse = require("../../core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnQueueProps`
 *
 * @param properties - the TypeScript properties of a `CfnQueueProps`
 *
 * @returns the result of the validation.
 */
function CfnQueuePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('contentBasedDeduplication', cdk.validateBoolean)(properties.contentBasedDeduplication));
    errors.collect(cdk.propertyValidator('deduplicationScope', cdk.validateString)(properties.deduplicationScope));
    errors.collect(cdk.propertyValidator('delaySeconds', cdk.validateNumber)(properties.delaySeconds));
    errors.collect(cdk.propertyValidator('fifoQueue', cdk.validateBoolean)(properties.fifoQueue));
    errors.collect(cdk.propertyValidator('fifoThroughputLimit', cdk.validateString)(properties.fifoThroughputLimit));
    errors.collect(cdk.propertyValidator('kmsDataKeyReusePeriodSeconds', cdk.validateNumber)(properties.kmsDataKeyReusePeriodSeconds));
    errors.collect(cdk.propertyValidator('kmsMasterKeyId', cdk.validateString)(properties.kmsMasterKeyId));
    errors.collect(cdk.propertyValidator('maximumMessageSize', cdk.validateNumber)(properties.maximumMessageSize));
    errors.collect(cdk.propertyValidator('messageRetentionPeriod', cdk.validateNumber)(properties.messageRetentionPeriod));
    errors.collect(cdk.propertyValidator('queueName', cdk.validateString)(properties.queueName));
    errors.collect(cdk.propertyValidator('receiveMessageWaitTimeSeconds', cdk.validateNumber)(properties.receiveMessageWaitTimeSeconds));
    errors.collect(cdk.propertyValidator('redriveAllowPolicy', cdk.validateObject)(properties.redriveAllowPolicy));
    errors.collect(cdk.propertyValidator('redrivePolicy', cdk.validateObject)(properties.redrivePolicy));
    errors.collect(cdk.propertyValidator('sqsManagedSseEnabled', cdk.validateBoolean)(properties.sqsManagedSseEnabled));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('visibilityTimeout', cdk.validateNumber)(properties.visibilityTimeout));
    return errors.wrap('supplied properties not correct for "CfnQueueProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SQS::Queue` resource
 *
 * @param properties - the TypeScript properties of a `CfnQueueProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SQS::Queue` resource.
 */
// @ts-ignore TS6133
function cfnQueuePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnQueuePropsValidator(properties).assertSuccess();
    return {
        ContentBasedDeduplication: cdk.booleanToCloudFormation(properties.contentBasedDeduplication),
        DeduplicationScope: cdk.stringToCloudFormation(properties.deduplicationScope),
        DelaySeconds: cdk.numberToCloudFormation(properties.delaySeconds),
        FifoQueue: cdk.booleanToCloudFormation(properties.fifoQueue),
        FifoThroughputLimit: cdk.stringToCloudFormation(properties.fifoThroughputLimit),
        KmsDataKeyReusePeriodSeconds: cdk.numberToCloudFormation(properties.kmsDataKeyReusePeriodSeconds),
        KmsMasterKeyId: cdk.stringToCloudFormation(properties.kmsMasterKeyId),
        MaximumMessageSize: cdk.numberToCloudFormation(properties.maximumMessageSize),
        MessageRetentionPeriod: cdk.numberToCloudFormation(properties.messageRetentionPeriod),
        QueueName: cdk.stringToCloudFormation(properties.queueName),
        ReceiveMessageWaitTimeSeconds: cdk.numberToCloudFormation(properties.receiveMessageWaitTimeSeconds),
        RedriveAllowPolicy: cdk.objectToCloudFormation(properties.redriveAllowPolicy),
        RedrivePolicy: cdk.objectToCloudFormation(properties.redrivePolicy),
        SqsManagedSseEnabled: cdk.booleanToCloudFormation(properties.sqsManagedSseEnabled),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        VisibilityTimeout: cdk.numberToCloudFormation(properties.visibilityTimeout),
    };
}
// @ts-ignore TS6133
function CfnQueuePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('contentBasedDeduplication', 'ContentBasedDeduplication', properties.ContentBasedDeduplication != null ? cfn_parse.FromCloudFormation.getBoolean(properties.ContentBasedDeduplication) : undefined);
    ret.addPropertyResult('deduplicationScope', 'DeduplicationScope', properties.DeduplicationScope != null ? cfn_parse.FromCloudFormation.getString(properties.DeduplicationScope) : undefined);
    ret.addPropertyResult('delaySeconds', 'DelaySeconds', properties.DelaySeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.DelaySeconds) : undefined);
    ret.addPropertyResult('fifoQueue', 'FifoQueue', properties.FifoQueue != null ? cfn_parse.FromCloudFormation.getBoolean(properties.FifoQueue) : undefined);
    ret.addPropertyResult('fifoThroughputLimit', 'FifoThroughputLimit', properties.FifoThroughputLimit != null ? cfn_parse.FromCloudFormation.getString(properties.FifoThroughputLimit) : undefined);
    ret.addPropertyResult('kmsDataKeyReusePeriodSeconds', 'KmsDataKeyReusePeriodSeconds', properties.KmsDataKeyReusePeriodSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.KmsDataKeyReusePeriodSeconds) : undefined);
    ret.addPropertyResult('kmsMasterKeyId', 'KmsMasterKeyId', properties.KmsMasterKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsMasterKeyId) : undefined);
    ret.addPropertyResult('maximumMessageSize', 'MaximumMessageSize', properties.MaximumMessageSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaximumMessageSize) : undefined);
    ret.addPropertyResult('messageRetentionPeriod', 'MessageRetentionPeriod', properties.MessageRetentionPeriod != null ? cfn_parse.FromCloudFormation.getNumber(properties.MessageRetentionPeriod) : undefined);
    ret.addPropertyResult('queueName', 'QueueName', properties.QueueName != null ? cfn_parse.FromCloudFormation.getString(properties.QueueName) : undefined);
    ret.addPropertyResult('receiveMessageWaitTimeSeconds', 'ReceiveMessageWaitTimeSeconds', properties.ReceiveMessageWaitTimeSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.ReceiveMessageWaitTimeSeconds) : undefined);
    ret.addPropertyResult('redriveAllowPolicy', 'RedriveAllowPolicy', properties.RedriveAllowPolicy != null ? cfn_parse.FromCloudFormation.getAny(properties.RedriveAllowPolicy) : undefined);
    ret.addPropertyResult('redrivePolicy', 'RedrivePolicy', properties.RedrivePolicy != null ? cfn_parse.FromCloudFormation.getAny(properties.RedrivePolicy) : undefined);
    ret.addPropertyResult('sqsManagedSseEnabled', 'SqsManagedSseEnabled', properties.SqsManagedSseEnabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.SqsManagedSseEnabled) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('visibilityTimeout', 'VisibilityTimeout', properties.VisibilityTimeout != null ? cfn_parse.FromCloudFormation.getNumber(properties.VisibilityTimeout) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SQS::Queue`
 *
 * The `AWS::SQS::Queue` resource creates an Amazon SQS standard or FIFO queue.
 *
 * Keep the following caveats in mind:
 *
 * - If you don't specify the `FifoQueue` property, Amazon SQS creates a standard queue.
 *
 * > You can't change the queue type after you create it and you can't convert an existing standard queue into a FIFO queue. You must either create a new FIFO queue for your application or delete your existing standard queue and recreate it as a FIFO queue. For more information, see [Moving from a standard queue to a FIFO queue](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-moving.html) in the *Amazon SQS Developer Guide* .
 * - If you don't provide a value for a property, the queue is created with the default value for the property.
 * - If you delete a queue, you must wait at least 60 seconds before creating a queue with the same name.
 * - To successfully create a new queue, you must provide a queue name that adheres to the [limits related to queues](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/limits-queues.html) and is unique within the scope of your queues.
 *
 * For more information about creating FIFO (first-in-first-out) queues, see [Creating an Amazon SQS queue ( AWS CloudFormation )](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/screate-queue-cloudformation.html) in the *Amazon SQS Developer Guide* .
 *
 * @cloudformationResource AWS::SQS::Queue
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html
 */
class CfnQueue extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnQueuePropsFromCloudFormation(resourceProperties);
        const ret = new CfnQueue(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::SQS::Queue`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnQueue.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_sqs_CfnQueueProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnQueue);
            }
            throw error;
        }
        this.attrArn = cdk.Token.asString(this.getAtt('Arn', cdk.ResolutionTypeHint.STRING));
        this.attrQueueName = cdk.Token.asString(this.getAtt('QueueName', cdk.ResolutionTypeHint.STRING));
        this.attrQueueUrl = cdk.Token.asString(this.getAtt('QueueUrl', cdk.ResolutionTypeHint.STRING));
        this.contentBasedDeduplication = props.contentBasedDeduplication;
        this.deduplicationScope = props.deduplicationScope;
        this.delaySeconds = props.delaySeconds;
        this.fifoQueue = props.fifoQueue;
        this.fifoThroughputLimit = props.fifoThroughputLimit;
        this.kmsDataKeyReusePeriodSeconds = props.kmsDataKeyReusePeriodSeconds;
        this.kmsMasterKeyId = props.kmsMasterKeyId;
        this.maximumMessageSize = props.maximumMessageSize;
        this.messageRetentionPeriod = props.messageRetentionPeriod;
        this.queueName = props.queueName;
        this.receiveMessageWaitTimeSeconds = props.receiveMessageWaitTimeSeconds;
        this.redriveAllowPolicy = props.redriveAllowPolicy;
        this.redrivePolicy = props.redrivePolicy;
        this.sqsManagedSseEnabled = props.sqsManagedSseEnabled;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::SQS::Queue", props.tags, { tagPropertyName: 'tags' });
        this.visibilityTimeout = props.visibilityTimeout;
        if (this.node.scope && cdk.Resource.isResource(this.node.scope)) {
            this.node.addValidation({ validate: () => this.cfnOptions.deletionPolicy === undefined
                    ? ['\'AWS::SQS::Queue\' is a stateful resource type, and you must specify a Removal Policy for it. Call \'resource.applyRemovalPolicy()\'.']
                    : [] });
        }
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnQueue.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            contentBasedDeduplication: this.contentBasedDeduplication,
            deduplicationScope: this.deduplicationScope,
            delaySeconds: this.delaySeconds,
            fifoQueue: this.fifoQueue,
            fifoThroughputLimit: this.fifoThroughputLimit,
            kmsDataKeyReusePeriodSeconds: this.kmsDataKeyReusePeriodSeconds,
            kmsMasterKeyId: this.kmsMasterKeyId,
            maximumMessageSize: this.maximumMessageSize,
            messageRetentionPeriod: this.messageRetentionPeriod,
            queueName: this.queueName,
            receiveMessageWaitTimeSeconds: this.receiveMessageWaitTimeSeconds,
            redriveAllowPolicy: this.redriveAllowPolicy,
            redrivePolicy: this.redrivePolicy,
            sqsManagedSseEnabled: this.sqsManagedSseEnabled,
            tags: this.tags.renderTags(),
            visibilityTimeout: this.visibilityTimeout,
        };
    }
    renderProperties(props) {
        return cfnQueuePropsToCloudFormation(props);
    }
}
_a = JSII_RTTI_SYMBOL_1;
CfnQueue[_a] = { fqn: "aws-cdk-lib.aws_sqs.CfnQueue", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnQueue.CFN_RESOURCE_TYPE_NAME = "AWS::SQS::Queue";
exports.CfnQueue = CfnQueue;
/**
 * Determine whether the given properties match those of a `CfnQueuePolicyProps`
 *
 * @param properties - the TypeScript properties of a `CfnQueuePolicyProps`
 *
 * @returns the result of the validation.
 */
function CfnQueuePolicyPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('policyDocument', cdk.requiredValidator)(properties.policyDocument));
    errors.collect(cdk.propertyValidator('policyDocument', cdk.validateObject)(properties.policyDocument));
    errors.collect(cdk.propertyValidator('queues', cdk.requiredValidator)(properties.queues));
    errors.collect(cdk.propertyValidator('queues', cdk.listValidator(cdk.validateString))(properties.queues));
    return errors.wrap('supplied properties not correct for "CfnQueuePolicyProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SQS::QueuePolicy` resource
 *
 * @param properties - the TypeScript properties of a `CfnQueuePolicyProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SQS::QueuePolicy` resource.
 */
// @ts-ignore TS6133
function cfnQueuePolicyPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnQueuePolicyPropsValidator(properties).assertSuccess();
    return {
        PolicyDocument: cdk.objectToCloudFormation(properties.policyDocument),
        Queues: cdk.listMapper(cdk.stringToCloudFormation)(properties.queues),
    };
}
// @ts-ignore TS6133
function CfnQueuePolicyPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('policyDocument', 'PolicyDocument', cfn_parse.FromCloudFormation.getAny(properties.PolicyDocument));
    ret.addPropertyResult('queues', 'Queues', cfn_parse.FromCloudFormation.getStringArray(properties.Queues));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SQS::QueuePolicy`
 *
 * The `AWS::SQS::QueuePolicy` type applies a policy to Amazon SQS queues. For an example snippet, see [Declaring an Amazon SQS policy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/quickref-iam.html#scenario-sqs-policy) in the *AWS CloudFormation User Guide* .
 *
 * @cloudformationResource AWS::SQS::QueuePolicy
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html
 */
class CfnQueuePolicy extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnQueuePolicyPropsFromCloudFormation(resourceProperties);
        const ret = new CfnQueuePolicy(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::SQS::QueuePolicy`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnQueuePolicy.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_sqs_CfnQueuePolicyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnQueuePolicy);
            }
            throw error;
        }
        cdk.requireProperty(props, 'policyDocument', this);
        cdk.requireProperty(props, 'queues', this);
        this.policyDocument = props.policyDocument;
        this.queues = props.queues;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnQueuePolicy.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            policyDocument: this.policyDocument,
            queues: this.queues,
        };
    }
    renderProperties(props) {
        return cfnQueuePolicyPropsToCloudFormation(props);
    }
}
_b = JSII_RTTI_SYMBOL_1;
CfnQueuePolicy[_b] = { fqn: "aws-cdk-lib.aws_sqs.CfnQueuePolicy", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnQueuePolicy.CFN_RESOURCE_TYPE_NAME = "AWS::SQS::QueuePolicy";
exports.CfnQueuePolicy = CfnQueuePolicy;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3FzLmdlbmVyYXRlZC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInNxcy5nZW5lcmF0ZWQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBUUEsa0NBQWtDO0FBQ2xDLDZEQUE2RDtBQXNLN0Q7Ozs7OztHQU1HO0FBQ0gsU0FBUyxzQkFBc0IsQ0FBQyxVQUFlO0lBQzNDLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQywyQkFBMkIsRUFBRSxHQUFHLENBQUMsZUFBZSxDQUFDLENBQUMsVUFBVSxDQUFDLHlCQUF5QixDQUFDLENBQUMsQ0FBQztJQUM5SCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxvQkFBb0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLENBQUMsQ0FBQztJQUMvRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDO0lBQ25HLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFdBQVcsRUFBRSxHQUFHLENBQUMsZUFBZSxDQUFDLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7SUFDOUYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMscUJBQXFCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUM7SUFDakgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsOEJBQThCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyw0QkFBNEIsQ0FBQyxDQUFDLENBQUM7SUFDbkksTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDO0lBQ3ZHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG9CQUFvQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsa0JBQWtCLENBQUMsQ0FBQyxDQUFDO0lBQy9HLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHdCQUF3QixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsc0JBQXNCLENBQUMsQ0FBQyxDQUFDO0lBQ3ZILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFdBQVcsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7SUFDN0YsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsK0JBQStCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyw2QkFBNkIsQ0FBQyxDQUFDLENBQUM7SUFDckksTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsb0JBQW9CLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDLENBQUM7SUFDL0csTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZUFBZSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsYUFBYSxDQUFDLENBQUMsQ0FBQztJQUNyRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxzQkFBc0IsRUFBRSxHQUFHLENBQUMsZUFBZSxDQUFDLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDLENBQUMsQ0FBQztJQUNwSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztJQUN0RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQztJQUM3RyxPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMscURBQXFELENBQUMsQ0FBQztBQUM5RSxDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsNkJBQTZCLENBQUMsVUFBZTtJQUNsRCxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQsc0JBQXNCLENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDbkQsT0FBTztRQUNILHlCQUF5QixFQUFFLEdBQUcsQ0FBQyx1QkFBdUIsQ0FBQyxVQUFVLENBQUMseUJBQXlCLENBQUM7UUFDNUYsa0JBQWtCLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQztRQUM3RSxZQUFZLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUM7UUFDakUsU0FBUyxFQUFFLEdBQUcsQ0FBQyx1QkFBdUIsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDO1FBQzVELG1CQUFtQixFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsbUJBQW1CLENBQUM7UUFDL0UsNEJBQTRCLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyw0QkFBNEIsQ0FBQztRQUNqRyxjQUFjLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUM7UUFDckUsa0JBQWtCLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQztRQUM3RSxzQkFBc0IsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLHNCQUFzQixDQUFDO1FBQ3JGLFNBQVMsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQztRQUMzRCw2QkFBNkIsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLDZCQUE2QixDQUFDO1FBQ25HLGtCQUFrQixFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsa0JBQWtCLENBQUM7UUFDN0UsYUFBYSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsYUFBYSxDQUFDO1FBQ25FLG9CQUFvQixFQUFFLEdBQUcsQ0FBQyx1QkFBdUIsQ0FBQyxVQUFVLENBQUMsb0JBQW9CLENBQUM7UUFDbEYsSUFBSSxFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLHNCQUFzQixDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQztRQUNqRSxpQkFBaUIsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDO0tBQzlFLENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMsK0JBQStCLENBQUMsVUFBZTtJQUNwRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUFpQixDQUFDO0lBQzVFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQywyQkFBMkIsRUFBRSwyQkFBMkIsRUFBRSxVQUFVLENBQUMseUJBQXlCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUMxTixHQUFHLENBQUMsaUJBQWlCLENBQUMsb0JBQW9CLEVBQUUsb0JBQW9CLEVBQUUsVUFBVSxDQUFDLGtCQUFrQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsa0JBQWtCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDN0wsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGNBQWMsRUFBRSxjQUFjLEVBQUUsVUFBVSxDQUFDLFlBQVksSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNySyxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLFdBQVcsRUFBRSxVQUFVLENBQUMsU0FBUyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzFKLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxxQkFBcUIsRUFBRSxxQkFBcUIsRUFBRSxVQUFVLENBQUMsbUJBQW1CLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNqTSxHQUFHLENBQUMsaUJBQWlCLENBQUMsOEJBQThCLEVBQUUsOEJBQThCLEVBQUUsVUFBVSxDQUFDLDRCQUE0QixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsNEJBQTRCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDck8sR0FBRyxDQUFDLGlCQUFpQixDQUFDLGdCQUFnQixFQUFFLGdCQUFnQixFQUFFLFVBQVUsQ0FBQyxjQUFjLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDN0ssR0FBRyxDQUFDLGlCQUFpQixDQUFDLG9CQUFvQixFQUFFLG9CQUFvQixFQUFFLFVBQVUsQ0FBQyxrQkFBa0IsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzdMLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyx3QkFBd0IsRUFBRSx3QkFBd0IsRUFBRSxVQUFVLENBQUMsc0JBQXNCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUM3TSxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLFdBQVcsRUFBRSxVQUFVLENBQUMsU0FBUyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3pKLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQywrQkFBK0IsRUFBRSwrQkFBK0IsRUFBRSxVQUFVLENBQUMsNkJBQTZCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyw2QkFBNkIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUN6TyxHQUFHLENBQUMsaUJBQWlCLENBQUMsb0JBQW9CLEVBQUUsb0JBQW9CLEVBQUUsVUFBVSxDQUFDLGtCQUFrQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLE1BQU0sQ0FBQyxVQUFVLENBQUMsa0JBQWtCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDMUwsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGVBQWUsRUFBRSxlQUFlLEVBQUUsVUFBVSxDQUFDLGFBQWEsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxNQUFNLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUN0SyxHQUFHLENBQUMsaUJBQWlCLENBQUMsc0JBQXNCLEVBQUUsc0JBQXNCLEVBQUUsVUFBVSxDQUFDLG9CQUFvQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsb0JBQW9CLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDdE0sR0FBRyxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxNQUFNLEVBQUUsVUFBVSxDQUFDLElBQUksSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBZ0IsQ0FBQyxDQUFDO0lBQ25MLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxtQkFBbUIsRUFBRSxVQUFVLENBQUMsaUJBQWlCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUN6TCxHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBRUQ7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0dBb0JHO0FBQ0gsTUFBYSxRQUFTLFNBQVEsR0FBRyxDQUFDLFdBQVc7SUFNekM7Ozs7OztPQU1HO0lBQ0ksTUFBTSxDQUFDLG1CQUFtQixDQUFDLEtBQTJCLEVBQUUsRUFBVSxFQUFFLGtCQUF1QixFQUFFLE9BQTRDO1FBQzVJLGtCQUFrQixHQUFHLGtCQUFrQixJQUFJLEVBQUUsQ0FBQztRQUM5QyxNQUFNLGtCQUFrQixHQUFHLE9BQU8sQ0FBQyxNQUFNLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBQ3BGLE1BQU0sV0FBVyxHQUFHLCtCQUErQixDQUFDLGtCQUFrQixDQUFDLENBQUM7UUFDeEUsTUFBTSxHQUFHLEdBQUcsSUFBSSxRQUFRLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxXQUFXLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDdkQsS0FBSyxNQUFNLENBQUMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxJQUFJLE1BQU0sQ0FBQyxPQUFPLENBQUMsV0FBVyxDQUFDLGVBQWUsQ0FBQyxFQUFHO1lBQzNFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLENBQUM7U0FDN0M7UUFDRCxPQUFPLENBQUMsTUFBTSxDQUFDLGdCQUFnQixDQUFDLEdBQUcsRUFBRSxrQkFBa0IsRUFBRSxFQUFFLENBQUMsQ0FBQztRQUM3RCxPQUFPLEdBQUcsQ0FBQztLQUNkO0lBNktEOzs7Ozs7T0FNRztJQUNILFlBQVksS0FBMkIsRUFBRSxFQUFVLEVBQUUsUUFBdUIsRUFBRTtRQUMxRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxFQUFFLElBQUksRUFBRSxRQUFRLENBQUMsc0JBQXNCLEVBQUUsVUFBVSxFQUFFLEtBQUssRUFBRSxDQUFDLENBQUM7Ozs7OzsrQ0E1TTFFLFFBQVE7Ozs7UUE2TWIsSUFBSSxDQUFDLE9BQU8sR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssRUFBRSxHQUFHLENBQUMsa0JBQWtCLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQztRQUNyRixJQUFJLENBQUMsYUFBYSxHQUFHLEdBQUcsQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsV0FBVyxFQUFFLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDO1FBQ2pHLElBQUksQ0FBQyxZQUFZLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxVQUFVLEVBQUUsR0FBRyxDQUFDLGtCQUFrQixDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUM7UUFFL0YsSUFBSSxDQUFDLHlCQUF5QixHQUFHLEtBQUssQ0FBQyx5QkFBeUIsQ0FBQztRQUNqRSxJQUFJLENBQUMsa0JBQWtCLEdBQUcsS0FBSyxDQUFDLGtCQUFrQixDQUFDO1FBQ25ELElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDLFlBQVksQ0FBQztRQUN2QyxJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQyxTQUFTLENBQUM7UUFDakMsSUFBSSxDQUFDLG1CQUFtQixHQUFHLEtBQUssQ0FBQyxtQkFBbUIsQ0FBQztRQUNyRCxJQUFJLENBQUMsNEJBQTRCLEdBQUcsS0FBSyxDQUFDLDRCQUE0QixDQUFDO1FBQ3ZFLElBQUksQ0FBQyxjQUFjLEdBQUcsS0FBSyxDQUFDLGNBQWMsQ0FBQztRQUMzQyxJQUFJLENBQUMsa0JBQWtCLEdBQUcsS0FBSyxDQUFDLGtCQUFrQixDQUFDO1FBQ25ELElBQUksQ0FBQyxzQkFBc0IsR0FBRyxLQUFLLENBQUMsc0JBQXNCLENBQUM7UUFDM0QsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsU0FBUyxDQUFDO1FBQ2pDLElBQUksQ0FBQyw2QkFBNkIsR0FBRyxLQUFLLENBQUMsNkJBQTZCLENBQUM7UUFDekUsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQztRQUNuRCxJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQyxhQUFhLENBQUM7UUFDekMsSUFBSSxDQUFDLG9CQUFvQixHQUFHLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQztRQUN2RCxJQUFJLENBQUMsSUFBSSxHQUFHLElBQUksR0FBRyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsT0FBTyxDQUFDLFFBQVEsRUFBRSxpQkFBaUIsRUFBRSxLQUFLLENBQUMsSUFBSSxFQUFFLEVBQUUsZUFBZSxFQUFFLE1BQU0sRUFBRSxDQUFDLENBQUM7UUFDakgsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQztRQUNqRCxJQUFJLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxJQUFJLEdBQUcsQ0FBQyxRQUFRLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLEVBQUU7WUFDN0QsSUFBSSxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsRUFBRSxRQUFRLEVBQUUsR0FBRyxFQUFFLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxjQUFjLEtBQUssU0FBUztvQkFDcEYsQ0FBQyxDQUFDLENBQUMsd0lBQXdJLENBQUM7b0JBQzVJLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1NBQ2I7S0FDSjtJQUVEOzs7OztPQUtHO0lBQ0ksT0FBTyxDQUFDLFNBQTRCOzs7Ozs7Ozs7O1FBQ3ZDLFNBQVMsQ0FBQyxZQUFZLENBQUMsNkJBQTZCLEVBQUUsUUFBUSxDQUFDLHNCQUFzQixDQUFDLENBQUM7UUFDdkYsU0FBUyxDQUFDLFlBQVksQ0FBQyw4QkFBOEIsRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLENBQUM7S0FDOUU7SUFFRCxJQUF1QixhQUFhO1FBQ2hDLE9BQU87WUFDSCx5QkFBeUIsRUFBRSxJQUFJLENBQUMseUJBQXlCO1lBQ3pELGtCQUFrQixFQUFFLElBQUksQ0FBQyxrQkFBa0I7WUFDM0MsWUFBWSxFQUFFLElBQUksQ0FBQyxZQUFZO1lBQy9CLFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUztZQUN6QixtQkFBbUIsRUFBRSxJQUFJLENBQUMsbUJBQW1CO1lBQzdDLDRCQUE0QixFQUFFLElBQUksQ0FBQyw0QkFBNEI7WUFDL0QsY0FBYyxFQUFFLElBQUksQ0FBQyxjQUFjO1lBQ25DLGtCQUFrQixFQUFFLElBQUksQ0FBQyxrQkFBa0I7WUFDM0Msc0JBQXNCLEVBQUUsSUFBSSxDQUFDLHNCQUFzQjtZQUNuRCxTQUFTLEVBQUUsSUFBSSxDQUFDLFNBQVM7WUFDekIsNkJBQTZCLEVBQUUsSUFBSSxDQUFDLDZCQUE2QjtZQUNqRSxrQkFBa0IsRUFBRSxJQUFJLENBQUMsa0JBQWtCO1lBQzNDLGFBQWEsRUFBRSxJQUFJLENBQUMsYUFBYTtZQUNqQyxvQkFBb0IsRUFBRSxJQUFJLENBQUMsb0JBQW9CO1lBQy9DLElBQUksRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLFVBQVUsRUFBRTtZQUM1QixpQkFBaUIsRUFBRSxJQUFJLENBQUMsaUJBQWlCO1NBQzVDLENBQUM7S0FDTDtJQUVrQixnQkFBZ0IsQ0FBQyxLQUEyQjtRQUMzRCxPQUFPLDZCQUE2QixDQUFDLEtBQUssQ0FBQyxDQUFDO0tBQy9DOzs7O0FBelFEOztHQUVHO0FBQ29CLCtCQUFzQixHQUFHLGlCQUFpQixDQUFDO0FBSnpELDRCQUFRO0FBc1NyQjs7Ozs7O0dBTUc7QUFDSCxTQUFTLDRCQUE0QixDQUFDLFVBQWU7SUFDakQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGdCQUFnQixFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDO0lBQzFHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGdCQUFnQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQztJQUN2RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxRQUFRLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUM7SUFDMUYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsUUFBUSxFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUM7SUFDMUcsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLDJEQUEyRCxDQUFDLENBQUM7QUFDcEYsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLG1DQUFtQyxDQUFDLFVBQWU7SUFDeEQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELDRCQUE0QixDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ3pELE9BQU87UUFDSCxjQUFjLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUM7UUFDckUsTUFBTSxFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLHNCQUFzQixDQUFDLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQztLQUN4RSxDQUFDO0FBQ04sQ0FBQztBQUVELG9CQUFvQjtBQUNwQixTQUFTLHFDQUFxQyxDQUFDLFVBQWU7SUFDMUQsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBdUIsQ0FBQztJQUNsRixHQUFHLENBQUMsaUJBQWlCLENBQUMsZ0JBQWdCLEVBQUUsZ0JBQWdCLEVBQUUsU0FBUyxDQUFDLGtCQUFrQixDQUFDLE1BQU0sQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQztJQUMxSCxHQUFHLENBQUMsaUJBQWlCLENBQUMsUUFBUSxFQUFFLFFBQVEsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsY0FBYyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDO0lBQzFHLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUFFRDs7Ozs7Ozs7O0dBU0c7QUFDSCxNQUFhLGNBQWUsU0FBUSxHQUFHLENBQUMsV0FBVztJQU0vQzs7Ozs7O09BTUc7SUFDSSxNQUFNLENBQUMsbUJBQW1CLENBQUMsS0FBMkIsRUFBRSxFQUFVLEVBQUUsa0JBQXVCLEVBQUUsT0FBNEM7UUFDNUksa0JBQWtCLEdBQUcsa0JBQWtCLElBQUksRUFBRSxDQUFDO1FBQzlDLE1BQU0sa0JBQWtCLEdBQUcsT0FBTyxDQUFDLE1BQU0sQ0FBQyxVQUFVLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLENBQUM7UUFDcEYsTUFBTSxXQUFXLEdBQUcscUNBQXFDLENBQUMsa0JBQWtCLENBQUMsQ0FBQztRQUM5RSxNQUFNLEdBQUcsR0FBRyxJQUFJLGNBQWMsQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLFdBQVcsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUM3RCxLQUFLLE1BQU0sQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLElBQUksTUFBTSxDQUFDLE9BQU8sQ0FBQyxXQUFXLENBQUMsZUFBZSxDQUFDLEVBQUc7WUFDM0UsR0FBRyxDQUFDLG1CQUFtQixDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUMsQ0FBQztTQUM3QztRQUNELE9BQU8sQ0FBQyxNQUFNLENBQUMsZ0JBQWdCLENBQUMsR0FBRyxFQUFFLGtCQUFrQixFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQzdELE9BQU8sR0FBRyxDQUFDO0tBQ2Q7SUFnQkQ7Ozs7OztPQU1HO0lBQ0gsWUFBWSxLQUEyQixFQUFFLEVBQVUsRUFBRSxLQUEwQjtRQUMzRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxFQUFFLElBQUksRUFBRSxjQUFjLENBQUMsc0JBQXNCLEVBQUUsVUFBVSxFQUFFLEtBQUssRUFBRSxDQUFDLENBQUM7Ozs7OzsrQ0EvQ2hGLGNBQWM7Ozs7UUFnRG5CLEdBQUcsQ0FBQyxlQUFlLENBQUMsS0FBSyxFQUFFLGdCQUFnQixFQUFFLElBQUksQ0FBQyxDQUFDO1FBQ25ELEdBQUcsQ0FBQyxlQUFlLENBQUMsS0FBSyxFQUFFLFFBQVEsRUFBRSxJQUFJLENBQUMsQ0FBQztRQUUzQyxJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQyxjQUFjLENBQUM7UUFDM0MsSUFBSSxDQUFDLE1BQU0sR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDO0tBQzlCO0lBRUQ7Ozs7O09BS0c7SUFDSSxPQUFPLENBQUMsU0FBNEI7Ozs7Ozs7Ozs7UUFDdkMsU0FBUyxDQUFDLFlBQVksQ0FBQyw2QkFBNkIsRUFBRSxjQUFjLENBQUMsc0JBQXNCLENBQUMsQ0FBQztRQUM3RixTQUFTLENBQUMsWUFBWSxDQUFDLDhCQUE4QixFQUFFLElBQUksQ0FBQyxhQUFhLENBQUMsQ0FBQztLQUM5RTtJQUVELElBQXVCLGFBQWE7UUFDaEMsT0FBTztZQUNILGNBQWMsRUFBRSxJQUFJLENBQUMsY0FBYztZQUNuQyxNQUFNLEVBQUUsSUFBSSxDQUFDLE1BQU07U0FDdEIsQ0FBQztLQUNMO0lBRWtCLGdCQUFnQixDQUFDLEtBQTJCO1FBQzNELE9BQU8sbUNBQW1DLENBQUMsS0FBSyxDQUFDLENBQUM7S0FDckQ7Ozs7QUExRUQ7O0dBRUc7QUFDb0IscUNBQXNCLEdBQUcsdUJBQXVCLENBQUM7QUFKL0Qsd0NBQWMiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBDb3B5cmlnaHQgMjAxMi0yMDIzIEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4vLyBHZW5lcmF0ZWQgZnJvbSB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIFJlc291cmNlIFNwZWNpZmljYXRpb25cbi8vIFNlZTogZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2Nmbi1yZXNvdXJjZS1zcGVjaWZpY2F0aW9uLmh0bWxcbi8vIEBjZm4ydHM6bWV0YUAge1wiZ2VuZXJhdGVkXCI6XCIyMDIzLTA0LTEzVDE1OjQ2OjAzLjgxNVpcIixcImZpbmdlcnByaW50XCI6XCI1TjlpakU4ck9NQXZiN0UxbFdiNThwMlFYcjAzUDdrb0puRHZtdmdYMGhrPVwifVxuXG4vKiBlc2xpbnQtZGlzYWJsZSBtYXgtbGVuICovIC8vIFRoaXMgaXMgZ2VuZXJhdGVkIGNvZGUgLSBsaW5lIGxlbmd0aHMgYXJlIGRpZmZpY3VsdCB0byBjb250cm9sXG5cbmltcG9ydCAqIGFzIGNvbnN0cnVjdHMgZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgKiBhcyBjZGsgZnJvbSAnLi4vLi4vY29yZSc7XG5pbXBvcnQgKiBhcyBjZm5fcGFyc2UgZnJvbSAnLi4vLi4vY29yZS9saWIvaGVscGVycy1pbnRlcm5hbCc7XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgZGVmaW5pbmcgYSBgQ2ZuUXVldWVgXG4gKlxuICogQHN0cnVjdFxuICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICpcbiAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLXNxcy1xdWV1ZS5odG1sXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ2ZuUXVldWVQcm9wcyB7XG5cbiAgICAvKipcbiAgICAgKiBGb3IgZmlyc3QtaW4tZmlyc3Qtb3V0IChGSUZPKSBxdWV1ZXMsIHNwZWNpZmllcyB3aGV0aGVyIHRvIGVuYWJsZSBjb250ZW50LWJhc2VkIGRlZHVwbGljYXRpb24uIER1cmluZyB0aGUgZGVkdXBsaWNhdGlvbiBpbnRlcnZhbCwgQW1hem9uIFNRUyB0cmVhdHMgbWVzc2FnZXMgdGhhdCBhcmUgc2VudCB3aXRoIGlkZW50aWNhbCBjb250ZW50IGFzIGR1cGxpY2F0ZXMgYW5kIGRlbGl2ZXJzIG9ubHkgb25lIGNvcHkgb2YgdGhlIG1lc3NhZ2UuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgdGhlIGBDb250ZW50QmFzZWREZWR1cGxpY2F0aW9uYCBhdHRyaWJ1dGUgZm9yIHRoZSBgW0NyZWF0ZVF1ZXVlXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTU2ltcGxlUXVldWVTZXJ2aWNlL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0NyZWF0ZVF1ZXVlLmh0bWwpYCBhY3Rpb24gaW4gdGhlICpBbWF6b24gU1FTIEFQSSBSZWZlcmVuY2UqIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLXNxcy1xdWV1ZS5odG1sI2Nmbi1zcXMtcXVldWUtY29udGVudGJhc2VkZGVkdXBsaWNhdGlvblxuICAgICAqL1xuICAgIHJlYWRvbmx5IGNvbnRlbnRCYXNlZERlZHVwbGljYXRpb24/OiBib29sZWFuIHwgY2RrLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogRm9yIGhpZ2ggdGhyb3VnaHB1dCBmb3IgRklGTyBxdWV1ZXMsIHNwZWNpZmllcyB3aGV0aGVyIG1lc3NhZ2UgZGVkdXBsaWNhdGlvbiBvY2N1cnMgYXQgdGhlIG1lc3NhZ2UgZ3JvdXAgb3IgcXVldWUgbGV2ZWwuIFZhbGlkIHZhbHVlcyBhcmUgYG1lc3NhZ2VHcm91cGAgYW5kIGBxdWV1ZWAgLlxuICAgICAqXG4gICAgICogVG8gZW5hYmxlIGhpZ2ggdGhyb3VnaHB1dCBmb3IgYSBGSUZPIHF1ZXVlLCBzZXQgdGhpcyBhdHRyaWJ1dGUgdG8gYG1lc3NhZ2VHcm91cGAgKmFuZCogc2V0IHRoZSBgRmlmb1Rocm91Z2hwdXRMaW1pdGAgYXR0cmlidXRlIHRvIGBwZXJNZXNzYWdlR3JvdXBJZGAgLiBJZiB5b3Ugc2V0IHRoZXNlIGF0dHJpYnV0ZXMgdG8gYW55dGhpbmcgb3RoZXIgdGhhbiB0aGVzZSB2YWx1ZXMsIG5vcm1hbCB0aHJvdWdocHV0IGlzIGluIGVmZmVjdCBhbmQgZGVkdXBsaWNhdGlvbiBvY2N1cnMgYXMgc3BlY2lmaWVkLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtIaWdoIHRocm91Z2hwdXQgZm9yIEZJRk8gcXVldWVzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTU2ltcGxlUXVldWVTZXJ2aWNlL2xhdGVzdC9TUVNEZXZlbG9wZXJHdWlkZS9oaWdoLXRocm91Z2hwdXQtZmlmby5odG1sKSBhbmQgW1F1b3RhcyByZWxhdGVkIHRvIG1lc3NhZ2VzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTU2ltcGxlUXVldWVTZXJ2aWNlL2xhdGVzdC9TUVNEZXZlbG9wZXJHdWlkZS9xdW90YXMtbWVzc2FnZXMuaHRtbCkgaW4gdGhlICpBbWF6b24gU1FTIERldmVsb3BlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2Utc3FzLXF1ZXVlLmh0bWwjY2ZuLXNxcy1xdWV1ZS1kZWR1cGxpY2F0aW9uc2NvcGVcbiAgICAgKi9cbiAgICByZWFkb25seSBkZWR1cGxpY2F0aW9uU2NvcGU/OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgdGltZSBpbiBzZWNvbmRzIGZvciB3aGljaCB0aGUgZGVsaXZlcnkgb2YgYWxsIG1lc3NhZ2VzIGluIHRoZSBxdWV1ZSBpcyBkZWxheWVkLiBZb3UgY2FuIHNwZWNpZnkgYW4gaW50ZWdlciB2YWx1ZSBvZiBgMGAgdG8gYDkwMGAgKDE1IG1pbnV0ZXMpLiBUaGUgZGVmYXVsdCB2YWx1ZSBpcyBgMGAgLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2Utc3FzLXF1ZXVlLmh0bWwjY2ZuLXNxcy1xdWV1ZS1kZWxheXNlY29uZHNcbiAgICAgKi9cbiAgICByZWFkb25seSBkZWxheVNlY29uZHM/OiBudW1iZXI7XG5cbiAgICAvKipcbiAgICAgKiBJZiBzZXQgdG8gdHJ1ZSwgY3JlYXRlcyBhIEZJRk8gcXVldWUuIElmIHlvdSBkb24ndCBzcGVjaWZ5IHRoaXMgcHJvcGVydHksIEFtYXpvbiBTUVMgY3JlYXRlcyBhIHN0YW5kYXJkIHF1ZXVlLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtGSUZPIHF1ZXVlc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU1NpbXBsZVF1ZXVlU2VydmljZS9sYXRlc3QvU1FTRGV2ZWxvcGVyR3VpZGUvRklGTy1xdWV1ZXMuaHRtbCkgaW4gdGhlICpBbWF6b24gU1FTIERldmVsb3BlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2Utc3FzLXF1ZXVlLmh0bWwjY2ZuLXNxcy1xdWV1ZS1maWZvcXVldWVcbiAgICAgKi9cbiAgICByZWFkb25seSBmaWZvUXVldWU/OiBib29sZWFuIHwgY2RrLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogRm9yIGhpZ2ggdGhyb3VnaHB1dCBmb3IgRklGTyBxdWV1ZXMsIHNwZWNpZmllcyB3aGV0aGVyIHRoZSBGSUZPIHF1ZXVlIHRocm91Z2hwdXQgcXVvdGEgYXBwbGllcyB0byB0aGUgZW50aXJlIHF1ZXVlIG9yIHBlciBtZXNzYWdlIGdyb3VwLiBWYWxpZCB2YWx1ZXMgYXJlIGBwZXJRdWV1ZWAgYW5kIGBwZXJNZXNzYWdlR3JvdXBJZGAgLlxuICAgICAqXG4gICAgICogVG8gZW5hYmxlIGhpZ2ggdGhyb3VnaHB1dCBmb3IgYSBGSUZPIHF1ZXVlLCBzZXQgdGhpcyBhdHRyaWJ1dGUgdG8gYHBlck1lc3NhZ2VHcm91cElkYCAqYW5kKiBzZXQgdGhlIGBEZWR1cGxpY2F0aW9uU2NvcGVgIGF0dHJpYnV0ZSB0byBgbWVzc2FnZUdyb3VwYCAuIElmIHlvdSBzZXQgdGhlc2UgYXR0cmlidXRlcyB0byBhbnl0aGluZyBvdGhlciB0aGFuIHRoZXNlIHZhbHVlcywgbm9ybWFsIHRocm91Z2hwdXQgaXMgaW4gZWZmZWN0IGFuZCBkZWR1cGxpY2F0aW9uIG9jY3VycyBhcyBzcGVjaWZpZWQuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW0hpZ2ggdGhyb3VnaHB1dCBmb3IgRklGTyBxdWV1ZXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NTaW1wbGVRdWV1ZVNlcnZpY2UvbGF0ZXN0L1NRU0RldmVsb3Blckd1aWRlL2hpZ2gtdGhyb3VnaHB1dC1maWZvLmh0bWwpIGFuZCBbUXVvdGFzIHJlbGF0ZWQgdG8gbWVzc2FnZXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NTaW1wbGVRdWV1ZVNlcnZpY2UvbGF0ZXN0L1NRU0RldmVsb3Blckd1aWRlL3F1b3Rhcy1tZXNzYWdlcy5odG1sKSBpbiB0aGUgKkFtYXpvbiBTUVMgRGV2ZWxvcGVyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1zcXMtcXVldWUuaHRtbCNjZm4tc3FzLXF1ZXVlLWZpZm90aHJvdWdocHV0bGltaXRcbiAgICAgKi9cbiAgICByZWFkb25seSBmaWZvVGhyb3VnaHB1dExpbWl0Pzogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIGxlbmd0aCBvZiB0aW1lIGluIHNlY29uZHMgZm9yIHdoaWNoIEFtYXpvbiBTUVMgY2FuIHJldXNlIGEgZGF0YSBrZXkgdG8gZW5jcnlwdCBvciBkZWNyeXB0IG1lc3NhZ2VzIGJlZm9yZSBjYWxsaW5nIEFXUyBLTVMgYWdhaW4uIFRoZSB2YWx1ZSBtdXN0IGJlIGFuIGludGVnZXIgYmV0d2VlbiA2MCAoMSBtaW51dGUpIGFuZCA4Niw0MDAgKDI0IGhvdXJzKS4gVGhlIGRlZmF1bHQgaXMgMzAwICg1IG1pbnV0ZXMpLlxuICAgICAqXG4gICAgICogPiBBIHNob3J0ZXIgdGltZSBwZXJpb2QgcHJvdmlkZXMgYmV0dGVyIHNlY3VyaXR5LCBidXQgcmVzdWx0cyBpbiBtb3JlIGNhbGxzIHRvIEFXUyBLTVMgLCB3aGljaCBtaWdodCBpbmN1ciBjaGFyZ2VzIGFmdGVyIEZyZWUgVGllci4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbRW5jcnlwdGlvbiBhdCByZXN0XShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTU2ltcGxlUXVldWVTZXJ2aWNlL2xhdGVzdC9TUVNEZXZlbG9wZXJHdWlkZS9zcXMtc2VydmVyLXNpZGUtZW5jcnlwdGlvbi5odG1sI3Nxcy1ob3ctZG9lcy10aGUtZGF0YS1rZXktcmV1c2UtcGVyaW9kLXdvcmspIGluIHRoZSAqQW1hem9uIFNRUyBEZXZlbG9wZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLXNxcy1xdWV1ZS5odG1sI2Nmbi1zcXMtcXVldWUta21zZGF0YWtleXJldXNlcGVyaW9kc2Vjb25kc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IGttc0RhdGFLZXlSZXVzZVBlcmlvZFNlY29uZHM/OiBudW1iZXI7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgSUQgb2YgYW4gQVdTIEtleSBNYW5hZ2VtZW50IFNlcnZpY2UgKEtNUykgZm9yIEFtYXpvbiBTUVMgLCBvciBhIGN1c3RvbSBLTVMuIFRvIHVzZSB0aGUgQVdTIG1hbmFnZWQgS01TIGZvciBBbWF6b24gU1FTICwgc3BlY2lmeSBhIChkZWZhdWx0KSBhbGlhcyBBUk4sIGFsaWFzIG5hbWUgKGUuZy4gYGFsaWFzL2F3cy9zcXNgICksIGtleSBBUk4sIG9yIGtleSBJRC4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSB0aGUgZm9sbG93aW5nOlxuICAgICAqXG4gICAgICogLSBbRW5jcnlwdGlvbiBhdCByZXN0XShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTU2ltcGxlUXVldWVTZXJ2aWNlL2xhdGVzdC9TUVNEZXZlbG9wZXJHdWlkZS9zcXMtc2VydmVyLXNpZGUtZW5jcnlwdGlvbi5odG1sKSBpbiB0aGUgKkFtYXpvbiBTUVMgRGV2ZWxvcGVyIEd1aWRlKlxuICAgICAqIC0gW0NyZWF0ZVF1ZXVlXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTU2ltcGxlUXVldWVTZXJ2aWNlL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0NyZWF0ZVF1ZXVlLmh0bWwpIGluIHRoZSAqQW1hem9uIFNRUyBBUEkgUmVmZXJlbmNlKlxuICAgICAqIC0gW1JlcXVlc3QgUGFyYW1ldGVyc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ttcy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9EZXNjcmliZUtleS5odG1sI0FQSV9EZXNjcmliZUtleV9SZXF1ZXN0UGFyYW1ldGVycykgaW4gdGhlICpBV1MgS2V5IE1hbmFnZW1lbnQgU2VydmljZSBBUEkgUmVmZXJlbmNlKlxuICAgICAqIC0gVGhlIEtleSBNYW5hZ2VtZW50IFNlcnZpY2UgKEtNUykgc2VjdGlvbiBvZiB0aGUgW0FXUyBLZXkgTWFuYWdlbWVudCBTZXJ2aWNlIEJlc3QgUHJhY3RpY2VzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaHR0cHM6Ly9kMC5hd3NzdGF0aWMuY29tL3doaXRlcGFwZXJzL2F3cy1rbXMtYmVzdC1wcmFjdGljZXMucGRmKSB3aGl0ZXBhcGVyXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1zcXMtcXVldWUuaHRtbCNjZm4tc3FzLXF1ZXVlLWttc21hc3RlcmtleWlkXG4gICAgICovXG4gICAgcmVhZG9ubHkga21zTWFzdGVyS2V5SWQ/OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbGltaXQgb2YgaG93IG1hbnkgYnl0ZXMgdGhhdCBhIG1lc3NhZ2UgY2FuIGNvbnRhaW4gYmVmb3JlIEFtYXpvbiBTUVMgcmVqZWN0cyBpdC4gWW91IGNhbiBzcGVjaWZ5IGFuIGludGVnZXIgdmFsdWUgZnJvbSBgMSwwMjRgIGJ5dGVzICgxIEtpQikgdG8gYDI2MiwxNDRgIGJ5dGVzICgyNTYgS2lCKS4gVGhlIGRlZmF1bHQgdmFsdWUgaXMgYDI2MiwxNDRgICgyNTYgS2lCKS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLXNxcy1xdWV1ZS5odG1sI2Nmbi1zcXMtcXVldWUtbWF4aW11bW1lc3NhZ2VzaXplXG4gICAgICovXG4gICAgcmVhZG9ubHkgbWF4aW11bU1lc3NhZ2VTaXplPzogbnVtYmVyO1xuXG4gICAgLyoqXG4gICAgICogVGhlIG51bWJlciBvZiBzZWNvbmRzIHRoYXQgQW1hem9uIFNRUyByZXRhaW5zIGEgbWVzc2FnZS4gWW91IGNhbiBzcGVjaWZ5IGFuIGludGVnZXIgdmFsdWUgZnJvbSBgNjBgIHNlY29uZHMgKDEgbWludXRlKSB0byBgMSwyMDksNjAwYCBzZWNvbmRzICgxNCBkYXlzKS4gVGhlIGRlZmF1bHQgdmFsdWUgaXMgYDM0NSw2MDBgIHNlY29uZHMgKDQgZGF5cykuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1zcXMtcXVldWUuaHRtbCNjZm4tc3FzLXF1ZXVlLW1lc3NhZ2VyZXRlbnRpb25wZXJpb2RcbiAgICAgKi9cbiAgICByZWFkb25seSBtZXNzYWdlUmV0ZW50aW9uUGVyaW9kPzogbnVtYmVyO1xuXG4gICAgLyoqXG4gICAgICogQSBuYW1lIGZvciB0aGUgcXVldWUuIFRvIGNyZWF0ZSBhIEZJRk8gcXVldWUsIHRoZSBuYW1lIG9mIHlvdXIgRklGTyBxdWV1ZSBtdXN0IGVuZCB3aXRoIHRoZSBgLmZpZm9gIHN1ZmZpeC4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbRklGTyBxdWV1ZXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NTaW1wbGVRdWV1ZVNlcnZpY2UvbGF0ZXN0L1NRU0RldmVsb3Blckd1aWRlL0ZJRk8tcXVldWVzLmh0bWwpIGluIHRoZSAqQW1hem9uIFNRUyBEZXZlbG9wZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqIElmIHlvdSBkb24ndCBzcGVjaWZ5IGEgbmFtZSwgQVdTIENsb3VkRm9ybWF0aW9uIGdlbmVyYXRlcyBhIHVuaXF1ZSBwaHlzaWNhbCBJRCBhbmQgdXNlcyB0aGF0IElEIGZvciB0aGUgcXVldWUgbmFtZS4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbTmFtZSB0eXBlXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1uYW1lLmh0bWwpIGluIHRoZSAqQVdTIENsb3VkRm9ybWF0aW9uIFVzZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqID4gSWYgeW91IHNwZWNpZnkgYSBuYW1lLCB5b3UgY2FuJ3QgcGVyZm9ybSB1cGRhdGVzIHRoYXQgcmVxdWlyZSByZXBsYWNlbWVudCBvZiB0aGlzIHJlc291cmNlLiBZb3UgY2FuIHBlcmZvcm0gdXBkYXRlcyB0aGF0IHJlcXVpcmUgbm8gb3Igc29tZSBpbnRlcnJ1cHRpb24uIElmIHlvdSBtdXN0IHJlcGxhY2UgdGhlIHJlc291cmNlLCBzcGVjaWZ5IGEgbmV3IG5hbWUuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1zcXMtcXVldWUuaHRtbCNjZm4tc3FzLXF1ZXVlLXF1ZXVlbmFtZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IHF1ZXVlTmFtZT86IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyB0aGUgZHVyYXRpb24sIGluIHNlY29uZHMsIHRoYXQgdGhlIFJlY2VpdmVNZXNzYWdlIGFjdGlvbiBjYWxsIHdhaXRzIHVudGlsIGEgbWVzc2FnZSBpcyBpbiB0aGUgcXVldWUgaW4gb3JkZXIgdG8gaW5jbHVkZSBpdCBpbiB0aGUgcmVzcG9uc2UsIHJhdGhlciB0aGFuIHJldHVybmluZyBhbiBlbXB0eSByZXNwb25zZSBpZiBhIG1lc3NhZ2UgaXNuJ3QgeWV0IGF2YWlsYWJsZS4gWW91IGNhbiBzcGVjaWZ5IGFuIGludGVnZXIgZnJvbSAxIHRvIDIwLiBTaG9ydCBwb2xsaW5nIGlzIHVzZWQgYXMgdGhlIGRlZmF1bHQgb3Igd2hlbiB5b3Ugc3BlY2lmeSAwIGZvciB0aGlzIHByb3BlcnR5LiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtDb25zdW1pbmcgbWVzc2FnZXMgdXNpbmcgbG9uZyBwb2xsaW5nXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTU2ltcGxlUXVldWVTZXJ2aWNlL2xhdGVzdC9TUVNEZXZlbG9wZXJHdWlkZS9zcXMtc2hvcnQtYW5kLWxvbmctcG9sbGluZy5odG1sI3Nxcy1sb25nLXBvbGxpbmcpIGluIHRoZSAqQW1hem9uIFNRUyBEZXZlbG9wZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLXNxcy1xdWV1ZS5odG1sI2Nmbi1zcXMtcXVldWUtcmVjZWl2ZW1lc3NhZ2V3YWl0dGltZXNlY29uZHNcbiAgICAgKi9cbiAgICByZWFkb25seSByZWNlaXZlTWVzc2FnZVdhaXRUaW1lU2Vjb25kcz86IG51bWJlcjtcblxuICAgIC8qKlxuICAgICAqIFRoZSBzdHJpbmcgdGhhdCBpbmNsdWRlcyB0aGUgcGFyYW1ldGVycyBmb3IgdGhlIHBlcm1pc3Npb25zIGZvciB0aGUgZGVhZC1sZXR0ZXIgcXVldWUgcmVkcml2ZSBwZXJtaXNzaW9uIGFuZCB3aGljaCBzb3VyY2UgcXVldWVzIGNhbiBzcGVjaWZ5IGRlYWQtbGV0dGVyIHF1ZXVlcyBhcyBhIEpTT04gb2JqZWN0LiBUaGUgcGFyYW1ldGVycyBhcmUgYXMgZm9sbG93czpcbiAgICAgKlxuICAgICAqIC0gYHJlZHJpdmVQZXJtaXNzaW9uYCA6IFRoZSBwZXJtaXNzaW9uIHR5cGUgdGhhdCBkZWZpbmVzIHdoaWNoIHNvdXJjZSBxdWV1ZXMgY2FuIHNwZWNpZnkgdGhlIGN1cnJlbnQgcXVldWUgYXMgdGhlIGRlYWQtbGV0dGVyIHF1ZXVlLiBWYWxpZCB2YWx1ZXMgYXJlOlxuICAgICAqXG4gICAgICogLSBgYWxsb3dBbGxgIDogKERlZmF1bHQpIEFueSBzb3VyY2UgcXVldWVzIGluIHRoaXMgQVdTIGFjY291bnQgaW4gdGhlIHNhbWUgUmVnaW9uIGNhbiBzcGVjaWZ5IHRoaXMgcXVldWUgYXMgdGhlIGRlYWQtbGV0dGVyIHF1ZXVlLlxuICAgICAqIC0gYGRlbnlBbGxgIDogTm8gc291cmNlIHF1ZXVlcyBjYW4gc3BlY2lmeSB0aGlzIHF1ZXVlIGFzIHRoZSBkZWFkLWxldHRlciBxdWV1ZS5cbiAgICAgKiAtIGBieVF1ZXVlYCA6IE9ubHkgcXVldWVzIHNwZWNpZmllZCBieSB0aGUgYHNvdXJjZVF1ZXVlQXJuc2AgcGFyYW1ldGVyIGNhbiBzcGVjaWZ5IHRoaXMgcXVldWUgYXMgdGhlIGRlYWQtbGV0dGVyIHF1ZXVlLlxuICAgICAqIC0gYHNvdXJjZVF1ZXVlQXJuc2AgOiBUaGUgQW1hem9uIFJlc291cmNlIE5hbWVzIChBUk4pcyBvZiB0aGUgc291cmNlIHF1ZXVlcyB0aGF0IGNhbiBzcGVjaWZ5IHRoaXMgcXVldWUgYXMgdGhlIGRlYWQtbGV0dGVyIHF1ZXVlIGFuZCByZWRyaXZlIG1lc3NhZ2VzLiBZb3UgY2FuIHNwZWNpZnkgdGhpcyBwYXJhbWV0ZXIgb25seSB3aGVuIHRoZSBgcmVkcml2ZVBlcm1pc3Npb25gIHBhcmFtZXRlciBpcyBzZXQgdG8gYGJ5UXVldWVgIC4gWW91IGNhbiBzcGVjaWZ5IHVwIHRvIDEwIHNvdXJjZSBxdWV1ZSBBUk5zLiBUbyBhbGxvdyBtb3JlIHRoYW4gMTAgc291cmNlIHF1ZXVlcyB0byBzcGVjaWZ5IGRlYWQtbGV0dGVyIHF1ZXVlcywgc2V0IHRoZSBgcmVkcml2ZVBlcm1pc3Npb25gIHBhcmFtZXRlciB0byBgYWxsb3dBbGxgIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLXNxcy1xdWV1ZS5odG1sI2Nmbi1zcXMtcXVldWUtcmVkcml2ZWFsbG93cG9saWN5XG4gICAgICovXG4gICAgcmVhZG9ubHkgcmVkcml2ZUFsbG93UG9saWN5PzogYW55IHwgY2RrLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogVGhlIHN0cmluZyB0aGF0IGluY2x1ZGVzIHRoZSBwYXJhbWV0ZXJzIGZvciB0aGUgZGVhZC1sZXR0ZXIgcXVldWUgZnVuY3Rpb25hbGl0eSBvZiB0aGUgc291cmNlIHF1ZXVlIGFzIGEgSlNPTiBvYmplY3QuIFRoZSBwYXJhbWV0ZXJzIGFyZSBhcyBmb2xsb3dzOlxuICAgICAqXG4gICAgICogLSBgZGVhZExldHRlclRhcmdldEFybmAgOiBUaGUgQW1hem9uIFJlc291cmNlIE5hbWUgKEFSTikgb2YgdGhlIGRlYWQtbGV0dGVyIHF1ZXVlIHRvIHdoaWNoIEFtYXpvbiBTUVMgbW92ZXMgbWVzc2FnZXMgYWZ0ZXIgdGhlIHZhbHVlIG9mIGBtYXhSZWNlaXZlQ291bnRgIGlzIGV4Y2VlZGVkLlxuICAgICAqIC0gYG1heFJlY2VpdmVDb3VudGAgOiBUaGUgbnVtYmVyIG9mIHRpbWVzIGEgbWVzc2FnZSBpcyBkZWxpdmVyZWQgdG8gdGhlIHNvdXJjZSBxdWV1ZSBiZWZvcmUgYmVpbmcgbW92ZWQgdG8gdGhlIGRlYWQtbGV0dGVyIHF1ZXVlLiBXaGVuIHRoZSBgUmVjZWl2ZUNvdW50YCBmb3IgYSBtZXNzYWdlIGV4Y2VlZHMgdGhlIGBtYXhSZWNlaXZlQ291bnRgIGZvciBhIHF1ZXVlLCBBbWF6b24gU1FTIG1vdmVzIHRoZSBtZXNzYWdlIHRvIHRoZSBkZWFkLWxldHRlci1xdWV1ZS5cbiAgICAgKlxuICAgICAqID4gVGhlIGRlYWQtbGV0dGVyIHF1ZXVlIG9mIGEgRklGTyBxdWV1ZSBtdXN0IGFsc28gYmUgYSBGSUZPIHF1ZXVlLiBTaW1pbGFybHksIHRoZSBkZWFkLWxldHRlciBxdWV1ZSBvZiBhIHN0YW5kYXJkIHF1ZXVlIG11c3QgYWxzbyBiZSBhIHN0YW5kYXJkIHF1ZXVlLlxuICAgICAqXG4gICAgICogKkpTT04qXG4gICAgICpcbiAgICAgKiBgeyBcImRlYWRMZXR0ZXJUYXJnZXRBcm5cIiA6ICpTdHJpbmcqICwgXCJtYXhSZWNlaXZlQ291bnRcIiA6ICpJbnRlZ2VyKiB9YFxuICAgICAqXG4gICAgICogKllBTUwqXG4gICAgICpcbiAgICAgKiBgZGVhZExldHRlclRhcmdldEFybiA6ICpTdHJpbmcqYFxuICAgICAqXG4gICAgICogYG1heFJlY2VpdmVDb3VudCA6ICpJbnRlZ2VyKmBcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLXNxcy1xdWV1ZS5odG1sI2Nmbi1zcXMtcXVldWUtcmVkcml2ZXBvbGljeVxuICAgICAqL1xuICAgIHJlYWRvbmx5IHJlZHJpdmVQb2xpY3k/OiBhbnkgfCBjZGsuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBFbmFibGVzIHNlcnZlci1zaWRlIHF1ZXVlIGVuY3J5cHRpb24gdXNpbmcgU1FTIG93bmVkIGVuY3J5cHRpb24ga2V5cy4gT25seSBvbmUgc2VydmVyLXNpZGUgZW5jcnlwdGlvbiBvcHRpb24gaXMgc3VwcG9ydGVkIHBlciBxdWV1ZSAoZm9yIGV4YW1wbGUsIFtTU0UtS01TXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTU2ltcGxlUXVldWVTZXJ2aWNlL2xhdGVzdC9TUVNEZXZlbG9wZXJHdWlkZS9zcXMtY29uZmlndXJlLXNzZS1leGlzdGluZy1xdWV1ZS5odG1sKSBvciBbU1NFLVNRU10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU1NpbXBsZVF1ZXVlU2VydmljZS9sYXRlc3QvU1FTRGV2ZWxvcGVyR3VpZGUvc3FzLWNvbmZpZ3VyZS1zcXMtc3NlLXF1ZXVlLmh0bWwpICkuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1zcXMtcXVldWUuaHRtbCNjZm4tc3FzLXF1ZXVlLXNxc21hbmFnZWRzc2VlbmFibGVkXG4gICAgICovXG4gICAgcmVhZG9ubHkgc3FzTWFuYWdlZFNzZUVuYWJsZWQ/OiBib29sZWFuIHwgY2RrLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogVGhlIHRhZ3MgdGhhdCB5b3UgYXR0YWNoIHRvIHRoaXMgcXVldWUuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW1Jlc291cmNlIHRhZ10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtcmVzb3VyY2UtdGFncy5odG1sKSBpbiB0aGUgKkFXUyBDbG91ZEZvcm1hdGlvbiBVc2VyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1zcXMtcXVldWUuaHRtbCNjZm4tc3FzLXF1ZXVlLXRhZ3NcbiAgICAgKi9cbiAgICByZWFkb25seSB0YWdzPzogY2RrLkNmblRhZ1tdO1xuXG4gICAgLyoqXG4gICAgICogVGhlIGxlbmd0aCBvZiB0aW1lIGR1cmluZyB3aGljaCBhIG1lc3NhZ2Ugd2lsbCBiZSB1bmF2YWlsYWJsZSBhZnRlciBhIG1lc3NhZ2UgaXMgZGVsaXZlcmVkIGZyb20gdGhlIHF1ZXVlLiBUaGlzIGJsb2NrcyBvdGhlciBjb21wb25lbnRzIGZyb20gcmVjZWl2aW5nIHRoZSBzYW1lIG1lc3NhZ2UgYW5kIGdpdmVzIHRoZSBpbml0aWFsIGNvbXBvbmVudCB0aW1lIHRvIHByb2Nlc3MgYW5kIGRlbGV0ZSB0aGUgbWVzc2FnZSBmcm9tIHRoZSBxdWV1ZS5cbiAgICAgKlxuICAgICAqIFZhbHVlcyBtdXN0IGJlIGZyb20gMCB0byA0MywyMDAgc2Vjb25kcyAoMTIgaG91cnMpLiBJZiB5b3UgZG9uJ3Qgc3BlY2lmeSBhIHZhbHVlLCBBV1MgQ2xvdWRGb3JtYXRpb24gdXNlcyB0aGUgZGVmYXVsdCB2YWx1ZSBvZiAzMCBzZWNvbmRzLlxuICAgICAqXG4gICAgICogRm9yIG1vcmUgaW5mb3JtYXRpb24gYWJvdXQgQW1hem9uIFNRUyBxdWV1ZSB2aXNpYmlsaXR5IHRpbWVvdXRzLCBzZWUgW1Zpc2liaWxpdHkgdGltZW91dF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU1NpbXBsZVF1ZXVlU2VydmljZS9sYXRlc3QvU1FTRGV2ZWxvcGVyR3VpZGUvc3FzLXZpc2liaWxpdHktdGltZW91dC5odG1sKSBpbiB0aGUgKkFtYXpvbiBTUVMgRGV2ZWxvcGVyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1zcXMtcXVldWUuaHRtbCNjZm4tc3FzLXF1ZXVlLXZpc2liaWxpdHl0aW1lb3V0XG4gICAgICovXG4gICAgcmVhZG9ubHkgdmlzaWJpbGl0eVRpbWVvdXQ/OiBudW1iZXI7XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgQ2ZuUXVldWVQcm9wc2BcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgQ2ZuUXVldWVQcm9wc2BcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5RdWV1ZVByb3BzVmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignY29udGVudEJhc2VkRGVkdXBsaWNhdGlvbicsIGNkay52YWxpZGF0ZUJvb2xlYW4pKHByb3BlcnRpZXMuY29udGVudEJhc2VkRGVkdXBsaWNhdGlvbikpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZGVkdXBsaWNhdGlvblNjb3BlJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmRlZHVwbGljYXRpb25TY29wZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZGVsYXlTZWNvbmRzJywgY2RrLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLmRlbGF5U2Vjb25kcykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZmlmb1F1ZXVlJywgY2RrLnZhbGlkYXRlQm9vbGVhbikocHJvcGVydGllcy5maWZvUXVldWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2ZpZm9UaHJvdWdocHV0TGltaXQnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuZmlmb1Rocm91Z2hwdXRMaW1pdCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigna21zRGF0YUtleVJldXNlUGVyaW9kU2Vjb25kcycsIGNkay52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5rbXNEYXRhS2V5UmV1c2VQZXJpb2RTZWNvbmRzKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdrbXNNYXN0ZXJLZXlJZCcsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5rbXNNYXN0ZXJLZXlJZCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbWF4aW11bU1lc3NhZ2VTaXplJywgY2RrLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLm1heGltdW1NZXNzYWdlU2l6ZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbWVzc2FnZVJldGVudGlvblBlcmlvZCcsIGNkay52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5tZXNzYWdlUmV0ZW50aW9uUGVyaW9kKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdxdWV1ZU5hbWUnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMucXVldWVOYW1lKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdyZWNlaXZlTWVzc2FnZVdhaXRUaW1lU2Vjb25kcycsIGNkay52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5yZWNlaXZlTWVzc2FnZVdhaXRUaW1lU2Vjb25kcykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncmVkcml2ZUFsbG93UG9saWN5JywgY2RrLnZhbGlkYXRlT2JqZWN0KShwcm9wZXJ0aWVzLnJlZHJpdmVBbGxvd1BvbGljeSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncmVkcml2ZVBvbGljeScsIGNkay52YWxpZGF0ZU9iamVjdCkocHJvcGVydGllcy5yZWRyaXZlUG9saWN5KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzcXNNYW5hZ2VkU3NlRW5hYmxlZCcsIGNkay52YWxpZGF0ZUJvb2xlYW4pKHByb3BlcnRpZXMuc3FzTWFuYWdlZFNzZUVuYWJsZWQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3RhZ3MnLCBjZGsubGlzdFZhbGlkYXRvcihjZGsudmFsaWRhdGVDZm5UYWcpKShwcm9wZXJ0aWVzLnRhZ3MpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3Zpc2liaWxpdHlUaW1lb3V0JywgY2RrLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLnZpc2liaWxpdHlUaW1lb3V0KSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIkNmblF1ZXVlUHJvcHNcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OlNRUzo6UXVldWVgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYENmblF1ZXVlUHJvcHNgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OlNRUzo6UXVldWVgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuUXVldWVQcm9wc1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuUXVldWVQcm9wc1ZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgQ29udGVudEJhc2VkRGVkdXBsaWNhdGlvbjogY2RrLmJvb2xlYW5Ub0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuY29udGVudEJhc2VkRGVkdXBsaWNhdGlvbiksXG4gICAgICAgIERlZHVwbGljYXRpb25TY29wZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5kZWR1cGxpY2F0aW9uU2NvcGUpLFxuICAgICAgICBEZWxheVNlY29uZHM6IGNkay5udW1iZXJUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuZGVsYXlTZWNvbmRzKSxcbiAgICAgICAgRmlmb1F1ZXVlOiBjZGsuYm9vbGVhblRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5maWZvUXVldWUpLFxuICAgICAgICBGaWZvVGhyb3VnaHB1dExpbWl0OiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmZpZm9UaHJvdWdocHV0TGltaXQpLFxuICAgICAgICBLbXNEYXRhS2V5UmV1c2VQZXJpb2RTZWNvbmRzOiBjZGsubnVtYmVyVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmttc0RhdGFLZXlSZXVzZVBlcmlvZFNlY29uZHMpLFxuICAgICAgICBLbXNNYXN0ZXJLZXlJZDogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5rbXNNYXN0ZXJLZXlJZCksXG4gICAgICAgIE1heGltdW1NZXNzYWdlU2l6ZTogY2RrLm51bWJlclRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5tYXhpbXVtTWVzc2FnZVNpemUpLFxuICAgICAgICBNZXNzYWdlUmV0ZW50aW9uUGVyaW9kOiBjZGsubnVtYmVyVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm1lc3NhZ2VSZXRlbnRpb25QZXJpb2QpLFxuICAgICAgICBRdWV1ZU5hbWU6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucXVldWVOYW1lKSxcbiAgICAgICAgUmVjZWl2ZU1lc3NhZ2VXYWl0VGltZVNlY29uZHM6IGNkay5udW1iZXJUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucmVjZWl2ZU1lc3NhZ2VXYWl0VGltZVNlY29uZHMpLFxuICAgICAgICBSZWRyaXZlQWxsb3dQb2xpY3k6IGNkay5vYmplY3RUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucmVkcml2ZUFsbG93UG9saWN5KSxcbiAgICAgICAgUmVkcml2ZVBvbGljeTogY2RrLm9iamVjdFRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5yZWRyaXZlUG9saWN5KSxcbiAgICAgICAgU3FzTWFuYWdlZFNzZUVuYWJsZWQ6IGNkay5ib29sZWFuVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnNxc01hbmFnZWRTc2VFbmFibGVkKSxcbiAgICAgICAgVGFnczogY2RrLmxpc3RNYXBwZXIoY2RrLmNmblRhZ1RvQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMudGFncyksXG4gICAgICAgIFZpc2liaWxpdHlUaW1lb3V0OiBjZGsubnVtYmVyVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnZpc2liaWxpdHlUaW1lb3V0KSxcbiAgICB9O1xufVxuXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuUXVldWVQcm9wc0Zyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmblF1ZXVlUHJvcHM+IHtcbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmblF1ZXVlUHJvcHM+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdjb250ZW50QmFzZWREZWR1cGxpY2F0aW9uJywgJ0NvbnRlbnRCYXNlZERlZHVwbGljYXRpb24nLCBwcm9wZXJ0aWVzLkNvbnRlbnRCYXNlZERlZHVwbGljYXRpb24gIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0Qm9vbGVhbihwcm9wZXJ0aWVzLkNvbnRlbnRCYXNlZERlZHVwbGljYXRpb24pIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2RlZHVwbGljYXRpb25TY29wZScsICdEZWR1cGxpY2F0aW9uU2NvcGUnLCBwcm9wZXJ0aWVzLkRlZHVwbGljYXRpb25TY29wZSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5EZWR1cGxpY2F0aW9uU2NvcGUpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2RlbGF5U2Vjb25kcycsICdEZWxheVNlY29uZHMnLCBwcm9wZXJ0aWVzLkRlbGF5U2Vjb25kcyAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXROdW1iZXIocHJvcGVydGllcy5EZWxheVNlY29uZHMpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2ZpZm9RdWV1ZScsICdGaWZvUXVldWUnLCBwcm9wZXJ0aWVzLkZpZm9RdWV1ZSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRCb29sZWFuKHByb3BlcnRpZXMuRmlmb1F1ZXVlKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdmaWZvVGhyb3VnaHB1dExpbWl0JywgJ0ZpZm9UaHJvdWdocHV0TGltaXQnLCBwcm9wZXJ0aWVzLkZpZm9UaHJvdWdocHV0TGltaXQgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuRmlmb1Rocm91Z2hwdXRMaW1pdCkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgna21zRGF0YUtleVJldXNlUGVyaW9kU2Vjb25kcycsICdLbXNEYXRhS2V5UmV1c2VQZXJpb2RTZWNvbmRzJywgcHJvcGVydGllcy5LbXNEYXRhS2V5UmV1c2VQZXJpb2RTZWNvbmRzICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldE51bWJlcihwcm9wZXJ0aWVzLkttc0RhdGFLZXlSZXVzZVBlcmlvZFNlY29uZHMpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2ttc01hc3RlcktleUlkJywgJ0ttc01hc3RlcktleUlkJywgcHJvcGVydGllcy5LbXNNYXN0ZXJLZXlJZCAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5LbXNNYXN0ZXJLZXlJZCkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbWF4aW11bU1lc3NhZ2VTaXplJywgJ01heGltdW1NZXNzYWdlU2l6ZScsIHByb3BlcnRpZXMuTWF4aW11bU1lc3NhZ2VTaXplICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldE51bWJlcihwcm9wZXJ0aWVzLk1heGltdW1NZXNzYWdlU2l6ZSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbWVzc2FnZVJldGVudGlvblBlcmlvZCcsICdNZXNzYWdlUmV0ZW50aW9uUGVyaW9kJywgcHJvcGVydGllcy5NZXNzYWdlUmV0ZW50aW9uUGVyaW9kICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldE51bWJlcihwcm9wZXJ0aWVzLk1lc3NhZ2VSZXRlbnRpb25QZXJpb2QpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3F1ZXVlTmFtZScsICdRdWV1ZU5hbWUnLCBwcm9wZXJ0aWVzLlF1ZXVlTmFtZSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5RdWV1ZU5hbWUpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3JlY2VpdmVNZXNzYWdlV2FpdFRpbWVTZWNvbmRzJywgJ1JlY2VpdmVNZXNzYWdlV2FpdFRpbWVTZWNvbmRzJywgcHJvcGVydGllcy5SZWNlaXZlTWVzc2FnZVdhaXRUaW1lU2Vjb25kcyAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXROdW1iZXIocHJvcGVydGllcy5SZWNlaXZlTWVzc2FnZVdhaXRUaW1lU2Vjb25kcykgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgncmVkcml2ZUFsbG93UG9saWN5JywgJ1JlZHJpdmVBbGxvd1BvbGljeScsIHByb3BlcnRpZXMuUmVkcml2ZUFsbG93UG9saWN5ICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldEFueShwcm9wZXJ0aWVzLlJlZHJpdmVBbGxvd1BvbGljeSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgncmVkcml2ZVBvbGljeScsICdSZWRyaXZlUG9saWN5JywgcHJvcGVydGllcy5SZWRyaXZlUG9saWN5ICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldEFueShwcm9wZXJ0aWVzLlJlZHJpdmVQb2xpY3kpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3Nxc01hbmFnZWRTc2VFbmFibGVkJywgJ1Nxc01hbmFnZWRTc2VFbmFibGVkJywgcHJvcGVydGllcy5TcXNNYW5hZ2VkU3NlRW5hYmxlZCAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRCb29sZWFuKHByb3BlcnRpZXMuU3FzTWFuYWdlZFNzZUVuYWJsZWQpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3RhZ3MnLCAnVGFncycsIHByb3BlcnRpZXMuVGFncyAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRBcnJheShjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldENmblRhZykocHJvcGVydGllcy5UYWdzKSA6IHVuZGVmaW5lZCBhcyBhbnkpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgndmlzaWJpbGl0eVRpbWVvdXQnLCAnVmlzaWJpbGl0eVRpbWVvdXQnLCBwcm9wZXJ0aWVzLlZpc2liaWxpdHlUaW1lb3V0ICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldE51bWJlcihwcm9wZXJ0aWVzLlZpc2liaWxpdHlUaW1lb3V0KSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG5cbi8qKlxuICogQSBDbG91ZEZvcm1hdGlvbiBgQVdTOjpTUVM6OlF1ZXVlYFxuICpcbiAqIFRoZSBgQVdTOjpTUVM6OlF1ZXVlYCByZXNvdXJjZSBjcmVhdGVzIGFuIEFtYXpvbiBTUVMgc3RhbmRhcmQgb3IgRklGTyBxdWV1ZS5cbiAqXG4gKiBLZWVwIHRoZSBmb2xsb3dpbmcgY2F2ZWF0cyBpbiBtaW5kOlxuICpcbiAqIC0gSWYgeW91IGRvbid0IHNwZWNpZnkgdGhlIGBGaWZvUXVldWVgIHByb3BlcnR5LCBBbWF6b24gU1FTIGNyZWF0ZXMgYSBzdGFuZGFyZCBxdWV1ZS5cbiAqXG4gKiA+IFlvdSBjYW4ndCBjaGFuZ2UgdGhlIHF1ZXVlIHR5cGUgYWZ0ZXIgeW91IGNyZWF0ZSBpdCBhbmQgeW91IGNhbid0IGNvbnZlcnQgYW4gZXhpc3Rpbmcgc3RhbmRhcmQgcXVldWUgaW50byBhIEZJRk8gcXVldWUuIFlvdSBtdXN0IGVpdGhlciBjcmVhdGUgYSBuZXcgRklGTyBxdWV1ZSBmb3IgeW91ciBhcHBsaWNhdGlvbiBvciBkZWxldGUgeW91ciBleGlzdGluZyBzdGFuZGFyZCBxdWV1ZSBhbmQgcmVjcmVhdGUgaXQgYXMgYSBGSUZPIHF1ZXVlLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtNb3ZpbmcgZnJvbSBhIHN0YW5kYXJkIHF1ZXVlIHRvIGEgRklGTyBxdWV1ZV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU1NpbXBsZVF1ZXVlU2VydmljZS9sYXRlc3QvU1FTRGV2ZWxvcGVyR3VpZGUvRklGTy1xdWV1ZXMtbW92aW5nLmh0bWwpIGluIHRoZSAqQW1hem9uIFNRUyBEZXZlbG9wZXIgR3VpZGUqIC5cbiAqIC0gSWYgeW91IGRvbid0IHByb3ZpZGUgYSB2YWx1ZSBmb3IgYSBwcm9wZXJ0eSwgdGhlIHF1ZXVlIGlzIGNyZWF0ZWQgd2l0aCB0aGUgZGVmYXVsdCB2YWx1ZSBmb3IgdGhlIHByb3BlcnR5LlxuICogLSBJZiB5b3UgZGVsZXRlIGEgcXVldWUsIHlvdSBtdXN0IHdhaXQgYXQgbGVhc3QgNjAgc2Vjb25kcyBiZWZvcmUgY3JlYXRpbmcgYSBxdWV1ZSB3aXRoIHRoZSBzYW1lIG5hbWUuXG4gKiAtIFRvIHN1Y2Nlc3NmdWxseSBjcmVhdGUgYSBuZXcgcXVldWUsIHlvdSBtdXN0IHByb3ZpZGUgYSBxdWV1ZSBuYW1lIHRoYXQgYWRoZXJlcyB0byB0aGUgW2xpbWl0cyByZWxhdGVkIHRvIHF1ZXVlc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU1NpbXBsZVF1ZXVlU2VydmljZS9sYXRlc3QvU1FTRGV2ZWxvcGVyR3VpZGUvbGltaXRzLXF1ZXVlcy5odG1sKSBhbmQgaXMgdW5pcXVlIHdpdGhpbiB0aGUgc2NvcGUgb2YgeW91ciBxdWV1ZXMuXG4gKlxuICogRm9yIG1vcmUgaW5mb3JtYXRpb24gYWJvdXQgY3JlYXRpbmcgRklGTyAoZmlyc3QtaW4tZmlyc3Qtb3V0KSBxdWV1ZXMsIHNlZSBbQ3JlYXRpbmcgYW4gQW1hem9uIFNRUyBxdWV1ZSAoIEFXUyBDbG91ZEZvcm1hdGlvbiApXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTU2ltcGxlUXVldWVTZXJ2aWNlL2xhdGVzdC9TUVNEZXZlbG9wZXJHdWlkZS9zY3JlYXRlLXF1ZXVlLWNsb3VkZm9ybWF0aW9uLmh0bWwpIGluIHRoZSAqQW1hem9uIFNRUyBEZXZlbG9wZXIgR3VpZGUqIC5cbiAqXG4gKiBAY2xvdWRmb3JtYXRpb25SZXNvdXJjZSBBV1M6OlNRUzo6UXVldWVcbiAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAqXG4gKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1zcXMtcXVldWUuaHRtbFxuICovXG5leHBvcnQgY2xhc3MgQ2ZuUXVldWUgZXh0ZW5kcyBjZGsuQ2ZuUmVzb3VyY2UgaW1wbGVtZW50cyBjZGsuSUluc3BlY3RhYmxlIHtcbiAgICAvKipcbiAgICAgKiBUaGUgQ2xvdWRGb3JtYXRpb24gcmVzb3VyY2UgdHlwZSBuYW1lIGZvciB0aGlzIHJlc291cmNlIGNsYXNzLlxuICAgICAqL1xuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSA9IFwiQVdTOjpTUVM6OlF1ZXVlXCI7XG5cbiAgICAvKipcbiAgICAgKiBBIGZhY3RvcnkgbWV0aG9kIHRoYXQgY3JlYXRlcyBhIG5ldyBpbnN0YW5jZSBvZiB0aGlzIGNsYXNzIGZyb20gYW4gb2JqZWN0XG4gICAgICogY29udGFpbmluZyB0aGUgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiB0aGlzIHJlc291cmNlLlxuICAgICAqIFVzZWQgaW4gdGhlIEBhd3MtY2RrL2Nsb3VkZm9ybWF0aW9uLWluY2x1ZGUgbW9kdWxlLlxuICAgICAqXG4gICAgICogQGludGVybmFsXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyBfZnJvbUNsb3VkRm9ybWF0aW9uKHNjb3BlOiBjb25zdHJ1Y3RzLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcmVzb3VyY2VBdHRyaWJ1dGVzOiBhbnksIG9wdGlvbnM6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25PcHRpb25zKTogQ2ZuUXVldWUge1xuICAgICAgICByZXNvdXJjZUF0dHJpYnV0ZXMgPSByZXNvdXJjZUF0dHJpYnV0ZXMgfHwge307XG4gICAgICAgIGNvbnN0IHJlc291cmNlUHJvcGVydGllcyA9IG9wdGlvbnMucGFyc2VyLnBhcnNlVmFsdWUocmVzb3VyY2VBdHRyaWJ1dGVzLlByb3BlcnRpZXMpO1xuICAgICAgICBjb25zdCBwcm9wc1Jlc3VsdCA9IENmblF1ZXVlUHJvcHNGcm9tQ2xvdWRGb3JtYXRpb24ocmVzb3VyY2VQcm9wZXJ0aWVzKTtcbiAgICAgICAgY29uc3QgcmV0ID0gbmV3IENmblF1ZXVlKHNjb3BlLCBpZCwgcHJvcHNSZXN1bHQudmFsdWUpO1xuICAgICAgICBmb3IgKGNvbnN0IFtwcm9wS2V5LCBwcm9wVmFsXSBvZiBPYmplY3QuZW50cmllcyhwcm9wc1Jlc3VsdC5leHRyYVByb3BlcnRpZXMpKSAge1xuICAgICAgICAgICAgcmV0LmFkZFByb3BlcnR5T3ZlcnJpZGUocHJvcEtleSwgcHJvcFZhbCk7XG4gICAgICAgIH1cbiAgICAgICAgb3B0aW9ucy5wYXJzZXIuaGFuZGxlQXR0cmlidXRlcyhyZXQsIHJlc291cmNlQXR0cmlidXRlcywgaWQpO1xuICAgICAgICByZXR1cm4gcmV0O1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIFJldHVybnMgdGhlIEFtYXpvbiBSZXNvdXJjZSBOYW1lIChBUk4pIG9mIHRoZSBxdWV1ZS4gRm9yIGV4YW1wbGU6IGBhcm46YXdzOnNxczp1cy1lYXN0LTI6MTIzNDU2Nzg5MDEyOm15c3RhY2stbXlxdWV1ZS0xNVBHNUMyRkMxQ1c4YCAuXG4gICAgICogQGNsb3VkZm9ybWF0aW9uQXR0cmlidXRlIEFyblxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyQXJuOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBSZXR1cm5zIHRoZSBxdWV1ZSBuYW1lLiBGb3IgZXhhbXBsZTogYG15c3RhY2stbXlxdWV1ZS0xVkY5QktRSDVCSlZJYCAuXG4gICAgICogQGNsb3VkZm9ybWF0aW9uQXR0cmlidXRlIFF1ZXVlTmFtZVxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyUXVldWVOYW1lOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBSZXR1cm5zIHRoZSBVUkxzIG9mIHRoZSBxdWV1ZXMgZnJvbSB0aGUgcG9saWN5LlxuICAgICAqIEBjbG91ZGZvcm1hdGlvbkF0dHJpYnV0ZSBRdWV1ZVVybFxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyUXVldWVVcmw6IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIEZvciBmaXJzdC1pbi1maXJzdC1vdXQgKEZJRk8pIHF1ZXVlcywgc3BlY2lmaWVzIHdoZXRoZXIgdG8gZW5hYmxlIGNvbnRlbnQtYmFzZWQgZGVkdXBsaWNhdGlvbi4gRHVyaW5nIHRoZSBkZWR1cGxpY2F0aW9uIGludGVydmFsLCBBbWF6b24gU1FTIHRyZWF0cyBtZXNzYWdlcyB0aGF0IGFyZSBzZW50IHdpdGggaWRlbnRpY2FsIGNvbnRlbnQgYXMgZHVwbGljYXRlcyBhbmQgZGVsaXZlcnMgb25seSBvbmUgY29weSBvZiB0aGUgbWVzc2FnZS4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSB0aGUgYENvbnRlbnRCYXNlZERlZHVwbGljYXRpb25gIGF0dHJpYnV0ZSBmb3IgdGhlIGBbQ3JlYXRlUXVldWVdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NTaW1wbGVRdWV1ZVNlcnZpY2UvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfQ3JlYXRlUXVldWUuaHRtbClgIGFjdGlvbiBpbiB0aGUgKkFtYXpvbiBTUVMgQVBJIFJlZmVyZW5jZSogLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2Utc3FzLXF1ZXVlLmh0bWwjY2ZuLXNxcy1xdWV1ZS1jb250ZW50YmFzZWRkZWR1cGxpY2F0aW9uXG4gICAgICovXG4gICAgcHVibGljIGNvbnRlbnRCYXNlZERlZHVwbGljYXRpb246IGJvb2xlYW4gfCBjZGsuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBGb3IgaGlnaCB0aHJvdWdocHV0IGZvciBGSUZPIHF1ZXVlcywgc3BlY2lmaWVzIHdoZXRoZXIgbWVzc2FnZSBkZWR1cGxpY2F0aW9uIG9jY3VycyBhdCB0aGUgbWVzc2FnZSBncm91cCBvciBxdWV1ZSBsZXZlbC4gVmFsaWQgdmFsdWVzIGFyZSBgbWVzc2FnZUdyb3VwYCBhbmQgYHF1ZXVlYCAuXG4gICAgICpcbiAgICAgKiBUbyBlbmFibGUgaGlnaCB0aHJvdWdocHV0IGZvciBhIEZJRk8gcXVldWUsIHNldCB0aGlzIGF0dHJpYnV0ZSB0byBgbWVzc2FnZUdyb3VwYCAqYW5kKiBzZXQgdGhlIGBGaWZvVGhyb3VnaHB1dExpbWl0YCBhdHRyaWJ1dGUgdG8gYHBlck1lc3NhZ2VHcm91cElkYCAuIElmIHlvdSBzZXQgdGhlc2UgYXR0cmlidXRlcyB0byBhbnl0aGluZyBvdGhlciB0aGFuIHRoZXNlIHZhbHVlcywgbm9ybWFsIHRocm91Z2hwdXQgaXMgaW4gZWZmZWN0IGFuZCBkZWR1cGxpY2F0aW9uIG9jY3VycyBhcyBzcGVjaWZpZWQuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW0hpZ2ggdGhyb3VnaHB1dCBmb3IgRklGTyBxdWV1ZXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NTaW1wbGVRdWV1ZVNlcnZpY2UvbGF0ZXN0L1NRU0RldmVsb3Blckd1aWRlL2hpZ2gtdGhyb3VnaHB1dC1maWZvLmh0bWwpIGFuZCBbUXVvdGFzIHJlbGF0ZWQgdG8gbWVzc2FnZXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NTaW1wbGVRdWV1ZVNlcnZpY2UvbGF0ZXN0L1NRU0RldmVsb3Blckd1aWRlL3F1b3Rhcy1tZXNzYWdlcy5odG1sKSBpbiB0aGUgKkFtYXpvbiBTUVMgRGV2ZWxvcGVyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1zcXMtcXVldWUuaHRtbCNjZm4tc3FzLXF1ZXVlLWRlZHVwbGljYXRpb25zY29wZVxuICAgICAqL1xuICAgIHB1YmxpYyBkZWR1cGxpY2F0aW9uU2NvcGU6IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFRoZSB0aW1lIGluIHNlY29uZHMgZm9yIHdoaWNoIHRoZSBkZWxpdmVyeSBvZiBhbGwgbWVzc2FnZXMgaW4gdGhlIHF1ZXVlIGlzIGRlbGF5ZWQuIFlvdSBjYW4gc3BlY2lmeSBhbiBpbnRlZ2VyIHZhbHVlIG9mIGAwYCB0byBgOTAwYCAoMTUgbWludXRlcykuIFRoZSBkZWZhdWx0IHZhbHVlIGlzIGAwYCAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1zcXMtcXVldWUuaHRtbCNjZm4tc3FzLXF1ZXVlLWRlbGF5c2Vjb25kc1xuICAgICAqL1xuICAgIHB1YmxpYyBkZWxheVNlY29uZHM6IG51bWJlciB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIElmIHNldCB0byB0cnVlLCBjcmVhdGVzIGEgRklGTyBxdWV1ZS4gSWYgeW91IGRvbid0IHNwZWNpZnkgdGhpcyBwcm9wZXJ0eSwgQW1hem9uIFNRUyBjcmVhdGVzIGEgc3RhbmRhcmQgcXVldWUuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW0ZJRk8gcXVldWVzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTU2ltcGxlUXVldWVTZXJ2aWNlL2xhdGVzdC9TUVNEZXZlbG9wZXJHdWlkZS9GSUZPLXF1ZXVlcy5odG1sKSBpbiB0aGUgKkFtYXpvbiBTUVMgRGV2ZWxvcGVyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1zcXMtcXVldWUuaHRtbCNjZm4tc3FzLXF1ZXVlLWZpZm9xdWV1ZVxuICAgICAqL1xuICAgIHB1YmxpYyBmaWZvUXVldWU6IGJvb2xlYW4gfCBjZGsuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBGb3IgaGlnaCB0aHJvdWdocHV0IGZvciBGSUZPIHF1ZXVlcywgc3BlY2lmaWVzIHdoZXRoZXIgdGhlIEZJRk8gcXVldWUgdGhyb3VnaHB1dCBxdW90YSBhcHBsaWVzIHRvIHRoZSBlbnRpcmUgcXVldWUgb3IgcGVyIG1lc3NhZ2UgZ3JvdXAuIFZhbGlkIHZhbHVlcyBhcmUgYHBlclF1ZXVlYCBhbmQgYHBlck1lc3NhZ2VHcm91cElkYCAuXG4gICAgICpcbiAgICAgKiBUbyBlbmFibGUgaGlnaCB0aHJvdWdocHV0IGZvciBhIEZJRk8gcXVldWUsIHNldCB0aGlzIGF0dHJpYnV0ZSB0byBgcGVyTWVzc2FnZUdyb3VwSWRgICphbmQqIHNldCB0aGUgYERlZHVwbGljYXRpb25TY29wZWAgYXR0cmlidXRlIHRvIGBtZXNzYWdlR3JvdXBgIC4gSWYgeW91IHNldCB0aGVzZSBhdHRyaWJ1dGVzIHRvIGFueXRoaW5nIG90aGVyIHRoYW4gdGhlc2UgdmFsdWVzLCBub3JtYWwgdGhyb3VnaHB1dCBpcyBpbiBlZmZlY3QgYW5kIGRlZHVwbGljYXRpb24gb2NjdXJzIGFzIHNwZWNpZmllZC4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbSGlnaCB0aHJvdWdocHV0IGZvciBGSUZPIHF1ZXVlc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU1NpbXBsZVF1ZXVlU2VydmljZS9sYXRlc3QvU1FTRGV2ZWxvcGVyR3VpZGUvaGlnaC10aHJvdWdocHV0LWZpZm8uaHRtbCkgYW5kIFtRdW90YXMgcmVsYXRlZCB0byBtZXNzYWdlc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU1NpbXBsZVF1ZXVlU2VydmljZS9sYXRlc3QvU1FTRGV2ZWxvcGVyR3VpZGUvcXVvdGFzLW1lc3NhZ2VzLmh0bWwpIGluIHRoZSAqQW1hem9uIFNRUyBEZXZlbG9wZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLXNxcy1xdWV1ZS5odG1sI2Nmbi1zcXMtcXVldWUtZmlmb3Rocm91Z2hwdXRsaW1pdFxuICAgICAqL1xuICAgIHB1YmxpYyBmaWZvVGhyb3VnaHB1dExpbWl0OiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbGVuZ3RoIG9mIHRpbWUgaW4gc2Vjb25kcyBmb3Igd2hpY2ggQW1hem9uIFNRUyBjYW4gcmV1c2UgYSBkYXRhIGtleSB0byBlbmNyeXB0IG9yIGRlY3J5cHQgbWVzc2FnZXMgYmVmb3JlIGNhbGxpbmcgQVdTIEtNUyBhZ2Fpbi4gVGhlIHZhbHVlIG11c3QgYmUgYW4gaW50ZWdlciBiZXR3ZWVuIDYwICgxIG1pbnV0ZSkgYW5kIDg2LDQwMCAoMjQgaG91cnMpLiBUaGUgZGVmYXVsdCBpcyAzMDAgKDUgbWludXRlcykuXG4gICAgICpcbiAgICAgKiA+IEEgc2hvcnRlciB0aW1lIHBlcmlvZCBwcm92aWRlcyBiZXR0ZXIgc2VjdXJpdHksIGJ1dCByZXN1bHRzIGluIG1vcmUgY2FsbHMgdG8gQVdTIEtNUyAsIHdoaWNoIG1pZ2h0IGluY3VyIGNoYXJnZXMgYWZ0ZXIgRnJlZSBUaWVyLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtFbmNyeXB0aW9uIGF0IHJlc3RdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NTaW1wbGVRdWV1ZVNlcnZpY2UvbGF0ZXN0L1NRU0RldmVsb3Blckd1aWRlL3Nxcy1zZXJ2ZXItc2lkZS1lbmNyeXB0aW9uLmh0bWwjc3FzLWhvdy1kb2VzLXRoZS1kYXRhLWtleS1yZXVzZS1wZXJpb2Qtd29yaykgaW4gdGhlICpBbWF6b24gU1FTIERldmVsb3BlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2Utc3FzLXF1ZXVlLmh0bWwjY2ZuLXNxcy1xdWV1ZS1rbXNkYXRha2V5cmV1c2VwZXJpb2RzZWNvbmRzXG4gICAgICovXG4gICAgcHVibGljIGttc0RhdGFLZXlSZXVzZVBlcmlvZFNlY29uZHM6IG51bWJlciB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFRoZSBJRCBvZiBhbiBBV1MgS2V5IE1hbmFnZW1lbnQgU2VydmljZSAoS01TKSBmb3IgQW1hem9uIFNRUyAsIG9yIGEgY3VzdG9tIEtNUy4gVG8gdXNlIHRoZSBBV1MgbWFuYWdlZCBLTVMgZm9yIEFtYXpvbiBTUVMgLCBzcGVjaWZ5IGEgKGRlZmF1bHQpIGFsaWFzIEFSTiwgYWxpYXMgbmFtZSAoZS5nLiBgYWxpYXMvYXdzL3Nxc2AgKSwga2V5IEFSTiwgb3Iga2V5IElELiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIHRoZSBmb2xsb3dpbmc6XG4gICAgICpcbiAgICAgKiAtIFtFbmNyeXB0aW9uIGF0IHJlc3RdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NTaW1wbGVRdWV1ZVNlcnZpY2UvbGF0ZXN0L1NRU0RldmVsb3Blckd1aWRlL3Nxcy1zZXJ2ZXItc2lkZS1lbmNyeXB0aW9uLmh0bWwpIGluIHRoZSAqQW1hem9uIFNRUyBEZXZlbG9wZXIgR3VpZGUqXG4gICAgICogLSBbQ3JlYXRlUXVldWVdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NTaW1wbGVRdWV1ZVNlcnZpY2UvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfQ3JlYXRlUXVldWUuaHRtbCkgaW4gdGhlICpBbWF6b24gU1FTIEFQSSBSZWZlcmVuY2UqXG4gICAgICogLSBbUmVxdWVzdCBQYXJhbWV0ZXJzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0Rlc2NyaWJlS2V5Lmh0bWwjQVBJX0Rlc2NyaWJlS2V5X1JlcXVlc3RQYXJhbWV0ZXJzKSBpbiB0aGUgKkFXUyBLZXkgTWFuYWdlbWVudCBTZXJ2aWNlIEFQSSBSZWZlcmVuY2UqXG4gICAgICogLSBUaGUgS2V5IE1hbmFnZW1lbnQgU2VydmljZSAoS01TKSBzZWN0aW9uIG9mIHRoZSBbQVdTIEtleSBNYW5hZ2VtZW50IFNlcnZpY2UgQmVzdCBQcmFjdGljZXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9odHRwczovL2QwLmF3c3N0YXRpYy5jb20vd2hpdGVwYXBlcnMvYXdzLWttcy1iZXN0LXByYWN0aWNlcy5wZGYpIHdoaXRlcGFwZXJcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLXNxcy1xdWV1ZS5odG1sI2Nmbi1zcXMtcXVldWUta21zbWFzdGVya2V5aWRcbiAgICAgKi9cbiAgICBwdWJsaWMga21zTWFzdGVyS2V5SWQ6IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFRoZSBsaW1pdCBvZiBob3cgbWFueSBieXRlcyB0aGF0IGEgbWVzc2FnZSBjYW4gY29udGFpbiBiZWZvcmUgQW1hem9uIFNRUyByZWplY3RzIGl0LiBZb3UgY2FuIHNwZWNpZnkgYW4gaW50ZWdlciB2YWx1ZSBmcm9tIGAxLDAyNGAgYnl0ZXMgKDEgS2lCKSB0byBgMjYyLDE0NGAgYnl0ZXMgKDI1NiBLaUIpLiBUaGUgZGVmYXVsdCB2YWx1ZSBpcyBgMjYyLDE0NGAgKDI1NiBLaUIpLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2Utc3FzLXF1ZXVlLmh0bWwjY2ZuLXNxcy1xdWV1ZS1tYXhpbXVtbWVzc2FnZXNpemVcbiAgICAgKi9cbiAgICBwdWJsaWMgbWF4aW11bU1lc3NhZ2VTaXplOiBudW1iZXIgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbnVtYmVyIG9mIHNlY29uZHMgdGhhdCBBbWF6b24gU1FTIHJldGFpbnMgYSBtZXNzYWdlLiBZb3UgY2FuIHNwZWNpZnkgYW4gaW50ZWdlciB2YWx1ZSBmcm9tIGA2MGAgc2Vjb25kcyAoMSBtaW51dGUpIHRvIGAxLDIwOSw2MDBgIHNlY29uZHMgKDE0IGRheXMpLiBUaGUgZGVmYXVsdCB2YWx1ZSBpcyBgMzQ1LDYwMGAgc2Vjb25kcyAoNCBkYXlzKS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLXNxcy1xdWV1ZS5odG1sI2Nmbi1zcXMtcXVldWUtbWVzc2FnZXJldGVudGlvbnBlcmlvZFxuICAgICAqL1xuICAgIHB1YmxpYyBtZXNzYWdlUmV0ZW50aW9uUGVyaW9kOiBudW1iZXIgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBBIG5hbWUgZm9yIHRoZSBxdWV1ZS4gVG8gY3JlYXRlIGEgRklGTyBxdWV1ZSwgdGhlIG5hbWUgb2YgeW91ciBGSUZPIHF1ZXVlIG11c3QgZW5kIHdpdGggdGhlIGAuZmlmb2Agc3VmZml4LiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtGSUZPIHF1ZXVlc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU1NpbXBsZVF1ZXVlU2VydmljZS9sYXRlc3QvU1FTRGV2ZWxvcGVyR3VpZGUvRklGTy1xdWV1ZXMuaHRtbCkgaW4gdGhlICpBbWF6b24gU1FTIERldmVsb3BlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogSWYgeW91IGRvbid0IHNwZWNpZnkgYSBuYW1lLCBBV1MgQ2xvdWRGb3JtYXRpb24gZ2VuZXJhdGVzIGEgdW5pcXVlIHBoeXNpY2FsIElEIGFuZCB1c2VzIHRoYXQgSUQgZm9yIHRoZSBxdWV1ZSBuYW1lLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtOYW1lIHR5cGVdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLW5hbWUuaHRtbCkgaW4gdGhlICpBV1MgQ2xvdWRGb3JtYXRpb24gVXNlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogPiBJZiB5b3Ugc3BlY2lmeSBhIG5hbWUsIHlvdSBjYW4ndCBwZXJmb3JtIHVwZGF0ZXMgdGhhdCByZXF1aXJlIHJlcGxhY2VtZW50IG9mIHRoaXMgcmVzb3VyY2UuIFlvdSBjYW4gcGVyZm9ybSB1cGRhdGVzIHRoYXQgcmVxdWlyZSBubyBvciBzb21lIGludGVycnVwdGlvbi4gSWYgeW91IG11c3QgcmVwbGFjZSB0aGUgcmVzb3VyY2UsIHNwZWNpZnkgYSBuZXcgbmFtZS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLXNxcy1xdWV1ZS5odG1sI2Nmbi1zcXMtcXVldWUtcXVldWVuYW1lXG4gICAgICovXG4gICAgcHVibGljIHF1ZXVlTmFtZTogc3RyaW5nIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogU3BlY2lmaWVzIHRoZSBkdXJhdGlvbiwgaW4gc2Vjb25kcywgdGhhdCB0aGUgUmVjZWl2ZU1lc3NhZ2UgYWN0aW9uIGNhbGwgd2FpdHMgdW50aWwgYSBtZXNzYWdlIGlzIGluIHRoZSBxdWV1ZSBpbiBvcmRlciB0byBpbmNsdWRlIGl0IGluIHRoZSByZXNwb25zZSwgcmF0aGVyIHRoYW4gcmV0dXJuaW5nIGFuIGVtcHR5IHJlc3BvbnNlIGlmIGEgbWVzc2FnZSBpc24ndCB5ZXQgYXZhaWxhYmxlLiBZb3UgY2FuIHNwZWNpZnkgYW4gaW50ZWdlciBmcm9tIDEgdG8gMjAuIFNob3J0IHBvbGxpbmcgaXMgdXNlZCBhcyB0aGUgZGVmYXVsdCBvciB3aGVuIHlvdSBzcGVjaWZ5IDAgZm9yIHRoaXMgcHJvcGVydHkuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW0NvbnN1bWluZyBtZXNzYWdlcyB1c2luZyBsb25nIHBvbGxpbmddKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NTaW1wbGVRdWV1ZVNlcnZpY2UvbGF0ZXN0L1NRU0RldmVsb3Blckd1aWRlL3Nxcy1zaG9ydC1hbmQtbG9uZy1wb2xsaW5nLmh0bWwjc3FzLWxvbmctcG9sbGluZykgaW4gdGhlICpBbWF6b24gU1FTIERldmVsb3BlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2Utc3FzLXF1ZXVlLmh0bWwjY2ZuLXNxcy1xdWV1ZS1yZWNlaXZlbWVzc2FnZXdhaXR0aW1lc2Vjb25kc1xuICAgICAqL1xuICAgIHB1YmxpYyByZWNlaXZlTWVzc2FnZVdhaXRUaW1lU2Vjb25kczogbnVtYmVyIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogVGhlIHN0cmluZyB0aGF0IGluY2x1ZGVzIHRoZSBwYXJhbWV0ZXJzIGZvciB0aGUgcGVybWlzc2lvbnMgZm9yIHRoZSBkZWFkLWxldHRlciBxdWV1ZSByZWRyaXZlIHBlcm1pc3Npb24gYW5kIHdoaWNoIHNvdXJjZSBxdWV1ZXMgY2FuIHNwZWNpZnkgZGVhZC1sZXR0ZXIgcXVldWVzIGFzIGEgSlNPTiBvYmplY3QuIFRoZSBwYXJhbWV0ZXJzIGFyZSBhcyBmb2xsb3dzOlxuICAgICAqXG4gICAgICogLSBgcmVkcml2ZVBlcm1pc3Npb25gIDogVGhlIHBlcm1pc3Npb24gdHlwZSB0aGF0IGRlZmluZXMgd2hpY2ggc291cmNlIHF1ZXVlcyBjYW4gc3BlY2lmeSB0aGUgY3VycmVudCBxdWV1ZSBhcyB0aGUgZGVhZC1sZXR0ZXIgcXVldWUuIFZhbGlkIHZhbHVlcyBhcmU6XG4gICAgICpcbiAgICAgKiAtIGBhbGxvd0FsbGAgOiAoRGVmYXVsdCkgQW55IHNvdXJjZSBxdWV1ZXMgaW4gdGhpcyBBV1MgYWNjb3VudCBpbiB0aGUgc2FtZSBSZWdpb24gY2FuIHNwZWNpZnkgdGhpcyBxdWV1ZSBhcyB0aGUgZGVhZC1sZXR0ZXIgcXVldWUuXG4gICAgICogLSBgZGVueUFsbGAgOiBObyBzb3VyY2UgcXVldWVzIGNhbiBzcGVjaWZ5IHRoaXMgcXVldWUgYXMgdGhlIGRlYWQtbGV0dGVyIHF1ZXVlLlxuICAgICAqIC0gYGJ5UXVldWVgIDogT25seSBxdWV1ZXMgc3BlY2lmaWVkIGJ5IHRoZSBgc291cmNlUXVldWVBcm5zYCBwYXJhbWV0ZXIgY2FuIHNwZWNpZnkgdGhpcyBxdWV1ZSBhcyB0aGUgZGVhZC1sZXR0ZXIgcXVldWUuXG4gICAgICogLSBgc291cmNlUXVldWVBcm5zYCA6IFRoZSBBbWF6b24gUmVzb3VyY2UgTmFtZXMgKEFSTilzIG9mIHRoZSBzb3VyY2UgcXVldWVzIHRoYXQgY2FuIHNwZWNpZnkgdGhpcyBxdWV1ZSBhcyB0aGUgZGVhZC1sZXR0ZXIgcXVldWUgYW5kIHJlZHJpdmUgbWVzc2FnZXMuIFlvdSBjYW4gc3BlY2lmeSB0aGlzIHBhcmFtZXRlciBvbmx5IHdoZW4gdGhlIGByZWRyaXZlUGVybWlzc2lvbmAgcGFyYW1ldGVyIGlzIHNldCB0byBgYnlRdWV1ZWAgLiBZb3UgY2FuIHNwZWNpZnkgdXAgdG8gMTAgc291cmNlIHF1ZXVlIEFSTnMuIFRvIGFsbG93IG1vcmUgdGhhbiAxMCBzb3VyY2UgcXVldWVzIHRvIHNwZWNpZnkgZGVhZC1sZXR0ZXIgcXVldWVzLCBzZXQgdGhlIGByZWRyaXZlUGVybWlzc2lvbmAgcGFyYW1ldGVyIHRvIGBhbGxvd0FsbGAgLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2Utc3FzLXF1ZXVlLmh0bWwjY2ZuLXNxcy1xdWV1ZS1yZWRyaXZlYWxsb3dwb2xpY3lcbiAgICAgKi9cbiAgICBwdWJsaWMgcmVkcml2ZUFsbG93UG9saWN5OiBhbnkgfCBjZGsuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgc3RyaW5nIHRoYXQgaW5jbHVkZXMgdGhlIHBhcmFtZXRlcnMgZm9yIHRoZSBkZWFkLWxldHRlciBxdWV1ZSBmdW5jdGlvbmFsaXR5IG9mIHRoZSBzb3VyY2UgcXVldWUgYXMgYSBKU09OIG9iamVjdC4gVGhlIHBhcmFtZXRlcnMgYXJlIGFzIGZvbGxvd3M6XG4gICAgICpcbiAgICAgKiAtIGBkZWFkTGV0dGVyVGFyZ2V0QXJuYCA6IFRoZSBBbWF6b24gUmVzb3VyY2UgTmFtZSAoQVJOKSBvZiB0aGUgZGVhZC1sZXR0ZXIgcXVldWUgdG8gd2hpY2ggQW1hem9uIFNRUyBtb3ZlcyBtZXNzYWdlcyBhZnRlciB0aGUgdmFsdWUgb2YgYG1heFJlY2VpdmVDb3VudGAgaXMgZXhjZWVkZWQuXG4gICAgICogLSBgbWF4UmVjZWl2ZUNvdW50YCA6IFRoZSBudW1iZXIgb2YgdGltZXMgYSBtZXNzYWdlIGlzIGRlbGl2ZXJlZCB0byB0aGUgc291cmNlIHF1ZXVlIGJlZm9yZSBiZWluZyBtb3ZlZCB0byB0aGUgZGVhZC1sZXR0ZXIgcXVldWUuIFdoZW4gdGhlIGBSZWNlaXZlQ291bnRgIGZvciBhIG1lc3NhZ2UgZXhjZWVkcyB0aGUgYG1heFJlY2VpdmVDb3VudGAgZm9yIGEgcXVldWUsIEFtYXpvbiBTUVMgbW92ZXMgdGhlIG1lc3NhZ2UgdG8gdGhlIGRlYWQtbGV0dGVyLXF1ZXVlLlxuICAgICAqXG4gICAgICogPiBUaGUgZGVhZC1sZXR0ZXIgcXVldWUgb2YgYSBGSUZPIHF1ZXVlIG11c3QgYWxzbyBiZSBhIEZJRk8gcXVldWUuIFNpbWlsYXJseSwgdGhlIGRlYWQtbGV0dGVyIHF1ZXVlIG9mIGEgc3RhbmRhcmQgcXVldWUgbXVzdCBhbHNvIGJlIGEgc3RhbmRhcmQgcXVldWUuXG4gICAgICpcbiAgICAgKiAqSlNPTipcbiAgICAgKlxuICAgICAqIGB7IFwiZGVhZExldHRlclRhcmdldEFyblwiIDogKlN0cmluZyogLCBcIm1heFJlY2VpdmVDb3VudFwiIDogKkludGVnZXIqIH1gXG4gICAgICpcbiAgICAgKiAqWUFNTCpcbiAgICAgKlxuICAgICAqIGBkZWFkTGV0dGVyVGFyZ2V0QXJuIDogKlN0cmluZypgXG4gICAgICpcbiAgICAgKiBgbWF4UmVjZWl2ZUNvdW50IDogKkludGVnZXIqYFxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2Utc3FzLXF1ZXVlLmh0bWwjY2ZuLXNxcy1xdWV1ZS1yZWRyaXZlcG9saWN5XG4gICAgICovXG4gICAgcHVibGljIHJlZHJpdmVQb2xpY3k6IGFueSB8IGNkay5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEVuYWJsZXMgc2VydmVyLXNpZGUgcXVldWUgZW5jcnlwdGlvbiB1c2luZyBTUVMgb3duZWQgZW5jcnlwdGlvbiBrZXlzLiBPbmx5IG9uZSBzZXJ2ZXItc2lkZSBlbmNyeXB0aW9uIG9wdGlvbiBpcyBzdXBwb3J0ZWQgcGVyIHF1ZXVlIChmb3IgZXhhbXBsZSwgW1NTRS1LTVNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NTaW1wbGVRdWV1ZVNlcnZpY2UvbGF0ZXN0L1NRU0RldmVsb3Blckd1aWRlL3Nxcy1jb25maWd1cmUtc3NlLWV4aXN0aW5nLXF1ZXVlLmh0bWwpIG9yIFtTU0UtU1FTXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTU2ltcGxlUXVldWVTZXJ2aWNlL2xhdGVzdC9TUVNEZXZlbG9wZXJHdWlkZS9zcXMtY29uZmlndXJlLXNxcy1zc2UtcXVldWUuaHRtbCkgKS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLXNxcy1xdWV1ZS5odG1sI2Nmbi1zcXMtcXVldWUtc3FzbWFuYWdlZHNzZWVuYWJsZWRcbiAgICAgKi9cbiAgICBwdWJsaWMgc3FzTWFuYWdlZFNzZUVuYWJsZWQ6IGJvb2xlYW4gfCBjZGsuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgdGFncyB0aGF0IHlvdSBhdHRhY2ggdG8gdGhpcyBxdWV1ZS4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbUmVzb3VyY2UgdGFnXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1yZXNvdXJjZS10YWdzLmh0bWwpIGluIHRoZSAqQVdTIENsb3VkRm9ybWF0aW9uIFVzZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLXNxcy1xdWV1ZS5odG1sI2Nmbi1zcXMtcXVldWUtdGFnc1xuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSB0YWdzOiBjZGsuVGFnTWFuYWdlcjtcblxuICAgIC8qKlxuICAgICAqIFRoZSBsZW5ndGggb2YgdGltZSBkdXJpbmcgd2hpY2ggYSBtZXNzYWdlIHdpbGwgYmUgdW5hdmFpbGFibGUgYWZ0ZXIgYSBtZXNzYWdlIGlzIGRlbGl2ZXJlZCBmcm9tIHRoZSBxdWV1ZS4gVGhpcyBibG9ja3Mgb3RoZXIgY29tcG9uZW50cyBmcm9tIHJlY2VpdmluZyB0aGUgc2FtZSBtZXNzYWdlIGFuZCBnaXZlcyB0aGUgaW5pdGlhbCBjb21wb25lbnQgdGltZSB0byBwcm9jZXNzIGFuZCBkZWxldGUgdGhlIG1lc3NhZ2UgZnJvbSB0aGUgcXVldWUuXG4gICAgICpcbiAgICAgKiBWYWx1ZXMgbXVzdCBiZSBmcm9tIDAgdG8gNDMsMjAwIHNlY29uZHMgKDEyIGhvdXJzKS4gSWYgeW91IGRvbid0IHNwZWNpZnkgYSB2YWx1ZSwgQVdTIENsb3VkRm9ybWF0aW9uIHVzZXMgdGhlIGRlZmF1bHQgdmFsdWUgb2YgMzAgc2Vjb25kcy5cbiAgICAgKlxuICAgICAqIEZvciBtb3JlIGluZm9ybWF0aW9uIGFib3V0IEFtYXpvbiBTUVMgcXVldWUgdmlzaWJpbGl0eSB0aW1lb3V0cywgc2VlIFtWaXNpYmlsaXR5IHRpbWVvdXRdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NTaW1wbGVRdWV1ZVNlcnZpY2UvbGF0ZXN0L1NRU0RldmVsb3Blckd1aWRlL3Nxcy12aXNpYmlsaXR5LXRpbWVvdXQuaHRtbCkgaW4gdGhlICpBbWF6b24gU1FTIERldmVsb3BlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2Utc3FzLXF1ZXVlLmh0bWwjY2ZuLXNxcy1xdWV1ZS12aXNpYmlsaXR5dGltZW91dFxuICAgICAqL1xuICAgIHB1YmxpYyB2aXNpYmlsaXR5VGltZW91dDogbnVtYmVyIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQ3JlYXRlIGEgbmV3IGBBV1M6OlNRUzo6UXVldWVgLlxuICAgICAqXG4gICAgICogQHBhcmFtIHNjb3BlIC0gc2NvcGUgaW4gd2hpY2ggdGhpcyByZXNvdXJjZSBpcyBkZWZpbmVkXG4gICAgICogQHBhcmFtIGlkICAgIC0gc2NvcGVkIGlkIG9mIHRoZSByZXNvdXJjZVxuICAgICAqIEBwYXJhbSBwcm9wcyAtIHJlc291cmNlIHByb3BlcnRpZXNcbiAgICAgKi9cbiAgICBjb25zdHJ1Y3RvcihzY29wZTogY29uc3RydWN0cy5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBDZm5RdWV1ZVByb3BzID0ge30pIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkLCB7IHR5cGU6IENmblF1ZXVlLkNGTl9SRVNPVVJDRV9UWVBFX05BTUUsIHByb3BlcnRpZXM6IHByb3BzIH0pO1xuICAgICAgICB0aGlzLmF0dHJBcm4gPSBjZGsuVG9rZW4uYXNTdHJpbmcodGhpcy5nZXRBdHQoJ0FybicsIGNkay5SZXNvbHV0aW9uVHlwZUhpbnQuU1RSSU5HKSk7XG4gICAgICAgIHRoaXMuYXR0clF1ZXVlTmFtZSA9IGNkay5Ub2tlbi5hc1N0cmluZyh0aGlzLmdldEF0dCgnUXVldWVOYW1lJywgY2RrLlJlc29sdXRpb25UeXBlSGludC5TVFJJTkcpKTtcbiAgICAgICAgdGhpcy5hdHRyUXVldWVVcmwgPSBjZGsuVG9rZW4uYXNTdHJpbmcodGhpcy5nZXRBdHQoJ1F1ZXVlVXJsJywgY2RrLlJlc29sdXRpb25UeXBlSGludC5TVFJJTkcpKTtcblxuICAgICAgICB0aGlzLmNvbnRlbnRCYXNlZERlZHVwbGljYXRpb24gPSBwcm9wcy5jb250ZW50QmFzZWREZWR1cGxpY2F0aW9uO1xuICAgICAgICB0aGlzLmRlZHVwbGljYXRpb25TY29wZSA9IHByb3BzLmRlZHVwbGljYXRpb25TY29wZTtcbiAgICAgICAgdGhpcy5kZWxheVNlY29uZHMgPSBwcm9wcy5kZWxheVNlY29uZHM7XG4gICAgICAgIHRoaXMuZmlmb1F1ZXVlID0gcHJvcHMuZmlmb1F1ZXVlO1xuICAgICAgICB0aGlzLmZpZm9UaHJvdWdocHV0TGltaXQgPSBwcm9wcy5maWZvVGhyb3VnaHB1dExpbWl0O1xuICAgICAgICB0aGlzLmttc0RhdGFLZXlSZXVzZVBlcmlvZFNlY29uZHMgPSBwcm9wcy5rbXNEYXRhS2V5UmV1c2VQZXJpb2RTZWNvbmRzO1xuICAgICAgICB0aGlzLmttc01hc3RlcktleUlkID0gcHJvcHMua21zTWFzdGVyS2V5SWQ7XG4gICAgICAgIHRoaXMubWF4aW11bU1lc3NhZ2VTaXplID0gcHJvcHMubWF4aW11bU1lc3NhZ2VTaXplO1xuICAgICAgICB0aGlzLm1lc3NhZ2VSZXRlbnRpb25QZXJpb2QgPSBwcm9wcy5tZXNzYWdlUmV0ZW50aW9uUGVyaW9kO1xuICAgICAgICB0aGlzLnF1ZXVlTmFtZSA9IHByb3BzLnF1ZXVlTmFtZTtcbiAgICAgICAgdGhpcy5yZWNlaXZlTWVzc2FnZVdhaXRUaW1lU2Vjb25kcyA9IHByb3BzLnJlY2VpdmVNZXNzYWdlV2FpdFRpbWVTZWNvbmRzO1xuICAgICAgICB0aGlzLnJlZHJpdmVBbGxvd1BvbGljeSA9IHByb3BzLnJlZHJpdmVBbGxvd1BvbGljeTtcbiAgICAgICAgdGhpcy5yZWRyaXZlUG9saWN5ID0gcHJvcHMucmVkcml2ZVBvbGljeTtcbiAgICAgICAgdGhpcy5zcXNNYW5hZ2VkU3NlRW5hYmxlZCA9IHByb3BzLnNxc01hbmFnZWRTc2VFbmFibGVkO1xuICAgICAgICB0aGlzLnRhZ3MgPSBuZXcgY2RrLlRhZ01hbmFnZXIoY2RrLlRhZ1R5cGUuU1RBTkRBUkQsIFwiQVdTOjpTUVM6OlF1ZXVlXCIsIHByb3BzLnRhZ3MsIHsgdGFnUHJvcGVydHlOYW1lOiAndGFncycgfSk7XG4gICAgICAgIHRoaXMudmlzaWJpbGl0eVRpbWVvdXQgPSBwcm9wcy52aXNpYmlsaXR5VGltZW91dDtcbiAgICAgICAgaWYgKHRoaXMubm9kZS5zY29wZSAmJiBjZGsuUmVzb3VyY2UuaXNSZXNvdXJjZSh0aGlzLm5vZGUuc2NvcGUpKSB7XG4gICAgICAgICAgICB0aGlzLm5vZGUuYWRkVmFsaWRhdGlvbih7IHZhbGlkYXRlOiAoKSA9PiB0aGlzLmNmbk9wdGlvbnMuZGVsZXRpb25Qb2xpY3kgPT09IHVuZGVmaW5lZFxuICAgICAgICAgICAgICA/IFsnXFwnQVdTOjpTUVM6OlF1ZXVlXFwnIGlzIGEgc3RhdGVmdWwgcmVzb3VyY2UgdHlwZSwgYW5kIHlvdSBtdXN0IHNwZWNpZnkgYSBSZW1vdmFsIFBvbGljeSBmb3IgaXQuIENhbGwgXFwncmVzb3VyY2UuYXBwbHlSZW1vdmFsUG9saWN5KClcXCcuJ11cbiAgICAgICAgICAgICAgOiBbXSB9KTtcbiAgICAgICAgfVxuICAgIH1cblxuICAgIC8qKlxuICAgICAqIEV4YW1pbmVzIHRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSBhbmQgZGlzY2xvc2VzIGF0dHJpYnV0ZXMuXG4gICAgICpcbiAgICAgKiBAcGFyYW0gaW5zcGVjdG9yIC0gdHJlZSBpbnNwZWN0b3IgdG8gY29sbGVjdCBhbmQgcHJvY2VzcyBhdHRyaWJ1dGVzXG4gICAgICpcbiAgICAgKi9cbiAgICBwdWJsaWMgaW5zcGVjdChpbnNwZWN0b3I6IGNkay5UcmVlSW5zcGVjdG9yKSB7XG4gICAgICAgIGluc3BlY3Rvci5hZGRBdHRyaWJ1dGUoXCJhd3M6Y2RrOmNsb3VkZm9ybWF0aW9uOnR5cGVcIiwgQ2ZuUXVldWUuQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSk7XG4gICAgICAgIGluc3BlY3Rvci5hZGRBdHRyaWJ1dGUoXCJhd3M6Y2RrOmNsb3VkZm9ybWF0aW9uOnByb3BzXCIsIHRoaXMuY2ZuUHJvcGVydGllcyk7XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIG92ZXJyaWRlIGdldCBjZm5Qcm9wZXJ0aWVzKCk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIGNvbnRlbnRCYXNlZERlZHVwbGljYXRpb246IHRoaXMuY29udGVudEJhc2VkRGVkdXBsaWNhdGlvbixcbiAgICAgICAgICAgIGRlZHVwbGljYXRpb25TY29wZTogdGhpcy5kZWR1cGxpY2F0aW9uU2NvcGUsXG4gICAgICAgICAgICBkZWxheVNlY29uZHM6IHRoaXMuZGVsYXlTZWNvbmRzLFxuICAgICAgICAgICAgZmlmb1F1ZXVlOiB0aGlzLmZpZm9RdWV1ZSxcbiAgICAgICAgICAgIGZpZm9UaHJvdWdocHV0TGltaXQ6IHRoaXMuZmlmb1Rocm91Z2hwdXRMaW1pdCxcbiAgICAgICAgICAgIGttc0RhdGFLZXlSZXVzZVBlcmlvZFNlY29uZHM6IHRoaXMua21zRGF0YUtleVJldXNlUGVyaW9kU2Vjb25kcyxcbiAgICAgICAgICAgIGttc01hc3RlcktleUlkOiB0aGlzLmttc01hc3RlcktleUlkLFxuICAgICAgICAgICAgbWF4aW11bU1lc3NhZ2VTaXplOiB0aGlzLm1heGltdW1NZXNzYWdlU2l6ZSxcbiAgICAgICAgICAgIG1lc3NhZ2VSZXRlbnRpb25QZXJpb2Q6IHRoaXMubWVzc2FnZVJldGVudGlvblBlcmlvZCxcbiAgICAgICAgICAgIHF1ZXVlTmFtZTogdGhpcy5xdWV1ZU5hbWUsXG4gICAgICAgICAgICByZWNlaXZlTWVzc2FnZVdhaXRUaW1lU2Vjb25kczogdGhpcy5yZWNlaXZlTWVzc2FnZVdhaXRUaW1lU2Vjb25kcyxcbiAgICAgICAgICAgIHJlZHJpdmVBbGxvd1BvbGljeTogdGhpcy5yZWRyaXZlQWxsb3dQb2xpY3ksXG4gICAgICAgICAgICByZWRyaXZlUG9saWN5OiB0aGlzLnJlZHJpdmVQb2xpY3ksXG4gICAgICAgICAgICBzcXNNYW5hZ2VkU3NlRW5hYmxlZDogdGhpcy5zcXNNYW5hZ2VkU3NlRW5hYmxlZCxcbiAgICAgICAgICAgIHRhZ3M6IHRoaXMudGFncy5yZW5kZXJUYWdzKCksXG4gICAgICAgICAgICB2aXNpYmlsaXR5VGltZW91dDogdGhpcy52aXNpYmlsaXR5VGltZW91dCxcbiAgICAgICAgfTtcbiAgICB9XG5cbiAgICBwcm90ZWN0ZWQgb3ZlcnJpZGUgcmVuZGVyUHJvcGVydGllcyhwcm9wczoge1trZXk6IHN0cmluZ106IGFueX0pOiB7IFtrZXk6IHN0cmluZ106IGFueSB9ICB7XG4gICAgICAgIHJldHVybiBjZm5RdWV1ZVByb3BzVG9DbG91ZEZvcm1hdGlvbihwcm9wcyk7XG4gICAgfVxufVxuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGRlZmluaW5nIGEgYENmblF1ZXVlUG9saWN5YFxuICpcbiAqIEBzdHJ1Y3RcbiAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAqXG4gKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLXNxcy1wb2xpY3kuaHRtbFxuICovXG5leHBvcnQgaW50ZXJmYWNlIENmblF1ZXVlUG9saWN5UHJvcHMge1xuXG4gICAgLyoqXG4gICAgICogQSBwb2xpY3kgZG9jdW1lbnQgdGhhdCBjb250YWlucyB0aGUgcGVybWlzc2lvbnMgZm9yIHRoZSBzcGVjaWZpZWQgQW1hem9uIFNRUyBxdWV1ZXMuIEZvciBtb3JlIGluZm9ybWF0aW9uIGFib3V0IEFtYXpvbiBTUVMgcG9saWNpZXMsIHNlZSBbVXNpbmcgY3VzdG9tIHBvbGljaWVzIHdpdGggdGhlIEFtYXpvbiBTUVMgYWNjZXNzIHBvbGljeSBsYW5ndWFnZV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU1NpbXBsZVF1ZXVlU2VydmljZS9sYXRlc3QvU1FTRGV2ZWxvcGVyR3VpZGUvc3FzLWNyZWF0aW5nLWN1c3RvbS1wb2xpY2llcy5odG1sKSBpbiB0aGUgKkFtYXpvbiBTUVMgRGV2ZWxvcGVyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLXNxcy1wb2xpY3kuaHRtbCNjZm4tc3FzLXF1ZXVlcG9saWN5LXBvbGljeWRvY1xuICAgICAqL1xuICAgIHJlYWRvbmx5IHBvbGljeURvY3VtZW50OiBhbnkgfCBjZGsuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgVVJMcyBvZiB0aGUgcXVldWVzIHRvIHdoaWNoIHlvdSB3YW50IHRvIGFkZCB0aGUgcG9saWN5LiBZb3UgY2FuIHVzZSB0aGUgYFtSZWZdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2ludHJpbnNpYy1mdW5jdGlvbi1yZWZlcmVuY2UtcmVmLmh0bWwpYCBmdW5jdGlvbiB0byBzcGVjaWZ5IGFuIGBbQVdTOjpTUVM6OlF1ZXVlXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1zcXMtcXVldWVzLmh0bWwpYCByZXNvdXJjZS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtc3FzLXBvbGljeS5odG1sI2Nmbi1zcXMtcXVldWVwb2xpY3ktcXVldWVzXG4gICAgICovXG4gICAgcmVhZG9ubHkgcXVldWVzOiBzdHJpbmdbXTtcbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBDZm5RdWV1ZVBvbGljeVByb3BzYFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBDZm5RdWV1ZVBvbGljeVByb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmblF1ZXVlUG9saWN5UHJvcHNWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdwb2xpY3lEb2N1bWVudCcsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5wb2xpY3lEb2N1bWVudCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncG9saWN5RG9jdW1lbnQnLCBjZGsudmFsaWRhdGVPYmplY3QpKHByb3BlcnRpZXMucG9saWN5RG9jdW1lbnQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3F1ZXVlcycsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5xdWV1ZXMpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3F1ZXVlcycsIGNkay5saXN0VmFsaWRhdG9yKGNkay52YWxpZGF0ZVN0cmluZykpKHByb3BlcnRpZXMucXVldWVzKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIkNmblF1ZXVlUG9saWN5UHJvcHNcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OlNRUzo6UXVldWVQb2xpY3lgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYENmblF1ZXVlUG9saWN5UHJvcHNgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OlNRUzo6UXVldWVQb2xpY3lgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuUXVldWVQb2xpY3lQcm9wc1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuUXVldWVQb2xpY3lQcm9wc1ZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgUG9saWN5RG9jdW1lbnQ6IGNkay5vYmplY3RUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucG9saWN5RG9jdW1lbnQpLFxuICAgICAgICBRdWV1ZXM6IGNkay5saXN0TWFwcGVyKGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKShwcm9wZXJ0aWVzLnF1ZXVlcyksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmblF1ZXVlUG9saWN5UHJvcHNGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdDxDZm5RdWV1ZVBvbGljeVByb3BzPiB7XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5RdWV1ZVBvbGljeVByb3BzPigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgncG9saWN5RG9jdW1lbnQnLCAnUG9saWN5RG9jdW1lbnQnLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldEFueShwcm9wZXJ0aWVzLlBvbGljeURvY3VtZW50KSk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdxdWV1ZXMnLCAnUXVldWVzJywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmdBcnJheShwcm9wZXJ0aWVzLlF1ZXVlcykpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG4vKipcbiAqIEEgQ2xvdWRGb3JtYXRpb24gYEFXUzo6U1FTOjpRdWV1ZVBvbGljeWBcbiAqXG4gKiBUaGUgYEFXUzo6U1FTOjpRdWV1ZVBvbGljeWAgdHlwZSBhcHBsaWVzIGEgcG9saWN5IHRvIEFtYXpvbiBTUVMgcXVldWVzLiBGb3IgYW4gZXhhbXBsZSBzbmlwcGV0LCBzZWUgW0RlY2xhcmluZyBhbiBBbWF6b24gU1FTIHBvbGljeV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvcXVpY2tyZWYtaWFtLmh0bWwjc2NlbmFyaW8tc3FzLXBvbGljeSkgaW4gdGhlICpBV1MgQ2xvdWRGb3JtYXRpb24gVXNlciBHdWlkZSogLlxuICpcbiAqIEBjbG91ZGZvcm1hdGlvblJlc291cmNlIEFXUzo6U1FTOjpRdWV1ZVBvbGljeVxuICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICpcbiAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtc3FzLXBvbGljeS5odG1sXG4gKi9cbmV4cG9ydCBjbGFzcyBDZm5RdWV1ZVBvbGljeSBleHRlbmRzIGNkay5DZm5SZXNvdXJjZSBpbXBsZW1lbnRzIGNkay5JSW5zcGVjdGFibGUge1xuICAgIC8qKlxuICAgICAqIFRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSB0eXBlIG5hbWUgZm9yIHRoaXMgcmVzb3VyY2UgY2xhc3MuXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBDRk5fUkVTT1VSQ0VfVFlQRV9OQU1FID0gXCJBV1M6OlNRUzo6UXVldWVQb2xpY3lcIjtcblxuICAgIC8qKlxuICAgICAqIEEgZmFjdG9yeSBtZXRob2QgdGhhdCBjcmVhdGVzIGEgbmV3IGluc3RhbmNlIG9mIHRoaXMgY2xhc3MgZnJvbSBhbiBvYmplY3RcbiAgICAgKiBjb250YWluaW5nIHRoZSBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIHRoaXMgcmVzb3VyY2UuXG4gICAgICogVXNlZCBpbiB0aGUgQGF3cy1jZGsvY2xvdWRmb3JtYXRpb24taW5jbHVkZSBtb2R1bGUuXG4gICAgICpcbiAgICAgKiBAaW50ZXJuYWxcbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIF9mcm9tQ2xvdWRGb3JtYXRpb24oc2NvcGU6IGNvbnN0cnVjdHMuQ29uc3RydWN0LCBpZDogc3RyaW5nLCByZXNvdXJjZUF0dHJpYnV0ZXM6IGFueSwgb3B0aW9uczogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbk9wdGlvbnMpOiBDZm5RdWV1ZVBvbGljeSB7XG4gICAgICAgIHJlc291cmNlQXR0cmlidXRlcyA9IHJlc291cmNlQXR0cmlidXRlcyB8fCB7fTtcbiAgICAgICAgY29uc3QgcmVzb3VyY2VQcm9wZXJ0aWVzID0gb3B0aW9ucy5wYXJzZXIucGFyc2VWYWx1ZShyZXNvdXJjZUF0dHJpYnV0ZXMuUHJvcGVydGllcyk7XG4gICAgICAgIGNvbnN0IHByb3BzUmVzdWx0ID0gQ2ZuUXVldWVQb2xpY3lQcm9wc0Zyb21DbG91ZEZvcm1hdGlvbihyZXNvdXJjZVByb3BlcnRpZXMpO1xuICAgICAgICBjb25zdCByZXQgPSBuZXcgQ2ZuUXVldWVQb2xpY3koc2NvcGUsIGlkLCBwcm9wc1Jlc3VsdC52YWx1ZSk7XG4gICAgICAgIGZvciAoY29uc3QgW3Byb3BLZXksIHByb3BWYWxdIG9mIE9iamVjdC5lbnRyaWVzKHByb3BzUmVzdWx0LmV4dHJhUHJvcGVydGllcykpICB7XG4gICAgICAgICAgICByZXQuYWRkUHJvcGVydHlPdmVycmlkZShwcm9wS2V5LCBwcm9wVmFsKTtcbiAgICAgICAgfVxuICAgICAgICBvcHRpb25zLnBhcnNlci5oYW5kbGVBdHRyaWJ1dGVzKHJldCwgcmVzb3VyY2VBdHRyaWJ1dGVzLCBpZCk7XG4gICAgICAgIHJldHVybiByZXQ7XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogQSBwb2xpY3kgZG9jdW1lbnQgdGhhdCBjb250YWlucyB0aGUgcGVybWlzc2lvbnMgZm9yIHRoZSBzcGVjaWZpZWQgQW1hem9uIFNRUyBxdWV1ZXMuIEZvciBtb3JlIGluZm9ybWF0aW9uIGFib3V0IEFtYXpvbiBTUVMgcG9saWNpZXMsIHNlZSBbVXNpbmcgY3VzdG9tIHBvbGljaWVzIHdpdGggdGhlIEFtYXpvbiBTUVMgYWNjZXNzIHBvbGljeSBsYW5ndWFnZV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU1NpbXBsZVF1ZXVlU2VydmljZS9sYXRlc3QvU1FTRGV2ZWxvcGVyR3VpZGUvc3FzLWNyZWF0aW5nLWN1c3RvbS1wb2xpY2llcy5odG1sKSBpbiB0aGUgKkFtYXpvbiBTUVMgRGV2ZWxvcGVyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLXNxcy1wb2xpY3kuaHRtbCNjZm4tc3FzLXF1ZXVlcG9saWN5LXBvbGljeWRvY1xuICAgICAqL1xuICAgIHB1YmxpYyBwb2xpY3lEb2N1bWVudDogYW55IHwgY2RrLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogVGhlIFVSTHMgb2YgdGhlIHF1ZXVlcyB0byB3aGljaCB5b3Ugd2FudCB0byBhZGQgdGhlIHBvbGljeS4gWW91IGNhbiB1c2UgdGhlIGBbUmVmXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9pbnRyaW5zaWMtZnVuY3Rpb24tcmVmZXJlbmNlLXJlZi5odG1sKWAgZnVuY3Rpb24gdG8gc3BlY2lmeSBhbiBgW0FXUzo6U1FTOjpRdWV1ZV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtc3FzLXF1ZXVlcy5odG1sKWAgcmVzb3VyY2UuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLXNxcy1wb2xpY3kuaHRtbCNjZm4tc3FzLXF1ZXVlcG9saWN5LXF1ZXVlc1xuICAgICAqL1xuICAgIHB1YmxpYyBxdWV1ZXM6IHN0cmluZ1tdO1xuXG4gICAgLyoqXG4gICAgICogQ3JlYXRlIGEgbmV3IGBBV1M6OlNRUzo6UXVldWVQb2xpY3lgLlxuICAgICAqXG4gICAgICogQHBhcmFtIHNjb3BlIC0gc2NvcGUgaW4gd2hpY2ggdGhpcyByZXNvdXJjZSBpcyBkZWZpbmVkXG4gICAgICogQHBhcmFtIGlkICAgIC0gc2NvcGVkIGlkIG9mIHRoZSByZXNvdXJjZVxuICAgICAqIEBwYXJhbSBwcm9wcyAtIHJlc291cmNlIHByb3BlcnRpZXNcbiAgICAgKi9cbiAgICBjb25zdHJ1Y3RvcihzY29wZTogY29uc3RydWN0cy5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBDZm5RdWV1ZVBvbGljeVByb3BzKSB7XG4gICAgICAgIHN1cGVyKHNjb3BlLCBpZCwgeyB0eXBlOiBDZm5RdWV1ZVBvbGljeS5DRk5fUkVTT1VSQ0VfVFlQRV9OQU1FLCBwcm9wZXJ0aWVzOiBwcm9wcyB9KTtcbiAgICAgICAgY2RrLnJlcXVpcmVQcm9wZXJ0eShwcm9wcywgJ3BvbGljeURvY3VtZW50JywgdGhpcyk7XG4gICAgICAgIGNkay5yZXF1aXJlUHJvcGVydHkocHJvcHMsICdxdWV1ZXMnLCB0aGlzKTtcblxuICAgICAgICB0aGlzLnBvbGljeURvY3VtZW50ID0gcHJvcHMucG9saWN5RG9jdW1lbnQ7XG4gICAgICAgIHRoaXMucXVldWVzID0gcHJvcHMucXVldWVzO1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIEV4YW1pbmVzIHRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSBhbmQgZGlzY2xvc2VzIGF0dHJpYnV0ZXMuXG4gICAgICpcbiAgICAgKiBAcGFyYW0gaW5zcGVjdG9yIC0gdHJlZSBpbnNwZWN0b3IgdG8gY29sbGVjdCBhbmQgcHJvY2VzcyBhdHRyaWJ1dGVzXG4gICAgICpcbiAgICAgKi9cbiAgICBwdWJsaWMgaW5zcGVjdChpbnNwZWN0b3I6IGNkay5UcmVlSW5zcGVjdG9yKSB7XG4gICAgICAgIGluc3BlY3Rvci5hZGRBdHRyaWJ1dGUoXCJhd3M6Y2RrOmNsb3VkZm9ybWF0aW9uOnR5cGVcIiwgQ2ZuUXVldWVQb2xpY3kuQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSk7XG4gICAgICAgIGluc3BlY3Rvci5hZGRBdHRyaWJ1dGUoXCJhd3M6Y2RrOmNsb3VkZm9ybWF0aW9uOnByb3BzXCIsIHRoaXMuY2ZuUHJvcGVydGllcyk7XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIG92ZXJyaWRlIGdldCBjZm5Qcm9wZXJ0aWVzKCk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIHBvbGljeURvY3VtZW50OiB0aGlzLnBvbGljeURvY3VtZW50LFxuICAgICAgICAgICAgcXVldWVzOiB0aGlzLnF1ZXVlcyxcbiAgICAgICAgfTtcbiAgICB9XG5cbiAgICBwcm90ZWN0ZWQgb3ZlcnJpZGUgcmVuZGVyUHJvcGVydGllcyhwcm9wczoge1trZXk6IHN0cmluZ106IGFueX0pOiB7IFtrZXk6IHN0cmluZ106IGFueSB9ICB7XG4gICAgICAgIHJldHVybiBjZm5RdWV1ZVBvbGljeVByb3BzVG9DbG91ZEZvcm1hdGlvbihwcm9wcyk7XG4gICAgfVxufVxuIl19