"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnResourcePolicy = exports.CfnResourceDataSync = exports.CfnPatchBaseline = exports.CfnParameter = exports.CfnMaintenanceWindowTask = exports.CfnMaintenanceWindowTarget = exports.CfnMaintenanceWindow = exports.CfnDocument = exports.CfnAssociation = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core");
const cfn_parse = require("../../core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnAssociationProps`
 *
 * @param properties - the TypeScript properties of a `CfnAssociationProps`
 *
 * @returns the result of the validation.
 */
function CfnAssociationPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('applyOnlyAtCronInterval', cdk.validateBoolean)(properties.applyOnlyAtCronInterval));
    errors.collect(cdk.propertyValidator('associationName', cdk.validateString)(properties.associationName));
    errors.collect(cdk.propertyValidator('automationTargetParameterName', cdk.validateString)(properties.automationTargetParameterName));
    errors.collect(cdk.propertyValidator('calendarNames', cdk.listValidator(cdk.validateString))(properties.calendarNames));
    errors.collect(cdk.propertyValidator('complianceSeverity', cdk.validateString)(properties.complianceSeverity));
    errors.collect(cdk.propertyValidator('documentVersion', cdk.validateString)(properties.documentVersion));
    errors.collect(cdk.propertyValidator('instanceId', cdk.validateString)(properties.instanceId));
    errors.collect(cdk.propertyValidator('maxConcurrency', cdk.validateString)(properties.maxConcurrency));
    errors.collect(cdk.propertyValidator('maxErrors', cdk.validateString)(properties.maxErrors));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('outputLocation', CfnAssociation_InstanceAssociationOutputLocationPropertyValidator)(properties.outputLocation));
    errors.collect(cdk.propertyValidator('parameters', cdk.validateObject)(properties.parameters));
    errors.collect(cdk.propertyValidator('scheduleExpression', cdk.validateString)(properties.scheduleExpression));
    errors.collect(cdk.propertyValidator('scheduleOffset', cdk.validateNumber)(properties.scheduleOffset));
    errors.collect(cdk.propertyValidator('syncCompliance', cdk.validateString)(properties.syncCompliance));
    errors.collect(cdk.propertyValidator('targets', cdk.listValidator(CfnAssociation_TargetPropertyValidator))(properties.targets));
    errors.collect(cdk.propertyValidator('waitForSuccessTimeoutSeconds', cdk.validateNumber)(properties.waitForSuccessTimeoutSeconds));
    return errors.wrap('supplied properties not correct for "CfnAssociationProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::Association` resource
 *
 * @param properties - the TypeScript properties of a `CfnAssociationProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::Association` resource.
 */
// @ts-ignore TS6133
function cfnAssociationPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAssociationPropsValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        ApplyOnlyAtCronInterval: cdk.booleanToCloudFormation(properties.applyOnlyAtCronInterval),
        AssociationName: cdk.stringToCloudFormation(properties.associationName),
        AutomationTargetParameterName: cdk.stringToCloudFormation(properties.automationTargetParameterName),
        CalendarNames: cdk.listMapper(cdk.stringToCloudFormation)(properties.calendarNames),
        ComplianceSeverity: cdk.stringToCloudFormation(properties.complianceSeverity),
        DocumentVersion: cdk.stringToCloudFormation(properties.documentVersion),
        InstanceId: cdk.stringToCloudFormation(properties.instanceId),
        MaxConcurrency: cdk.stringToCloudFormation(properties.maxConcurrency),
        MaxErrors: cdk.stringToCloudFormation(properties.maxErrors),
        OutputLocation: cfnAssociationInstanceAssociationOutputLocationPropertyToCloudFormation(properties.outputLocation),
        Parameters: cdk.objectToCloudFormation(properties.parameters),
        ScheduleExpression: cdk.stringToCloudFormation(properties.scheduleExpression),
        ScheduleOffset: cdk.numberToCloudFormation(properties.scheduleOffset),
        SyncCompliance: cdk.stringToCloudFormation(properties.syncCompliance),
        Targets: cdk.listMapper(cfnAssociationTargetPropertyToCloudFormation)(properties.targets),
        WaitForSuccessTimeoutSeconds: cdk.numberToCloudFormation(properties.waitForSuccessTimeoutSeconds),
    };
}
// @ts-ignore TS6133
function CfnAssociationPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('applyOnlyAtCronInterval', 'ApplyOnlyAtCronInterval', properties.ApplyOnlyAtCronInterval != null ? cfn_parse.FromCloudFormation.getBoolean(properties.ApplyOnlyAtCronInterval) : undefined);
    ret.addPropertyResult('associationName', 'AssociationName', properties.AssociationName != null ? cfn_parse.FromCloudFormation.getString(properties.AssociationName) : undefined);
    ret.addPropertyResult('automationTargetParameterName', 'AutomationTargetParameterName', properties.AutomationTargetParameterName != null ? cfn_parse.FromCloudFormation.getString(properties.AutomationTargetParameterName) : undefined);
    ret.addPropertyResult('calendarNames', 'CalendarNames', properties.CalendarNames != null ? cfn_parse.FromCloudFormation.getStringArray(properties.CalendarNames) : undefined);
    ret.addPropertyResult('complianceSeverity', 'ComplianceSeverity', properties.ComplianceSeverity != null ? cfn_parse.FromCloudFormation.getString(properties.ComplianceSeverity) : undefined);
    ret.addPropertyResult('documentVersion', 'DocumentVersion', properties.DocumentVersion != null ? cfn_parse.FromCloudFormation.getString(properties.DocumentVersion) : undefined);
    ret.addPropertyResult('instanceId', 'InstanceId', properties.InstanceId != null ? cfn_parse.FromCloudFormation.getString(properties.InstanceId) : undefined);
    ret.addPropertyResult('maxConcurrency', 'MaxConcurrency', properties.MaxConcurrency != null ? cfn_parse.FromCloudFormation.getString(properties.MaxConcurrency) : undefined);
    ret.addPropertyResult('maxErrors', 'MaxErrors', properties.MaxErrors != null ? cfn_parse.FromCloudFormation.getString(properties.MaxErrors) : undefined);
    ret.addPropertyResult('outputLocation', 'OutputLocation', properties.OutputLocation != null ? CfnAssociationInstanceAssociationOutputLocationPropertyFromCloudFormation(properties.OutputLocation) : undefined);
    ret.addPropertyResult('parameters', 'Parameters', properties.Parameters != null ? cfn_parse.FromCloudFormation.getAny(properties.Parameters) : undefined);
    ret.addPropertyResult('scheduleExpression', 'ScheduleExpression', properties.ScheduleExpression != null ? cfn_parse.FromCloudFormation.getString(properties.ScheduleExpression) : undefined);
    ret.addPropertyResult('scheduleOffset', 'ScheduleOffset', properties.ScheduleOffset != null ? cfn_parse.FromCloudFormation.getNumber(properties.ScheduleOffset) : undefined);
    ret.addPropertyResult('syncCompliance', 'SyncCompliance', properties.SyncCompliance != null ? cfn_parse.FromCloudFormation.getString(properties.SyncCompliance) : undefined);
    ret.addPropertyResult('targets', 'Targets', properties.Targets != null ? cfn_parse.FromCloudFormation.getArray(CfnAssociationTargetPropertyFromCloudFormation)(properties.Targets) : undefined);
    ret.addPropertyResult('waitForSuccessTimeoutSeconds', 'WaitForSuccessTimeoutSeconds', properties.WaitForSuccessTimeoutSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.WaitForSuccessTimeoutSeconds) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SSM::Association`
 *
 * The `AWS::SSM::Association` resource creates a State Manager association for your managed instances. A State Manager association defines the state that you want to maintain on your instances. For example, an association can specify that anti-virus software must be installed and running on your instances, or that certain ports must be closed. For static targets, the association specifies a schedule for when the configuration is reapplied. For dynamic targets, such as an AWS Resource Groups or an AWS Auto Scaling Group, State Manager applies the configuration when new instances are added to the group. The association also specifies actions to take when applying the configuration. For example, an association for anti-virus software might run once a day. If the software is not installed, then State Manager installs it. If the software is installed, but the service is not running, then the association might instruct State Manager to start the service.
 *
 * @cloudformationResource AWS::SSM::Association
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html
 */
class CfnAssociation extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnAssociationPropsFromCloudFormation(resourceProperties);
        const ret = new CfnAssociation(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::SSM::Association`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnAssociation.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ssm_CfnAssociationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnAssociation);
            }
            throw error;
        }
        cdk.requireProperty(props, 'name', this);
        this.attrAssociationId = cdk.Token.asString(this.getAtt('AssociationId', cdk.ResolutionTypeHint.STRING));
        this.name = props.name;
        this.applyOnlyAtCronInterval = props.applyOnlyAtCronInterval;
        this.associationName = props.associationName;
        this.automationTargetParameterName = props.automationTargetParameterName;
        this.calendarNames = props.calendarNames;
        this.complianceSeverity = props.complianceSeverity;
        this.documentVersion = props.documentVersion;
        this.instanceId = props.instanceId;
        this.maxConcurrency = props.maxConcurrency;
        this.maxErrors = props.maxErrors;
        this.outputLocation = props.outputLocation;
        this.parameters = props.parameters;
        this.scheduleExpression = props.scheduleExpression;
        this.scheduleOffset = props.scheduleOffset;
        this.syncCompliance = props.syncCompliance;
        this.targets = props.targets;
        this.waitForSuccessTimeoutSeconds = props.waitForSuccessTimeoutSeconds;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnAssociation.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            name: this.name,
            applyOnlyAtCronInterval: this.applyOnlyAtCronInterval,
            associationName: this.associationName,
            automationTargetParameterName: this.automationTargetParameterName,
            calendarNames: this.calendarNames,
            complianceSeverity: this.complianceSeverity,
            documentVersion: this.documentVersion,
            instanceId: this.instanceId,
            maxConcurrency: this.maxConcurrency,
            maxErrors: this.maxErrors,
            outputLocation: this.outputLocation,
            parameters: this.parameters,
            scheduleExpression: this.scheduleExpression,
            scheduleOffset: this.scheduleOffset,
            syncCompliance: this.syncCompliance,
            targets: this.targets,
            waitForSuccessTimeoutSeconds: this.waitForSuccessTimeoutSeconds,
        };
    }
    renderProperties(props) {
        return cfnAssociationPropsToCloudFormation(props);
    }
}
_a = JSII_RTTI_SYMBOL_1;
CfnAssociation[_a] = { fqn: "aws-cdk-lib.aws_ssm.CfnAssociation", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnAssociation.CFN_RESOURCE_TYPE_NAME = "AWS::SSM::Association";
exports.CfnAssociation = CfnAssociation;
/**
 * Determine whether the given properties match those of a `InstanceAssociationOutputLocationProperty`
 *
 * @param properties - the TypeScript properties of a `InstanceAssociationOutputLocationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAssociation_InstanceAssociationOutputLocationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('s3Location', CfnAssociation_S3OutputLocationPropertyValidator)(properties.s3Location));
    return errors.wrap('supplied properties not correct for "InstanceAssociationOutputLocationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::Association.InstanceAssociationOutputLocation` resource
 *
 * @param properties - the TypeScript properties of a `InstanceAssociationOutputLocationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::Association.InstanceAssociationOutputLocation` resource.
 */
// @ts-ignore TS6133
function cfnAssociationInstanceAssociationOutputLocationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAssociation_InstanceAssociationOutputLocationPropertyValidator(properties).assertSuccess();
    return {
        S3Location: cfnAssociationS3OutputLocationPropertyToCloudFormation(properties.s3Location),
    };
}
// @ts-ignore TS6133
function CfnAssociationInstanceAssociationOutputLocationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('s3Location', 'S3Location', properties.S3Location != null ? CfnAssociationS3OutputLocationPropertyFromCloudFormation(properties.S3Location) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `S3OutputLocationProperty`
 *
 * @param properties - the TypeScript properties of a `S3OutputLocationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAssociation_S3OutputLocationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('outputS3BucketName', cdk.validateString)(properties.outputS3BucketName));
    errors.collect(cdk.propertyValidator('outputS3KeyPrefix', cdk.validateString)(properties.outputS3KeyPrefix));
    errors.collect(cdk.propertyValidator('outputS3Region', cdk.validateString)(properties.outputS3Region));
    return errors.wrap('supplied properties not correct for "S3OutputLocationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::Association.S3OutputLocation` resource
 *
 * @param properties - the TypeScript properties of a `S3OutputLocationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::Association.S3OutputLocation` resource.
 */
// @ts-ignore TS6133
function cfnAssociationS3OutputLocationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAssociation_S3OutputLocationPropertyValidator(properties).assertSuccess();
    return {
        OutputS3BucketName: cdk.stringToCloudFormation(properties.outputS3BucketName),
        OutputS3KeyPrefix: cdk.stringToCloudFormation(properties.outputS3KeyPrefix),
        OutputS3Region: cdk.stringToCloudFormation(properties.outputS3Region),
    };
}
// @ts-ignore TS6133
function CfnAssociationS3OutputLocationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('outputS3BucketName', 'OutputS3BucketName', properties.OutputS3BucketName != null ? cfn_parse.FromCloudFormation.getString(properties.OutputS3BucketName) : undefined);
    ret.addPropertyResult('outputS3KeyPrefix', 'OutputS3KeyPrefix', properties.OutputS3KeyPrefix != null ? cfn_parse.FromCloudFormation.getString(properties.OutputS3KeyPrefix) : undefined);
    ret.addPropertyResult('outputS3Region', 'OutputS3Region', properties.OutputS3Region != null ? cfn_parse.FromCloudFormation.getString(properties.OutputS3Region) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `TargetProperty`
 *
 * @param properties - the TypeScript properties of a `TargetProperty`
 *
 * @returns the result of the validation.
 */
function CfnAssociation_TargetPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('key', cdk.requiredValidator)(properties.key));
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('values', cdk.requiredValidator)(properties.values));
    errors.collect(cdk.propertyValidator('values', cdk.listValidator(cdk.validateString))(properties.values));
    return errors.wrap('supplied properties not correct for "TargetProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::Association.Target` resource
 *
 * @param properties - the TypeScript properties of a `TargetProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::Association.Target` resource.
 */
// @ts-ignore TS6133
function cfnAssociationTargetPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAssociation_TargetPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Values: cdk.listMapper(cdk.stringToCloudFormation)(properties.values),
    };
}
// @ts-ignore TS6133
function CfnAssociationTargetPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('key', 'Key', cfn_parse.FromCloudFormation.getString(properties.Key));
    ret.addPropertyResult('values', 'Values', cfn_parse.FromCloudFormation.getStringArray(properties.Values));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnDocumentProps`
 *
 * @param properties - the TypeScript properties of a `CfnDocumentProps`
 *
 * @returns the result of the validation.
 */
function CfnDocumentPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('attachments', cdk.listValidator(CfnDocument_AttachmentsSourcePropertyValidator))(properties.attachments));
    errors.collect(cdk.propertyValidator('content', cdk.requiredValidator)(properties.content));
    errors.collect(cdk.propertyValidator('content', cdk.validateObject)(properties.content));
    errors.collect(cdk.propertyValidator('documentFormat', cdk.validateString)(properties.documentFormat));
    errors.collect(cdk.propertyValidator('documentType', cdk.validateString)(properties.documentType));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('requires', cdk.listValidator(CfnDocument_DocumentRequiresPropertyValidator))(properties.requires));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('targetType', cdk.validateString)(properties.targetType));
    errors.collect(cdk.propertyValidator('updateMethod', cdk.validateString)(properties.updateMethod));
    errors.collect(cdk.propertyValidator('versionName', cdk.validateString)(properties.versionName));
    return errors.wrap('supplied properties not correct for "CfnDocumentProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::Document` resource
 *
 * @param properties - the TypeScript properties of a `CfnDocumentProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::Document` resource.
 */
// @ts-ignore TS6133
function cfnDocumentPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDocumentPropsValidator(properties).assertSuccess();
    return {
        Content: cdk.objectToCloudFormation(properties.content),
        Attachments: cdk.listMapper(cfnDocumentAttachmentsSourcePropertyToCloudFormation)(properties.attachments),
        DocumentFormat: cdk.stringToCloudFormation(properties.documentFormat),
        DocumentType: cdk.stringToCloudFormation(properties.documentType),
        Name: cdk.stringToCloudFormation(properties.name),
        Requires: cdk.listMapper(cfnDocumentDocumentRequiresPropertyToCloudFormation)(properties.requires),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        TargetType: cdk.stringToCloudFormation(properties.targetType),
        UpdateMethod: cdk.stringToCloudFormation(properties.updateMethod),
        VersionName: cdk.stringToCloudFormation(properties.versionName),
    };
}
// @ts-ignore TS6133
function CfnDocumentPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('content', 'Content', cfn_parse.FromCloudFormation.getAny(properties.Content));
    ret.addPropertyResult('attachments', 'Attachments', properties.Attachments != null ? cfn_parse.FromCloudFormation.getArray(CfnDocumentAttachmentsSourcePropertyFromCloudFormation)(properties.Attachments) : undefined);
    ret.addPropertyResult('documentFormat', 'DocumentFormat', properties.DocumentFormat != null ? cfn_parse.FromCloudFormation.getString(properties.DocumentFormat) : undefined);
    ret.addPropertyResult('documentType', 'DocumentType', properties.DocumentType != null ? cfn_parse.FromCloudFormation.getString(properties.DocumentType) : undefined);
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('requires', 'Requires', properties.Requires != null ? cfn_parse.FromCloudFormation.getArray(CfnDocumentDocumentRequiresPropertyFromCloudFormation)(properties.Requires) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('targetType', 'TargetType', properties.TargetType != null ? cfn_parse.FromCloudFormation.getString(properties.TargetType) : undefined);
    ret.addPropertyResult('updateMethod', 'UpdateMethod', properties.UpdateMethod != null ? cfn_parse.FromCloudFormation.getString(properties.UpdateMethod) : undefined);
    ret.addPropertyResult('versionName', 'VersionName', properties.VersionName != null ? cfn_parse.FromCloudFormation.getString(properties.VersionName) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SSM::Document`
 *
 * The `AWS::SSM::Document` resource creates a Systems Manager (SSM) document in AWS Systems Manager . This document defines the actions that Systems Manager performs on your AWS resources.
 *
 * > This resource does not support CloudFormation drift detection.
 *
 * @cloudformationResource AWS::SSM::Document
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html
 */
class CfnDocument extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDocumentPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDocument(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::SSM::Document`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDocument.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ssm_CfnDocumentProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnDocument);
            }
            throw error;
        }
        cdk.requireProperty(props, 'content', this);
        this.content = props.content;
        this.attachments = props.attachments;
        this.documentFormat = props.documentFormat;
        this.documentType = props.documentType;
        this.name = props.name;
        this.requires = props.requires;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::SSM::Document", props.tags, { tagPropertyName: 'tags' });
        this.targetType = props.targetType;
        this.updateMethod = props.updateMethod;
        this.versionName = props.versionName;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDocument.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            content: this.content,
            attachments: this.attachments,
            documentFormat: this.documentFormat,
            documentType: this.documentType,
            name: this.name,
            requires: this.requires,
            tags: this.tags.renderTags(),
            targetType: this.targetType,
            updateMethod: this.updateMethod,
            versionName: this.versionName,
        };
    }
    renderProperties(props) {
        return cfnDocumentPropsToCloudFormation(props);
    }
}
_b = JSII_RTTI_SYMBOL_1;
CfnDocument[_b] = { fqn: "aws-cdk-lib.aws_ssm.CfnDocument", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDocument.CFN_RESOURCE_TYPE_NAME = "AWS::SSM::Document";
exports.CfnDocument = CfnDocument;
/**
 * Determine whether the given properties match those of a `AttachmentsSourceProperty`
 *
 * @param properties - the TypeScript properties of a `AttachmentsSourceProperty`
 *
 * @returns the result of the validation.
 */
function CfnDocument_AttachmentsSourcePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('values', cdk.listValidator(cdk.validateString))(properties.values));
    return errors.wrap('supplied properties not correct for "AttachmentsSourceProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::Document.AttachmentsSource` resource
 *
 * @param properties - the TypeScript properties of a `AttachmentsSourceProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::Document.AttachmentsSource` resource.
 */
// @ts-ignore TS6133
function cfnDocumentAttachmentsSourcePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDocument_AttachmentsSourcePropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Name: cdk.stringToCloudFormation(properties.name),
        Values: cdk.listMapper(cdk.stringToCloudFormation)(properties.values),
    };
}
// @ts-ignore TS6133
function CfnDocumentAttachmentsSourcePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('key', 'Key', properties.Key != null ? cfn_parse.FromCloudFormation.getString(properties.Key) : undefined);
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('values', 'Values', properties.Values != null ? cfn_parse.FromCloudFormation.getStringArray(properties.Values) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DocumentRequiresProperty`
 *
 * @param properties - the TypeScript properties of a `DocumentRequiresProperty`
 *
 * @returns the result of the validation.
 */
function CfnDocument_DocumentRequiresPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('version', cdk.validateString)(properties.version));
    return errors.wrap('supplied properties not correct for "DocumentRequiresProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::Document.DocumentRequires` resource
 *
 * @param properties - the TypeScript properties of a `DocumentRequiresProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::Document.DocumentRequires` resource.
 */
// @ts-ignore TS6133
function cfnDocumentDocumentRequiresPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDocument_DocumentRequiresPropertyValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        Version: cdk.stringToCloudFormation(properties.version),
    };
}
// @ts-ignore TS6133
function CfnDocumentDocumentRequiresPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('version', 'Version', properties.Version != null ? cfn_parse.FromCloudFormation.getString(properties.Version) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnMaintenanceWindowProps`
 *
 * @param properties - the TypeScript properties of a `CfnMaintenanceWindowProps`
 *
 * @returns the result of the validation.
 */
function CfnMaintenanceWindowPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('allowUnassociatedTargets', cdk.requiredValidator)(properties.allowUnassociatedTargets));
    errors.collect(cdk.propertyValidator('allowUnassociatedTargets', cdk.validateBoolean)(properties.allowUnassociatedTargets));
    errors.collect(cdk.propertyValidator('cutoff', cdk.requiredValidator)(properties.cutoff));
    errors.collect(cdk.propertyValidator('cutoff', cdk.validateNumber)(properties.cutoff));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('duration', cdk.requiredValidator)(properties.duration));
    errors.collect(cdk.propertyValidator('duration', cdk.validateNumber)(properties.duration));
    errors.collect(cdk.propertyValidator('endDate', cdk.validateString)(properties.endDate));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('schedule', cdk.requiredValidator)(properties.schedule));
    errors.collect(cdk.propertyValidator('schedule', cdk.validateString)(properties.schedule));
    errors.collect(cdk.propertyValidator('scheduleOffset', cdk.validateNumber)(properties.scheduleOffset));
    errors.collect(cdk.propertyValidator('scheduleTimezone', cdk.validateString)(properties.scheduleTimezone));
    errors.collect(cdk.propertyValidator('startDate', cdk.validateString)(properties.startDate));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnMaintenanceWindowProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindow` resource
 *
 * @param properties - the TypeScript properties of a `CfnMaintenanceWindowProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindow` resource.
 */
// @ts-ignore TS6133
function cfnMaintenanceWindowPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMaintenanceWindowPropsValidator(properties).assertSuccess();
    return {
        AllowUnassociatedTargets: cdk.booleanToCloudFormation(properties.allowUnassociatedTargets),
        Cutoff: cdk.numberToCloudFormation(properties.cutoff),
        Duration: cdk.numberToCloudFormation(properties.duration),
        Name: cdk.stringToCloudFormation(properties.name),
        Schedule: cdk.stringToCloudFormation(properties.schedule),
        Description: cdk.stringToCloudFormation(properties.description),
        EndDate: cdk.stringToCloudFormation(properties.endDate),
        ScheduleOffset: cdk.numberToCloudFormation(properties.scheduleOffset),
        ScheduleTimezone: cdk.stringToCloudFormation(properties.scheduleTimezone),
        StartDate: cdk.stringToCloudFormation(properties.startDate),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnMaintenanceWindowPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('allowUnassociatedTargets', 'AllowUnassociatedTargets', cfn_parse.FromCloudFormation.getBoolean(properties.AllowUnassociatedTargets));
    ret.addPropertyResult('cutoff', 'Cutoff', cfn_parse.FromCloudFormation.getNumber(properties.Cutoff));
    ret.addPropertyResult('duration', 'Duration', cfn_parse.FromCloudFormation.getNumber(properties.Duration));
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('schedule', 'Schedule', cfn_parse.FromCloudFormation.getString(properties.Schedule));
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('endDate', 'EndDate', properties.EndDate != null ? cfn_parse.FromCloudFormation.getString(properties.EndDate) : undefined);
    ret.addPropertyResult('scheduleOffset', 'ScheduleOffset', properties.ScheduleOffset != null ? cfn_parse.FromCloudFormation.getNumber(properties.ScheduleOffset) : undefined);
    ret.addPropertyResult('scheduleTimezone', 'ScheduleTimezone', properties.ScheduleTimezone != null ? cfn_parse.FromCloudFormation.getString(properties.ScheduleTimezone) : undefined);
    ret.addPropertyResult('startDate', 'StartDate', properties.StartDate != null ? cfn_parse.FromCloudFormation.getString(properties.StartDate) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SSM::MaintenanceWindow`
 *
 * The `AWS::SSM::MaintenanceWindow` resource represents general information about a maintenance window for AWS Systems Manager . Maintenance Windows let you define a schedule for when to perform potentially disruptive actions on your instances, such as patching an operating system (OS), updating drivers, or installing software. Each maintenance window has a schedule, a duration, a set of registered targets, and a set of registered tasks.
 *
 * For more information, see [Systems Manager Maintenance Windows](https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-maintenance.html) in the *AWS Systems Manager User Guide* and [CreateMaintenanceWindow](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_CreateMaintenanceWindow.html) in the *AWS Systems Manager API Reference* .
 *
 * @cloudformationResource AWS::SSM::MaintenanceWindow
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindow.html
 */
class CfnMaintenanceWindow extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnMaintenanceWindowPropsFromCloudFormation(resourceProperties);
        const ret = new CfnMaintenanceWindow(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::SSM::MaintenanceWindow`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnMaintenanceWindow.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ssm_CfnMaintenanceWindowProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnMaintenanceWindow);
            }
            throw error;
        }
        cdk.requireProperty(props, 'allowUnassociatedTargets', this);
        cdk.requireProperty(props, 'cutoff', this);
        cdk.requireProperty(props, 'duration', this);
        cdk.requireProperty(props, 'name', this);
        cdk.requireProperty(props, 'schedule', this);
        this.allowUnassociatedTargets = props.allowUnassociatedTargets;
        this.cutoff = props.cutoff;
        this.duration = props.duration;
        this.name = props.name;
        this.schedule = props.schedule;
        this.description = props.description;
        this.endDate = props.endDate;
        this.scheduleOffset = props.scheduleOffset;
        this.scheduleTimezone = props.scheduleTimezone;
        this.startDate = props.startDate;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::SSM::MaintenanceWindow", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnMaintenanceWindow.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            allowUnassociatedTargets: this.allowUnassociatedTargets,
            cutoff: this.cutoff,
            duration: this.duration,
            name: this.name,
            schedule: this.schedule,
            description: this.description,
            endDate: this.endDate,
            scheduleOffset: this.scheduleOffset,
            scheduleTimezone: this.scheduleTimezone,
            startDate: this.startDate,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnMaintenanceWindowPropsToCloudFormation(props);
    }
}
_c = JSII_RTTI_SYMBOL_1;
CfnMaintenanceWindow[_c] = { fqn: "aws-cdk-lib.aws_ssm.CfnMaintenanceWindow", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnMaintenanceWindow.CFN_RESOURCE_TYPE_NAME = "AWS::SSM::MaintenanceWindow";
exports.CfnMaintenanceWindow = CfnMaintenanceWindow;
/**
 * Determine whether the given properties match those of a `CfnMaintenanceWindowTargetProps`
 *
 * @param properties - the TypeScript properties of a `CfnMaintenanceWindowTargetProps`
 *
 * @returns the result of the validation.
 */
function CfnMaintenanceWindowTargetPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('ownerInformation', cdk.validateString)(properties.ownerInformation));
    errors.collect(cdk.propertyValidator('resourceType', cdk.requiredValidator)(properties.resourceType));
    errors.collect(cdk.propertyValidator('resourceType', cdk.validateString)(properties.resourceType));
    errors.collect(cdk.propertyValidator('targets', cdk.requiredValidator)(properties.targets));
    errors.collect(cdk.propertyValidator('targets', cdk.listValidator(CfnMaintenanceWindowTarget_TargetsPropertyValidator))(properties.targets));
    errors.collect(cdk.propertyValidator('windowId', cdk.requiredValidator)(properties.windowId));
    errors.collect(cdk.propertyValidator('windowId', cdk.validateString)(properties.windowId));
    return errors.wrap('supplied properties not correct for "CfnMaintenanceWindowTargetProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTarget` resource
 *
 * @param properties - the TypeScript properties of a `CfnMaintenanceWindowTargetProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTarget` resource.
 */
// @ts-ignore TS6133
function cfnMaintenanceWindowTargetPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMaintenanceWindowTargetPropsValidator(properties).assertSuccess();
    return {
        ResourceType: cdk.stringToCloudFormation(properties.resourceType),
        Targets: cdk.listMapper(cfnMaintenanceWindowTargetTargetsPropertyToCloudFormation)(properties.targets),
        WindowId: cdk.stringToCloudFormation(properties.windowId),
        Description: cdk.stringToCloudFormation(properties.description),
        Name: cdk.stringToCloudFormation(properties.name),
        OwnerInformation: cdk.stringToCloudFormation(properties.ownerInformation),
    };
}
// @ts-ignore TS6133
function CfnMaintenanceWindowTargetPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('resourceType', 'ResourceType', cfn_parse.FromCloudFormation.getString(properties.ResourceType));
    ret.addPropertyResult('targets', 'Targets', cfn_parse.FromCloudFormation.getArray(CfnMaintenanceWindowTargetTargetsPropertyFromCloudFormation)(properties.Targets));
    ret.addPropertyResult('windowId', 'WindowId', cfn_parse.FromCloudFormation.getString(properties.WindowId));
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('ownerInformation', 'OwnerInformation', properties.OwnerInformation != null ? cfn_parse.FromCloudFormation.getString(properties.OwnerInformation) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SSM::MaintenanceWindowTarget`
 *
 * The `AWS::SSM::MaintenanceWindowTarget` resource registers a target with a maintenance window for AWS Systems Manager . For more information, see [RegisterTargetWithMaintenanceWindow](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_RegisterTargetWithMaintenanceWindow.html) in the *AWS Systems Manager API Reference* .
 *
 * @cloudformationResource AWS::SSM::MaintenanceWindowTarget
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtarget.html
 */
class CfnMaintenanceWindowTarget extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnMaintenanceWindowTargetPropsFromCloudFormation(resourceProperties);
        const ret = new CfnMaintenanceWindowTarget(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::SSM::MaintenanceWindowTarget`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnMaintenanceWindowTarget.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ssm_CfnMaintenanceWindowTargetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnMaintenanceWindowTarget);
            }
            throw error;
        }
        cdk.requireProperty(props, 'resourceType', this);
        cdk.requireProperty(props, 'targets', this);
        cdk.requireProperty(props, 'windowId', this);
        this.resourceType = props.resourceType;
        this.targets = props.targets;
        this.windowId = props.windowId;
        this.description = props.description;
        this.name = props.name;
        this.ownerInformation = props.ownerInformation;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnMaintenanceWindowTarget.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            resourceType: this.resourceType,
            targets: this.targets,
            windowId: this.windowId,
            description: this.description,
            name: this.name,
            ownerInformation: this.ownerInformation,
        };
    }
    renderProperties(props) {
        return cfnMaintenanceWindowTargetPropsToCloudFormation(props);
    }
}
_d = JSII_RTTI_SYMBOL_1;
CfnMaintenanceWindowTarget[_d] = { fqn: "aws-cdk-lib.aws_ssm.CfnMaintenanceWindowTarget", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnMaintenanceWindowTarget.CFN_RESOURCE_TYPE_NAME = "AWS::SSM::MaintenanceWindowTarget";
exports.CfnMaintenanceWindowTarget = CfnMaintenanceWindowTarget;
/**
 * Determine whether the given properties match those of a `TargetsProperty`
 *
 * @param properties - the TypeScript properties of a `TargetsProperty`
 *
 * @returns the result of the validation.
 */
function CfnMaintenanceWindowTarget_TargetsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('key', cdk.requiredValidator)(properties.key));
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('values', cdk.requiredValidator)(properties.values));
    errors.collect(cdk.propertyValidator('values', cdk.listValidator(cdk.validateString))(properties.values));
    return errors.wrap('supplied properties not correct for "TargetsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTarget.Targets` resource
 *
 * @param properties - the TypeScript properties of a `TargetsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTarget.Targets` resource.
 */
// @ts-ignore TS6133
function cfnMaintenanceWindowTargetTargetsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMaintenanceWindowTarget_TargetsPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Values: cdk.listMapper(cdk.stringToCloudFormation)(properties.values),
    };
}
// @ts-ignore TS6133
function CfnMaintenanceWindowTargetTargetsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('key', 'Key', cfn_parse.FromCloudFormation.getString(properties.Key));
    ret.addPropertyResult('values', 'Values', cfn_parse.FromCloudFormation.getStringArray(properties.Values));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnMaintenanceWindowTaskProps`
 *
 * @param properties - the TypeScript properties of a `CfnMaintenanceWindowTaskProps`
 *
 * @returns the result of the validation.
 */
function CfnMaintenanceWindowTaskPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cutoffBehavior', cdk.validateString)(properties.cutoffBehavior));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('loggingInfo', CfnMaintenanceWindowTask_LoggingInfoPropertyValidator)(properties.loggingInfo));
    errors.collect(cdk.propertyValidator('maxConcurrency', cdk.validateString)(properties.maxConcurrency));
    errors.collect(cdk.propertyValidator('maxErrors', cdk.validateString)(properties.maxErrors));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('priority', cdk.requiredValidator)(properties.priority));
    errors.collect(cdk.propertyValidator('priority', cdk.validateNumber)(properties.priority));
    errors.collect(cdk.propertyValidator('serviceRoleArn', cdk.validateString)(properties.serviceRoleArn));
    errors.collect(cdk.propertyValidator('targets', cdk.listValidator(CfnMaintenanceWindowTask_TargetPropertyValidator))(properties.targets));
    errors.collect(cdk.propertyValidator('taskArn', cdk.requiredValidator)(properties.taskArn));
    errors.collect(cdk.propertyValidator('taskArn', cdk.validateString)(properties.taskArn));
    errors.collect(cdk.propertyValidator('taskInvocationParameters', CfnMaintenanceWindowTask_TaskInvocationParametersPropertyValidator)(properties.taskInvocationParameters));
    errors.collect(cdk.propertyValidator('taskParameters', cdk.validateObject)(properties.taskParameters));
    errors.collect(cdk.propertyValidator('taskType', cdk.requiredValidator)(properties.taskType));
    errors.collect(cdk.propertyValidator('taskType', cdk.validateString)(properties.taskType));
    errors.collect(cdk.propertyValidator('windowId', cdk.requiredValidator)(properties.windowId));
    errors.collect(cdk.propertyValidator('windowId', cdk.validateString)(properties.windowId));
    return errors.wrap('supplied properties not correct for "CfnMaintenanceWindowTaskProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask` resource
 *
 * @param properties - the TypeScript properties of a `CfnMaintenanceWindowTaskProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask` resource.
 */
// @ts-ignore TS6133
function cfnMaintenanceWindowTaskPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMaintenanceWindowTaskPropsValidator(properties).assertSuccess();
    return {
        Priority: cdk.numberToCloudFormation(properties.priority),
        TaskArn: cdk.stringToCloudFormation(properties.taskArn),
        TaskType: cdk.stringToCloudFormation(properties.taskType),
        WindowId: cdk.stringToCloudFormation(properties.windowId),
        CutoffBehavior: cdk.stringToCloudFormation(properties.cutoffBehavior),
        Description: cdk.stringToCloudFormation(properties.description),
        LoggingInfo: cfnMaintenanceWindowTaskLoggingInfoPropertyToCloudFormation(properties.loggingInfo),
        MaxConcurrency: cdk.stringToCloudFormation(properties.maxConcurrency),
        MaxErrors: cdk.stringToCloudFormation(properties.maxErrors),
        Name: cdk.stringToCloudFormation(properties.name),
        ServiceRoleArn: cdk.stringToCloudFormation(properties.serviceRoleArn),
        Targets: cdk.listMapper(cfnMaintenanceWindowTaskTargetPropertyToCloudFormation)(properties.targets),
        TaskInvocationParameters: cfnMaintenanceWindowTaskTaskInvocationParametersPropertyToCloudFormation(properties.taskInvocationParameters),
        TaskParameters: cdk.objectToCloudFormation(properties.taskParameters),
    };
}
// @ts-ignore TS6133
function CfnMaintenanceWindowTaskPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('priority', 'Priority', cfn_parse.FromCloudFormation.getNumber(properties.Priority));
    ret.addPropertyResult('taskArn', 'TaskArn', cfn_parse.FromCloudFormation.getString(properties.TaskArn));
    ret.addPropertyResult('taskType', 'TaskType', cfn_parse.FromCloudFormation.getString(properties.TaskType));
    ret.addPropertyResult('windowId', 'WindowId', cfn_parse.FromCloudFormation.getString(properties.WindowId));
    ret.addPropertyResult('cutoffBehavior', 'CutoffBehavior', properties.CutoffBehavior != null ? cfn_parse.FromCloudFormation.getString(properties.CutoffBehavior) : undefined);
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('loggingInfo', 'LoggingInfo', properties.LoggingInfo != null ? CfnMaintenanceWindowTaskLoggingInfoPropertyFromCloudFormation(properties.LoggingInfo) : undefined);
    ret.addPropertyResult('maxConcurrency', 'MaxConcurrency', properties.MaxConcurrency != null ? cfn_parse.FromCloudFormation.getString(properties.MaxConcurrency) : undefined);
    ret.addPropertyResult('maxErrors', 'MaxErrors', properties.MaxErrors != null ? cfn_parse.FromCloudFormation.getString(properties.MaxErrors) : undefined);
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('serviceRoleArn', 'ServiceRoleArn', properties.ServiceRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.ServiceRoleArn) : undefined);
    ret.addPropertyResult('targets', 'Targets', properties.Targets != null ? cfn_parse.FromCloudFormation.getArray(CfnMaintenanceWindowTaskTargetPropertyFromCloudFormation)(properties.Targets) : undefined);
    ret.addPropertyResult('taskInvocationParameters', 'TaskInvocationParameters', properties.TaskInvocationParameters != null ? CfnMaintenanceWindowTaskTaskInvocationParametersPropertyFromCloudFormation(properties.TaskInvocationParameters) : undefined);
    ret.addPropertyResult('taskParameters', 'TaskParameters', properties.TaskParameters != null ? cfn_parse.FromCloudFormation.getAny(properties.TaskParameters) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SSM::MaintenanceWindowTask`
 *
 * The `AWS::SSM::MaintenanceWindowTask` resource defines information about a task for an AWS Systems Manager maintenance window. For more information, see [RegisterTaskWithMaintenanceWindow](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_RegisterTaskWithMaintenanceWindow.html) in the *AWS Systems Manager API Reference* .
 *
 * @cloudformationResource AWS::SSM::MaintenanceWindowTask
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html
 */
class CfnMaintenanceWindowTask extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnMaintenanceWindowTaskPropsFromCloudFormation(resourceProperties);
        const ret = new CfnMaintenanceWindowTask(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::SSM::MaintenanceWindowTask`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnMaintenanceWindowTask.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ssm_CfnMaintenanceWindowTaskProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnMaintenanceWindowTask);
            }
            throw error;
        }
        cdk.requireProperty(props, 'priority', this);
        cdk.requireProperty(props, 'taskArn', this);
        cdk.requireProperty(props, 'taskType', this);
        cdk.requireProperty(props, 'windowId', this);
        this.priority = props.priority;
        this.taskArn = props.taskArn;
        this.taskType = props.taskType;
        this.windowId = props.windowId;
        this.cutoffBehavior = props.cutoffBehavior;
        this.description = props.description;
        this.loggingInfo = props.loggingInfo;
        this.maxConcurrency = props.maxConcurrency;
        this.maxErrors = props.maxErrors;
        this.name = props.name;
        this.serviceRoleArn = props.serviceRoleArn;
        this.targets = props.targets;
        this.taskInvocationParameters = props.taskInvocationParameters;
        this.taskParameters = props.taskParameters;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnMaintenanceWindowTask.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            priority: this.priority,
            taskArn: this.taskArn,
            taskType: this.taskType,
            windowId: this.windowId,
            cutoffBehavior: this.cutoffBehavior,
            description: this.description,
            loggingInfo: this.loggingInfo,
            maxConcurrency: this.maxConcurrency,
            maxErrors: this.maxErrors,
            name: this.name,
            serviceRoleArn: this.serviceRoleArn,
            targets: this.targets,
            taskInvocationParameters: this.taskInvocationParameters,
            taskParameters: this.taskParameters,
        };
    }
    renderProperties(props) {
        return cfnMaintenanceWindowTaskPropsToCloudFormation(props);
    }
}
_e = JSII_RTTI_SYMBOL_1;
CfnMaintenanceWindowTask[_e] = { fqn: "aws-cdk-lib.aws_ssm.CfnMaintenanceWindowTask", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnMaintenanceWindowTask.CFN_RESOURCE_TYPE_NAME = "AWS::SSM::MaintenanceWindowTask";
exports.CfnMaintenanceWindowTask = CfnMaintenanceWindowTask;
/**
 * Determine whether the given properties match those of a `CloudWatchOutputConfigProperty`
 *
 * @param properties - the TypeScript properties of a `CloudWatchOutputConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnMaintenanceWindowTask_CloudWatchOutputConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cloudWatchLogGroupName', cdk.validateString)(properties.cloudWatchLogGroupName));
    errors.collect(cdk.propertyValidator('cloudWatchOutputEnabled', cdk.validateBoolean)(properties.cloudWatchOutputEnabled));
    return errors.wrap('supplied properties not correct for "CloudWatchOutputConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask.CloudWatchOutputConfig` resource
 *
 * @param properties - the TypeScript properties of a `CloudWatchOutputConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask.CloudWatchOutputConfig` resource.
 */
// @ts-ignore TS6133
function cfnMaintenanceWindowTaskCloudWatchOutputConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMaintenanceWindowTask_CloudWatchOutputConfigPropertyValidator(properties).assertSuccess();
    return {
        CloudWatchLogGroupName: cdk.stringToCloudFormation(properties.cloudWatchLogGroupName),
        CloudWatchOutputEnabled: cdk.booleanToCloudFormation(properties.cloudWatchOutputEnabled),
    };
}
// @ts-ignore TS6133
function CfnMaintenanceWindowTaskCloudWatchOutputConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('cloudWatchLogGroupName', 'CloudWatchLogGroupName', properties.CloudWatchLogGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.CloudWatchLogGroupName) : undefined);
    ret.addPropertyResult('cloudWatchOutputEnabled', 'CloudWatchOutputEnabled', properties.CloudWatchOutputEnabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.CloudWatchOutputEnabled) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LoggingInfoProperty`
 *
 * @param properties - the TypeScript properties of a `LoggingInfoProperty`
 *
 * @returns the result of the validation.
 */
function CfnMaintenanceWindowTask_LoggingInfoPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('region', cdk.requiredValidator)(properties.region));
    errors.collect(cdk.propertyValidator('region', cdk.validateString)(properties.region));
    errors.collect(cdk.propertyValidator('s3Bucket', cdk.requiredValidator)(properties.s3Bucket));
    errors.collect(cdk.propertyValidator('s3Bucket', cdk.validateString)(properties.s3Bucket));
    errors.collect(cdk.propertyValidator('s3Prefix', cdk.validateString)(properties.s3Prefix));
    return errors.wrap('supplied properties not correct for "LoggingInfoProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask.LoggingInfo` resource
 *
 * @param properties - the TypeScript properties of a `LoggingInfoProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask.LoggingInfo` resource.
 */
// @ts-ignore TS6133
function cfnMaintenanceWindowTaskLoggingInfoPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMaintenanceWindowTask_LoggingInfoPropertyValidator(properties).assertSuccess();
    return {
        Region: cdk.stringToCloudFormation(properties.region),
        S3Bucket: cdk.stringToCloudFormation(properties.s3Bucket),
        S3Prefix: cdk.stringToCloudFormation(properties.s3Prefix),
    };
}
// @ts-ignore TS6133
function CfnMaintenanceWindowTaskLoggingInfoPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('region', 'Region', cfn_parse.FromCloudFormation.getString(properties.Region));
    ret.addPropertyResult('s3Bucket', 'S3Bucket', cfn_parse.FromCloudFormation.getString(properties.S3Bucket));
    ret.addPropertyResult('s3Prefix', 'S3Prefix', properties.S3Prefix != null ? cfn_parse.FromCloudFormation.getString(properties.S3Prefix) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MaintenanceWindowAutomationParametersProperty`
 *
 * @param properties - the TypeScript properties of a `MaintenanceWindowAutomationParametersProperty`
 *
 * @returns the result of the validation.
 */
function CfnMaintenanceWindowTask_MaintenanceWindowAutomationParametersPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('documentVersion', cdk.validateString)(properties.documentVersion));
    errors.collect(cdk.propertyValidator('parameters', cdk.validateObject)(properties.parameters));
    return errors.wrap('supplied properties not correct for "MaintenanceWindowAutomationParametersProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask.MaintenanceWindowAutomationParameters` resource
 *
 * @param properties - the TypeScript properties of a `MaintenanceWindowAutomationParametersProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask.MaintenanceWindowAutomationParameters` resource.
 */
// @ts-ignore TS6133
function cfnMaintenanceWindowTaskMaintenanceWindowAutomationParametersPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMaintenanceWindowTask_MaintenanceWindowAutomationParametersPropertyValidator(properties).assertSuccess();
    return {
        DocumentVersion: cdk.stringToCloudFormation(properties.documentVersion),
        Parameters: cdk.objectToCloudFormation(properties.parameters),
    };
}
// @ts-ignore TS6133
function CfnMaintenanceWindowTaskMaintenanceWindowAutomationParametersPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('documentVersion', 'DocumentVersion', properties.DocumentVersion != null ? cfn_parse.FromCloudFormation.getString(properties.DocumentVersion) : undefined);
    ret.addPropertyResult('parameters', 'Parameters', properties.Parameters != null ? cfn_parse.FromCloudFormation.getAny(properties.Parameters) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MaintenanceWindowLambdaParametersProperty`
 *
 * @param properties - the TypeScript properties of a `MaintenanceWindowLambdaParametersProperty`
 *
 * @returns the result of the validation.
 */
function CfnMaintenanceWindowTask_MaintenanceWindowLambdaParametersPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('clientContext', cdk.validateString)(properties.clientContext));
    errors.collect(cdk.propertyValidator('payload', cdk.validateString)(properties.payload));
    errors.collect(cdk.propertyValidator('qualifier', cdk.validateString)(properties.qualifier));
    return errors.wrap('supplied properties not correct for "MaintenanceWindowLambdaParametersProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask.MaintenanceWindowLambdaParameters` resource
 *
 * @param properties - the TypeScript properties of a `MaintenanceWindowLambdaParametersProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask.MaintenanceWindowLambdaParameters` resource.
 */
// @ts-ignore TS6133
function cfnMaintenanceWindowTaskMaintenanceWindowLambdaParametersPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMaintenanceWindowTask_MaintenanceWindowLambdaParametersPropertyValidator(properties).assertSuccess();
    return {
        ClientContext: cdk.stringToCloudFormation(properties.clientContext),
        Payload: cdk.stringToCloudFormation(properties.payload),
        Qualifier: cdk.stringToCloudFormation(properties.qualifier),
    };
}
// @ts-ignore TS6133
function CfnMaintenanceWindowTaskMaintenanceWindowLambdaParametersPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('clientContext', 'ClientContext', properties.ClientContext != null ? cfn_parse.FromCloudFormation.getString(properties.ClientContext) : undefined);
    ret.addPropertyResult('payload', 'Payload', properties.Payload != null ? cfn_parse.FromCloudFormation.getString(properties.Payload) : undefined);
    ret.addPropertyResult('qualifier', 'Qualifier', properties.Qualifier != null ? cfn_parse.FromCloudFormation.getString(properties.Qualifier) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MaintenanceWindowRunCommandParametersProperty`
 *
 * @param properties - the TypeScript properties of a `MaintenanceWindowRunCommandParametersProperty`
 *
 * @returns the result of the validation.
 */
function CfnMaintenanceWindowTask_MaintenanceWindowRunCommandParametersPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cloudWatchOutputConfig', CfnMaintenanceWindowTask_CloudWatchOutputConfigPropertyValidator)(properties.cloudWatchOutputConfig));
    errors.collect(cdk.propertyValidator('comment', cdk.validateString)(properties.comment));
    errors.collect(cdk.propertyValidator('documentHash', cdk.validateString)(properties.documentHash));
    errors.collect(cdk.propertyValidator('documentHashType', cdk.validateString)(properties.documentHashType));
    errors.collect(cdk.propertyValidator('documentVersion', cdk.validateString)(properties.documentVersion));
    errors.collect(cdk.propertyValidator('notificationConfig', CfnMaintenanceWindowTask_NotificationConfigPropertyValidator)(properties.notificationConfig));
    errors.collect(cdk.propertyValidator('outputS3BucketName', cdk.validateString)(properties.outputS3BucketName));
    errors.collect(cdk.propertyValidator('outputS3KeyPrefix', cdk.validateString)(properties.outputS3KeyPrefix));
    errors.collect(cdk.propertyValidator('parameters', cdk.validateObject)(properties.parameters));
    errors.collect(cdk.propertyValidator('serviceRoleArn', cdk.validateString)(properties.serviceRoleArn));
    errors.collect(cdk.propertyValidator('timeoutSeconds', cdk.validateNumber)(properties.timeoutSeconds));
    return errors.wrap('supplied properties not correct for "MaintenanceWindowRunCommandParametersProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask.MaintenanceWindowRunCommandParameters` resource
 *
 * @param properties - the TypeScript properties of a `MaintenanceWindowRunCommandParametersProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask.MaintenanceWindowRunCommandParameters` resource.
 */
// @ts-ignore TS6133
function cfnMaintenanceWindowTaskMaintenanceWindowRunCommandParametersPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMaintenanceWindowTask_MaintenanceWindowRunCommandParametersPropertyValidator(properties).assertSuccess();
    return {
        CloudWatchOutputConfig: cfnMaintenanceWindowTaskCloudWatchOutputConfigPropertyToCloudFormation(properties.cloudWatchOutputConfig),
        Comment: cdk.stringToCloudFormation(properties.comment),
        DocumentHash: cdk.stringToCloudFormation(properties.documentHash),
        DocumentHashType: cdk.stringToCloudFormation(properties.documentHashType),
        DocumentVersion: cdk.stringToCloudFormation(properties.documentVersion),
        NotificationConfig: cfnMaintenanceWindowTaskNotificationConfigPropertyToCloudFormation(properties.notificationConfig),
        OutputS3BucketName: cdk.stringToCloudFormation(properties.outputS3BucketName),
        OutputS3KeyPrefix: cdk.stringToCloudFormation(properties.outputS3KeyPrefix),
        Parameters: cdk.objectToCloudFormation(properties.parameters),
        ServiceRoleArn: cdk.stringToCloudFormation(properties.serviceRoleArn),
        TimeoutSeconds: cdk.numberToCloudFormation(properties.timeoutSeconds),
    };
}
// @ts-ignore TS6133
function CfnMaintenanceWindowTaskMaintenanceWindowRunCommandParametersPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('cloudWatchOutputConfig', 'CloudWatchOutputConfig', properties.CloudWatchOutputConfig != null ? CfnMaintenanceWindowTaskCloudWatchOutputConfigPropertyFromCloudFormation(properties.CloudWatchOutputConfig) : undefined);
    ret.addPropertyResult('comment', 'Comment', properties.Comment != null ? cfn_parse.FromCloudFormation.getString(properties.Comment) : undefined);
    ret.addPropertyResult('documentHash', 'DocumentHash', properties.DocumentHash != null ? cfn_parse.FromCloudFormation.getString(properties.DocumentHash) : undefined);
    ret.addPropertyResult('documentHashType', 'DocumentHashType', properties.DocumentHashType != null ? cfn_parse.FromCloudFormation.getString(properties.DocumentHashType) : undefined);
    ret.addPropertyResult('documentVersion', 'DocumentVersion', properties.DocumentVersion != null ? cfn_parse.FromCloudFormation.getString(properties.DocumentVersion) : undefined);
    ret.addPropertyResult('notificationConfig', 'NotificationConfig', properties.NotificationConfig != null ? CfnMaintenanceWindowTaskNotificationConfigPropertyFromCloudFormation(properties.NotificationConfig) : undefined);
    ret.addPropertyResult('outputS3BucketName', 'OutputS3BucketName', properties.OutputS3BucketName != null ? cfn_parse.FromCloudFormation.getString(properties.OutputS3BucketName) : undefined);
    ret.addPropertyResult('outputS3KeyPrefix', 'OutputS3KeyPrefix', properties.OutputS3KeyPrefix != null ? cfn_parse.FromCloudFormation.getString(properties.OutputS3KeyPrefix) : undefined);
    ret.addPropertyResult('parameters', 'Parameters', properties.Parameters != null ? cfn_parse.FromCloudFormation.getAny(properties.Parameters) : undefined);
    ret.addPropertyResult('serviceRoleArn', 'ServiceRoleArn', properties.ServiceRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.ServiceRoleArn) : undefined);
    ret.addPropertyResult('timeoutSeconds', 'TimeoutSeconds', properties.TimeoutSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.TimeoutSeconds) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MaintenanceWindowStepFunctionsParametersProperty`
 *
 * @param properties - the TypeScript properties of a `MaintenanceWindowStepFunctionsParametersProperty`
 *
 * @returns the result of the validation.
 */
function CfnMaintenanceWindowTask_MaintenanceWindowStepFunctionsParametersPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('input', cdk.validateString)(properties.input));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    return errors.wrap('supplied properties not correct for "MaintenanceWindowStepFunctionsParametersProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask.MaintenanceWindowStepFunctionsParameters` resource
 *
 * @param properties - the TypeScript properties of a `MaintenanceWindowStepFunctionsParametersProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask.MaintenanceWindowStepFunctionsParameters` resource.
 */
// @ts-ignore TS6133
function cfnMaintenanceWindowTaskMaintenanceWindowStepFunctionsParametersPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMaintenanceWindowTask_MaintenanceWindowStepFunctionsParametersPropertyValidator(properties).assertSuccess();
    return {
        Input: cdk.stringToCloudFormation(properties.input),
        Name: cdk.stringToCloudFormation(properties.name),
    };
}
// @ts-ignore TS6133
function CfnMaintenanceWindowTaskMaintenanceWindowStepFunctionsParametersPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('input', 'Input', properties.Input != null ? cfn_parse.FromCloudFormation.getString(properties.Input) : undefined);
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NotificationConfigProperty`
 *
 * @param properties - the TypeScript properties of a `NotificationConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnMaintenanceWindowTask_NotificationConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('notificationArn', cdk.requiredValidator)(properties.notificationArn));
    errors.collect(cdk.propertyValidator('notificationArn', cdk.validateString)(properties.notificationArn));
    errors.collect(cdk.propertyValidator('notificationEvents', cdk.listValidator(cdk.validateString))(properties.notificationEvents));
    errors.collect(cdk.propertyValidator('notificationType', cdk.validateString)(properties.notificationType));
    return errors.wrap('supplied properties not correct for "NotificationConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask.NotificationConfig` resource
 *
 * @param properties - the TypeScript properties of a `NotificationConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask.NotificationConfig` resource.
 */
// @ts-ignore TS6133
function cfnMaintenanceWindowTaskNotificationConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMaintenanceWindowTask_NotificationConfigPropertyValidator(properties).assertSuccess();
    return {
        NotificationArn: cdk.stringToCloudFormation(properties.notificationArn),
        NotificationEvents: cdk.listMapper(cdk.stringToCloudFormation)(properties.notificationEvents),
        NotificationType: cdk.stringToCloudFormation(properties.notificationType),
    };
}
// @ts-ignore TS6133
function CfnMaintenanceWindowTaskNotificationConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('notificationArn', 'NotificationArn', cfn_parse.FromCloudFormation.getString(properties.NotificationArn));
    ret.addPropertyResult('notificationEvents', 'NotificationEvents', properties.NotificationEvents != null ? cfn_parse.FromCloudFormation.getStringArray(properties.NotificationEvents) : undefined);
    ret.addPropertyResult('notificationType', 'NotificationType', properties.NotificationType != null ? cfn_parse.FromCloudFormation.getString(properties.NotificationType) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `TargetProperty`
 *
 * @param properties - the TypeScript properties of a `TargetProperty`
 *
 * @returns the result of the validation.
 */
function CfnMaintenanceWindowTask_TargetPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('key', cdk.requiredValidator)(properties.key));
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('values', cdk.requiredValidator)(properties.values));
    errors.collect(cdk.propertyValidator('values', cdk.listValidator(cdk.validateString))(properties.values));
    return errors.wrap('supplied properties not correct for "TargetProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask.Target` resource
 *
 * @param properties - the TypeScript properties of a `TargetProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask.Target` resource.
 */
// @ts-ignore TS6133
function cfnMaintenanceWindowTaskTargetPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMaintenanceWindowTask_TargetPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Values: cdk.listMapper(cdk.stringToCloudFormation)(properties.values),
    };
}
// @ts-ignore TS6133
function CfnMaintenanceWindowTaskTargetPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('key', 'Key', cfn_parse.FromCloudFormation.getString(properties.Key));
    ret.addPropertyResult('values', 'Values', cfn_parse.FromCloudFormation.getStringArray(properties.Values));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `TaskInvocationParametersProperty`
 *
 * @param properties - the TypeScript properties of a `TaskInvocationParametersProperty`
 *
 * @returns the result of the validation.
 */
function CfnMaintenanceWindowTask_TaskInvocationParametersPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('maintenanceWindowAutomationParameters', CfnMaintenanceWindowTask_MaintenanceWindowAutomationParametersPropertyValidator)(properties.maintenanceWindowAutomationParameters));
    errors.collect(cdk.propertyValidator('maintenanceWindowLambdaParameters', CfnMaintenanceWindowTask_MaintenanceWindowLambdaParametersPropertyValidator)(properties.maintenanceWindowLambdaParameters));
    errors.collect(cdk.propertyValidator('maintenanceWindowRunCommandParameters', CfnMaintenanceWindowTask_MaintenanceWindowRunCommandParametersPropertyValidator)(properties.maintenanceWindowRunCommandParameters));
    errors.collect(cdk.propertyValidator('maintenanceWindowStepFunctionsParameters', CfnMaintenanceWindowTask_MaintenanceWindowStepFunctionsParametersPropertyValidator)(properties.maintenanceWindowStepFunctionsParameters));
    return errors.wrap('supplied properties not correct for "TaskInvocationParametersProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask.TaskInvocationParameters` resource
 *
 * @param properties - the TypeScript properties of a `TaskInvocationParametersProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::MaintenanceWindowTask.TaskInvocationParameters` resource.
 */
// @ts-ignore TS6133
function cfnMaintenanceWindowTaskTaskInvocationParametersPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMaintenanceWindowTask_TaskInvocationParametersPropertyValidator(properties).assertSuccess();
    return {
        MaintenanceWindowAutomationParameters: cfnMaintenanceWindowTaskMaintenanceWindowAutomationParametersPropertyToCloudFormation(properties.maintenanceWindowAutomationParameters),
        MaintenanceWindowLambdaParameters: cfnMaintenanceWindowTaskMaintenanceWindowLambdaParametersPropertyToCloudFormation(properties.maintenanceWindowLambdaParameters),
        MaintenanceWindowRunCommandParameters: cfnMaintenanceWindowTaskMaintenanceWindowRunCommandParametersPropertyToCloudFormation(properties.maintenanceWindowRunCommandParameters),
        MaintenanceWindowStepFunctionsParameters: cfnMaintenanceWindowTaskMaintenanceWindowStepFunctionsParametersPropertyToCloudFormation(properties.maintenanceWindowStepFunctionsParameters),
    };
}
// @ts-ignore TS6133
function CfnMaintenanceWindowTaskTaskInvocationParametersPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('maintenanceWindowAutomationParameters', 'MaintenanceWindowAutomationParameters', properties.MaintenanceWindowAutomationParameters != null ? CfnMaintenanceWindowTaskMaintenanceWindowAutomationParametersPropertyFromCloudFormation(properties.MaintenanceWindowAutomationParameters) : undefined);
    ret.addPropertyResult('maintenanceWindowLambdaParameters', 'MaintenanceWindowLambdaParameters', properties.MaintenanceWindowLambdaParameters != null ? CfnMaintenanceWindowTaskMaintenanceWindowLambdaParametersPropertyFromCloudFormation(properties.MaintenanceWindowLambdaParameters) : undefined);
    ret.addPropertyResult('maintenanceWindowRunCommandParameters', 'MaintenanceWindowRunCommandParameters', properties.MaintenanceWindowRunCommandParameters != null ? CfnMaintenanceWindowTaskMaintenanceWindowRunCommandParametersPropertyFromCloudFormation(properties.MaintenanceWindowRunCommandParameters) : undefined);
    ret.addPropertyResult('maintenanceWindowStepFunctionsParameters', 'MaintenanceWindowStepFunctionsParameters', properties.MaintenanceWindowStepFunctionsParameters != null ? CfnMaintenanceWindowTaskMaintenanceWindowStepFunctionsParametersPropertyFromCloudFormation(properties.MaintenanceWindowStepFunctionsParameters) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnParameterProps`
 *
 * @param properties - the TypeScript properties of a `CfnParameterProps`
 *
 * @returns the result of the validation.
 */
function CfnParameterPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('allowedPattern', cdk.validateString)(properties.allowedPattern));
    errors.collect(cdk.propertyValidator('dataType', cdk.validateString)(properties.dataType));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('policies', cdk.validateString)(properties.policies));
    errors.collect(cdk.propertyValidator('tags', cdk.validateObject)(properties.tags));
    errors.collect(cdk.propertyValidator('tier', cdk.validateString)(properties.tier));
    errors.collect(cdk.propertyValidator('type', cdk.requiredValidator)(properties.type));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    errors.collect(cdk.propertyValidator('value', cdk.requiredValidator)(properties.value));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "CfnParameterProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::Parameter` resource
 *
 * @param properties - the TypeScript properties of a `CfnParameterProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::Parameter` resource.
 */
// @ts-ignore TS6133
function cfnParameterPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnParameterPropsValidator(properties).assertSuccess();
    return {
        Type: cdk.stringToCloudFormation(properties.type),
        Value: cdk.stringToCloudFormation(properties.value),
        AllowedPattern: cdk.stringToCloudFormation(properties.allowedPattern),
        DataType: cdk.stringToCloudFormation(properties.dataType),
        Description: cdk.stringToCloudFormation(properties.description),
        Name: cdk.stringToCloudFormation(properties.name),
        Policies: cdk.stringToCloudFormation(properties.policies),
        Tags: cdk.objectToCloudFormation(properties.tags),
        Tier: cdk.stringToCloudFormation(properties.tier),
    };
}
// @ts-ignore TS6133
function CfnParameterPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('type', 'Type', cfn_parse.FromCloudFormation.getString(properties.Type));
    ret.addPropertyResult('value', 'Value', cfn_parse.FromCloudFormation.getString(properties.Value));
    ret.addPropertyResult('allowedPattern', 'AllowedPattern', properties.AllowedPattern != null ? cfn_parse.FromCloudFormation.getString(properties.AllowedPattern) : undefined);
    ret.addPropertyResult('dataType', 'DataType', properties.DataType != null ? cfn_parse.FromCloudFormation.getString(properties.DataType) : undefined);
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('policies', 'Policies', properties.Policies != null ? cfn_parse.FromCloudFormation.getString(properties.Policies) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getAny(properties.Tags) : undefined);
    ret.addPropertyResult('tier', 'Tier', properties.Tier != null ? cfn_parse.FromCloudFormation.getString(properties.Tier) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SSM::Parameter`
 *
 * The `AWS::SSM::Parameter` resource creates an SSM parameter in AWS Systems Manager Parameter Store.
 *
 * > To create an SSM parameter, you must have the AWS Identity and Access Management ( IAM ) permissions `ssm:PutParameter` and `ssm:AddTagsToResource` . On stack creation, AWS CloudFormation adds the following three tags to the parameter: `aws:cloudformation:stack-name` , `aws:cloudformation:logical-id` , and `aws:cloudformation:stack-id` , in addition to any custom tags you specify.
 * >
 * > To add, update, or remove tags during stack update, you must have IAM permissions for both `ssm:AddTagsToResource` and `ssm:RemoveTagsFromResource` . For more information, see [Managing Access Using Policies](https://docs.aws.amazon.com/systems-manager/latest/userguide/security-iam.html#security_iam_access-manage) in the *AWS Systems Manager User Guide* .
 *
 * For information about valid values for parameters, see [Requirements and Constraints for Parameter Names](https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-su-create.html#sysman-parameter-name-constraints) in the *AWS Systems Manager User Guide* and [PutParameter](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PutParameter.html) in the *AWS Systems Manager API Reference* .
 *
 * @cloudformationResource AWS::SSM::Parameter
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-parameter.html
 */
class CfnParameter extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnParameterPropsFromCloudFormation(resourceProperties);
        const ret = new CfnParameter(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::SSM::Parameter`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnParameter.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ssm_CfnParameterProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnParameter);
            }
            throw error;
        }
        cdk.requireProperty(props, 'type', this);
        cdk.requireProperty(props, 'value', this);
        this.attrType = cdk.Token.asString(this.getAtt('Type', cdk.ResolutionTypeHint.STRING));
        this.attrValue = cdk.Token.asString(this.getAtt('Value', cdk.ResolutionTypeHint.STRING));
        this.type = props.type;
        this.value = props.value;
        this.allowedPattern = props.allowedPattern;
        this.dataType = props.dataType;
        this.description = props.description;
        this.name = props.name;
        this.policies = props.policies;
        this.tags = new cdk.TagManager(cdk.TagType.MAP, "AWS::SSM::Parameter", props.tags, { tagPropertyName: 'tags' });
        this.tier = props.tier;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnParameter.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            type: this.type,
            value: this.value,
            allowedPattern: this.allowedPattern,
            dataType: this.dataType,
            description: this.description,
            name: this.name,
            policies: this.policies,
            tags: this.tags.renderTags(),
            tier: this.tier,
        };
    }
    renderProperties(props) {
        return cfnParameterPropsToCloudFormation(props);
    }
}
_f = JSII_RTTI_SYMBOL_1;
CfnParameter[_f] = { fqn: "aws-cdk-lib.aws_ssm.CfnParameter", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnParameter.CFN_RESOURCE_TYPE_NAME = "AWS::SSM::Parameter";
exports.CfnParameter = CfnParameter;
/**
 * Determine whether the given properties match those of a `CfnPatchBaselineProps`
 *
 * @param properties - the TypeScript properties of a `CfnPatchBaselineProps`
 *
 * @returns the result of the validation.
 */
function CfnPatchBaselinePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('approvalRules', CfnPatchBaseline_RuleGroupPropertyValidator)(properties.approvalRules));
    errors.collect(cdk.propertyValidator('approvedPatches', cdk.listValidator(cdk.validateString))(properties.approvedPatches));
    errors.collect(cdk.propertyValidator('approvedPatchesComplianceLevel', cdk.validateString)(properties.approvedPatchesComplianceLevel));
    errors.collect(cdk.propertyValidator('approvedPatchesEnableNonSecurity', cdk.validateBoolean)(properties.approvedPatchesEnableNonSecurity));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('globalFilters', CfnPatchBaseline_PatchFilterGroupPropertyValidator)(properties.globalFilters));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('operatingSystem', cdk.validateString)(properties.operatingSystem));
    errors.collect(cdk.propertyValidator('patchGroups', cdk.listValidator(cdk.validateString))(properties.patchGroups));
    errors.collect(cdk.propertyValidator('rejectedPatches', cdk.listValidator(cdk.validateString))(properties.rejectedPatches));
    errors.collect(cdk.propertyValidator('rejectedPatchesAction', cdk.validateString)(properties.rejectedPatchesAction));
    errors.collect(cdk.propertyValidator('sources', cdk.listValidator(CfnPatchBaseline_PatchSourcePropertyValidator))(properties.sources));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnPatchBaselineProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::PatchBaseline` resource
 *
 * @param properties - the TypeScript properties of a `CfnPatchBaselineProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::PatchBaseline` resource.
 */
// @ts-ignore TS6133
function cfnPatchBaselinePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPatchBaselinePropsValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        ApprovalRules: cfnPatchBaselineRuleGroupPropertyToCloudFormation(properties.approvalRules),
        ApprovedPatches: cdk.listMapper(cdk.stringToCloudFormation)(properties.approvedPatches),
        ApprovedPatchesComplianceLevel: cdk.stringToCloudFormation(properties.approvedPatchesComplianceLevel),
        ApprovedPatchesEnableNonSecurity: cdk.booleanToCloudFormation(properties.approvedPatchesEnableNonSecurity),
        Description: cdk.stringToCloudFormation(properties.description),
        GlobalFilters: cfnPatchBaselinePatchFilterGroupPropertyToCloudFormation(properties.globalFilters),
        OperatingSystem: cdk.stringToCloudFormation(properties.operatingSystem),
        PatchGroups: cdk.listMapper(cdk.stringToCloudFormation)(properties.patchGroups),
        RejectedPatches: cdk.listMapper(cdk.stringToCloudFormation)(properties.rejectedPatches),
        RejectedPatchesAction: cdk.stringToCloudFormation(properties.rejectedPatchesAction),
        Sources: cdk.listMapper(cfnPatchBaselinePatchSourcePropertyToCloudFormation)(properties.sources),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnPatchBaselinePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('approvalRules', 'ApprovalRules', properties.ApprovalRules != null ? CfnPatchBaselineRuleGroupPropertyFromCloudFormation(properties.ApprovalRules) : undefined);
    ret.addPropertyResult('approvedPatches', 'ApprovedPatches', properties.ApprovedPatches != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ApprovedPatches) : undefined);
    ret.addPropertyResult('approvedPatchesComplianceLevel', 'ApprovedPatchesComplianceLevel', properties.ApprovedPatchesComplianceLevel != null ? cfn_parse.FromCloudFormation.getString(properties.ApprovedPatchesComplianceLevel) : undefined);
    ret.addPropertyResult('approvedPatchesEnableNonSecurity', 'ApprovedPatchesEnableNonSecurity', properties.ApprovedPatchesEnableNonSecurity != null ? cfn_parse.FromCloudFormation.getBoolean(properties.ApprovedPatchesEnableNonSecurity) : undefined);
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('globalFilters', 'GlobalFilters', properties.GlobalFilters != null ? CfnPatchBaselinePatchFilterGroupPropertyFromCloudFormation(properties.GlobalFilters) : undefined);
    ret.addPropertyResult('operatingSystem', 'OperatingSystem', properties.OperatingSystem != null ? cfn_parse.FromCloudFormation.getString(properties.OperatingSystem) : undefined);
    ret.addPropertyResult('patchGroups', 'PatchGroups', properties.PatchGroups != null ? cfn_parse.FromCloudFormation.getStringArray(properties.PatchGroups) : undefined);
    ret.addPropertyResult('rejectedPatches', 'RejectedPatches', properties.RejectedPatches != null ? cfn_parse.FromCloudFormation.getStringArray(properties.RejectedPatches) : undefined);
    ret.addPropertyResult('rejectedPatchesAction', 'RejectedPatchesAction', properties.RejectedPatchesAction != null ? cfn_parse.FromCloudFormation.getString(properties.RejectedPatchesAction) : undefined);
    ret.addPropertyResult('sources', 'Sources', properties.Sources != null ? cfn_parse.FromCloudFormation.getArray(CfnPatchBaselinePatchSourcePropertyFromCloudFormation)(properties.Sources) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SSM::PatchBaseline`
 *
 * The `AWS::SSM::PatchBaseline` resource defines the basic information for an AWS Systems Manager patch baseline. A patch baseline defines which patches are approved for installation on your instances.
 *
 * For more information, see [CreatePatchBaseline](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_CreatePatchBaseline.html) in the *AWS Systems Manager API Reference* .
 *
 * @cloudformationResource AWS::SSM::PatchBaseline
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-patchbaseline.html
 */
class CfnPatchBaseline extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnPatchBaselinePropsFromCloudFormation(resourceProperties);
        const ret = new CfnPatchBaseline(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::SSM::PatchBaseline`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnPatchBaseline.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ssm_CfnPatchBaselineProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnPatchBaseline);
            }
            throw error;
        }
        cdk.requireProperty(props, 'name', this);
        this.name = props.name;
        this.approvalRules = props.approvalRules;
        this.approvedPatches = props.approvedPatches;
        this.approvedPatchesComplianceLevel = props.approvedPatchesComplianceLevel;
        this.approvedPatchesEnableNonSecurity = props.approvedPatchesEnableNonSecurity;
        this.description = props.description;
        this.globalFilters = props.globalFilters;
        this.operatingSystem = props.operatingSystem;
        this.patchGroups = props.patchGroups;
        this.rejectedPatches = props.rejectedPatches;
        this.rejectedPatchesAction = props.rejectedPatchesAction;
        this.sources = props.sources;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::SSM::PatchBaseline", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnPatchBaseline.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            name: this.name,
            approvalRules: this.approvalRules,
            approvedPatches: this.approvedPatches,
            approvedPatchesComplianceLevel: this.approvedPatchesComplianceLevel,
            approvedPatchesEnableNonSecurity: this.approvedPatchesEnableNonSecurity,
            description: this.description,
            globalFilters: this.globalFilters,
            operatingSystem: this.operatingSystem,
            patchGroups: this.patchGroups,
            rejectedPatches: this.rejectedPatches,
            rejectedPatchesAction: this.rejectedPatchesAction,
            sources: this.sources,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnPatchBaselinePropsToCloudFormation(props);
    }
}
_g = JSII_RTTI_SYMBOL_1;
CfnPatchBaseline[_g] = { fqn: "aws-cdk-lib.aws_ssm.CfnPatchBaseline", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnPatchBaseline.CFN_RESOURCE_TYPE_NAME = "AWS::SSM::PatchBaseline";
exports.CfnPatchBaseline = CfnPatchBaseline;
/**
 * Determine whether the given properties match those of a `PatchFilterProperty`
 *
 * @param properties - the TypeScript properties of a `PatchFilterProperty`
 *
 * @returns the result of the validation.
 */
function CfnPatchBaseline_PatchFilterPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('values', cdk.listValidator(cdk.validateString))(properties.values));
    return errors.wrap('supplied properties not correct for "PatchFilterProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::PatchBaseline.PatchFilter` resource
 *
 * @param properties - the TypeScript properties of a `PatchFilterProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::PatchBaseline.PatchFilter` resource.
 */
// @ts-ignore TS6133
function cfnPatchBaselinePatchFilterPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPatchBaseline_PatchFilterPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Values: cdk.listMapper(cdk.stringToCloudFormation)(properties.values),
    };
}
// @ts-ignore TS6133
function CfnPatchBaselinePatchFilterPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('key', 'Key', properties.Key != null ? cfn_parse.FromCloudFormation.getString(properties.Key) : undefined);
    ret.addPropertyResult('values', 'Values', properties.Values != null ? cfn_parse.FromCloudFormation.getStringArray(properties.Values) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PatchFilterGroupProperty`
 *
 * @param properties - the TypeScript properties of a `PatchFilterGroupProperty`
 *
 * @returns the result of the validation.
 */
function CfnPatchBaseline_PatchFilterGroupPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('patchFilters', cdk.listValidator(CfnPatchBaseline_PatchFilterPropertyValidator))(properties.patchFilters));
    return errors.wrap('supplied properties not correct for "PatchFilterGroupProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::PatchBaseline.PatchFilterGroup` resource
 *
 * @param properties - the TypeScript properties of a `PatchFilterGroupProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::PatchBaseline.PatchFilterGroup` resource.
 */
// @ts-ignore TS6133
function cfnPatchBaselinePatchFilterGroupPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPatchBaseline_PatchFilterGroupPropertyValidator(properties).assertSuccess();
    return {
        PatchFilters: cdk.listMapper(cfnPatchBaselinePatchFilterPropertyToCloudFormation)(properties.patchFilters),
    };
}
// @ts-ignore TS6133
function CfnPatchBaselinePatchFilterGroupPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('patchFilters', 'PatchFilters', properties.PatchFilters != null ? cfn_parse.FromCloudFormation.getArray(CfnPatchBaselinePatchFilterPropertyFromCloudFormation)(properties.PatchFilters) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PatchSourceProperty`
 *
 * @param properties - the TypeScript properties of a `PatchSourceProperty`
 *
 * @returns the result of the validation.
 */
function CfnPatchBaseline_PatchSourcePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('configuration', cdk.validateString)(properties.configuration));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('products', cdk.listValidator(cdk.validateString))(properties.products));
    return errors.wrap('supplied properties not correct for "PatchSourceProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::PatchBaseline.PatchSource` resource
 *
 * @param properties - the TypeScript properties of a `PatchSourceProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::PatchBaseline.PatchSource` resource.
 */
// @ts-ignore TS6133
function cfnPatchBaselinePatchSourcePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPatchBaseline_PatchSourcePropertyValidator(properties).assertSuccess();
    return {
        Configuration: cdk.stringToCloudFormation(properties.configuration),
        Name: cdk.stringToCloudFormation(properties.name),
        Products: cdk.listMapper(cdk.stringToCloudFormation)(properties.products),
    };
}
// @ts-ignore TS6133
function CfnPatchBaselinePatchSourcePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('configuration', 'Configuration', properties.Configuration != null ? cfn_parse.FromCloudFormation.getString(properties.Configuration) : undefined);
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('products', 'Products', properties.Products != null ? cfn_parse.FromCloudFormation.getStringArray(properties.Products) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `RuleProperty`
 *
 * @param properties - the TypeScript properties of a `RuleProperty`
 *
 * @returns the result of the validation.
 */
function CfnPatchBaseline_RulePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('approveAfterDays', cdk.validateNumber)(properties.approveAfterDays));
    errors.collect(cdk.propertyValidator('approveUntilDate', cdk.validateString)(properties.approveUntilDate));
    errors.collect(cdk.propertyValidator('complianceLevel', cdk.validateString)(properties.complianceLevel));
    errors.collect(cdk.propertyValidator('enableNonSecurity', cdk.validateBoolean)(properties.enableNonSecurity));
    errors.collect(cdk.propertyValidator('patchFilterGroup', CfnPatchBaseline_PatchFilterGroupPropertyValidator)(properties.patchFilterGroup));
    return errors.wrap('supplied properties not correct for "RuleProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::PatchBaseline.Rule` resource
 *
 * @param properties - the TypeScript properties of a `RuleProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::PatchBaseline.Rule` resource.
 */
// @ts-ignore TS6133
function cfnPatchBaselineRulePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPatchBaseline_RulePropertyValidator(properties).assertSuccess();
    return {
        ApproveAfterDays: cdk.numberToCloudFormation(properties.approveAfterDays),
        ApproveUntilDate: cdk.stringToCloudFormation(properties.approveUntilDate),
        ComplianceLevel: cdk.stringToCloudFormation(properties.complianceLevel),
        EnableNonSecurity: cdk.booleanToCloudFormation(properties.enableNonSecurity),
        PatchFilterGroup: cfnPatchBaselinePatchFilterGroupPropertyToCloudFormation(properties.patchFilterGroup),
    };
}
// @ts-ignore TS6133
function CfnPatchBaselineRulePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('approveAfterDays', 'ApproveAfterDays', properties.ApproveAfterDays != null ? cfn_parse.FromCloudFormation.getNumber(properties.ApproveAfterDays) : undefined);
    ret.addPropertyResult('approveUntilDate', 'ApproveUntilDate', properties.ApproveUntilDate != null ? cfn_parse.FromCloudFormation.getString(properties.ApproveUntilDate) : undefined);
    ret.addPropertyResult('complianceLevel', 'ComplianceLevel', properties.ComplianceLevel != null ? cfn_parse.FromCloudFormation.getString(properties.ComplianceLevel) : undefined);
    ret.addPropertyResult('enableNonSecurity', 'EnableNonSecurity', properties.EnableNonSecurity != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableNonSecurity) : undefined);
    ret.addPropertyResult('patchFilterGroup', 'PatchFilterGroup', properties.PatchFilterGroup != null ? CfnPatchBaselinePatchFilterGroupPropertyFromCloudFormation(properties.PatchFilterGroup) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `RuleGroupProperty`
 *
 * @param properties - the TypeScript properties of a `RuleGroupProperty`
 *
 * @returns the result of the validation.
 */
function CfnPatchBaseline_RuleGroupPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('patchRules', cdk.listValidator(CfnPatchBaseline_RulePropertyValidator))(properties.patchRules));
    return errors.wrap('supplied properties not correct for "RuleGroupProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::PatchBaseline.RuleGroup` resource
 *
 * @param properties - the TypeScript properties of a `RuleGroupProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::PatchBaseline.RuleGroup` resource.
 */
// @ts-ignore TS6133
function cfnPatchBaselineRuleGroupPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPatchBaseline_RuleGroupPropertyValidator(properties).assertSuccess();
    return {
        PatchRules: cdk.listMapper(cfnPatchBaselineRulePropertyToCloudFormation)(properties.patchRules),
    };
}
// @ts-ignore TS6133
function CfnPatchBaselineRuleGroupPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('patchRules', 'PatchRules', properties.PatchRules != null ? cfn_parse.FromCloudFormation.getArray(CfnPatchBaselineRulePropertyFromCloudFormation)(properties.PatchRules) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnResourceDataSyncProps`
 *
 * @param properties - the TypeScript properties of a `CfnResourceDataSyncProps`
 *
 * @returns the result of the validation.
 */
function CfnResourceDataSyncPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('bucketName', cdk.validateString)(properties.bucketName));
    errors.collect(cdk.propertyValidator('bucketPrefix', cdk.validateString)(properties.bucketPrefix));
    errors.collect(cdk.propertyValidator('bucketRegion', cdk.validateString)(properties.bucketRegion));
    errors.collect(cdk.propertyValidator('kmsKeyArn', cdk.validateString)(properties.kmsKeyArn));
    errors.collect(cdk.propertyValidator('s3Destination', CfnResourceDataSync_S3DestinationPropertyValidator)(properties.s3Destination));
    errors.collect(cdk.propertyValidator('syncFormat', cdk.validateString)(properties.syncFormat));
    errors.collect(cdk.propertyValidator('syncName', cdk.requiredValidator)(properties.syncName));
    errors.collect(cdk.propertyValidator('syncName', cdk.validateString)(properties.syncName));
    errors.collect(cdk.propertyValidator('syncSource', CfnResourceDataSync_SyncSourcePropertyValidator)(properties.syncSource));
    errors.collect(cdk.propertyValidator('syncType', cdk.validateString)(properties.syncType));
    return errors.wrap('supplied properties not correct for "CfnResourceDataSyncProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::ResourceDataSync` resource
 *
 * @param properties - the TypeScript properties of a `CfnResourceDataSyncProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::ResourceDataSync` resource.
 */
// @ts-ignore TS6133
function cfnResourceDataSyncPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnResourceDataSyncPropsValidator(properties).assertSuccess();
    return {
        SyncName: cdk.stringToCloudFormation(properties.syncName),
        BucketName: cdk.stringToCloudFormation(properties.bucketName),
        BucketPrefix: cdk.stringToCloudFormation(properties.bucketPrefix),
        BucketRegion: cdk.stringToCloudFormation(properties.bucketRegion),
        KMSKeyArn: cdk.stringToCloudFormation(properties.kmsKeyArn),
        S3Destination: cfnResourceDataSyncS3DestinationPropertyToCloudFormation(properties.s3Destination),
        SyncFormat: cdk.stringToCloudFormation(properties.syncFormat),
        SyncSource: cfnResourceDataSyncSyncSourcePropertyToCloudFormation(properties.syncSource),
        SyncType: cdk.stringToCloudFormation(properties.syncType),
    };
}
// @ts-ignore TS6133
function CfnResourceDataSyncPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('syncName', 'SyncName', cfn_parse.FromCloudFormation.getString(properties.SyncName));
    ret.addPropertyResult('bucketName', 'BucketName', properties.BucketName != null ? cfn_parse.FromCloudFormation.getString(properties.BucketName) : undefined);
    ret.addPropertyResult('bucketPrefix', 'BucketPrefix', properties.BucketPrefix != null ? cfn_parse.FromCloudFormation.getString(properties.BucketPrefix) : undefined);
    ret.addPropertyResult('bucketRegion', 'BucketRegion', properties.BucketRegion != null ? cfn_parse.FromCloudFormation.getString(properties.BucketRegion) : undefined);
    ret.addPropertyResult('kmsKeyArn', 'KMSKeyArn', properties.KMSKeyArn != null ? cfn_parse.FromCloudFormation.getString(properties.KMSKeyArn) : undefined);
    ret.addPropertyResult('s3Destination', 'S3Destination', properties.S3Destination != null ? CfnResourceDataSyncS3DestinationPropertyFromCloudFormation(properties.S3Destination) : undefined);
    ret.addPropertyResult('syncFormat', 'SyncFormat', properties.SyncFormat != null ? cfn_parse.FromCloudFormation.getString(properties.SyncFormat) : undefined);
    ret.addPropertyResult('syncSource', 'SyncSource', properties.SyncSource != null ? CfnResourceDataSyncSyncSourcePropertyFromCloudFormation(properties.SyncSource) : undefined);
    ret.addPropertyResult('syncType', 'SyncType', properties.SyncType != null ? cfn_parse.FromCloudFormation.getString(properties.SyncType) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SSM::ResourceDataSync`
 *
 * The `AWS::SSM::ResourceDataSync` resource creates, updates, or deletes a resource data sync for AWS Systems Manager . A resource data sync helps you view data from multiple sources in a single location. Systems Manager offers two types of resource data sync: `SyncToDestination` and `SyncFromSource` .
 *
 * You can configure Systems Manager Inventory to use the `SyncToDestination` type to synchronize Inventory data from multiple AWS Regions to a single Amazon S3 bucket.
 *
 * You can configure Systems Manager Explorer to use the `SyncFromSource` type to synchronize operational work items (OpsItems) and operational data (OpsData) from multiple AWS Regions . This type can synchronize OpsItems and OpsData from multiple AWS accounts and Regions or from an `EntireOrganization` by using AWS Organizations .
 *
 * A resource data sync is an asynchronous operation that returns immediately. After a successful initial sync is completed, the system continuously syncs data.
 *
 * By default, data is not encrypted in Amazon S3 . We strongly recommend that you enable encryption in Amazon S3 to ensure secure data storage. We also recommend that you secure access to the Amazon S3 bucket by creating a restrictive bucket policy.
 *
 * For more information, see [Configuring Inventory Collection](https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-configuring.html#sysman-inventory-datasync) and [Setting Up Systems Manager Explorer to Display Data from Multiple Accounts and Regions](https://docs.aws.amazon.com/systems-manager/latest/userguide/Explorer-resource-data-sync.html) in the *AWS Systems Manager User Guide* .
 *
 * Important: The following *Syntax* section shows all fields that are supported for a resource data sync. The *Examples* section below shows the recommended way to specify configurations for each sync type. Please see the *Examples* section when you create your resource data sync.
 *
 * @cloudformationResource AWS::SSM::ResourceDataSync
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html
 */
class CfnResourceDataSync extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnResourceDataSyncPropsFromCloudFormation(resourceProperties);
        const ret = new CfnResourceDataSync(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::SSM::ResourceDataSync`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnResourceDataSync.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ssm_CfnResourceDataSyncProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnResourceDataSync);
            }
            throw error;
        }
        cdk.requireProperty(props, 'syncName', this);
        this.attrSyncName = cdk.Token.asString(this.getAtt('SyncName', cdk.ResolutionTypeHint.STRING));
        this.syncName = props.syncName;
        this.bucketName = props.bucketName;
        this.bucketPrefix = props.bucketPrefix;
        this.bucketRegion = props.bucketRegion;
        this.kmsKeyArn = props.kmsKeyArn;
        this.s3Destination = props.s3Destination;
        this.syncFormat = props.syncFormat;
        this.syncSource = props.syncSource;
        this.syncType = props.syncType;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnResourceDataSync.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            syncName: this.syncName,
            bucketName: this.bucketName,
            bucketPrefix: this.bucketPrefix,
            bucketRegion: this.bucketRegion,
            kmsKeyArn: this.kmsKeyArn,
            s3Destination: this.s3Destination,
            syncFormat: this.syncFormat,
            syncSource: this.syncSource,
            syncType: this.syncType,
        };
    }
    renderProperties(props) {
        return cfnResourceDataSyncPropsToCloudFormation(props);
    }
}
_h = JSII_RTTI_SYMBOL_1;
CfnResourceDataSync[_h] = { fqn: "aws-cdk-lib.aws_ssm.CfnResourceDataSync", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnResourceDataSync.CFN_RESOURCE_TYPE_NAME = "AWS::SSM::ResourceDataSync";
exports.CfnResourceDataSync = CfnResourceDataSync;
/**
 * Determine whether the given properties match those of a `AwsOrganizationsSourceProperty`
 *
 * @param properties - the TypeScript properties of a `AwsOrganizationsSourceProperty`
 *
 * @returns the result of the validation.
 */
function CfnResourceDataSync_AwsOrganizationsSourcePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('organizationSourceType', cdk.requiredValidator)(properties.organizationSourceType));
    errors.collect(cdk.propertyValidator('organizationSourceType', cdk.validateString)(properties.organizationSourceType));
    errors.collect(cdk.propertyValidator('organizationalUnits', cdk.listValidator(cdk.validateString))(properties.organizationalUnits));
    return errors.wrap('supplied properties not correct for "AwsOrganizationsSourceProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::ResourceDataSync.AwsOrganizationsSource` resource
 *
 * @param properties - the TypeScript properties of a `AwsOrganizationsSourceProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::ResourceDataSync.AwsOrganizationsSource` resource.
 */
// @ts-ignore TS6133
function cfnResourceDataSyncAwsOrganizationsSourcePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnResourceDataSync_AwsOrganizationsSourcePropertyValidator(properties).assertSuccess();
    return {
        OrganizationSourceType: cdk.stringToCloudFormation(properties.organizationSourceType),
        OrganizationalUnits: cdk.listMapper(cdk.stringToCloudFormation)(properties.organizationalUnits),
    };
}
// @ts-ignore TS6133
function CfnResourceDataSyncAwsOrganizationsSourcePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('organizationSourceType', 'OrganizationSourceType', cfn_parse.FromCloudFormation.getString(properties.OrganizationSourceType));
    ret.addPropertyResult('organizationalUnits', 'OrganizationalUnits', properties.OrganizationalUnits != null ? cfn_parse.FromCloudFormation.getStringArray(properties.OrganizationalUnits) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `S3DestinationProperty`
 *
 * @param properties - the TypeScript properties of a `S3DestinationProperty`
 *
 * @returns the result of the validation.
 */
function CfnResourceDataSync_S3DestinationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('bucketName', cdk.requiredValidator)(properties.bucketName));
    errors.collect(cdk.propertyValidator('bucketName', cdk.validateString)(properties.bucketName));
    errors.collect(cdk.propertyValidator('bucketPrefix', cdk.validateString)(properties.bucketPrefix));
    errors.collect(cdk.propertyValidator('bucketRegion', cdk.requiredValidator)(properties.bucketRegion));
    errors.collect(cdk.propertyValidator('bucketRegion', cdk.validateString)(properties.bucketRegion));
    errors.collect(cdk.propertyValidator('kmsKeyArn', cdk.validateString)(properties.kmsKeyArn));
    errors.collect(cdk.propertyValidator('syncFormat', cdk.requiredValidator)(properties.syncFormat));
    errors.collect(cdk.propertyValidator('syncFormat', cdk.validateString)(properties.syncFormat));
    return errors.wrap('supplied properties not correct for "S3DestinationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::ResourceDataSync.S3Destination` resource
 *
 * @param properties - the TypeScript properties of a `S3DestinationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::ResourceDataSync.S3Destination` resource.
 */
// @ts-ignore TS6133
function cfnResourceDataSyncS3DestinationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnResourceDataSync_S3DestinationPropertyValidator(properties).assertSuccess();
    return {
        BucketName: cdk.stringToCloudFormation(properties.bucketName),
        BucketPrefix: cdk.stringToCloudFormation(properties.bucketPrefix),
        BucketRegion: cdk.stringToCloudFormation(properties.bucketRegion),
        KMSKeyArn: cdk.stringToCloudFormation(properties.kmsKeyArn),
        SyncFormat: cdk.stringToCloudFormation(properties.syncFormat),
    };
}
// @ts-ignore TS6133
function CfnResourceDataSyncS3DestinationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('bucketName', 'BucketName', cfn_parse.FromCloudFormation.getString(properties.BucketName));
    ret.addPropertyResult('bucketPrefix', 'BucketPrefix', properties.BucketPrefix != null ? cfn_parse.FromCloudFormation.getString(properties.BucketPrefix) : undefined);
    ret.addPropertyResult('bucketRegion', 'BucketRegion', cfn_parse.FromCloudFormation.getString(properties.BucketRegion));
    ret.addPropertyResult('kmsKeyArn', 'KMSKeyArn', properties.KMSKeyArn != null ? cfn_parse.FromCloudFormation.getString(properties.KMSKeyArn) : undefined);
    ret.addPropertyResult('syncFormat', 'SyncFormat', cfn_parse.FromCloudFormation.getString(properties.SyncFormat));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `SyncSourceProperty`
 *
 * @param properties - the TypeScript properties of a `SyncSourceProperty`
 *
 * @returns the result of the validation.
 */
function CfnResourceDataSync_SyncSourcePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('awsOrganizationsSource', CfnResourceDataSync_AwsOrganizationsSourcePropertyValidator)(properties.awsOrganizationsSource));
    errors.collect(cdk.propertyValidator('includeFutureRegions', cdk.validateBoolean)(properties.includeFutureRegions));
    errors.collect(cdk.propertyValidator('sourceRegions', cdk.requiredValidator)(properties.sourceRegions));
    errors.collect(cdk.propertyValidator('sourceRegions', cdk.listValidator(cdk.validateString))(properties.sourceRegions));
    errors.collect(cdk.propertyValidator('sourceType', cdk.requiredValidator)(properties.sourceType));
    errors.collect(cdk.propertyValidator('sourceType', cdk.validateString)(properties.sourceType));
    return errors.wrap('supplied properties not correct for "SyncSourceProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::ResourceDataSync.SyncSource` resource
 *
 * @param properties - the TypeScript properties of a `SyncSourceProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::ResourceDataSync.SyncSource` resource.
 */
// @ts-ignore TS6133
function cfnResourceDataSyncSyncSourcePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnResourceDataSync_SyncSourcePropertyValidator(properties).assertSuccess();
    return {
        AwsOrganizationsSource: cfnResourceDataSyncAwsOrganizationsSourcePropertyToCloudFormation(properties.awsOrganizationsSource),
        IncludeFutureRegions: cdk.booleanToCloudFormation(properties.includeFutureRegions),
        SourceRegions: cdk.listMapper(cdk.stringToCloudFormation)(properties.sourceRegions),
        SourceType: cdk.stringToCloudFormation(properties.sourceType),
    };
}
// @ts-ignore TS6133
function CfnResourceDataSyncSyncSourcePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('awsOrganizationsSource', 'AwsOrganizationsSource', properties.AwsOrganizationsSource != null ? CfnResourceDataSyncAwsOrganizationsSourcePropertyFromCloudFormation(properties.AwsOrganizationsSource) : undefined);
    ret.addPropertyResult('includeFutureRegions', 'IncludeFutureRegions', properties.IncludeFutureRegions != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IncludeFutureRegions) : undefined);
    ret.addPropertyResult('sourceRegions', 'SourceRegions', cfn_parse.FromCloudFormation.getStringArray(properties.SourceRegions));
    ret.addPropertyResult('sourceType', 'SourceType', cfn_parse.FromCloudFormation.getString(properties.SourceType));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnResourcePolicyProps`
 *
 * @param properties - the TypeScript properties of a `CfnResourcePolicyProps`
 *
 * @returns the result of the validation.
 */
function CfnResourcePolicyPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('policy', cdk.requiredValidator)(properties.policy));
    errors.collect(cdk.propertyValidator('policy', cdk.validateObject)(properties.policy));
    errors.collect(cdk.propertyValidator('resourceArn', cdk.requiredValidator)(properties.resourceArn));
    errors.collect(cdk.propertyValidator('resourceArn', cdk.validateString)(properties.resourceArn));
    return errors.wrap('supplied properties not correct for "CfnResourcePolicyProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SSM::ResourcePolicy` resource
 *
 * @param properties - the TypeScript properties of a `CfnResourcePolicyProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SSM::ResourcePolicy` resource.
 */
// @ts-ignore TS6133
function cfnResourcePolicyPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnResourcePolicyPropsValidator(properties).assertSuccess();
    return {
        Policy: cdk.objectToCloudFormation(properties.policy),
        ResourceArn: cdk.stringToCloudFormation(properties.resourceArn),
    };
}
// @ts-ignore TS6133
function CfnResourcePolicyPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('policy', 'Policy', cfn_parse.FromCloudFormation.getAny(properties.Policy));
    ret.addPropertyResult('resourceArn', 'ResourceArn', cfn_parse.FromCloudFormation.getString(properties.ResourceArn));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SSM::ResourcePolicy`
 *
 * Creates or updates a Systems Manager resource policy. A resource policy helps you to define the IAM entity (for example, an AWS account ) that can manage your Systems Manager resources. Currently, `OpsItemGroup` is the only resource that supports Systems Manager resource policies. The resource policy for `OpsItemGroup` enables AWS accounts to view and interact with OpsCenter operational work items (OpsItems). OpsCenter is a capability of Systems Manager .
 *
 * @cloudformationResource AWS::SSM::ResourcePolicy
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcepolicy.html
 */
class CfnResourcePolicy extends cdk.CfnResource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnResourcePolicyPropsFromCloudFormation(resourceProperties);
        const ret = new CfnResourcePolicy(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Create a new `AWS::SSM::ResourcePolicy`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnResourcePolicy.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_ssm_CfnResourcePolicyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnResourcePolicy);
            }
            throw error;
        }
        cdk.requireProperty(props, 'policy', this);
        cdk.requireProperty(props, 'resourceArn', this);
        this.attrPolicyHash = cdk.Token.asString(this.getAtt('PolicyHash', cdk.ResolutionTypeHint.STRING));
        this.attrPolicyId = cdk.Token.asString(this.getAtt('PolicyId', cdk.ResolutionTypeHint.STRING));
        this.policy = props.policy;
        this.resourceArn = props.resourceArn;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnResourcePolicy.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            policy: this.policy,
            resourceArn: this.resourceArn,
        };
    }
    renderProperties(props) {
        return cfnResourcePolicyPropsToCloudFormation(props);
    }
}
_j = JSII_RTTI_SYMBOL_1;
CfnResourcePolicy[_j] = { fqn: "aws-cdk-lib.aws_ssm.CfnResourcePolicy", version: "2.74.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnResourcePolicy.CFN_RESOURCE_TYPE_NAME = "AWS::SSM::ResourcePolicy";
exports.CfnResourcePolicy = CfnResourcePolicy;
//# sourceMappingURL=data:application/json;base64,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