"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CallAwsService = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../../aws-iam");
const sfn = require("../../../aws-stepfunctions");
const core_1 = require("../../../core");
const task_utils_1 = require("../private/task-utils");
/**
 * A StepFunctions task to call an AWS service API
 */
class CallAwsService extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_stepfunctions_tasks_CallAwsServiceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CallAwsService);
            }
            throw error;
        }
        if (this.props.integrationPattern === sfn.IntegrationPattern.RUN_JOB) {
            throw new Error('The RUN_JOB integration pattern is not supported for CallAwsService');
        }
        const iamServiceMap = {
            sfn: 'states',
        };
        const iamService = iamServiceMap[props.service] ?? props.service;
        this.taskPolicies = [
            new iam.PolicyStatement({
                resources: props.iamResources,
                // The prefix and the action name are case insensitive
                // https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_action.html
                actions: [props.iamAction ?? `${iamService}:${props.action}`],
            }),
            ...props.additionalIamStatements ?? [],
        ];
    }
    /**
     * @internal
     */
    _renderTask() {
        let service = this.props.service;
        if (!core_1.Token.isUnresolved(service)) {
            service = service.toLowerCase();
        }
        return {
            Resource: (0, task_utils_1.integrationResourceArn)('aws-sdk', `${service}:${this.props.action}`, this.props.integrationPattern),
            Parameters: sfn.FieldUtils.renderObject(this.props.parameters) ?? {}, // Parameters is required for aws-sdk
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
CallAwsService[_a] = { fqn: "aws-cdk-lib.aws_stepfunctions_tasks.CallAwsService", version: "2.74.0" };
exports.CallAwsService = CallAwsService;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2FsbC1hd3Mtc2VydmljZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImNhbGwtYXdzLXNlcnZpY2UudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEsd0NBQXdDO0FBQ3hDLGtEQUFrRDtBQUNsRCx3Q0FBc0M7QUFFdEMsc0RBQStEO0FBZ0UvRDs7R0FFRztBQUNILE1BQWEsY0FBZSxTQUFRLEdBQUcsQ0FBQyxhQUFhO0lBSW5ELFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQW1CLEtBQTBCO1FBQ25GLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBRGlDLFVBQUssR0FBTCxLQUFLLENBQXFCOzs7Ozs7K0NBSjFFLGNBQWM7Ozs7UUFPdkIsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLGtCQUFrQixLQUFLLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxPQUFPLEVBQUU7WUFDcEUsTUFBTSxJQUFJLEtBQUssQ0FBQyxxRUFBcUUsQ0FBQyxDQUFDO1NBQ3hGO1FBRUQsTUFBTSxhQUFhLEdBQTJCO1lBQzVDLEdBQUcsRUFBRSxRQUFRO1NBQ2QsQ0FBQztRQUNGLE1BQU0sVUFBVSxHQUFHLGFBQWEsQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLElBQUksS0FBSyxDQUFDLE9BQU8sQ0FBQztRQUVqRSxJQUFJLENBQUMsWUFBWSxHQUFHO1lBQ2xCLElBQUksR0FBRyxDQUFDLGVBQWUsQ0FBQztnQkFDdEIsU0FBUyxFQUFFLEtBQUssQ0FBQyxZQUFZO2dCQUM3QixzREFBc0Q7Z0JBQ3RELDJGQUEyRjtnQkFDM0YsT0FBTyxFQUFFLENBQUMsS0FBSyxDQUFDLFNBQVMsSUFBSSxHQUFHLFVBQVUsSUFBSSxLQUFLLENBQUMsTUFBTSxFQUFFLENBQUM7YUFDOUQsQ0FBQztZQUNGLEdBQUcsS0FBSyxDQUFDLHVCQUF1QixJQUFJLEVBQUU7U0FDdkMsQ0FBQztLQUNIO0lBRUQ7O09BRUc7SUFDTyxXQUFXO1FBQ25CLElBQUksT0FBTyxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDO1FBRWpDLElBQUksQ0FBQyxZQUFLLENBQUMsWUFBWSxDQUFDLE9BQU8sQ0FBQyxFQUFFO1lBQ2hDLE9BQU8sR0FBRyxPQUFPLENBQUMsV0FBVyxFQUFFLENBQUM7U0FDakM7UUFFRCxPQUFPO1lBQ0wsUUFBUSxFQUFFLElBQUEsbUNBQXNCLEVBQzlCLFNBQVMsRUFDVCxHQUFHLE9BQU8sSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLE1BQU0sRUFBRSxFQUNqQyxJQUFJLENBQUMsS0FBSyxDQUFDLGtCQUFrQixDQUM5QjtZQUNELFVBQVUsRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxJQUFJLEVBQUUsRUFBRSxxQ0FBcUM7U0FDNUcsQ0FBQztLQUNIOzs7O0FBN0NVLHdDQUFjIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgaWFtIGZyb20gJy4uLy4uLy4uL2F3cy1pYW0nO1xuaW1wb3J0ICogYXMgc2ZuIGZyb20gJy4uLy4uLy4uL2F3cy1zdGVwZnVuY3Rpb25zJztcbmltcG9ydCB7IFRva2VuIH0gZnJvbSAnLi4vLi4vLi4vY29yZSc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IGludGVncmF0aW9uUmVzb3VyY2VBcm4gfSBmcm9tICcuLi9wcml2YXRlL3Rhc2stdXRpbHMnO1xuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGNhbGxpbmcgYW4gQVdTIHNlcnZpY2UncyBBUEkgYWN0aW9uIGZyb20geW91clxuICogc3RhdGUgbWFjaGluZS5cbiAqXG4gKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9zdGVwLWZ1bmN0aW9ucy9sYXRlc3QvZGcvc3VwcG9ydGVkLXNlcnZpY2VzLWF3c3Nkay5odG1sXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ2FsbEF3c1NlcnZpY2VQcm9wcyBleHRlbmRzIHNmbi5UYXNrU3RhdGVCYXNlUHJvcHMge1xuICAvKipcbiAgICogVGhlIEFXUyBzZXJ2aWNlIHRvIGNhbGwuXG4gICAqXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3N0ZXAtZnVuY3Rpb25zL2xhdGVzdC9kZy9zdXBwb3J0ZWQtc2VydmljZXMtYXdzc2RrLmh0bWxcbiAgICovXG4gIHJlYWRvbmx5IHNlcnZpY2U6IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIEFQSSBhY3Rpb24gdG8gY2FsbC5cbiAgICpcbiAgICogVXNlIGNhbWVsQ2FzZS5cbiAgICovXG4gIHJlYWRvbmx5IGFjdGlvbjogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBQYXJhbWV0ZXJzIGZvciB0aGUgQVBJIGFjdGlvbiBjYWxsLlxuICAgKlxuICAgKiBVc2UgUGFzY2FsQ2FzZSBmb3IgdGhlIHBhcmFtZXRlciBuYW1lcy5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBubyBwYXJhbWV0ZXJzXG4gICAqL1xuICByZWFkb25seSBwYXJhbWV0ZXJzPzogeyBba2V5OiBzdHJpbmddOiBhbnkgfTtcblxuICAvKipcbiAgICogVGhlIHJlc291cmNlcyBmb3IgdGhlIElBTSBzdGF0ZW1lbnQgdGhhdCB3aWxsIGJlIGFkZGVkIHRvIHRoZSBzdGF0ZVxuICAgKiBtYWNoaW5lIHJvbGUncyBwb2xpY3kgdG8gYWxsb3cgdGhlIHN0YXRlIG1hY2hpbmUgdG8gbWFrZSB0aGUgQVBJIGNhbGwuXG4gICAqXG4gICAqIEJ5IGRlZmF1bHQgdGhlIGFjdGlvbiBmb3IgdGhpcyBJQU0gc3RhdGVtZW50IHdpbGwgYmUgYHNlcnZpY2U6YWN0aW9uYC5cbiAgICovXG4gIHJlYWRvbmx5IGlhbVJlc291cmNlczogc3RyaW5nW107XG5cbiAgLyoqXG4gICAqIFRoZSBhY3Rpb24gZm9yIHRoZSBJQU0gc3RhdGVtZW50IHRoYXQgd2lsbCBiZSBhZGRlZCB0byB0aGUgc3RhdGVcbiAgICogbWFjaGluZSByb2xlJ3MgcG9saWN5IHRvIGFsbG93IHRoZSBzdGF0ZSBtYWNoaW5lIHRvIG1ha2UgdGhlIEFQSSBjYWxsLlxuICAgKlxuICAgKiBVc2UgaW4gdGhlIGNhc2Ugd2hlcmUgdGhlIElBTSBhY3Rpb24gbmFtZSBkb2VzIG5vdCBtYXRjaCB3aXRoIHRoZVxuICAgKiBBUEkgc2VydmljZS9hY3Rpb24gbmFtZSwgZS5nLiBgczM6TGlzdEJ1Y2tldHNgIHJlcXVpcmVzIGBzMzpMaXN0QWxsTXlCdWNrZXRzYC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBzZXJ2aWNlOmFjdGlvblxuICAgKi9cbiAgcmVhZG9ubHkgaWFtQWN0aW9uPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBBZGRpdGlvbmFsIElBTSBzdGF0ZW1lbnRzIHRoYXQgd2lsbCBiZSBhZGRlZCB0byB0aGUgc3RhdGUgbWFjaGluZVxuICAgKiByb2xlJ3MgcG9saWN5LlxuICAgKlxuICAgKiBVc2UgaW4gdGhlIGNhc2Ugd2hlcmUgdGhlIGNhbGwgcmVxdWlyZXMgbW9yZSB0aGFuIGEgc2luZ2xlIHN0YXRlbWVudCB0b1xuICAgKiBiZSBleGVjdXRlZCwgZS5nLiBgcmVrb2duaXRpb246ZGV0ZWN0TGFiZWxzYCByZXF1aXJlcyBhbHNvIFMzIHBlcm1pc3Npb25zXG4gICAqIHRvIHJlYWQgdGhlIG9iamVjdCBvbiB3aGljaCBpdCBtdXN0IGFjdC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBubyBhZGRpdGlvbmFsIHN0YXRlbWVudHMgYXJlIGFkZGVkXG4gICAqL1xuICByZWFkb25seSBhZGRpdGlvbmFsSWFtU3RhdGVtZW50cz86IGlhbS5Qb2xpY3lTdGF0ZW1lbnRbXTtcbn1cblxuLyoqXG4gKiBBIFN0ZXBGdW5jdGlvbnMgdGFzayB0byBjYWxsIGFuIEFXUyBzZXJ2aWNlIEFQSVxuICovXG5leHBvcnQgY2xhc3MgQ2FsbEF3c1NlcnZpY2UgZXh0ZW5kcyBzZm4uVGFza1N0YXRlQmFzZSB7XG4gIHByb3RlY3RlZCByZWFkb25seSB0YXNrTWV0cmljcz86IHNmbi5UYXNrTWV0cmljc0NvbmZpZztcbiAgcHJvdGVjdGVkIHJlYWRvbmx5IHRhc2tQb2xpY2llcz86IGlhbS5Qb2xpY3lTdGF0ZW1lbnRbXTtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcml2YXRlIHJlYWRvbmx5IHByb3BzOiBDYWxsQXdzU2VydmljZVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCBwcm9wcyk7XG5cbiAgICBpZiAodGhpcy5wcm9wcy5pbnRlZ3JhdGlvblBhdHRlcm4gPT09IHNmbi5JbnRlZ3JhdGlvblBhdHRlcm4uUlVOX0pPQikge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdUaGUgUlVOX0pPQiBpbnRlZ3JhdGlvbiBwYXR0ZXJuIGlzIG5vdCBzdXBwb3J0ZWQgZm9yIENhbGxBd3NTZXJ2aWNlJyk7XG4gICAgfVxuXG4gICAgY29uc3QgaWFtU2VydmljZU1hcDogUmVjb3JkPHN0cmluZywgc3RyaW5nPiA9IHtcbiAgICAgIHNmbjogJ3N0YXRlcycsXG4gICAgfTtcbiAgICBjb25zdCBpYW1TZXJ2aWNlID0gaWFtU2VydmljZU1hcFtwcm9wcy5zZXJ2aWNlXSA/PyBwcm9wcy5zZXJ2aWNlO1xuXG4gICAgdGhpcy50YXNrUG9saWNpZXMgPSBbXG4gICAgICBuZXcgaWFtLlBvbGljeVN0YXRlbWVudCh7XG4gICAgICAgIHJlc291cmNlczogcHJvcHMuaWFtUmVzb3VyY2VzLFxuICAgICAgICAvLyBUaGUgcHJlZml4IGFuZCB0aGUgYWN0aW9uIG5hbWUgYXJlIGNhc2UgaW5zZW5zaXRpdmVcbiAgICAgICAgLy8gaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0lBTS9sYXRlc3QvVXNlckd1aWRlL3JlZmVyZW5jZV9wb2xpY2llc19lbGVtZW50c19hY3Rpb24uaHRtbFxuICAgICAgICBhY3Rpb25zOiBbcHJvcHMuaWFtQWN0aW9uID8/IGAke2lhbVNlcnZpY2V9OiR7cHJvcHMuYWN0aW9ufWBdLFxuICAgICAgfSksXG4gICAgICAuLi5wcm9wcy5hZGRpdGlvbmFsSWFtU3RhdGVtZW50cyA/PyBbXSxcbiAgICBdO1xuICB9XG5cbiAgLyoqXG4gICAqIEBpbnRlcm5hbFxuICAgKi9cbiAgcHJvdGVjdGVkIF9yZW5kZXJUYXNrKCk6IGFueSB7XG4gICAgbGV0IHNlcnZpY2UgPSB0aGlzLnByb3BzLnNlcnZpY2U7XG5cbiAgICBpZiAoIVRva2VuLmlzVW5yZXNvbHZlZChzZXJ2aWNlKSkge1xuICAgICAgc2VydmljZSA9IHNlcnZpY2UudG9Mb3dlckNhc2UoKTtcbiAgICB9XG5cbiAgICByZXR1cm4ge1xuICAgICAgUmVzb3VyY2U6IGludGVncmF0aW9uUmVzb3VyY2VBcm4oXG4gICAgICAgICdhd3Mtc2RrJyxcbiAgICAgICAgYCR7c2VydmljZX06JHt0aGlzLnByb3BzLmFjdGlvbn1gLFxuICAgICAgICB0aGlzLnByb3BzLmludGVncmF0aW9uUGF0dGVybixcbiAgICAgICksXG4gICAgICBQYXJhbWV0ZXJzOiBzZm4uRmllbGRVdGlscy5yZW5kZXJPYmplY3QodGhpcy5wcm9wcy5wYXJhbWV0ZXJzKSA/PyB7fSwgLy8gUGFyYW1ldGVycyBpcyByZXF1aXJlZCBmb3IgYXdzLXNka1xuICAgIH07XG4gIH1cbn1cbiJdfQ==