"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateJsonPath = exports.transformAttributeValueMap = exports.getDynamoResourceArn = exports.DynamoMethod = void 0;
const sfn = require("../../../../aws-stepfunctions");
const task_utils_1 = require("../../private/task-utils");
var DynamoMethod;
(function (DynamoMethod) {
    DynamoMethod["GET"] = "Get";
    DynamoMethod["PUT"] = "Put";
    DynamoMethod["DELETE"] = "Delete";
    DynamoMethod["UPDATE"] = "Update";
})(DynamoMethod = exports.DynamoMethod || (exports.DynamoMethod = {}));
function getDynamoResourceArn(method) {
    return (0, task_utils_1.integrationResourceArn)('dynamodb', `${method.toLowerCase()}Item`, sfn.IntegrationPattern.REQUEST_RESPONSE);
}
exports.getDynamoResourceArn = getDynamoResourceArn;
function transformAttributeValueMap(attrMap) {
    const transformedValue = {};
    for (const key in attrMap) {
        if (key) {
            transformedValue[key] = attrMap[key].toObject();
        }
    }
    return attrMap ? transformedValue : undefined;
}
exports.transformAttributeValueMap = transformAttributeValueMap;
function validateJsonPath(value) {
    if (!value.startsWith('$')) {
        throw new Error("Data JSON path values must either be exactly equal to '$' or start with '$.'");
    }
}
exports.validateJsonPath = validateJsonPath;
//# sourceMappingURL=data:application/json;base64,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