"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamoAttributeValue = exports.DynamoProjectionExpression = exports.DynamoReturnValues = exports.DynamoItemCollectionMetrics = exports.DynamoConsumedCapacity = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const utils_1 = require("./private/utils");
/**
 * Determines the level of detail about provisioned throughput consumption that is returned.
 */
var DynamoConsumedCapacity;
(function (DynamoConsumedCapacity) {
    /**
     * The response includes the aggregate ConsumedCapacity for the operation,
     * together with ConsumedCapacity for each table and secondary index that was accessed
     */
    DynamoConsumedCapacity["INDEXES"] = "INDEXES";
    /**
     * The response includes only the aggregate ConsumedCapacity for the operation.
     */
    DynamoConsumedCapacity["TOTAL"] = "TOTAL";
    /**
     * No ConsumedCapacity details are included in the response.
     */
    DynamoConsumedCapacity["NONE"] = "NONE";
})(DynamoConsumedCapacity = exports.DynamoConsumedCapacity || (exports.DynamoConsumedCapacity = {}));
/**
 * Determines whether item collection metrics are returned.
 */
var DynamoItemCollectionMetrics;
(function (DynamoItemCollectionMetrics) {
    /**
     * If set to SIZE, the response includes statistics about item collections,
     * if any, that were modified during the operation.
     */
    DynamoItemCollectionMetrics["SIZE"] = "SIZE";
    /**
     * If set to NONE, no statistics are returned.
     */
    DynamoItemCollectionMetrics["NONE"] = "NONE";
})(DynamoItemCollectionMetrics = exports.DynamoItemCollectionMetrics || (exports.DynamoItemCollectionMetrics = {}));
/**
 * Use ReturnValues if you want to get the item attributes as they appear before or after they are changed
 */
var DynamoReturnValues;
(function (DynamoReturnValues) {
    /**
     * Nothing is returned
     */
    DynamoReturnValues["NONE"] = "NONE";
    /**
     * Returns all of the attributes of the item
     */
    DynamoReturnValues["ALL_OLD"] = "ALL_OLD";
    /**
     * Returns only the updated attributes
     */
    DynamoReturnValues["UPDATED_OLD"] = "UPDATED_OLD";
    /**
     * Returns all of the attributes of the item
     */
    DynamoReturnValues["ALL_NEW"] = "ALL_NEW";
    /**
     * Returns only the updated attributes
     */
    DynamoReturnValues["UPDATED_NEW"] = "UPDATED_NEW";
})(DynamoReturnValues = exports.DynamoReturnValues || (exports.DynamoReturnValues = {}));
/**
 * Class to generate projection expression
 */
class DynamoProjectionExpression {
    constructor() {
        this.expression = [];
    }
    /**
     * Adds the passed attribute to the chain
     *
     * @param attr Attribute name
     */
    withAttribute(attr) {
        if (this.expression.length) {
            this.expression.push(`.${attr}`);
        }
        else {
            this.expression.push(attr);
        }
        return this;
    }
    /**
     * Adds the array literal access for passed index
     *
     * @param index array index
     */
    atIndex(index) {
        if (!this.expression.length) {
            throw new Error('Expression must start with an attribute');
        }
        this.expression.push(`[${index}]`);
        return this;
    }
    /**
     * converts and return the string expression
     */
    toString() {
        return this.expression.join('');
    }
}
_a = JSII_RTTI_SYMBOL_1;
DynamoProjectionExpression[_a] = { fqn: "aws-cdk-lib.aws_stepfunctions_tasks.DynamoProjectionExpression", version: "2.74.0" };
exports.DynamoProjectionExpression = DynamoProjectionExpression;
/**
 * Represents the data for an attribute.
 * Each attribute value is described as a name-value pair.
 * The name is the data type, and the value is the data itself.
 *
 * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_AttributeValue.html
 */
class DynamoAttributeValue {
    /**
     * Sets an attribute of type String. For example:  "S": "Hello"
     * Strings may be literal values or as JsonPath. Example values:
     *
     * - `DynamoAttributeValue.fromString('someValue')`
     * - `DynamoAttributeValue.fromString(JsonPath.stringAt('$.bar'))`
     */
    static fromString(value) {
        return new DynamoAttributeValue({ S: value });
    }
    /**
     * Sets a literal number. For example: 1234
     * Numbers are sent across the network to DynamoDB as strings,
     * to maximize compatibility across languages and libraries.
     * However, DynamoDB treats them as number type attributes for mathematical operations.
     */
    static fromNumber(value) {
        return new DynamoAttributeValue({ N: value.toString() });
    }
    /**
     * Sets an attribute of type Number. For example:  "N": "123.45"
     * Numbers are sent across the network to DynamoDB as strings,
     * to maximize compatibility across languages and libraries.
     * However, DynamoDB treats them as number type attributes for mathematical operations.
     *
     * Numbers may be expressed as literal strings or as JsonPath
     */
    static numberFromString(value) {
        return new DynamoAttributeValue({ N: value.toString() });
    }
    /**
     * Sets an attribute of type Binary. For example:  "B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"
     *
     * @param value base-64 encoded string
     */
    static fromBinary(value) {
        return new DynamoAttributeValue({ B: value });
    }
    /**
     * Sets an attribute of type String Set. For example:  "SS": ["Giraffe", "Hippo" ,"Zebra"]
     */
    static fromStringSet(value) {
        return new DynamoAttributeValue({ SS: value });
    }
    /**
     * Sets an attribute of type Number Set. For example:  "NS": ["42.2", "-19", "7.5", "3.14"]
     * Numbers are sent across the network to DynamoDB as strings,
     * to maximize compatibility across languages and libraries.
     * However, DynamoDB treats them as number type attributes for mathematical operations.
     */
    static fromNumberSet(value) {
        return new DynamoAttributeValue({ NS: value.map(String) });
    }
    /**
     * Sets an attribute of type Number Set. For example:  "NS": ["42.2", "-19", "7.5", "3.14"]
     * Numbers are sent across the network to DynamoDB as strings,
     * to maximize compatibility across languages and libraries.
     * However, DynamoDB treats them as number type attributes for mathematical operations.
     *
     * Numbers may be expressed as literal strings or as JsonPath
     */
    static numberSetFromStrings(value) {
        return new DynamoAttributeValue({ NS: value });
    }
    /**
     * Sets an attribute of type Binary Set. For example:  "BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]
     */
    static fromBinarySet(value) {
        return new DynamoAttributeValue({ BS: value });
    }
    /**
     * Sets an attribute of type Map. For example:  "M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}
     */
    static fromMap(value) {
        return new DynamoAttributeValue({ M: (0, utils_1.transformAttributeValueMap)(value) });
    }
    /**
     * Sets an attribute of type Map. For example:  "M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}
     *
     * @param value Json path that specifies state input to be used
     */
    static mapFromJsonPath(value) {
        (0, utils_1.validateJsonPath)(value);
        return new DynamoAttributeValue({ 'M.$': value });
    }
    /**
     * Sets an attribute of type List. For example:  "L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]
     */
    static fromList(value) {
        return new DynamoAttributeValue({ L: value.map((val) => val.toObject()) });
    }
    /**
     * Sets an attribute of type List. For example:  "L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"S", "Veggies"}]
     *
     * @param value Json path that specifies state input to be used
     */
    static listFromJsonPath(value) {
        (0, utils_1.validateJsonPath)(value);
        return new DynamoAttributeValue({ L: value });
    }
    /**
     * Sets an attribute of type Null. For example:  "NULL": true
     */
    static fromNull(value) {
        return new DynamoAttributeValue({ NULL: value });
    }
    /**
     * Sets an attribute of type Boolean. For example:  "BOOL": true
     */
    static fromBoolean(value) {
        return new DynamoAttributeValue({ BOOL: value });
    }
    /**
     * Sets an attribute of type Boolean from state input through Json path.
     * For example:  "BOOL": true
     *
     * @param value Json path that specifies state input to be used
     */
    static booleanFromJsonPath(value) {
        (0, utils_1.validateJsonPath)(value);
        return new DynamoAttributeValue({ BOOL: value.toString() });
    }
    constructor(value) {
        this.attributeValue = value;
    }
    /**
     * Returns the DynamoDB attribute value
     */
    toObject() {
        return this.attributeValue;
    }
}
_b = JSII_RTTI_SYMBOL_1;
DynamoAttributeValue[_b] = { fqn: "aws-cdk-lib.aws_stepfunctions_tasks.DynamoAttributeValue", version: "2.74.0" };
exports.DynamoAttributeValue = DynamoAttributeValue;
//# sourceMappingURL=data:application/json;base64,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