"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpMethods = exports.EksCall = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const sfn = require("../../../aws-stepfunctions");
const task_utils_1 = require("../private/task-utils");
/**
 * Call a EKS endpoint as a Task
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-eks.html
 */
class EksCall extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_stepfunctions_tasks_EksCallProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EksCall);
            }
            throw error;
        }
        this.integrationPattern = props.integrationPattern ?? sfn.IntegrationPattern.REQUEST_RESPONSE;
        (0, task_utils_1.validatePatternSupported)(this.integrationPattern, EksCall.SUPPORTED_INTEGRATION_PATTERNS);
        try {
            this.clusterEndpoint = this.props.cluster.clusterEndpoint;
        }
        catch {
            throw new Error('The "clusterEndpoint" property must be specified when using an imported Cluster.');
        }
        try {
            this.clusterCertificateAuthorityData = this.props.cluster.clusterCertificateAuthorityData;
        }
        catch {
            throw new Error('The "clusterCertificateAuthorityData" property must be specified when using an imported Cluster.');
        }
    }
    /**
     * Provides the EKS Call service integration task configuration
     * @internal
     */
    _renderTask() {
        return {
            Resource: (0, task_utils_1.integrationResourceArn)('eks', 'call', this.integrationPattern),
            Parameters: sfn.FieldUtils.renderObject({
                ClusterName: this.props.cluster.clusterName,
                CertificateAuthority: this.clusterCertificateAuthorityData,
                Endpoint: this.clusterEndpoint,
                Method: this.props.httpMethod,
                Path: this.props.httpPath,
                QueryParameters: this.props.queryParameters,
                RequestBody: this.props.requestBody?.value,
            }),
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
EksCall[_a] = { fqn: "aws-cdk-lib.aws_stepfunctions_tasks.EksCall", version: "2.74.0" };
EksCall.SUPPORTED_INTEGRATION_PATTERNS = [
    sfn.IntegrationPattern.REQUEST_RESPONSE,
];
exports.EksCall = EksCall;
/**
 * Method type of a EKS call
 */
var HttpMethods;
(function (HttpMethods) {
    /**
     * Retrieve data from a server at the specified resource
     */
    HttpMethods["GET"] = "GET";
    /**
     * Send data to the API endpoint to create or update a resource
     */
    HttpMethods["POST"] = "POST";
    /**
     * Send data to the API endpoint to update or create a resource
     */
    HttpMethods["PUT"] = "PUT";
    /**
     * Delete the resource at the specified endpoint
     */
    HttpMethods["DELETE"] = "DELETE";
    /**
     * Apply partial modifications to the resource
     */
    HttpMethods["PATCH"] = "PATCH";
    /**
     * Retrieve data from a server at the specified resource without the response body
     */
    HttpMethods["HEAD"] = "HEAD";
})(HttpMethods = exports.HttpMethods || (exports.HttpMethods = {}));
//# sourceMappingURL=data:application/json;base64,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