"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmrModifyInstanceFleetByName = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../../aws-iam");
const sfn = require("../../../aws-stepfunctions");
const core_1 = require("../../../core");
const task_utils_1 = require("../private/task-utils");
/**
 * A Step Functions Task to to modify an InstanceFleet on an EMR Cluster.
 *
 */
class EmrModifyInstanceFleetByName extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_stepfunctions_tasks_EmrModifyInstanceFleetByNameProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EmrModifyInstanceFleetByName);
            }
            throw error;
        }
        this.taskPolicies = [
            new iam.PolicyStatement({
                actions: [
                    'elasticmapreduce:ModifyInstanceFleet',
                    'elasticmapreduce:ListInstanceFleets',
                ],
                resources: [
                    core_1.Stack.of(this).formatArn({
                        service: 'elasticmapreduce',
                        resource: 'cluster',
                        resourceName: '*',
                    }),
                ],
            }),
        ];
    }
    /**
     * @internal
     */
    _renderTask() {
        return {
            Resource: (0, task_utils_1.integrationResourceArn)('elasticmapreduce', 'modifyInstanceFleetByName', sfn.IntegrationPattern.REQUEST_RESPONSE),
            Parameters: sfn.FieldUtils.renderObject({
                ClusterId: this.props.clusterId,
                InstanceFleetName: this.props.instanceFleetName,
                InstanceFleet: {
                    TargetOnDemandCapacity: this.props.targetOnDemandCapacity,
                    TargetSpotCapacity: this.props.targetSpotCapacity,
                },
            }),
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
EmrModifyInstanceFleetByName[_a] = { fqn: "aws-cdk-lib.aws_stepfunctions_tasks.EmrModifyInstanceFleetByName", version: "2.74.0" };
exports.EmrModifyInstanceFleetByName = EmrModifyInstanceFleetByName;
//# sourceMappingURL=data:application/json;base64,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