"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmrContainersCreateVirtualCluster = exports.EksClusterInput = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../../aws-iam");
const sfn = require("../../../aws-stepfunctions");
const core_1 = require("../../../core");
const task_utils_1 = require("../private/task-utils");
/**
 * Class for supported types of EMR Containers' Container Providers
 */
var ContainerProviderTypes;
(function (ContainerProviderTypes) {
    /**
     * Supported container provider type for a EKS Cluster
     */
    ContainerProviderTypes["EKS"] = "EKS";
})(ContainerProviderTypes || (ContainerProviderTypes = {}));
/**
 * Class that supports methods which return the EKS cluster name depending on input type.
 */
class EksClusterInput {
    /**
     * Specify an existing EKS Cluster as the name for this Cluster
     */
    static fromCluster(cluster) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_eks_ICluster(cluster);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromCluster);
            }
            throw error;
        }
        return new EksClusterInput(cluster.clusterName);
    }
    /**
     * Specify a Task Input as the name for this Cluster
     */
    static fromTaskInput(taskInput) {
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_stepfunctions_TaskInput(taskInput);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromTaskInput);
            }
            throw error;
        }
        return new EksClusterInput(taskInput.value);
    }
    /**
     * Initializes the clusterName
     *
     * @param clusterName The name of the EKS Cluster
     */
    constructor(clusterName) {
        this.clusterName = clusterName;
    }
}
_a = JSII_RTTI_SYMBOL_1;
EksClusterInput[_a] = { fqn: "aws-cdk-lib.aws_stepfunctions_tasks.EksClusterInput", version: "2.74.0" };
exports.EksClusterInput = EksClusterInput;
/**
 * Task that creates an EMR Containers virtual cluster from an EKS cluster
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-emr-eks.html
 */
class EmrContainersCreateVirtualCluster extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_stepfunctions_tasks_EmrContainersCreateVirtualClusterProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EmrContainersCreateVirtualCluster);
            }
            throw error;
        }
        this.integrationPattern = props.integrationPattern ?? sfn.IntegrationPattern.REQUEST_RESPONSE;
        (0, task_utils_1.validatePatternSupported)(this.integrationPattern, EmrContainersCreateVirtualCluster.SUPPORTED_INTEGRATION_PATTERNS);
        this.taskPolicies = this.createPolicyStatements();
    }
    /**
     * @internal
     */
    _renderTask() {
        return {
            Resource: (0, task_utils_1.integrationResourceArn)('emr-containers', 'createVirtualCluster', this.integrationPattern),
            Parameters: sfn.FieldUtils.renderObject({
                Name: this.props.virtualClusterName ?? sfn.JsonPath.stringAt('States.Format(\'{}/{}\', $$.Execution.Name, $$.State.Name)'),
                ContainerProvider: {
                    Id: this.props.eksCluster.clusterName,
                    Info: {
                        EksInfo: {
                            Namespace: this.props.eksNamespace ?? 'default',
                        },
                    },
                    Type: ContainerProviderTypes.EKS,
                },
                Tags: this.props.tags,
            }),
        };
    }
    ;
    createPolicyStatements() {
        return [
            new iam.PolicyStatement({
                resources: ['*'],
                actions: ['emr-containers:CreateVirtualCluster'],
            }),
            new iam.PolicyStatement({
                resources: [
                    core_1.Stack.of(this).formatArn({
                        service: 'iam',
                        region: '',
                        resource: 'role/aws-service-role/emr-containers.amazonaws.com',
                        resourceName: 'AWSServiceRoleForAmazonEMRContainers',
                    }),
                ],
                actions: ['iam:CreateServiceLinkedRole'],
                conditions: {
                    StringLike: { 'iam:AWSServiceName': 'emr-containers.amazonaws.com' },
                },
            }),
        ];
    }
}
_b = JSII_RTTI_SYMBOL_1;
EmrContainersCreateVirtualCluster[_b] = { fqn: "aws-cdk-lib.aws_stepfunctions_tasks.EmrContainersCreateVirtualCluster", version: "2.74.0" };
EmrContainersCreateVirtualCluster.SUPPORTED_INTEGRATION_PATTERNS = [
    sfn.IntegrationPattern.REQUEST_RESPONSE,
];
exports.EmrContainersCreateVirtualCluster = EmrContainersCreateVirtualCluster;
//# sourceMappingURL=data:application/json;base64,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