"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EvaluateExpression = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const iam = require("../../aws-iam");
const lambda = require("../../aws-lambda");
const sfn = require("../../aws-stepfunctions");
/**
 * A Step Functions Task to evaluate an expression
 *
 * OUTPUT: the output of this task is the evaluated expression.
 *
 */
class EvaluateExpression extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_stepfunctions_tasks_EvaluateExpressionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EvaluateExpression);
            }
            throw error;
        }
        this.evalFn = createEvalFn(this.props.runtime ?? lambda.Runtime.NODEJS_14_X, this);
        this.taskPolicies = [
            new iam.PolicyStatement({
                resources: this.evalFn.resourceArnsForGrantInvoke,
                actions: ['lambda:InvokeFunction'],
            }),
        ];
    }
    /**
     * @internal
     */
    _renderTask() {
        const matches = this.props.expression.match(/\$[.\[][.a-zA-Z[\]0-9-_]+/g);
        let expressionAttributeValues = {};
        if (matches) {
            expressionAttributeValues = matches.reduce((acc, m) => ({
                ...acc,
                [m]: sfn.JsonPath.stringAt(m), // It's okay to always use `stringAt` here
            }), {});
        }
        const parameters = {
            expression: this.props.expression,
            expressionAttributeValues,
        };
        return {
            Resource: this.evalFn.functionArn,
            Parameters: sfn.FieldUtils.renderObject(parameters),
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
EvaluateExpression[_a] = { fqn: "aws-cdk-lib.aws_stepfunctions_tasks.EvaluateExpression", version: "2.74.0" };
exports.EvaluateExpression = EvaluateExpression;
function createEvalFn(runtime, scope) {
    const lambdaPurpose = 'Eval';
    const nodeJsGuids = {
        [lambda.Runtime.NODEJS_18_X.name]: '078d40d3-fb4e-4d53-94a7-9c46fc11fe02',
        [lambda.Runtime.NODEJS_16_X.name]: '2a430b68-eb4b-4026-9232-ee39b71c1db8',
        [lambda.Runtime.NODEJS_14_X.name]: 'da2d1181-604e-4a45-8694-1a6abd7fe42d',
        [lambda.Runtime.NODEJS_12_X.name]: '2b81e383-aad2-44db-8aaf-b4809ae0e3b4',
        [lambda.Runtime.NODEJS_10_X.name]: 'a0d2ce44-871b-4e74-87a1-f5e63d7c3bdc',
    };
    switch (runtime.name) {
        case lambda.Runtime.NODEJS_18_X.name:
        case lambda.Runtime.NODEJS_16_X.name:
        case lambda.Runtime.NODEJS_14_X.name:
        case lambda.Runtime.NODEJS_12_X.name:
        case lambda.Runtime.NODEJS_10_X.name:
            const uuid = nodeJsGuids[runtime.name];
            if (uuid) {
                return new lambda.SingletonFunction(scope, 'EvalFunction', {
                    runtime,
                    uuid,
                    handler: 'index.handler',
                    lambdaPurpose,
                    code: lambda.Code.fromAsset(path.join(__dirname, 'eval-nodejs-handler'), {
                        exclude: ['*.ts'],
                    }),
                });
            }
            break;
    }
    throw new Error(`The runtime ${runtime.name} is currently not supported.`);
}
//# sourceMappingURL=data:application/json;base64,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