"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RunGlueJobTask = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../../aws-iam");
const sfn = require("../../../aws-stepfunctions");
const core_1 = require("../../../core");
const resource_arn_suffix_1 = require("../resource-arn-suffix");
/**
 * Invoke a Glue job as a Task
 *
 * OUTPUT: the output of this task is a JobRun structure, for details consult
 * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-runs.html#aws-glue-api-jobs-runs-JobRun
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-glue.html
 *
 * @deprecated use `GlueStartJobRun`
 */
class RunGlueJobTask {
    constructor(glueJobName, props = {}) {
        this.glueJobName = glueJobName;
        this.props = props;
        this.integrationPattern = props.integrationPattern || sfn.ServiceIntegrationPattern.FIRE_AND_FORGET;
        const supportedPatterns = [
            sfn.ServiceIntegrationPattern.FIRE_AND_FORGET,
            sfn.ServiceIntegrationPattern.SYNC,
        ];
        if (!supportedPatterns.includes(this.integrationPattern)) {
            throw new Error(`Invalid Service Integration Pattern: ${this.integrationPattern} is not supported to call Glue.`);
        }
    }
    bind(task) {
        const notificationProperty = this.props.notifyDelayAfter ? { NotifyDelayAfter: this.props.notifyDelayAfter.toMinutes() } : null;
        let iamActions;
        if (this.integrationPattern === sfn.ServiceIntegrationPattern.FIRE_AND_FORGET) {
            iamActions = ['glue:StartJobRun'];
        }
        else if (this.integrationPattern === sfn.ServiceIntegrationPattern.SYNC) {
            iamActions = [
                'glue:StartJobRun',
                'glue:GetJobRun',
                'glue:GetJobRuns',
                'glue:BatchStopJobRun',
            ];
        }
        return {
            resourceArn: (0, resource_arn_suffix_1.getResourceArn)('glue', 'startJobRun', this.integrationPattern),
            policyStatements: [new iam.PolicyStatement({
                    resources: [
                        core_1.Stack.of(task).formatArn({
                            service: 'glue',
                            resource: 'job',
                            resourceName: this.glueJobName,
                        }),
                    ],
                    actions: iamActions,
                })],
            metricPrefixSingular: 'GlueJob',
            metricPrefixPlural: 'GlueJobs',
            metricDimensions: { GlueJobName: this.glueJobName },
            parameters: {
                JobName: this.glueJobName,
                Arguments: this.props.arguments,
                Timeout: this.props.timeout?.toMinutes(),
                SecurityConfiguration: this.props.securityConfiguration,
                NotificationProperty: notificationProperty,
            },
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
RunGlueJobTask[_a] = { fqn: "aws-cdk-lib.aws_stepfunctions_tasks.RunGlueJobTask", version: "2.74.0" };
exports.RunGlueJobTask = RunGlueJobTask;
//# sourceMappingURL=data:application/json;base64,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