"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlueStartJobRun = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../../aws-iam");
const sfn = require("../../../aws-stepfunctions");
const core_1 = require("../../../core");
const task_utils_1 = require("../private/task-utils");
/**
 * Starts an AWS Glue job in a Task state
 *
 * OUTPUT: the output of this task is a JobRun structure, for details consult
 * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-runs.html#aws-glue-api-jobs-runs-JobRun
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-glue.html
 */
class GlueStartJobRun extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_stepfunctions_tasks_GlueStartJobRunProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, GlueStartJobRun);
            }
            throw error;
        }
        this.integrationPattern = props.integrationPattern ?? sfn.IntegrationPattern.REQUEST_RESPONSE;
        (0, task_utils_1.validatePatternSupported)(this.integrationPattern, GlueStartJobRun.SUPPORTED_INTEGRATION_PATTERNS);
        this.taskPolicies = this.getPolicies();
        this.taskMetrics = {
            metricPrefixSingular: 'GlueJob',
            metricPrefixPlural: 'GlueJobs',
            metricDimensions: { GlueJobName: this.props.glueJobName },
        };
    }
    /**
     * @internal
     */
    _renderTask() {
        const notificationProperty = this.props.notifyDelayAfter ? { NotifyDelayAfter: this.props.notifyDelayAfter.toMinutes() } : null;
        let timeout = undefined;
        if (this.props.timeout) {
            timeout = this.props.timeout.toMinutes();
        }
        else if (this.props.taskTimeout?.seconds) {
            timeout = core_1.Duration.seconds(this.props.taskTimeout.seconds).toMinutes();
        }
        else if (this.props.taskTimeout?.path) {
            timeout = sfn.JsonPath.numberAt(this.props.taskTimeout.path);
        }
        return {
            Resource: (0, task_utils_1.integrationResourceArn)('glue', 'startJobRun', this.integrationPattern),
            Parameters: sfn.FieldUtils.renderObject({
                JobName: this.props.glueJobName,
                Arguments: this.props.arguments?.value,
                Timeout: timeout,
                SecurityConfiguration: this.props.securityConfiguration,
                NotificationProperty: notificationProperty,
            }),
            TimeoutSeconds: undefined,
            TimeoutSecondsPath: undefined,
        };
    }
    getPolicies() {
        let iamActions;
        if (this.integrationPattern === sfn.IntegrationPattern.REQUEST_RESPONSE) {
            iamActions = ['glue:StartJobRun'];
        }
        else if (this.integrationPattern === sfn.IntegrationPattern.RUN_JOB) {
            iamActions = [
                'glue:StartJobRun',
                'glue:GetJobRun',
                'glue:GetJobRuns',
                'glue:BatchStopJobRun',
            ];
        }
        return [new iam.PolicyStatement({
                resources: [
                    core_1.Stack.of(this).formatArn({
                        service: 'glue',
                        resource: 'job',
                        resourceName: this.props.glueJobName,
                    }),
                ],
                actions: iamActions,
            })];
    }
}
_a = JSII_RTTI_SYMBOL_1;
GlueStartJobRun[_a] = { fqn: "aws-cdk-lib.aws_stepfunctions_tasks.GlueStartJobRun", version: "2.74.0" };
GlueStartJobRun.SUPPORTED_INTEGRATION_PATTERNS = [
    sfn.IntegrationPattern.REQUEST_RESPONSE,
    sfn.IntegrationPattern.RUN_JOB,
];
exports.GlueStartJobRun = GlueStartJobRun;
//# sourceMappingURL=data:application/json;base64,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