"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvokeActivity = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * A Step Functions Task to invoke an Activity worker.
 *
 * An Activity can be used directly as a Resource.
 *
 * @deprecated use `StepFunctionsInvokeActivity`
 */
class InvokeActivity {
    constructor(activity, props = {}) {
        this.activity = activity;
        this.props = props;
    }
    bind(_task) {
        return {
            resourceArn: this.activity.activityArn,
            metricDimensions: { ActivityArn: this.activity.activityArn },
            heartbeat: this.props.heartbeat,
            // No IAM permissions necessary, execution role implicitly has Activity permissions.
            metricPrefixSingular: 'Activity',
            metricPrefixPlural: 'Activities',
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
InvokeActivity[_a] = { fqn: "aws-cdk-lib.aws_stepfunctions_tasks.InvokeActivity", version: "2.74.0" };
exports.InvokeActivity = InvokeActivity;
//# sourceMappingURL=data:application/json;base64,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