"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvokeFunction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../../aws-iam");
/**
 * A Step Functions Task to invoke a Lambda function.
 *
 * The Lambda function Arn is defined as Resource in the state machine definition.
 *
 * OUTPUT: the output of this task is the return value of the Lambda Function.
 *
 * @deprecated Use `LambdaInvoke`
 */
class InvokeFunction {
    constructor(lambdaFunction, props = {}) {
        this.lambdaFunction = lambdaFunction;
        this.props = props;
    }
    bind(_task) {
        return {
            resourceArn: this.lambdaFunction.functionArn,
            policyStatements: [new iam.PolicyStatement({
                    resources: this.lambdaFunction.resourceArnsForGrantInvoke,
                    actions: ['lambda:InvokeFunction'],
                })],
            metricPrefixSingular: 'LambdaFunction',
            metricPrefixPlural: 'LambdaFunctions',
            metricDimensions: { LambdaFunctionArn: this.lambdaFunction.functionArn },
            parameters: this.props.payload,
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
InvokeFunction[_a] = { fqn: "aws-cdk-lib.aws_stepfunctions_tasks.InvokeFunction", version: "2.74.0" };
exports.InvokeFunction = InvokeFunction;
//# sourceMappingURL=data:application/json;base64,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