"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SqsSendMessage = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../../aws-iam");
const sfn = require("../../../aws-stepfunctions");
const task_utils_1 = require("../private/task-utils");
/**
 * A StepFunctions Task to send messages to SQS queue.
 *
 */
class SqsSendMessage extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_stepfunctions_tasks_SqsSendMessageProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SqsSendMessage);
            }
            throw error;
        }
        this.integrationPattern = props.integrationPattern ?? sfn.IntegrationPattern.REQUEST_RESPONSE;
        (0, task_utils_1.validatePatternSupported)(this.integrationPattern, SqsSendMessage.SUPPORTED_INTEGRATION_PATTERNS);
        if (props.integrationPattern === sfn.IntegrationPattern.WAIT_FOR_TASK_TOKEN) {
            if (!sfn.FieldUtils.containsTaskToken(props.messageBody)) {
                throw new Error('Task Token is required in `messageBody` Use JsonPath.taskToken to set the token.');
            }
        }
        this.taskPolicies = [
            new iam.PolicyStatement({
                actions: ['sqs:SendMessage'],
                resources: [this.props.queue.queueArn],
            }),
        ];
        // sending to an encrypted queue requires
        // permissions on the associated kms key
        if (this.props.queue.encryptionMasterKey) {
            this.taskPolicies.push(new iam.PolicyStatement({
                actions: ['kms:Decrypt', 'kms:GenerateDataKey*'],
                resources: [this.props.queue.encryptionMasterKey.keyArn],
            }));
        }
    }
    /**
     * Provides the SQS SendMessage service integration task configuration
     */
    /**
     * @internal
     */
    _renderTask() {
        return {
            Resource: (0, task_utils_1.integrationResourceArn)('sqs', 'sendMessage', this.integrationPattern),
            Parameters: sfn.FieldUtils.renderObject({
                QueueUrl: this.props.queue.queueUrl,
                MessageBody: this.props.messageBody.value,
                DelaySeconds: this.props.delay?.toSeconds(),
                MessageDeduplicationId: this.props.messageDeduplicationId,
                MessageGroupId: this.props.messageGroupId,
            }),
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
SqsSendMessage[_a] = { fqn: "aws-cdk-lib.aws_stepfunctions_tasks.SqsSendMessage", version: "2.74.0" };
SqsSendMessage.SUPPORTED_INTEGRATION_PATTERNS = [
    sfn.IntegrationPattern.REQUEST_RESPONSE,
    sfn.IntegrationPattern.WAIT_FOR_TASK_TOKEN,
];
exports.SqsSendMessage = SqsSendMessage;
//# sourceMappingURL=data:application/json;base64,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