"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SendToQueue = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../../aws-iam");
const sfn = require("../../../aws-stepfunctions");
const resource_arn_suffix_1 = require("../resource-arn-suffix");
/**
 * A StepFunctions Task to send messages to SQS queue.
 *
 * A Function can be used directly as a Resource, but this class mirrors
 * integration with other AWS services via a specific class instance.
 *
 * @deprecated Use `SqsSendMessage`
 */
class SendToQueue {
    constructor(queue, props) {
        this.queue = queue;
        this.props = props;
        this.integrationPattern = props.integrationPattern || sfn.ServiceIntegrationPattern.FIRE_AND_FORGET;
        const supportedPatterns = [
            sfn.ServiceIntegrationPattern.FIRE_AND_FORGET,
            sfn.ServiceIntegrationPattern.WAIT_FOR_TASK_TOKEN,
        ];
        if (!supportedPatterns.includes(this.integrationPattern)) {
            throw new Error(`Invalid Service Integration Pattern: ${this.integrationPattern} is not supported to call SQS.`);
        }
        if (props.integrationPattern === sfn.ServiceIntegrationPattern.WAIT_FOR_TASK_TOKEN) {
            if (!sfn.FieldUtils.containsTaskToken(props.messageBody)) {
                throw new Error('Task Token is missing in messageBody (pass JsonPath.taskToken somewhere in messageBody)');
            }
        }
    }
    bind(_task) {
        return {
            resourceArn: (0, resource_arn_suffix_1.getResourceArn)('sqs', 'sendMessage', this.integrationPattern),
            policyStatements: [new iam.PolicyStatement({
                    actions: ['sqs:SendMessage'],
                    resources: [this.queue.queueArn],
                })],
            parameters: {
                QueueUrl: this.queue.queueUrl,
                MessageBody: this.props.messageBody.value,
                DelaySeconds: this.props.delay && this.props.delay.toSeconds(),
                MessageDeduplicationId: this.props.messageDeduplicationId,
                MessageGroupId: this.props.messageGroupId,
            },
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
SendToQueue[_a] = { fqn: "aws-cdk-lib.aws_stepfunctions_tasks.SendToQueue", version: "2.74.0" };
exports.SendToQueue = SendToQueue;
//# sourceMappingURL=data:application/json;base64,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