"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StepFunctionsInvokeActivity = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const sfn = require("../../../aws-stepfunctions");
/**
 * A Step Functions Task to invoke an Activity worker.
 *
 * An Activity can be used directly as a Resource.
 */
class StepFunctionsInvokeActivity extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_stepfunctions_tasks_StepFunctionsInvokeActivityProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, StepFunctionsInvokeActivity);
            }
            throw error;
        }
        this.taskMetrics = {
            metricDimensions: { ActivityArn: this.props.activity.activityArn },
            metricPrefixSingular: 'Activity',
            metricPrefixPlural: 'Activities',
        };
    }
    /**
     * @internal
     */
    _renderTask() {
        return {
            Resource: this.props.activity.activityArn,
            Parameters: this.props.parameters ? sfn.FieldUtils.renderObject(this.props.parameters) : undefined,
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
StepFunctionsInvokeActivity[_a] = { fqn: "aws-cdk-lib.aws_stepfunctions_tasks.StepFunctionsInvokeActivity", version: "2.74.0" };
exports.StepFunctionsInvokeActivity = StepFunctionsInvokeActivity;
//# sourceMappingURL=data:application/json;base64,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