"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InputType = exports.TaskInput = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fields_1 = require("./fields");
/**
 * Type union for task classes that accept multiple types of payload
 */
class TaskInput {
    /**
     * Use a literal string as task input
     *
     * This might be a JSON-encoded object, or just a text.
     */
    static fromText(text) {
        return new TaskInput(InputType.TEXT, text);
    }
    /**
     * Use an object as task input
     *
     * This object may contain JSON path fields as object values, if desired.
     */
    static fromObject(obj) {
        return new TaskInput(InputType.OBJECT, obj);
    }
    /**
     * Use a part of the execution data or task context as task input
     *
     * Use this when you want to use a subobject or string from
     * the current state machine execution or the current task context
     * as complete payload to a task.
     */
    static fromJsonPathAt(path) {
        return new TaskInput(InputType.TEXT, fields_1.JsonPath.stringAt(path));
    }
    /**
     * Use a part of the execution data as task input
     *
     * Use this when you want to use a subobject or string from
     * the current state machine execution as complete payload
     * to a task.
     *
     * @deprecated Use `fromJsonPathAt`.
     */
    static fromDataAt(path) {
        return new TaskInput(InputType.TEXT, fields_1.JsonPath.stringAt(path));
    }
    /**
     * Use a part of the task context as task input
     *
     * Use this when you want to use a subobject or string from
     * the current task context as complete payload
     * to a task.
     *
     * @deprecated Use `fromJsonPathAt`.
     */
    static fromContextAt(path) {
        return new TaskInput(InputType.TEXT, fields_1.JsonPath.stringAt(path));
    }
    /**
     *
     * @param type type of task input
     * @param value payload for the corresponding input type.
     * It can be a JSON-encoded object, context, data, etc.
     */
    constructor(type, value) {
        this.type = type;
        this.value = value;
    }
}
_a = JSII_RTTI_SYMBOL_1;
TaskInput[_a] = { fqn: "aws-cdk-lib.aws_stepfunctions.TaskInput", version: "2.74.0" };
exports.TaskInput = TaskInput;
/**
 * The type of task input
 */
var InputType;
(function (InputType) {
    /**
     * Use a literal string
     * This might be a JSON-encoded object, or just text.
     * valid JSON text: standalone, quote-delimited strings; objects; arrays; numbers; Boolean values; and null.
     *
     * example: `literal string`
     * example: {"json": "encoded"}
     */
    InputType[InputType["TEXT"] = 0] = "TEXT";
    /**
     * Use an object which may contain Data and Context fields
     * as object values, if desired.
     *
     * example:
     * {
     *  literal: 'literal',
     *  SomeInput: sfn.JsonPath.stringAt('$.someField')
     * }
     *
     * @see https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-data.html
     * @see https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html
     */
    InputType[InputType["OBJECT"] = 1] = "OBJECT";
})(InputType = exports.InputType || (exports.InputType = {}));
//# sourceMappingURL=data:application/json;base64,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