"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Fail = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const state_type_1 = require("./private/state-type");
const state_1 = require("./state");
/**
 * Define a Fail state in the state machine
 *
 * Reaching a Fail state terminates the state execution in failure.
 */
class Fail extends state_1.State {
    constructor(scope, id, props = {}) {
        super(scope, id, props);
        this.endStates = [];
        try {
            jsiiDeprecationWarnings.aws_cdk_lib_aws_stepfunctions_FailProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Fail);
            }
            throw error;
        }
        this.error = props.error;
        this.cause = props.cause;
    }
    /**
     * Return the Amazon States Language object for this state
     */
    toStateJson() {
        return {
            Type: state_type_1.StateType.FAIL,
            Comment: this.comment,
            Error: this.error,
            Cause: this.cause,
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
Fail[_a] = { fqn: "aws-cdk-lib.aws_stepfunctions.Fail", version: "2.74.0" };
exports.Fail = Fail;
//# sourceMappingURL=data:application/json;base64,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