"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoadBalancerListenerProtocol = exports.LoadBalancerType = exports.ContextProvider = void 0;
/**
 * Identifier for the context provider
 */
var ContextProvider;
(function (ContextProvider) {
    /**
     * AMI provider
     */
    ContextProvider["AMI_PROVIDER"] = "ami";
    /**
     * AZ provider
     */
    ContextProvider["AVAILABILITY_ZONE_PROVIDER"] = "availability-zones";
    /**
     * Route53 Hosted Zone provider
     */
    ContextProvider["HOSTED_ZONE_PROVIDER"] = "hosted-zone";
    /**
     * SSM Parameter Provider
     */
    ContextProvider["SSM_PARAMETER_PROVIDER"] = "ssm";
    /**
     * VPC Provider
     */
    ContextProvider["VPC_PROVIDER"] = "vpc-provider";
    /**
     * VPC Endpoint Service AZ Provider
     */
    ContextProvider["ENDPOINT_SERVICE_AVAILABILITY_ZONE_PROVIDER"] = "endpoint-service-availability-zones";
    /**
     * Load balancer provider
     */
    ContextProvider["LOAD_BALANCER_PROVIDER"] = "load-balancer";
    /**
     * Load balancer listener provider
     */
    ContextProvider["LOAD_BALANCER_LISTENER_PROVIDER"] = "load-balancer-listener";
    /**
     * Security group provider
     */
    ContextProvider["SECURITY_GROUP_PROVIDER"] = "security-group";
    /**
     * KMS Key Provider
     */
    ContextProvider["KEY_PROVIDER"] = "key-provider";
    /**
     * A plugin provider (the actual plugin name will be in the properties)
     */
    ContextProvider["PLUGIN"] = "plugin";
})(ContextProvider = exports.ContextProvider || (exports.ContextProvider = {}));
/**
 * Type of load balancer
 */
var LoadBalancerType;
(function (LoadBalancerType) {
    /**
     * Network load balancer
     */
    LoadBalancerType["NETWORK"] = "network";
    /**
     * Application load balancer
     */
    LoadBalancerType["APPLICATION"] = "application";
})(LoadBalancerType = exports.LoadBalancerType || (exports.LoadBalancerType = {}));
/**
 * The protocol for connections from clients to the load balancer
 */
var LoadBalancerListenerProtocol;
(function (LoadBalancerListenerProtocol) {
    /**
     * HTTP protocol
     */
    LoadBalancerListenerProtocol["HTTP"] = "HTTP";
    /**
     * HTTPS protocol
     */
    LoadBalancerListenerProtocol["HTTPS"] = "HTTPS";
    /**
     * TCP protocol
     */
    LoadBalancerListenerProtocol["TCP"] = "TCP";
    /**
     * TLS protocol
     */
    LoadBalancerListenerProtocol["TLS"] = "TLS";
    /**
     * UDP protocol
     * */
    LoadBalancerListenerProtocol["UDP"] = "UDP";
    /**
     * TCP and UDP protocol
     * */
    LoadBalancerListenerProtocol["TCP_UDP"] = "TCP_UDP";
})(LoadBalancerListenerProtocol = exports.LoadBalancerListenerProtocol || (exports.LoadBalancerListenerProtocol = {}));
//# sourceMappingURL=data:application/json;base64,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