"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ArtifactMetadataEntryType = void 0;
/**
 * Type of artifact metadata entry.
 */
var ArtifactMetadataEntryType;
(function (ArtifactMetadataEntryType) {
    /**
     * Asset in metadata.
     */
    ArtifactMetadataEntryType["ASSET"] = "aws:cdk:asset";
    /**
     * Metadata key used to print INFO-level messages by the toolkit when an app is syntheized.
     */
    ArtifactMetadataEntryType["INFO"] = "aws:cdk:info";
    /**
     * Metadata key used to print WARNING-level messages by the toolkit when an app is syntheized.
     */
    ArtifactMetadataEntryType["WARN"] = "aws:cdk:warning";
    /**
     * Metadata key used to print ERROR-level messages by the toolkit when an app is syntheized.
     */
    ArtifactMetadataEntryType["ERROR"] = "aws:cdk:error";
    /**
     * Represents the CloudFormation logical ID of a resource at a certain path.
     */
    ArtifactMetadataEntryType["LOGICAL_ID"] = "aws:cdk:logicalId";
    /**
     * Represents tags of a stack.
     */
    ArtifactMetadataEntryType["STACK_TAGS"] = "aws:cdk:stack-tags";
})(ArtifactMetadataEntryType = exports.ArtifactMetadataEntryType || (exports.ArtifactMetadataEntryType = {}));
//# sourceMappingURL=data:application/json;base64,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